/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import translator.AppPreferences;
import translator.License;
import translator.MainClass;
import translator.MainView;
import translator.ResourceView;
import translator.ui.UITools;
import translator.ui.kodo.KodoProgressBarUI;
import translator.web.Proz;

public final class AboutDialog
extends JDialog {
    private MainView parent;
    private JLabel label2;
    private JLabel label4;
    private JLabel label6;
    private JLabel label8;
    private JLabel label10;

    AboutDialog(MainView parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AboutDialog(MainView parent) {
        this.parent = parent;
    }

    private void jbInit() throws Exception {
        JLabel label = new JLabel();
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setPreferredSize(new Dimension(400, 50));
        float fsize = 18.0f;
        float ffsize = 16.0f;
        label.setIcon(new ImageIcon(AppPreferences.iconsPath + AppPreferences.iconsSize + AppPreferences.fs + "CT32.png"));
        label.setFont(label.getFont().deriveFont(fsize));
        label.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CAFETRAN PRODUCT INFORMATION"));
        JPanel panel1 = new JPanel();
        panel1.setBorder(BorderFactory.createEmptyBorder(5, 50, 5, 5));
        panel1.setLayout(new SpringLayout());
        Font ffont = label.getFont().deriveFont(0, ffsize);
        Font font = label.getFont().deriveFont(ffsize);
        JLabel label1 = new JLabel();
        label1.setFont(font);
        label1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRODUCT VERSION:"));
        this.label2 = new JLabel();
        this.label2.setText(AppPreferences.productName + " " + AppPreferences.productVersion);
        this.label2.setFont(ffont);
        panel1.add(label1);
        panel1.add(this.label2);
        JLabel label3 = new JLabel();
        label3.setFont(font);
        label3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPERATING SYSTEM:"));
        this.label4 = new JLabel();
        String sys = System.getProperty("os.name") + " version " + System.getProperty("os.version");
        this.label4.setText(sys);
        this.label4.setFont(ffont);
        panel1.add(label3);
        panel1.add(this.label4);
        JLabel label5 = new JLabel();
        label5.setFont(font);
        String jv = AppPreferences.jversion + " " + System.getProperty("java.vm.name");
        String arch = System.getProperty("os.arch");
        if (arch != null) {
            jv = jv + " on " + arch;
        }
        label5.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JAVA VERSION:"));
        this.label6 = new JLabel();
        this.label6.setText(jv);
        this.label6.setFont(ffont);
        panel1.add(label5);
        panel1.add(this.label6);
        JLabel labelJM = new JLabel();
        labelJM.setFont(font);
        labelJM.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JAVA MEMORY SIZE:"));
        JProgressBar progressBar = new JProgressBar();
        Color c = new Color(AppPreferences.iconsColor).darker();
        progressBar.setForeground(c);
        progressBar.setBorder(BorderFactory.createEmptyBorder());
        progressBar.setUI(new KodoProgressBarUI());
        progressBar.setStringPainted(true);
        long[] marr = MainClass.getJavaHeapSize();
        int max = (int)marr[0];
        int used = (int)marr[1];
        String s = "Used " + used + " out of " + max + " MB";
        progressBar.setMinimum(0);
        progressBar.setMaximum(max);
        progressBar.setValue(used);
        progressBar.setString(s);
        panel1.add(labelJM);
        panel1.add(progressBar);
        JLabel label7 = new JLabel();
        label7.setFont(font);
        label7.setText("System ID:");
        this.label8 = new JLabel();
        this.label8.setText(AppPreferences.systemID);
        this.label8.setFont(ffont);
        panel1.add(label7);
        panel1.add(this.label8);
        JLabel label9 = new JLabel();
        label9.setFont(font);
        label9.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LICENSE:"));
        this.label10 = new JLabel();
        if (AppPreferences.isTrialVersion) {
            this.label10.setText("Trial version");
        } else {
            this.label10.setText("Full version" + (AppPreferences.lastLicenseCheckResult.equals("grace") ? " (expiration grace period until " + License.getGracePeriodEnd() + ")" : ""));
        }
        this.label10.setFont(ffont);
        panel1.add(label9);
        panel1.add(this.label10);
        int numRows = 9;
        if (!AppPreferences.isTrialVersion) {
            if (Proz.benefitCTE) {
                ++numRows;
                JLabel label40 = new JLabel();
                label40.setFont(font);
                label40.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LICENSED TO:"));
                JLabel label41 = new JLabel();
                label41.setFont(ffont);
                if (AppPreferences.prozPremiumMember) {
                    label41.setText("ProZ.com Premium Member");
                } else if (AppPreferences.prozPlusMember) {
                    label41.setText("ProZ.com Plus Member");
                } else if (AppPreferences.prozStandardMember) {
                    label41.setText("ProZ.com Standard Member");
                } else if (AppPreferences.prozRegisteredMember) {
                    label41.setText("ProZ.com Registered User");
                }
                panel1.add(label40);
                panel1.add(label41);
            } else {
                Date licenseNotAfter;
                String licenseHolder = License.getHolder();
                if (!licenseHolder.isEmpty()) {
                    ++numRows;
                    JLabel label40 = new JLabel();
                    label40.setFont(font);
                    label40.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LICENSED TO:"));
                    JLabel label41 = new JLabel();
                    label41.setFont(ffont);
                    label41.setText(licenseHolder);
                    panel1.add(label40);
                    panel1.add(label41);
                }
                if (!(licenseNotAfter = License.getNotAfter()).toString().isEmpty()) {
                    ++numRows;
                    JLabel label50 = new JLabel();
                    label50.setFont(font);
                    JLabel label51 = new JLabel();
                    label51.setFont(ffont);
                    if (License.isPerpetual()) {
                        label50.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LICENSE TERM:"));
                        label51.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PERPETUAL"));
                    } else {
                        label50.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LICENSED THROUGH:"));
                        label51.setText(licenseNotAfter.toString());
                    }
                    panel1.add(label50);
                    panel1.add(label51);
                }
            }
        }
        JLabel label15 = new JLabel();
        label15.setFont(font);
        label15.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HOME:"));
        JLabel label16 = new JLabel();
        label16.setText(AppPreferences.website_url);
        label16.setFont(ffont);
        panel1.add(label15);
        panel1.add(label16);
        JLabel label13 = new JLabel();
        label13.setFont(font);
        label13.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ICONS:"));
        JLabel label14 = new JLabel();
        label14.setText("http://www.fatcow.com/free-icons");
        label14.setFont(ffont);
        panel1.add(label13);
        panel1.add(label14);
        JLabel label11 = new JLabel();
        label11.setFont(font);
        label11.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("COPYRIGHT:"));
        JLabel label12 = new JLabel();
        label12.setText("\u00a9 2005-2025 by Collaborative Translation Networks, LLC.");
        label12.setFont(ffont);
        panel1.add(label11);
        panel1.add(label12);
        UITools.makeCompactGrid(panel1, numRows, 2, 0, 0, 10, 5);
        JButton jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("COPY SYSTEMID"));
        JButton jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE"));
        jb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.parent.getResourceView().copySystemIDToClipboard(AboutDialog.this.label8.getText());
                JOptionPane.showMessageDialog(AboutDialog.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM ID COPIED TO CLIPBOARD"));
            }
        });
        jb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.cancel();
            }
        });
        JButton jb3 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALL UPDATE"));
        jb3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.cancel();
                AboutDialog.this.installUpdate();
            }
        });
        JButton jb4 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT" + (!AppPreferences.isTrialVersion ? " NEW" : "") + " LICENSE FILE"));
        jb4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                License.showLicenseFileImportWizard(AboutDialog.this);
            }
        });
        String buttonLabel = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PURCHASE LICENSE");
        JButton jb5 = new JButton(buttonLabel);
        if (!AppPreferences.lastLicenseCheckResult.equals("full")) {
            jb5.setFont(jb5.getFont().deriveFont(1));
        }
        jb5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = !AppPreferences.isTrialVersion && !License.isPerpetual() ? new URI(AppPreferences.account_url) : new URI(AppPreferences.purchase_url);
                    AboutDialog.this.parent.getResourceView();
                    ResourceView.browse(uri);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JPanel panel2 = new JPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel2.setLayout(new FlowLayout(1));
        panel2.setOpaque(false);
        panel2.add(jb3);
        panel2.add(jb1);
        panel2.add(jb5);
        panel2.add(jb4);
        panel2.add(jb2);
        JPanel panel3 = (JPanel)this.getContentPane();
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)label, "North");
        panel3.add((Component)panel1, "Center");
        panel3.add((Component)panel2, "South");
        this.setResizable(false);
        panel3.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.cancel();
            }
        });
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
    }

    private void installUpdate() {
        this.parent.requestFocus();
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALL UPDATE"));
                    final File file = fileChooser.showOpenDialog(null);
                    if (file != null) {
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                if (file.getName().endsWith("update.zip") || file.getName().endsWith("update.jar")) {
                                    this.this$1.AboutDialog.this.installZip(file);
                                } else if (file.getName().endsWith(".jar")) {
                                    this.this$1.AboutDialog.this.installJar(file);
                                }
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALL UPDATE"));
            if (0 == jFileChooser.showOpenDialog(this.parent)) {
                File file = jFileChooser.getSelectedFile();
                if (file.getName().endsWith("update.zip") || file.getName().endsWith("update.jar")) {
                    this.installZip(file);
                } else if (file.getName().endsWith(".jar")) {
                    this.installJar(file);
                }
            }
        }
    }

    public void installJar(File file) {
        block5: {
            if (AppPreferences.isTrialVersion) {
                JOptionPane.showMessageDialog(this.parent, "Free updates are for the unlimited version only!");
                return;
            }
            File iconsDir = new File(AppPreferences.packagePath + "/graphics/icons/16");
            if (!iconsDir.exists()) {
                iconsDir.mkdir();
                new File(AppPreferences.packagePath + "/graphics/icons/32").mkdir();
            }
            if (!(iconsDir = new File(AppPreferences.packagePath + "/graphics/icons/16-monochromatic")).exists()) {
                iconsDir.mkdir();
                new File(AppPreferences.packagePath + "/graphics/icons/32-monochromatic").mkdir();
            }
            try {
                String srcFileName = file.getName();
                String dst = srcFileName.startsWith("mysql-connector-j") || srcFileName.startsWith("mariadb-java-client") ? AppPreferences.packagePath + "/lib/mysql.jar" : AppPreferences.packagePath + srcFileName;
                FileChannel srcChannel = new FileInputStream(file.getPath()).getChannel();
                FileChannel dstChannel = new FileOutputStream(dst).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALLATION COMPLETED. PLEASE RESTART CAFETRAN."));
            }
            catch (IOException e) {
                String m = e.getMessage();
                if (m == null) break block5;
                JOptionPane.showMessageDialog(this.parent, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
            }
        }
    }

    public void installZip(File file) {
        if (AppPreferences.isTrialVersion) {
            JOptionPane.showMessageDialog(this.parent, "Free updates are for the unlimited version only!");
            return;
        }
        File iconsDir = new File(AppPreferences.packagePath + "/graphics/icons/16");
        if (!iconsDir.exists()) {
            iconsDir.mkdir();
            new File(AppPreferences.packagePath + "/graphics/icons/32").mkdir();
        }
        if (!(iconsDir = new File(AppPreferences.packagePath + "/graphics/icons/16-monochromatic")).exists()) {
            iconsDir.mkdir();
            new File(AppPreferences.packagePath + "/graphics/icons/32-monochromatic").mkdir();
        }
        String dirPath = AppPreferences.packagePath;
        boolean extract = true;
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                int fs = entryName.indexOf(AppPreferences.fs);
                if (fs == -1 && AppPreferences.fs.equals("/")) {
                    entryName = entryName.replace('\\', '/');
                }
                if ((fs = entryName.indexOf(47)) != -1) {
                    entryName = entryName.substring(fs + 1);
                }
                if (entry.isDirectory() || !extract) continue;
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(dirPath + entryName);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            zipFile.close();
            JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALLATION COMPLETED. PLEASE RESTART CAFETRAN."));
        }
        catch (IOException ioe) {
            String m = ioe.getMessage();
            if (m != null) {
                JOptionPane.showMessageDialog(this.parent, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
            }
            ioe.printStackTrace();
        }
    }

    public static void installJavaRuntime(File file) throws IOException {
        Path targetDir = Paths.get(AppPreferences.packagePath, new String[0]);
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zipIn = new ZipInputStream(bis);){
            ZipEntry ze;
            while ((ze = zipIn.getNextEntry()) != null) {
                Path resolvedPath = targetDir.resolve(ze.getName());
                if (ze.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                Files.copy(zipIn, resolvedPath, new CopyOption[0]);
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }
}

