/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Currency;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.MainView;
import translator.ui.GridPanel;

final class BillingChooser
extends JDialog
implements ActionListener {
    private JComboBox unitbox;
    private JComboBox currbox;
    private JTextField jTextField0 = null;
    private JTextField jTextField1 = null;
    private JTextField field = null;
    private JButton jb1;
    private JButton jb2;
    private MainView parent;

    BillingChooser(MainView parent, JTextField field, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.field = field;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String currString;
        String[] sfields = AppPreferences.billing.split("\\s");
        String[] fields = new String[]{"0", ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORDS"), "0.0", "USD"};
        if (sfields != null && sfields.length == 4) {
            fields = sfields;
        }
        String[] unit = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORDS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHARACTERS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ALL CHARACTERS")};
        this.unitbox = new JComboBox<String>(unit);
        this.unitbox.setPreferredSize(new Dimension(120, 26));
        String s = fields[1];
        if (s != null) {
            if (s.equals("words")) {
                this.unitbox.setSelectedIndex(0);
            } else if (s.equals("characters")) {
                this.unitbox.setSelectedIndex(1);
            } else if (s.equals("x-characters")) {
                this.unitbox.setSelectedIndex(2);
            } else {
                this.unitbox.setSelectedIndex(0);
            }
        }
        String[] currency = new String[]{"USD", "EUR", "GBP"};
        Currency curr = Currency.getInstance(Locale.getDefault());
        if (!(curr == null || (currString = curr.getCurrencyCode()) == null || currString.equals(currency[0]) || currString.equals(currency[1]) || currString.equals(currency[2]))) {
            currency[2] = currString;
        }
        this.currbox = new JComboBox<String>(currency);
        this.currbox.setEditable(true);
        this.currbox.setPreferredSize(new Dimension(this.unitbox.getPreferredSize().width, this.unitbox.getPreferredSize().height));
        s = fields[3];
        if (s != null) {
            this.currbox.setSelectedItem(s);
        }
        this.jTextField0 = new JTextField();
        this.jTextField0.setPreferredSize(new Dimension(60, 26));
        this.jTextField0.setMargin(new Insets(0, 2, 0, 0));
        s = fields[0];
        if (s != null) {
            this.jTextField0.setText(s);
        }
        this.jTextField1 = new JTextField();
        this.jTextField1.setPreferredSize(new Dimension(60, 26));
        this.jTextField1.setMargin(new Insets(0, 2, 0, 0));
        s = fields[2];
        if (s != null) {
            this.jTextField1.setText(s);
        }
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        JLabel label = new JLabel(" = ");
        JPanel panel1 = new JPanel();
        panel1.setOpaque(false);
        panel1.setLayout(new FlowLayout());
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(2));
        panel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        panel2.setOpaque(false);
        GridPanel panel3 = new GridPanel();
        this.setContentPane(panel3);
        panel3.setBorder(new EmptyBorder(10, 10, 5, 10));
        panel3.setLayout(new BorderLayout());
        this.setResizable(false);
        panel1.add(this.jTextField0);
        panel1.add(this.unitbox);
        panel1.add(label);
        panel1.add(this.jTextField1);
        panel1.add(this.currbox);
        panel2.add(this.jb1);
        panel2.add(this.jb2);
        panel3.add((Component)panel1, "Center");
        panel3.add((Component)panel2, "South");
        panel3.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingChooser.this.jb1.doClick();
            }
        });
        panel3.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingChooser.this.jb2.doClick();
            }
        });
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            String number = this.jTextField0.getText().trim();
            int u = this.unitbox.getSelectedIndex();
            String unit = u == 0 ? "words" : (u == 1 ? "characters" : (u == 2 ? "x-characters" : "words"));
            String amount = this.jTextField1.getText().trim();
            String currency = (String)this.currbox.getSelectedItem();
            String b = number.trim().length() == 0 || number.equals("0") ? "" : number + " " + unit + " " + amount + " " + currency;
            if (this.field != null) {
                this.field.setText(b);
            } else {
                AppPreferences.billing = b;
            }
            this.cancel();
        }
    }
}

