/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import translator.AppPreferences;
import translator.ExternalEditor;
import translator.MainView;
import translator.MatchBoard;
import translator.Project;
import translator.ResourceView;
import translator.Workflow;
import translator.tmx.MemoryView;

public class ClipboardHandler
implements ClipboardOwner {
    private MainView topui;
    private boolean targetOut;
    private boolean stringOut;
    private boolean pause;

    ClipboardHandler(MainView topui) {
        this.topui = topui;
        if (AppPreferences.operatingSystem == 1) {
            this.setMacOSClipboardHander();
        }
    }

    public boolean isPaused() {
        return this.pause;
    }

    public void pause(boolean p) {
        this.pause = p;
    }

    private void setMacOSClipboardHander() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                final javafx.scene.input.Clipboard fxclipboard = javafx.scene.input.Clipboard.getSystemClipboard();
                Timeline repeatTask = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)500.0), (EventHandler)new EventHandler<ActionEvent>(){
                    private String oldString = "";
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handle(ActionEvent event) {
                        if (fxclipboard.hasString()) {
                            final String newString = fxclipboard.getString();
                            if (newString == null) {
                                return;
                            }
                            if (this.this$1.ClipboardHandler.this.pause) {
                                this.oldString = newString;
                                return;
                            }
                            if (this.this$1.ClipboardHandler.this.targetOut) {
                                this.this$1.ClipboardHandler.this.targetOut = false;
                                this.oldString = newString;
                                return;
                            }
                            if (this.oldString != null && !this.oldString.equals(newString)) {
                                this.oldString = newString;
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        this.this$2.this$1.ClipboardHandler.this.handleClipboardString(newString);
                                        this.this$2.this$1.ClipboardHandler.this.stringOut = false;
                                    }
                                });
                            }
                        }
                    }
                }, new KeyValue[0])});
                repeatTask.setCycleCount(-1);
                repeatTask.play();
            }
        });
    }

    public void setTargetOut(boolean out) {
        this.targetOut = out;
    }

    public void setStringOut(boolean out) {
        this.stringOut = out;
    }

    private void handleClipboardString(String imp) {
        int mode;
        ResourceView rv = this.topui.getResourceView();
        ++rv.clipboardCount;
        if (rv.reachedTrialVersionClipboardLimit()) {
            return;
        }
        if (imp == null || imp.trim().length() == 0) {
            return;
        }
        imp = this.stripNonValidXMLCharacters(imp);
        if (AppPreferences.clipboardReplaceNewline) {
            imp = this.stripNewLineCharacters(imp);
        }
        boolean clipflow = false;
        Workflow flow = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
        if (flow != null && (mode = flow.getMode()) == 1) {
            Project project = this.topui.getProjectView().getProject();
            int no = project.getCurrentUnitsNumber();
            boolean isSet = flow.setClipboardSource(imp);
            if (isSet) {
                clipflow = true;
                MatchBoard mb = this.topui.getMatchBoard();
                if (mb != null) {
                    mb.clearMatchBoard();
                }
                this.topui.toFront();
                this.topui.requestFocusInWindow();
                if (no > 0) {
                    String t = "#" + Integer.toString(no);
                    project.edit(t, no);
                    project.setExportStartTU(no);
                } else {
                    project.setExportStartTU(0);
                    this.topui.getWorkflowView().next(0);
                }
                this.topui.getTargetPane().setCaretPosition(0);
                this.topui.setPauseButtonColor(new Color(AppPreferences.iconsColor));
            }
        }
        if (!clipflow && !this.stringOut) {
            ExternalEditor ee = this.topui.getTargetView().getExternalEditor();
            if (AppPreferences.bindExternalEditor && ee != null && ee.isClipboardTransfer()) {
                ee.setClipboardTargetSegment(imp);
            } else if (AppPreferences.clipboard && AppPreferences.clipboardTarget == 0) {
                this.topui.getResourceView().getLookUpBox().setSelectedItem(imp);
                this.topui.getResourceView().searchDefaulScope();
                this.topui.getResourceView().addToClipboardHistory(imp);
            } else if (AppPreferences.clipboard && AppPreferences.clipboardTarget == 2) {
                this.topui.toFront();
                this.topui.requestFocusInWindow();
                this.topui.getTargetView().grabSelection(imp);
                this.topui.getResourceView().addToClipboardHistory(imp);
            } else if (AppPreferences.clipboard && AppPreferences.clipboardTarget == 1) {
                MemoryView mv = this.topui.getMemoryView();
                mv.translateSegment(imp, null, null, null, false);
                this.topui.getResourceView().addToClipboardHistory(imp);
            } else if (AppPreferences.clipboardTarget == 3) {
                this.topui.getSourceView().addSelectedWord(imp, false);
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        if (AppPreferences.operatingSystem == 1) {
            return;
        }
        try {
            Thread.sleep(250L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Transferable cntnts = clipboard.getContents(null);
        if (cntnts != null && cntnts.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String imp = (String)cntnts.getTransferData(DataFlavor.stringFlavor);
                if (imp != null && imp.length() > 0) {
                    this.handleClipboardString(imp);
                    StringSelection ss = new StringSelection(imp);
                    clipboard.setContents(ss, this);
                    this.stringOut = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String stripNewLineCharacters(String in) {
        if (in.indexOf("\n") != -1) {
            in = in.replaceAll("\r\n|\n", " ");
        }
        return in;
    }

    private String stripNonValidXMLCharacters(String in) {
        StringBuffer ou = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            ou.append(current);
        }
        return ou.toString();
    }
}

