/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import translator.AppPreferences;
import translator.DictionaryResource;
import translator.MainView;
import translator.MySwingWorker;
import translator.Project;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLElement;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;
import translator.ttx.TTX;
import translator.ttx.TTXUnit;
import translator.xliff.FileBody;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class Converter {
    Project project;
    Memory memory;
    DictionaryResource dictionary;
    MainView topui;
    private int stags;
    private int ttags;
    Pattern startTagsPattern;
    Pattern endTagsPattern;

    public Converter(Project project, Memory memory) {
        this.project = project;
        this.memory = memory;
    }

    public Converter(DictionaryResource dictionary, Memory memory) {
        this.dictionary = dictionary;
        this.memory = memory;
    }

    public void setMainView(MainView mv) {
        this.topui = mv;
    }

    public void toMemory() {
        if (this.project != null) {
            XLIFF xliff = this.project.getXLIFF();
            if (xliff != null) {
                this.fromXlifftoTMX(xliff);
            } else {
                TTX ttx = this.project.getTTX();
                if (ttx != null) {
                    this.fromTTXtoTMX(ttx);
                } else {
                    TMX tmx = this.project.getTMX();
                    if (tmx != null) {
                        this.fromProjectTMXtoTMX(tmx);
                    }
                }
            }
        }
    }

    public void toReplacementMemory() {
        FileBody body;
        List col;
        this.startTagsPattern = Pattern.compile(AppPreferences.startTagRegEx);
        this.endTagsPattern = Pattern.compile(AppPreferences.endTagRegEx);
        XLIFF xliff = this.project.getXLIFF();
        XliffFile pfile = xliff.getCurrentFile();
        TMX tmx = this.memory.getTMX();
        TranslationUnitMap tmap = tmx.getTUMap();
        String id = this.memory.getUserID();
        if (id == null || id.length() == 0) {
            id = AppPreferences.userid;
        }
        if ((col = (body = pfile.getBody()).getTransUnits()) != null) {
            LinkedHashMap attrs = null;
            Project pro = this.topui.getProjectView().getProject();
            if (pro != null) {
                attrs = pro.getSegmentAttributes();
            }
            Iterator it = col.iterator();
            while (it.hasNext()) {
                XLIFFUnit tu = (XLIFFUnit)it.next();
                if (!tu.translate) continue;
                String[] seg = xliff.isUncleaned ? (it.hasNext() ? this.formatXliffSegment(tu, false, xliff.getVersion()) : this.formatXliffSegment(tu, true, xliff.getVersion())) : this.formatXliffSegment(tu, false, xliff.getVersion());
                if (seg == null) continue;
                String source = seg[0];
                String target = seg[1];
                String nkey = XMLHelper.parseTags(source);
                String nvalue = XMLHelper.parseTags(target);
                if (nkey.length() <= 0 || nvalue.length() <= 0) continue;
                int[] tags = XMLHelper.calculateTagsPosition(target);
                if (tags.length > 0) {
                    tmx.update(nkey, nvalue, null, attrs, tags, this.memory.getDuplicatesMode());
                } else {
                    tmx.update(nkey, nvalue, null, attrs, null, this.memory.getDuplicatesMode());
                }
                tmap.createTU(id);
            }
        }
    }

    private void fromXlifftoTMX(XLIFF xliff) {
        List col;
        XliffFile pfile = xliff.getCurrentFile();
        if (pfile == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO XLIFF PROJECT!"));
            return;
        }
        if (this.memory == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO TMX MEMORY!"));
            return;
        }
        this.startTagsPattern = Pattern.compile(AppPreferences.startTagRegEx);
        this.endTagsPattern = Pattern.compile(AppPreferences.endTagRegEx);
        TMX tmx = this.memory.getTMX();
        TranslationUnitMap tmap = tmx.getTUMap();
        tmap.cancelProgress();
        String id = this.memory.getUserID();
        if (id == null || id.length() == 0) {
            id = AppPreferences.userid;
        }
        if ((col = xliff.getView().getViewUnits()) != null) {
            boolean counter = false;
            tmap.initProgress(0, col.size(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SENDING PROJECT SEGMENTS TO MEMORY"));
            ProgressMonitor pbar = tmap.getProgresBar();
            LinkedHashMap attrs = null;
            Project pro = this.topui.getProjectView().getProject();
            if (pro != null) {
                attrs = pro.getSegmentAttributes();
            }
            Iterator it = col.iterator();
            while (it.hasNext()) {
                XLIFFUnit tu = (XLIFFUnit)it.next();
                if (!tu.translate) continue;
                String[] seg = xliff.isUncleaned ? (it.hasNext() ? this.formatXliffSegment(tu, false, xliff.getVersion()) : this.formatXliffSegment(tu, true, xliff.getVersion())) : this.formatXliffSegment(tu, false, xliff.getVersion());
                if (seg != null) {
                    String source = seg[0];
                    String target = seg[1];
                    String nkey = XMLHelper.parseTags(source);
                    String nvalue = XMLHelper.parseTags(target);
                    if (nkey.length() > 0 && nvalue.length() > 0) {
                        int[] tags = XMLHelper.calculateTagsPosition(target);
                        if (tags.length > 0) {
                            tmx.update(nkey, nvalue, null, attrs, tags, this.memory.getDuplicatesMode());
                        } else {
                            tmx.update(nkey, nvalue, null, attrs, null, this.memory.getDuplicatesMode());
                        }
                        tmap.createTU(id);
                    }
                }
                if (!pbar.isCanceled()) continue;
                break;
            }
        }
        this.memory.setToSave(true);
        JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TMX tmx = Converter.this.memory.getTMX();
                TranslationUnitMap tmap = tmx.getTUMap();
                tmap.cancelProgress();
            }
        });
    }

    private void fromTTXtoTMX(TTX ttx) {
        List col;
        if (this.memory == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO TMX MEMORY!"));
            return;
        }
        this.startTagsPattern = Pattern.compile(AppPreferences.startTagRegEx);
        this.endTagsPattern = Pattern.compile(AppPreferences.endTagRegEx);
        TMX tmx = this.memory.getTMX();
        TranslationUnitMap tmap = tmx.getTUMap();
        tmap.cancelProgress();
        String id = this.memory.getUserID();
        if (id == null || id.length() == 0) {
            id = AppPreferences.userid;
        }
        if ((col = ttx.getView().getViewUnits()) != null) {
            tmap.initProgress(0, col.size(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SENDING PROJECT SEGMENTS TO MEMORY"));
            ProgressMonitor pbar = tmap.getProgresBar();
            LinkedHashMap attrs = null;
            Project pro = this.topui.getProjectView().getProject();
            if (pro != null) {
                attrs = pro.getSegmentAttributes();
            }
            for (TTXUnit tu : col) {
                String[] seg = this.formatTTXSegment(tu);
                if (seg != null) {
                    String source = seg[0];
                    String target = seg[1];
                    String nkey = XMLHelper.parseTags(source);
                    String nvalue = XMLHelper.parseTags(target);
                    if (nkey.length() > 0 && nvalue.length() > 0) {
                        int[] tags = XMLHelper.calculateTagsPosition(target);
                        if (tags.length > 0) {
                            tmx.update(nkey, nvalue, null, attrs, tags, this.memory.getDuplicatesMode());
                        } else {
                            tmx.update(nkey, nvalue, null, attrs, null, this.memory.getDuplicatesMode());
                        }
                        tmap.createTU(id);
                    }
                }
                if (!pbar.isCanceled()) continue;
                break;
            }
        }
        this.memory.setToSave(true);
        JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TMX tmx = Converter.this.memory.getTMX();
                TranslationUnitMap tmap = tmx.getTUMap();
                tmap.cancelProgress();
            }
        });
    }

    private void fromProjectTMXtoTMX(TMX projectTMX) {
        if (this.memory == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO TMX MEMORY!"));
            return;
        }
        TMX tmx = this.memory.getTMX();
        TranslationUnitMap tmap = tmx.getTUMap();
        tmap.cancelProgress();
        List col = projectTMX.getView().getViewUnits();
        if (col != null) {
            boolean counter = false;
            tmap.initProgress(0, col.size(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SENDING PROJECT SEGMENTS TO MEMORY"));
            ProgressMonitor pbar = tmap.getProgresBar();
            for (TMXUnit tu : col) {
                tmx.getBody().addChild(tu);
                if (!pbar.isCanceled()) continue;
                break;
            }
        }
        this.memory.setToSave(true);
        JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TMX tmx = Converter.this.memory.getTMX();
                TranslationUnitMap tmap = tmx.getTUMap();
                tmap.cancelProgress();
            }
        });
    }

    public void toProject() {
        XLIFF xliff;
        XliffFile pfile = null;
        if (this.project != null && (xliff = this.project.getXLIFF()) != null) {
            pfile = xliff.getCurrentFile();
        }
        if (pfile == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO XLIFF PROJECT!"));
            return;
        }
        if (this.memory == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO TMX MEMORY!"));
            return;
        }
        MySwingWorker worker = new MySwingWorker(){
            int count = 0;
            TranslationUnitMap tmap;

            @Override
            public Object construct() {
                TMX tmx = Converter.this.memory.getTMX();
                this.tmap = tmx.getTUMap();
                Collection col = tmx.getTranslationUnits();
                this.tmap.initProgress(0, col.size(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SENDING MEMORY SEGMENTS TO PROJECT"));
                ProgressMonitor pbar = this.tmap.getProgresBar();
                String slang = Converter.this.memory.getSourceLangCode();
                String tlang = Converter.this.memory.getTargetLangCode();
                String source = null;
                String target = null;
                for (TranslationUnit tu : col) {
                    source = tu.getSegment(slang);
                    target = tu.getSegment(tlang);
                    Converter.this.project.prepareTransUnit();
                    Converter.this.project.createTransUnit(source, target, null, 0, source.length(), 0, null);
                    ++this.count;
                    if (this.count % 100 == 0) {
                        this.tmap.updateProgress(this.count);
                    }
                    if (!pbar.isCanceled()) continue;
                    break;
                }
                return null;
            }

            @Override
            public void finished() {
                this.tmap.cancelProgress();
                Converter.this.project.updateViewMode(AppPreferences.projectView);
                JOptionPane.showMessageDialog(Converter.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
            }
        };
        worker.start();
    }

    public void dictionaryToMemory() {
        if (this.memory == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO TMX MEMORY!"));
            return;
        }
        this.dictionary.toMemory(this.memory);
    }

    public void memoryToDictionary() {
        if (this.memory == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO TMX MEMORY!"));
            return;
        }
        this.dictionary.fromMemory(this.memory);
    }

    private String[] formatXliffSegment(XLIFFUnit tu, boolean lastTUUncleaned, int xliffVersion) {
        boolean hasString;
        XMLElement ttuv = tu.getTarget();
        XMLElement stuv = tu.getSource();
        if (stuv == null || ttuv == null) {
            return null;
        }
        List slist = stuv.getChildren();
        List tlist = ttuv.getChildren();
        this.stags = -1;
        this.ttags = -1;
        String firstSourceTag = null;
        String firstTargetTag = null;
        String lastTargetTag = null;
        String lastSourceTag = null;
        String[] sarr = this.getXliffSourceElements(slist, true, xliffVersion);
        String[] tarr = this.getXliffTargetElements(tlist, true, xliffVersion);
        String fsource = sarr[0];
        String ftarget = tarr[0];
        while (fsource.startsWith("<x") && ftarget.startsWith("<x")) {
            int exstag = this.firstTagsIndex(fsource);
            int exttag = this.firstTagsIndex(ftarget);
            if (exstag == -1 || exttag == -1) break;
            if (firstSourceTag == null && firstTargetTag == null) {
                firstSourceTag = fsource.substring(0, exstag);
                firstTargetTag = ftarget.substring(0, exttag);
            } else {
                firstSourceTag = firstSourceTag + fsource.substring(0, exstag);
                firstTargetTag = firstTargetTag + ftarget.substring(0, exttag);
            }
            fsource = fsource.substring(exstag);
            ftarget = ftarget.substring(exttag);
        }
        if (firstSourceTag != null && firstTargetTag != null && !firstSourceTag.equals(firstTargetTag)) {
            firstSourceTag = null;
            firstTargetTag = null;
            fsource = sarr[0];
            ftarget = tarr[0];
        }
        while (fsource.endsWith(">") && ftarget.endsWith(">")) {
            int indxs = this.lastTagsIndex(fsource);
            int indxt = this.lastTagsIndex(ftarget);
            if (indxs == -1 || indxt == -1) break;
            if (lastSourceTag == null && lastTargetTag == null) {
                lastSourceTag = fsource.substring(indxs);
                lastTargetTag = ftarget.substring(indxt);
            } else {
                lastSourceTag = fsource.substring(indxs) + lastSourceTag;
                lastTargetTag = ftarget.substring(indxt) + lastTargetTag;
            }
            fsource = fsource.substring(0, indxs);
            ftarget = ftarget.substring(0, indxt);
        }
        if (lastSourceTag != null && lastTargetTag != null && !lastSourceTag.equals(lastTargetTag)) {
            firstSourceTag = null;
            firstTargetTag = null;
            lastSourceTag = null;
            lastTargetTag = null;
            fsource = sarr[0];
            ftarget = tarr[0];
        }
        if (lastTUUncleaned && lastTargetTag == null) {
            int indxt;
            while (ftarget.endsWith(">") && (indxt = this.lastTagsIndex(ftarget)) != -1) {
                lastTargetTag = lastTargetTag == null ? ftarget.substring(indxt) : ftarget.substring(indxt) + lastTargetTag;
                ftarget = ftarget.substring(0, indxt);
            }
        }
        if (ftarget.length() > 0 && !(hasString = XMLHelper.hasStringContent(ftarget))) {
            ftarget = "";
        }
        String[] seg = new String[]{fsource, ftarget};
        return seg;
    }

    private String[] getXliffTargetElements(List list, boolean edit, int xliffVersion) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (xliffVersion == 2) {
                    if (name.equals("cp") || name.equals("ph") || name.equals("sc") || name.equals("ec") || name.equals("sm") || name.equals("em")) {
                        ed = false;
                        em = true;
                    }
                } else {
                    if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                        ed = false;
                    }
                    if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                        em = true;
                    }
                }
                int tagNo = ++this.ttags;
                String tname = "x" + tagNo;
                if (name.equals("x")) {
                    String lock;
                    String equiv = xml.getAttribute("equiv-text");
                    if (equiv != null && equiv.length() > 0) {
                        tname = tname + " equiv-text=\"" + equiv + "\"";
                    }
                    if (AppPreferences.projectType == 3 && (lock = xml.getAttribute("id")) != null && lock.length() > 0 && lock.startsWith("locked")) {
                        tname = tname + " lock=\"true\"";
                    }
                }
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                fs = fs + stag;
                String[] arr = this.getXliffTargetElements(li, ed, xliffVersion);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private String[] getXliffSourceElements(List list, boolean edit, int xliffVersion) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                String equiv;
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (xliffVersion == 2) {
                    if (name.equals("cp") || name.equals("ph") || name.equals("sc") || name.equals("ec") || name.equals("sm") || name.equals("em")) {
                        ed = false;
                        em = true;
                    }
                } else {
                    if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                        ed = false;
                    }
                    if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                        em = true;
                    }
                }
                int tagNo = ++this.stags;
                String tname = "x" + tagNo;
                if (name.equals("x") && (equiv = xml.getAttribute("equiv-text")) != null && equiv.length() > 0) {
                    tname = tname + " equiv-text=\"" + equiv + "\"";
                }
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                fs = fs + stag;
                String[] arr = this.getXliffSourceElements(li, ed, xliffVersion);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private String[] formatTTXSegment(TTXUnit tu) {
        XMLElement ttuv = tu.getTarget();
        XMLElement stuv = tu.getSource();
        if (stuv == null || ttuv == null) {
            return null;
        }
        List slist = stuv.getChildren();
        List tlist = ttuv.getChildren();
        this.stags = -1;
        this.ttags = -1;
        String firstSourceTag = null;
        String firstTargetTag = null;
        String lastTargetTag = null;
        String lastSourceTag = null;
        String[] sarr = this.getTTXSourceElements(slist, true);
        String[] tarr = this.getTTXTargetElements(tlist, true);
        String fsource = sarr[0];
        String ftarget = tarr[0];
        while ((fsource.startsWith("<x") || fsource.startsWith("</x")) && ftarget.startsWith("<x") || ftarget.startsWith("</x")) {
            int exstag = this.firstTagsIndex(fsource);
            int exttag = this.firstTagsIndex(ftarget);
            if (exstag == -1 || exttag == -1) break;
            if (firstSourceTag == null && firstTargetTag == null) {
                firstSourceTag = fsource.substring(0, exstag);
                firstTargetTag = ftarget.substring(0, exttag);
            } else {
                firstSourceTag = firstSourceTag + fsource.substring(0, exstag);
                firstTargetTag = firstTargetTag + ftarget.substring(0, exttag);
            }
            fsource = fsource.substring(exstag);
            ftarget = ftarget.substring(exttag);
        }
        if (firstSourceTag != null && firstTargetTag != null && !firstSourceTag.equals(firstTargetTag)) {
            firstSourceTag = null;
            firstTargetTag = null;
            fsource = sarr[0];
            ftarget = tarr[0];
        }
        while (fsource.endsWith(">") && ftarget.endsWith(">")) {
            int indxs = this.lastTagsIndex(fsource);
            int indxt = this.lastTagsIndex(ftarget);
            if (indxs == -1 || indxt == -1) break;
            if (lastSourceTag == null && lastTargetTag == null) {
                lastSourceTag = fsource.substring(indxs);
                lastTargetTag = ftarget.substring(indxt);
            } else {
                lastSourceTag = fsource.substring(indxs) + lastSourceTag;
                lastTargetTag = ftarget.substring(indxt) + lastTargetTag;
            }
            fsource = fsource.substring(0, indxs);
            ftarget = ftarget.substring(0, indxt);
        }
        if (lastSourceTag != null && lastTargetTag != null && !lastSourceTag.equals(lastTargetTag)) {
            firstSourceTag = null;
            firstTargetTag = null;
            lastSourceTag = null;
            lastTargetTag = null;
            fsource = sarr[0];
            ftarget = tarr[0];
        }
        String[] seg = new String[]{fsource, ftarget};
        return seg;
    }

    private String[] getTTXSourceElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("ut")) {
                    ed = false;
                }
                int tagNo = ++this.stags;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                fs = fs + stag;
                String[] arr = this.getTTXSourceElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private String[] getTTXTargetElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("ut")) {
                    ed = false;
                }
                int tagNo = ++this.ttags;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                fs = fs + stag;
                String[] arr = this.getTTXTargetElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private int firstTagsIndex(String s) {
        int i = -1;
        Matcher m = this.startTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.end();
        }
        return i;
    }

    private int lastTagsIndex(String s) {
        int i = -1;
        Matcher m = this.endTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.start();
        }
        return i;
    }
}

