/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AboutDialog;
import translator.AppPreferences;
import translator.BillingChooser;
import translator.FormatChooser;
import translator.LanguageCodes;
import translator.MainView;
import translator.MatchBoard;
import translator.NewResource;
import translator.ProjectTemplate;
import translator.ProjectView;
import translator.ResourceLoader;
import translator.TabView;
import translator.WorkflowManager;
import translator.WorkflowView;
import translator.database.DatabaseView;
import translator.tmx.Memory;
import translator.ui.CTFocusTraversalPolicy;
import translator.ui.GridPanel;
import translator.ui.HTMLFormat;
import translator.ui.kodo.KodoBreathingPanel;
import translator.ui.kodo.KodoComboBoxRenderer;
import translator.ui.kodo.KodoComboBoxUI;
import translator.ui.kodo.KodoGlowingBorder;
import translator.ui.kodo.KodoTabbedPaneUI;
import translator.web.TMTown;
import translator.xliff.XliffFile;
import translator.xliff.XliffFileEditor;
import translator.xliff.XliffMenu;

public class DashboardView
extends GridPanel {
    private JTabbedPane jTab;
    private KodoBreathingPanel toolbars;
    private JPanel databasePanel;
    private JPanel resourcesPanel;
    private JPanel segmentsPanel;
    private JPanel termsPanel;
    private JPanel apiSericesPanel;
    private JComboBox recentProjectsCombo;
    private JComboBox combo1;
    private JComboBox combo2;
    private JButton langPairButton;
    private List recentProjectsList;
    private XliffFile projectFile;
    private MainView topui;
    private JMenuBar menuBar;
    private XliffMenu xliffmenu;
    private boolean addingFile = false;
    private boolean replacingFile = false;
    private JToolBar bar;
    private JToolBar bar2;
    private JToolBar barS;
    private JToolBar barP;
    private JToolBar barD;
    private JButton goButton;
    private JButton newButton;
    private JButton menuButton;
    boolean textColor;
    private boolean mergeGlossaries;
    private JSplitPane sp0;
    private JSplitPane sp1;
    private JSplitPane sp2;
    private JSplitPane sp3;
    private Color barsFontColor;
    private Color panelsFontColor;
    private boolean firstRun = false;
    private String tabTitle = "Resources";

    public DashboardView(MainView jowner, XliffMenu xliffmenu, XliffFile projFile, boolean add, boolean replace) {
        GridPanel panel3;
        JScrollPane scroll;
        String lang;
        Border border;
        String buttonName;
        String buttonText;
        Color barsColor;
        Color borderFontColor;
        Color color;
        Color c;
        KodoGlowingBorder borderPanels;
        Color colorTitleBorder;
        Border borderBars;
        Color colorPanels;
        this.projectFile = projFile;
        this.topui = jowner;
        this.xliffmenu = xliffmenu;
        this.setLayout(new BorderLayout());
        this.setName("Dashboard");
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.textColor = false;
        if (AppPreferences.alpha == -1 && AppPreferences.tBackgroundIm.length() <= 0 && !AppPreferences.linuxGTK) {
            this.textColor = true;
        }
        Object backgroundIm = null;
        String backgroundImCenter = null;
        if (AppPreferences.themeDashboard == null || AppPreferences.themeDashboard.equals("Coffeehouse")) {
            colorPanels = this.topui.getMainPanel().getBackground();
            this.barsFontColor = Color.LIGHT_GRAY;
            borderBars = BorderFactory.createEmptyBorder(5, 0, 5, 0);
            colorTitleBorder = Color.GRAY;
            borderPanels = new KodoGlowingBorder();
            c = new Color(AppPreferences.iconsColor);
            color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 180);
            borderPanels.setColors(new Color(200, 200, 200, 180), new Color(200, 200, 200, 180), color);
            if (AppPreferences.pBackgroundIm.length() > 0) {
                backgroundImCenter = AppPreferences.backgroundPath + "texture.jpg";
            }
            borderFontColor = Color.WHITE;
            barsColor = GridPanel.darker(colorPanels, 0.7);
        } else {
            colorPanels = GridPanel.darker(this.topui.getMainPanel().getBackground(), 0.9);
            this.barsFontColor = Color.BLACK;
            borderBars = BorderFactory.createEmptyBorder(5, 0, 5, 0);
            colorTitleBorder = Color.white;
            borderPanels = new KodoGlowingBorder();
            c = new Color(AppPreferences.iconsColor);
            color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 180);
            borderPanels.setColors(new Color(200, 200, 200, 180), new Color(200, 200, 200, 180), color);
            if (AppPreferences.pBackgroundIm.length() > 0 && AppPreferences.background == -1) {
                backgroundImCenter = AppPreferences.backgroundPath + "texture2.jpg";
            }
            borderFontColor = Color.BLACK;
            barsColor = GridPanel.darker(colorPanels, 0.9);
        }
        if (backgroundImCenter != null) {
            try {
                File imaFile = new File(backgroundImCenter);
                if (imaFile.exists()) {
                    this.setTransparent(true);
                    this.setImage(imaFile.toURI().toURL());
                }
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setBackground(colorPanels);
        int grey = (int)((double)this.getBackground().getRed() * 0.299 + (double)this.getBackground().getGreen() * 0.587 + (double)this.getBackground().getBlue() * 0.114);
        this.panelsFontColor = grey < 186 ? Color.WHITE : Color.BLACK;
        grey = (int)((double)barsColor.getRed() * 0.299 + (double)barsColor.getGreen() * 0.587 + (double)barsColor.getBlue() * 0.114);
        Border border2 = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.bar = new JToolBar();
        if (AppPreferences.linuxGTK) {
            this.bar.setUI(new BasicToolBarUI());
            this.bar.setLayout(new BoxLayout(this.bar, 2));
        }
        this.bar.setBorder(border2);
        this.bar.setFloatable(false);
        this.bar.setOpaque(false);
        this.bar.setBackground(this.topui.getMainPanelBackgroundColor());
        this.bar2 = new JToolBar();
        if (AppPreferences.linuxGTK) {
            this.bar2.setUI(new BasicToolBarUI());
            this.bar2.setLayout(new BoxLayout(this.bar2, 2));
        }
        this.bar2.setBackground(this.topui.getMainPanelBackgroundColor());
        this.bar2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.bar2.setFloatable(false);
        this.bar2.setOpaque(false);
        this.barS = new JToolBar();
        if (AppPreferences.linuxGTK) {
            this.barS.setUI(new BasicToolBarUI());
            this.barS.setLayout(new BoxLayout(this.barS, 2));
        }
        this.barS.setFloatable(false);
        this.barS.setOpaque(false);
        this.barS.setBorder(borderBars);
        this.barP = new JToolBar();
        if (AppPreferences.linuxGTK) {
            this.barP.setUI(new BasicToolBarUI());
            this.barP.setLayout(new BoxLayout(this.barP, 2));
        }
        this.barP.setFloatable(false);
        this.barP.setOpaque(false);
        this.barP.setBorder(borderBars);
        this.barD = new JToolBar();
        if (AppPreferences.linuxGTK) {
            this.barD.setUI(new BasicToolBarUI());
            this.barD.setLayout(new BoxLayout(this.barD, 2));
        }
        this.barD.setFloatable(false);
        this.barD.setOpaque(false);
        this.barD.setBorder(borderBars);
        this.addingFile = add;
        this.replacingFile = replace;
        this.topui.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                String fileName = null;
                try {
                    Transferable tr = dtde.getTransferable();
                    DataFlavor[] flavors = tr.getTransferDataFlavors();
                    flavors = flavors.length == 0 ? dtde.getCurrentDataFlavors() : flavors;
                    DataFlavor flavor = DataFlavor.selectBestTextFlavor(flavors);
                    flavor = flavor == null ? flavors[0] : flavor;
                    DataFlavor Linux = new DataFlavor("text/uri-list;class=java.io.Reader");
                    DataFlavor Windows = DataFlavor.javaFileListFlavor;
                    if (flavor.equals(Linux)) {
                        dtde.acceptDrop(3);
                        BufferedReader read = new BufferedReader(flavor.getReaderForText(tr));
                        fileName = read.readLine();
                        if (fileName.startsWith("file://")) {
                            fileName = fileName.substring(7);
                        }
                        fileName = fileName.replace("%20", " ");
                        if ((fileName = fileName.replace("+", "%2B")).length() > 9 && fileName.substring(0, 9).equals("localhost")) {
                            fileName = fileName.substring(9);
                        }
                        fileName = URLDecoder.decode(fileName, "UTF-8");
                        read.close();
                        dtde.dropComplete(true);
                    } else if (flavor.equals(Windows)) {
                        dtde.acceptDrop(3);
                        List list = (List)tr.getTransferData(flavor);
                        dtde.dropComplete(true);
                        if (list.size() == 1) {
                            File f = (File)list.get(0);
                            fileName = f.getPath();
                        }
                    } else {
                        System.err.println("DnD Error");
                        dtde.rejectDrop();
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("DnD not initalized properly, please try again.");
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
                catch (UnsupportedFlavorException e) {
                    System.err.println(e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    System.err.println(e.getMessage());
                }
                if (fileName != null) {
                    final File file = new File(fileName);
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.DashboardView.this.addSourceDocument(file);
                        }
                    });
                }
            }
        });
        if (!this.addingFile) {
            this.goButton = new JButton(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN")){

                @Override
                public void actionPerformed(ActionEvent a) {
                    if (DashboardView.this.recentProjectsCombo != null) {
                        int i = DashboardView.this.recentProjectsCombo.getSelectedIndex();
                        if (i != -1) {
                            if (i == DashboardView.this.recentProjectsCombo.getItemCount() - 2) {
                                DashboardView.this.newProject(4, false);
                            } else if (i == DashboardView.this.recentProjectsCombo.getItemCount() - 1) {
                                DashboardView.this.newProject(4, true);
                            } else {
                                String p = DashboardView.this.recentProjectsList.get(i).toString();
                                DashboardView.this.loadProjectFile(p);
                            }
                        }
                    } else {
                        DashboardView.this.newProject(4, false);
                    }
                }
            });
            this.goButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN A RECENT PROJECT"));
            this.goButton.setOpaque(false);
            this.goButton.setFocusPainted(false);
            Font bfont = this.goButton.getFont();
            float bsize = bfont.getSize2D();
            if ((double)bsize < 18.0) {
                this.goButton.setFont(this.goButton.getFont().deriveFont(18.0f));
            }
            this.goButton.setForeground(Color.WHITE);
            this.goButton.setBorder(new EmptyBorder(4, 12, 4, 12));
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_BOOK_OPEN_PAGE_VARIANT, (int)(this.goButton.getFont().getSize() + 4), (Color)Color.WHITE);
            this.goButton.setIcon((Icon)ficon);
            this.goButton.setName("DashboardOpenRecent");
        }
        if (!this.addingFile) {
            if (AppPreferences.fileSLang != null && AppPreferences.fileSLang.length() > 0) {
                buttonText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW");
            } else {
                buttonText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW");
                this.firstRun = true;
            }
            buttonName = "NewProject";
        } else {
            buttonText = !this.replacingFile ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD DOCUMENT") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE DOCUMENT");
            buttonName = "AddDocument";
        }
        this.newButton = new JButton(new AbstractAction(buttonText){

            @Override
            public void actionPerformed(ActionEvent a) {
                if (!DashboardView.this.firstRun) {
                    if (!DashboardView.this.addingFile) {
                        DashboardView.this.newProject(0, AppPreferences.documentsFolder);
                    } else {
                        DashboardView.this.newProject(0, false);
                    }
                } else {
                    JOptionPane.showMessageDialog(DashboardView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR LANGUAGE PAIR FROM THE LIST ABOVE!"));
                    DashboardView.this.combo1.requestFocusInWindow();
                }
            }
        });
        this.newButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK OR DROP A FILE HERE TO START A PROJECT."));
        this.newButton.setFocusPainted(false);
        this.newButton.setName(buttonName);
        Font bfont = this.newButton.getFont();
        float bsize = bfont.getSize2D();
        if ((double)bsize < 18.0) {
            this.newButton.setFont(this.newButton.getFont().deriveFont(18.0f));
        }
        this.newButton.setOpaque(false);
        this.newButton.setForeground(Color.WHITE);
        this.newButton.setBorder(new EmptyBorder(4, 12, 4, 12));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_BOOK_PLUS, (int)(this.newButton.getFont().getSize() + 4), (Color)Color.WHITE);
        this.newButton.setIcon((Icon)ficon);
        this.menuButton = new JButton("Menu");
        this.menuButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT OPTIONS AND SETTINGS"));
        this.menuButton.setOpaque(false);
        this.menuButton.setForeground(Color.WHITE);
        this.menuButton.setName("DashboardPopUpMenu");
        this.menuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JButton button = (JButton)e.getSource();
                int x = e.getX() - 20;
                int y = e.getY() + 20;
                DashboardView.this.showDashboardPopUpMenu(button, x, y);
            }
        });
        this.menuButton.setFocusPainted(false);
        this.menuButton.setBorder(new EmptyBorder(4, 12, 4, 12));
        bfont = this.menuButton.getFont();
        bsize = bfont.getSize2D();
        if ((double)bsize < 18.0) {
            this.menuButton.setFont(this.menuButton.getFont().deriveFont(18.0f));
        }
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_MENU, (int)(this.menuButton.getFont().getSize() + 4), (Color)Color.WHITE);
        this.menuButton.setIcon((Icon)ficon);
        if (!this.addingFile) {
            List tnames;
            JButton tableNewButton = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    DashboardView.this.topui.getDatabaseView().makeTable();
                }
            });
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DATABASE, (int)(tableNewButton.getFont().getSize() + 4), (Color)this.barsFontColor);
            tableNewButton.setIcon((Icon)ficon);
            tableNewButton.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW"));
            tableNewButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW MEMORY TABLE"));
            tableNewButton.setForeground(this.barsFontColor);
            tableNewButton.setOpaque(false);
            tableNewButton.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
            this.barD.add(tableNewButton);
            JButton importTMX = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT TMX"));
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PLUS_CIRCLE, (int)(importTMX.getFont().getSize() + 4), (Color)this.barsFontColor);
            importTMX.setIcon((Icon)ficon);
            importTMX.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
            importTMX.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT TMX MEMORY"));
            importTMX.setForeground(this.barsFontColor);
            importTMX.setOpaque(false);
            importTMX.setName("MenuTRCATToolsExchangeLoadFromTMXMemory");
            importTMX.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DashboardView.this.topui.getMemoryView().memoryOpen(2, ((DashboardView)DashboardView.this).topui.getDatabaseView().mergeTRMemories);
                }
            });
            this.barD.add(importTMX);
            JButton optionsButton = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPTIONS"));
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SETTINGS, (int)(optionsButton.getFont().getSize() + 4), (Color)this.barsFontColor);
            optionsButton.setIcon((Icon)ficon);
            optionsButton.setToolTipText("Total Recall options");
            optionsButton.setForeground(this.barsFontColor);
            optionsButton.setOpaque(false);
            optionsButton.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
            optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Memory m = (Memory)DashboardView.this.databasePanel.getClientProperty("memory");
                    if (m != null) {
                        DashboardView.this.topui.getMemoryView().setTotalRecallMemoryDefaultOptions(m);
                    }
                }
            });
            this.barD.add(Box.createHorizontalGlue());
            this.barD.add(optionsButton);
            this.recentProjectsList = new ArrayList();
            List list = this.topui.getResourceLoader().getLastProjects();
            if (!list.isEmpty()) {
                this.recentProjectsCombo = new JComboBox();
                this.recentProjectsCombo.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A RECENT PROJECT"));
                this.recentProjectsCombo.setMaximumRowCount(18);
                this.recentProjectsCombo.setName("RecentProjectsCombo");
                Font cfont = this.recentProjectsCombo.getFont();
                float fsize = cfont.getSize2D();
                if ((double)fsize < 16.0) {
                    cfont = new Font("SansSerif", 0, 16);
                }
                if (!AppPreferences.linuxGTK) {
                    this.recentProjectsCombo.setRenderer(new KodoComboBoxRenderer());
                    this.recentProjectsCombo.setBackground(new Color(20, 20, 20));
                    this.recentProjectsCombo.setForeground(Color.LIGHT_GRAY);
                    border = new KodoGlowingBorder();
                    Color c2 = new Color(AppPreferences.iconsColor);
                    Color color2 = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), 180);
                    border.setColors(new Color(255, 255, 255, 180), new Color(255, 255, 255, 90), color2);
                    this.recentProjectsCombo.setBorder(border);
                    this.recentProjectsCombo.setUI(new KodoComboBoxUI());
                }
                this.recentProjectsCombo.setFont(cfont);
                this.recentProjectsCombo.setFocusable(false);
                String selectedProject = null;
                for (int i = 0; i < list.size(); ++i) {
                    String n;
                    String nn;
                    File file;
                    String p = list.get(i).toString();
                    if (p == null || p.length() <= 0 || !(file = new File(p)).exists()) continue;
                    if (!file.isDirectory() && (nn = file.getName().toLowerCase()).endsWith(".xlf")) {
                        file = file.getParentFile();
                    }
                    if ((n = file.getName()).length() > 45) {
                        n = n.substring(0, 42) + "...";
                    }
                    this.recentProjectsList.add(p);
                    this.recentProjectsCombo.addItem(n);
                    if (AppPreferences.currentProject == null || !AppPreferences.currentProject.equals(p)) continue;
                    selectedProject = n;
                }
                this.recentProjectsCombo.addItem("Open project...");
                this.recentProjectsCombo.addItem("Open project folder...");
                if (selectedProject != null) {
                    this.recentProjectsCombo.setSelectedItem(selectedProject);
                }
                this.recentProjectsCombo.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            String s = e.getItem().toString();
                            if (s.equals("Open project...")) {
                                DashboardView.this.recentProjectsCombo.setPopupVisible(false);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DashboardView.this.newProject(4, false);
                                    }
                                });
                            } else if (s.equals("Open project folder...")) {
                                DashboardView.this.recentProjectsCombo.setPopupVisible(false);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DashboardView.this.newProject(4, true);
                                    }
                                });
                            } else {
                                int i = DashboardView.this.recentProjectsCombo.getSelectedIndex();
                                if (i != -1 && i < DashboardView.this.recentProjectsList.size() && i < DashboardView.this.recentProjectsCombo.getItemCount() - 2) {
                                    String p;
                                    AppPreferences.currentProject = p = DashboardView.this.recentProjectsList.get(i).toString();
                                    DashboardView.this.setTemplateForProject(p);
                                }
                            }
                        }
                    }
                });
            }
            this.resourcesPanel = new JPanel();
            this.resourcesPanel.setOpaque(false);
            BoxLayout boxLayout = new BoxLayout(this.resourcesPanel, 3);
            this.resourcesPanel.setLayout(boxLayout);
            this.setResources(false);
            this.apiSericesPanel = new JPanel();
            this.apiSericesPanel.setOpaque(false);
            boxLayout = new BoxLayout(this.apiSericesPanel, 3);
            this.apiSericesPanel.setLayout(boxLayout);
            this.setServices(false);
            this.segmentsPanel = new JPanel();
            this.segmentsPanel.setOpaque(false);
            boxLayout = new BoxLayout(this.segmentsPanel, 3);
            this.segmentsPanel.setLayout(boxLayout);
            this.setMemories(false);
            JButton memoryButton = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    DashboardView.this.showTMFileChooser(false);
                }
            });
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PLUS_CIRCLE, (int)(memoryButton.getFont().getSize() + 4), (Color)this.barsFontColor);
            memoryButton.setIcon((Icon)ficon);
            memoryButton.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD MEMORY"));
            memoryButton.setForeground(this.barsFontColor);
            memoryButton.setOpaque(false);
            memoryButton.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
            JButton memoryNewButton = new JButton(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW MEMORY")){

                @Override
                public void actionPerformed(ActionEvent a) {
                    DashboardView.this.topui.getMemoryView().newSegmentsMemory(false);
                }
            });
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)(memoryNewButton.getFont().getSize() + 4), (Color)this.barsFontColor);
            memoryNewButton.setIcon((Icon)ficon);
            memoryNewButton.setForeground(this.barsFontColor);
            memoryNewButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW TRANSLATION MEMORY"));
            memoryNewButton.setOpaque(false);
            memoryNewButton.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
            this.barS.add(memoryNewButton);
            this.barS.add(memoryButton);
            this.termsPanel = new JPanel();
            this.termsPanel.setOpaque(false);
            boxLayout = new BoxLayout(this.termsPanel, 3);
            this.termsPanel.setLayout(boxLayout);
            this.setGlossaries(false);
            JButton glossaryButton = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    DashboardView.this.addGlossary(true);
                }
            });
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PENCIL, (int)(glossaryButton.getFont().getSize() + 4), (Color)this.barsFontColor);
            glossaryButton.setIcon((Icon)ficon);
            glossaryButton.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW GLOSSARY"));
            glossaryButton.setForeground(this.barsFontColor);
            glossaryButton.setOpaque(false);
            glossaryButton.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
            JButton openGlossaryButton = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    DashboardView.this.addGlossary(false);
                }
            });
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PLUS_CIRCLE, (int)(openGlossaryButton.getFont().getSize() + 4), (Color)this.barsFontColor);
            openGlossaryButton.setIcon((Icon)ficon);
            openGlossaryButton.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD GLOSSARY"));
            openGlossaryButton.setForeground(this.barsFontColor);
            openGlossaryButton.setOpaque(false);
            openGlossaryButton.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
            this.barP.add(glossaryButton);
            this.barP.add(openGlossaryButton);
            this.databasePanel = new JPanel();
            this.databasePanel.setOpaque(false);
            boxLayout = new BoxLayout(this.databasePanel, 3);
            this.databasePanel.setLayout(boxLayout);
            Memory m = this.topui.getMemoryView().createTotalRecallMemory(null);
            this.databasePanel.putClientProperty("memory", m);
            DatabaseView dv = this.topui.getDatabaseView();
            if (dv.isConnected() && (tnames = dv.getTableNames()) != null) {
                this.setDatabaseTables(tnames);
            }
        }
        String[] wlangs = null;
        if (AppPreferences.workingLanguages != null && AppPreferences.workingLanguages.length() > 0) {
            wlangs = AppPreferences.workingLanguages.split("\\|");
            LanguageCodes.updateCurrentLangNames(wlangs);
        }
        String[] langs = LanguageCodes.getNames();
        this.combo1 = new JComboBox<String>(langs);
        this.combo1.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A SOURCE LANGUAGE"));
        if (!AppPreferences.linuxGTK) {
            this.combo1.setRenderer(new KodoComboBoxRenderer());
            this.combo1.setBackground(new Color(20, 20, 20));
            this.combo1.setForeground(Color.LIGHT_GRAY);
            KodoGlowingBorder border3 = new KodoGlowingBorder();
            Color c3 = new Color(AppPreferences.iconsColor);
            Color color3 = new Color(c3.getRed(), c3.getGreen(), c3.getBlue(), 180);
            border3.setColors(new Color(255, 255, 255, 180), new Color(255, 255, 255, 90), color3);
            this.combo1.setBorder(border3);
            this.combo1.setUI(new KodoComboBoxUI());
        }
        this.combo1.setFocusable(false);
        Font f = this.combo1.getFont();
        float fs = f.getSize2D();
        if ((double)fs < 16.0) {
            this.combo1.setFont(f.deriveFont(16.0f));
        }
        if (wlangs != null && wlangs.length > 0) {
            for (int i = 0; i < wlangs.length; ++i) {
                lang = wlangs[i];
                this.combo1.insertItemAt(lang, 0);
            }
            this.combo1.insertItemAt("", wlangs.length);
        }
        if (AppPreferences.fileSLang != null && AppPreferences.fileSLang.length() > 0) {
            String s = LanguageCodes.getName(AppPreferences.fileSLang);
            if (s != null) {
                this.combo1.setSelectedItem(s);
            }
            this.projectFile.setAttribute("source-language", AppPreferences.fileSLang);
        }
        langs = LanguageCodes.getNames();
        this.combo2 = new JComboBox<String>(langs);
        this.combo2.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A TARGET LANGUAGE"));
        if (!AppPreferences.linuxGTK) {
            this.combo2.setRenderer(new KodoComboBoxRenderer());
            this.combo2.setBackground(new Color(20, 20, 20));
            this.combo2.setForeground(Color.LIGHT_GRAY);
            KodoGlowingBorder border4 = new KodoGlowingBorder();
            Color c4 = new Color(AppPreferences.iconsColor);
            Color color4 = new Color(c4.getRed(), c4.getGreen(), c4.getBlue(), 180);
            border4.setColors(new Color(255, 255, 255, 180), new Color(255, 255, 255, 90), color4);
            this.combo2.setBorder(border4);
            this.combo2.setUI(new KodoComboBoxUI());
        }
        this.combo2.setFocusable(false);
        f = this.combo2.getFont();
        fs = f.getSize2D();
        if ((double)fs < 16.0) {
            this.combo2.setFont(f.deriveFont(16.0f));
        }
        if (wlangs != null && wlangs.length > 0) {
            for (int i = 0; i < wlangs.length; ++i) {
                lang = wlangs[i];
                this.combo2.insertItemAt(lang, 0);
            }
            this.combo2.insertItemAt("", wlangs.length);
        }
        if (AppPreferences.fileTLang != null && AppPreferences.fileTLang.length() > 0) {
            String s = LanguageCodes.getName(AppPreferences.fileTLang);
            if (s != null) {
                this.combo2.setSelectedItem(s);
            }
            this.projectFile.setAttribute("target-language", AppPreferences.fileTLang);
        }
        this.langPairButton = new JButton();
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SWAP_HORIZONTAL, (int)(this.langPairButton.getFont().getSize() + 4), (Color)Color.WHITE);
        this.langPairButton.setIcon((Icon)ficon);
        this.langPairButton.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize + 8, AppPreferences.borderSize, AppPreferences.borderSize + 8));
        this.langPairButton.setOpaque(false);
        this.langPairButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String src = (String)DashboardView.this.combo1.getSelectedItem();
                String trg = (String)DashboardView.this.combo2.getSelectedItem();
                if (src != null && trg != null) {
                    DashboardView.this.combo1.setSelectedItem(trg);
                    DashboardView.this.combo2.setSelectedItem(src);
                }
            }
        });
        this.langPairButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SWITCH LANGUAGES"));
        this.langPairButton.setFocusPainted(false);
        bfont = this.langPairButton.getFont();
        bsize = bfont.getSize2D();
        if ((double)bsize < 18.0) {
            this.langPairButton.setFont(this.langPairButton.getFont().deriveFont(1, 18.0f));
        }
        if (AppPreferences.themeDashboard == null || AppPreferences.themeDashboard.equals("Coffeehouse")) {
            this.langPairButton.setForeground(Color.WHITE);
        } else {
            this.langPairButton.setForeground(Color.WHITE);
        }
        this.combo1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String s = e.getItem().toString();
                String s2 = DashboardView.this.combo2.getSelectedItem().toString();
                if (s.length() == 0 || s2.length() == 0) {
                    return;
                }
                AppPreferences.fileSLang = LanguageCodes.getCode(s);
                DashboardView.this.projectFile.setAttribute("source-language", AppPreferences.fileSLang);
                AppPreferences.fileTLang = LanguageCodes.getCode(s2);
                DashboardView.this.projectFile.setAttribute("target-language", AppPreferences.fileTLang);
                if (!DashboardView.this.addingFile) {
                    DashboardView.this.firstRun = false;
                    String buttonText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW");
                    DashboardView.this.newButton.setText(buttonText);
                }
            }
        });
        this.combo2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String s = e.getItem().toString();
                String s2 = DashboardView.this.combo1.getSelectedItem().toString();
                if (s.length() == 0 || s2.length() == 0) {
                    return;
                }
                AppPreferences.fileTLang = LanguageCodes.getCode(s);
                DashboardView.this.projectFile.setAttribute("target-language", AppPreferences.fileTLang);
                AppPreferences.fileSLang = LanguageCodes.getCode(s2);
                DashboardView.this.projectFile.setAttribute("source-language", AppPreferences.fileSLang);
                if (!DashboardView.this.addingFile) {
                    DashboardView.this.firstRun = false;
                    String buttonText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW");
                    DashboardView.this.newButton.setText(buttonText);
                }
            }
        });
        this.bar.add(this.combo1);
        this.bar.add(this.langPairButton);
        this.bar.add(this.combo2);
        if (!this.replacingFile) {
            this.bar2.add(Box.createHorizontalStrut(2));
            this.bar2.add(this.menuButton);
        }
        this.bar2.add(this.newButton);
        if (!this.addingFile) {
            this.bar2.add(this.goButton);
        }
        if (this.recentProjectsCombo != null) {
            this.bar2.add(Box.createHorizontalStrut(8));
            this.bar2.add(this.recentProjectsCombo);
        }
        this.sp0 = new JSplitPane();
        this.sp0.setResizeWeight(0.5);
        BasicSplitPaneUI ui = new BasicSplitPaneUI();
        this.sp0.setUI(ui);
        ui.getDivider().setBorder(null);
        this.sp0.setOpaque(false);
        if (AppPreferences.themeDashboard == null || AppPreferences.themeDashboard.equals("Coffeehouse")) {
            this.sp0.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        } else {
            this.sp0.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        this.sp0.setDividerSize(AppPreferences.dividerSize * 2);
        this.sp0.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JSplitPane spane = (JSplitPane)e.getComponent();
            }
        });
        this.sp1 = new JSplitPane();
        ui = new BasicSplitPaneUI();
        this.sp1.setUI(ui);
        ui.getDivider().setBorder(null);
        this.sp1.setOpaque(false);
        this.sp1.setBorder(BorderFactory.createEmptyBorder());
        this.sp1.setDividerSize(AppPreferences.dividerSize * 2);
        this.sp1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
        this.sp2 = new JSplitPane();
        ui = new BasicSplitPaneUI();
        this.sp2.setUI(ui);
        ui.getDivider().setBorder(null);
        this.sp2.setOpaque(false);
        this.sp2.setBorder(BorderFactory.createEmptyBorder());
        this.sp2.setDividerSize(AppPreferences.dividerSize * 2);
        this.sp3 = new JSplitPane();
        ui = new BasicSplitPaneUI();
        this.sp3.setUI(ui);
        ui.getDivider().setBorder(null);
        this.sp3.setOpaque(false);
        this.sp3.setBorder(BorderFactory.createEmptyBorder());
        this.sp3.setDividerSize(AppPreferences.dividerSize * 2);
        if (!this.addingFile) {
            GridPanel panel2 = new GridPanel();
            border = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, colorTitleBorder), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION MEMORIES") + " (TMX)", 3, 1, this.newButton.getFont().deriveFont(1), borderFontColor);
            panel2.setBorder(BorderFactory.createCompoundBorder(borderPanels, border));
            panel2.setBackground(colorPanels);
            panel2.setLayout(new BorderLayout());
            panel2.setOpaque(false);
            panel2.add((Component)this.barS, "South");
            scroll = new JScrollPane(this.segmentsPanel);
            scroll.setOpaque(false);
            scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
            scroll.getViewport().setOpaque(false);
            panel2.add((Component)scroll, "Center");
            if (AppPreferences.activeMenu7) {
                this.sp2.setLeftComponent(panel2);
            } else {
                this.sp1.setRightComponent(panel2);
            }
        }
        if (!this.addingFile) {
            panel3 = new GridPanel();
            border = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, colorTitleBorder), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES") + " (TXT)", 3, 1, this.newButton.getFont().deriveFont(1), borderFontColor);
            panel3.setBorder(BorderFactory.createCompoundBorder(borderPanels, border));
            panel3.setBackground(colorPanels);
            panel3.setLayout(new BorderLayout());
            panel3.setOpaque(false);
            panel3.add((Component)this.barP, "South");
            scroll = new JScrollPane(this.termsPanel);
            scroll.setOpaque(false);
            scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
            scroll.getViewport().setOpaque(false);
            panel3.add((Component)scroll, "Center");
            this.sp1.setLeftComponent(panel3);
        }
        if (!this.addingFile) {
            GridPanel panel1 = new GridPanel();
            border = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, colorTitleBorder), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FREE WEB RESOURCES AND IMAGES"), 3, 1, this.newButton.getFont().deriveFont(1), borderFontColor);
            panel1.setBorder(BorderFactory.createCompoundBorder(borderPanels, border));
            panel1.setBackground(colorPanels);
            panel1.setLayout(new BorderLayout());
            panel1.setOpaque(false);
            scroll = new JScrollPane(this.resourcesPanel);
            scroll.setOpaque(false);
            scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
            scroll.getViewport().setOpaque(false);
            panel1.add((Component)scroll, "Center");
            this.sp3.setLeftComponent(panel1);
            GridPanel panel2 = new GridPanel();
            border = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, colorTitleBorder), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OTHER RESOURCES AND SERVICES"), 3, 1, this.newButton.getFont().deriveFont(1), borderFontColor);
            panel2.setBorder(BorderFactory.createCompoundBorder(borderPanels, border));
            panel2.setBackground(colorPanels);
            panel2.setLayout(new BorderLayout());
            panel2.setOpaque(false);
            JScrollPane scroll2 = new JScrollPane(this.apiSericesPanel);
            scroll2.setOpaque(false);
            scroll2.setBorder(new EmptyBorder(0, 0, 0, 0));
            scroll2.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
            scroll2.getViewport().setOpaque(false);
            panel2.add((Component)scroll2, "Center");
            int cc = this.topui.getTabView().getComponentCount();
            if (cc == 2) {
                panel2.add(this.topui.getTabView().getComponent(1), "South");
            }
            this.sp3.setRightComponent(panel2);
        }
        if (!this.addingFile && AppPreferences.activeMenu7) {
            panel3 = new GridPanel();
            border = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, colorTitleBorder), "Total Recall (MEMORY STORAGE)", 3, 1, this.newButton.getFont().deriveFont(1), borderFontColor);
            panel3.setBorder(BorderFactory.createCompoundBorder(borderPanels, border));
            panel3.setBackground(colorPanels);
            panel3.setLayout(new BorderLayout());
            panel3.setOpaque(false);
            panel3.add((Component)this.barD, "South");
            scroll = new JScrollPane(this.databasePanel);
            scroll.setOpaque(false);
            scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
            scroll.getViewport().setOpaque(false);
            panel3.add((Component)scroll, "Center");
            this.sp2.setRightComponent(panel3);
        }
        this.menuBar = new JMenuBar();
        this.menuBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.menuBar.add(this.topui.getHelpMenu());
        this.topui.setJMenuBar(this.menuBar);
        JPanel mainBars = this.topui.getToolBarsPanel();
        if (mainBars.isDisplayable()) {
            this.topui.getMainPanel().remove(mainBars);
        }
        this.toolbars = new KodoBreathingPanel();
        this.toolbars.setOpaque(true);
        this.toolbars.setBackground(new Color(35, 35, 35));
        border = BorderFactory.createEmptyBorder(5, 5, 50, 5);
        this.toolbars.setBorder(border);
        this.toolbars.setLayout(new FlowLayout(0, 8, 8));
        this.toolbars.add(this.bar);
        this.toolbars.add(this.bar2);
        this.topui.getMainPanel().add((Component)this.toolbars, "North");
        this.sp2.setOrientation(0);
        this.sp3.setOrientation(0);
        if (AppPreferences.activeMenu7) {
            this.sp1.setRightComponent(this.sp3);
            this.sp0.setLeftComponent(this.sp2);
            this.sp0.setRightComponent(this.sp1);
        } else {
            this.sp1.setOrientation(0);
            this.sp0.setLeftComponent(this.sp1);
            this.sp0.setRightComponent(this.sp3);
        }
        if (!this.addingFile) {
            String n;
            ProjectTemplate pt = this.topui.getResourceLoader().getCurrentProjectTemplate();
            if (pt != null && (n = pt.getName()) != null) {
                int i = n.lastIndexOf(".");
                if (i != -1) {
                    n = n.substring(0, i);
                }
                this.tabTitle = n;
            }
            this.jTab = new JTabbedPane();
            this.jTab.setTabLayoutPolicy(1);
            this.jTab.setTabPlacement(1);
            if (!AppPreferences.laf.equals("Nimbus")) {
                this.jTab.setUI(new KodoTabbedPaneUI());
            }
            this.jTab.setBorder(new EmptyBorder(0, 10, 10, 10));
            this.jTab.add(this.tabTitle, this.sp0);
            TMTown tmtown = this.topui.getResourceView().getTMTownService();
            if (tmtown != null) {
                tmtown.removeView();
                this.jTab.add("TM-Town Resources", tmtown.getTMTownDocumentsView());
            }
            if (AppPreferences.laf.equals("Mac OS")) {
                this.jTab.setForeground(Color.BLACK);
            }
            this.jTab.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        int x = evt.getX();
                        int y = evt.getY();
                        int k = DashboardView.this.jTab.indexAtLocation(x, y);
                        if (k != -1) {
                            JPopupMenu pop = DashboardView.this.createPopUpMenu();
                            pop.show(evt.getComponent(), x + 2, y);
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        int x = evt.getX();
                        int y = evt.getY();
                        int k = DashboardView.this.jTab.indexAtLocation(x, y);
                        if (k != -1) {
                            JPopupMenu pop = DashboardView.this.createPopUpMenu();
                            pop.show(evt.getComponent(), x + 2, y);
                        }
                    }
                }
            });
            this.add((Component)this.jTab, "Center");
        }
        this.setDividersLocation();
        this.setDashboardFocusPolicy();
        this.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DashboardView.this.recentProjectsCombo != null) {
                    if (DashboardView.this.newButton.hasFocus()) {
                        DashboardView.this.newButton.doClick();
                    } else {
                        DashboardView.this.goButton.doClick();
                    }
                } else {
                    DashboardView.this.newButton.doClick();
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
    }

    public void setDatabaseTables(List list) {
        HashSet<String> lastTables = new HashSet<String>();
        if (AppPreferences.recallTables != null && AppPreferences.recallTables.length() > 0) {
            String[] s = AppPreferences.recallTables.split("\\|");
            for (int i = 0; i < s.length; ++i) {
                String string = s[i];
                if (string == null || string.length() <= 0) continue;
                lastTables.add(string);
            }
        }
        this.databasePanel.removeAll();
        for (Object object : list) {
            String name = object.toString();
            JCheckBox jBut = new JCheckBox(name);
            if (lastTables.contains(name)) {
                jBut.setSelected(true);
            }
            jBut.setForeground(this.panelsFontColor);
            jBut.setOpaque(false);
            jBut.setName(name);
            this.databasePanel.add(jBut);
        }
        if (!list.isEmpty()) {
            this.databasePanel.revalidate();
            this.databasePanel.repaint();
        }
    }

    private void setMemories(boolean refresh) {
        if (refresh) {
            this.segmentsPanel.removeAll();
        }
        JCheckBox mBut = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT MEMORY"));
        mBut.setForeground(this.panelsFontColor);
        mBut.setSelected(AppPreferences.projectTMX);
        mBut.setOpaque(false);
        mBut.setName("ProjectTM");
        mBut.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.projectTMX = e.getStateChange() == 1;
            }
        });
        List slist = this.topui.getResourceLoader().getLastSegmentMemories();
        final Collator usCollator = Collator.getInstance();
        usCollator.setStrength(0);
        Collections.sort(slist, new Comparator(){
            final /* synthetic */ DashboardView this$0;
            {
                this.this$0 = this$0;
            }

            public int compare(Object o1, Object o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                int i1 = s1.lastIndexOf(AppPreferences.fs);
                int i2 = s2.lastIndexOf(AppPreferences.fs);
                if (i1 != -1 && i2 != -1) {
                    s1 = s1.substring(i1 + 1);
                    s2 = s2.substring(i2 + 1);
                }
                return usCollator.compare(s1, s2);
            }
        });
        this.segmentsPanel.add(mBut);
        Iterator iterator = slist.iterator();
        while (iterator.hasNext()) {
            String infoPath = iterator.next().toString();
            if (infoPath == null || infoPath.length() <= 0) continue;
            File rfile = new File(infoPath);
            if (rfile.exists()) {
                int i = infoPath.lastIndexOf(AppPreferences.fs);
                if (i == -1) {
                    i = infoPath.lastIndexOf(47);
                }
                String text = null;
                if (i == -1 || infoPath.length() <= i) continue;
                text = infoPath.endsWith(".res") || infoPath.endsWith(".tmx") || infoPath.endsWith(".txt") ? infoPath.substring(i + 1, infoPath.length() - 4) : infoPath.substring(i + 1, infoPath.length());
                JCheckBox jBut = new JCheckBox(text);
                jBut.setForeground(this.panelsFontColor);
                Memory ntr = this.topui.getMemoryView().createSegmentsMemory(false);
                ntr.setPath(infoPath);
                jBut.putClientProperty("tm", ntr);
                jBut.setOpaque(false);
                jBut.setName(infoPath);
                jBut.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOAD RESOURCE:") + " " + infoPath);
                if (this.topui.getResourceLoader().isLastSessionResource(infoPath)) {
                    jBut.setSelected(true);
                }
                jBut.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            JCheckBox button = (JCheckBox)e.getSource();
                            DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 1);
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            JCheckBox button = (JCheckBox)e.getSource();
                            DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 1);
                        }
                    }
                });
                this.segmentsPanel.add(jBut);
                continue;
            }
            iterator.remove();
        }
        if (refresh) {
            this.segmentsPanel.revalidate();
            this.segmentsPanel.repaint();
        }
    }

    private void setGlossaries(boolean refresh) {
        if (refresh) {
            this.termsPanel.removeAll();
        }
        List glist = this.topui.getResourceLoader().getLastGlossaries();
        final Collator usCollator = Collator.getInstance();
        usCollator.setStrength(0);
        Collections.sort(glist, new Comparator(){
            final /* synthetic */ DashboardView this$0;
            {
                this.this$0 = this$0;
            }

            public int compare(Object o1, Object o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                int i1 = s1.lastIndexOf(AppPreferences.fs);
                int i2 = s2.lastIndexOf(AppPreferences.fs);
                if (i1 != -1 && i2 != -1) {
                    s1 = s1.substring(i1 + 1);
                    s2 = s2.substring(i2 + 1);
                }
                return usCollator.compare(s1, s2);
            }
        });
        JCheckBox mBut = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT GLOSSARY"));
        mBut.setForeground(this.panelsFontColor);
        mBut.setSelected(AppPreferences.projectGlossary);
        mBut.setOpaque(false);
        mBut.setName("ProjectTerms");
        mBut.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.projectGlossary = e.getStateChange() == 1;
            }
        });
        this.termsPanel.add(mBut);
        Iterator iterator = glist.iterator();
        while (iterator.hasNext()) {
            String infoPath = iterator.next().toString();
            if (infoPath == null || infoPath.length() <= 0) continue;
            File rfile = new File(infoPath);
            if (rfile.exists()) {
                int i = infoPath.lastIndexOf(AppPreferences.fs);
                if (i == -1) {
                    i = infoPath.lastIndexOf(47);
                }
                String text = null;
                if (i == -1 || infoPath.length() <= i) continue;
                text = infoPath.endsWith(".res") ? infoPath.substring(i + 1, infoPath.length() - 4) : infoPath.substring(i + 1, infoPath.length());
                JCheckBox jBut = new JCheckBox(text);
                jBut.setForeground(this.panelsFontColor);
                jBut.putClientProperty("type", "glossary");
                jBut.setOpaque(false);
                jBut.setName(infoPath);
                jBut.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOAD RESOURCE:") + " " + text);
                if (this.topui.getResourceLoader().isLastSessionResource(infoPath)) {
                    jBut.setSelected(true);
                }
                jBut.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            JCheckBox button = (JCheckBox)e.getSource();
                            DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 3);
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            JCheckBox button = (JCheckBox)e.getSource();
                            DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 3);
                        }
                    }
                });
                this.termsPanel.add(jBut);
                continue;
            }
            iterator.remove();
        }
        if (refresh) {
            this.termsPanel.revalidate();
            this.termsPanel.repaint();
        }
    }

    private void setResources(boolean refresh) {
        List rlist;
        if (refresh) {
            this.resourcesPanel.removeAll();
        }
        if ((rlist = this.topui.getResourceLoader().getLastResources()).isEmpty()) {
            String webResPath = AppPreferences.packagePath + "infos/resources/Internet";
            File file = new File(webResPath);
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String p;
                File file1 = files[i];
                if (file1.isDirectory() || !(p = file1.getPath()).endsWith(".res")) continue;
                rlist.add(p);
            }
        }
        final Collator usCollator = Collator.getInstance();
        usCollator.setStrength(0);
        Collections.sort(rlist, new Comparator(){
            final /* synthetic */ DashboardView this$0;
            {
                this.this$0 = this$0;
            }

            public int compare(Object o1, Object o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                int i1 = s1.lastIndexOf(AppPreferences.fs);
                int i2 = s2.lastIndexOf(AppPreferences.fs);
                if (i1 != -1 && i2 != -1) {
                    s1 = s1.substring(i1 + 1);
                    s2 = s2.substring(i2 + 1);
                }
                return usCollator.compare(s1, s2);
            }
        });
        HashSet<String> uniqueFileNames = new HashSet<String>();
        Iterator iterator = rlist.iterator();
        while (iterator.hasNext()) {
            String infoPath = iterator.next().toString();
            if (infoPath == null || infoPath.length() <= 0) continue;
            File rfile = new File(infoPath);
            if (rfile.exists()) {
                String fname = rfile.getName();
                if (uniqueFileNames.contains(fname)) {
                    iterator.remove();
                    continue;
                }
                int i = infoPath.lastIndexOf(AppPreferences.fs);
                if (i == -1) {
                    i = infoPath.lastIndexOf(47);
                }
                String text = null;
                if (i == -1 || infoPath.length() <= i) continue;
                text = infoPath.endsWith(".res") || infoPath.endsWith(".tmx") ? infoPath.substring(i + 1, infoPath.length() - 4) : infoPath.substring(i + 1, infoPath.length());
                uniqueFileNames.add(fname);
                JCheckBox jBut = new JCheckBox(text);
                jBut.setForeground(this.panelsFontColor);
                jBut.setOpaque(false);
                jBut.setName(infoPath);
                jBut.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOAD RESOURCE:") + " " + text);
                if (this.topui.getResourceLoader().isLastSessionResource(infoPath)) {
                    jBut.setSelected(true);
                }
                jBut.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            JCheckBox button = (JCheckBox)e.getSource();
                            DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 0);
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            JCheckBox button = (JCheckBox)e.getSource();
                            DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 0);
                        }
                    }
                });
                this.resourcesPanel.add(jBut);
                continue;
            }
            iterator.remove();
        }
        if (refresh) {
            this.resourcesPanel.revalidate();
            this.resourcesPanel.repaint();
        }
    }

    void setServices(boolean refresh) {
        JCheckBox ms2But;
        JCheckBox ms1But;
        if (refresh) {
            this.apiSericesPanel.removeAll();
        }
        JCheckBox wsBut = new JCheckBox("ProZ.com services (term search, KudoZ, etc)");
        wsBut.setForeground(this.panelsFontColor);
        wsBut.setOpaque(false);
        wsBut.setName("API: ProZ.com");
        if (AppPreferences.webServiceProz != null && AppPreferences.webServiceProz.equals("Proz")) {
            wsBut.setSelected(true);
        }
        wsBut.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.prozUIClosed = false;
                    if (DashboardView.this.topui.getResourceView().getProzService() == null) {
                        AppPreferences.webServiceProz = "Proz";
                        DashboardView.this.topui.getResourceView().setProzService(AppPreferences.webServiceProz);
                        DashboardView.this.topui.getResourceView().getProzService().showLoginFrame();
                    } else {
                        DashboardView.this.topui.getResourceView().getProzService().showLoginFrame();
                    }
                } else if (AppPreferences.prozUIClosed) {
                    AppPreferences.prozUIClosed = false;
                    if (DashboardView.this.topui.getResourceView().getProzService() != null) {
                        DashboardView.this.topui.getResourceView().getProzService().createView();
                    }
                }
            }
        });
        JCheckBox ws2But = new JCheckBox("TM-Town services (segment search, term search, etc.)");
        ws2But.setForeground(this.panelsFontColor);
        ws2But.setOpaque(false);
        ws2But.setName("API: TM-Town");
        if (AppPreferences.webServiceTMTown != null && AppPreferences.webServiceTMTown.equals("TMTown")) {
            ws2But.setSelected(true);
        }
        ws2But.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (DashboardView.this.topui.getResourceView().getTMTownService() == null) {
                        AppPreferences.webServiceTMTown = "TMTown";
                        DashboardView.this.topui.getResourceView().setTMTownService(AppPreferences.webServiceTMTown);
                        DashboardView.this.topui.getResourceView().getTMTownService().showLoginFrame();
                    } else {
                        DashboardView.this.topui.getResourceView().getTMTownService().showLoginFrame();
                    }
                }
            }
        });
        this.apiSericesPanel.add(wsBut);
        this.apiSericesPanel.add(ws2But);
        if (AppPreferences.aiServices != -1) {
            ms1But = new JCheckBox("AI services (ChatGPT, Claude, Gemini)");
            ms1But.setForeground(this.panelsFontColor);
            ms1But.setOpaque(false);
            ms1But.setName("API: ChatGPT");
            if (AppPreferences.aiServices == 1) {
                ms1But.setSelected(true);
            }
            this.apiSericesPanel.add(ms1But);
        }
        if (AppPreferences.webServiceAmazonPolly != -1) {
            ms1But = new JCheckBox("Amazon Polly (Text To Speech web service)");
            ms1But.setForeground(this.panelsFontColor);
            ms1But.setOpaque(false);
            ms1But.setName("API: Amazon Polly");
            if (AppPreferences.webServiceAmazonPolly == 1) {
                ms1But.setSelected(true);
            }
            this.apiSericesPanel.add(ms1But);
        }
        if (AppPreferences.mt3 != -1) {
            ms1But = new JCheckBox("MyMemory (Online Machine Translation)");
            ms1But.setForeground(this.panelsFontColor);
            ms1But.setOpaque(false);
            ms1But.setName("API: MyMemory");
            if (AppPreferences.mt3 == 1) {
                ms1But.setSelected(true);
            }
            this.apiSericesPanel.add(ms1But);
        }
        if (AppPreferences.mt2 != -1) {
            ms2But = new JCheckBox("Microsoft Translator (Online Machine Translation)");
            ms2But.setForeground(this.panelsFontColor);
            ms2But.setOpaque(false);
            ms2But.setName("API: Microsoft Translator");
            if (AppPreferences.mt2 == 1) {
                ms2But.setSelected(true);
            }
            this.apiSericesPanel.add(ms2But);
        }
        if (AppPreferences.mt != -1) {
            ms2But = new JCheckBox("Google Translate (Online Machine Translation)");
            ms2But.setForeground(this.panelsFontColor);
            ms2But.setOpaque(false);
            ms2But.setName("API: Google Translate");
            if (AppPreferences.mt == 1) {
                ms2But.setSelected(true);
            }
            this.apiSericesPanel.add(ms2But);
        }
        if (AppPreferences.mt6 != -1) {
            ms2But = new JCheckBox("DeepL (Online Machine Translation)");
            ms2But.setForeground(this.panelsFontColor);
            ms2But.setOpaque(false);
            ms2But.setName("API: DeepL");
            if (AppPreferences.mt6 == 1) {
                ms2But.setSelected(true);
            }
            this.apiSericesPanel.add(ms2But);
        }
        if (AppPreferences.mt7 != -1) {
            ms2But = new JCheckBox("IBM Watson (Online Machine Translation)");
            ms2But.setForeground(this.panelsFontColor);
            ms2But.setOpaque(false);
            ms2But.setName("API: Watson");
            if (AppPreferences.mt7 == 1) {
                ms2But.setSelected(true);
            }
            this.apiSericesPanel.add(ms2But);
        }
        if (AppPreferences.mt8 != -1) {
            ms2But = new JCheckBox("Amazon Translate (Online Machine Translation)");
            ms2But.setForeground(this.panelsFontColor);
            ms2But.setOpaque(false);
            ms2But.setName("API: Amazon Translate");
            if (AppPreferences.mt8 == 1) {
                ms2But.setSelected(true);
            }
            this.apiSericesPanel.add(ms2But);
        }
        if (AppPreferences.mt5 != -1) {
            ms2But = new JCheckBox("Yandex Translate (Online Machine Translation)");
            ms2But.setForeground(this.panelsFontColor);
            ms2But.setOpaque(false);
            ms2But.setName("API: Yandex Translate");
            if (AppPreferences.mt5 == 1) {
                ms2But.setSelected(true);
            }
            this.apiSericesPanel.add(ms2But);
        }
        if (AppPreferences.mt4 != -1) {
            ms2But = new JCheckBox("Slate Desktop (Local Machine Translation)");
            ms2But.setForeground(this.panelsFontColor);
            ms2But.setOpaque(false);
            ms2But.setName("API: Slate Desktop");
            if (AppPreferences.mt4 == 1) {
                ms2But.setSelected(true);
            }
            this.apiSericesPanel.add(ms2But);
        }
        if (refresh) {
            this.apiSericesPanel.revalidate();
            this.apiSericesPanel.repaint();
        }
    }

    private void setDividersLocation() {
        if (AppPreferences.dashboardDivider1 == -1 || AppPreferences.dashboardDivider2 == -1 || AppPreferences.dashboardDivider3 == -1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AppPreferences.activeMenu7) {
                        DashboardView.this.sp0.setDividerLocation(0.33);
                    } else {
                        DashboardView.this.sp0.setDividerLocation(0.5);
                    }
                    DashboardView.this.sp1.setDividerLocation(0.5);
                    DashboardView.this.sp2.setDividerLocation(0.5);
                    DashboardView.this.sp3.setDividerLocation(0.5);
                }
            });
        } else {
            this.sp0.setDividerLocation(AppPreferences.dashboardDivider3);
            this.sp1.setDividerLocation(AppPreferences.dashboardDivider);
            this.sp2.setDividerLocation(AppPreferences.dashboardDivider1);
            this.sp3.setDividerLocation(AppPreferences.dashboardDivider2);
        }
    }

    void getDividersLocation() {
        AppPreferences.dashboardDivider = this.sp1.getDividerLocation();
        AppPreferences.dashboardDivider1 = this.sp2.getDividerLocation();
        AppPreferences.dashboardDivider2 = this.sp3.getDividerLocation();
        AppPreferences.dashboardDivider3 = this.sp0.getDividerLocation();
    }

    public void newDashboard() {
        JCheckBox but;
        int i;
        Component[] comps = this.segmentsPanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JCheckBox) || i == 0 || !(but = (JCheckBox)comps[i]).isSelected()) continue;
            but.setSelected(false);
        }
        comps = this.termsPanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JCheckBox) || i == 0 || !(but = (JCheckBox)comps[i]).isSelected()) continue;
            but.setSelected(false);
        }
        comps = this.databasePanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JCheckBox) || !(but = (JCheckBox)comps[i]).isSelected()) continue;
            but.setSelected(false);
        }
        ResourceLoader rl = this.topui.getResourceLoader();
        rl.closeProjectTemplate();
        if (this.jTab != null) {
            this.jTab.setTitleAt(0, "Resources");
        }
    }

    public void closeDashboard() {
        this.getDividersLocation();
        if (this.jTab != null) {
            this.jTab.removeAll();
        }
        this.topui.removeDashboard();
        this.topui.setMainPanelFocusPolicy();
    }

    private void newProject(int i, boolean directory) {
        if (i == 0) {
            this.addDocument(directory);
        } else if (i == 1) {
            this.showProjectFile(this.projectFile, 3, true);
        } else if (i == 4) {
            this.gatherResources();
            this.gatherMemories();
            this.gatherTotalRecallTables();
            ProjectView prview = this.topui.getProjectView();
            prview.openProject(2, directory);
        } else if (i == 2) {
            this.gatherResources();
            this.gatherMemories();
            this.gatherTotalRecallTables();
            ProjectView prview = this.topui.getProjectView();
            prview.openProject(1, directory);
        } else if (i == 3) {
            this.showProjectFile(this.projectFile, 2, true);
        } else if (i == 5) {
            this.showProjectFile(this.projectFile, 4, true);
        } else if (i == 6) {
            this.showProjectFile(this.projectFile, 5, true);
        }
    }

    private void gatherResources() {
        MatchBoard mb;
        JCheckBox but;
        int i;
        if (this.addingFile) {
            return;
        }
        ResourceLoader loader = this.topui.getResourceLoader();
        loader.clearLastSessionResources();
        HashSet<String> set = new HashSet<String>();
        Component[] comps = this.resourcesPanel.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            String name;
            JCheckBox but2;
            if (!(comps[i2] instanceof JCheckBox) || !(but2 = (JCheckBox)comps[i2]).isSelected() || (name = but2.getName()) == null) continue;
            set.add(name);
        }
        boolean chatGPTService = false;
        boolean AmazonTranslateService = false;
        boolean AmazonPollyService = false;
        boolean WatsonService = false;
        boolean DeepLService = false;
        boolean MTService = false;
        boolean GTService = false;
        boolean myMemoryService = false;
        boolean YandexService = false;
        boolean slateDesktopService = false;
        boolean tmTownService = false;
        boolean prozService = false;
        comps = this.apiSericesPanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            String name;
            if (!(comps[i] instanceof JCheckBox) || !(but = (JCheckBox)comps[i]).isSelected() || (name = but.getName()) == null) continue;
            if (name.equals("API: TM-Town")) {
                tmTownService = true;
                continue;
            }
            if (name.equals("API: ProZ.com")) {
                prozService = true;
                continue;
            }
            if (name.equals("API: MyMemory")) {
                myMemoryService = true;
                continue;
            }
            if (name.equals("API: Google Translate")) {
                GTService = true;
                continue;
            }
            if (name.equals("API: DeepL")) {
                DeepLService = true;
                continue;
            }
            if (name.equals("API: Microsoft Translator")) {
                MTService = true;
                continue;
            }
            if (name.equals("API: Watson")) {
                WatsonService = true;
                continue;
            }
            if (name.equals("API: Amazon Translate")) {
                AmazonTranslateService = true;
                continue;
            }
            if (name.equals("API: Amazon Polly")) {
                AmazonPollyService = true;
                continue;
            }
            if (name.equals("API: Yandex Translate")) {
                YandexService = true;
                continue;
            }
            if (name.equals("API: Slate Desktop")) {
                slateDesktopService = true;
                continue;
            }
            if (!name.equals("API: ChatGPT")) continue;
            chatGPTService = true;
        }
        comps = this.termsPanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            String type;
            if (!(comps[i] instanceof JCheckBox) || i == 0 || !(but = (JCheckBox)comps[i]).isSelected() || (type = (String)but.getClientProperty("type")) == null || !type.equals("glossary")) continue;
            set.add(but.getName());
        }
        if (set.size() > 0) {
            loader.prepareLoaderResources(set);
        }
        if (myMemoryService) {
            if (this.topui.getResourceView().getMT3() == null) {
                AppPreferences.mt3 = 1;
                this.topui.getResourceView().setMT3("MyMemory");
            }
        } else if (AppPreferences.mt3 != -1) {
            AppPreferences.mt3 = 0;
        }
        if (MTService) {
            if (this.topui.getResourceView().getMT2() == null) {
                AppPreferences.mt2 = 1;
                this.topui.getResourceView().setMT2("Bing");
            }
        } else if (AppPreferences.mt2 != -1) {
            AppPreferences.mt2 = 0;
        }
        if (GTService) {
            if (this.topui.getResourceView().getMT() == null) {
                AppPreferences.mt = 1;
                this.topui.getResourceView().setMT("Google");
            }
        } else if (AppPreferences.mt != -1) {
            AppPreferences.mt = 0;
        }
        if (DeepLService) {
            if (this.topui.getResourceView().getMT6() == null) {
                AppPreferences.mt6 = 1;
                this.topui.getResourceView().setMT6("DeepL");
            }
        } else if (AppPreferences.mt6 != -1) {
            AppPreferences.mt6 = 0;
        }
        if (WatsonService) {
            if (this.topui.getResourceView().getMT7() == null) {
                AppPreferences.mt7 = 1;
                this.topui.getResourceView().setMT7("Watson");
            }
        } else if (AppPreferences.mt7 != -1) {
            AppPreferences.mt7 = 0;
        }
        if (AmazonTranslateService) {
            if (this.topui.getResourceView().getMT8() == null) {
                AppPreferences.mt8 = 1;
                this.topui.getResourceView().setMT8("Amazon");
            }
        } else if (AppPreferences.mt8 != -1) {
            AppPreferences.mt8 = 0;
        }
        if (YandexService) {
            if (this.topui.getResourceView().getMT5() == null) {
                AppPreferences.mt5 = 1;
                this.topui.getResourceView().setMT5("Yandex");
            }
        } else if (AppPreferences.mt5 != -1) {
            AppPreferences.mt5 = 0;
        }
        if (slateDesktopService) {
            if (this.topui.getResourceView().getMT4() == null) {
                AppPreferences.mt4 = 1;
                this.topui.getResourceView().setMT4("SlateDesktop");
            }
        } else if (AppPreferences.mt4 != -1) {
            AppPreferences.mt4 = 0;
        }
        if (chatGPTService) {
            if (this.topui.getResourceView().getCTLinguist() == null) {
                AppPreferences.aiServices = 1;
                this.topui.getResourceView().setCTLinguist(1);
            }
        } else if (AppPreferences.aiServices != -1) {
            AppPreferences.aiServices = 0;
        }
        if (AmazonPollyService) {
            if (this.topui.getResourceView().getAmazonTTSService() == null) {
                AppPreferences.webServiceAmazonPolly = 1;
                this.topui.getResourceView().setAmazonTTSService(1);
            }
        } else if (AppPreferences.webServiceAmazonPolly != -1) {
            AppPreferences.webServiceAmazonPolly = 0;
        }
        if (tmTownService) {
            if (this.topui.getResourceView().getTMTownService() == null) {
                AppPreferences.webServiceTMTown = "TMTown";
                this.topui.getResourceView().setTMTownService(AppPreferences.webServiceTMTown);
            }
        } else {
            AppPreferences.webServiceTMTown = "";
            if (this.topui.getResourceView().getTMTownService() != null) {
                this.topui.getResourceView().getTMTownService().closeResource();
            }
        }
        if (prozService) {
            if (this.topui.getResourceView().getProzService() == null) {
                AppPreferences.webServiceProz = "Proz";
                this.topui.getResourceView().setProzService(AppPreferences.webServiceProz);
            }
            if (AppPreferences.prozWiwoAutoPopup && this.topui.getResourceView().getProzService() != null) {
                this.topui.getResourceView().getProzService().activateWiwo();
            }
        } else {
            AppPreferences.webServiceProz = "";
            if (this.topui.getResourceView().getProzService() != null) {
                this.topui.getResourceView().getProzService().closeResource();
            }
        }
        if ((mb = this.topui.getMatchBoard()) != null) {
            mb.createMatchesTables();
        }
    }

    private void gatherMemories() {
        if (this.addingFile) {
            return;
        }
        HashSet<Memory> set = new HashSet<Memory>();
        Component[] comps = this.segmentsPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            String path;
            Memory ntr;
            JCheckBox but;
            if (!(comps[i] instanceof JCheckBox) || i == 0 || !(but = (JCheckBox)comps[i]).isSelected() || (ntr = (Memory)but.getClientProperty("tm")) == null || (path = ntr.getPath()) == null || path.length() <= 0) continue;
            ntr.setMainView(this.topui);
            ntr.setPath(path);
            File file = new File(path);
            if (file.isDirectory()) {
                ntr.setReadOnly(true);
            }
            set.add(ntr);
        }
        if (set.size() > 0) {
            this.topui.getResourceLoader().prepareLoaderMemories(set);
        }
    }

    private void gatherTotalRecallTables() {
        if (this.addingFile) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Component[] comps = this.databasePanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            String n;
            JCheckBox but;
            if (!(comps[i] instanceof JCheckBox) || !(but = (JCheckBox)comps[i]).isSelected() || (n = but.getText()) == null || n.length() <= 0) continue;
            list.add(n);
            if (sb.length() + n.length() >= 8192) continue;
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(n);
        }
        AppPreferences.recallTables = sb.toString();
        if (list.size() > 0) {
            Memory m = (Memory)this.databasePanel.getClientProperty("memory");
            m.setDatabaseTableNames(list);
            this.topui.getMemoryView().setTotalRecallMemory(m);
        } else {
            this.topui.getMemoryView().setTotalRecallMemory(null);
        }
    }

    private void loadProjectFile(String p) {
        WorkflowView wview = this.topui.getWorkflowView();
        WorkflowManager manager = wview.getWorkflowManager();
        manager.endTranslation();
        this.closeDashboard();
        this.gatherResources();
        this.gatherMemories();
        this.gatherTotalRecallTables();
        ProjectView prview = this.topui.getProjectView();
        File file = new File(p);
        AppPreferences.projectDirectory = !file.isDirectory() ? file.getParent() : file.getPath();
        prview.prepareProject(p);
    }

    public void showProjectFile(XliffFile file, int mode, boolean isNew) {
        XliffFileEditor dlg = new XliffFileEditor(this.topui, file, mode, isNew, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT CONFIGURATION"));
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2, (frmSize.height - dlgSize.height) / 2);
        dlg.setVisible(true);
        if (!dlg.cancelled) {
            this.closeDashboard();
            this.gatherResources();
            this.gatherMemories();
            this.gatherTotalRecallTables();
            if (!this.replacingFile) {
                this.xliffmenu.createProjectFile(file, this.addingFile);
            } else {
                this.xliffmenu.replaceProjectFile(file);
            }
        }
    }

    private void addDocument(final boolean folder) {
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ DashboardView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        if (!folder) {
                            FileChooser fileChooser = new FileChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A SOURCE DOCUMENT"));
                            File f = new File(AppPreferences.sourceFilesDirectory);
                            if (f.isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showOpenDialog(null);
                        } else {
                            DirectoryChooser fileChooser = new DirectoryChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE SOURCE DOCUMENTS FOLDER"));
                            File f = new File(AppPreferences.sourceFilesDirectory);
                            if (f.isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showDialog(null);
                        }
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 31 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this$0.addSourceDocument(file);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 31 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A SOURCE DOCUMENT"));
            File f = new File(AppPreferences.sourceFilesDirectory);
            if (f.isDirectory()) {
                jFileChooser.setCurrentDirectory(f);
            }
            if (0 == jFileChooser.showOpenDialog(this.topui)) {
                FileFilter filter = jFileChooser.getFileFilter();
                String desc = filter.getDescription();
                if (desc.equals("All Files")) {
                    desc = "Text";
                }
                final File file = jFileChooser.getSelectedFile();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ DashboardView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.addSourceDocument(file);
                    }
                });
            }
        }
    }

    private void addSourceDocument(File file) {
        String fileName = file.getPath();
        if (fileName != null) {
            boolean bilingual = false;
            if (file.isDirectory()) {
                String[] files = file.list();
                for (int i = 0; i < files.length; ++i) {
                    String n = files[i].toLowerCase();
                    if (!n.endsWith(".xlf") && !n.endsWith(".sdlxliff") && !n.endsWith(".tmx") && !n.endsWith(".ttx") && !n.endsWith(".xliff") && !n.endsWith(".ctp") && !n.endsWith(".sdlppx") && !n.endsWith(".mqxlz") && !n.endsWith(".mqxliff") && !n.endsWith(".mxliff") && !n.endsWith(".txml") && !n.endsWith(".txlf")) continue;
                    bilingual = true;
                    break;
                }
            }
            String n = fileName.toLowerCase();
            if (bilingual || n.endsWith(".xlf") || n.endsWith(".sdlxliff") || n.endsWith(".tmx") || n.endsWith(".ttx") || n.endsWith(".xliff") || n.endsWith(".ctp") || n.endsWith(".sdlppx") || n.endsWith(".mqxlz") || n.endsWith(".mqxliff") || n.endsWith(".mxliff") || n.endsWith(".txml") || n.endsWith(".txlf")) {
                if (n.endsWith(".tmx") && !this.addingFile) {
                    Object[] options = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT TRANSLATION MEMORY"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN TRANSLATION MEMORY")};
                    int i = JOptionPane.showOptionDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE MEMORY WORKING MODE"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TMX MEMORY"), 0, 1, null, options, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION MEMORY"));
                    if (i == 0) {
                        this.loadProjectFile(fileName);
                    } else if (i == 1) {
                        this.setTM(file);
                    }
                } else {
                    this.loadProjectFile(fileName);
                }
            } else if (file.isDirectory()) {
                this.showProjectFileDnD(this.projectFile, 0, true, file, AppPreferences.format);
            } else if (n.endsWith("update.zip") || n.endsWith("update.jar")) {
                AboutDialog about = new AboutDialog(this.topui);
                about.installZip(file);
                System.exit(0);
            } else if (n.endsWith(".jar")) {
                AboutDialog about = new AboutDialog(this.topui);
                about.installJar(file);
                System.exit(0);
            } else {
                int dot = n.lastIndexOf(46);
                if (dot != -1) {
                    String ext = n.substring(dot);
                    String dtype = FormatChooser.getDataTypeForExtension(ext);
                    String format = FormatChooser.getFormatType(dtype);
                    int docType = 0;
                    this.showProjectFileDnD(this.projectFile, docType, true, file, format);
                }
            }
        }
    }

    public void showProjectFileDnD(XliffFile file, int mode, boolean isNew, File sourceFile, String filter) {
        XliffFileEditor dlg = new XliffFileEditor(this.topui, file, mode, isNew, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT CONFIGURATION"));
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2, (frmSize.height - dlgSize.height) / 2);
        dlg.selectSourceFile(sourceFile, filter);
        dlg.setVisible(true);
        if (!dlg.cancelled) {
            this.closeDashboard();
            this.gatherResources();
            this.gatherMemories();
            this.gatherTotalRecallTables();
            if (!this.replacingFile) {
                this.xliffmenu.createProjectFile(file, this.addingFile);
            } else {
                this.xliffmenu.replaceProjectFile(file);
            }
        }
    }

    private void showTMFileChooser(final boolean directory) {
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ DashboardView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        if (!directory) {
                            File f;
                            FileChooser fileChooser = new FileChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MEMORY"));
                            if (AppPreferences.memoryDirectory != null && AppPreferences.memoryDirectory.length() > 0 && (f = new File(AppPreferences.memoryDirectory)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showOpenDialog(null);
                        } else {
                            File f;
                            DirectoryChooser fileChooser = new DirectoryChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MEMORY"));
                            if (AppPreferences.memoryDirectory != null && AppPreferences.memoryDirectory.length() > 0 && (f = new File(AppPreferences.memoryDirectory)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showDialog(null);
                        }
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 33 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    String name = file.getName().toLowerCase();
                                    if (name.endsWith(".tmx") || name.endsWith(".txt") || file.isDirectory()) {
                                        this.this$1.this$0.setTM(file);
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 33 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            File file;
            String name;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A MEMORY FILE OR FOLDER"));
            jFileChooser.setCurrentDirectory(new File(AppPreferences.memoryDirectory));
            jFileChooser.repaint();
            if (0 == jFileChooser.showOpenDialog(this.topui) && ((name = (file = jFileChooser.getSelectedFile()).getName().toLowerCase()).endsWith(".tmx") || name.endsWith(".txt") || file.isDirectory())) {
                this.setTM(file);
            }
        }
    }

    private void setTM(File file) {
        String path = file.getPath();
        String s = file.getName();
        int i = s.indexOf(46);
        if (i != -1) {
            s = s.substring(0, i);
        }
        JCheckBox jBut = new JCheckBox(s);
        jBut.setForeground(this.panelsFontColor);
        jBut.setOpaque(false);
        jBut.setName(path);
        jBut.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOAD RESOURCE:") + " " + path);
        jBut.setSelected(true);
        boolean k = true;
        Memory ntr = this.topui.getMemoryView().setMemoryDefaultOptions();
        if (ntr != null) {
            ntr.setPath(path);
            this.topui.getResourceLoader().addSegmentMemory(path);
            jBut.putClientProperty("tm", ntr);
            this.segmentsPanel.add(jBut);
            this.segmentsPanel.revalidate();
            this.segmentsPanel.repaint();
            jBut.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JCheckBox button = (JCheckBox)e.getSource();
                        DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 1);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JCheckBox button = (JCheckBox)e.getSource();
                        DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 1);
                    }
                }
            });
        }
    }

    public void addNewMemory(Memory TM) {
        String path = TM.getPath();
        this.topui.getResourceLoader().addSegmentMemory(path);
        int i = path.lastIndexOf(AppPreferences.fs);
        if (i == -1) {
            i = path.lastIndexOf(47);
        }
        String text = null;
        text = i != -1 && path.length() > i ? (path.endsWith(".tmx") ? path.substring(i + 1, path.length() - 4) : path.substring(i + 1, path.length())) : path;
        JCheckBox jBut = new JCheckBox(text);
        jBut.putClientProperty("tm", TM);
        jBut.setOpaque(false);
        jBut.setForeground(this.panelsFontColor);
        jBut.setSelected(true);
        jBut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JCheckBox button = (JCheckBox)e.getSource();
                    DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 1);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JCheckBox button = (JCheckBox)e.getSource();
                    DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 1);
                }
            }
        });
        this.segmentsPanel.add(jBut);
        this.segmentsPanel.revalidate();
        this.segmentsPanel.repaint();
    }

    private void addGlossary(final boolean isNew) {
        String wloc;
        File f;
        final String loc = AppPreferences.glossaryDir.length() > 0 ? AppPreferences.glossaryDir : (AppPreferences.operatingSystem == 0 ? (!(f = new File(wloc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists() ? System.getProperty("user.home") : wloc) : System.getProperty("user.home"));
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ DashboardView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        if (!this.this$0.mergeGlossaries) {
                            File f;
                            FileChooser fileChooser = new FileChooser();
                            if (loc != null && loc.length() > 0 && (f = new File(loc)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            if (isNew) {
                                String n;
                                int dot;
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY NAME"));
                                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("TEXT files (*.txt)", new String[]{"*.txt"});
                                fileChooser.getExtensionFilters().add((Object)extFilter);
                                file = fileChooser.showSaveDialog(null);
                                if (file != null && (dot = (n = file.getName()).indexOf(46)) == -1) {
                                    file.renameTo(new File(file.getPath() + ".txt"));
                                }
                            } else {
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                                file = fileChooser.showOpenDialog(null);
                            }
                        } else {
                            File f;
                            DirectoryChooser fileChooser = new DirectoryChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                            if (loc != null && loc.length() > 0 && (f = new File(loc)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showDialog(null);
                        }
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 36 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this$0.showGlossaryInfoPanel(file, this.this$1.isNew);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 36 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            int option;
            JFileChooser jch = new JFileChooser(loc);
            if (isNew) {
                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY NAME"));
                option = jch.showSaveDialog(this.topui);
            } else {
                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                jch.setFileSelectionMode(2);
                option = jch.showOpenDialog(this.topui);
            }
            if (option == 0) {
                File file = jch.getSelectedFile();
                this.showGlossaryInfoPanel(file, isNew);
            }
        }
    }

    private void showGlossaryInfoPanel(File file, boolean isNew) {
        String parent;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.topui, ex.getMessage());
                Logger.getLogger(NewResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((parent = file.getParent()) != null) {
            AppPreferences.glossaryDir = parent;
        }
        String resourcePath = null;
        try {
            resourcePath = file.toURI().toURL().getPath();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        if (resourcePath != null && resourcePath.startsWith(AppPreferences.packagePath + "resources")) {
            resourcePath = resourcePath.substring(AppPreferences.packagePath.length());
            resourcePath = resourcePath.replaceAll("%20", " ");
        } else {
            resourcePath = file.getPath();
            if (file.isDirectory()) {
                resourcePath = resourcePath + AppPreferences.fs;
            } else if (!file.exists() && resourcePath.indexOf(46) == -1) {
                resourcePath = resourcePath + ".txt";
            }
        }
        String title = isNew ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW GLOSSARY") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD GLOSSARY");
        String rp = AppPreferences.packagePath + "forms/GlossaryAddResource";
        NewResource dlg = new NewResource(this.topui, title, rp, 9);
        dlg.chooseGlossary(resourcePath);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point ploc = this.topui.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + ploc.x, (frmSize.height - dlgSize.height) / 2 + ploc.y);
        dlg.setVisible(true);
        boolean approve = dlg.approve;
        String s = dlg.infoPath;
        if (approve) {
            this.addGlossaryCheckBox(s);
        }
    }

    private void addGlossaryCheckBox(String path) {
        File file = new File(path);
        path = file.getPath();
        String s = file.getName();
        int i = s.indexOf(46);
        if (i != -1) {
            s = s.substring(0, i);
        }
        this.topui.getResourceLoader().addGlossary(path);
        JCheckBox jBut = new JCheckBox(s);
        jBut.setForeground(this.panelsFontColor);
        jBut.setOpaque(false);
        jBut.setName(path);
        jBut.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOAD RESOURCE:") + " " + path);
        jBut.setSelected(true);
        int k = 3;
        jBut.putClientProperty("type", "glossary");
        this.termsPanel.add(jBut);
        this.termsPanel.revalidate();
        this.termsPanel.repaint();
        jBut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JCheckBox button = (JCheckBox)e.getSource();
                    DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 3);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JCheckBox button = (JCheckBox)e.getSource();
                    DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 3);
                }
            }
        });
    }

    private void addResource(int j) {
        String path = j == 0 ? this.topui.getResourceView().addOnlineResource() : this.topui.getResourceView().addImageResource();
        if (path == null) {
            return;
        }
        this.topui.getResourceLoader().addResource(path);
        File file = new File(path);
        String name = file.getName();
        path = file.getPath();
        String s = file.getName();
        int i = s.indexOf(46);
        if (i != -1) {
            s = s.substring(0, i);
        }
        JCheckBox jBut = new JCheckBox(s);
        jBut.setForeground(this.panelsFontColor);
        jBut.setOpaque(false);
        jBut.setName(path);
        jBut.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOAD RESOURCE:") + " " + name);
        jBut.setSelected(true);
        boolean k = false;
        this.resourcesPanel.add(jBut);
        this.resourcesPanel.revalidate();
        this.resourcesPanel.repaint();
        jBut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JCheckBox button = (JCheckBox)e.getSource();
                    DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 0);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JCheckBox button = (JCheckBox)e.getSource();
                    DashboardView.this.showResourceContextMenu(button, e.getX(), e.getY(), 0);
                }
            }
        });
    }

    private void showResourceContextMenu(final JCheckBox box, int x, int y, final int type) {
        String ipath;
        JPopupMenu pop = new JPopupMenu();
        JMenuItem item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ DashboardView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = null;
                if (type == 0) {
                    list = this.this$0.topui.getResourceLoader().getLastResources();
                } else if (type == 1) {
                    list = this.this$0.topui.getResourceLoader().getLastSegmentMemories();
                } else if (type == 3) {
                    list = this.this$0.topui.getResourceLoader().getLastGlossaries();
                }
                if (list != null) {
                    String path = box.getName();
                    list.remove(path);
                    this.this$0.topui.getResourceLoader().removeLastSessionResource(path);
                }
                Container component = box.getParent();
                component.remove(box);
                component.revalidate();
                component.repaint();
                this.this$0.exportCurrentTemplate();
            }
        });
        JMenuItem item2 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE ALL SELECTED"));
        item2.addActionListener(new ActionListener(){
            final /* synthetic */ DashboardView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Component[] comps;
                List list = null;
                if (type == 0) {
                    list = this.this$0.topui.getResourceLoader().getLastResources();
                    comps = this.this$0.resourcesPanel.getComponents();
                } else if (type == 1) {
                    list = this.this$0.topui.getResourceLoader().getLastSegmentMemories();
                    comps = this.this$0.segmentsPanel.getComponents();
                } else if (type == 3) {
                    list = this.this$0.topui.getResourceLoader().getLastGlossaries();
                    comps = this.this$0.termsPanel.getComponents();
                } else {
                    return;
                }
                for (int i = 0; i < comps.length; ++i) {
                    JCheckBox but;
                    if (!(comps[i] instanceof JCheckBox) || !(but = (JCheckBox)comps[i]).isSelected()) continue;
                    String path = but.getName();
                    if (path != null) {
                        if (path.equals("ProjectTerms") || path.equals("ProjectTM")) continue;
                        if (list != null) {
                            list.remove(path);
                        }
                    }
                    Container component = but.getParent();
                    component.remove(but);
                    component.revalidate();
                    component.repaint();
                }
                this.this$0.exportCurrentTemplate();
            }
        });
        if (type == 0) {
            final String ipath2 = box.getName();
            if (ipath2 != null) {
                JMenuItem jminfo = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT RESOURCE INFO")){
                    final /* synthetic */ DashboardView this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        this.this$0.topui.getResourceView().editResourceInfo(ipath2);
                    }
                });
                jminfo.setToolTipText(ipath2);
                jminfo.setName("MenuToolsEditResourceInfo");
                pop.add(jminfo);
            }
        } else if (type == 3 && (ipath = box.getName()) != null) {
            JMenuItem jminfo = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT GLOSSARY INFO")){
                final /* synthetic */ DashboardView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    this.this$0.topui.getResourceView().editGlossaryInfo(ipath);
                }
            });
            jminfo.setToolTipText(ipath);
            jminfo.setName("MenuGlossaryEditGlossaryInfo");
            pop.add(jminfo);
        }
        pop.add(item);
        pop.add(item2);
        pop.show(box, x, y);
    }

    private void showDashboardPopUpMenu(Component comp, int x, int y) {
        JPopupMenu pop = new JPopupMenu();
        JMenu projectMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW PROJECT"));
        pop.add(projectMenu);
        JMenuItem projectItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE DOCUMENT"));
        projectItem.setToolTipText("Translate imported documents in CafeTran project.");
        projectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DashboardView.this.firstRun) {
                    DashboardView.this.newProject(0, AppPreferences.documentsFolder);
                } else {
                    JOptionPane.showMessageDialog(DashboardView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR LANGUAGE PAIR FROM THE LIST ABOVE!"));
                    DashboardView.this.combo1.requestFocusInWindow();
                }
            }
        });
        JMenuItem projectItem2 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE FROM ANOTHER APPLICATION"));
        projectItem2.setToolTipText("Translate copied text from another application in CafeTran project.");
        projectItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DashboardView.this.firstRun) {
                    DashboardView.this.newProject(1, AppPreferences.documentsFolder);
                } else {
                    JOptionPane.showMessageDialog(DashboardView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR LANGUAGE PAIR FROM THE LIST ABOVE!"));
                    DashboardView.this.combo1.requestFocusInWindow();
                }
            }
        });
        JMenuItem projectItem3 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE EXTERNAL PROJECT"));
        projectItem3.setToolTipText("Translate xliff, sdlxliff, sdlppx, txml, ttx projects created in other CAT tools.");
        projectItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DashboardView.this.firstRun) {
                    DashboardView.this.newProject(2, AppPreferences.documentsFolder);
                } else {
                    JOptionPane.showMessageDialog(DashboardView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR LANGUAGE PAIR FROM THE LIST ABOVE!"));
                    DashboardView.this.combo1.requestFocusInWindow();
                }
            }
        });
        JMenuItem projectItem4 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE PAPER DOCUMENT"));
        projectItem4.setToolTipText("Translate a paper or scanned document in CafeTran project.");
        projectItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DashboardView.this.firstRun) {
                    DashboardView.this.newProject(3, AppPreferences.documentsFolder);
                } else {
                    JOptionPane.showMessageDialog(DashboardView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR LANGUAGE PAIR FROM THE LIST ABOVE!"));
                    DashboardView.this.combo1.requestFocusInWindow();
                }
            }
        });
        JMenuItem projectItem5 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT TRANSLATION MEMORY"));
        projectItem5.setToolTipText("Edit TMX translation memories created in CafeTran or other translation tools.");
        projectItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DashboardView.this.firstRun) {
                    DashboardView.this.newProject(4, AppPreferences.documentsFolder);
                } else {
                    JOptionPane.showMessageDialog(DashboardView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR LANGUAGE PAIR FROM THE LIST ABOVE!"));
                    DashboardView.this.combo1.requestFocusInWindow();
                }
            }
        });
        JMenuItem projectItem6 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ALIGN TWO DOCUMENTS"));
        projectItem6.setToolTipText("Align source and target language documents to create a translation memory.");
        projectItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DashboardView.this.firstRun) {
                    DashboardView.this.newProject(5, AppPreferences.documentsFolder);
                } else {
                    JOptionPane.showMessageDialog(DashboardView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR LANGUAGE PAIR FROM THE LIST ABOVE!"));
                    DashboardView.this.combo1.requestFocusInWindow();
                }
            }
        });
        projectMenu.add(projectItem);
        projectMenu.add(projectItem2);
        projectMenu.add(projectItem3);
        projectMenu.add(projectItem4);
        projectMenu.addSeparator();
        projectMenu.add(projectItem5);
        projectMenu.add(projectItem6);
        if (AppPreferences.editorAPI == 1) {
            JMenuItem projectItem7 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE VIA LIBREOFFICE"));
            projectItem7.setToolTipText("Translate a document directly from LibreOffice suite.");
            projectItem7.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DashboardView.this.firstRun) {
                        DashboardView.this.newProject(6, AppPreferences.documentsFolder);
                    } else {
                        JOptionPane.showMessageDialog(DashboardView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR LANGUAGE PAIR FROM THE LIST ABOVE!"));
                        DashboardView.this.combo1.requestFocusInWindow();
                    }
                }
            });
            projectMenu.add(projectItem7);
        }
        JCheckBoxMenuItem multiProjectItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MULTIPLE DOCUMENT PROJECT"));
        if (AppPreferences.documentsFolder) {
            multiProjectItem.setSelected(true);
        }
        multiProjectItem.setToolTipText("Translate multiple documents in a folder instead of a single document.");
        multiProjectItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.documentsFolder = e.getStateChange() == 1;
            }
        });
        pop.add(multiProjectItem);
        if (this.topui.getResourceView().isLibreOfficeAvailable()) {
            JCheckBoxMenuItem previewWithLibreOfficeItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW WITH LIBREOFFICE"));
            if (AppPreferences.previewWithLibreOffice) {
                previewWithLibreOfficeItem.setSelected(true);
            }
            previewWithLibreOfficeItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AppPreferences.previewWithLibreOffice = e.getStateChange() == 1;
                }
            });
            pop.add(previewWithLibreOfficeItem);
        }
        pop.addSeparator();
        List pts = this.topui.getResourceLoader().getlastProjectTemplates();
        if (!pts.isEmpty()) {
            JMenu templatesMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RECENT PROJECT TEMPLATES"));
            pop.add(templatesMenu);
            Iterator iterator = pts.iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                final File tempFile = new File(next);
                if (tempFile.exists()) {
                    String name = tempFile.getName();
                    int ext = name.lastIndexOf(46);
                    if (ext != -1) {
                        name = name.substring(0, ext);
                    }
                    JMenuItem templateItem = new JMenuItem(name);
                    templateItem.addActionListener(new ActionListener(){
                        final /* synthetic */ DashboardView this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.this$0.importTemplateNode(tempFile);
                        }
                    });
                    templatesMenu.add(templateItem);
                    continue;
                }
                iterator.remove();
            }
        }
        JMenuItem newGlossary = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW GLOSSARY") + "...");
        newGlossary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.addGlossary(true);
            }
        });
        JMenuItem addGlossary = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD GLOSSARY") + "...");
        addGlossary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.addGlossary(false);
            }
        });
        JMenuItem newMemory = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW MEMORY") + "...");
        newMemory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.topui.getMemoryView().newSegmentsMemory(false);
            }
        });
        JMenuItem addMemory = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD MEMORY") + "...");
        addMemory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.showTMFileChooser(false);
            }
        });
        JMenuItem addMemoryInFolder = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD MEMORIES FOLDER") + "...");
        addMemoryInFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.showTMFileChooser(true);
            }
        });
        JMenuItem openProjectTemplateItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN PROJECT TEMPLATE") + "...");
        openProjectTemplateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.openProjectTemplate();
            }
        });
        JMenuItem saveProjectTemplateItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE IN PROJECT TEMPLATE") + "...");
        saveProjectTemplateItem.setToolTipText("Save project options and settings in a template");
        saveProjectTemplateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.saveProjectTemplate();
            }
        });
        JMenuItem removeProjectTemplateItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE CURRENT PROJECT TEMPLATE"));
        removeProjectTemplateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.removeProjectTemplate();
            }
        });
        JMenuItem chooseRateItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR RATE") + "...");
        chooseRateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.chooseRate();
            }
        });
        JMenuItem LPItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE WORKING LANGUAGE PAIR"));
        LPItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b2;
                Set set = LanguageCodes.getCurrentLangNames();
                String s = (String)DashboardView.this.combo1.getSelectedItem();
                String s2 = (String)DashboardView.this.combo2.getSelectedItem();
                boolean b = set.remove(s);
                if (b) {
                    DashboardView.this.combo1.removeItem(s);
                    DashboardView.this.combo2.removeItem(s);
                }
                if (b2 = set.remove(s2)) {
                    DashboardView.this.combo1.removeItem(s2);
                    DashboardView.this.combo2.removeItem(s2);
                }
            }
        });
        JMenuItem prefItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREFERENCES") + "...");
        prefItem.setName("MenuEditOptions");
        prefItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardView.this.topui.showOptions(null, 0);
            }
        });
        JMenuItem closeItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent a) {
                DashboardView.this.closeDashboard();
                DashboardView.this.topui.getResourceLoader().finishLoadingResources();
            }
        });
        closeItem.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE DASHBOARD"));
        closeItem.setName("CloseProjectDashboard");
        JMenuItem newDashboardMenuItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent a) {
                DashboardView.this.newDashboard();
            }
        });
        newDashboardMenuItem.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW DASHBOARD"));
        newDashboardMenuItem.setName("NewProjectDashboard");
        JMenuItem removeCurrentProjectMenuItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int i = DashboardView.this.recentProjectsCombo.getSelectedIndex();
                int len = DashboardView.this.recentProjectsList.size();
                if (i != -1 && i < len) {
                    List lastProjects = DashboardView.this.topui.getResourceLoader().getLastProjects();
                    DashboardView.this.recentProjectsCombo.removeItemAt(i);
                    Object o = DashboardView.this.recentProjectsList.remove(i);
                    if (o != null) {
                        lastProjects.remove(o);
                        String infos = "";
                        Iterator it = lastProjects.iterator();
                        while (it.hasNext()) {
                            String info = it.next().toString();
                            if (info == null || info.length() <= 0 || infos.length() + info.length() >= 8192) continue;
                            infos = infos + info + "|";
                        }
                        AppPreferences.projects = infos;
                        Preferences prefs = AppPreferences.getPreferences();
                        prefs.put("projects", AppPreferences.projects);
                        try {
                            prefs.flush();
                        }
                        catch (BackingStoreException ex) {
                            Logger.getLogger(DashboardView.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        });
        removeCurrentProjectMenuItem.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE CURRENT PROJECT"));
        removeCurrentProjectMenuItem.setName("RemoveCurrentProjectDashboard");
        pop.add(newGlossary);
        pop.add(addGlossary);
        pop.addSeparator();
        pop.add(newMemory);
        pop.add(addMemory);
        pop.add(addMemoryInFolder);
        pop.addSeparator();
        pop.add(openProjectTemplateItem);
        pop.add(saveProjectTemplateItem);
        pop.add(removeProjectTemplateItem);
        pop.addSeparator();
        pop.add(chooseRateItem);
        pop.add(LPItem);
        pop.add(removeCurrentProjectMenuItem);
        pop.addSeparator();
        pop.add(newDashboardMenuItem);
        pop.add(closeItem);
        pop.add(prefItem);
        pop.show(comp, x, y);
    }

    private void setDashboardFocusPolicy() {
        Vector<Component> order = new Vector<Component>(2);
        if (this.recentProjectsCombo != null) {
            order.add(this.recentProjectsCombo);
            order.add(this.goButton);
            order.add(this.newButton);
        } else {
            order.add(this.combo1);
            order.add(this.combo2);
            order.add(this.newButton);
        }
        CTFocusTraversalPolicy newPolicy = new CTFocusTraversalPolicy(order);
        this.topui.setFocusTraversalPolicy(newPolicy);
    }

    private void removeProjectTemplate() {
        ResourceLoader rl = this.topui.getResourceLoader();
        boolean success = rl.removeCurrentProjectTemplate();
        if (success) {
            this.restartUI();
        }
    }

    private void saveProjectTemplate() {
        String n;
        ProjectTemplate pt = this.topui.getResourceLoader().getCurrentProjectTemplate();
        final String fileName = pt != null ? ((n = pt.getName()) != null ? n : "MyTemplate") : "MyTemplate";
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ DashboardView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XML", new String[]{"*.xml"})});
                        if (AppPreferences.templatesDirectory != null && AppPreferences.templatesDirectory.length() > 0) {
                            File dir = new File(AppPreferences.templatesDirectory);
                            if (dir.exists() && dir.isDirectory()) {
                                fileChooser.setInitialDirectory(dir);
                            } else {
                                fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
                            }
                        } else {
                            fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
                        }
                        fileChooser.setInitialFileName(fileName);
                        File f = fileChooser.showSaveDialog(null);
                        if (f != null) {
                            String n = f.getName();
                            final File file = !n.endsWith(".xml") ? new File(f.getPath() + ".xml") : f;
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 67 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this$0.exportTemplateNode(file);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 67 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            File f;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            if (AppPreferences.templatesDirectory != null && AppPreferences.templatesDirectory.length() > 0) {
                File dir = new File(AppPreferences.templatesDirectory);
                if (dir.exists() && dir.isDirectory()) {
                    jFileChooser.setCurrentDirectory(dir);
                } else {
                    jFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                }
            } else {
                jFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            }
            jFileChooser.setSelectedFile(new File(fileName));
            if (0 == jFileChooser.showSaveDialog(this.topui) && (f = jFileChooser.getSelectedFile()) != null) {
                String n2 = f.getName();
                final File file = !n2.endsWith(".xml") ? new File(f.getPath() + ".xml") : f;
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ DashboardView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.exportTemplateNode(file);
                    }
                });
            }
        }
    }

    private void exportCurrentTemplate() {
        File file;
        ResourceLoader rl = this.topui.getResourceLoader();
        ProjectTemplate pt = rl.getCurrentProjectTemplate();
        if (pt != null && (file = pt.getTemplateFile()) != null) {
            this.exportTemplateNode(file);
        }
    }

    private void exportTemplateNode(File file) {
        String path;
        JCheckBox but;
        int i;
        this.topui.savePrefs(false);
        File dir = file.getParentFile();
        if (dir != null && dir.exists()) {
            AppPreferences.templatesDirectory = file.getParent();
        }
        ProjectTemplate projectTemplate = new ProjectTemplate(file);
        Preferences node = projectTemplate.createTemplateNode();
        Component[] comps = this.apiSericesPanel.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            String name;
            if (!(comps[i2] instanceof JCheckBox)) continue;
            JCheckBox but2 = (JCheckBox)comps[i2];
            int k = 0;
            if (but2.isSelected()) {
                k = 1;
            }
            if ((name = but2.getName()) == null) continue;
            if (name.equals("API: MyMemory")) {
                node.putInt("mt3", k);
                continue;
            }
            if (name.equals("API: Google Translate")) {
                node.putInt("mt", k);
                continue;
            }
            if (name.equals("API: DeepL")) {
                node.putInt("mt6", k);
                continue;
            }
            if (name.equals("API: Watson")) {
                node.putInt("mt7", k);
                continue;
            }
            if (name.equals("API: Microsoft Translator")) {
                node.putInt("mt2", k);
                continue;
            }
            if (name.equals("API: Yandex Translate")) {
                node.putInt("mt5", k);
                continue;
            }
            if (!name.equals("API: Slate Desktop")) continue;
            node.putInt("mt4", k);
        }
        StringBuilder sb = new StringBuilder();
        comps = this.databasePanel.getComponents();
        for (int i3 = 0; i3 < comps.length; ++i3) {
            String n;
            JCheckBox but3;
            if (!(comps[i3] instanceof JCheckBox) || !(but3 = (JCheckBox)comps[i3]).isSelected() || (n = but3.getText()) == null || n.length() <= 0 || sb.length() + n.length() >= 8192) continue;
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(n);
        }
        node.put("recallTables", sb.toString());
        ResourceLoader loader = this.topui.getResourceLoader();
        loader.setLastResourcesString();
        loader.setLastGlossariesString();
        loader.setLastMemoriesString();
        node.put("glossaries", AppPreferences.glossaries);
        node.put("glossaries2", AppPreferences.glossaries2);
        node.put("resources", AppPreferences.resources);
        node.put("segmentMemories", AppPreferences.segmentMemories);
        node.put("segmentMemories2", AppPreferences.segmentMemories2);
        node.putBoolean("projectGlossary", AppPreferences.projectGlossary);
        node.putBoolean("projectTMX", AppPreferences.projectTMX);
        comps = this.segmentsPanel.getComponents();
        sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (i = 0; i < comps.length; ++i) {
            Memory ntr;
            if (!(comps[i] instanceof JCheckBox) || i == 0 || !(but = (JCheckBox)comps[i]).isSelected() || (ntr = (Memory)but.getClientProperty("tm")) == null || (path = ntr.getPath()) == null || path.length() <= 0) continue;
            if (sb.length() + path.length() < 8192) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(path);
                continue;
            }
            if (sb2.length() + path.length() >= 8192) continue;
            if (sb2.length() > 0) {
                sb2.append('|');
            }
            sb2.append(path);
        }
        comps = this.termsPanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            String type;
            if (!(comps[i] instanceof JCheckBox) || i == 0 || !(but = (JCheckBox)comps[i]).isSelected() || (type = (String)but.getClientProperty("type")) == null || !type.equals("glossary") || (path = but.getName()) == null || path.length() <= 0) continue;
            if (sb.length() + path.length() < 8192) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(path);
                continue;
            }
            if (sb2.length() + path.length() >= 8192) continue;
            if (sb2.length() > 0) {
                sb2.append('|');
            }
            sb2.append(path);
        }
        comps = this.resourcesPanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            String path2;
            if (!(comps[i] instanceof JCheckBox) || !(but = (JCheckBox)comps[i]).isSelected() || (path2 = but.getName()) == null || path2.length() <= 0) continue;
            if (sb.length() + path2.length() < 8192) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(path2);
                continue;
            }
            if (sb2.length() + path2.length() >= 8192) continue;
            if (sb2.length() > 0) {
                sb2.append('|');
            }
            sb2.append(path2);
        }
        node.put("resourcesLastSession", sb.toString());
        node.put("resourcesLastSession2", sb2.toString());
        node.put("currentTUNumber", AppPreferences.currentTUNumber);
        projectTemplate.setCTPreferences();
        projectTemplate.saveTemplate();
        loader.addProjectTemplate(projectTemplate);
        String n = projectTemplate.getName();
        if (n != null) {
            int i4 = n.lastIndexOf(".");
            if (i4 != -1) {
                n = n.substring(0, i4);
            }
            n = n + " ";
            if (this.jTab != null) {
                this.jTab.setTitleAt(0, n);
            }
        }
    }

    private void openProjectTemplate() {
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        File file;
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XML", new String[]{"*.xml"})});
                        File f = new File(AppPreferences.templatesDirectory);
                        if (f.isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if ((file = fileChooser.showOpenDialog(null)) != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 69 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.DashboardView.this.importTemplateNode(file);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 69 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.DashboardView.this.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            File f = new File(AppPreferences.templatesDirectory);
            if (f.isDirectory()) {
                jFileChooser.setCurrentDirectory(f);
            }
            if (0 == jFileChooser.showOpenDialog(this.topui)) {
                final File file = jFileChooser.getSelectedFile();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ DashboardView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.importTemplateNode(file);
                    }
                });
            }
        }
    }

    private void setTemplateForProject(String projectPath) {
        ResourceLoader rl = this.topui.getResourceLoader();
        if (rl.isCurrentTemplate(projectPath)) {
            return;
        }
        boolean success = rl.loadProjectTemplate(projectPath);
        if (success) {
            this.restartUI();
        } else {
            rl.closeProjectTemplate();
            if (this.jTab != null) {
                this.jTab.setTitleAt(0, "Resources");
            }
        }
    }

    private void importTemplateNode(File file) {
        ProjectTemplate projectTemplate;
        boolean success;
        this.exportCurrentTemplate();
        File dir = file.getParentFile();
        if (dir != null && dir.exists()) {
            AppPreferences.templatesDirectory = file.getParent();
        }
        if (success = (projectTemplate = new ProjectTemplate(file)).loadTemplate()) {
            this.topui.getResourceLoader().addProjectTemplate(projectTemplate);
            TabView.createJoinResourcesMap();
            TabView.createFloatingFramesMap();
            this.restartUI();
        }
    }

    private void restartUI() {
        this.getDividersLocation();
        this.topui.getResourceLoader().createLastSessionResourcesList();
        this.topui.getResourceLoader().createMemoriesList();
        this.topui.getResourceLoader().createGlossariesList();
        this.topui.getResourceLoader().createResourcesList();
        HTMLFormat.setStyles();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DashboardView.this.topui.restartDashboard();
            }
        });
    }

    public JPanel getAPIServicesPanel() {
        return this.apiSericesPanel;
    }

    public void chooseRate() {
        BillingChooser dlg = new BillingChooser(this.topui, null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR RATE"), true);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    public void disableOnlineServices() {
        JCheckBox but;
        int i;
        AppPreferences.mt = -1;
        AppPreferences.mt2 = -1;
        AppPreferences.mt3 = -1;
        AppPreferences.mt4 = -1;
        AppPreferences.mt5 = -1;
        AppPreferences.mt6 = -1;
        AppPreferences.mt7 = -1;
        AppPreferences.mt8 = -1;
        Component[] comps = this.apiSericesPanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            String name;
            if (!(comps[i] instanceof JCheckBox) || (name = (but = (JCheckBox)comps[i]).getName()) != null && (name.equals("API: ProZ.com") || name.equals("API: TM-Town")) || !but.isSelected()) continue;
            but.setSelected(false);
        }
        comps = this.resourcesPanel.getComponents();
        for (i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JCheckBox) || !(but = (JCheckBox)comps[i]).isSelected()) continue;
            but.setSelected(false);
        }
        this.apiSericesPanel.revalidate();
        this.apiSericesPanel.repaint();
        this.resourcesPanel.revalidate();
        this.resourcesPanel.repaint();
    }

    public boolean isAddingFile() {
        return this.addingFile;
    }

    public boolean isReplacingFile() {
        return this.replacingFile;
    }

    public XliffMenu getXliffMenu() {
        return this.xliffmenu;
    }

    public XliffFile getProjectFile() {
        return this.projectFile;
    }

    public JPopupMenu createPopUpMenu() {
        JPopupMenu pop = new JPopupMenu();
        List pts = this.topui.getResourceLoader().getlastProjectTemplates();
        if (!pts.isEmpty()) {
            Iterator iterator = pts.iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                final File tempFile = new File(next);
                if (tempFile.exists()) {
                    String name = tempFile.getName();
                    int ext = name.lastIndexOf(46);
                    if (ext != -1 && (name = name.substring(0, ext)).equals(this.tabTitle)) continue;
                    JMenuItem templateItem = new JMenuItem(name);
                    templateItem.addActionListener(new ActionListener(){
                        final /* synthetic */ DashboardView this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.this$0.importTemplateNode(tempFile);
                        }
                    });
                    pop.add(templateItem);
                    continue;
                }
                iterator.remove();
            }
        }
        return pop;
    }
}

