/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class EncodingValidator {
    private final CharsetDecoder decoder;

    public EncodingValidator(String charsetName) {
        Charset charset = Charset.forName(charsetName);
        this.decoder = charset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateFile(File file) {
        boolean result = true;
        long total = 0L;
        InputStreamReader isr = null;
        char[] buf = new char[65536];
        try {
            int chars;
            isr = new InputStreamReader((InputStream)new FileInputStream(file), this.decoder);
            while ((chars = isr.read(buf)) >= 0) {
                total += (long)chars;
            }
        }
        catch (CharacterCodingException ex) {
            result = false;
        }
        catch (IOException ex) {
            result = false;
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException ex) {
                    System.err.println("Failed to close file: " + ex.toString());
                }
            }
        }
        return result;
    }
}

