/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.LinkedHashMap;
import java.util.Map;
import translator.AppPreferences;

public class FormatChooser {
    static String textFormat = "";
    static String javaPropsFormat = "";
    static String macStringsFormat = "";
    static String stringResourceHeaderFormat = "";
    static String imageFormat = "";
    static String xhtmlTagsFormat = "(>\\s+<[/]*)|(</)|(/>)|[<>]";
    static String xmlFormat = "<base64.*?</base64>|<[^>]*>";
    static String excelFormat = "<rPh.+?</rPh>|<[^>]*>";
    static String powerPointFormat = "<a:tableStyleId>.+?</a:tableStyleId>|<c:numRef>.+?</c:numRef>|<p:timing>.+?</p:timing>|<c:f>.+?</c:f>|<a:buChar.+?/>|<[^>]*>";
    static String taggedXMLFormat = "(<[^>]*>)|(&lt;.+?&gt;)";
    static String xmlTransitFormat = "<Seg.+?</Seg>";
    static String taggedFormat = "(\\\\[<>])|(<.*?(<.*?>.*?)*>+)";
    static String ooFormat = "<text:table-of-content([^<]*[<]*[^>]*[>])*?[^<]*</text:table-of-content>|<office:annotation .*?</office:annotation>|<officeooo:annotation .*?</officeooo:annotation>|<number:currency-style.*?</number:currency-style>|<text:deletion>.*?</text:deletion>|<[^>]*>";
    static String iworkFormat = "<sf:ghost-text.+?>.+?</sf:ghost-text.+?>|<[^>]*>";
    static String htmlFormat = "<script[ >].+?</script>|<style[ >].+?</style>|<[^>]*>";
    static String wordMLFormat = "(\\A.+?<w:body>)|(<pkg:part pkg:name=\"/word/[ts].+?\\z)|<w:binData[^<]*</w:binData>|<w:fldData[^<]*</w:fldData>|<w:instrText[^<]*</w:instrText>|<w:del .*?</w:del>|<mc:Fallback>.*?</mc:Fallback>|<pic:pic.*?</pic:pic>|<wp14:.*?</wp14:[^>]*>|<wp:Position.*?</wp:Position[^>]*>|<[^>]*>";
    static String abiwordFormat = "<metadata([^<]*[<]*[^>]*[>])*?[^<]*</metadata>[\\s]*|<data([^<]*[<]*[^>]*[>])*?[^<]*</data>|<[^>]*>";
    static String wordMLFormatUncleaned = "#" + wordMLFormat;
    static String ooFormatUncleaned = "#" + ooFormat;
    static String autoCadFormat = "^([M]?TEXT|ATTRIB|ATTDEF)\r\n.+?\r\n  0\r\n";
    static String indesignINXFormat = "<pcnt>c_.+?</pcnt>";
    static String indesignIDMLFormat = "<Content>.*?</Content>";
    static String framemakerMIFFormat = "(<TextFlow .+?> # end of TextFlow)|(<Tbl .+?> # end of Tbl\\s)";
    static String resXFormat = "<data.+?</data>";
    static String SVGFormat = "<text.+?</text>";
    static String SRTFormat = "^\\d+\r*\n.+?\r*\n|\r*\n\r*\n\\d+\r*\n.+?\r*\n";
    public static String[] formatType = new String[]{"Text (*.txt)", "LibreOffice (*.odt/ods/odp/odg)", "Ms Word (*.docx/xml)", "Ms Word OCR (*.docx/xml)", "Ms Excel (*.xlsx)", "Ms PowerPoint (*.pptx)", "iWork (*.pages/key/numbers)", "PO Format (*.po)", "XML", "HTML", "XML/HTML with tags", "Abiword (*.abw)", "Ms Word Uncleaned (*.docx/xml)", "LibreOffice Uncleaned (*.odt)", "AutoCAD (*.dxf)", "Indesign (*.inx)", "Indesign (*.idml)", "Framemaker (*.mif)", "Subtitles (*.srt)", "Subtitles (*.itt)", "Java Properties (*.properties)", "Windows .NET Resources (*.resx)", "Mac String Resources (*.strings)", "String resource header (*.loc)", "DTP Tagged Text", "Tagged Ms Excel (*.xlsx)", "Transit XML File", "Vector Image (*.svg)", "Image (.*jpg/gif/bmp/png) or Paper"};
    public static String[] dataType = new String[]{"plaintext", "x-openoffice", "x-docx/xml", "x-docx_ocr", "x-xlsx", "x-pptx", "x-iwork", "x-po", "xml", "x-html", "x-xhtml_tags", "x-abiword", "x-docx/xml_unclean", "x-openoffice_unclean", "x-dxf", "x-inx", "x-idml", "x-mif", "x-subtitles_srt", "x-subtitles_itt", "x-java_properties", "x-windows_resx", "x-mac_strings", "x-string_resource_header", "x-taggedtext", "x-tagged_xlsx", "x-transit_xml", "x-image_svg", "x-image"};
    public static String[] regExps = new String[]{textFormat, ooFormat, wordMLFormat, wordMLFormat, excelFormat, powerPointFormat, iworkFormat, "", xmlFormat, htmlFormat, xhtmlTagsFormat, abiwordFormat, wordMLFormatUncleaned, ooFormatUncleaned, autoCadFormat, indesignINXFormat, indesignIDMLFormat, framemakerMIFFormat, SRTFormat, xmlFormat, javaPropsFormat, resXFormat, macStringsFormat, stringResourceHeaderFormat, taggedFormat, taggedXMLFormat, xmlTransitFormat, SVGFormat, imageFormat};

    public static String getFormatRegEx(String ftype) {
        int index = -1;
        for (int i = 0; i < formatType.length; ++i) {
            String string = formatType[i];
            if (!string.equalsIgnoreCase(ftype)) continue;
            index = i;
            break;
        }
        String s = index != -1 ? regExps[index] : ftype;
        return s;
    }

    public static String getFormatType(String dtype) {
        int index = -1;
        for (int i = 0; i < dataType.length; ++i) {
            String string = dataType[i];
            if (!string.equalsIgnoreCase(dtype)) continue;
            index = i;
            break;
        }
        String s = index != -1 ? formatType[index] : dtype;
        return s;
    }

    public static String getDataType(String ftype) {
        int index = -1;
        for (int i = 0; i < formatType.length; ++i) {
            String string = formatType[i];
            if (!string.equalsIgnoreCase(ftype)) continue;
            index = i;
            break;
        }
        String s = index != -1 ? dataType[index] : ftype;
        return s;
    }

    public static String getDataTypeForExtension(String ext) {
        if (ext.equals(".odt") || ext.equals(".ods") || ext.equals(".odp") || ext.equals(".odg") || ext.equals(".sxw")) {
            if (AppPreferences.format != null && AppPreferences.format.equals("LibreOffice Uncleaned (*.odt)")) {
                return "x-openoffice_unclean";
            }
            return "x-openoffice";
        }
        if (ext.equals(".docx") || ext.equals(".docm")) {
            if (AppPreferences.format != null && AppPreferences.format.equals("Ms Word Uncleaned (*.docx/xml)")) {
                return "x-docx/xml_unclean";
            }
            if (AppPreferences.format != null && AppPreferences.format.equals("Ms Word OCR (*.docx/xml)")) {
                return "x-docx_ocr";
            }
            return "x-docx/xml";
        }
        if (ext.equals(".xlsx") || ext.equals(".xlsm")) {
            if (AppPreferences.format != null && AppPreferences.format.equals("Tagged Ms Excel (*.xlsx)")) {
                return "x-tagged_xlsx";
            }
            return "x-xlsx";
        }
        if (ext.equals(".pptx")) {
            return "x-pptx";
        }
        if (ext.equals(".pages") || ext.equals(".numbers") || ext.equals(".key")) {
            return "x-iwork";
        }
        if (ext.equals(".xml")) {
            if (AppPreferences.format != null && AppPreferences.format.equals("Ms Word (*.docx/xml)")) {
                return "x-docx/xml";
            }
            if (AppPreferences.format != null && AppPreferences.format.equals("XML/HTML with tags")) {
                return "x-xhtml_tags";
            }
            return "xml";
        }
        if (ext.equals(".html") || ext.equals(".htm") || ext.equals(".xhtml")) {
            if (AppPreferences.format != null && AppPreferences.format.equals("XML/HTML with tags")) {
                return "x-xhtml_tags";
            }
            return "x-html";
        }
        if (ext.equals(".po")) {
            return "x-po";
        }
        if (ext.equals(".abw")) {
            return "x-abiword";
        }
        if (ext.equals(".dxf")) {
            return "x-dxf";
        }
        if (ext.equals(".inx")) {
            return "x-inx";
        }
        if (ext.equals(".idml")) {
            return "x-idml";
        }
        if (ext.equals(".mif")) {
            return "x-mif";
        }
        if (ext.equals(".srt")) {
            return "x-subtitles_srt";
        }
        if (ext.equals(".itt")) {
            return "x-subtitles_itt";
        }
        if (ext.equals(".properties")) {
            return "x-java_properties";
        }
        if (ext.equals(".resx")) {
            return "x-windows_resx";
        }
        if (ext.equals(".strings")) {
            return "x-mac_strings";
        }
        if (ext.equals(".loc")) {
            return "x-string_resource_header";
        }
        if (ext.equals(".gif") || ext.equals(".jpg") || ext.equals(".jpeg") || ext.equals(".png") || ext.equals(".bmp") || ext.equals(".tif") || ext.equals(".tiff")) {
            return "x-image";
        }
        if (ext.equals(".svg")) {
            return "x-image_svg";
        }
        if (ext.equals(".txt")) {
            return "plaintext";
        }
        if (AppPreferences.format != null && AppPreferences.format.equals("DTP Tagged Text")) {
            return "x-taggedtext";
        }
        if (AppPreferences.format != null && AppPreferences.format.equals("Transit XML File")) {
            return "x-transit_xml";
        }
        return "x-auto";
    }

    public static Map getFilterOptions(String format) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (format.equals("Ms Excel (*.xlsx)") || format.equals("Tagged Ms Excel (*.xlsx)")) {
            map.put("filter:ImportSourceColumn", "");
            map.put("filter:ImportTargetColumn", "");
            map.put("filter:ImportNotesColumn", "");
            map.put("filter:ExportColumn", "");
            map.put("filter:NoSegmentation", false);
        } else if (format.equals("AutoCAD (*.dxf)")) {
            map.put("filter:Layers", "");
        }
        return map;
    }

    public static boolean isSupportedPreviewFormat(String s) {
        boolean supp = false;
        int i = s.lastIndexOf(46);
        if (i != -1 && ((s = s.substring(i)).endsWith(".docx") || s.endsWith(".xlsx") || s.endsWith(".pptx") || s.endsWith(".odt") || s.endsWith(".ods") || s.endsWith(".odp") || s.endsWith(".odg") || s.endsWith(".html") || s.endsWith(".xml") || s.endsWith(".txt"))) {
            supp = true;
        }
        return supp;
    }
}

