/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.GlossaryResource;
import translator.MainView;
import translator.MySwingWorker;
import translator.Project;
import translator.ResourceView;
import translator.ScrollPaneWatermark;
import translator.StopWords;
import translator.TabView;
import translator.TranslationUnitMap;
import translator.WordCount;
import translator.WorkflowView;
import translator.XMLHelper;
import translator.html.CTHTMLEditorKit;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;
import translator.tmx.TMXView;
import translator.ttx.Raw;
import translator.ttx.TTX;
import translator.ttx.TTXUnit;
import translator.ui.HTMLFormat;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class Frequencer
extends DefaultResource {
    private MainView topui;
    private LinkedHashMap hm;
    private List freqSortWords;
    private Pattern pattern = Pattern.compile("[\\s\u00a0]+");
    private String wordSeparator = " ";
    private int internalRepetitionsWords;
    private int allTextLengh;
    private int internalRepetitionsLength;
    private WordCount wordCountInternalRep;
    private JTextPane HTMLPane;
    private int matchType = 0;
    private String punctuation = "[\\Q,.\u3002:;!\u00a1?\u00bf[]{}()\"\u00ab\u00bb\u2018\u2019\u201c\u201d\u201e\u201a\\E]";
    private int lastSort = 0;
    List pos = new ArrayList();

    public Frequencer(MainView topui) {
        this.topui = topui;
    }

    public void setMatchingType(int mtype) {
        if (mtype != this.matchType) {
            this.matchType = mtype;
            if (mtype == 2) {
                this.pattern = Pattern.compile("", 16);
                this.wordSeparator = "";
            } else {
                this.pattern = Pattern.compile("[\\s\u00a0]+");
                this.wordSeparator = " ";
            }
        }
    }

    public int[] getRepetitions() {
        int[] i = new int[]{this.internalRepetitionsWords, this.allTextLengh > 0 ? this.internalRepetitionsLength * 100 / this.allTextLengh : 0};
        return i;
    }

    public int[] getRepetitions2() {
        int[] i = new int[4];
        if (this.wordCountInternalRep != null) {
            int repWords = this.wordCountInternalRep.getWordCount();
            int repWhiteChars = this.wordCountInternalRep.getAllCharsCount();
            int repChars = this.wordCountInternalRep.getCharsCount();
            i[0] = repWords;
            i[1] = repChars;
            i[2] = repWhiteChars;
            i[3] = this.allTextLengh;
        } else {
            i[0] = 0;
            i[1] = 0;
            i[2] = 0;
            i[3] = 0;
        }
        return i;
    }

    private void fillWordAllMap(String entry) {
        this.allTextLengh += entry.length();
        int intRepLen = -1;
        int totalRepIndex = -1;
        int repIndex = -1;
        String repeatedPhrase = null;
        int len = 1;
        int start = 0;
        if (AppPreferences.noWordSeparatorSourceLanguage) {
            len = 0;
            start = 1;
        }
        entry = entry.replaceAll(this.punctuation, "");
        String[] str = this.pattern.split(entry);
        for (int i = start; i < str.length; ++i) {
            String comp = str[i];
            Object o = this.hm.get(comp);
            int repNo = 0;
            if (o != null) {
                Integer iobj = (Integer)o;
                int k = iobj + 1;
                this.hm.put(comp, new Integer(k));
                if (k > 1 && str.length > len) {
                    repeatedPhrase = comp;
                    intRepLen = comp.length();
                    repIndex = i;
                    repNo = k;
                }
            } else {
                boolean add = true;
                if (AppPreferences.minimalFrequentFragmentLength > 0 && comp.length() < AppPreferences.minimalFrequentFragmentLength) {
                    add = false;
                }
                if (AppPreferences.maximalFrequentFragmentLength > 0 && comp.length() > AppPreferences.maximalFrequentFragmentLength) {
                    add = false;
                }
                if (add) {
                    this.hm.put(comp, new Integer(1));
                }
            }
            for (int j = i + 1; j < str.length; ++j) {
                o = this.hm.get(comp = comp + this.wordSeparator + str[j]);
                if (o != null) {
                    Integer iobj = (Integer)o;
                    int k = iobj + 1;
                    this.hm.put(comp, new Integer(k));
                    if (k <= 1 || i == 0 && j + 1 == str.length) continue;
                    repeatedPhrase = comp;
                    intRepLen = comp.length();
                    repIndex = j;
                    repNo = k;
                    continue;
                }
                boolean add = true;
                if (AppPreferences.minimalFrequentFragmentLength > 0 && comp.length() < AppPreferences.minimalFrequentFragmentLength) {
                    add = false;
                }
                if (AppPreferences.maximalFrequentFragmentLength > 0 && comp.length() > AppPreferences.maximalFrequentFragmentLength) {
                    add = false;
                }
                if (!add) continue;
                this.hm.put(comp, new Integer(1));
            }
            if (intRepLen == -1 || repIndex <= totalRepIndex) continue;
            if (repNo == 2) {
                ++this.internalRepetitionsWords;
            }
            if (repeatedPhrase != null) {
                this.wordCountInternalRep.doWordCount(repeatedPhrase);
                repeatedPhrase = null;
            }
            this.internalRepetitionsLength += intRepLen;
            totalRepIndex = repIndex;
        }
    }

    private void fillWordSegmentMap(String entry, LinkedHashMap map) {
        entry = entry.replaceAll(this.punctuation, "");
        String[] str = this.pattern.split(entry);
        int start = 0;
        if (AppPreferences.noWordSeparatorSourceLanguage) {
            start = 1;
        }
        for (int i = start; i < str.length; ++i) {
            String comp = str[i];
            Object o = map.get(comp);
            if (o != null) {
                Integer iobj = (Integer)o;
                int k = iobj + 1;
                map.put(comp, new Integer(k));
            } else {
                boolean add = true;
                if (AppPreferences.minimalFrequentFragmentLength > 0 && comp.length() < AppPreferences.minimalFrequentFragmentLength) {
                    add = false;
                }
                if (AppPreferences.maximalFrequentFragmentLength > 0 && comp.length() > AppPreferences.maximalFrequentFragmentLength) {
                    add = false;
                }
                if (add) {
                    map.put(comp, new Integer(1));
                }
            }
            for (int j = i + 1; j < str.length; ++j) {
                o = this.hm.get(comp = comp + this.wordSeparator + str[j]);
                if (o != null) {
                    Integer iobj = (Integer)o;
                    int k = iobj + 1;
                    map.put(comp, new Integer(k));
                    continue;
                }
                boolean add = true;
                if (AppPreferences.minimalFrequentFragmentLength > 0 && comp.length() < AppPreferences.minimalFrequentFragmentLength) {
                    add = false;
                }
                if (AppPreferences.maximalFrequentFragmentLength > 0 && comp.length() > AppPreferences.maximalFrequentFragmentLength) {
                    add = false;
                }
                if (!add) continue;
                map.put(comp, new Integer(1));
            }
        }
    }

    public void findProjectHFWords() {
        block12: {
            Project project;
            block14: {
                block13: {
                    if (this.hm != null && !this.hm.isEmpty()) {
                        return;
                    }
                    if (AppPreferences.noWordSeparatorSourceLanguage) {
                        this.setMatchingType(2);
                    } else {
                        this.setMatchingType(1);
                    }
                    this.allTextLengh = 0;
                    this.internalRepetitionsWords = 0;
                    this.internalRepetitionsLength = 0;
                    this.wordCountInternalRep = new WordCount();
                    project = this.topui.getProjectView().getProject();
                    if (project == null) break block12;
                    XLIFF xliff = project.getXLIFF();
                    if (xliff == null) break block13;
                    List tunits = xliff.getView().getViewUnits();
                    if (tunits == null) break block12;
                    this.hm = new LinkedHashMap();
                    for (XLIFFUnit tu : tunits) {
                        if (!tu.translate) continue;
                        String segment = tu.getSourceText();
                        this.fillWordAllMap(segment);
                    }
                    break block12;
                }
                TTX ttx = project.getTTX();
                if (ttx == null) break block14;
                List tunits = ttx.getView().getFilteredUnits();
                if (tunits == null && (tunits = ttx.getView().getGluedUnits()) == null) {
                    Raw file = ttx.getCurrentFile();
                    tunits = file.getTransUnits();
                }
                if (tunits == null) break block12;
                this.hm = new LinkedHashMap();
                for (TTXUnit tu : tunits) {
                    String segment = tu.getSourceText();
                    this.fillWordAllMap(segment);
                }
                break block12;
            }
            TMX tmx = project.getTMX();
            if (tmx != null) {
                ArrayList tunits = TMXView.getFilteredUnits();
                if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
                    Collection col = tmx.getTranslationUnits();
                    if (col instanceof List) {
                        tunits = (List)col;
                    } else {
                        tunits = new ArrayList(col.size());
                        tunits.addAll(col);
                    }
                }
                if (tunits != null) {
                    TranslationUnitMap map = tmx.getTUMap();
                    String slang = map.getSourceLang();
                    this.hm = new LinkedHashMap();
                    for (TMXUnit tu : tunits) {
                        TMXUnitVariant tuv = tu.getTUV(slang);
                        if (tuv == null) continue;
                        String segment = tuv.getSegmentText();
                        this.fillWordAllMap(segment);
                    }
                }
            }
        }
    }

    void findUnsegmentedHFWords(String sdoc, Matcher matcher, int from) {
        if (this.hm != null && !this.hm.isEmpty()) {
            return;
        }
        if (AppPreferences.noWordSeparatorSourceLanguage) {
            this.setMatchingType(2);
        } else {
            this.setMatchingType(1);
        }
        this.allTextLengh = 0;
        this.internalRepetitionsWords = 0;
        this.internalRepetitionsLength = 0;
        this.wordCountInternalRep = new WordCount();
        int no = 0;
        String segment = null;
        this.hm = new LinkedHashMap();
        int len = sdoc.length();
        while (matcher.find(from) && from < len) {
            int end;
            int start = matcher.start();
            segment = sdoc.substring(from, start);
            this.fillWordAllMap(segment);
            from = end = matcher.end();
            ++no;
        }
        matcher.reset();
    }

    void sortByFrequency() {
        Collections.sort(this.pos, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                int len1 = (Integer)o1[1];
                int len2 = (Integer)o2[1];
                return len2 - len1;
            }
        });
    }

    void sortByLength() {
        Collections.sort(this.pos, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                String s1 = (String)o1[0];
                String s2 = (String)o2[0];
                int len1 = s1.length();
                int len2 = s2.length();
                return len2 - len1;
            }
        });
    }

    void sortByAlphabet() {
        Collections.sort(this.pos, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                String s1 = (String)o1[0];
                String s2 = (String)o2[0];
                return s1.trim().compareToIgnoreCase(s2.trim());
            }
        });
    }

    public void createFWTab() {
        File file;
        this.HTMLPane = new JTextPane();
        this.HTMLPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.HTMLPane.putClientProperty("type", "memory");
        this.HTMLPane.addHyperlinkListener(new FWHyperactive());
        this.HTMLPane.setContentType("text/html");
        Graphics g = this.HTMLPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            Color foreground = new Color(AppPreferences.foreground);
            background = new Color(AppPreferences.background);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.HTMLPane.setCaretColor(foreground);
            this.HTMLPane.setBackground(background);
            this.HTMLPane.setForeground(foreground);
            this.HTMLPane.setSelectionColor(selection);
            this.HTMLPane.setSelectedTextColor(foreground);
        }
        this.HTMLPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        this.HTMLPane.setMargin(new Insets(12, 12, 12, 12));
        this.HTMLPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Frequencer.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.HTMLPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Frequencer.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Frequencer.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.HTMLPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.HTMLPane.setBackground(new Color(0, 0, 0, 0));
            this.HTMLPane.setOpaque(false);
        }
        jScrollPane.getViewport().add((Component)this.HTMLPane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.HTMLPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.HTMLPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.topui.getTabView().addTab(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FREQUENT WORDS"), jScrollPane);
    }

    private void showPopUp(Component comp, int x, int y) {
        JPopupMenu pop = new JPopupMenu();
        String text = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MINIMAL FRAGMENT LENGTH") + " = " + AppPreferences.minimalFrequentFragmentLength;
        JMenuItem item1 = new JMenuItem(text);
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = String.valueOf(AppPreferences.minimalFrequentFragmentLength);
                Object o = JOptionPane.showInputDialog(Frequencer.this.topui, null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MINIMAL FRAGMENT LENGTH"), 3, null, null, s);
                if (o != null) {
                    s = o.toString();
                    AppPreferences.minimalFrequentFragmentLength = s.length() > 0 ? Integer.parseInt(s) : 0;
                    if (Frequencer.this.hm != null) {
                        Frequencer.this.hm.clear();
                        Frequencer.this.hm = null;
                    }
                    if (Frequencer.this.freqSortWords != null) {
                        Frequencer.this.freqSortWords.clear();
                        Frequencer.this.freqSortWords = null;
                    }
                    Frequencer.this.showAllFreqWords(Frequencer.this.lastSort);
                }
            }
        });
        text = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MAXIMAL FRAGMENT LENGTH") + " = " + AppPreferences.maximalFrequentFragmentLength;
        JMenuItem item2 = new JMenuItem(text);
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = String.valueOf(AppPreferences.maximalFrequentFragmentLength);
                Object o = JOptionPane.showInputDialog(Frequencer.this.topui, null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MAXIMAL FRAGMENT LENGTH"), 3, null, null, s);
                if (o != null) {
                    s = o.toString();
                    AppPreferences.maximalFrequentFragmentLength = s.length() > 0 ? Integer.parseInt(s) : 0;
                    if (Frequencer.this.hm != null) {
                        Frequencer.this.hm.clear();
                        Frequencer.this.hm = null;
                    }
                    if (Frequencer.this.freqSortWords != null) {
                        Frequencer.this.freqSortWords.clear();
                        Frequencer.this.freqSortWords = null;
                    }
                    Frequencer.this.showAllFreqWords(Frequencer.this.lastSort);
                }
            }
        });
        JCheckBoxMenuItem extractFWMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXTRACT FREQUENT WORDS FROM CURRENT SEGMENT"));
        extractFWMenu.setName("MenuTaskFrequentWordsExactFromCurrentSeg");
        extractFWMenu.setSelected(AppPreferences.frequencer);
        extractFWMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.frequencer = e.getStateChange() == 1;
            }
        });
        pop.add(item1);
        pop.add(item2);
        pop.addSeparator();
        pop.add(extractFWMenu);
        pop.show(comp, x, y);
    }

    public void setHTMLPane() {
        if (this.HTMLPane == null || !this.HTMLPane.isVisible()) {
            this.createFWTab();
        } else {
            try {
                HTMLDocument document = (HTMLDocument)this.HTMLPane.getDocument();
                document.remove(0, document.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Frequencer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setFreqWordsTable() {
        if (this.freqSortWords != null) {
            return;
        }
        ArrayList<String> freqWords = new ArrayList<String>();
        if (this.hm != null && !this.hm.isEmpty()) {
            Iterator it = this.hm.keySet().iterator();
            while (it.hasNext()) {
                String ex = it.next().toString();
                Integer i = (Integer)this.hm.get(ex);
                int j = i;
                if (j <= 1) continue;
                freqWords.add(ex);
            }
        }
        if (!freqWords.isEmpty()) {
            String prev = "#$%";
            this.freqSortWords = new ArrayList();
            for (String elem : freqWords) {
                int j;
                Object o;
                int i;
                if (prev.indexOf(elem) != -1) {
                    i = (Integer)this.hm.get(elem);
                    o = this.hm.get(prev);
                    if (o != null && i == (j = ((Integer)o).intValue())) {
                        continue;
                    }
                } else if (elem.indexOf(prev) != -1) {
                    i = (Integer)this.hm.get(elem);
                    o = this.hm.get(prev);
                    if (o != null && i == (j = ((Integer)o).intValue())) {
                        this.freqSortWords.remove(prev);
                    }
                }
                this.freqSortWords.add(elem);
                prev = elem;
            }
            freqWords.clear();
        }
    }

    void showSegmentFreqWords(String segment, boolean append) {
        if (this.hm != null && this.freqSortWords == null) {
            this.setFreqWordsTable();
        }
        if (this.freqSortWords != null && this.freqSortWords.size() > 0) {
            this.pos.clear();
            LinkedHashMap hmap = new LinkedHashMap();
            this.fillWordSegmentMap(segment, hmap);
            Iterator it = hmap.keySet().iterator();
            while (it.hasNext()) {
                String elem = it.next().toString();
                if (!this.freqSortWords.contains(elem)) continue;
                Object[] o = new Object[]{elem, this.hm.get(elem)};
                this.pos.add(o);
                this.freqSortWords.remove(elem);
            }
            hmap.clear();
            if (AppPreferences.uniqueFrequentTerms) {
                this.filterOutUniqueWords();
            }
            this.sortByFrequency();
            if (this.HTMLPane == null || !this.HTMLPane.isVisible()) {
                this.createFWTab();
            }
            this.showInTextPane();
        }
    }

    public void showAllFreqWords(int sort) {
        this.lastSort = sort;
        this.setHTMLPane();
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Extracting frequent words...");
        MySwingWorker worker = new MySwingWorker(this){
            final /* synthetic */ Frequencer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.this$0.findProjectHFWords();
                if (this.this$0.hm == null || this.this$0.hm.isEmpty()) {
                    return null;
                }
                if (!this.this$0.pos.isEmpty()) {
                    this.this$0.pos.clear();
                }
                String prev = "#$%";
                Object[] prevO = null;
                Iterator it = this.this$0.hm.keySet().iterator();
                while (it.hasNext()) {
                    int m;
                    Object o;
                    int n;
                    String elem = it.next().toString();
                    Integer i = (Integer)this.this$0.hm.get(elem);
                    int j = i;
                    if (j <= 1) continue;
                    if (prev.indexOf(elem) != -1) {
                        n = (Integer)this.this$0.hm.get(elem);
                        o = this.this$0.hm.get(prev);
                        if (o != null && n == (m = ((Integer)o).intValue())) {
                            continue;
                        }
                    } else if (elem.indexOf(prev) != -1) {
                        n = (Integer)this.this$0.hm.get(elem);
                        o = this.this$0.hm.get(prev);
                        if (o != null && n == (m = ((Integer)o).intValue())) {
                            this.this$0.pos.remove(prevO);
                        }
                    }
                    Object[] o2 = new Object[]{elem, i};
                    this.this$0.pos.add(o2);
                    prev = elem;
                    prevO = o2;
                }
                if (AppPreferences.uniqueFrequentTerms) {
                    this.this$0.filterOutUniqueWords();
                }
                bar.setString("Sorting frequent words...");
                if (this.this$0.lastSort == 0) {
                    this.this$0.sortByFrequency();
                } else if (this.this$0.lastSort == 1) {
                    this.this$0.sortByLength();
                } else if (this.this$0.lastSort == 2) {
                    this.this$0.sortByAlphabet();
                }
                return null;
            }

            @Override
            public void finished() {
                this.this$0.showInTextPane();
                if (bar != null) {
                    this.this$0.topui.removePretranslateProgressBar(bar);
                }
                AppPreferences.frequencer = true;
            }
        };
        worker.start();
    }

    public void filterOutUniqueWords() {
        List glossaries = this.topui.getResourceView().getGlossaries();
        List memories = this.topui.getMemoryView().getLocalMemories();
        Iterator it = this.pos.iterator();
        block0: while (it.hasNext()) {
            Object[] object = (Object[])it.next();
            String entry = object[0].toString();
            for (GlossaryResource g : glossaries) {
                if (!g.hasMatch(entry)) continue;
                it.remove();
                continue block0;
            }
            for (Memory m : memories) {
                TMX tmx = m.getTMX();
                if (tmx.getFromMemory(entry) == null) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public Set getProjectUniqueWords() {
        HashSet<String> hs;
        block16: {
            Project project;
            block18: {
                block17: {
                    XliffFile file;
                    if (AppPreferences.noWordSeparatorSourceLanguage) {
                        this.setMatchingType(2);
                    } else {
                        this.setMatchingType(1);
                    }
                    hs = new HashSet<String>(2000);
                    project = this.topui.getProjectView().getProject();
                    if (project == null) break block16;
                    if (project.mode == 3) {
                        String segment = this.topui.getWorkflowView().getWorkflowManager().getWorkflow().getTranslatableText();
                        segment = segment.replaceAll(this.punctuation, "");
                        String[] str = this.pattern.split(segment);
                        for (int i = 0; i < str.length; ++i) {
                            String string = str[i];
                            if (string.length() <= 0 || StopWords.isStopWord(string)) continue;
                            hs.add(string.toLowerCase());
                        }
                        return hs;
                    }
                    XLIFF xliff = project.getXLIFF();
                    if (xliff == null) break block17;
                    List tunits = xliff.getView().getFilteredUnits();
                    if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null && (file = xliff.getCurrentFile()) != null) {
                        tunits = file.getBody().getTransUnits();
                    }
                    if (tunits == null) break block16;
                    for (XLIFFUnit tu : tunits) {
                        if (!tu.translate) continue;
                        String segment = tu.getSourceText();
                        segment = segment.replaceAll(this.punctuation, "");
                        String[] str = this.pattern.split(segment);
                        for (int i = 0; i < str.length; ++i) {
                            String string = str[i];
                            if (string.length() <= 0 || StopWords.isStopWord(string)) continue;
                            hs.add(string.toLowerCase());
                        }
                    }
                    break block16;
                }
                TTX ttx = project.getTTX();
                if (ttx == null) break block18;
                List tunits = ttx.getView().getFilteredUnits();
                if (tunits == null && (tunits = ttx.getView().getGluedUnits()) == null) {
                    Raw file = ttx.getCurrentFile();
                    tunits = file.getTransUnits();
                }
                if (tunits == null) break block16;
                this.hm = new LinkedHashMap();
                for (TTXUnit tu : tunits) {
                    String segment = tu.getSourceText();
                    segment = segment.replaceAll(this.punctuation, "");
                    String[] str = this.pattern.split(segment);
                    for (int i = 0; i < str.length; ++i) {
                        String string = str[i];
                        if (string.length() <= 0 || StopWords.isStopWord(string)) continue;
                        hs.add(string.toLowerCase());
                    }
                }
                break block16;
            }
            TMX tmx = project.getTMX();
            if (tmx != null) {
                ArrayList tunits = TMXView.getFilteredUnits();
                if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
                    Collection col = tmx.getTranslationUnits();
                    if (col instanceof List) {
                        tunits = (List)col;
                    } else {
                        tunits = new ArrayList(col.size());
                        tunits.addAll(col);
                    }
                }
                TranslationUnitMap map = tmx.getTUMap();
                String slang = map.getSourceLang();
                for (TMXUnit tu : tunits) {
                    TMXUnitVariant tuv = tu.getTUV(slang);
                    if (tuv == null) continue;
                    String segment = tuv.getSegmentText();
                    segment = segment.replaceAll(this.punctuation, "");
                    String[] str = this.pattern.split(segment);
                    for (int i = 0; i < str.length; ++i) {
                        String string = str[i];
                        if (string.length() <= 0 || StopWords.isStopWord(string)) continue;
                        hs.add(string.toLowerCase());
                    }
                }
            }
        }
        return hs;
    }

    private void showInTextPane() {
        String colstyle2;
        String colstyle;
        HTMLDocument document = (HTMLDocument)this.HTMLPane.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(HTMLFormat.glossaryStyles);
        sb.append("<body>");
        sb.append("<table WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=4>");
        boolean colorRow = false;
        if (AppPreferences.foreground == -16777216) {
            colstyle = "<td style=\"color:black; background-color:white\">";
            colstyle2 = "<td style=\"color:black; background-color:#EEEEEE\">";
        } else {
            colstyle = "<td style=\"color:white; background-color:#202020\">";
            colstyle2 = "<td style=\"color:white; background-color:#222222\">";
        }
        int id = 0;
        for (Object[] object : this.pos) {
            sb.append("<tr>");
            sb.append("<td width=10% style=\"color:white; background-color:#0074CC\" align=center>");
            sb.append("<a href=\"show" + Integer.toString(id) + "\" \"style=color:white\">").append(object[1]);
            sb.append("</td>");
            sb.append("<td width=10% style=\"color:white; background-color:#0074CC\" align=center>");
            sb.append("<a href=\"add" + Integer.toString(id) + "\" \"style=color:white\">Add");
            sb.append("</td>");
            sb.append("<td width=10% style=\"color:white; background-color:#0074CC\" align=center>");
            sb.append("<a href=\"search" + Integer.toString(id) + "\" \"style=color:white\">Search");
            sb.append("</td>");
            if (colorRow) {
                sb.append(colstyle);
            } else {
                sb.append(colstyle2);
            }
            sb.append("<p>");
            String s = object[0].toString();
            s = XMLHelper.resolveXMLEntities(s);
            sb.append(s);
            sb.append("</p>");
            sb.append("</td>");
            sb.append("</tr>");
            colorRow = !colorRow;
            ++id;
        }
        sb.append("</table>");
        sb.append("</body></html>");
        try {
            document.remove(0, document.getLength());
            document.setInnerHTML(document.getDefaultRootElement(), sb.toString());
            this.HTMLPane.setCaretPosition(0);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            Logger.getLogger(Frequencer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void searchFrequentWord(String word) {
        MemoryView mrview = this.topui.getMemoryView();
        ResourceView rview = this.topui.getResourceView();
        mrview.searchMemories(word, null, 2);
        rview.searchManualGlossaries(word, null);
        rview.translateAIService(word);
        rview.translateMTSelection(word);
        rview.searchMTWebResources(word);
    }

    private void searchFrequentWordProject(String word) {
        ResourceView rv = this.topui.getResourceView();
        word = XMLHelper.parseTags(word);
        rv.getLookUpBox().setSelectedItem(word);
        int m = rv.getFindMode();
        rv.setFindMode(4);
        rv.lookUpResource(word, null, null);
        rv.setFindMode(m);
    }

    @Override
    public void closeResource() {
        this.pos.clear();
        TabView tview = this.topui.getTabView();
        String n = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FREQUENT WORDS");
        tview.removeTab(n);
        this.topui.closeFrequencer();
    }

    class FWHyperactive
    implements HyperlinkListener {
        FWHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                int i;
                String s = e.getDescription();
                if (s.startsWith("show")) {
                    int i2 = Integer.parseInt(s.substring(4));
                    if (i2 < Frequencer.this.pos.size()) {
                        Object[] a = (Object[])Frequencer.this.pos.get(i2);
                        Frequencer.this.searchFrequentWordProject(a[0].toString());
                    }
                } else if (s.startsWith("search")) {
                    int i3 = Integer.parseInt(s.substring(6));
                    if (i3 < Frequencer.this.pos.size()) {
                        Object[] a = (Object[])Frequencer.this.pos.get(i3);
                        Frequencer.this.searchFrequentWord(a[0].toString());
                    }
                } else if (s.startsWith("add") && (i = Integer.parseInt(s.substring(3))) < Frequencer.this.pos.size()) {
                    Object[] a = (Object[])Frequencer.this.pos.get(i);
                    JTextPane tp = Frequencer.this.topui.getTargetPane();
                    String entry = tp.getSelectedText();
                    String key = a[0].toString();
                    if (entry == null) {
                        entry = "";
                    } else {
                        tp.setCaretPosition(tp.getSelectionEnd());
                    }
                    if (!AppPreferences.frequentTermsToGlossary) {
                        WorkflowView wv = Frequencer.this.topui.getWorkflowView();
                        wv.addPhraseToMemory(key, entry);
                    } else {
                        WorkflowView wview = Frequencer.this.topui.getWorkflowView();
                        wview.addEntryToGlossary(key, entry);
                    }
                }
            }
        }
    }
}

