/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import translator.AppPreferences;

public class LanguageCodes {
    private static LinkedHashSet currentNames;
    public static String sourceLanguage;
    public static String targetLanguage;
    private static String[] names;
    private static String[] codes;

    public static void setSourceLanguage() {
        String lang = "";
        if (AppPreferences.fileSLang != null && AppPreferences.fileSLang.length() > 0) {
            String s = LanguageCodes.getName(AppPreferences.fileSLang);
            if (s != null) {
                int n;
                int i = s.indexOf(40);
                if (i != -1) {
                    s = s.substring(0, i - 1);
                }
                if ((n = (lang = s).indexOf(" - ")) != -1) {
                    lang = lang.substring(0, n);
                }
            } else {
                lang = AppPreferences.fileSLang;
            }
        }
        sourceLanguage = lang;
    }

    public static void setTargetLanguage() {
        String lang = "";
        if (AppPreferences.fileTLang != null && AppPreferences.fileTLang.length() > 0) {
            String s = LanguageCodes.getName(AppPreferences.fileTLang);
            if (s != null) {
                int n;
                int i = s.indexOf(40);
                if (i != -1) {
                    s = s.substring(0, i - 1);
                }
                if ((n = (lang = s).indexOf(" - ")) != -1) {
                    lang = lang.substring(0, n);
                }
            } else {
                lang = AppPreferences.fileTLang;
            }
        }
        targetLanguage = lang;
    }

    public static String getCode(String name) {
        String code = null;
        for (int i = 0; i < names.length; ++i) {
            String s = names[i];
            if (!name.equals(s)) continue;
            code = codes[i];
            break;
        }
        return code;
    }

    public static String getCountryCodeforLanguage(String lang) {
        String code = null;
        if (lang.equals("ar")) {
            code = "EG";
        } else if (lang.equals("bn")) {
            code = "BD";
        } else if (lang.equals("bn")) {
            code = "BD";
        } else if (lang.equals("zh")) {
            code = "CN";
        } else if (lang.equals("nl")) {
            code = "NL";
        } else if (lang.equals("en")) {
            code = "US";
        } else if (lang.equals("en")) {
            code = "US";
        } else if (lang.equals("fr")) {
            code = "FR";
        } else if (lang.equals("gd")) {
            code = "GB";
        } else if (lang.equals("de")) {
            code = "DE";
        } else if (lang.equals("en")) {
            code = "US";
        } else if (lang.equals("it")) {
            code = "IT";
        } else if (lang.equals("en")) {
            code = "US";
        } else if (lang.equals("ms")) {
            code = "MY";
        } else if (lang.equals("pt")) {
            code = "PT";
        } else if (lang.equals("en")) {
            code = "US";
        } else if (lang.equals("ru")) {
            code = "RU";
        } else if (lang.equals("es")) {
            code = "ES";
        } else if (lang.equals("sv")) {
            code = "SE";
        } else {
            String[] cod = LanguageCodes.getCodes();
            for (int i = 0; i < cod.length; ++i) {
                String code1 = cod[i];
                if (code1.length() != 5) continue;
                String s1 = code1.substring(0, 2);
                String s2 = code1.substring(3, 5);
                if (!lang.equals(s1)) continue;
                code = s2;
                break;
            }
        }
        return code;
    }

    public static String getName(String code) {
        int k;
        String name = null;
        for (int i = 0; i < codes.length; ++i) {
            String s = codes[i];
            if (!code.equalsIgnoreCase(s)) continue;
            name = names[i];
            break;
        }
        if (name == null && (k = code.indexOf("-")) != -1) {
            code = code.substring(0, k);
            for (int i = 0; i < codes.length; ++i) {
                String s = codes[i];
                if (!code.equalsIgnoreCase(s)) continue;
                name = names[i];
                break;
            }
        }
        return name;
    }

    public static Set getCurrentLangNames() {
        return currentNames;
    }

    public static void updateCurrentLangNames(String[] langs) {
        if (langs == null) {
            return;
        }
        if (currentNames == null) {
            currentNames = new LinkedHashSet(8);
        }
        for (int i = 0; i < langs.length; ++i) {
            String lang = langs[i];
            if (lang == null || lang.length() <= 0) continue;
            if (currentNames.size() < 8) {
                currentNames.add(lang);
                continue;
            }
            Iterator iterator = currentNames.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            currentNames.add(lang);
        }
    }

    public static String currentLangNamesToString() {
        StringBuilder sb = new StringBuilder();
        if (currentNames != null) {
            for (String s : currentNames) {
                if (sb.length() + s.length() >= 8192) continue;
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static String[] getNames() {
        return names;
    }

    public static String[] getCodes() {
        return codes;
    }

    static {
        names = new String[]{"Afrikaans (af-ZA)", "Albanian (sq-AL)", "Amharic (am-ET)", "Arabic - Algeria (ar-DZ)", "Arabic - Bahrain (ar-BH)", "Arabic - Egypt (ar-EG)", "Arabic - Iraq (ar-IQ)", "Arabic - Jordan (ar-JO)", "Arabic - Kuwait (ar-KW)", "Arabic - Lebanon (ar-LB)", "Arabic - Libya (ar-LY)", "Arabic - Morocco (ar-MA)", "Arabic - Oman (ar-OM)", "Arabic - Qatar (ar-QA)", "Arabic - Saudi Arabia (ar-SA)", "Arabic - Syria (ar-SY)", "Arabic - Tunisia (ar-TN)", "Arabic - United Arab Emirates (ar-AE)", "Arabic - Yemen (ar-YE)", "Armenian (hy-AM)", "Assamese (as-IN)", "Asturian (ast)", "Azeri (az-AZ)", "Basque (eu-ES)", "Belarusian (be-BY)", "Bengali - Bangladesh (bn-BD)", "Bengali - India (bn-IN)", "Bislama (bi-VU)", "Bosnian (bs-BA)", "Bulgarian (bg-BG)", "Burmese (my-MM)", "Catalan (ca-ES)", "Cebuano (ceb)", "Chichewa (ny)", "Chinese - China (zh-CN)", "Chinese - Hong Kong SAR (zh-HK)", "Chinese - Macau SAR (zh-MO)", "Chinese - Singapore (zh-SG)", "Chinese - Taiwan (zh-TW)", "Cornish (kw-GB)", "Corsican (co-IT)", "Croatian (hr-HR)", "Czech (cs-CZ)", "Danish (da-DK)", "Divehi; Dhivehi; Maldivian (dv-MV)", "Dutch - Belgium (nl-BE)", "Dutch - Netherlands (nl-NL)", "East Franconian (vmf)", "English - Australia (en-AU)", "English - Belize (en-BZ)", "English - Canada (en-CA)", "English - Caribbean (en-CB)", "English - Great Britain (en-GB)", "English - India (en-IN)", "English - Ireland (en-IE)", "English - Jamaica (en-JM)", "English - New Zealand (en-NZ)", "English - Phillippines (en-PH)", "English - Southern Africa (en-ZA)", "English - Trinidad (en-TT)", "English - United States (en-US)", "Esperanto (eo-EO)", "Estonian (et-EE)", "Faroese (fo-FO)", "Farsi - Persian (fa-IR)", "Filipino (tl-PH)", "Finnish (fi-FI)", "French - Belgium (fr-BE)", "French - Canada (fr-CA)", "French - France (fr-FR)", "French - Luxembourg (fr-LU)", "French - Switzerland (fr-CH)", "Frisian (fy-NL)", "FYRO Macedonia (mk-MK)", "Gaelic - Ireland (ga-IE)", "Gaelic - Scotland (gd-GB)", "Galician (gl-ES)", "Georgian (ka-GE)", "German - Austria (de-AT)", "German - Germany (de-DE)", "German - Liechtenstein (de-LI)", "German - Luxembourg (de-LU)", "German - Switzerland (de-CH)", "Greek (el-GR)", "Guarani - Paraguay (gn-PY)", "Gujarati (gu-IN)", "Haitian Creole (ht-HT)", "Hausa (ha)", "Hawaiian (haw)", "Hebrew (he-IL)", "Hiligaynon (hil)", "Hindi (hi-IN)", "Hmong (hmn)", "Hungarian (hu-HU)", "Hunsrik (hrx)", "Icelandic (is-IS)", "Igbo (ig-NG)", "Iloko (ilo)", "Indonesian (id-ID)", "Italian - Italy (it-IT)", "Italian - Switzerland (it-CH)", "Japanese (ja-JP)", "Javanese (jv-ID)", "Kannada (kn-IN)", "Kashmiri (ks-IN)", "Kazakh (kk-KZ)", "Khmer (km-KH)", "Kongo (kg)", "Korean (ko-KR)", "Kurdish - Kurmanji (kmr)", "Kyrgyz (ky)", "Lao (lo-LA)", "Latin (la-VA)", "Latvian (lv-LV)", "Lingala (ln)", "Lithuanian (lt-LT)", "Luxembourgish (lb-LU)", "Macedonian (mk-MK)", "Malagasy (mg)", "Malay - Brunei (ms-BN)", "Malay - Malaysia (ms-MY)", "Malayalam (ml-IN)", "Maltese (mt-MT)", "Maori (mi-NZ)", "Marathi (mr-IN)", "Marshallese (mh-MH)", "Mongolian (mn-MN)", "Neapolitan (nap)", "Nepali (ne-NP)", "Norwegian - Bokml (nb-NO)", "Norwegian - Nynorsk (nn-NO)", "Occitan (oc)", "Oriya (or-IN)", "Papiamentu (pap)", "Pashto (ps)", "Polish (pl-PL)", "Portuguese - Brazil (pt-BR)", "Portuguese - Portugal (pt-PT)", "Punjabi (pa-IN)", "Rhaeto-Romance (rm-CH)", "Romanian - Romania (ro-RO)", "Russian (ru-RU)", "Russian - Moldova (ru-MO)", "Samoan (sm)", "Sanskrit (sa-IN)", "Serbian (sr-SP)", "Sesotho (st)", "Setswana/Tswana - South Africa (tn-ZA)", "Setswana/Tswana - Botswana (tn-BW)", "Shona (sn)", "Sicilian (scn)", "Sindhi (sd)", "Sinhala; Sinhalese (si-LK)", "Slovak (sk-SK)", "Slovenian (sl-SI)", "Somali (so-SO)", "Sorbian (sb-DE)", "Spanish - Argentina (es-AR)", "Spanish - Bolivia (es-BO)", "Spanish - Chile (es-CL)", "Spanish - Colombia (es-CO)", "Spanish - Costa Rica (es-CR)", "Spanish - Dominican Republic (es-DO)", "Spanish - Ecuador (es-EC)", "Spanish - El Salvador (es-SV)", "Spanish - Guatemala (es-GT)", "Spanish - Honduras (es-HN)", "Spanish - Mexico (es-MX)", "Spanish - Nicaragua (es-NI)", "Spanish - Panama (es-PA)", "Spanish - Paraguay (es-PY)", "Spanish - Peru (es-PE)", "Spanish - Puerto Rico (es-PR)", "Spanish - Spain (es-ES)", "Spanish - Uruguay (es-UY)", "Spanish - Venezuela (es-VE)", "Spanish - Neutral (es)", "Sundanese (su-ID)", "Swahili - Kenya (sw-KE)", "Swahili - Tanzania (sw-TZ)", "Swedish - Finland (sv-FI)", "Swedish - Sweden (sv-SE)", "Tagalog (tl-PH)", "Tajik (tg-TJ)", "Tamil (ta-IN)", "Tatar (tt-RU)", "Telugu (te-IN)", "Thai (th-TH)", "Tibetan (bo)", "Tsonga (ts-ZA)", "Turkish (tr-TR)", "Turkmen (tk-TM)", "Ukrainian (uk-UA)", "Urdu (ur)", "Uzbek (uz-UZ)", "Venetian (vec)", "Vietnamese (vi-VN)", "Welsh (cy-GB)", "Wolof (wo)", "Xhosa (xh-ZA)", "Yiddish (yi)", "Yoruba (yo)", "Zulu (zu-ZA)"};
        codes = new String[]{"af-ZA", "sq-AL", "am-ET", "ar-DZ", "ar-BH", "ar-EG", "ar-IQ", "ar-JO", "ar-KW", "ar-LB", "ar-LY", "ar-MA", "ar-OM", "ar-QA", "ar-SA", "ar-SY", "ar-TN", "ar-AE", "ar-YE", "hy-AM", "as-IN", "ast", "az-AZ", "eu-ES", "be-BY", "bn-BD", "bn-IN", "bi-VU", "bs-BA", "bg-BG", "my-MM", "ca-ES", "ceb", "ny", "zh-CN", "zh-HK", "zh-MO", "zh-SG", "zh-TW", "kw-GB", "co-IT", "hr-HR", "cs-CZ", "da-DK", "dv-MV", "nl-BE", "nl-NL", "vmf", "en-AU", "en-BZ", "en-CA", "en-CB", "en-GB", "en-IN", "en-IE", "en-JM", "en-NZ", "en-PH", "en-ZA", "en-TT", "en-US", "eo-EO", "et-EE", "fo-FO", "fa-IR", "tl-PH", "fi-FI", "fr-BE", "fr-CA", "fr-FR", "fr-LU", "fr-CH", "fy-NL", "mk-MK", "ga-IE", "gd-GB", "gl-ES", "ka-GE", "de-AT", "de-DE", "de-LI", "de-LU", "de-CH", "el-GR", "gn-PY", "gu-IN", "ht-HT", "ha", "haw", "he-IL", "hil", "hi-IN", "hmn", "hu-HU", "hrx", "is-IS", "ig-NG", "ilo", "id-ID", "it-IT", "it-CH", "ja-JP", "jv-ID", "kn-IN", "ks-IN", "kk-KZ", "km-KH", "kg", "ko-KR", "kmr", "ky", "lo-LA", "la-VA", "lv-LV", "ln", "lt-LT", "lb-LU", "mk-MK", "mg", "ms-BN", "ms-MY", "ml-IN", "mt-MT", "mi-NZ", "mr-IN", "mh-MH", "mn-MN", "nap", "ne-NP", "nb-NO", "nn-NO", "oc", "or-IN", "pap", "ps", "pl-PL", "pt-BR", "pt-PT", "pa-IN", "rm-CH", "ro-RO", "ru-RU", "ru-MO", "sm", "sa-IN", "sr-SP", "st", "tn-ZA", "tn-BW", "sn", "scn", "sd", "si-LK", "sk-SK", "sl-SI", "so-SO", "sb-DE", "es-AR", "es-BO", "es-CL", "es-CO", "es-CR", "es-DO", "es-EC", "es-SV", "es-GT", "es-HN", "es-MX", "es-NI", "es-PA", "es-PY", "es-PE", "es-PR", "es-ES", "es-UY", "es-VE", "es", "su-ID", "sw-KE", "sw-TZ", "sv-FI", "sv-SE", "tl-PH", "tg-TJ", "ta-IN", "tt-RU", "te-IN", "th-TH", "bo", "ts-ZA", "tr-TR", "tk-TM", "uk-UA", "ur", "uz-UZ", "vec", "vi-VN", "cy-GB", "wo", "xh-ZA", "yi", "yo", "zu-ZA"};
    }
}

