/*
 * Decompiled with CFR 0.152.
 */
package translator;

import javax.swing.SwingUtilities;

public abstract class MySwingWorker {
    private Object value;
    private int priority = 1;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public MySwingWorker() {
        final Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                MySwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){
            final /* synthetic */ MySwingWorker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.setValue(this.this$0.construct());
                }
                finally {
                    this.this$0.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public void start() {
        Thread t = this.threadVar.get();
        t.setPriority(this.priority);
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

