/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class MyUndoListener
implements UndoableEditListener {
    protected UndoManager undo = new UndoManager();
    private CompoundEdit compound;
    private boolean space = false;
    private boolean compoundEditBreak = false;
    private boolean compoundEditEnd = true;

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.compoundEditBreak) {
            if (this.compound != null) {
                this.compound.addEdit(e.getEdit());
                this.compound.end();
                this.undo.addEdit(this.compound);
                this.compound = new CompoundEdit();
            } else {
                this.compound = new CompoundEdit();
                this.compound.addEdit(e.getEdit());
            }
            this.compoundEditBreak = false;
        } else if (this.compoundEditEnd) {
            if (this.compound != null) {
                this.compound.end();
                this.undo.addEdit(this.compound);
            }
            this.compound = new CompoundEdit();
            this.compound.addEdit(e.getEdit());
        } else if (this.compound == null) {
            this.compound = new CompoundEdit();
            this.compound.addEdit(e.getEdit());
        } else {
            this.compound.addEdit(e.getEdit());
        }
        this.compoundEditEnd = true;
    }

    public void undoableEditHappenedOld(UndoableEditEvent e) {
        block22: {
            if (e.getEdit() instanceof AbstractDocument.DefaultDocumentEvent) {
                AbstractDocument.DefaultDocumentEvent edit = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
                if (edit.getType() == DocumentEvent.EventType.INSERT) {
                    int length = edit.getLength();
                    int offset = edit.getOffset();
                    Document doc = edit.getDocument();
                    try {
                        String string = doc.getText(offset, length);
                        int trim = string.trim().length();
                        if (length == 1 && trim > 0) {
                            if (this.compound == null) {
                                this.compound = new CompoundEdit();
                            } else if (this.space) {
                                this.compound.end();
                                this.undo.addEdit(this.compound);
                                this.compound = new CompoundEdit();
                            }
                            this.compound.addEdit(edit);
                            this.space = false;
                            break block22;
                        }
                        if (trim == 0) {
                            if (this.compound != null) {
                                if (!this.space) {
                                    this.compound.end();
                                    this.undo.addEdit(this.compound);
                                    this.compound = null;
                                } else {
                                    this.compound.addEdit(edit);
                                    return;
                                }
                            }
                            this.compound = new CompoundEdit();
                            this.compound.addEdit(edit);
                            this.space = true;
                            break block22;
                        }
                        if (this.compound != null) {
                            this.compound.end();
                            this.undo.addEdit(this.compound);
                            this.compound = null;
                        }
                        this.compound = new CompoundEdit();
                        this.compound.addEdit(edit);
                        this.space = false;
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(MyUndoListener.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (edit.getType() == DocumentEvent.EventType.REMOVE) {
                    if (this.compound != null) {
                        this.compound.end();
                        this.undo.addEdit(this.compound);
                        this.compound = null;
                    }
                    this.undo.addEdit(edit);
                } else {
                    if (this.compound == null) {
                        this.compound = new CompoundEdit();
                    }
                    this.compound.addEdit(edit);
                }
            } else {
                if (this.compound == null) {
                    this.compound = new CompoundEdit();
                } else if (e.getEdit().isSignificant()) {
                    this.compound.end();
                    this.undo.addEdit(this.compound);
                    this.compound = new CompoundEdit();
                }
                this.compound.addEdit(e.getEdit());
            }
        }
    }

    public void compoundEditBreak(boolean b) {
        this.compoundEditBreak = b;
    }

    public void compoundEditEnd(boolean b) {
        this.compoundEditEnd = b;
    }

    public void undoAction() {
        if (this.compound != null) {
            this.compound.end();
            this.undo.addEdit(this.compound);
            this.compound = null;
        }
        try {
            if (this.undo.canUndo()) {
                this.undo.undo();
            }
        }
        catch (CannotUndoException ex) {
            System.out.println("Unable to undo: " + ex);
            ex.printStackTrace();
        }
    }

    public void redoAction() {
        try {
            if (this.undo.canRedo()) {
                this.undo.redo();
            }
        }
        catch (CannotRedoException ex) {
            System.out.println("Unable to redo: " + ex);
            ex.printStackTrace();
        }
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        if (this.compound != null) {
            this.compoundEditBreak = true;
            this.compound.die();
        }
    }

    public void setLimit(int limit) {
        this.undo.setLimit(limit);
    }
}

