/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.Project;

public class Placeables {
    static String path = AppPreferences.packagePath + "resources" + AppPreferences.fs + "placeables";
    private static Set placeablesSet = new HashSet();
    private static Set placeablesSetHidden = new HashSet();
    private static HashMap conversionMap = new HashMap();
    private static HashMap placeablesMap = new HashMap();
    private static String filePath;
    public static String whiteSpaces;
    public static String numberExpressions;
    private static Map placeablePatternsMap;
    private static List currentPlaceablePatterns;
    private static boolean isEmpy;
    private static ConcurrentHashMap maskMap;
    private static Pattern groupPattern;

    public static String maskSource(String source) {
        if (AppPreferences.maskNontranslatables && !maskMap.isEmpty()) {
            for (Map.Entry entry : maskMap.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                source = source.replace(value, key);
            }
        }
        return source;
    }

    public static synchronized String unmaskTarget(String target) {
        if (AppPreferences.maskNontranslatables && !maskMap.isEmpty()) {
            for (Map.Entry entry : maskMap.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                target = target.replace(key, value);
            }
        }
        return target;
    }

    public static void maskPlaceable(String p) {
        p = p.trim();
        if (!AppPreferences.maskNontranslatables || p.length() < 4) {
            return;
        }
        int randomNum = ThreadLocalRandom.current().nextInt(10000, 100000);
        maskMap.put(String.valueOf(randomNum), p);
    }

    public static void resetMasking() {
        if (AppPreferences.maskNontranslatables) {
            maskMap.clear();
        }
    }

    public static List getCurrentPlaceablePatterns() {
        return currentPlaceablePatterns;
    }

    public static void addCurrentPlaceablePattern(Pattern p) {
        if (currentPlaceablePatterns == null) {
            currentPlaceablePatterns = new ArrayList();
        }
        currentPlaceablePatterns.add(p);
    }

    public static void clearCurrentPlaceables() {
        if (currentPlaceablePatterns != null) {
            currentPlaceablePatterns.clear();
        }
        if (!conversionMap.isEmpty()) {
            conversionMap.clear();
        }
    }

    public static Pattern getPlaceablePattern(String s) {
        if (placeablePatternsMap != null) {
            return (Pattern)placeablePatternsMap.get(s);
        }
        return null;
    }

    public static void putPlaceablePattern(String s, Pattern p) {
        if (placeablePatternsMap == null) {
            placeablePatternsMap = new HashMap();
        }
        placeablePatternsMap.put(s, p);
    }

    public static Set getPlaceablesSet() {
        return placeablesSet;
    }

    public static Set getPlaceablesSetHidden() {
        return placeablesSetHidden;
    }

    public static String getPlaceablesPath() {
        return filePath;
    }

    public static String convertPlaceable(String key) {
        Matcher matcher;
        if (!conversionMap.isEmpty() && (matcher = (Matcher)conversionMap.get(key)) != null) {
            matcher.reset();
            if (matcher.find()) {
                String key2 = matcher.pattern().toString();
                String value = (String)placeablesMap.get("|" + key2);
                if (value != null && value.length() > 0) {
                    StringBuffer sb = new StringBuffer();
                    int gcount = matcher.groupCount();
                    Matcher m = groupPattern.matcher(value);
                    while (m.find()) {
                        String gr = m.group();
                        String digitString = gr.substring(1, gr.length() - 1);
                        int digit = Integer.valueOf(digitString);
                        if (digit > gcount) continue;
                        String s = matcher.group(digit);
                        m.appendReplacement(sb, s);
                    }
                    m.appendTail(sb);
                    String match = sb.toString();
                    return match;
                }
            }
        }
        return null;
    }

    public static void addPlaceableToConversionMap(String key, Matcher ma) {
        String key2 = ma.pattern().toString();
        String value = (String)placeablesMap.get("|" + key2);
        if (value != null && value.length() > 0) {
            StringBuffer sb = new StringBuffer();
            int gcount = ma.groupCount();
            Matcher m = groupPattern.matcher(value);
            while (m.find()) {
                String gr = m.group();
                String digitString = gr.substring(1, gr.length() - 1);
                int digit = Integer.valueOf(digitString);
                if (digit > gcount) continue;
                String s = ma.group(digit);
                m.appendReplacement(sb, s);
            }
            m.appendTail(sb);
            String match = sb.toString();
            conversionMap.put(key, match);
        }
    }

    public static String getConvertedPlaceable(String key) {
        return (String)conversionMap.get(key);
    }

    public static String getPlaceablesForConversion(String key) {
        String v = (String)placeablesMap.get(key);
        return v;
    }

    public static void addPlaceable(String pl) {
        int i = pl.indexOf("=");
        while (i != -1) {
            char c;
            int j = i - 1;
            int k = i + 1;
            if (j != -1 && (c = pl.charAt(j)) != '\\' && k < pl.length()) {
                String key = pl.substring(0, i);
                String value = pl.substring(k);
                if (key.length() <= 0 || value.length() <= 0) break;
                placeablesMap.put(key, value);
                pl = key;
                break;
            }
            i = pl.indexOf("=", k);
        }
        if (pl.endsWith("^") && pl.length() > 1) {
            placeablesSetHidden.add(pl.substring(0, pl.length() - 1));
        } else if (pl.length() > 0) {
            placeablesSet.add(pl);
        }
    }

    public static void removePlaceable(String pl) {
        if (pl.endsWith("^") && pl.length() > 1) {
            placeablesSetHidden.remove(pl.substring(0, pl.length() - 1));
            if (placeablePatternsMap != null) {
                placeablePatternsMap.remove(pl.substring(0, pl.length() - 1));
            }
        } else {
            placeablesSet.remove(pl);
            if (placeablePatternsMap != null) {
                placeablePatternsMap.remove(pl);
            }
        }
    }

    public static void clearPlaceables() {
        if (!placeablesSet.isEmpty()) {
            placeablesSet.clear();
        }
        if (!placeablesSetHidden.isEmpty()) {
            placeablesSetHidden.clear();
        }
        if (!placeablesMap.isEmpty()) {
            placeablesMap.clear();
        }
        if (placeablePatternsMap != null) {
            placeablePatternsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlaceables() {
        Placeables.clearPlaceables();
        filePath = path + AppPreferences.fs + AppPreferences.placeablesFile;
        File file = new File(filePath);
        if (!file.exists()) {
            boolean b;
            File fdir = new File(path);
            if (!fdir.exists() && (b = fdir.mkdir())) {
                try {
                    file.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(Placeables.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            FileInputStream fis = null;
            try {
                String eline;
                fis = new FileInputStream(file);
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                while ((eline = r.readLine()) != null) {
                    int hash = eline.indexOf(35);
                    if (hash != -1) {
                        if (eline.charAt(0) == '#') continue;
                        eline = eline.substring(0, hash);
                    }
                    if (eline.length() <= 0) continue;
                    Placeables.addPlaceable(eline);
                }
                if (!placeablesSet.isEmpty() || !placeablesSetHidden.isEmpty()) {
                    isEmpy = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + file.getPath());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        placeablesSet.add("|" + whiteSpaces);
        placeablesSet.add("|" + numberExpressions);
    }

    public static void savePlaceables(String pl) {
        String con;
        if (!isEmpy) {
            con = AppPreferences.ls + pl;
        } else {
            con = pl;
            isEmpy = false;
        }
        try {
            File file = new File(path + AppPreferences.fs + AppPreferences.placeablesFile);
            Charset charset = Charset.forName("UTF-8");
            CharsetEncoder encoder = charset.newEncoder();
            FileOutputStream foss = new FileOutputStream(file, true);
            FileChannel fc = foss.getChannel();
            CharBuffer cb = CharBuffer.wrap(con);
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            foss.close();
            fc.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void sortByLength(List list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int len1 = s1.length();
                int len2 = s2.length();
                return len2 - len1;
            }
        });
    }

    static {
        whiteSpaces = "[ \u3000\u00a0\t]{2,}";
        numberExpressions = "\\d+([., \u00a0]\\d+)*(['/:=+\\-\u00b0$\u20ac]\\d*)*";
        isEmpy = true;
        maskMap = new ConcurrentHashMap();
        groupPattern = Pattern.compile("\\(\\d+\\)");
    }
}

