/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import translator.AppPreferences;
import translator.MainView;
import translator.ProjectView;
import translator.ResourceLoader;

public class ProjectTemplate {
    private Preferences pref;
    private Preferences node;
    private Preferences templatesMap;
    private File templateFile;
    private String currentProject;

    public ProjectTemplate() {
        this.pref = AppPreferences.getPreferences();
        this.templatesMap = this.pref.node("templatesMap");
    }

    public ProjectTemplate(File file) {
        this.templateFile = file;
        this.pref = AppPreferences.getPreferences();
        this.templatesMap = this.pref.node("templatesMap");
    }

    public Preferences createTemplateNode() {
        this.node = this.pref.node("template");
        return this.node;
    }

    public void setProjectResources(MainView topui) {
        this.node.putInt("mt", AppPreferences.mt);
        this.node.putInt("mt2", AppPreferences.mt2);
        this.node.putInt("mt3", AppPreferences.mt3);
        this.node.putInt("mt4", AppPreferences.mt4);
        this.node.putInt("mt5", AppPreferences.mt5);
        this.node.putInt("mt6", AppPreferences.mt6);
        this.node.putInt("mt7", AppPreferences.mt7);
        this.node.putInt("mt8", AppPreferences.mt8);
        this.node.put("recallTables", AppPreferences.recallTables);
        ResourceLoader loader = topui.getResourceLoader();
        loader.setLastResourcesString();
        loader.setLastGlossariesString();
        loader.setLastMemoriesString();
        this.node.put("glossaries", AppPreferences.glossaries);
        this.node.put("glossaries2", AppPreferences.glossaries2);
        this.node.put("resources", AppPreferences.resources);
        this.node.put("segmentMemories", AppPreferences.segmentMemories);
        this.node.put("segmentMemories2", AppPreferences.segmentMemories2);
        loader.setLastSessionResourcesString();
        this.node.put("resourcesLastSession", AppPreferences.resourcesLastSession);
        this.node.put("resourcesLastSession2", AppPreferences.resourcesLastSession2);
        this.node.put("currentTUNumber", AppPreferences.currentTUNumber);
    }

    public void setCTPreferences() {
        boolean docsFolder = AppPreferences.documentsFolder;
        this.node.putBoolean("documentsFolder", docsFolder);
        this.node.put("fileslang", AppPreferences.fileSLang);
        this.node.put("filetlang", AppPreferences.fileTLang);
        this.node.put("projectlocation", AppPreferences.projectLocationDir);
        this.node.put("sourceFilesDirectory", AppPreferences.sourceFilesDirectory);
        this.node.put("autodockName1", AppPreferences.autodockName1);
        this.node.put("autodockName2", AppPreferences.autodockName2);
        this.node.put("autodockName3", AppPreferences.autodockName3);
        this.node.put("autoFloat", AppPreferences.autoFloat);
        this.node.put("joinedTabsNames", AppPreferences.joinedTabsNames);
        this.node.put("dockedTabsNames", AppPreferences.dockedTabsNames);
        this.node.put("activeTab", AppPreferences.activeTab);
        this.node.put("view", AppPreferences.editorsSplit);
        this.node.put("flip", AppPreferences.editorsLocation);
        this.node.putBoolean("sflip", AppPreferences.editorsFlip);
        this.node.putBoolean("detached", AppPreferences.detached);
        this.node.putInt("panoramic", AppPreferences.windowsLayout);
        this.node.putInt("frameExtendedState", AppPreferences.frameExtendedState);
        this.node.putInt("width", AppPreferences.width);
        this.node.putInt("heigth", AppPreferences.heigth);
        this.node.putInt("posX", AppPreferences.posX);
        this.node.putInt("posY", AppPreferences.posY);
        this.node.putInt("posXFind", AppPreferences.posXFind);
        this.node.putInt("posYFind", AppPreferences.posYFind);
        this.node.putInt("width2", AppPreferences.width2);
        this.node.putInt("heigth2", AppPreferences.heigth2);
        this.node.putInt("posX2", AppPreferences.posX2);
        this.node.putInt("posY2", AppPreferences.posY2);
        this.node.putInt("glossaryDialogWidth", AppPreferences.glossaryDialogWidth);
        this.node.putInt("divider", AppPreferences.divider);
        this.node.putInt("divider2", AppPreferences.divider2);
        this.node.putInt("editorsDivider", AppPreferences.editorsDivider);
        this.node.putInt("dock1divider", AppPreferences.dock1divider);
        this.node.putInt("dock2divider", AppPreferences.dock2divider);
        this.node.putInt("dock3divider", AppPreferences.dock3divider);
        this.node.putInt("dock4divider", AppPreferences.dock4divider);
        this.node.putInt("dock5divider", AppPreferences.dock5divider);
        this.node.putInt("dock6divider", AppPreferences.dock6divider);
        this.node.putInt("dashboardDivider", AppPreferences.dashboardDivider);
        this.node.putInt("dashboardDivider1", AppPreferences.dashboardDivider1);
        this.node.putInt("dashboardDivider2", AppPreferences.dashboardDivider2);
        this.node.putInt("dashboardDivider3", AppPreferences.dashboardDivider3);
        this.node.putBoolean("tabsVerticalDivider", AppPreferences.tabsVerticalDivider);
        this.node.putBoolean("dockingVerticalDivider", AppPreferences.dockingVerticalDivider);
        this.node.putBoolean("bindExternalEditor", AppPreferences.bindExternalEditor);
        this.node.put("editorBinding", AppPreferences.editorBinding);
        this.node.put("billing", AppPreferences.billing);
        this.node.put("replacesourcechars", AppPreferences.replaceSourceChars);
        this.node.put("replacetargetchars", AppPreferences.replaceTargetChars);
        this.node.putBoolean("replaceattransfer", AppPreferences.replaceAtTransfer);
        this.node.put("replacepunctsourcechars", AppPreferences.replacePunctSourceChars);
        this.node.put("replacepuncttargetchars", AppPreferences.replacePunctTargetChars);
        this.node.putBoolean("replacepunctattransfer", AppPreferences.replacePunctAtTransfer);
        this.node.put("punctuation", AppPreferences.punctuationString);
        this.node.putBoolean("QACheck1", AppPreferences.QACheck1);
        this.node.putBoolean("QACheck2", AppPreferences.QACheck2);
        this.node.putBoolean("QACheck3", AppPreferences.QACheck3);
        this.node.putBoolean("QACheck4", AppPreferences.QACheck4);
        this.node.putBoolean("QACheck5", AppPreferences.QACheck5);
        this.node.putBoolean("QACheck6", AppPreferences.QACheck6);
        this.node.putBoolean("QACheck7", AppPreferences.QACheck7);
        this.node.putBoolean("QACheck8", AppPreferences.QACheck8);
        this.node.putBoolean("QACheck9", AppPreferences.QACheck9);
        this.node.putBoolean("QACheck10", AppPreferences.QACheck10);
        this.node.putBoolean("QACheck11", AppPreferences.QACheck11);
        this.node.putBoolean("QACheck12", AppPreferences.QACheck12);
        this.node.putBoolean("QACheck13", AppPreferences.QACheck13);
        this.node.putBoolean("QACheck14", AppPreferences.QACheck14);
        this.node.putBoolean("QACheck15", AppPreferences.QACheck15);
        this.node.putBoolean("QACheck16", AppPreferences.QACheck16);
        this.node.putBoolean("QACheck17", AppPreferences.QACheck17);
        this.node.putBoolean("QACheck18", AppPreferences.QACheck18);
        this.node.putBoolean("QACheck19", AppPreferences.QACheck19);
        this.node.putBoolean("QACheck20", AppPreferences.QACheck20);
        this.node.putBoolean("QACheck21", AppPreferences.QACheck21);
        this.node.putBoolean("QACheck22", AppPreferences.QACheck22);
        this.node.putBoolean("QACheck23", AppPreferences.QACheck23);
        this.node.putBoolean("QACheck24", AppPreferences.QACheck24);
        this.node.putBoolean("glossaryPrefixMatch", AppPreferences.glossaryPrefixMatch);
        this.node.putInt("memPrefixLength", AppPreferences.memPrefixLength);
        this.node.putBoolean("skiptranslated", AppPreferences.skipTranslated);
        this.node.putBoolean("skiprepetions", AppPreferences.skipRepetions);
        this.node.putBoolean("skipnumbers", AppPreferences.skipNumbers);
        this.node.putBoolean("skipreviewed", AppPreferences.skipReviewed);
        this.node.putBoolean("skipperfect", AppPreferences.skipPerfectMatches);
        this.node.putBoolean("skipnoletters", AppPreferences.skipNoLetters);
        this.node.put("chatGPTPromptTranslate", AppPreferences.chatGPTPromptTranslate);
        this.node.put("chatGPTPromptCheck", AppPreferences.chatGPTPromptCheck);
        this.node.put("chatGPTPromptM1", AppPreferences.chatGPTPromptM1);
        this.node.put("chatGPTPromptM2", AppPreferences.chatGPTPromptM2);
        this.node.put("chatGPTPromptM3", AppPreferences.chatGPTPromptM3);
        this.node.put("chatGPTPromptM4", AppPreferences.chatGPTPromptM4);
        this.node.put("chatGPTPromptM5", AppPreferences.chatGPTPromptM5);
        this.node.put("chatGPTPromptM6", AppPreferences.chatGPTPromptM6);
        this.node.put("chatGPTPromptM7", AppPreferences.chatGPTPromptM7);
        this.node.put("chatGPTPromptM8", AppPreferences.chatGPTPromptM8);
        this.node.put("chatGPTPromptM9", AppPreferences.chatGPTPromptM9);
        this.node.put("chatGPTPromptM10", AppPreferences.chatGPTPromptM10);
        this.node.put("chatGPTPromptSystem", AppPreferences.chatGPTPromptSystem);
        this.node.put("chatGPTGlossary", AppPreferences.chatGPTGlossary);
        this.node.putInt("chatGPTDefaultPrompt", AppPreferences.chatGPTDefaultPrompt);
        this.node.putInt("chatGPTDefaultContext", AppPreferences.chatGPTDefaultContext);
        this.node.putInt("chatGPTSpeak", AppPreferences.chatGPTSpeak);
        this.node.putBoolean("chatGPTPause", AppPreferences.chatGPTPause);
        this.node.putBoolean("chatGPTHideButtons", AppPreferences.chatGPTHideButtons);
        this.node.putBoolean("chatGPTTargetEditorChatMode", AppPreferences.chatGPTTargetEditorChatMode);
    }

    public void saveTemplate() {
        if (this.templateFile != null) {
            AppPreferences.exportPreferencesNode(this.node, this.templateFile);
        }
    }

    public void mapProjectToTemplate(String projectPath) {
        if (projectPath != null && this.templateFile != null && this.templateFile.exists()) {
            String templateName = this.templateFile.getName();
            File file = new File(projectPath);
            String name = file.getName();
            if (name != null) {
                if (name.length() > 80) {
                    name = Integer.toString(name.hashCode());
                }
                this.templatesMap.put(name, templateName);
            }
        }
    }

    public void setProjectTemplate(String projectPath) {
        File pf;
        String name;
        if (this.templatesMap != null && projectPath != null && (name = (pf = new File(projectPath)).getName()) != null) {
            String f;
            File file;
            String templateName;
            if (name.length() > 80) {
                name = Integer.toString(name.hashCode());
            }
            if ((templateName = this.templatesMap.get(name, "")) != null && templateName.length() > 0 && (file = new File(f = AppPreferences.templatesDirectory + AppPreferences.fs + templateName)).exists()) {
                this.templateFile = file;
                this.currentProject = projectPath;
            }
        }
    }

    public void removeProjectTemplate() {
        String templateName;
        if (this.templateFile != null && this.templatesMap != null && (templateName = this.templateFile.getName()) != null) {
            String[] keys;
            try {
                keys = this.templatesMap.keys();
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(ProjectTemplate.class.getName()).log(Level.SEVERE, null, ex);
                keys = null;
            }
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    String value = this.templatesMap.get(key, "");
                    if (value == null || !value.equals(templateName)) continue;
                    this.templatesMap.remove(key);
                }
                try {
                    this.templatesMap.flush();
                }
                catch (BackingStoreException ex) {
                    Logger.getLogger(ProjectTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadTemplate() {
        if (this.templateFile == null || !this.templateFile.exists()) {
            return false;
        }
        boolean success = false;
        AppPreferences.importPreferences(this.templateFile);
        try {
            if (this.pref.nodeExists("template")) {
                this.node = this.pref.node("template");
                boolean docsFolder = this.node.getBoolean("documentsFolder", false);
                String sLang = this.node.get("fileslang", AppPreferences.fileSLang);
                String tLang = this.node.get("filetlang", AppPreferences.fileTLang);
                String prLocation = this.node.get("projectlocation", AppPreferences.projectLocationDir);
                String srcDir = this.node.get("sourceFilesDirectory", AppPreferences.sourceFilesDirectory);
                AppPreferences.fileSLang = sLang;
                AppPreferences.fileTLang = tLang;
                AppPreferences.documentsFolder = docsFolder;
                if (prLocation != null && prLocation.length() > 0) {
                    AppPreferences.projectLocationDir = prLocation;
                }
                if (srcDir != null && srcDir.length() > 0) {
                    AppPreferences.sourceFilesDirectory = srcDir;
                }
                AppPreferences.chatGPTPromptTranslate = this.node.get("chatGPTPromptTranslate", AppPreferences.chatGPTPromptTranslate);
                AppPreferences.chatGPTPromptCheck = this.node.get("chatGPTPromptCheck", AppPreferences.chatGPTPromptCheck);
                AppPreferences.chatGPTPromptM1 = this.node.get("chatGPTPromptM1", AppPreferences.chatGPTPromptM1);
                AppPreferences.chatGPTPromptM2 = this.node.get("chatGPTPromptM2", AppPreferences.chatGPTPromptM2);
                AppPreferences.chatGPTPromptM3 = this.node.get("chatGPTPromptM3", AppPreferences.chatGPTPromptM3);
                AppPreferences.chatGPTPromptM4 = this.node.get("chatGPTPromptM4", AppPreferences.chatGPTPromptM4);
                AppPreferences.chatGPTPromptM5 = this.node.get("chatGPTPromptM5", AppPreferences.chatGPTPromptM5);
                AppPreferences.chatGPTPromptM6 = this.node.get("chatGPTPromptM6", AppPreferences.chatGPTPromptM6);
                AppPreferences.chatGPTPromptM7 = this.node.get("chatGPTPromptM7", AppPreferences.chatGPTPromptM7);
                AppPreferences.chatGPTPromptM8 = this.node.get("chatGPTPromptM8", AppPreferences.chatGPTPromptM8);
                AppPreferences.chatGPTPromptM9 = this.node.get("chatGPTPromptM9", AppPreferences.chatGPTPromptM9);
                AppPreferences.chatGPTPromptM10 = this.node.get("chatGPTPromptM10", AppPreferences.chatGPTPromptM10);
                AppPreferences.chatGPTPromptSystem = this.node.get("chatGPTPromptSystem", AppPreferences.chatGPTPromptSystem);
                AppPreferences.chatGPTGlossary = this.node.get("chatGPTGlossary", AppPreferences.chatGPTGlossary);
                AppPreferences.chatGPTDefaultPrompt = this.node.getInt("chatGPTDefaultPrompt", AppPreferences.chatGPTDefaultPrompt);
                AppPreferences.chatGPTDefaultContext = this.node.getInt("chatGPTDefaultContext", AppPreferences.chatGPTDefaultContext);
                AppPreferences.chatGPTSpeak = this.node.getInt("chatGPTSpeak", AppPreferences.chatGPTSpeak);
                AppPreferences.chatGPTPause = this.node.getBoolean("chatGPTPause", AppPreferences.chatGPTPause);
                AppPreferences.chatGPTHideButtons = this.node.getBoolean("chatGPTHideButtons", AppPreferences.chatGPTHideButtons);
                AppPreferences.chatGPTTargetEditorChatMode = this.node.getBoolean("chatGPTTargetEditorChatMode", AppPreferences.chatGPTTargetEditorChatMode);
                AppPreferences.mt = this.node.getInt("mt", AppPreferences.mt);
                AppPreferences.mt2 = this.node.getInt("mt2", AppPreferences.mt2);
                AppPreferences.mt3 = this.node.getInt("mt3", AppPreferences.mt3);
                AppPreferences.mt5 = this.node.getInt("mt5", AppPreferences.mt5);
                AppPreferences.mt6 = this.node.getInt("mt6", AppPreferences.mt6);
                AppPreferences.mt7 = this.node.getInt("mt7", AppPreferences.mt7);
                AppPreferences.mt8 = this.node.getInt("mt8", AppPreferences.mt8);
                AppPreferences.mt4 = this.node.getInt("mt4", AppPreferences.mt4);
                AppPreferences.resourcesLastSession = this.node.get("resourcesLastSession", "");
                AppPreferences.resourcesLastSession2 = this.node.get("resourcesLastSession2", "");
                AppPreferences.recallTables = this.node.get("recallTables", "");
                AppPreferences.glossaries = this.node.get("glossaries", AppPreferences.glossaries);
                AppPreferences.glossaries2 = this.node.get("glossaries2", AppPreferences.glossaries2);
                AppPreferences.segmentMemories = this.node.get("segmentMemories", AppPreferences.segmentMemories);
                AppPreferences.segmentMemories2 = this.node.get("segmentMemories2", AppPreferences.segmentMemories2);
                AppPreferences.resources = this.node.get("resources", AppPreferences.resources);
                AppPreferences.projectGlossary = this.node.getBoolean("projectGlossary", AppPreferences.projectGlossary);
                AppPreferences.projectTMX = this.node.getBoolean("projectTMX", AppPreferences.projectTMX);
                AppPreferences.currentTUNumber = this.node.get("currentTUNumber", AppPreferences.currentTUNumber);
                AppPreferences.autodockName1 = this.node.get("autodockName1", "");
                AppPreferences.autodockName2 = this.node.get("autodockName2", "");
                AppPreferences.autodockName3 = this.node.get("autodockName3", "Matchboard");
                AppPreferences.autoFloat = this.node.get("autoFloat", "");
                AppPreferences.joinedTabsNames = this.node.get("joinedTabsNames", "");
                AppPreferences.dockedTabsNames = this.node.get("dockedTabsNames", "");
                AppPreferences.activeTab = this.node.get("activeTab", "");
                AppPreferences.editorsSplit = this.node.get("view", "Horizontal");
                AppPreferences.editorsLocation = this.node.get("flip", "South");
                AppPreferences.windowsLayout = this.node.getInt("panoramic", 3);
                AppPreferences.editorsFlip = this.node.getBoolean("sflip", false);
                AppPreferences.detached = this.node.getBoolean("detached", false);
                AppPreferences.frameExtendedState = this.node.getInt("frameExtendedState", -1);
                AppPreferences.width = this.node.getInt("width", -1);
                AppPreferences.heigth = this.node.getInt("heigth", -1);
                AppPreferences.posX = this.node.getInt("posX", 0);
                AppPreferences.posY = this.node.getInt("posY", 0);
                AppPreferences.posXFind = this.node.getInt("posXFind", -1);
                AppPreferences.posYFind = this.node.getInt("posYFind", -1);
                AppPreferences.width2 = this.node.getInt("width2", 1200);
                AppPreferences.heigth2 = this.node.getInt("heigth2", 800);
                AppPreferences.posX2 = this.node.getInt("posX2", 0);
                AppPreferences.posY2 = this.node.getInt("posY2", 0);
                AppPreferences.glossaryDialogWidth = this.node.getInt("glossaryDialogWidth", -1);
                AppPreferences.divider = this.node.getInt("divider", -1);
                AppPreferences.divider2 = this.node.getInt("divider2", -1);
                AppPreferences.editorsDivider = this.node.getInt("editorsDivider", -1);
                AppPreferences.dock1divider = this.node.getInt("dock1divider", -1);
                AppPreferences.dock2divider = this.node.getInt("dock2divider", -1);
                AppPreferences.dock3divider = this.node.getInt("dock3divider", -1);
                AppPreferences.dock4divider = this.node.getInt("dock4divider", -1);
                AppPreferences.dock5divider = this.node.getInt("dock5divider", -1);
                AppPreferences.dock6divider = this.node.getInt("dock6divider", -1);
                AppPreferences.dashboardDivider = this.node.getInt("dashboardDivider", -1);
                AppPreferences.dashboardDivider1 = this.node.getInt("dashboardDivider1", -1);
                AppPreferences.dashboardDivider2 = this.node.getInt("dashboardDivider2", -1);
                AppPreferences.dashboardDivider3 = this.node.getInt("dashboardDivider3", -1);
                AppPreferences.tabsVerticalDivider = this.node.getBoolean("tabsVerticalDivider", true);
                AppPreferences.dockingVerticalDivider = this.node.getBoolean("dockingVerticalDivider", true);
                AppPreferences.bindExternalEditor = this.node.getBoolean("bindExternalEditor", false);
                AppPreferences.editorBinding = this.node.get("editorBinding", "Clipboard binding");
                AppPreferences.billing = this.node.get("billing", "");
                AppPreferences.replaceSourceChars = this.node.get("replacesourcechars", ".");
                AppPreferences.replaceTargetChars = this.node.get("replacetargetchars", ",");
                AppPreferences.replaceAtTransfer = this.node.getBoolean("replaceattransfer", false);
                AppPreferences.replacePunctSourceChars = this.node.get("replacepunctsourcechars", " \"/-/\" /-/\u3002");
                AppPreferences.replacePunctTargetChars = this.node.get("replacepuncttargetchars", " \u00ab\u00a0/-/\u00a0\u00bb /-/.");
                AppPreferences.replacePunctAtTransfer = this.node.getBoolean("replacepunctattransfer", false);
                AppPreferences.punctuationString = this.node.get("punctuation", ",.\u3002:;!\u00a1?\u00bf[]{}()\"\u00ab\u00bb\u2018\u2019\u201c\u201d\u201e\u201a");
                AppPreferences.punctuation = AppPreferences.punctuationString.length() > 0 ? "[\\Q" + AppPreferences.punctuationString + "\\E]" : "";
                AppPreferences.QACheck1 = this.node.getBoolean("QACheck1", AppPreferences.QACheck1);
                AppPreferences.QACheck2 = this.node.getBoolean("QACheck2", AppPreferences.QACheck2);
                AppPreferences.QACheck3 = this.node.getBoolean("QACheck3", AppPreferences.QACheck3);
                AppPreferences.QACheck4 = this.node.getBoolean("QACheck4", AppPreferences.QACheck4);
                AppPreferences.QACheck5 = this.node.getBoolean("QACheck5", AppPreferences.QACheck5);
                AppPreferences.QACheck6 = this.node.getBoolean("QACheck6", AppPreferences.QACheck6);
                AppPreferences.QACheck7 = this.node.getBoolean("QACheck7", AppPreferences.QACheck7);
                AppPreferences.QACheck8 = this.node.getBoolean("QACheck8", AppPreferences.QACheck8);
                AppPreferences.QACheck9 = this.node.getBoolean("QACheck9", AppPreferences.QACheck9);
                AppPreferences.QACheck10 = this.node.getBoolean("QACheck10", AppPreferences.QACheck10);
                AppPreferences.QACheck11 = this.node.getBoolean("QACheck11", AppPreferences.QACheck11);
                AppPreferences.QACheck12 = this.node.getBoolean("QACheck12", AppPreferences.QACheck12);
                AppPreferences.QACheck13 = this.node.getBoolean("QACheck13", AppPreferences.QACheck13);
                AppPreferences.QACheck14 = this.node.getBoolean("QACheck14", AppPreferences.QACheck14);
                AppPreferences.QACheck15 = this.node.getBoolean("QACheck15", AppPreferences.QACheck15);
                AppPreferences.QACheck16 = this.node.getBoolean("QACheck16", AppPreferences.QACheck16);
                AppPreferences.QACheck17 = this.node.getBoolean("QACheck17", AppPreferences.QACheck17);
                AppPreferences.QACheck18 = this.node.getBoolean("QACheck18", AppPreferences.QACheck18);
                AppPreferences.QACheck19 = this.node.getBoolean("QACheck19", AppPreferences.QACheck19);
                AppPreferences.QACheck20 = this.node.getBoolean("QACheck20", AppPreferences.QACheck20);
                AppPreferences.QACheck21 = this.node.getBoolean("QACheck21", AppPreferences.QACheck21);
                AppPreferences.QACheck22 = this.node.getBoolean("QACheck22", AppPreferences.QACheck22);
                AppPreferences.QACheck23 = this.node.getBoolean("QACheck23", AppPreferences.QACheck23);
                AppPreferences.QACheck24 = this.node.getBoolean("QACheck24", AppPreferences.QACheck24);
                AppPreferences.glossaryPrefixMatch = this.node.getBoolean("glossaryPrefixMatch", AppPreferences.glossaryPrefixMatch);
                AppPreferences.memPrefixLength = this.node.getInt("memPrefixLength", AppPreferences.memPrefixLength);
                AppPreferences.skipTranslated = this.node.getBoolean("skiptranslated", AppPreferences.skipTranslated);
                AppPreferences.skipRepetions = this.node.getBoolean("skiprepetions", AppPreferences.skipRepetions);
                AppPreferences.skipNumbers = this.node.getBoolean("skipnumbers", AppPreferences.skipNumbers);
                AppPreferences.skipReviewed = this.node.getBoolean("skipreviewed", AppPreferences.skipReviewed);
                AppPreferences.skipPerfectMatches = this.node.getBoolean("skipperfect", AppPreferences.skipPerfectMatches);
                AppPreferences.skipNoLetters = this.node.getBoolean("skipnoletters", AppPreferences.skipNoLetters);
                success = true;
                return success;
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(ProjectView.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            return success;
        }
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public String getName() {
        String n = null;
        if (this.templateFile != null) {
            n = this.templateFile.getName();
        }
        return n;
    }

    public String getCurrentProject() {
        return this.currentProject;
    }

    public void removeTemplateNode() {
        try {
            if (this.node != null) {
                this.node.removeNode();
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(ProjectTemplate.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void clearTemplateMap() {
        try {
            this.templatesMap.clear();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(ProjectTemplate.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

