/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;
import translator.ui.GridPanel;

public class PropertyChooser
extends JDialog
implements ActionListener {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JComboBox typeComboBox = null;
    private JTextField jTextField2 = null;
    private String type;
    private String value;
    private MainView topui;

    public PropertyChooser(MainView topui, String title) {
        super(topui, title, true);
        this.topui = topui;
        JPanel jPanel0 = new JPanel();
        jPanel0.setLayout(new GridLayout(0, 3, 10, 0));
        jPanel0.setOpaque(false);
        jPanel0.setBorder(new EmptyBorder(new Insets(10, 0, 0, 0)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setOpaque(false);
        jPanel6.setLayout(new GridLayout(0, 1, 10, 3));
        JPanel jPanelProperty1 = new JPanel();
        jPanelProperty1.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROPERTY")));
        jPanelProperty1.setOpaque(false);
        jPanelProperty1.setLayout(new GridLayout(0, 2, 10, 3));
        this.typeComboBox = new JComboBox();
        this.typeComboBox.setEditable(true);
        this.jTextField2 = new JTextField();
        this.jTextField2.setMargin(new Insets(0, 2, 0, 0));
        this.jTextField2.setPreferredSize(new Dimension(200, 24));
        JLabel label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NAME") + ":");
        label.setHorizontalAlignment(4);
        jPanelProperty1.add(label);
        jPanelProperty1.add(this.typeComboBox);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VALUE") + ":");
        label.setHorizontalAlignment(4);
        jPanelProperty1.add(label);
        jPanelProperty1.add(this.jTextField2);
        jPanel6.add(jPanelProperty1);
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton2 = new JButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROPERTY NAMES"));
        this.jButton3.addActionListener(this);
        jPanel0.add(this.jButton1);
        jPanel0.add(this.jButton3);
        jPanel0.add(this.jButton2);
        GridPanel con = new GridPanel();
        this.setContentPane(con);
        EmptyBorder border = new EmptyBorder(10, 20, 10, 20);
        con.setBorder(border);
        con.setLayout(new BorderLayout());
        con.add((Component)jPanel6, "Center");
        con.add((Component)jPanel0, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyChooser.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyChooser.this.jButton2.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PropertyChooser.this.cancel();
            }
        });
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = topui.getSize();
        Point loc = topui.getLocation();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        this.setVisible(true);
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.closeDialog();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton3) {
            this.listPropertyNames();
        } else if (e.getSource() == this.jButton1) {
            this.type = (String)this.typeComboBox.getSelectedItem();
            this.value = this.jTextField2.getText();
            this.closeDialog();
        } else {
            this.cancel();
        }
    }

    public String getPropertyType() {
        return this.type;
    }

    public String getPropertyValue() {
        return this.value;
    }

    private void listPropertyNames() {
        TMX tmx;
        this.typeComboBox.removeAllItems();
        TreeSet<String> set = new TreeSet<String>();
        List mems = this.topui.getMemoryView().getLocalMemories();
        if (mems != null) {
            for (Memory m : mems) {
                TMX tmx2 = m.getTMX();
                if (tmx2 == null) continue;
                Collection col = tmx2.getTranslationUnits();
                for (Object o : col) {
                    if (o == null || !(o instanceof TMXUnit)) continue;
                    TMXUnit tu = (TMXUnit)o;
                    List list = tu.getChildren("prop");
                    for (Object object : list) {
                        DefaultXMLElement elem = (DefaultXMLElement)object;
                        String ptype = elem.getAttribute("type");
                        if (ptype == null) continue;
                        set.add(ptype);
                    }
                }
            }
        }
        if ((tmx = this.topui.getProjectView().getProject().getTMX()) != null) {
            Collection col = tmx.getTranslationUnits();
            for (Object o : col) {
                if (o == null || !(o instanceof TMXUnit)) continue;
                TMXUnit tu = (TMXUnit)o;
                List list = tu.getChildren("prop");
                for (Object object : list) {
                    DefaultXMLElement elem = (DefaultXMLElement)object;
                    String ptype = elem.getAttribute("type");
                    if (ptype == null) continue;
                    set.add(ptype);
                }
            }
        }
        if (!set.isEmpty()) {
            for (String string : set) {
                this.typeComboBox.addItem(string);
            }
        }
        this.typeComboBox.addItem("Creation ID");
        this.typeComboBox.addItem("Creation Date");
    }
}

