/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import translator.AppPreferences;

public class ResourceInfo {
    String infoPath;
    HashMap hm;

    public ResourceInfo(String infoPath) {
        this.infoPath = infoPath;
        this.hm = new HashMap();
        this.loadInfo();
    }

    public ResourceInfo(HashMap hm) {
        this.hm = hm;
    }

    public ResourceInfo() {
        this.hm = new HashMap();
    }

    public void setEntry(String key, String value) {
        this.hm.put(key, value);
    }

    private void loadInfo() {
        try {
            String line;
            File file = new File(this.infoPath);
            FileInputStream fis = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            while ((line = in.readLine()) != null) {
                int i;
                if (line.length() <= 0 || (i = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, i);
                String value = line.substring(i + 1);
                if (value == null || key == null) continue;
                this.hm.put(key, value);
            }
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveInfo() {
        if (this.infoPath != null && this.infoPath.length() > 0) {
            try {
                File file = new File(this.infoPath);
                FileOutputStream out = new FileOutputStream(file);
                BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                for (String key : this.hm.keySet()) {
                    String value = (String)this.hm.get(key);
                    awriter.write(key + "=" + value);
                    awriter.newLine();
                }
                awriter.close();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getInfoPath() {
        return this.infoPath;
    }

    public String getDriverFile() {
        String s = (String)this.hm.get("Driver file");
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.startsWith("resources") || s.startsWith("lib")) {
            s = AppPreferences.packagePath + s;
        }
        return s.trim();
    }

    public String getDriverClass() {
        String s = (String)this.hm.get("Driver class");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s.trim();
    }

    public String getUserName() {
        String s = (String)this.hm.get("User name");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s.trim();
    }

    public String getPassword() {
        String s = (String)this.hm.get("Password");
        if (s == null || s.length() == 0) {
            return "";
        }
        return s.trim();
    }

    public String getConnectionURL() {
        String s = (String)this.hm.get("Connection URL");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s.trim();
    }

    public String getClassPath() {
        String s = (String)this.hm.get("Class path");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s.trim();
    }

    public String getType() {
        String s = (String)this.hm.get("Type");
        if (s == null || s.length() == 0) {
            return "dictionary";
        }
        return s;
    }

    public String getResourcePath() {
        String s = (String)this.hm.get("Path");
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.startsWith("resources") || s.startsWith("lib")) {
            s = AppPreferences.packagePath + s;
        }
        return s.trim();
    }

    public String getResourceAddress() {
        String s = (String)this.hm.get("Internet address");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s.trim();
    }

    public String getName() {
        String s = (String)this.hm.get("Name");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public String getAuthor() {
        String s = (String)this.hm.get("Author");
        if (s == null || s.length() == 0) {
            return "Unknown";
        }
        return s;
    }

    public String getSource() {
        String s = (String)this.hm.get("Source language");
        if (s == null || s.length() == 0) {
            return "Source";
        }
        return s;
    }

    public String getTarget() {
        String s = (String)this.hm.get("Target language");
        if (s == null || s.length() == 0) {
            return "Target";
        }
        return s;
    }

    public String getDescription() {
        String s = (String)this.hm.get("Description");
        if (s != null) {
            return s;
        }
        return "";
    }

    public String getEntrySeparator() {
        String s = (String)this.hm.get("Entries separator");
        if (s == null || s.length() == 0) {
            return AppPreferences.ls;
        }
        return s;
    }

    public String getKeyEntrySeparator() {
        String s = (String)this.hm.get("Entry word separator");
        if (s == null || s.length() == 0) {
            return "";
        }
        return s;
    }

    public int getPriority() {
        String s = (String)this.hm.get("Priority");
        if (s == null || s.length() == 0) {
            return 1;
        }
        return Integer.parseInt(s);
    }

    public int getSearchColumn() {
        String s = (String)this.hm.get("Search column");
        if (s == null || s.length() == 0) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    public String getTextDelimiter() {
        String s = (String)this.hm.get("Text delimiter");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public String getEncoding() {
        String s = (String)this.hm.get("Encoding");
        if (s == null || s.length() == 0) {
            return System.getProperty("file.encoding");
        }
        return s;
    }

    public String getSecretKey() {
        String s = (String)this.hm.get("Secret key");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public String getPrefix() {
        String s = (String)this.hm.get("Address start");
        if (s == null || s.length() == 0) {
            return "";
        }
        return s;
    }

    public String getSuffix() {
        String s = (String)this.hm.get("Address end");
        if (s == null || s.length() == 0) {
            return "";
        }
        return s;
    }

    public String getService() {
        String s = (String)this.hm.get("Service");
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public String getStyleSheetPath() {
        String s = (String)this.hm.get("Style");
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.startsWith("styles")) {
            s = AppPreferences.packagePath + s;
        }
        return s;
    }

    public boolean getMethod() {
        String s = (String)this.hm.get("POST method");
        return s != null && s.equalsIgnoreCase("yes");
    }

    public boolean blockJavaScript() {
        String s = (String)this.hm.get("Block JavaScript");
        return s != null && s.equalsIgnoreCase("yes");
    }

    public int getZoom() {
        String s = (String)this.hm.get("Zoom");
        if (s == null || s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public boolean isNontranslatablesOnly() {
        String s = (String)this.hm.get("Non-translatable fragments only");
        return s != null && s.equalsIgnoreCase("yes");
    }

    public boolean isRegExOnly() {
        String s = (String)this.hm.get("Regular expressions only");
        return s != null && s.equalsIgnoreCase("yes");
    }

    public boolean isReadOnly() {
        String s = (String)this.hm.get("Read only");
        return s != null && s.equalsIgnoreCase("yes");
    }

    public boolean isMatchCase() {
        String s = (String)this.hm.get("Match case");
        if (s != null) {
            return s.equalsIgnoreCase("yes");
        }
        return AppPreferences.memCaseMatch;
    }

    public boolean isTermsCheck() {
        String s = (String)this.hm.get("Terms check");
        if (s != null) {
            return s.equalsIgnoreCase("yes");
        }
        return AppPreferences.consistencyCheckGlossary;
    }
}

