/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.Abbreviations;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.ClipboardHandler;
import translator.DictionaryResource;
import translator.DocumentChooser;
import translator.EnChooser;
import translator.GlossaryNewEntryEditor;
import translator.GlossaryResource;
import translator.GlossaryTip;
import translator.ImageResource;
import translator.KeyPreferences;
import translator.MT;
import translator.MainView;
import translator.NewResource;
import translator.Options;
import translator.Placeables;
import translator.Project;
import translator.ProjectView;
import translator.Resource;
import translator.ResourceInfo;
import translator.ResourceLoader;
import translator.SourceView;
import translator.Spellcheckable;
import translator.SynchronizedResource;
import translator.TabView;
import translator.TargetView;
import translator.Terminal;
import translator.TextResource;
import translator.TextShortcuts;
import translator.Translatable;
import translator.TranslateEvent;
import translator.WebResource;
import translator.Workflow;
import translator.XMLHelper;
import translator.ai.CTLinguist;
import translator.browser.Browser;
import translator.browser.WebResourceFX;
import translator.database.DatabaseView;
import translator.mt.AmazonTranslate;
import translator.mt.Bing;
import translator.mt.DeepL;
import translator.mt.Google;
import translator.mt.IBMWatson;
import translator.mt.MTRefinement;
import translator.mt.MyMemory;
import translator.mt.SlateDesktop;
import translator.mt.Yandex;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.translatables.TextDocument;
import translator.ui.Colors;
import translator.ui.GridPanel;
import translator.ui.GridPopupMenu;
import translator.ui.kodo.KodoButton;
import translator.ui.kodo.KodoComboBoxRenderer;
import translator.ui.kodo.KodoComboBoxUI;
import translator.ui.kodo.KodoGlowingBorder;
import translator.web.AmazonTTS;
import translator.web.Proz;
import translator.web.TMTown;
import translator.xliff.XLIFF;
import translator.xliff.XliffFile;

public class ResourceView {
    private MainView topui;
    private JToolBar searchBar;
    private JMenu libraryMenu;
    private JMenu glossaryMenu;
    private JMenu transMenu;
    private TabView tview;
    private Resource resource;
    private Resource ooResource;
    private GlossaryResource glossary;
    private List glossaries;
    private List webresources;
    private HashMap translatables;
    private Translatable translatable;
    private Spellcheckable spellcheckable;
    private ClipboardHandler clipboardHandler;
    private MT mt;
    private MT mt2;
    private MT mt3;
    private MT mt4;
    private MT mt5;
    private MT mt6;
    private MT mt7;
    private MT mt8;
    private TMTown tmTown;
    private Proz proz;
    private CTLinguist linguist;
    private AmazonTTS amazonTTS;
    private Terminal terminal;
    private JComboBox findCombo;
    private int findMode;
    private List clipboadList;
    private GridPopupMenu pop;
    private TextShortcuts shortcuts;
    KodoButton buttonTRSourceSearch;
    KodoButton buttonTRTargetSearch;
    KodoButton buttonGlossarySearch;
    JMenuItem reloadGloss;
    JCheckBoxMenuItem replaceCharsItem;
    JMenuItem transferPlaceablesItem;
    JMenuItem addPlaceableItem;
    JMenuItem textShortcutsItem;
    JMenuItem addAbbreviationItem;
    JMenuItem newDocumentItem;
    JMenuItem openDocumentItem;
    JMenuItem openImageDocumentItem;
    JMenuItem printItem;
    GlossaryNewEntryEditor glossaryNewEntryEditor;
    private boolean mergeGlossaries;
    private GlossaryTip glossaryTip;
    public static int uniqueResourceID;
    private int MTLimit;
    private int AutoClipboardLimit;
    int mtcount = 0;
    int webMTcount = 0;
    boolean mtTrialMessageShown = false;
    int clipboardCount = 0;
    boolean clipboardTrialMessageShown = false;
    int transferMTCount = 0;
    boolean transferMTTrialMessageShown = false;

    ResourceView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.searchBar = topui.getSearchBar();
        this.glossaryTip = new GlossaryTip();
        this.setEditButtons();
        this.setSearchBox();
        this.createResourcesMenu();
        this.createGossaryMenu();
        this.shortcuts = new TextShortcuts(topui);
        this.findMode = AppPreferences.findMode;
        this.MTLimit = 50;
        this.AutoClipboardLimit = 30;
        if (AppPreferences.launchNumber > 90) {
            this.MTLimit = 5;
            this.AutoClipboardLimit = 5;
        } else if (AppPreferences.launchNumber > 60) {
            this.MTLimit = 10;
            this.AutoClipboardLimit = 5;
        } else if (AppPreferences.launchNumber > 30) {
            this.MTLimit = 25;
            this.AutoClipboardLimit = 15;
        }
        this.glossaries = new ArrayList();
        AssembleParser.setGlossaries(this.glossaries);
    }

    public GlossaryTip getGlossaryTip() {
        return this.glossaryTip;
    }

    public JMenu getLibraryMenu() {
        return this.libraryMenu;
    }

    public JMenu getGlossaryMenu() {
        return this.glossaryMenu;
    }

    public TextShortcuts getTextShortcuts() {
        return this.shortcuts;
    }

    public JComboBox getLookUpBox() {
        return this.findCombo;
    }

    public String getLookUpText() {
        Object o = this.findCombo.getSelectedItem();
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public Resource getDefaultResource() {
        return this.resource;
    }

    public void setDefaultResource(Resource res) {
        this.resource = res;
    }

    private void setSearchBox() {
        String[] h = null;
        if (AppPreferences.searchHistory != null && AppPreferences.searchHistory.length() > 0) {
            h = AppPreferences.searchHistory.split(";;");
        }
        this.findCombo = h != null && h.length > 0 ? new JComboBox<String>(h) : new JComboBox();
        KodoComboBoxUI ui = null;
        if (AppPreferences.linuxGTK) {
            this.findCombo.setUI(new MetalComboBoxUI());
        } else {
            this.findCombo.setRenderer(new KodoComboBoxRenderer());
            ui = new KodoComboBoxUI();
            this.findCombo.setUI(ui);
            KodoGlowingBorder border = new KodoGlowingBorder();
            int t = 180;
            Color c = new Color(AppPreferences.iconsColor);
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), t);
            border.setColors(new Color(200, 200, 200, t), new Color(200, 200, 200, t), color);
            this.findCombo.setBorder(border);
        }
        this.findCombo.setEditable(true);
        int max = Toolkit.getDefaultToolkit().getScreenSize().width;
        int boxwidth = max / 2 - 50;
        JTextField lookUpTextField = (JTextField)this.findCombo.getEditor().getEditorComponent();
        lookUpTextField.putClientProperty("type", "searchfield");
        Graphics g = lookUpTextField.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        lookUpTextField.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        if (AppPreferences.tbackground != 0 && !AppPreferences.linuxGTK) {
            Color background = new Color(AppPreferences.tbackground);
            Color foreground = new Color(AppPreferences.tforeground);
            lookUpTextField.setBackground(background);
            lookUpTextField.setForeground(foreground);
            lookUpTextField.setCaretColor(foreground);
            this.findCombo.setBackground(background);
            if (ui != null) {
                ui.setButtonColors(foreground, background);
            }
        } else if (AppPreferences.theme.equals("System") && !AppPreferences.linuxGTK && ui != null) {
            ui.setButtonColors(lookUpTextField.getForeground(), lookUpTextField.getBackground());
        }
        lookUpTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Component comp = e.getComponent();
                if (comp instanceof JTextComponent) {
                    JTextComponent tcomp = (JTextComponent)comp;
                    tcomp.selectAll();
                    ResourceView.this.topui.setFocusedTextComponent(tcomp);
                }
            }
        });
        lookUpTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                int kc = ke.getKeyCode();
                if (kc == 10) {
                    ResourceView.this.searchDefaulScope();
                }
            }
        });
        JButton buttonPrevious = new JButton();
        buttonPrevious.setFont(buttonPrevious.getFont().deriveFont(1));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_LEFT, (int)(buttonPrevious.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonPrevious.setIcon((Icon)ficon);
        buttonPrevious.setOpaque(false);
        buttonPrevious.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonPrevious.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BACK"));
        buttonPrevious.setName("Back");
        buttonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Resource resource = ResourceView.this.tview.getCurrentResource();
                Memory tmx = ResourceView.this.tview.getCurrentMemory();
                if (resource != null) {
                    resource.previousResource();
                } else if (tmx != null) {
                    MemoryView trview = ResourceView.this.topui.getMemoryView();
                    trview.previous();
                } else {
                    ProjectView prview = ResourceView.this.topui.getProjectView();
                    prview.previous();
                }
            }
        });
        JButton buttonNextP = new JButton();
        buttonNextP.setOpaque(false);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT, (int)(buttonNextP.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonNextP.setIcon((Icon)ficon);
        buttonNextP.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonNextP.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FORWARD"));
        buttonNextP.setName("Forward");
        buttonNextP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Resource resource = ResourceView.this.tview.getCurrentResource();
                Memory tmx = ResourceView.this.tview.getCurrentMemory();
                if (resource != null) {
                    resource.nextResource();
                } else if (tmx != null) {
                    MemoryView trview = ResourceView.this.topui.getMemoryView();
                    trview.next();
                } else {
                    ProjectView prview = ResourceView.this.topui.getProjectView();
                    prview.next();
                }
            }
        });
        JButton buttonFind = new JButton();
        buttonFind.setOpaque(false);
        buttonFind.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE QUICK SEARCH BAR"));
        buttonFind.setName("MenuViewHideSearchButtons");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)(buttonFind.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonFind.setIcon((Icon)ficon);
        buttonFind.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.toggleQuickSearch();
            }
        });
        JToolBar searchBar2 = this.topui.getSearchBar2();
        searchBar2.add(buttonPrevious);
        searchBar2.add(buttonNextP);
        searchBar2.add(this.findCombo);
        searchBar2.add(buttonFind);
        KodoButton buttonResource = new KodoButton("Resources");
        buttonResource.setBackground(this.topui.getMainPanelBackgroundColor());
        buttonResource.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonResource.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESOURCE") + " (" + Options.getShortcutComboString("k72") + ")");
        buttonResource.setName("Resource");
        buttonResource.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize));
        buttonResource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getResourceView().search(0);
            }
        });
        this.searchBar.add(buttonResource);
        KodoButton buttonTM = null;
        if (AppPreferences.mt != -1) {
            buttonTM = new KodoButton("Machine Tr");
        } else if (AppPreferences.mt2 != -1) {
            buttonTM = new KodoButton("Machine Tr");
        } else if (AppPreferences.mt3 != -1) {
            buttonTM = new KodoButton("Machine Tr");
        } else if (AppPreferences.mt4 != -1) {
            buttonTM = new KodoButton("Machine Tr.");
        } else if (AppPreferences.mt5 != -1) {
            buttonTM = new KodoButton("Machine Tr");
        } else if (AppPreferences.mt6 != -1) {
            buttonTM = new KodoButton("Machine Tr");
        } else if (AppPreferences.mt7 != -1) {
            buttonTM = new KodoButton("Machine Tr");
        } else if (AppPreferences.mt8 != -1) {
            buttonTM = new KodoButton("Machine Tr");
        }
        if (buttonTM != null) {
            buttonTM.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MACHINE TRANSLATION") + " (" + Options.getShortcutComboString("k85") + ")");
            buttonTM.setName("MachineTranslation");
            buttonTM.setBackground(this.topui.getMainPanelBackgroundColor());
            buttonTM.setForeground(new Color(AppPreferences.toolBarsForeground));
            buttonTM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.topui.getResourceView().search(-3);
                }
            });
            this.searchBar.add(buttonTM);
        }
        KodoButton buttonSearch = new KodoButton("PR source");
        buttonSearch.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT SOURCE") + " (" + Options.getShortcutComboString("k73") + ")");
        buttonSearch.setName("ProjectSourceSegments");
        buttonSearch.setBackground(this.topui.getMainPanelBackgroundColor());
        buttonSearch.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getResourceView().search(4);
            }
        });
        this.searchBar.add(buttonSearch);
        buttonSearch = new KodoButton("PR target");
        buttonSearch.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT TARGET") + " (" + Options.getShortcutComboString("k74") + ")");
        buttonSearch.setName("ProjectTargetSegments");
        buttonSearch.setBackground(this.topui.getMainPanelBackgroundColor());
        buttonSearch.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getResourceView().search(5);
            }
        });
        this.searchBar.add(buttonSearch);
        buttonSearch = new KodoButton("TM source");
        buttonSearch.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY SOURCE") + " (" + Options.getShortcutComboString("k75") + ")");
        buttonSearch.setName("MemorySourceSegments");
        buttonSearch.setBackground(this.topui.getMainPanelBackgroundColor());
        buttonSearch.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getResourceView().search(2);
            }
        });
        this.searchBar.add(buttonSearch);
        buttonSearch = new KodoButton("TM target");
        buttonSearch.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY TARGET") + " (" + Options.getShortcutComboString("k76") + ")");
        buttonSearch.setName("MemoryTargetSegments");
        buttonSearch.setBackground(this.topui.getMainPanelBackgroundColor());
        buttonSearch.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getResourceView().search(3);
            }
        });
        this.searchBar.add(buttonSearch);
        this.buttonGlossarySearch = new KodoButton("Glossaries");
        this.buttonGlossarySearch.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES") + " (" + Options.getShortcutComboString("k94") + ")");
        this.buttonGlossarySearch.setName("Glossaries");
        this.buttonGlossarySearch.setBackground(this.topui.getMainPanelBackgroundColor());
        this.buttonGlossarySearch.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.buttonGlossarySearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getResourceView().search(-4);
            }
        });
        this.buttonTRSourceSearch = new KodoButton("TR source");
        this.buttonTRSourceSearch.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TOTAL RECALL SOURCE") + " (" + Options.getShortcutComboString("k77") + ")");
        this.buttonTRSourceSearch.setName("TRSourceSegments");
        this.buttonTRSourceSearch.setBackground(this.topui.getMainPanelBackgroundColor());
        this.buttonTRSourceSearch.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.buttonTRSourceSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getResourceView().search(6);
            }
        });
        this.buttonTRTargetSearch = new KodoButton("TR target");
        this.buttonTRTargetSearch.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TOTAL RECALL TARGET") + " (" + Options.getShortcutComboString("k78") + ")");
        this.buttonTRTargetSearch.setName("TRTargetSegments");
        this.buttonTRTargetSearch.setBackground(this.topui.getMainPanelBackgroundColor());
        this.buttonTRTargetSearch.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.buttonTRTargetSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getResourceView().search(7);
            }
        });
        if (AppPreferences.desktopSearchTool.trim().length() > 0) {
            buttonSearch = new KodoButton("Desktop");
            buttonSearch.setBackground(this.topui.getMainPanelBackgroundColor());
            buttonSearch.setForeground(new Color(AppPreferences.toolBarsForeground));
            buttonSearch.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AT CURSOR") + " > " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DESKTOP SEARCH TOOL"));
            buttonSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.topui.getResourceView().search(-2);
                }
            });
            this.searchBar.add(buttonSearch);
        }
    }

    public void showTotalRecallSearchButtons() {
        if (this.searchBar.getComponentIndex(this.buttonTRSourceSearch) == -1) {
            this.searchBar.add(this.buttonTRSourceSearch);
            this.searchBar.add(this.buttonTRTargetSearch);
            this.searchBar.revalidate();
            this.searchBar.repaint();
        }
    }

    public void showGlossarySearchButton() {
        if (this.searchBar.getComponentIndex(this.buttonGlossarySearch) == -1) {
            this.searchBar.add(this.buttonGlossarySearch);
            this.searchBar.revalidate();
            this.searchBar.repaint();
        }
    }

    private void setEditButtons() {
        JButton buttonBold = new JButton();
        buttonBold.setOpaque(false);
        buttonBold.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_BOLD, (int)(buttonBold.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonBold.setIcon((Icon)ficon);
        buttonBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().formatSelectedText('b');
            }
        });
        JButton buttonItalics = new JButton();
        buttonItalics.setOpaque(false);
        buttonItalics.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_ITALIC, (int)(buttonItalics.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonItalics.setIcon((Icon)ficon);
        buttonItalics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().formatSelectedText('i');
            }
        });
        JButton buttonUndeline = new JButton();
        buttonUndeline.setOpaque(false);
        buttonUndeline.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_UNDERLINE, (int)(buttonUndeline.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonUndeline.setIcon((Icon)ficon);
        buttonUndeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().formatSelectedText('u');
            }
        });
        JButton buttonSubscript = new JButton();
        buttonSubscript.setOpaque(false);
        buttonSubscript.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_SUBSCRIPT, (int)(buttonSubscript.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonSubscript.setIcon((Icon)ficon);
        buttonSubscript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().formatSelectedText('s');
            }
        });
        JButton buttonSuperscript = new JButton();
        buttonSuperscript.setOpaque(false);
        buttonSuperscript.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_SUPERSCRIPT, (int)(buttonSuperscript.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonSuperscript.setIcon((Icon)ficon);
        buttonSuperscript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().formatSelectedText('r');
            }
        });
        JButton buttonHighlight = new JButton();
        buttonHighlight.setOpaque(false);
        buttonHighlight.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_COLOR_FILL, (int)(buttonHighlight.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonHighlight.setIcon((Icon)ficon);
        buttonHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().formatSelectedText('m');
            }
        });
        JButton buttonSurround = new JButton();
        buttonSurround.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        Font f = buttonSurround.getFont().deriveFont(1);
        buttonSurround.setFont(f);
        buttonSurround.setForeground(Colors.getIconsColor());
        buttonSurround.setText("S1");
        buttonSurround.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().surroundWithCharacters(AppPreferences.surroundChars);
            }
        });
        buttonSurround.setOpaque(false);
        buttonSurround.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SURROUND WITH CHARACTERS") + " " + AppPreferences.surroundChars);
        JButton buttonSurround2 = new JButton();
        buttonSurround2.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonSurround2.setForeground(Colors.getIconsColor());
        buttonSurround2.setFont(f);
        buttonSurround2.setText("S2");
        buttonSurround2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().surroundWithCharacters(AppPreferences.surroundChars2);
            }
        });
        buttonSurround2.setOpaque(false);
        buttonSurround2.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SURROUND WITH CHARACTERS") + " " + AppPreferences.surroundChars2);
        JButton buttonSurround3 = new JButton();
        buttonSurround3.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonSurround3.setForeground(Colors.getIconsColor());
        buttonSurround3.setFont(f);
        buttonSurround3.setText("S3");
        buttonSurround3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                ResourceView.this.topui.getTargetView().surroundWithCharacters(AppPreferences.surroundChars3);
            }
        });
        buttonSurround3.setOpaque(false);
        buttonSurround3.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SURROUND WITH CHARACTERS") + " " + AppPreferences.surroundChars3);
        JButton buttonLower = new JButton();
        buttonLower.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonLower.setOpaque(false);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_SIZE, (int)(buttonLower.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonLower.setIcon((Icon)ficon);
        buttonLower.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHANGE CASE"));
        buttonLower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPane tc = ResourceView.this.topui.getTargetView().getTargetPane();
                ResourceView.this.cycleCase(tc, 1);
            }
        });
        JButton buttonCut = new JButton();
        buttonCut.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonCut.setOpaque(false);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CONTENT_CUT, (int)(buttonCut.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonCut.setIcon((Icon)ficon);
        buttonCut.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CUT"));
        buttonCut.setName("Cut");
        buttonCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                JTextComponent tc = ResourceView.this.topui.getFocusedTextComponent();
                tc.cut();
            }
        });
        JButton buttonCopy = new JButton();
        buttonCopy.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonCopy.setOpaque(false);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CONTENT_COPY, (int)(buttonCopy.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonCopy.setIcon((Icon)ficon);
        buttonCopy.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("COPY"));
        buttonCopy.setName("Copy");
        buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                JTextComponent tc = ResourceView.this.topui.getFocusedTextComponent();
                tc.copy();
            }
        });
        JButton buttonPaste = new JButton();
        buttonPaste.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonPaste.setOpaque(false);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CONTENT_PASTE, (int)(buttonPaste.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        buttonPaste.setIcon((Icon)ficon);
        buttonPaste.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PASTE"));
        buttonPaste.setName("Paste");
        buttonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView.this.topui.getTargetView().getToolPopup().setVisible(false);
                JTextComponent tc = ResourceView.this.topui.getFocusedTextComponent();
                tc.paste();
            }
        });
        JToggleButton AIButton = new JToggleButton();
        AIButton.setSelected(AppPreferences.chatGPTTargetEditorChatMode);
        AIButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AI CHAT MODE"));
        AIButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JToggleButton button = (JToggleButton)e.getSource();
                AppPreferences.chatGPTTargetEditorChatMode = button.isSelected();
            }
        });
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SIGMA, (int)(buttonPaste.getFont().getSize() + 2), (Color)Colors.getIconsColor());
        AIButton.setIcon((Icon)ficon);
        JToolBar contextToolbar = this.topui.getContextToolBar();
        contextToolbar.add(buttonLower);
        contextToolbar.add(buttonCut);
        contextToolbar.add(buttonCopy);
        contextToolbar.add(buttonPaste);
        contextToolbar.addSeparator();
        contextToolbar.add(buttonSurround);
        contextToolbar.add(buttonSurround2);
        contextToolbar.add(buttonSurround3);
        contextToolbar.addSeparator();
        contextToolbar.add(buttonBold);
        contextToolbar.add(buttonItalics);
        contextToolbar.add(buttonUndeline);
        contextToolbar.add(buttonSubscript);
        contextToolbar.add(buttonSuperscript);
        contextToolbar.add(buttonHighlight);
        contextToolbar.addSeparator();
        contextToolbar.add(AIButton);
    }

    private void setMemories(File file, JMenu jMenu, int j) {
        Object[] files = ((File)file).listFiles();
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            String fileName = ((File)file).getName();
            if (((File)file).isDirectory()) {
                JMenu jm = new JMenu(" " + fileName);
                jMenu.insert(jm, 0);
                this.setMemories((File)file, jm, i + 1);
                continue;
            }
            if (!fileName.endsWith(".res")) continue;
            final String fname = fileName.substring(0, fileName.lastIndexOf("."));
            final String dictionaryPath = ((File)file).getPath();
            JMenuItem jch = new JMenuItem(new AbstractAction(this, " " + fname){
                String name;
                String path;
                final /* synthetic */ ResourceView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.name = fname;
                    this.path = dictionaryPath;
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    this.this$0.topui.getResourceLoader().prepareResources(this.path);
                }
            });
            jMenu.add(jch);
        }
    }

    private void createGossaryMenu() {
        this.glossaryMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY"));
        this.setGlossaries(new File(AppPreferences.packagePath + "infos/resources"), this.glossaryMenu, 0);
    }

    private void createResourcesMenu() {
        this.libraryMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESOURCES"));
        File mf = new File(AppPreferences.packagePath + "infos/memories");
        if (mf.exists()) {
            this.transMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION MEMORIES"));
            this.setMemories(mf, this.transMenu, 0);
            this.libraryMenu.add(this.transMenu);
        }
        this.libraryMenu.addSeparator();
        this.setResources(new File(AppPreferences.packagePath + "infos/resources"), this.libraryMenu, 0);
    }

    private void setResources(File file, JMenu jMenu, int j) {
        Object[] files = ((File)file).listFiles();
        Arrays.sort(files);
        int level = j;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            String fileName = ((File)file).getName();
            if (((File)file).isDirectory()) {
                String name;
                String menuName = "";
                if (fileName.equals("Glossaries") && level == 0) continue;
                if (fileName.equals("Dictionaries")) {
                    name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DICTIONARIES");
                } else if (fileName.equals("Internet")) {
                    name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WEB");
                    menuName = "MenuToolsWeb";
                } else if (fileName.equals("Images")) {
                    name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMAGES");
                    menuName = "MenuToolsImages";
                } else {
                    name = fileName.equals("Examples") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXAMPLES") : fileName;
                }
                JMenu jm = new JMenu(name);
                if (!menuName.isEmpty()) {
                    jm.setName(menuName);
                }
                if (level > 0) {
                    FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FOLDER, (int)jm.getFont().getSize(), (Color)jm.getForeground());
                    jm.setIcon((Icon)ficon);
                }
                jMenu.insert(jm, 0);
                this.setResources((File)file, jm, i + 1);
                continue;
            }
            if (!fileName.endsWith(".res")) continue;
            final String fname = fileName.substring(0, fileName.lastIndexOf("."));
            final String dictionaryPath = ((File)file).getPath();
            JMenuItem jch = new JMenuItem(new AbstractAction(this, fname){
                String name;
                String path;
                final /* synthetic */ ResourceView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.name = fname;
                    this.path = dictionaryPath;
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    this.this$0.topui.getResourceLoader().prepareResources(this.path);
                }
            });
            if (i > 0 && i % 6 == 0) {
                jMenu.addSeparator();
            }
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_WEB, (int)jch.getFont().getSize(), (Color)jch.getForeground());
            jch.setIcon((Icon)ficon);
            jMenu.add(jch);
        }
        if (level == 0) {
            JCheckBoxMenuItem swsMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SWS"));
            swsMenu.setName("MenuToolsSimultaneousWebSearch");
            swsMenu.setSelected(AppPreferences.sws);
            swsMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                    AppPreferences.sws = item.isSelected();
                }
            });
            jMenu.insert(swsMenu, 0);
            jMenu.insertSeparator(1);
            JMenuItem jmi = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD WEB RESOURCE") + "..."){

                @Override
                public void actionPerformed(ActionEvent a) {
                    ResourceView.this.addOnlineResource();
                }
            });
            jmi.setName("MenuToolsAddResource");
            JMenuItem jmi2 = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD IMAGE") + "..."){

                @Override
                public void actionPerformed(ActionEvent a) {
                    ResourceView.this.addImageResource();
                }
            });
            jmi2.setName("MenuToolsAddResource");
            JMenuItem jmwebimport = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT WEB RESOURCE INFO") + "..."){

                @Override
                public void actionPerformed(ActionEvent a) {
                    if (AppPreferences.isJavaFXReady()) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FileChooser fileChooser = new FileChooser();
                                    fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                                    final File file = fileChooser.showOpenDialog(null);
                                    if (file != null) {
                                        SwingUtilities.invokeLater(new Runnable(){
                                            final /* synthetic */ 1 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            @Override
                                            public void run() {
                                                if (file.exists()) {
                                                    String ipath = file.getPath();
                                                    NewResource dlg = new NewResource(this.this$2.ResourceView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESOURCE INFORMATION"), ipath, 10);
                                                    Dimension dlgSize = dlg.getPreferredSize();
                                                    Dimension frmSize = this.this$2.ResourceView.this.topui.getSize();
                                                    Point loc = this.this$2.ResourceView.this.topui.getLocationOnScreen();
                                                    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                                                    dlg.setVisible(true);
                                                    if (dlg.approve) {
                                                        this.this$2.ResourceView.this.refreshResourceMenu();
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                                catch (Exception ex) {
                                    final String s = ex.getMessage();
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(this.this$2.ResourceView.this.topui, s);
                                        }
                                    });
                                }
                            }
                        });
                    } else {
                        File file;
                        JFileChooser jch = new JFileChooser();
                        jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                        jch.setFileSelectionMode(0);
                        if (0 == jch.showOpenDialog(ResourceView.this.topui) && (file = jch.getSelectedFile()) != null && file.exists()) {
                            String ipath = file.getPath();
                            NewResource dlg = new NewResource(ResourceView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESOURCE INFORMATION"), ipath, 10);
                            Dimension dlgSize = dlg.getPreferredSize();
                            Dimension frmSize = ResourceView.this.topui.getSize();
                            Point loc = ResourceView.this.topui.getLocationOnScreen();
                            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                            dlg.setVisible(true);
                            if (dlg.approve) {
                                ResourceView.this.refreshResourceMenu();
                            }
                        }
                    }
                }
            });
            jmwebimport.setName("MenuToolsImportWebResourceInfo");
            JMenuItem jminfo = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT RESOURCE INFO")){

                @Override
                public void actionPerformed(ActionEvent a) {
                    Resource res = ResourceView.this.tview.getCurrentResource();
                    if (res == null) {
                        return;
                    }
                    String ipath = res.getInfoPath();
                    if (ipath == null) {
                        return;
                    }
                    ResourceView.this.editResourceInfo(ipath);
                }
            });
            jminfo.setName("MenuToolsEditResourceInfo");
            JMenuItem jmsave = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE RESOURCE")){

                @Override
                public void actionPerformed(ActionEvent a) {
                    Resource resource = ResourceView.this.tview.getCurrentResource();
                    if (resource != null) {
                        resource.saveResource();
                    }
                }
            });
            jmsave.setName("MenuToolsSaveResource");
            if (AppPreferences.isJavaFXReady()) {
                JMenuItem realTimeLocalPreviewMenuItem = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN HTML PAGE FOR PREVIEW...")){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A SOURCE DOCUMENT"));
                                File f = new File(AppPreferences.sourcePreviewDirectory);
                                if (f.isDirectory() && f.canRead()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    AppPreferences.sourcePreviewDirectory = file.getParent();
                                    try {
                                        ResourceView.this.topui.getResourceLoader().prepareWebResource(file.toURI().toURL().toExternalForm(), "Source Preview", false, false, 0);
                                    }
                                    catch (MalformedURLException ex) {
                                        JOptionPane.showMessageDialog(ResourceView.this.topui, ex.getMessage());
                                        Logger.getLogger(ProjectView.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }
                        });
                    }
                });
                realTimeLocalPreviewMenuItem.setName("MenuToolsOpenHTMLPageForSrcPreview");
                JMenuItem realTimeLibreOfficePreviewMenuItem = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN LIBREOFFICE FOR PREVIEW...")){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        if (!ResourceView.this.isLibreOfficeAvailable()) {
                            JOptionPane.showMessageDialog(ResourceView.this.topui, "Install and choose LibreOffice in Preferences > Application connection.");
                            return;
                        }
                        Project project = ResourceView.this.topui.getProjectView().getProject();
                        if (project != null && project.getLibreOfficeMode() == 1) {
                            JOptionPane.showMessageDialog(ResourceView.this.topui, "LibreOffice document set in real-time preview.");
                            return;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN LIBREOFFICE DOCUMENT"));
                                File f = new File(AppPreferences.sourcePreviewDirectory);
                                if (f.isDirectory() && f.canRead()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    AppPreferences.sourcePreviewDirectory = file.getParent();
                                    ResourceView.this.openOOForPreview(file.getPath());
                                }
                            }
                        });
                    }
                });
                realTimeLibreOfficePreviewMenuItem.setName("MenuToolsLibreOfficeForSrcPreview");
                JMenuItem videoResourceMenuItem = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MOVIE") + "..."){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MOVIE"));
                                File f = new File(AppPreferences.sourcePreviewDirectory);
                                if (f.isDirectory() && f.canRead()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    AppPreferences.sourcePreviewDirectory = file.getParent();
                                    ResourceView.this.topui.getResourceLoader().prepareVideoResource(file);
                                }
                            }
                        });
                    }
                });
                JCheckBoxMenuItem reviewTargetSegments = new JCheckBoxMenuItem();
                reviewTargetSegments.setSelected(AppPreferences.reviewTargetSegments);
                reviewTargetSegments.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIGHLIGHT TARGET SEGMENTS"));
                reviewTargetSegments.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        AppPreferences.reviewTargetSegments = e.getStateChange() == 1;
                    }
                });
                jMenu.add(reviewTargetSegments);
                jMenu.add(realTimeLibreOfficePreviewMenuItem);
                jMenu.add(realTimeLocalPreviewMenuItem);
                jMenu.add(videoResourceMenuItem);
                jMenu.addSeparator();
            }
            JMenu notepadMenu = new JMenu("Notepad");
            notepadMenu.setName("MenuToolsNotepad");
            jMenu.add(notepadMenu);
            jMenu.addSeparator();
            JMenuItem documentNoteItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT NOTE"));
            documentNoteItem.setName("MenuToolsNotepadDocumentNote");
            documentNoteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT NOTE");
                    if (!ResourceView.this.topui.getTabView().selectTab(s)) {
                        ResourceView.this.openDocumentNote(true);
                    }
                }
            });
            notepadMenu.add(documentNoteItem);
            notepadMenu.addSeparator();
            this.newDocumentItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW DOCUMENT..."));
            this.newDocumentItem.setName("MenuToolsNotepadNewDocument");
            KeyStroke ks = KeyPreferences.getKeyStroke("k53");
            if (ks != null) {
                this.newDocumentItem.setAccelerator(ks);
            }
            this.newDocumentItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView rview = ResourceView.this.topui.getResourceView();
                    rview.newTextDocument(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW"));
                }
            });
            notepadMenu.add(this.newDocumentItem);
            JMenuItem newClipDoc = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW DOCUMENT FROM CLIPBOARD"));
            newClipDoc.setName("MenuToolsNotepadNewDocumentFromClipboard");
            newClipDoc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView rview = ResourceView.this.topui.getResourceView();
                    rview.importClipboardText();
                }
            });
            notepadMenu.add(newClipDoc);
            this.openDocumentItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN DOCUMENT..."));
            this.openDocumentItem.setName("MenuToolsNotepadOpenDocument");
            this.openDocumentItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DocumentChooser ch = new DocumentChooser(ResourceView.this.topui);
                    ch.fileOpen();
                }
            });
            notepadMenu.add(this.openDocumentItem);
            this.openImageDocumentItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN IMAGE DOCUMENT..."));
            this.openImageDocumentItem.setName("MenuToolsNotepadOpenImageDocument");
            ks = KeyPreferences.getKeyStroke("k55");
            if (ks != null) {
                this.openImageDocumentItem.setAccelerator(ks);
            }
            this.openImageDocumentItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView rview = ResourceView.this.topui.getResourceView();
                    rview.openImageResource();
                }
            });
            notepadMenu.add(this.openImageDocumentItem);
            JMenuItem view = new JMenuItem();
            view.setName("MenuToolsNotepadViewDocument");
            view.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VIEW DOCUMENT"));
            view.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.topui.getResourceView().viewDocument();
                }
            });
            notepadMenu.add(view);
            this.printItem = new JMenuItem();
            this.printItem.setName("MenuToolsNotepadPrint");
            ks = KeyPreferences.getKeyStroke("k56");
            if (ks != null) {
                this.printItem.setAccelerator(ks);
            }
            this.printItem.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRINT"));
            this.printItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Resource resource = ResourceView.this.topui.getTabView().getCurrentResource();
                    if (resource != null) {
                        resource.printResource();
                    } else {
                        ResourceView.this.topui.printTextComponent();
                    }
                }
            });
            notepadMenu.add(this.printItem);
            JMenuItem saveAsDoc = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE DOCUMENT AS..."));
            saveAsDoc.setName("MenuToolsNotepadSaveDocumentAs");
            saveAsDoc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView rview = ResourceView.this.topui.getResourceView();
                    rview.saveAsTextResource();
                }
            });
            JMenuItem menuItemEncoding = new JMenuItem();
            menuItemEncoding.setName("MenuToolsNotepadCharacterEncoding");
            menuItemEncoding.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHARACTER ENCODING"));
            menuItemEncoding.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnChooser dlg = new EnChooser(ResourceView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHARACTER ENCODING"), true);
                    Dimension dlgSize = dlg.getPreferredSize();
                    Dimension frmSize = ResourceView.this.topui.getSize();
                    Point loc = ResourceView.this.topui.getLocationOnScreen();
                    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                    dlg.setVisible(true);
                }
            });
            notepadMenu.add(saveAsDoc);
            notepadMenu.addSeparator();
            notepadMenu.add(menuItemEncoding);
            JMenu menuPlaceable = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NON-TRANSLATABLE FRAGMENTS"));
            menuPlaceable.setName("MenuToolsNonTransFrags");
            this.replaceCharsItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE CHARS AT SOURCE TRANSFER"));
            this.replaceCharsItem.setName("MenuToolsNonTransFragsReplaceCharsAtSrcTransfer");
            ks = KeyPreferences.getKeyStroke("k19");
            if (ks != null) {
                this.replaceCharsItem.setAccelerator(ks);
            }
            this.replaceCharsItem.setSelected(AppPreferences.replaceAtTransfer);
            this.replaceCharsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                    AppPreferences.replaceAtTransfer = item.isSelected();
                }
            });
            menuPlaceable.add(this.replaceCharsItem);
            menuPlaceable.addSeparator();
            this.transferPlaceablesItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LIST NON-TRANSLATABLE FRAGMENTS"));
            this.transferPlaceablesItem.setName("MenuToolsNonTransFragsList");
            ks = KeyPreferences.getKeyStroke("k20");
            if (ks != null) {
                this.transferPlaceablesItem.setAccelerator(ks);
            }
            this.transferPlaceablesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Dimension frmSize = ResourceView.this.topui.getSize();
                    Point loc = ResourceView.this.topui.getLocation();
                    int w = frmSize.width / 2;
                    int x = w - w / 2 + loc.x;
                    int y = frmSize.height / 2 + loc.y;
                    ResourceView.this.topui.getTargetView().showPlaceablesPopUp(ResourceView.this.topui, x, y);
                }
            });
            menuPlaceable.add(this.transferPlaceablesItem);
            this.addPlaceableItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SELECTION TO NON-TRANSLATABLE FRAGMENTS"));
            this.addPlaceableItem.setName("MenuToolsNonTransFragsAddSelection");
            ks = KeyPreferences.getKeyStroke("k21");
            if (ks != null) {
                this.addPlaceableItem.setAccelerator(ks);
            }
            this.addPlaceableItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.topui.getWorkflowView().addToPlaceables();
                }
            });
            menuPlaceable.add(this.addPlaceableItem);
            menuPlaceable.addSeparator();
            JCheckBoxMenuItem showHiddenPlaceablesItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW HIDDEN NON-TRANSLATABLE FRAGMENTS"));
            showHiddenPlaceablesItem.setSelected(AppPreferences.showHiddenPlaceables);
            showHiddenPlaceablesItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    XLIFF xliff;
                    int i = e.getStateChange();
                    AppPreferences.showHiddenPlaceables = i == 1;
                    Project project = ResourceView.this.topui.getProjectView().getProject();
                    if (project != null && (xliff = project.getXLIFF()) != null) {
                        int current = xliff.getView().getCurrentTUIndex();
                        if (current >= 0) {
                            xliff.getWorkflow().setCheckStart(current);
                        }
                        xliff.getWorkflow().checkNextTU();
                    }
                }
            });
            menuPlaceable.add(showHiddenPlaceablesItem);
            JCheckBoxMenuItem matchHiddenPlaceablesItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MATCH HIDDEN NON-TRANSLATABLE FRAGMENTS"));
            matchHiddenPlaceablesItem.setSelected(AppPreferences.matchHiddenPlaceables);
            matchHiddenPlaceablesItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i = e.getStateChange();
                    AppPreferences.matchHiddenPlaceables = i == 1;
                }
            });
            menuPlaceable.add(matchHiddenPlaceablesItem);
            JMenuItem editPlaceablesItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT NON-TRANSLATABLE FRAGMENTS"));
            editPlaceablesItem.setName("MenuToolsNonTransFragsEdit");
            editPlaceablesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.topui.getResourceView().editPlaceables();
                }
            });
            menuPlaceable.addSeparator();
            menuPlaceable.add(editPlaceablesItem);
            JMenuItem reloadPlaceablesItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RELOAD NON-TRANSLATABLE FRAGMENTS"));
            reloadPlaceablesItem.setName("MenuToolsNonTransFragsReload");
            reloadPlaceablesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Placeables.loadPlaceables();
                }
            });
            menuPlaceable.add(reloadPlaceablesItem);
            jMenu.add(menuPlaceable);
            JMenu menuTextShortCuts = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TEXT SHORTCUTS"));
            menuTextShortCuts.setName("MenuToolsTextShorcuts");
            this.textShortcutsItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SELECTION TO TEXT SHORTCUTS"));
            this.textShortcutsItem.setName("MenuToolsTextShorcutsAddSelection");
            ks = KeyPreferences.getKeyStroke("k36");
            if (ks != null) {
                this.textShortcutsItem.setAccelerator(ks);
            }
            this.textShortcutsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextPane pane = ResourceView.this.topui.getTargetPane();
                    String word = pane.getSelectedText();
                    if (word == null) {
                        TextShortcuts ts = ResourceView.this.getTextShortcuts();
                        ts.showShortcuts();
                    } else {
                        TextShortcuts ts = ResourceView.this.getTextShortcuts();
                        ts.addShortcut(word);
                        pane.setCaretPosition(pane.getSelectionEnd());
                    }
                }
            });
            JMenuItem listTextShortcutsItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LIST TEXT SHORTCUTS"));
            listTextShortcutsItem.setName("MenuToolsTextShorcutsList");
            listTextShortcutsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextShortcuts ts = ResourceView.this.getTextShortcuts();
                    ts.showShortcuts();
                }
            });
            JCheckBoxMenuItem changeStraightQuotesToGuillemetsFrench = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHANGE DOUBLE STRAIGHT QUOTES TO GUILLEMETS IN FRENCH"));
            changeStraightQuotesToGuillemetsFrench.setSelected(AppPreferences.changeQuotesToGuillemetsFrench);
            changeStraightQuotesToGuillemetsFrench.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i = e.getStateChange();
                    AppPreferences.changeQuotesToGuillemetsFrench = i == 1;
                }
            });
            JCheckBoxMenuItem addNonBreakingSpaceFrench = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD NON-BREAKING SPACE BEFORE FRENCH PUNCTUATION CHARACTERS"));
            addNonBreakingSpaceFrench.setSelected(AppPreferences.addNonBreakingSpaceFrench);
            addNonBreakingSpaceFrench.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i = e.getStateChange();
                    AppPreferences.addNonBreakingSpaceFrench = i == 1;
                }
            });
            menuTextShortCuts.add(this.textShortcutsItem);
            menuTextShortCuts.add(listTextShortcutsItem);
            menuTextShortCuts.addSeparator();
            menuTextShortCuts.add(changeStraightQuotesToGuillemetsFrench);
            menuTextShortCuts.add(addNonBreakingSpaceFrench);
            jMenu.add(menuTextShortCuts);
            JMenu menuAbbreviations = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ABBREVIATIONS"));
            menuAbbreviations.setName("MenuToolsAbbrevs");
            this.addAbbreviationItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SELECTION TO ABBREVIATIONS"));
            this.addAbbreviationItem.setName("MenuToolsAbbrevsAddSelection");
            ks = KeyPreferences.getKeyStroke("k91");
            if (ks != null) {
                this.addAbbreviationItem.setAccelerator(ks);
            }
            this.addAbbreviationItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.topui.getWorkflowView().addAbbreviation();
                }
            });
            JMenuItem editAbbreviationsItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT ABBREVIATIONS"));
            editAbbreviationsItem.setName("MenuToolsAbbrevsEdit");
            editAbbreviationsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.topui.getResourceView().editAbbrevaitions();
                }
            });
            JMenuItem scanAbbreviationsItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SCAN PROJECT FOR ABBREVIATIONS"));
            scanAbbreviationsItem.setName("MenuToolsAbbrevsScanProject");
            scanAbbreviationsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Abbreviations abb = new Abbreviations(ResourceView.this.topui);
                    abb.findProjectAbbreviations();
                }
            });
            menuAbbreviations.add(this.addAbbreviationItem);
            menuAbbreviations.add(editAbbreviationsItem);
            menuAbbreviations.add(scanAbbreviationsItem);
            jMenu.add(menuAbbreviations);
            jMenu.addSeparator();
            jMenu.add(jmi2);
            jMenu.add(jmi);
            jMenu.add(jmwebimport);
            jMenu.add(jminfo);
            jMenu.addSeparator();
            jMenu.add(jmsave);
        }
    }

    private void setGlossaries(File file, JMenu jMenu, int j) {
        Object[] files = ((File)file).listFiles();
        Arrays.sort(files);
        int level = j;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            String fileName = ((File)file).getName();
            if (((File)file).isDirectory()) {
                String name;
                String menuName = "";
                if (level == 0) {
                    if (!fileName.equals("Glossaries")) continue;
                    name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES");
                    menuName = "MenuGlossaryGlossaries";
                } else {
                    name = fileName.equals("Examples") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXAMPLES") : fileName;
                }
                JMenu jm = new JMenu(name);
                if (!menuName.isEmpty()) {
                    jm.setName(menuName);
                }
                if (level > 0) {
                    FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FOLDER, (int)jm.getFont().getSize(), (Color)jm.getForeground());
                    jm.setIcon((Icon)ficon);
                }
                jMenu.insert(jm, 0);
                this.setGlossaries((File)file, jm, i + 1);
                continue;
            }
            if (!fileName.endsWith(".res")) continue;
            final String fname = fileName.substring(0, fileName.lastIndexOf("."));
            final String dictionaryPath = ((File)file).getPath();
            JMenuItem jch = new JMenuItem(new AbstractAction(this, fname){
                String name;
                String path;
                final /* synthetic */ ResourceView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.name = fname;
                    this.path = dictionaryPath;
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    this.this$0.topui.getResourceLoader().prepareResources(this.path);
                }
            });
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PENCIL, (int)jch.getFont().getSize(), (Color)jch.getForeground());
            jch.setIcon((Icon)ficon);
            if (i > 0 && i % 6 == 0) {
                jMenu.addSeparator();
            }
            jMenu.add(jch);
        }
        if (level == 0) {
            JMenuItem jminfo = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT GLOSSARY INFO")){

                @Override
                public void actionPerformed(ActionEvent a) {
                    Resource r = ResourceView.this.topui.getTabView().getCurrentResource();
                    if (r != null && r instanceof GlossaryResource) {
                        ResourceView.this.glossary = (GlossaryResource)r;
                    } else {
                        ResourceView.this.chooseGlossary();
                    }
                    if (ResourceView.this.glossary != null) {
                        String ipath = null;
                        ipath = ResourceView.this.glossary.getInfoPath();
                        if (ipath != null) {
                            ResourceView.this.editGlossaryInfo(ipath);
                        }
                        ResourceView.this.glossary = null;
                    }
                }
            });
            jminfo.setName("MenuGlossaryEditGlossaryInfo");
            JMenuItem jmsave = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE GLOSSARY")){

                @Override
                public void actionPerformed(ActionEvent a) {
                    ResourceView.this.saveGlossaries();
                }
            });
            jmsave.setName("MenuGlossarySaveGlossary");
            JMenuItem jmsaveas = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE GLOSSARY AS") + "..."){

                @Override
                public void actionPerformed(ActionEvent a) {
                    TabView tv = ResourceView.this.topui.getTabView();
                    Resource r = tv.getCurrentResource();
                    if (r != null && r instanceof DictionaryResource) {
                        DictionaryResource d = (DictionaryResource)r;
                        d.saveAsResource();
                    } else {
                        ResourceView.this.chooseGlossary();
                        if (ResourceView.this.glossary != null) {
                            ResourceView.this.glossary.saveAsResource();
                        }
                        ResourceView.this.glossary = null;
                    }
                }
            });
            jmsaveas.setName("MenuGlossarySaveGlossaryAs");
            JMenuItem newGloss = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW GLOSSARY") + "...");
            newGloss.setName("MenuGlossaryNewGlossary");
            newGloss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.newGlossary(true);
                }
            });
            JMenuItem addGloss = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD GLOSSARY") + "...");
            addGloss.setName("MenuGlossaryAddGlossary");
            addGloss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.newGlossary(false);
                }
            });
            JCheckBoxMenuItem mergeGlossariesCheckBox = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES FOLDER"));
            mergeGlossariesCheckBox.setName("MenuGlossaryMergeGlossaries");
            mergeGlossariesCheckBox.setSelected(this.mergeGlossaries);
            mergeGlossariesCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i = e.getStateChange();
                    if (i == 1) {
                        ResourceView.this.mergeGlossaries = true;
                    } else {
                        ResourceView.this.mergeGlossaries = false;
                    }
                }
            });
            JMenuItem joinGloss = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN GLOSSARY") + "...");
            joinGloss.setName("MenuGlossaryJoinGlossary");
            joinGloss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceView.this.joinGlossary();
                        }
                    });
                }
            });
            JMenuItem importExcelGlossary = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT MS EXCEL GLOSSARY..."));
            importExcelGlossary.setName("MenuGlossaryImportMSExcelGlossary");
            importExcelGlossary.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceView.this.importExcelGlossary();
                        }
                    });
                }
            });
            JMenuItem mergeGlossTargets = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MERGE GLOSSARY TARGETS"));
            mergeGlossTargets.setName("MenuGlossaryMergeAlternativeTranslations");
            mergeGlossTargets.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceView.this.mergeGlossaryTargets();
                        }
                    });
                }
            });
            JMenuItem sortGloss = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SORT GLOSSARY"));
            sortGloss.setName("MenuGlossarySortGlossEntriesAlphabetically");
            sortGloss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceView.this.sortGlossary(0);
                        }
                    });
                }
            });
            JMenuItem sortGlossLength = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SORT GLOSSARY BY LENGTH"));
            sortGlossLength.setName("MenuGlossarySortGlossEntriesByLengthAlphabetically");
            sortGlossLength.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceView.this.sortGlossary(1);
                        }
                    });
                }
            });
            JMenuItem removeDuplicateEntries = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE DUPLICATE ENTRIES"));
            removeDuplicateEntries.setName("MenuGlossaryRemoveDuplicateEntries");
            removeDuplicateEntries.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceView.this.removeDuplicateEntries();
                        }
                    });
                }
            });
            JMenuItem removeSourceEqualsTargetEntries = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE SOURCE=TARGET"));
            removeSourceEqualsTargetEntries.setName("MenuGlossaryRemoveSrcEqualsTrg");
            removeSourceEqualsTargetEntries.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceView.this.removeSourceEqualsTargetEntries();
                        }
                    });
                }
            });
            this.reloadGloss = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RELOAD GLOSSARY"));
            this.reloadGloss.setName("MenuGlossaryReloadGlossary");
            KeyStroke ks = KeyPreferences.getKeyStroke("k90");
            if (ks != null) {
                this.reloadGloss.setAccelerator(ks);
            }
            this.reloadGloss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int i;
                            ResourceView.this.reloadGlossary();
                            Project p = ResourceView.this.topui.getProjectView().getProject();
                            if (p != null && (i = p.getCurrenTUIndex()) != -1) {
                                p.edit("#" + Integer.toString(i));
                            }
                        }
                    });
                }
            });
            JMenuItem editGloss = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT GLOSSARY"));
            editGloss.setName("MenuGlossaryEditGlossary");
            editGloss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceView.this.viewGlossary();
                }
            });
            jMenu.addSeparator();
            jMenu.add(newGloss);
            jMenu.addSeparator();
            jMenu.add(addGloss);
            jMenu.add(mergeGlossariesCheckBox);
            jMenu.add(joinGloss);
            jMenu.add(importExcelGlossary);
            jMenu.addSeparator();
            jMenu.add(mergeGlossTargets);
            jMenu.add(sortGloss);
            jMenu.add(sortGlossLength);
            jMenu.addSeparator();
            jMenu.add(removeDuplicateEntries);
            jMenu.add(removeSourceEqualsTargetEntries);
            jMenu.addSeparator();
            jMenu.add(this.reloadGloss);
            jMenu.add(editGloss);
            jMenu.add(jminfo);
            jMenu.addSeparator();
            jMenu.add(jmsave);
            jMenu.add(jmsaveas);
        }
    }

    public void setTMTownService(String id) {
        if (id != null && id.length() > 0) {
            TMTown t = new TMTown();
            t.setMainView(this.topui);
            t.connectToService();
            this.tmTown = t;
            this.resource = t;
        } else {
            this.tmTown = null;
        }
    }

    public TMTown getTMTownService() {
        return this.tmTown;
    }

    public void setProzService(String id) {
        if (id != null && id.length() > 0) {
            Proz p = new Proz();
            p.setMainView(this.topui);
            p.connectToService();
            this.proz = p;
            this.resource = p;
        } else {
            this.proz = null;
        }
    }

    public Proz getProzService() {
        return this.proz;
    }

    public void setCTLinguist(int cpt) {
        if (cpt != -1) {
            CTLinguist chat = new CTLinguist();
            chat.setMainView(this.topui);
            this.linguist = chat;
            this.resource = chat;
            this.topui.getSourceView().addSpeakButton();
        } else {
            this.linguist = null;
        }
    }

    public CTLinguist getCTLinguist() {
        return this.linguist;
    }

    public void setAmazonTTSService(int tts) {
        if (tts != -1) {
            AmazonTTS atts = new AmazonTTS();
            atts.setMainView(this.topui);
            atts.connectToService();
            this.amazonTTS = atts;
            this.resource = atts;
        } else {
            this.amazonTTS = null;
        }
    }

    public AmazonTTS getAmazonTTSService() {
        return this.amazonTTS;
    }

    public void setMT(String mtr) {
        if (mtr != null && mtr.length() > 0) {
            Google g = new Google();
            g.setMainView(this.topui);
            this.mt = g;
            this.resource = g;
            if (AppPreferences.googleAPIKey.length() > 0) {
                this.mt.setAPIKey(AppPreferences.googleAPIKey);
            }
        } else {
            this.mt = null;
        }
    }

    public void setMT2(String mtr) {
        if (mtr != null && mtr.length() > 0) {
            Bing g = new Bing();
            g.setMainView(this.topui);
            this.mt2 = g;
            this.resource = g;
            if (AppPreferences.bingAPIKey.length() > 0) {
                this.mt2.setAPIKey(AppPreferences.bingAPIKey);
            }
        } else {
            this.mt2 = null;
        }
    }

    public void setMT3(String mtr) {
        if (mtr != null && mtr.length() > 0) {
            MyMemory g = new MyMemory();
            g.setMainView(this.topui);
            this.mt3 = g;
            this.resource = g;
        } else {
            this.mt3 = null;
        }
    }

    public void setMT4(String mtr) {
        if (mtr != null && mtr.length() > 0) {
            SlateDesktop g = new SlateDesktop();
            g.setMainView(this.topui);
            this.mt4 = g;
            this.resource = g;
        } else {
            this.mt4 = null;
        }
    }

    public void setMT5(String mtr) {
        if (mtr != null && mtr.length() > 0) {
            Yandex y = new Yandex();
            y.setMainView(this.topui);
            this.mt5 = y;
            this.resource = y;
            if (AppPreferences.yandexAPIKey.length() > 0) {
                this.mt5.setAPIKey(AppPreferences.yandexAPIKey);
            }
        } else {
            this.mt5 = null;
        }
    }

    public void setMT6(String mtr) {
        if (mtr != null && mtr.length() > 0) {
            DeepL d = new DeepL();
            d.setMainView(this.topui);
            this.mt6 = d;
            this.resource = d;
            if (AppPreferences.deeplAPIKey.length() > 0) {
                this.mt6.setAPIKey(AppPreferences.deeplAPIKey);
            }
        } else {
            this.mt6 = null;
        }
    }

    public void setMT7(String mtr) {
        if (mtr != null && mtr.length() > 0) {
            IBMWatson d = new IBMWatson();
            d.setMainView(this.topui);
            this.mt7 = d;
            this.resource = d;
            if (AppPreferences.watsonAPIKey.length() > 0) {
                this.mt7.setAPIKey(AppPreferences.watsonAPIKey);
            }
        } else {
            this.mt7 = null;
        }
    }

    public void setMT8(String mtr) {
        if (mtr != null && mtr.length() > 0) {
            AmazonTranslate d = new AmazonTranslate();
            d.setMainView(this.topui);
            this.mt8 = d;
            this.resource = d;
            if (AppPreferences.amazonAPIAccessKey.length() > 0) {
                this.mt8.setAPIKey(AppPreferences.amazonAPIAccessKey);
            }
        } else {
            this.mt8 = null;
        }
    }

    public MT getMT() {
        return this.mt;
    }

    public MT getMT2() {
        return this.mt2;
    }

    public MT getMT3() {
        return this.mt3;
    }

    public MT getMT4() {
        return this.mt4;
    }

    public MT getMT5() {
        return this.mt5;
    }

    public MT getMT6() {
        return this.mt6;
    }

    public MT getMT7() {
        return this.mt7;
    }

    public MT getMT8() {
        return this.mt8;
    }

    public WebResourceFX getMTWebResource(String address) {
        if (this.webresources != null) {
            for (Object next : this.webresources) {
                String addr;
                WebResourceFX wr;
                if (!(next instanceof WebResourceFX) || !(wr = (WebResourceFX)next).isMTWebResurces() || (addr = wr.getResourceAddress()) == null || addr.indexOf(address) == -1) continue;
                return wr;
            }
        }
        return null;
    }

    public void openTerminal() {
        this.terminal = new Terminal(this.topui);
    }

    public void closeTerminal() {
        this.terminal = null;
    }

    public void setDatabase(String base) {
        String ipath = AppPreferences.packagePath + "infos/databases/" + base + ".res";
        ResourceInfo ri = new ResourceInfo(ipath);
        DatabaseView dview = this.topui.getDatabaseView();
        dview.prepareDatabase(ri);
    }

    public HashMap getTranslatables() {
        return this.translatables;
    }

    public void addTranslatable(Translatable t) {
        String loc;
        if (this.translatables == null) {
            this.translatables = new HashMap();
        }
        if ((loc = t.getLocation()) != null) {
            this.translatables.put(loc, t);
        }
    }

    public Translatable getTranslatable(String path) {
        if (this.translatables != null) {
            Set set = this.translatables.keySet();
            for (Object object : set) {
                Translatable tr;
                String loc = object.toString();
                if (!path.equals(loc) || (tr = (Translatable)this.translatables.get(loc)) == null) continue;
                return tr;
            }
        }
        return null;
    }

    public void removeTranslatable(Translatable t) {
        String loc;
        if (this.translatables != null && (loc = t.getLocation()) != null) {
            this.translatables.remove(loc);
        }
    }

    public void setTranslatable(int editor) {
        if (editor == 1) {
            String ipath = AppPreferences.packagePath + "infos/editors/OpenOffice.res";
            this.topui.getResourceLoader().prepareResources(ipath);
        } else {
            AppPreferences.editorAPI = 0;
            this.translatable = null;
        }
    }

    public Translatable[] getTranslatable() {
        Object o2;
        Object o1;
        SynchronizedResource jr;
        Translatable[] tr = new Translatable[2];
        Resource resource = this.topui.getTabView().getCurrentResource();
        if (resource != null) {
            if (resource instanceof Translatable) {
                tr[0] = (Translatable)((Object)resource);
                return tr;
            }
            if (resource instanceof SynchronizedResource) {
                jr = (SynchronizedResource)resource;
                o1 = jr.getLeftResource();
                o2 = jr.getRightResource();
                if (o1 instanceof Translatable) {
                    tr[0] = (Translatable)o1;
                }
                if (o2 instanceof Translatable) {
                    if (tr[0] == null) {
                        tr[0] = (Translatable)o2;
                    } else {
                        tr[1] = (Translatable)o2;
                    }
                }
            }
        }
        if (tr[0] == null && tr[1] == null && (resource = this.topui.getActiveResource()) != null) {
            if (resource instanceof Translatable) {
                tr[0] = (Translatable)((Object)resource);
                return tr;
            }
            if (resource instanceof SynchronizedResource) {
                jr = (SynchronizedResource)resource;
                o1 = jr.getLeftResource();
                o2 = jr.getRightResource();
                if (o1 instanceof Translatable) {
                    tr[0] = (Translatable)o1;
                }
                if (o2 instanceof Translatable) {
                    if (tr[0] == null) {
                        tr[0] = (Translatable)o2;
                    } else {
                        tr[1] = (Translatable)o2;
                    }
                }
            }
        }
        if (tr[0] == null && tr[1] == null) {
            tr[0] = this.translatable;
        }
        return tr;
    }

    public Spellcheckable getSpellcheckable() {
        return this.spellcheckable;
    }

    public void setSpellcheckable(Spellcheckable sp) {
        this.spellcheckable = sp;
    }

    private MT prepareMTResource(ResourceInfo ri) {
        MT mt = null;
        Object object = null;
        try {
            File file;
            String jclassPath = ri.getClassPath();
            URL[] urls = null;
            if (jclassPath != null) {
                File file2;
                int i;
                File dir = new File(jclassPath);
                if (dir.isDirectory()) {
                    File[] files = dir.listFiles();
                    urls = new URL[files.length + 1];
                    for (i = 0; i < files.length; ++i) {
                        file2 = files[i];
                        urls[i] = file2.toURI().toURL();
                    }
                } else {
                    String[] cp = jclassPath.split(System.getProperty("path.separator"));
                    if (cp != null) {
                        urls = new URL[cp.length + 1];
                        for (i = 0; i < cp.length; ++i) {
                            file2 = new File(cp[i]);
                            urls[i] = file2.toURI().toURL();
                        }
                    }
                }
            }
            String classPath = ri.getResourcePath();
            if (urls == null) {
                urls = new URL[1];
            }
            urls[urls.length - 1] = (file = new File(classPath)).exists() ? file.toURI().toURL() : new URL(classPath);
            URLClassLoader loader = new URLClassLoader(urls);
            String className = ri.getName();
            Class<?> clas = loader.loadClass(className);
            object = clas.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.toString());
        }
        if (object != null && object instanceof MT) {
            Resource res;
            mt = object;
            this.resource = res = (Resource)object;
            res.setMainView(this.topui);
        }
        return mt;
    }

    public void searchManualGlossaries(String query, String replace) {
        for (Object object : this.glossaries) {
            GlossaryResource gr = (GlossaryResource)object;
            boolean ro = gr.isReadOnly();
            if (ro && replace != null) continue;
            gr.search(query, replace);
        }
    }

    public void realTimeHTMLSourcePreview(String segment, boolean back) {
        if (this.webresources != null) {
            for (Object object : this.webresources) {
                WebResourceFX wr;
                if (!(object instanceof WebResourceFX) || (wr = (WebResourceFX)object).getRealTimePreview() != 0) continue;
                wr.findAndFrame(segment, back);
            }
        }
    }

    public void speakToAI() {
        CTLinguist ai = this.getCTLinguist();
        if (ai != null) {
            ai.voicePrompt();
        }
    }

    public void translateWebService(String content) {
        TMTown tmTown = this.getTMTownService();
        if (tmTown != null && AppPreferences.tmTownAutoSearch) {
            tmTown.translate(content);
        }
    }

    public void translateAIService(String content) {
        CTLinguist ai = this.getCTLinguist();
        if (ai != null) {
            ai.message(content, false);
        }
    }

    public void clearAISelection() {
        CTLinguist ai = this.getCTLinguist();
        if (ai != null) {
            ai.clearSelection();
        }
    }

    public void translateMT(String content) {
        MT mt4;
        MT mt8;
        MT mt7;
        MT mt5;
        MT mt3;
        MT mt2;
        MT mt;
        if (AppPreferences.isTrialVersion && this.mtcount >= this.MTLimit) {
            if (!this.mtTrialMessageShown) {
                String message = "The free version of CafeTran Espresso lets you connect to the supported Machine Translation services\na limited number of times in one session. You have reached this limit.\nTo unlock the program for use without the limit, it is necessary to purchase a license file from the CafeTran.com website.";
                this.showTrialVersionLimitMessage(message);
                this.mtTrialMessageShown = true;
            }
            return;
        }
        content = MTRefinement.maskSource(content);
        content = Placeables.maskSource(content);
        MT mt6 = this.getMT6();
        if (mt6 != null && AppPreferences.autoMT6) {
            mt6.translate(content);
            ++this.mtcount;
        }
        if ((mt = this.getMT()) != null && AppPreferences.autoMT) {
            mt.translate(content);
            ++this.mtcount;
        }
        if ((mt2 = this.getMT2()) != null && AppPreferences.autoMT2) {
            mt2.translate(content);
            ++this.mtcount;
        }
        if ((mt3 = this.getMT3()) != null && AppPreferences.autoMT3) {
            mt3.translate(content);
            ++this.mtcount;
        }
        if ((mt5 = this.getMT5()) != null && AppPreferences.autoMT5) {
            mt5.translate(content);
            ++this.mtcount;
        }
        if ((mt7 = this.getMT7()) != null && AppPreferences.autoMT7) {
            mt7.translate(content);
            ++this.mtcount;
        }
        if ((mt8 = this.getMT8()) != null && AppPreferences.autoMT8) {
            mt8.translate(content);
            ++this.mtcount;
        }
        if ((mt4 = this.getMT4()) != null) {
            mt4.translate(content);
            ++this.mtcount;
        }
    }

    public void translateMTSelection(String content) {
        MT mt8;
        MT mt7;
        MT mt5;
        MT mt3;
        MT mt2;
        MT mt;
        if (AppPreferences.isTrialVersion && this.mtcount >= this.MTLimit) {
            if (!this.mtTrialMessageShown) {
                String message = "The free version of CafeTran Espresso lets you connect to the supported Machine Translation services\na limited number of times in one session.You have reached this limit.\nTo unlock the program for use without the limit, it is necessary to purchase a license file from the CafeTran.com website.";
                this.showTrialVersionLimitMessage(message);
                this.mtTrialMessageShown = true;
            }
            return;
        }
        MT mt6 = this.getMT6();
        if (mt6 != null) {
            Resource r = (Resource)((Object)mt6);
            r.search(content, null);
            ++this.mtcount;
        }
        if ((mt = this.getMT()) != null) {
            Resource r = (Resource)((Object)mt);
            r.search(content, null);
            ++this.mtcount;
        }
        if ((mt2 = this.getMT2()) != null) {
            Resource r = (Resource)((Object)mt2);
            r.search(content, null);
            ++this.mtcount;
        }
        if ((mt3 = this.getMT3()) != null) {
            Resource r = (Resource)((Object)mt3);
            r.search(content, null);
            ++this.mtcount;
        }
        if ((mt5 = this.getMT5()) != null) {
            Resource r = (Resource)((Object)mt5);
            r.search(content, null);
            ++this.mtcount;
        }
        if ((mt7 = this.getMT7()) != null) {
            Resource r = (Resource)((Object)mt7);
            r.search(content, null);
            ++this.mtcount;
        }
        if ((mt8 = this.getMT8()) != null) {
            Resource r = (Resource)((Object)mt8);
            r.search(content, null);
            ++this.mtcount;
        }
    }

    public void transferMTFormWebPage() {
        List webresources;
        ++this.transferMTCount;
        if (AppPreferences.isTrialVersion && this.transferMTCount >= this.AutoClipboardLimit) {
            if (!this.transferMTTrialMessageShown) {
                String message = "The free version of CafeTran Espresso enables the transfer of translation to the segment editor\na limited number of times in one session. You have reached this limit.\nTo unlock the program for use without the limit, it is necessary to purchase a license file from the CafeTran.com website.";
                this.showTrialVersionLimitMessage(message);
                this.transferMTTrialMessageShown = true;
            }
            return;
        }
        boolean transferred = false;
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof WebResourceFX) {
            WebResourceFX wr = (WebResourceFX)r;
            if (wr.isMTWebResurces() || wr.isQAWebResurces()) {
                wr.transferToTargetSegment();
                transferred = true;
            }
        } else if (r != null && r instanceof MT) {
            MT mt = (MT)((Object)r);
            mt.apply(false);
            transferred = true;
        } else if (r instanceof CTLinguist) {
            CTLinguist gpt = (CTLinguist)r;
            gpt.apply(false);
            transferred = true;
        }
        if (!transferred && (webresources = this.getWebResources()) != null) {
            for (Object next : webresources) {
                WebResourceFX fx;
                if (!(next instanceof WebResourceFX) || !(fx = (WebResourceFX)next).isMTWebResurces() && !fx.isQAWebResurces()) continue;
                fx.transferToTargetSegment();
                break;
            }
        }
    }

    public void clearMTCache() {
        CTLinguist gpt;
        MT mt8;
        MT mt7;
        MT mt5;
        MT mt4;
        MT mt3;
        MT mt2;
        MT mt;
        MT mt6 = this.getMT6();
        if (mt6 != null) {
            mt6.clearCache();
        }
        if ((mt = this.getMT()) != null) {
            mt.clearCache();
        }
        if ((mt2 = this.getMT2()) != null) {
            mt2.clearCache();
        }
        if ((mt3 = this.getMT3()) != null) {
            mt3.clearCache();
        }
        if ((mt4 = this.getMT4()) != null) {
            mt4.clearCache();
        }
        if ((mt5 = this.getMT5()) != null) {
            mt5.clearCache();
        }
        if ((mt7 = this.getMT7()) != null) {
            mt7.clearCache();
        }
        if ((mt8 = this.getMT8()) != null) {
            mt8.clearCache();
        }
        if ((gpt = this.getCTLinguist()) != null) {
            gpt.close();
        }
    }

    public void saveGlossaries() {
        List list = this.getGlossaries();
        if (list != null) {
            for (GlossaryResource g : list) {
                if (g.isReadOnly()) continue;
                g.saveResource();
            }
        }
    }

    public GlossaryResource getGlossary(String name) {
        GlossaryResource gloss = null;
        for (int i = 0; i < this.glossaries.size(); ++i) {
            GlossaryResource g;
            Object object = this.glossaries.get(i);
            if (!(object instanceof GlossaryResource) || !name.equals((g = (GlossaryResource)object).getName())) continue;
            gloss = g;
            break;
        }
        return gloss;
    }

    public List getGlossaries() {
        return this.glossaries;
    }

    public void addGlossary(GlossaryResource g) {
        this.glossaries.add(g);
        this.topui.getResourceView().showGlossarySearchButton();
    }

    public void removeGlossary(GlossaryResource g) {
        this.glossaries.remove(g);
    }

    public boolean hasGlossaries4Terms() {
        List glist = this.getGlossaries();
        for (Object object : glist) {
            String name;
            boolean ro;
            GlossaryResource g = (GlossaryResource)object;
            if (g == null || (ro = g.isReadOnly()) || (name = g.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public void addTermToGlossaries(String key, String entry) {
        Dimension dlgSize;
        if (!this.hasGlossaries4Terms()) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY IS NOT OPEN."));
            return;
        }
        if (this.glossaryNewEntryEditor != null && this.glossaryNewEntryEditor.isVisible()) {
            if (key != null) {
                this.glossaryNewEntryEditor.setKey(key);
            }
            if (entry != null) {
                this.glossaryNewEntryEditor.setEntry(entry);
            }
            return;
        }
        this.glossaryNewEntryEditor = new GlossaryNewEntryEditor(this.topui);
        if (key != null) {
            this.glossaryNewEntryEditor.setKey(key);
        }
        if (entry != null) {
            this.glossaryNewEntryEditor.setEntry(entry);
        }
        if (AppPreferences.newEntryDialogWidth > 50 && AppPreferences.newEntryDialogHeight > 50) {
            dlgSize = new Dimension(AppPreferences.newEntryDialogWidth, AppPreferences.newEntryDialogHeight);
            this.glossaryNewEntryEditor.setSize(dlgSize);
        } else {
            dlgSize = this.glossaryNewEntryEditor.getPreferredSize();
        }
        if (AppPreferences.newEntryDialogPosX > -1 && AppPreferences.newEntryDialogPosY > -1) {
            this.glossaryNewEntryEditor.setLocation(AppPreferences.newEntryDialogPosX, AppPreferences.newEntryDialogPosY);
        } else {
            Dimension frmSize = this.topui.getSize();
            Point loc = this.topui.getLocationOnScreen();
            this.glossaryNewEntryEditor.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.glossaryNewEntryEditor.setVisible(true);
    }

    public void addTermToGlossaries() {
        Dimension dlgSize;
        if (!this.hasGlossaries4Terms()) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY IS NOT OPEN."));
            return;
        }
        TargetView pview = this.topui.getTargetView();
        JTextPane jps = this.topui.getSourcePane();
        String key = jps.getSelectedText();
        if (key == null) {
            key = "";
        } else {
            jps.setCaretPosition(jps.getSelectionEnd());
        }
        JTextPane jpt = pview.getTargetPane();
        String entry = jpt.getSelectedText();
        if (entry == null) {
            entry = "";
        } else {
            jpt.setCaretPosition(jpt.getSelectionEnd());
        }
        if (this.glossaryNewEntryEditor != null && this.glossaryNewEntryEditor.isVisible()) {
            this.glossaryNewEntryEditor.setKey(key);
            this.glossaryNewEntryEditor.setEntry(entry);
            return;
        }
        this.glossaryNewEntryEditor = new GlossaryNewEntryEditor(this.topui);
        this.glossaryNewEntryEditor.setKey(key);
        this.glossaryNewEntryEditor.setEntry(entry);
        if (AppPreferences.newEntryDialogWidth > 50 && AppPreferences.newEntryDialogHeight > 50) {
            dlgSize = new Dimension(AppPreferences.newEntryDialogWidth, AppPreferences.newEntryDialogHeight);
            this.glossaryNewEntryEditor.setSize(dlgSize);
        } else {
            dlgSize = this.glossaryNewEntryEditor.getPreferredSize();
        }
        if (AppPreferences.newEntryDialogPosX > -1 && AppPreferences.newEntryDialogPosY > -1) {
            this.glossaryNewEntryEditor.setLocation(AppPreferences.newEntryDialogPosX, AppPreferences.newEntryDialogPosY);
        } else {
            Dimension frmSize = this.topui.getSize();
            Point loc = this.topui.getLocationOnScreen();
            this.glossaryNewEntryEditor.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.glossaryNewEntryEditor.setVisible(true);
    }

    public void addTermToGlossariesDirect() {
        JTextPane sp = this.topui.getSourcePane();
        JTextPane tp = this.topui.getTargetPane();
        String key = sp.getSelectedText();
        String entry = tp.getSelectedText();
        if (key == null) {
            key = sp.getText();
        }
        if (entry == null) {
            entry = tp.getText();
        }
        for (Object object : this.glossaries) {
            GlossaryResource dic = (GlossaryResource)object;
            if (dic.isReadOnly() || dic.isBlocked()) continue;
            dic.addDirectEntry(key, entry);
        }
        int cp = sp.getSelectionEnd();
        if (cp != -1) {
            sp.setCaretPosition(cp);
        }
        if ((cp = tp.getSelectionEnd()) != -1) {
            tp.setCaretPosition(cp);
        }
    }

    public void addTermToGlossariesDirect(GlossaryResource dic) {
        JTextPane sp = this.topui.getSourcePane();
        JTextPane tp = this.topui.getTargetPane();
        String key = sp.getSelectedText();
        String entry = tp.getSelectedText();
        if (key == null || entry == null) {
            key = sp.getText();
            entry = tp.getText();
        }
        if (key != null && entry != null) {
            dic.addDirectEntry(key, entry);
            int cp = sp.getSelectionEnd();
            if (cp != -1) {
                sp.setCaretPosition(cp);
            }
            if ((cp = tp.getSelectionEnd()) != -1) {
                tp.setCaretPosition(cp);
            }
        }
    }

    public void addTermToGlossaries(String source, String target, Map map) {
        for (Object object : this.glossaries) {
            GlossaryResource dic = (GlossaryResource)object;
            if (dic.isReadOnly() || dic.isBlocked()) continue;
            dic.updateDictionary(source, target, map);
            dic.addToSourceMap();
            TranslateEvent event = this.topui.getMemoryView().getTranslateEvent();
            if (event != null) {
                dic.findGlossaryMatches(event);
            }
            if (dic.newEntryIndex < AppPreferences.gautosave) continue;
            dic.saveResource();
        }
    }

    public GlossaryNewEntryEditor getGlossaryNewEntryEditor() {
        return this.glossaryNewEntryEditor;
    }

    public List getWebResources() {
        return this.webresources;
    }

    public void addWebResource(Resource wr) {
        if (this.webresources == null) {
            this.webresources = new ArrayList();
        }
        this.webresources.add(wr);
    }

    public void removeWebResource(Resource wr) {
        if (this.webresources != null) {
            this.webresources.remove(wr);
        }
    }

    boolean openOOResource() {
        if (this.ooResource != null) {
            this.ooResource.openResource();
            return true;
        }
        return false;
    }

    public boolean openOOForPreview(String path) {
        if (this.ooResource != null) {
            Project pro = this.topui.getProjectView().getProject();
            pro.setPreviewReference(path, "LibreOffice");
            this.ooResource.openResource();
            return true;
        }
        return false;
    }

    void closeOOResource() {
        if (this.ooResource != null) {
            this.ooResource.closeResource();
        }
    }

    public void editPlaceables() {
        File file;
        String s = Placeables.getPlaceablesPath();
        if (s != null && (file = new File(s)).exists()) {
            TextResource tresource = new TextResource();
            tresource.editNonTranslatables();
            tresource.setParagraphView(false);
            tresource.setMainView(this.topui);
            tresource.openFile(file, "UTF-8");
        }
    }

    public void editAbbrevaitions() {
        File file;
        String s = Abbreviations.getAbbreviationsPath();
        if (s != null && (file = new File(s)).exists()) {
            TextResource tresource = new TextResource();
            tresource.editNonTranslatables();
            tresource.setParagraphView(false);
            tresource.setMainView(this.topui);
            tresource.openFile(file, "UTF-8");
        }
    }

    public void openDocumentNote(boolean createNew) {
        XliffFile xliffFile;
        XLIFF xliff;
        Project p = this.topui.getProjectView().getProject();
        if (p != null && (xliff = p.getXLIFF()) != null && xliff.isCafeTranXLIFF && (xliffFile = xliff.getFile(0)) != null) {
            String note = xliffFile.getHeaderNote();
            if (createNew) {
                ResourceView rview = this.topui.getResourceView();
                rview.editDocumentNote(note);
            } else if (note != null && note.length() > 0) {
                ResourceView rview = this.topui.getResourceView();
                rview.editDocumentNote(note);
            }
        }
    }

    private void editDocumentNote(String note) {
        TextResource tresource = new TextResource();
        tresource.setMainView(this.topui);
        tresource.editDocumentNote(note);
    }

    public TextResource newTextResource(String name) {
        TextResource tresource = new TextResource();
        tresource.setMainView(this.topui);
        tresource.newDocument(name);
        return tresource;
    }

    public TextDocument newTextDocument(String name) {
        TextDocument tresource = new TextDocument();
        tresource.setParagraphView(false);
        tresource.setMainView(this.topui);
        tresource.newDocument(name);
        return tresource;
    }

    void openDocument(File f, boolean editor, Map filters) {
        DocumentChooser ch = new DocumentChooser(this.topui);
        Resource r = editor ? ch.fileOpen(f, AppPreferences.format, AppPreferences.en, null, filters) : ch.fileLoad(f, AppPreferences.format, AppPreferences.en, null, filters);
        if (r instanceof Translatable) {
            this.translatable = (Translatable)((Object)r);
            this.addTranslatable(this.translatable);
        }
    }

    public void openDocument(File f, String format, String encoding, String zName) {
        DocumentChooser ch = new DocumentChooser(this.topui);
        Resource r = ch.fileOpen(f, format, encoding, zName, null);
        if (r instanceof Translatable) {
            this.translatable = (Translatable)((Object)r);
            this.addTranslatable(this.translatable);
        }
    }

    void save() {
        Resource res = this.tview.getCurrentResource();
        if (res != null && res instanceof TextResource) {
            TextResource tres = (TextResource)res;
            if (tres.isDocumentNote()) {
                tres.saveDocumentNote();
            }
            if (tres.isEditNonTranslatables()) {
                tres.saveResource();
            } else if (res instanceof Spellcheckable) {
                res.saveResource();
            }
        }
        ProjectView prview = this.topui.getProjectView();
        prview.saveProject();
        this.topui.getResourceView().saveGlossaries();
        MemoryView mv = this.topui.getMemoryView();
        mv.saveMemories();
    }

    void saveTextResource() {
        Resource resource = this.tview.getCurrentResource();
        if (resource != null && resource instanceof TextDocument) {
            resource.saveResource();
        } else {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A DOCUMENT FOR SAVE"));
        }
    }

    void saveAsTextResource() {
        Resource resource = this.tview.getCurrentResource();
        if (resource != null && resource instanceof TextDocument) {
            resource.saveAsResource();
        } else {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A DOCUMENT FOR SAVE"));
        }
    }

    void openImageResource() {
        String s = null;
        this.topui.getResourceLoader().prepareImageResource(s);
        this.resource.openResource();
    }

    public void close() {
        Resource resource = this.tview.getCurrentResource();
        Memory tm = this.tview.getCurrentMemory();
        if (resource != null) {
            if (resource instanceof Translatable) {
                Translatable t = (Translatable)((Object)resource);
                this.removeTranslatable(t);
            }
            resource.closeResource();
        } else if (tm != null) {
            tm.closeMemory();
        } else {
            this.tview.removeCurrentTab();
        }
    }

    public void closeAll() {
        this.topui.closeFloatingFrames();
        this.topui.saveUIState();
        this.topui.undockAllTabs();
        AppPreferences.width = this.topui.getWidth();
        AppPreferences.heigth = this.topui.getHeight();
        AppPreferences.posX = this.topui.getLocation().x;
        AppPreferences.posY = this.topui.getLocation().y;
        AppPreferences.joinedTabsNames = this.topui.getTabView().getSynchronizedTabsNames();
        Project project = this.topui.getProjectView().getProject();
        if (project != null) {
            String pp = project.getPackagePath();
            if (pp == null) {
                pp = project.getProjectPath();
            }
            if (pp != null) {
                ResourceLoader rl = this.topui.getResourceLoader();
                rl.saveProjectTemplate(pp, false);
                AppPreferences.currentProject = pp;
            }
        }
        this.tview.closeAllTabs();
        TabView.createJoinResourcesMap();
        TabView.createFloatingFramesMap();
        this.topui.getMemoryView().removeAllMemories();
        if (this.translatables != null) {
            this.translatables.clear();
        }
        this.translatable = null;
        this.topui.getMemoryView().resetAssembleParser();
    }

    public void lookUpResource(String s, String r, Resource res) {
        if (s.length() > 0) {
            ArrayList list;
            String search;
            ProjectView prview = this.topui.getProjectView();
            if (AppPreferences.searchSegmentNumbers) {
                boolean b = prview.goToTU(s);
                if (b) {
                    this.setSearchBoxText(s);
                    return;
                }
                b = prview.viewRange(s);
                if (b) {
                    this.setSearchBoxText(s);
                    return;
                }
            }
            boolean resourceSearch = false;
            boolean projectSearch = false;
            boolean floatingResourceSearch = true;
            if (this.findMode == -4) {
                this.searchManualGlossaries(s, r);
                floatingResourceSearch = false;
            } else if (this.findMode == 6 || this.findMode == 7) {
                DatabaseView dbview = this.topui.getDatabaseView();
                HashMap tables = dbview.getTables();
                if (!tables.isEmpty()) {
                    search = this.prepareSearchString(s);
                    dbview.searchTables(search, r, this.findMode);
                    this.topui.getTabView().selectResourceTab(this.findMode);
                }
                floatingResourceSearch = false;
            } else if (this.findMode == 4 || this.findMode == 5 || this.findMode >= 8) {
                projectSearch = true;
                if (this.findMode >= 8) {
                    this.topui.setSegmentsFilter();
                }
                prview = this.topui.getProjectView();
                String search2 = this.prepareSearchString(s);
                prview.searchEntry(search2, r, this.findMode);
                floatingResourceSearch = false;
            } else if (this.findMode == 2 || this.findMode == 3) {
                MemoryView mrview = this.topui.getMemoryView();
                String search3 = this.prepareSearchString(s);
                mrview.searchMemories(search3, r, this.findMode);
                floatingResourceSearch = false;
            } else if (res != null) {
                if (res instanceof TextDocument) {
                    if (this.findMode == 1) {
                        res.search(s, r);
                        this.topui.getTabView().selectResourceTab(res);
                    } else if (this.resource != null) {
                        resourceSearch = true;
                    }
                } else {
                    this.resource = res;
                    resourceSearch = true;
                }
            } else if (this.resource != null) {
                resourceSearch = true;
            }
            int multiSearch = -1;
            if (resourceSearch) {
                Resource wr;
                if ((s.startsWith("www") || s.startsWith("http") || s.startsWith("file:")) && (wr = this.topui.getTabView().getCurrentResource()) != null && wr instanceof WebResourceFX) {
                    WebResourceFX browser = (WebResourceFX)wr;
                    browser.loadPage(s);
                    return;
                }
                if (this.resource instanceof Terminal) {
                    this.searchDesktop(s);
                    this.topui.getTabView().selectResourceTab(this.resource);
                } else if (AppPreferences.sws) {
                    this.searchWebResources(s);
                    multiSearch = 1;
                    if (!(this.resource instanceof WebResource) && !(this.resource instanceof WebResourceFX)) {
                        this.resource.search(s, r);
                        this.topui.getTabView().selectResourceTab(this.resource);
                    }
                } else {
                    this.resource.search(s, r);
                    this.topui.getTabView().selectResourceTab(this.resource);
                }
            }
            if (floatingResourceSearch && (list = this.topui.getFloatingResources()) != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Resource fres = (Resource)list.get(i);
                    if (fres instanceof GlossaryResource && multiSearch == 0 || (fres instanceof WebResource || fres instanceof WebResourceFX) && multiSearch == 1) continue;
                    fres.search(s, r);
                }
            }
            if (!projectSearch && AppPreferences.includeProjectSegmentsSearch) {
                int fmode = this.findMode == 7 || this.findMode == 3 ? 5 : 4;
                prview = this.topui.getProjectView();
                search = this.prepareSearchString(s);
                prview.searchEntry(search, r, fmode);
            }
            this.setSearchBoxText(s);
        }
    }

    public void searchForDuplicateUnits(String source) {
        boolean b = AppPreferences.searchSegmentNumbers;
        AppPreferences.searchSegmentNumbers = false;
        int mt = AppPreferences.searchType;
        AppPreferences.searchType = 0;
        this.setFindMode(37);
        this.topui.setSegmentsFilter();
        this.lookUpResource(source, null, null);
        AppPreferences.searchType = mt;
        AppPreferences.searchSegmentNumbers = b;
    }

    public void searchMTWebResources(String q) {
        if (this.webresources != null) {
            if (AppPreferences.isTrialVersion && this.webMTcount >= this.MTLimit) {
                if (!this.mtTrialMessageShown) {
                    String message = "The free version of CafeTran Espresso lets you connect to the supported Machine Translation services\na limited number of times in one session. You have reached this limit.\nTo unlock the program for use without the limit, it is necessary to purchase a license file from the CafeTran.com website.";
                    this.showTrialVersionLimitMessage(message);
                    this.mtTrialMessageShown = true;
                }
                return;
            }
            ++this.webMTcount;
            q = Placeables.maskSource(q);
            for (Object next : this.webresources) {
                WebResourceFX fx;
                if (!(next instanceof WebResourceFX) || !(fx = (WebResourceFX)next).isMTWebResurces()) continue;
                fx.search(q, null);
            }
        }
    }

    public void searchQAWebResources(String q) {
        if (this.webresources != null) {
            q = Placeables.maskSource(q);
            for (Object next : this.webresources) {
                WebResourceFX fx;
                if (!(next instanceof WebResourceFX) || !(fx = (WebResourceFX)next).isQAWebResurces()) continue;
                fx.search(q, null);
            }
        }
    }

    public void searchWebResources(String s) {
        if (this.webresources != null) {
            for (int i = 0; i < this.webresources.size(); ++i) {
                Object o = this.webresources.get(i);
                if (o == null) continue;
                Resource r = (Resource)o;
                r.search(s, null);
            }
        }
    }

    public void findInWebResources(String s) {
        if (AppPreferences.sws && this.webresources != null) {
            for (int i = 0; i < this.webresources.size(); ++i) {
                Resource r;
                Object o = this.webresources.get(i);
                if (o == null || !((r = (Resource)o) instanceof WebResourceFX)) continue;
                WebResourceFX fx = (WebResourceFX)r;
                fx.findInPage(s, false);
            }
        } else if (this.resource != null && this.resource instanceof WebResourceFX) {
            WebResourceFX fx = (WebResourceFX)this.resource;
            fx.findInPage(s, false);
            this.topui.getTabView().selectResourceTab(this.resource);
        }
    }

    public void setSearchBoxText(String s) {
        boolean add = true;
        int c = this.findCombo.getItemCount();
        for (int i = 0; i < c; ++i) {
            Object object = this.findCombo.getItemAt(i);
            if (object == null || !object.toString().equals(s)) continue;
            add = false;
            break;
        }
        if (add) {
            this.findCombo.insertItemAt(s, 0);
            if (c + 1 > 20) {
                this.findCombo.removeItemAt(c);
            }
        }
    }

    public void setFindMode(int m) {
        this.findMode = m;
    }

    public int getFindMode() {
        return this.findMode;
    }

    public String prepareSearchString(String term) {
        StringBuilder sb = new StringBuilder();
        if (AppPreferences.searchType == 2) {
            Pattern pattern = Pattern.compile("\\s+");
            term = term.trim();
            term = term.replaceAll("\\s+", " ");
            String[] str = pattern.split(term);
            for (int i = 0; i < str.length; ++i) {
                int newlen;
                String string = str[i];
                boolean pause = false;
                if (string.indexOf(124) != -1) {
                    newlen = string.indexOf(124);
                    string = string.replace("|", "");
                } else if (string.indexOf(42) == -1) {
                    int len = string.length();
                    newlen = len * AppPreferences.searchTermAccuracy / 100;
                } else {
                    newlen = string.length();
                    pause = true;
                }
                if (newlen == 0) {
                    newlen = 1;
                }
                if (string.length() == 0) continue;
                if ((string = string.substring(0, newlen)).startsWith("*")) {
                    sb.append("\\b[^\\s]*");
                    string = string.substring(1);
                } else {
                    sb.append("\\b");
                }
                string = Pattern.quote(string);
                if (string.indexOf("*") != -1) {
                    string = string.replace("*", "\\E[^\\s]*\\Q");
                }
                sb.append(string);
                if (!pause) {
                    sb.append("[^\\s]*");
                } else {
                    sb.append("\\b");
                }
                if (i >= str.length - 1) continue;
                sb.append("(\\s+)");
            }
        } else if (AppPreferences.searchType == 1) {
            if (term.indexOf("+") != -1) {
                String[] mm = Pattern.compile("+", 16).split(term);
                for (int i = 0; i < mm.length; ++i) {
                    String string = mm[i];
                    string = Pattern.quote(string);
                    if (AppPreferences.searchWholewords) {
                        string = "\\b" + string + "\\b";
                    }
                    sb.append("(?=.*");
                    sb.append(string);
                    sb.append(")");
                }
            } else if (term.indexOf("|") != -1) {
                String[] mm = Pattern.compile("|", 16).split(term);
                for (int i = 0; i < mm.length; ++i) {
                    String string = mm[i];
                    string = Pattern.quote(string);
                    if (AppPreferences.searchWholewords) {
                        string = "\\b" + string + "\\b";
                    }
                    sb.append("(");
                    sb.append(string);
                    if (i == mm.length - 1) {
                        sb.append(")");
                        continue;
                    }
                    sb.append(")|");
                }
            } else {
                String string = Pattern.quote(term);
                if (AppPreferences.searchWholewords) {
                    string = "\\b" + string + "\\b";
                }
                sb.append(string);
            }
        } else if (AppPreferences.searchType == 0) {
            sb.append(term);
        }
        return sb.toString();
    }

    public static void browse(URI uri) {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THIS ACTION IS NOT SUPPORTED ON YOUR SYSTEM."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM INFORMATION"), 1);
            return;
        }
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void viewFile(File file) {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THIS ACTION IS NOT SUPPORTED ON YOUR SYSTEM."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM INFORMATION"), 1);
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    void viewDocument() {
        File file;
        String url;
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && (url = r.getLocation()) != null && (file = new File(url)).exists()) {
            this.viewFile(file);
        }
    }

    void viewGlossary() {
        File file;
        Resource r = this.topui.getTabView().getCurrentResource();
        String url = null;
        if (r != null && r instanceof DictionaryResource) {
            DictionaryResource dr = (DictionaryResource)r;
            url = dr.getLocation();
        } else {
            this.chooseGlossary();
            if (this.glossary != null) {
                url = this.glossary.getLocation();
                this.glossary = null;
            }
        }
        if (url != null && (file = new File(url)).exists()) {
            this.viewFile(file);
        }
    }

    void sendMail() {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM MAIL IS NOT SUPPORTED ON YOUR SYSTEM."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM INFORMATION"), 1);
        } else {
            String recipients;
            TextDocument tr;
            JTextPane textcomp;
            String ref = this.topui.getSourcePane().getSelectedText();
            if (ref != null) {
                ref = Pattern.compile("^", 8).matcher(ref).replaceAll("> ");
                ref = ref + AppPreferences.ls + AppPreferences.ls;
            } else {
                ref = "";
            }
            String subject = "SUBJECT=";
            String sub = this.getLookUpText();
            if (sub == null) {
                sub = "";
            }
            subject = subject + sub;
            String body = "&BODY=" + ref;
            body = body + this.topui.getTargetView().getTargetPaneText();
            StringBuffer buf = new StringBuffer();
            Resource r = this.topui.getTabView().getCurrentResource();
            if (r != null && r instanceof TextDocument && (textcomp = (tr = (TextDocument)r).getTextPane()) != null && textcomp.isEditable()) {
                String text = textcomp.getSelectedText();
                if (text == null) {
                    text = ((JTextComponent)textcomp).getText();
                }
                if (text.length() > 0) {
                    Pattern p = Pattern.compile("\\s+");
                    String[] fields = p.split(text);
                    String type = "CC=";
                    if (text.endsWith("BCC")) {
                        type = "BCC=";
                    }
                    for (int j = 0; j < fields.length; ++j) {
                        String line = fields[j];
                        if (line.indexOf(64) == -1) continue;
                        if (j == 0) {
                            buf.append(line);
                            buf.append('?');
                            continue;
                        }
                        buf.append(type);
                        buf.append(line);
                        buf.append('&');
                    }
                }
            }
            if ((recipients = buf.toString()).length() == 0) {
                recipients = "?";
            }
            String mailTo = recipients + subject + body;
            Desktop desktop = Desktop.getDesktop();
            URI uriMailTo = null;
            try {
                if (mailTo.length() > 0) {
                    uriMailTo = new URI("mailto", mailTo, null);
                    desktop.mail(uriMailTo);
                } else {
                    desktop.mail();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (URISyntaxException use) {
                use.printStackTrace();
            }
        }
    }

    public synchronized void cycleCase(JTextComponent tc, int mode) {
        String prop = (String)tc.getClientProperty("type");
        if (prop != null && prop.equals("langview2")) {
            return;
        }
        try {
            Document doc = tc.getDocument();
            int cpos = tc.getCaretPosition();
            String all = doc.getText(0, doc.getLength());
            String sourceCase = tc.getSelectedText();
            int start = -1;
            int end = -1;
            boolean select = false;
            if (sourceCase != null) {
                start = tc.getSelectionStart();
                end = tc.getSelectionEnd();
                sourceCase = all.substring(start, end);
                int len = sourceCase.length();
                for (int i = 0; i < len; ++i) {
                    int close;
                    char d = sourceCase.charAt(i);
                    if (Character.isLetter(d)) {
                        if (i <= 0) break;
                        sourceCase = sourceCase.substring(i, len);
                        start += i;
                        break;
                    }
                    if (d != '<' || (close = sourceCase.indexOf(62, i)) == -1) continue;
                    i = close;
                }
                select = true;
            } else {
                start = Utilities.getWordStart(tc, cpos);
                sourceCase = all.substring(start, end = Utilities.getWordEnd(tc, cpos)).trim();
                if (sourceCase.length() == 0) {
                    int ppos = Utilities.getPreviousWord(tc, cpos);
                    start = Utilities.getWordStart(tc, ppos);
                    end = Utilities.getWordEnd(tc, ppos);
                    sourceCase = all.substring(start, end).trim();
                }
            }
            if (sourceCase != null && sourceCase.length() > 0) {
                String target = this.changeCase(sourceCase, mode);
                StringBuffer sb = new StringBuffer(all);
                sb = sb.replace(start, end, target);
                doc.remove(0, doc.getLength());
                String p = (String)tc.getClientProperty("type");
                if (p != null && p.equals("langview")) {
                    Workflow w = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
                    if (w != null) {
                        w.markTargetTags((StyledDocument)doc, sb.toString());
                    } else {
                        doc.insertString(0, sb.toString(), null);
                    }
                } else {
                    doc.insertString(0, sb.toString(), null);
                }
                tc.setCaretPosition(cpos);
                if (select) {
                    if (target.length() > sourceCase.length()) {
                        end += target.length() - sourceCase.length();
                    }
                    tc.setSelectionStart(start);
                    tc.setSelectionEnd(end);
                }
                tc.requestFocusInWindow();
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(SourceView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String changeCase(String s, int mode) {
        String upper;
        StringBuffer sb;
        Locale locale;
        String t = null;
        Project p = this.topui.getProjectView().getProject();
        if (p != null) {
            locale = p.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        boolean dutch = false;
        int i = 1;
        if (s.length() > 1) {
            String lang;
            if (s.charAt(1) == '\'') {
                i = 2;
            }
            if (!(!(lang = locale.getLanguage()).equals("nl") || s.charAt(0) != 'i' && s.charAt(0) != 'I' || s.charAt(1) != 'j' && s.charAt(1) != 'J')) {
                dutch = true;
                i = 2;
            }
        }
        if (mode == 1) {
            int len = s.length();
            char a = s.charAt(0);
            if (Character.isUpperCase(a)) {
                t = len > i ? (Character.isUpperCase(a = s.charAt(i)) ? s.toLowerCase(locale) : (Character.isLetter(a) ? s.toUpperCase(locale) : s.toLowerCase(locale))) : s.toLowerCase(locale);
            } else {
                sb = new StringBuffer(s);
                upper = sb.substring(0, 1).toUpperCase(locale);
                sb = sb.deleteCharAt(0);
                sb = sb.insert(0, upper);
                if (dutch) {
                    String upper2 = sb.substring(1, 2).toUpperCase(locale);
                    sb = sb.deleteCharAt(1);
                    sb = sb.insert(1, upper2);
                }
                t = sb.toString();
            }
        } else if (mode == 2) {
            BreakIterator bi = BreakIterator.getWordInstance(locale);
            bi.setText(s);
            int bound = bi.current();
            sb = new StringBuffer(s);
            while (bound != -1 && bound < sb.length()) {
                if (dutch && bound + 1 < sb.length() && (upper = sb.substring(bound, bound + 2).toUpperCase(locale)).equals("IJ")) {
                    sb = sb.deleteCharAt(bound);
                    sb = sb.deleteCharAt(bound);
                    sb = sb.insert(bound, upper);
                    bound = bi.next();
                    continue;
                }
                upper = sb.substring(bound, bound + 1).toUpperCase(locale);
                sb = sb.deleteCharAt(bound);
                sb = sb.insert(bound, upper);
                bound = bi.next();
            }
            t = sb.toString();
        }
        if (t != null) {
            int stag = t.indexOf("<");
            int etag = t.indexOf(">");
            sb = new StringBuffer(t);
            while (stag != -1 && etag != -1 && etag > stag) {
                String tag = t.substring(stag, etag);
                tag = tag.toLowerCase(locale);
                sb.replace(stag, etag, tag);
                stag = t.indexOf("<", etag + 1);
                etag = t.indexOf(">", etag + 1);
            }
            t = sb.toString();
        }
        return t;
    }

    public void showUnicode() {
        JTextComponent comp = this.topui.getFocusedTextComponent();
        int pos = comp.getCaretPosition();
        Document doc = comp.getDocument();
        if (doc.getLength() > 0 && pos > -1) {
            String s = null;
            try {
                s = doc.getText(pos, 1);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ResourceView.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (s != null) {
                char c = s.charAt(0);
                String u = String.format("U+%04X", c);
                JLabel bar = this.topui.getMainStatusBar();
                bar.setText(s + " = " + u);
            }
        }
    }

    public void zoomPlus() {
        Resource resource = this.tview.getCurrentResource();
        if (resource != null) {
            if (resource instanceof WebResourceFX || resource instanceof WebResource || resource instanceof ImageResource) {
                resource.plusResource();
            } else {
                this.topui.getSourceView().plusFont();
                this.topui.getTargetView().plusFont();
                if (resource instanceof CTLinguist) {
                    resource.plusResource();
                }
            }
        } else {
            this.topui.getSourceView().plusFont();
            this.topui.getTargetView().plusFont();
        }
    }

    public void zoomMinus() {
        Resource resource = this.tview.getCurrentResource();
        if (resource != null) {
            if (resource instanceof WebResourceFX || resource instanceof WebResource || resource instanceof ImageResource) {
                resource.minusResource();
            } else {
                this.topui.getSourceView().minusFont();
                this.topui.getTargetView().minusFont();
                if (resource instanceof CTLinguist) {
                    resource.minusResource();
                }
            }
        } else {
            this.topui.getSourceView().minusFont();
            this.topui.getTargetView().minusFont();
        }
    }

    public String addOnlineResource() {
        String s = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WEB");
        String rp = AppPreferences.packagePath + "forms/InternetAddResource";
        NewResource dlg = new NewResource(this.topui, s, rp, 0);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        boolean approve = dlg.approve;
        s = dlg.infoPath;
        if (approve) {
            this.refreshResourceMenu();
            return s;
        }
        return null;
    }

    public String addImageResource() {
        String s = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMAGE");
        String rp = AppPreferences.packagePath + "forms/ImageAddResource";
        NewResource dlg = new NewResource(this.topui, s, rp, 1);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        boolean approve = dlg.approve;
        s = dlg.infoPath;
        if (approve) {
            this.refreshResourceMenu();
            return s;
        }
        return null;
    }

    private void newGlossary(final boolean isNew) {
        String wloc;
        File f;
        final String loc = AppPreferences.glossaryDir.length() > 0 ? AppPreferences.glossaryDir : (AppPreferences.operatingSystem == 0 ? (!(f = new File(wloc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists() ? System.getProperty("user.home") : wloc) : System.getProperty("user.home"));
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ ResourceView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        if (!this.this$0.mergeGlossaries || isNew) {
                            File f;
                            FileChooser fileChooser = new FileChooser();
                            if (loc != null && loc.length() > 0 && (f = new File(loc)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            if (isNew) {
                                String n;
                                int dot;
                                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("TEXT files (*.txt)", new String[]{"*.txt"});
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY NAME"));
                                fileChooser.getExtensionFilters().add((Object)extFilter);
                                file = fileChooser.showSaveDialog(null);
                                if (file != null && (dot = (n = file.getName()).indexOf(46)) == -1) {
                                    file.renameTo(new File(file.getPath() + ".txt"));
                                }
                            } else {
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                                file = fileChooser.showOpenDialog(null);
                            }
                        } else {
                            File f;
                            DirectoryChooser fileChooser = new DirectoryChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                            if (loc != null && loc.length() > 0 && (f = new File(loc)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showDialog(null);
                        }
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 81 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this$0.showGlossaryInfoPanel(file, this.this$1.isNew);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 81 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            int option;
            JFileChooser jch = new JFileChooser(loc);
            if (isNew) {
                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY NAME"));
                option = jch.showSaveDialog(this.topui);
            } else {
                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                jch.setFileSelectionMode(2);
                option = jch.showOpenDialog(this.topui);
            }
            if (option == 0) {
                File file = jch.getSelectedFile();
                this.showGlossaryInfoPanel(file, isNew);
            }
        }
    }

    private void showGlossaryInfoPanel(File file, boolean isNew) {
        String parent;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.topui, ex.getMessage());
                Logger.getLogger(NewResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((parent = file.getParent()) != null) {
            AppPreferences.glossaryDir = parent;
        }
        String resourcePath = null;
        try {
            resourcePath = file.toURI().toURL().getPath();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        if (resourcePath != null && resourcePath.startsWith(AppPreferences.packagePath + "resources")) {
            resourcePath = resourcePath.substring(AppPreferences.packagePath.length());
            resourcePath = resourcePath.replaceAll("%20", " ");
        } else {
            resourcePath = file.getPath();
            if (file.isDirectory()) {
                resourcePath = resourcePath + AppPreferences.fs;
            } else if (!file.exists() && resourcePath.indexOf(46) == -1) {
                resourcePath = resourcePath + ".txt";
            }
        }
        String title = isNew ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW GLOSSARY") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD GLOSSARY");
        String rp = AppPreferences.packagePath + "forms/GlossaryAddResource";
        NewResource dlg = new NewResource(this.topui, title, rp, 9);
        dlg.chooseGlossary(resourcePath);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point ploc = this.topui.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + ploc.x, (frmSize.height - dlgSize.height) / 2 + ploc.y);
        dlg.setVisible(true);
        boolean approve = dlg.approve;
        String s = dlg.infoPath;
        if (approve && s != null) {
            this.topui.getResourceLoader().prepareResources(s);
        }
    }

    public void reloadGlossaries() {
        ResourceView rview = this.topui.getResourceView();
        List glossList = rview.getGlossaries();
        if (glossList != null && glossList.size() > 0) {
            for (Object object : glossList) {
                GlossaryResource g = (GlossaryResource)object;
                g.reloadGlossary();
            }
        }
    }

    private void reloadGlossary() {
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof GlossaryResource) {
            this.glossary = (GlossaryResource)r;
        } else {
            this.chooseGlossary();
        }
        if (this.glossary != null) {
            this.glossary.reloadGlossary();
            this.glossary = null;
        }
    }

    private void joinGlossary() {
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof GlossaryResource) {
            this.glossary = (GlossaryResource)r;
        } else {
            this.chooseGlossary();
        }
        if (this.glossary != null) {
            this.glossary.joinGlossary();
            this.glossary = null;
        }
    }

    private void importExcelGlossary() {
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof GlossaryResource) {
            this.glossary = (GlossaryResource)r;
        } else {
            this.chooseGlossary();
        }
        if (this.glossary != null) {
            this.glossary.importExcel();
            this.glossary = null;
        }
    }

    private void mergeGlossaryTargets() {
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof GlossaryResource) {
            this.glossary = (GlossaryResource)r;
        } else {
            this.chooseGlossary();
        }
        if (this.glossary != null) {
            this.glossary.mergeTargets();
            this.glossary = null;
        }
    }

    private void sortGlossary(int type) {
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof GlossaryResource) {
            this.glossary = (GlossaryResource)r;
        } else {
            this.chooseGlossary();
        }
        if (this.glossary != null) {
            if (type == 0) {
                this.glossary.sort();
            } else if (type == 1) {
                this.glossary.sortByLengthAlphabet();
            }
            this.glossary = null;
        }
    }

    private void removeDuplicateEntries() {
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof GlossaryResource) {
            this.glossary = (GlossaryResource)r;
        } else {
            this.chooseGlossary();
        }
        if (this.glossary != null) {
            this.glossary.removeDuplicates();
            this.glossary = null;
        }
    }

    private void removeSourceEqualsTargetEntries() {
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof GlossaryResource) {
            this.glossary = (GlossaryResource)r;
        } else {
            this.chooseGlossary();
        }
        if (this.glossary != null) {
            this.glossary.removeSourceEqualsTarget();
            this.glossary = null;
        }
    }

    public void editResourceInfo(String ipath) {
        NewResource dlg = new NewResource(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESOURCE INFORMATION"), ipath, -1);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        if (dlg.approve) {
            this.refreshResourceMenu();
        }
    }

    public void editGlossaryInfo(String ipath) {
        NewResource dlg = new NewResource(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESOURCE INFORMATION"), ipath, -1);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        if (dlg.approve) {
            this.glossaryMenu.removeAll();
            this.setGlossaries(new File(AppPreferences.packagePath + "infos/resources"), this.glossaryMenu, 0);
        }
    }

    public void refreshResourceMenu() {
        this.libraryMenu.removeAll();
        if (this.transMenu != null) {
            this.transMenu.removeAll();
            this.setMemories(new File(AppPreferences.packagePath + "infos/memories"), this.transMenu, 0);
            this.libraryMenu.add(this.transMenu);
        }
        this.libraryMenu.addSeparator();
        this.setResources(new File(AppPreferences.packagePath + "infos/resources"), this.libraryMenu, 0);
    }

    public void setExternalTranslatable(Translatable t) {
        this.translatable = t;
        this.addTranslatable(t);
        this.ooResource = (Resource)((Object)t);
    }

    public Translatable getExternalTranslatable() {
        return this.translatable;
    }

    public boolean isLibreOfficeAvailable() {
        return this.ooResource != null;
    }

    public String getWordAtCaretPosition(JTextComponent pane, boolean selectWord) {
        String word = null;
        int cpos = pane.getCaretPosition();
        try {
            int end;
            Document doc = pane.getDocument();
            int len = doc.getLength();
            if (len == 0) {
                return null;
            }
            String all = doc.getText(0, len);
            if (AppPreferences.noWordSeparatorSourceLanguage) {
                int end2;
                int start;
                if (cpos == 0) {
                    start = 0;
                    end2 = 1;
                } else {
                    start = cpos - 1;
                    end2 = cpos;
                }
                word = all.substring(start, end2);
                if (selectWord) {
                    pane.setSelectionStart(start);
                    pane.setSelectionEnd(end2);
                }
                return word;
            }
            int start = Utilities.getWordStart(pane, cpos);
            word = all.substring(start, end = Utilities.getWordEnd(pane, cpos)).trim();
            if (word.length() == 0 && cpos > 0) {
                int ppos = Utilities.getPreviousWord(pane, cpos);
                start = Utilities.getWordStart(pane, ppos);
                end = Utilities.getWordEnd(pane, ppos);
                word = all.substring(start, end).trim();
            }
            if (word != null && selectWord) {
                pane.setSelectionStart(start);
                pane.setSelectionEnd(end);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return word;
    }

    public void searchDefaulScope() {
        Object o = this.findCombo.getSelectedItem();
        String s = null;
        if (o != null) {
            s = o.toString();
        }
        if (s == null || s.length() == 0) {
            s = this.topui.getSourcePane().getText();
            s = XMLHelper.parseTags(s);
        }
        if (s != null && s.length() > 0) {
            String r = null;
            Resource res = this.topui.getActiveResource();
            if (res == null) {
                res = this.tview.getCurrentResource();
            }
            this.lookUpResource(s, r, res);
        }
    }

    public void search(int mode) {
        JTextComponent textComp = this.topui.getFocusedTextComponent();
        String prop = (String)textComp.getClientProperty("type");
        String s = prop != null && prop.equals("searchfield") ? textComp.getText() : textComp.getSelectedText();
        if (!(s != null && s.length() != 0 || (s = this.getWordAtCaretPosition(textComp, true)) != null && s.length() != 0)) {
            s = (String)this.findCombo.getSelectedItem();
        }
        if (s != null && s.length() > 0) {
            s = XMLHelper.parseTags(s);
            this.getLookUpBox().setSelectedItem(s);
            if (mode >= 0 || mode == -4) {
                String r = null;
                Resource res = this.topui.getActiveResource();
                if (res == null) {
                    res = this.topui.getTabView().getCurrentResource();
                }
                int m = this.getFindMode();
                this.setFindMode(mode);
                this.lookUpResource(s, r, res);
                this.setFindMode(m);
            } else if (mode == -1) {
                this.searchDefaulScope();
            } else if (mode == -2) {
                this.searchDesktop(s);
            } else if (mode == -3) {
                this.translateAIService(s);
                this.translateMTSelection(s);
            } else if (mode == -5) {
                this.findInWebResources(s);
            }
        }
    }

    public void searchInLibreOffice(String query, String replace) {
        if (this.ooResource != null) {
            this.ooResource.search(query, replace);
        }
    }

    public void searchDesktop(String query) {
        String com = AppPreferences.desktopSearchTool;
        if (com.length() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        Pattern p = Pattern.compile("\".+?\"|[^ ]+");
        Matcher m = p.matcher(com);
        int j = 0;
        boolean shell = false;
        while (m.find()) {
            String s = m.group();
            if (j == 0 && s.startsWith("/bin/sh")) {
                shell = true;
            } else if (shell && j == 2) {
                s = com.substring(m.start());
                if (s.startsWith("\"") && s.endsWith("\"")) {
                    s = s.substring(1, s.length() - 1);
                }
                s = s.replace("{}", query);
                list.add(s);
                break;
            }
            s = s.replace("{}", query);
            list.add(s);
            ++j;
        }
        String[] command = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            command[i] = object.toString();
        }
        if (!AppPreferences.terminalTool) {
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        } else {
            if (this.terminal == null) {
                this.openTerminal();
            } else {
                this.topui.getTabView().selectTab("DST");
            }
            this.terminal.runCommand(command, query);
        }
    }

    public void showExtractedSearchResults(Set extractedResults, String name) {
        if (extractedResults != null && extractedResults.size() > 0) {
            Resource res;
            StringBuilder sb = new StringBuilder();
            Iterator it = extractedResults.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next()).append('\n');
            }
            extractedResults.clear();
            boolean b = this.tview.tabExists(name);
            if (b) {
                this.tview.selectTab(name);
                res = this.tview.getCurrentResource();
            } else {
                res = this.topui.getResourceView().newTextDocument(name);
            }
            if (res != null && res instanceof TextDocument) {
                Resource tres = res;
                try {
                    Document doc = ((TextDocument)tres).getDocument();
                    if (doc.getLength() > 0) {
                        doc.remove(0, doc.getLength());
                    }
                    ((TextDocument)tres).getDocument().insertString(0, sb.toString(), null);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(ResourceView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void chooseGlossary() {
        if (this.glossaries == null || this.glossaries.isEmpty()) {
            return;
        }
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (this.glossaries.size() > 20) {
            scroll.setPreferredSize(new Dimension(500, 500));
        }
        dialog.add(scroll);
        for (GlossaryResource g : this.glossaries) {
            JButton button = new JButton(g.getName());
            if (g.isReadOnly()) {
                button.setEnabled(false);
            }
            button.putClientProperty("glossary", g);
            button.addActionListener(new ActionListener(){
                final /* synthetic */ ResourceView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton)e.getSource();
                    this.this$0.glossary = (GlossaryResource)button.getClientProperty("glossary");
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            button.setHorizontalAlignment(2);
            button.setFont(button.getFont().deriveFont(1));
            panel.add(button);
        }
        JButton cancelButton = new JButton(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL")){
            final /* synthetic */ ResourceView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        cancelButton.setHorizontalAlignment(0);
        panel.add(cancelButton);
        JButton button = (JButton)panel.getComponent(0);
        button.requestFocusInWindow();
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    private void setPopup() {
        this.pop = new GridPopupMenu();
        this.pop.setBorder(BorderFactory.createRaisedBevelBorder());
        this.pop.setGrid(AppPreferences.backGrid);
        this.pop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ResourceView.this.pop.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ResourceView.this.pop.removeAll();
            }
        });
    }

    public void showClipboardSelectionPopUp(Component comp, int x, int y) {
        if (this.pop == null) {
            this.setPopup();
        }
        int no = 0;
        Font f = this.topui.getSourcePane().getFont();
        float fs = 12.0f;
        if (this.clipboadList != null) {
            Iterator it = this.clipboadList.iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                JMenuItem item = new JMenuItem(new AbstractAction(key){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        String com = a.getActionCommand();
                        if (AppPreferences.clipboardTarget == 0) {
                            ResourceView.this.getLookUpBox().setSelectedItem(com);
                        } else if (AppPreferences.clipboardTarget == 2) {
                            ResourceView.this.topui.getTargetView().grabSelection(com);
                        } else if (AppPreferences.clipboardTarget == 4) {
                            ResourceView.this.topui.getTargetView().grabSelection(com);
                        } else if (AppPreferences.clipboardTarget == 1) {
                            MemoryView mv = ResourceView.this.topui.getMemoryView();
                            mv.translateSegment(com, null, null, null, false);
                        } else if (AppPreferences.clipboardTarget == 3) {
                            ResourceView.this.topui.getSourceView().addSelectedWord(com, false);
                        }
                    }
                });
                if (++no == 10) {
                    no = 0;
                }
                char sh = Character.forDigit(no, 10);
                item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                item.setActionCommand(key);
                int max = 400;
                if (key.length() > max) {
                    key = key.substring(0, max) + "...";
                }
                key = key.replaceAll("\n", " ");
                item.setText("<html><body width=800>" + key + "</body></html>");
                item.setFont(f.deriveFont(fs));
                this.pop.add(item);
            }
            if (this.pop.getComponentCount() > 0) {
                this.pop.show(comp, x, y);
            }
        }
    }

    public void addToClipboardHistory(String key) {
        if (this.clipboadList != null) {
            this.clipboadList.add(0, key);
            if (this.clipboadList.size() == 11) {
                this.clipboadList.remove(10);
            }
        }
    }

    public void importClipboardText() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard clip = tk.getSystemClipboard();
        String imp = null;
        try {
            Transferable cntnts = clip.getContents(null);
            if (cntnts == null) {
                return;
            }
            if (cntnts.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                imp = (String)cntnts.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception cntnts) {
            // empty catch block
        }
        if (imp == null || imp.length() == 0) {
            return;
        }
        final String importString = imp;
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ResourceView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                TextDocument tr = this.this$0.newTextDocument(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE TEXT"));
                JTextPane sourcePane = tr.getTextPane();
                if (sourcePane != null) {
                    Document doc = sourcePane.getDocument();
                    try {
                        doc.insertString(0, importString, null);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(ResourceView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    sourcePane.setCaretPosition(0);
                }
            }
        });
    }

    public void bindExternalEditor(boolean state) {
        Browser.stopBindScript();
        if (state) {
            if (AppPreferences.editorBinding.equals("Clipboard binding")) {
                AppPreferences.clipboardSourceSegment = false;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection ss = new StringSelection("");
                this.clipboardHandler = this.getClipboardHandler();
                clipboard.setContents(ss, this.clipboardHandler);
            } else {
                if (AppPreferences.editorBinding.equals("DeepL")) {
                    WebResourceFX wr = this.getMTWebResource("https://www.deepl.com/translator");
                    if (wr != null) {
                        wr.bindWebpageEditor();
                    }
                    return;
                }
                if (AppPreferences.editorBinding.equals("Google Translate")) {
                    WebResourceFX wr = this.getMTWebResource("://translate.google.com");
                    if (wr != null) {
                        wr.bindWebpageEditor();
                    }
                    return;
                }
                if (AppPreferences.editorBinding.equals("Bing Translator")) {
                    WebResourceFX wr = this.getMTWebResource("https://www.bing.com/translator");
                    if (wr != null) {
                        wr.bindWebpageEditor();
                    }
                    return;
                }
            }
        } else if (AppPreferences.editorBinding.equals("Clipboard binding")) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection ss = new StringSelection("");
            clipboard.setContents(ss, null);
        }
        this.topui.getTargetView().bindExternalEditor(state);
    }

    public void setClipboardSensitive(boolean state) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard clipboard = tk.getSystemClipboard();
        if (state) {
            StringSelection ss = new StringSelection("");
            this.clipboardHandler = this.getClipboardHandler();
            clipboard.setContents(ss, this.clipboardHandler);
            this.clipboadList = new ArrayList(10);
            this.setPopup();
        } else {
            StringSelection ss = new StringSelection("");
            clipboard.setContents(ss, null);
            this.clipboadList = null;
            this.pop = null;
        }
    }

    public void addTargetToClipboard(String target) {
        ++this.clipboardCount;
        if (this.reachedTrialVersionClipboardLimit()) {
            return;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard clipboard = tk.getSystemClipboard();
        StringSelection ss = new StringSelection(target);
        if (this.clipboardHandler != null) {
            this.clipboardHandler.setTargetOut(true);
        }
        this.clipboardHandler = this.getClipboardHandler();
        clipboard.setContents(ss, this.clipboardHandler);
    }

    public void addHTMLTargetToClipboard(String target) {
        ++this.clipboardCount;
        if (this.reachedTrialVersionClipboardLimit()) {
            return;
        }
        target = "<html>" + target + "</html>";
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard clipboard = tk.getSystemClipboard();
        Transferable ss = this.getHTMLTransferable(target);
        if (this.clipboardHandler != null) {
            this.clipboardHandler.setTargetOut(true);
        }
        this.clipboardHandler = this.getClipboardHandler();
        clipboard.setContents(ss, this.clipboardHandler);
    }

    public void addStringToClipboard(String source) {
        ++this.clipboardCount;
        if (this.reachedTrialVersionClipboardLimit()) {
            return;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard clipboard = tk.getSystemClipboard();
        StringSelection ss = new StringSelection(source);
        if (this.clipboardHandler != null) {
            this.clipboardHandler.setStringOut(true);
        }
        clipboard.setContents(ss, null);
    }

    public String getClipboardContext() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard clip = tk.getSystemClipboard();
        String imp = null;
        try {
            Transferable cntnts = clip.getContents(null);
            if (cntnts == null) {
                return null;
            }
            if (cntnts.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                imp = (String)cntnts.getTransferData(DataFlavor.stringFlavor);
                StringSelection ss = new StringSelection("");
                if (this.clipboardHandler != null) {
                    this.clipboardHandler.setStringOut(true);
                }
                clip.setContents(ss, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (imp != null && imp.trim().length() > 0) {
            return imp;
        }
        return null;
    }

    public void copySystemIDToClipboard(String source) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard clipboard = tk.getSystemClipboard();
        StringSelection ss = new StringSelection(source);
        if (this.clipboardHandler != null) {
            this.clipboardHandler.setStringOut(true);
        }
        clipboard.setContents(ss, null);
    }

    private Transferable getHTMLTransferable(final String s) {
        Transferable ss = new Transferable(){
            final /* synthetic */ ResourceView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.getMimeType().equals("text/html;class=java.lang.String");
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                try {
                    return new DataFlavor[]{new DataFlavor("text/html;class=java.lang.String")};
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return s;
            }
        };
        return ss;
    }

    public ClipboardHandler getClipboardHandler() {
        if (this.clipboardHandler != null) {
            return this.clipboardHandler;
        }
        return new ClipboardHandler(this.topui);
    }

    public void setResourcesFont(Font font) {
        JTextComponent pane;
        List gs = this.getGlossaries();
        for (GlossaryResource next : gs) {
            pane = next.getGlossaryPane();
            pane.setFont(font);
        }
        MemoryView mv = this.topui.getMemoryView();
        List ms = mv.getLocalMemories();
        for (Memory next : ms) {
            JTextPane pane2 = next.getMemoryPane();
            pane2.setFont(font);
        }
        if (this.mt != null && (pane = this.mt.getMTPane()) != null) {
            pane.setFont(font);
        }
        if (this.mt2 != null && (pane = this.mt2.getMTPane()) != null) {
            pane.setFont(font);
        }
        if (this.mt3 != null && (pane = this.mt3.getMTPane()) != null) {
            pane.setFont(font);
        }
        if (this.mt4 != null && (pane = this.mt4.getMTPane()) != null) {
            pane.setFont(font);
        }
        if (this.mt5 != null && (pane = this.mt5.getMTPane()) != null) {
            pane.setFont(font);
        }
        if (this.mt6 != null && (pane = this.mt6.getMTPane()) != null) {
            pane.setFont(font);
        }
        if (this.mt7 != null && (pane = this.mt7.getMTPane()) != null) {
            pane.setFont(font);
        }
        if (this.mt8 != null && (pane = this.mt8.getMTPane()) != null) {
            pane.setFont(font);
        }
        if (this.proz != null && (pane = this.proz.getResourcePane()) != null) {
            pane.setFont(font);
        }
        if (this.tmTown != null && (pane = this.tmTown.getResourcePane()) != null) {
            pane.setFont(font);
        }
        if (this.linguist != null && (pane = this.linguist.getChatPane()) != null) {
            pane.setFont(font);
        }
    }

    public void speak(String s) {
        if (AppPreferences.chatGPTSpeak == -1) {
            return;
        }
        if (this.amazonTTS != null && AppPreferences.chatGPTSpeak == 0) {
            this.amazonTTS.talk(s);
        } else if (this.linguist != null && AppPreferences.chatGPTSpeak == 1) {
            this.linguist.talk(s);
        }
    }

    public void speakSelectedText() {
        String q;
        JTextComponent pane;
        String s = this.topui.getSourceView().getSelectedWords();
        if (s == null && (s = (pane = this.topui.getFocusedTextComponent()).getSelectedText()) == null && (s = pane.getText()).length() == 0) {
            s = this.topui.getSourcePane().getText();
        }
        if (s != null && s.trim().length() > 0 && (q = XMLHelper.parseTags(s)).length() > 0) {
            if (this.amazonTTS != null && AppPreferences.chatGPTSpeak == 0) {
                this.amazonTTS.talk(q);
            } else if (this.linguist != null) {
                this.linguist.talk(q);
            }
        }
    }

    private void showTrialVersionLimitMessage(String message) {
        String s = "Trial Version Limit";
        String buy = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PURCHASE LICENSE");
        String cont = "Continue to use free version, with limits";
        Object[] options = new String[]{buy, cont};
        int i = JOptionPane.showOptionDialog(this.topui, message, s, 0, 1, null, options, buy);
        if (i == 0) {
            try {
                URI uri = new URI(AppPreferences.purchase_url);
                this.topui.getResourceView();
                ResourceView.browse(uri);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    boolean reachedTrialVersionClipboardLimit() {
        if (AppPreferences.isTrialVersion && this.clipboardCount >= this.AutoClipboardLimit) {
            if (!this.clipboardTrialMessageShown) {
                String message = "The free version of CafeTran Espresso enables the automatic copy to clipboard\na limited number of times in one session. You have reached this limit.\nTo unlock the program for use without the limit, it is necessary to purchase a license file from the CafeTran.com website.";
                this.showTrialVersionLimitMessage(message);
                this.clipboardTrialMessageShown = true;
            }
            return true;
        }
        return false;
    }
}

