/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JViewport;

public class ScrollPaneWatermark
extends JViewport {
    BufferedImage fgimage;
    BufferedImage bgimage;
    TexturePaint texture;

    public void setBackgroundTexture(URL url) throws IOException {
        this.bgimage = ImageIO.read(url);
        Rectangle rect = new Rectangle(0, 0, this.bgimage.getWidth(null), this.bgimage.getHeight(null));
        this.texture = new TexturePaint(this.bgimage, rect);
    }

    public void setForegroundBadge(URL url) throws IOException {
        this.fgimage = ImageIO.read(url);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.texture != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.texture);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.fgimage != null) {
            g.drawImage(this.fgimage, this.getWidth() - this.fgimage.getWidth(null), 0, null);
        }
    }

    public void setView(JComponent view) {
        view.setOpaque(false);
        super.setView(view);
    }

    public static String fileToString(File file) throws FileNotFoundException, IOException {
        int n;
        FileReader reader = new FileReader(file);
        StringWriter writer = new StringWriter();
        char[] buf = new char[1000];
        while ((n = reader.read(buf, 0, 1000)) != -1) {
            writer.write(buf, 0, n);
        }
        return writer.toString();
    }
}

