/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.MainClass;
import translator.MemoryStatistics;
import translator.StopWords;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.WordCount;
import translator.XMLElement;
import translator.XMLHelper;
import translator.hunspell.HunSpellChecker;
import translator.tmx.Memory;
import translator.tmx.TMXResult;
import translator.ttx.TTXUnit;
import translator.xliff.XLIFFUnit;

public final class SegmentParser {
    private String[][] keysArray;
    private String[][] fullkeysArray;
    private Pattern[][] patternsArray;
    private Pattern matchPattern;
    private Pattern matchPattern2;
    private String wordSeparator;
    private int index;
    private TranslationUnitMap tumap;
    private Set tuset;
    private TMXResult results;
    private HashMap hm;
    private ConcurrentHashMap cache;
    private List functionTargetWords;
    private List functionSourceWords;
    private String bestMatch;
    private String bestMatchFull;
    private boolean running;
    private boolean found;
    private float step;
    private String fullSegment;
    private String cleanSegment;
    private String sourceSegmentKey;
    private String sLang;
    private String tLang;
    private HashMap fuzzies;
    private LinkedHashMap bestFuzzies;
    private int lengthSourceSegmentClean;
    private int matchType;
    private MemoryStatistics stats;
    private boolean prefMatch;
    private boolean caseMatch;
    private boolean compareTargets;
    private int priority;
    private XLIFFUnit currentXliffUnit;
    private TTXUnit currentTTXUnit;
    private WordCount wordCount;
    private boolean analysis;
    private Locale srcLocale;
    private boolean userBreakIteratorTokenizer;
    private Set activeKeys;
    private Memory memory;
    int fstats;
    int flength;
    int segLength = 0;
    int occur;
    boolean withContext;
    int pointer;
    int previousPointer;

    public SegmentParser(Memory memory) {
        this.memory = memory;
        this.functionTargetWords = new ArrayList();
        this.functionSourceWords = new ArrayList();
    }

    public void setSourceLocale(Locale loc) {
        this.srcLocale = loc;
        if (this.srcLocale != null && this.srcLocale.getLanguage().equals("th")) {
            this.wordSeparator = "";
            this.userBreakIteratorTokenizer = true;
        }
    }

    public void setAnalyseMode(boolean mode) {
        this.analysis = mode;
        this.wordCount = mode ? new WordCount() : null;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public void setCompareTargets(boolean compare) {
        this.compareTargets = compare;
    }

    public void setMatchingType(int mtype, boolean prefixes, boolean caseMatching) {
        this.matchType = mtype;
        if (mtype == 2) {
            this.matchPattern = Pattern.compile("", 16);
            this.matchPattern2 = Pattern.compile("", 16);
            this.wordSeparator = "";
            this.prefMatch = false;
        } else {
            this.matchPattern = Pattern.compile("\\s+");
            this.matchPattern2 = Pattern.compile("(\\p{Punct}*\\s+\\p{Punct}*)|(\\p{Punct}\\z)");
            this.wordSeparator = " ";
            this.prefMatch = prefixes;
        }
        this.caseMatch = caseMatching;
    }

    public void setTUMap(TranslationUnitMap map) {
        this.tumap = map;
        this.tuset = this.tumap.getSourceSegmentsSet();
        this.cache = new ConcurrentHashMap();
    }

    public void setMemoryStatistics(MemoryStatistics mstats) {
        this.stats = mstats;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public TMXResult getFromCache(String seg) {
        TMXResult res = (TMXResult)this.cache.get(seg);
        return res;
    }

    public void removeFromCache(String seg) {
        if (this.cache != null && !this.cache.isEmpty()) {
            this.cache.remove(seg);
        }
    }

    public ConcurrentHashMap getCacheMap() {
        return this.cache;
    }

    private void findBestFuzzies() {
        if (this.activeKeys == null) {
            this.activeKeys = new HashSet(16384);
        } else {
            this.activeKeys.clear();
        }
        this.fstats = 0;
        this.flength = 0;
        for (int i = 0; i < this.keysArray.length; ++i) {
            if (this.prefMatch) {
                this.lookUpFuzziesPrefixes(i, 0);
                continue;
            }
            this.lookUpFuzzies(i, 0);
        }
        if (this.analysis) {
            if (this.fstats < 50) {
                ++this.stats.noMatch;
                this.stats.noMatchL += (float)this.segLength;
                this.wordCount.doWordCount(this.fullSegment);
                this.stats.noMatchW += this.wordCount.getWordCount();
            } else if (this.fstats > 49 && this.fstats < 75) {
                ++this.stats.fuzzy4;
                this.stats.fuzzy4L += (float)this.segLength;
                this.wordCount.doWordCount(this.fullSegment);
                this.stats.fuzzy4W += this.wordCount.getWordCount();
            } else if (this.fstats > 74 && this.fstats < 85) {
                ++this.stats.fuzzy3;
                this.stats.fuzzy3L += (float)this.segLength;
                this.wordCount.doWordCount(this.fullSegment);
                this.stats.fuzzy3W += this.wordCount.getWordCount();
            } else if (this.fstats > 84 && this.fstats < 95) {
                ++this.stats.fuzzy2;
                this.stats.fuzzy2L += (float)this.segLength;
                this.wordCount.doWordCount(this.fullSegment);
                this.stats.fuzzy2W += this.wordCount.getWordCount();
            } else if (this.fstats > 94 && this.fstats <= 100) {
                ++this.stats.fuzzy1;
                this.stats.fuzzy1L += (float)this.segLength;
                this.wordCount.doWordCount(this.fullSegment);
                this.stats.fuzzy1W += this.wordCount.getWordCount();
            }
        }
    }

    private void makeSourceElements() {
        String comp;
        Iterator it;
        int n;
        String string;
        int i;
        String[] str;
        if (this.prefMatch) {
            str = this.userBreakIteratorTokenizer ? this.breakSegmentIntoWords(this.cleanSegment) : this.matchPattern.split(this.cleanSegment);
            if (this.matchType == 2 && !this.userBreakIteratorTokenizer) {
                ArrayList<String> list = new ArrayList<String>();
                for (i = 0; i < str.length; ++i) {
                    string = str[i];
                    if (string.length() <= 0) continue;
                    list.add(string);
                }
                str = new String[list.size()];
                n = 0;
                it = list.iterator();
                while (it.hasNext()) {
                    String string2;
                    str[n] = string2 = it.next().toString();
                    ++n;
                }
            }
            int l = str.length;
            this.fullkeysArray = new String[l][l];
            for (i = 0; i < str.length; ++i) {
                this.fullkeysArray[i][0] = comp = str[i];
                for (int j = i + 1; j < str.length; ++j) {
                    this.fullkeysArray[i][j] = comp = comp + this.wordSeparator + str[j];
                }
            }
            this.sourceSegmentKey = this.makePrefixes(this.cleanSegment);
        } else {
            this.sourceSegmentKey = this.cleanSegment;
        }
        str = this.userBreakIteratorTokenizer ? this.breakSegmentIntoWords(this.sourceSegmentKey) : this.matchPattern.split(this.sourceSegmentKey);
        if (this.matchType == 2 && !this.userBreakIteratorTokenizer) {
            ArrayList<String> list = new ArrayList<String>();
            for (i = 0; i < str.length; ++i) {
                string = str[i];
                if (string.length() <= 0) continue;
                list.add(string);
            }
            str = new String[list.size()];
            n = 0;
            it = list.iterator();
            while (it.hasNext()) {
                String string3;
                str[n] = string3 = it.next().toString();
                ++n;
            }
        }
        int l = str.length;
        this.keysArray = new String[l][l];
        this.patternsArray = new Pattern[l][l];
        this.lengthSourceSegmentClean = this.sourceSegmentKey.length();
        for (i = 0; i < str.length; ++i) {
            this.keysArray[i][0] = comp = str[i];
            this.patternsArray[i][0] = this.matchType == 2 || str.length == 1 || this.userBreakIteratorTokenizer ? (!this.caseMatch ? Pattern.compile(comp, 18) : Pattern.compile(comp, 16)) : (!this.caseMatch ? Pattern.compile(XMLHelper.quote(comp), 2) : Pattern.compile(XMLHelper.quote(comp)));
            for (int j = i + 1; j < str.length; ++j) {
                this.keysArray[i][j] = comp = comp + this.wordSeparator + str[j];
                this.patternsArray[i][j] = !this.caseMatch ? Pattern.compile(comp, 18) : Pattern.compile(comp, 16);
            }
        }
    }

    private String[] breakSegmentIntoWords(String segment) {
        ArrayList<String> matchList = new ArrayList<String>();
        BreakIterator boundary = BreakIterator.getWordInstance(this.srcLocale);
        boundary.setText(segment);
        int wordBoundaryIndex = boundary.first();
        int prevIndex = 0;
        while (wordBoundaryIndex != -1) {
            String word = segment.substring(prevIndex, wordBoundaryIndex);
            if (word.length() > 0) {
                matchList.add(word);
            }
            prevIndex = wordBoundaryIndex;
            wordBoundaryIndex = boundary.next();
        }
        int resultSize = matchList.size();
        String[] arr = new String[resultSize];
        return matchList.toArray(arr);
    }

    public synchronized void analyse(String sent, XMLElement unit) {
        if (unit != null) {
            if (unit instanceof XLIFFUnit) {
                this.currentXliffUnit = (XLIFFUnit)unit;
            } else if (unit instanceof TTXUnit) {
                this.currentTTXUnit = (TTXUnit)unit;
            }
        }
        this.fullSegment = sent;
        this.segLength = this.fullSegment.length();
        this.stats.totalLength += (float)this.segLength;
        sent = sent.replaceAll(AppPreferences.punctuation, "");
        sent = sent.trim();
        sent = XMLHelper.normalizeSpace(sent);
        this.cleanSegment = sent = sent.replaceAll("\\s+", " ");
        this.makeSourceElements();
        this.sLang = this.tumap.getSourceLang();
        this.tLang = this.tumap.getTargetLang();
        this.fuzzies = new HashMap();
        this.bestFuzzies = new LinkedHashMap();
        ++this.stats.total;
        this.wordCount.reset();
        if (!this.hasExactMatch()) {
            this.findBestFuzzies();
        }
    }

    public synchronized TranslationUnit getExactMatchTU(String source) {
        source = source.replaceAll(AppPreferences.punctuation, "");
        source = source.trim();
        source = XMLHelper.normalizeSpace(source);
        if (this.tumap.getMatch(source = source.replaceAll("\\s+", " ")) != null) {
            TranslationUnit tu = this.tumap.getCurrentTU();
            return tu;
        }
        return null;
    }

    public synchronized TMXResult translateExact(String fullSentence, String cleanSentence, XMLElement unit) {
        if (unit != null) {
            if (unit instanceof XLIFFUnit) {
                this.currentXliffUnit = (XLIFFUnit)unit;
            } else if (unit instanceof TTXUnit) {
                this.currentTTXUnit = (TTXUnit)unit;
            }
        }
        this.fullSegment = fullSentence;
        this.segLength = this.fullSegment.length();
        this.stats.totalLength += (float)this.segLength;
        this.cleanSegment = cleanSentence;
        this.makeSourceElements();
        this.sLang = this.tumap.getSourceLang();
        this.tLang = this.tumap.getTargetLang();
        this.results = new TMXResult(this.sLang, this.tLang, this.priority, this.memory.getName());
        this.results.setCurrentSourceSegment(this.fullSegment);
        if (this.compareTargets) {
            String t;
            if (this.currentXliffUnit != null) {
                String t2 = this.currentXliffUnit.getTargetText();
                if (t2.trim().length() > 0) {
                    this.results.setCurrentTargetSegment(t2);
                }
            } else if (this.currentTTXUnit != null && (t = this.currentTTXUnit.getTargetText()).trim().length() > 0) {
                this.results.setCurrentTargetSegment(t);
            }
        }
        this.running = true;
        ++this.stats.total;
        this.exactMemory();
        return this.results;
    }

    public synchronized TMXResult translate(String sentence, String cleanSentence, XMLElement unit, boolean pretranslation) {
        this.results = this.getFromCache(cleanSentence);
        String t = null;
        if (unit != null) {
            if (unit instanceof XLIFFUnit) {
                this.currentXliffUnit = (XLIFFUnit)unit;
                if (this.compareTargets) {
                    t = this.currentXliffUnit.getTargetText();
                }
            } else if (unit instanceof TTXUnit) {
                this.currentTTXUnit = (TTXUnit)unit;
                if (this.compareTargets) {
                    t = this.currentTTXUnit.getTargetText();
                }
            }
        }
        if (this.results != null) {
            if (t == null) {
                return this.results;
            }
            String tt = this.results.getCurrentTargetSegment();
            if (tt == null) {
                return this.results;
            }
            if (t.equals(tt)) {
                return this.results;
            }
        }
        this.fullSegment = sentence;
        this.segLength = this.fullSegment.length();
        this.stats.totalLength += (float)this.segLength;
        this.cleanSegment = cleanSentence;
        this.makeSourceElements();
        this.fuzzies = new HashMap();
        this.bestFuzzies = new LinkedHashMap();
        this.sLang = this.tumap.getSourceLang();
        this.tLang = this.tumap.getTargetLang();
        this.results = new TMXResult(this.sLang, this.tLang, this.priority, this.memory.getName());
        this.results.setCurrentSourceSegment(this.fullSegment);
        if (t != null && t.trim().length() > 0) {
            this.results.setCurrentTargetSegment(t);
        }
        this.running = true;
        ++this.stats.total;
        if (this.exactMemory()) {
            if (!this.memory.isGreedyMatching() && this.keysArray.length > 1) {
                this.fuzzyMemory();
            }
            this.cache.put(this.cleanSegment, this.results);
        } else {
            this.fuzzyMemory();
            if (pretranslation) {
                this.cache.put(this.cleanSegment, this.results);
            }
        }
        return this.results;
    }

    public void stop() {
        this.running = false;
    }

    public String cleanSegment(String segment) {
        String cs = segment.replaceAll(AppPreferences.punctuation, "");
        cs = cs.trim();
        cs = XMLHelper.normalizeSpace(cs);
        cs = cs.replaceAll("\\s+", " ");
        return cs;
    }

    private void findEntry(int sindex, int nindex) {
        this.step = 1.0f;
        this.found = this.shortTermMemory(sindex, nindex) || this.virtualMemory(sindex, nindex) || this.longTermMemory(sindex, nindex) ? true : (nindex == 0 && AppPreferences.wordStemMemoryLookup ? this.stemMatch(sindex, nindex) : false);
        this.findNextEntry(sindex);
    }

    private void findNextEntry(int sindex) {
        int off = 0;
        if (this.results.getContextPercent() > 99 && sindex == 0) {
            off = 1;
        }
        for (int nindex = sindex + 1; nindex < this.keysArray.length - off; ++nindex) {
            this.step += 1.0f;
            if (!this.shortTermMemory(sindex, nindex) && !this.virtualMemory(sindex, nindex) && !this.longTermMemory(sindex, nindex)) continue;
            this.index = nindex;
            this.found = true;
        }
    }

    private void findExactEntry(int sindex, int nindex) {
        this.step = 1.0f;
        this.found = this.shortTermMemory(sindex, nindex);
        this.findNextExactEntry(sindex);
    }

    private void findNextExactEntry(int sindex) {
        int off = 0;
        if (this.results.getContextPercent() > 99 && sindex == 0) {
            off = 1;
        }
        for (int nindex = sindex + 1; nindex < this.keysArray.length - off; ++nindex) {
            this.step += 1.0f;
            if (!this.shortTermMemory(sindex, nindex)) continue;
            this.index = nindex;
            this.found = true;
        }
    }

    private boolean virtualMemory(int sindex, int nindex) {
        String fragment = this.keysArray[sindex][nindex];
        String e = this.tumap.getVirtualMatch(fragment);
        if (e != null) {
            int len;
            char c;
            if (e.length() > 0 && ((c = e.charAt(len = e.length() - 1)) == '.' || c == '!' || c == '?' || c == '\u3002')) {
                e = e.substring(0, len);
            }
            String frag = this.prefMatch ? this.fullkeysArray[sindex][nindex] : fragment;
            this.results.setVirtualMatch(frag, e);
            return true;
        }
        return false;
    }

    private boolean stemMatch(int sindex, int nindex) {
        List stems;
        String s = this.prefMatch ? this.fullkeysArray[sindex][nindex] : this.keysArray[sindex][nindex];
        String s2 = XMLHelper.normalizeApostrophe(s);
        HunSpellChecker sp = MainClass.getMainView().getSpellChecker();
        if (sp != null && sp.hasSourceDictionary() && (stems = sp.getStems(s2)) != null) {
            for (String next : stems) {
                String e;
                if (next.equals(s2) || (e = this.tumap.getMatch(next)) == null || e.length() <= 0) continue;
                this.results.setVirtualMatch(s, e);
                return true;
            }
        }
        return false;
    }

    private boolean hasExactMatch() {
        if (this.tumap.getMatch(this.sourceSegmentKey) != null) {
            DefaultXMLElement xu;
            boolean hasContext = false;
            TranslationUnit tu = this.tumap.getCurrentTU();
            String[] cx = null;
            if (this.currentXliffUnit != null) {
                cx = new String[2];
                xu = this.currentXliffUnit.getPreviousTranslationUnit();
                if (xu != null) {
                    cx[0] = ((XLIFFUnit)xu).getSourceText();
                }
                if ((xu = this.currentXliffUnit.getNextTranslationUnit()) != null) {
                    cx[1] = ((XLIFFUnit)xu).getSourceText();
                }
            } else if (this.currentTTXUnit != null) {
                cx = new String[2];
                xu = this.currentTTXUnit.getPreviousTranslationUnit();
                if (xu != null) {
                    cx[0] = ((TTXUnit)xu).getSourceText();
                }
                if ((xu = this.currentTTXUnit.getNextTranslationUnit()) != null) {
                    cx[1] = ((TTXUnit)xu).getSourceText();
                }
            }
            if (cx != null) {
                int contextPercent = 0;
                do {
                    String s1;
                    TranslationUnit unit;
                    int contextMatch = 0;
                    String c1 = cx[0];
                    if (c1 != null && c1.length() > 0 && (unit = tu.getPreviousTranslationUnit()) != null && c1.equals(s1 = unit.getSegment(this.sLang))) {
                        ++contextMatch;
                        if (contextPercent == 0) {
                            contextPercent = 50;
                        }
                        if (cx[1] == null) {
                            ++contextMatch;
                            contextPercent = 100;
                            hasContext = true;
                        }
                    }
                    if ((c1 = cx[1]) == null || c1.length() <= 0 || (unit = tu.getNextTranslationUnit()) == null || !c1.equals(s1 = unit.getSegment(this.sLang))) continue;
                    ++contextMatch;
                    if (cx[0] == null) {
                        ++contextMatch;
                        contextPercent = 100;
                        hasContext = true;
                        continue;
                    }
                    if (contextPercent == 0) {
                        contextPercent = 50;
                        continue;
                    }
                    if (contextPercent != 50 || contextMatch != 2) continue;
                    contextPercent = 100;
                    hasContext = true;
                } while ((tu = tu.getLink()) != null);
            }
            if (!hasContext) {
                ++this.stats.exact;
                this.stats.exactL += (float)this.segLength;
                this.wordCount.doWordCount(this.fullSegment);
                this.stats.exactW += this.wordCount.getWordCount();
            } else {
                ++this.stats.context;
                this.stats.contextL += (float)this.segLength;
                this.wordCount.doWordCount(this.fullSegment);
                this.stats.contextW += this.wordCount.getWordCount();
            }
            return true;
        }
        return false;
    }

    private boolean exactMemory() {
        if (this.tumap.getMatch(this.sourceSegmentKey) != null) {
            boolean hasContext = false;
            TranslationUnit tu = this.tumap.getCurrentTU();
            String[] cx = new String[2];
            if (this.currentXliffUnit != null) {
                XLIFFUnit xu = this.currentXliffUnit.getPreviousTranslationUnit();
                if (xu != null) {
                    cx[0] = xu.getSourceText();
                }
                if ((xu = this.currentXliffUnit.getNextTranslationUnit()) != null) {
                    cx[1] = xu.getSourceText();
                }
                hasContext = this.results.setExactMatch(tu, true, cx, this.caseMatch, null, this.prefMatch);
            } else if (this.currentTTXUnit != null) {
                TTXUnit xu = this.currentTTXUnit.getPreviousTranslationUnit();
                if (xu != null) {
                    cx[0] = xu.getSourceText();
                }
                if ((xu = this.currentTTXUnit.getNextTranslationUnit()) != null) {
                    cx[1] = xu.getSourceText();
                }
                hasContext = this.results.setExactMatch(tu, true, cx, this.caseMatch, null, this.prefMatch);
            } else {
                this.results.setExactMatch(tu, true, cx, this.caseMatch, null, this.prefMatch);
            }
            if (!hasContext) {
                ++this.stats.exact;
                this.stats.exactL += (float)this.segLength;
            } else {
                ++this.stats.context;
                this.stats.contextL += (float)this.segLength;
            }
            return true;
        }
        return false;
    }

    private void fuzzyMemory() {
        this.findBestFuzzies();
        this.results.setBestFuzzies(this.bestFuzzies);
        if (this.matchType == 0) {
            this.index = 0;
            while (this.index < this.keysArray.length && this.running) {
                this.findEntry(this.index, 0);
                ++this.index;
            }
        } else {
            this.index = 0;
            while (this.index < this.keysArray.length && this.running) {
                this.findExactEntry(this.index, 0);
                ++this.index;
            }
        }
    }

    private boolean shortTermMemory(int sindex, int nindex) {
        String frag;
        String fragment = this.keysArray[sindex][nindex];
        if (this.tumap.getMatch(fragment) != null) {
            String frag2 = this.prefMatch ? this.fullkeysArray[sindex][nindex] : fragment;
            this.results.setExactMatch(this.tumap.getCurrentTU(), false, null, this.caseMatch, frag2, this.prefMatch);
            return true;
        }
        if (this.prefMatch && nindex == 0 && this.tumap.getMatchforRoot(frag = this.fullkeysArray[sindex][nindex]) != null) {
            this.results.setExactMatch(this.tumap.getCurrentTU(), false, null, this.caseMatch, frag, this.prefMatch);
            return true;
        }
        return false;
    }

    private void getBestMatch(String entry, boolean context, boolean fuzzyContext, int keyLength) {
        String[] full;
        String[] str;
        if (this.userBreakIteratorTokenizer) {
            str = this.breakSegmentIntoWords(entry);
            full = str;
        } else {
            full = this.matchPattern2.split(entry);
            str = this.makeTargetPrefixes(full);
        }
        HashSet<String> dup = new HashSet<String>();
        for (int m = 0; m < str.length; ++m) {
            String prefWord = str[m];
            if (prefWord.length() == 0) continue;
            String word = full[m];
            if (!dup.contains(prefWord)) {
                int comLength;
                int percent;
                dup.add(prefWord);
                Object o = this.hm.get(prefWord);
                if (o != null) {
                    Object[] arr = (Object[])o;
                    int k = (Integer)arr[0] + 1;
                    arr[0] = k;
                    boolean ctx = (Boolean)arr[1];
                    if (context) {
                        arr[1] = context;
                        ctx = context;
                    }
                    if (!prefWord.equals(this.bestMatch)) {
                        int len2;
                        int d2;
                        int d1;
                        int len1;
                        if (fuzzyContext && k >= this.occur && this.results.isFragmentInBestFuzzyMatchTarget(prefWord) && this.bestMatch.indexOf(prefWord) == -1) {
                            boolean b = this.results.isFragmentInBestFuzzyMatchTarget(this.bestMatch);
                            if (!b) {
                                this.hm.remove(this.bestMatch);
                                this.bestMatch = prefWord;
                                this.bestMatchFull = word;
                                this.occur = k;
                                if (k >= AppPreferences.hitInContextToAutoThreshold && ctx) {
                                    this.withContext = ctx;
                                }
                            } else {
                                int len22;
                                int d22;
                                int len12 = word.length();
                                int d12 = len12 > keyLength ? len12 - keyLength : keyLength - len12;
                                if (d12 < (d22 = (len22 = this.bestMatchFull.length()) > keyLength ? len22 - keyLength : keyLength - len22)) {
                                    this.hm.remove(this.bestMatch);
                                    this.bestMatch = prefWord;
                                    this.bestMatchFull = word;
                                    this.occur = k;
                                    if (k >= AppPreferences.hitInContextToAutoThreshold && ctx) {
                                        this.withContext = ctx;
                                    }
                                }
                            }
                        } else if (k == this.occur) {
                            if (ctx == this.withContext) {
                                len1 = word.length();
                                d1 = len1 > keyLength ? len1 - keyLength : keyLength - len1;
                                if (d1 < (d2 = (len2 = this.bestMatchFull.length()) > keyLength ? len2 - keyLength : keyLength - len2)) {
                                    this.bestMatch = prefWord;
                                    this.bestMatchFull = word;
                                }
                            } else if (ctx) {
                                this.bestMatch = prefWord;
                                this.bestMatchFull = word;
                            }
                            if (k >= AppPreferences.hitInContextToAutoThreshold && ctx) {
                                this.withContext = ctx;
                            }
                        } else if (k > this.occur) {
                            if (this.bestMatch.indexOf(prefWord) != -1) {
                                len1 = word.length();
                                d1 = len1 > keyLength ? len1 - keyLength : keyLength - len1;
                                if (d1 < (d2 = (len2 = this.bestMatchFull.length()) > keyLength ? len2 - keyLength : keyLength - len2)) {
                                    this.hm.remove(this.bestMatch);
                                    this.bestMatch = prefWord;
                                    this.bestMatchFull = word;
                                    this.occur = k;
                                } else {
                                    arr[0] = k - 1;
                                }
                            } else {
                                this.bestMatch = prefWord;
                                this.bestMatchFull = word;
                                this.occur = k;
                            }
                            if (k >= AppPreferences.hitInContextToAutoThreshold && ctx) {
                                this.withContext = ctx;
                            }
                        }
                    }
                } else if (!this.functionTargetWords.contains(word) && (word.length() > 3 || AppPreferences.noWordSeparatorTargetLanguage) && (percent = keyLength > (comLength = word.length()) ? comLength * 100 / keyLength : keyLength * 100 / comLength) > AppPreferences.phraseMinLengthDifference) {
                    Object[] arr = new Object[]{1, context};
                    this.hm.put(prefWord, arr);
                    if (this.occur == 0) {
                        this.occur = 1;
                    }
                }
            }
            StringBuilder buff = new StringBuilder(prefWord);
            StringBuilder buff2 = new StringBuilder(word);
            for (int j = m + 1; j < str.length; ++j) {
                int comLength;
                int percent;
                buff.append(this.wordSeparator);
                buff.append(str[j]);
                String prefWordNext = buff.toString();
                buff2.append(this.wordSeparator);
                buff2.append(full[j]);
                String sub2 = buff2.toString();
                if (dup.contains(prefWordNext)) continue;
                dup.add(prefWordNext);
                Object o = this.hm.get(prefWordNext);
                if (o != null) {
                    int len2;
                    int d2;
                    int d1;
                    int len1;
                    Object[] arr = (Object[])o;
                    int k = (Integer)arr[0] + 1;
                    arr[0] = k;
                    boolean ctx = (Boolean)arr[1];
                    if (context) {
                        arr[1] = context;
                        ctx = context;
                    }
                    if (prefWordNext.equals(this.bestMatch)) continue;
                    if (fuzzyContext && k >= this.occur && this.results.isFragmentInBestFuzzyMatchTarget(sub2) && this.bestMatch.indexOf(prefWordNext) == -1) {
                        boolean b = this.results.isFragmentInBestFuzzyMatchTarget(this.bestMatchFull);
                        if (!b) {
                            this.hm.remove(this.bestMatch);
                            this.bestMatch = prefWordNext;
                            this.bestMatchFull = sub2;
                            this.occur = k;
                            if (k >= AppPreferences.hitInContextToAutoThreshold && ctx) {
                                this.withContext = ctx;
                            }
                        } else {
                            int len23;
                            int d23;
                            int len13 = sub2.length();
                            int d13 = len13 > keyLength ? len13 - keyLength : keyLength - len13;
                            if (d13 < (d23 = (len23 = this.bestMatchFull.length()) > keyLength ? len23 - keyLength : keyLength - len23)) {
                                this.hm.remove(this.bestMatch);
                                this.bestMatch = prefWordNext;
                                this.bestMatchFull = sub2;
                                this.occur = k;
                            }
                        }
                        m = str.length;
                        continue;
                    }
                    if (k == this.occur) {
                        if (prefWordNext.indexOf(this.bestMatch) != -1) {
                            if (k > 4) {
                                this.hm.remove(this.bestMatch);
                            }
                            this.bestMatch = prefWordNext;
                            this.bestMatchFull = sub2;
                        } else if (ctx == this.withContext && this.bestMatch.indexOf(prefWordNext) == -1) {
                            len1 = sub2.length();
                            d1 = len1 > keyLength ? len1 - keyLength : keyLength - len1;
                            if (d1 < (d2 = (len2 = this.bestMatchFull.length()) > keyLength ? len2 - keyLength : keyLength - len2)) {
                                this.bestMatch = prefWordNext;
                                this.bestMatchFull = sub2;
                            } else {
                                arr[0] = k - 1;
                            }
                        } else if (ctx) {
                            this.bestMatch = prefWordNext;
                            this.bestMatchFull = sub2;
                        }
                        if (k < AppPreferences.hitInContextToAutoThreshold || !ctx) continue;
                        this.withContext = ctx;
                        continue;
                    }
                    if (k <= this.occur) continue;
                    if (prefWordNext.indexOf(this.bestMatch) != -1 && k > 4) {
                        this.hm.remove(this.bestMatch);
                    }
                    if (this.bestMatch.indexOf(prefWordNext) != -1) {
                        len1 = sub2.length();
                        d1 = len1 > keyLength ? len1 - keyLength : keyLength - len1;
                        if (d1 < (d2 = (len2 = this.bestMatchFull.length()) > keyLength ? len2 - keyLength : keyLength - len2)) {
                            this.hm.remove(this.bestMatch);
                            this.bestMatch = prefWordNext;
                            this.bestMatchFull = sub2;
                            this.occur = k;
                        } else {
                            arr[0] = k - 1;
                        }
                    } else {
                        this.bestMatch = prefWordNext;
                        this.bestMatchFull = sub2;
                        this.occur = k;
                    }
                    if (k < AppPreferences.hitInContextToAutoThreshold || !ctx) continue;
                    this.withContext = ctx;
                    continue;
                }
                if (this.functionTargetWords.contains(sub2) || (percent = keyLength > (comLength = sub2.length()) ? comLength * 100 / keyLength : keyLength * 100 / comLength) <= AppPreferences.phraseMinLengthDifference) continue;
                Object[] arr = new Object[]{1, context};
                this.hm.put(prefWordNext, arr);
                if (this.occur != 0) continue;
                this.occur = 1;
            }
        }
        if (this.occur < 2 && !this.withContext) {
            this.bestMatch = entry;
            this.bestMatchFull = entry;
        }
    }

    private void lookUpFuzziesOld(int sindex, int nindex) {
        Pattern pat = this.patternsArray[sindex][nindex];
        String token = this.keysArray[sindex][nindex];
        if (sindex == 0) {
            this.pointer = 0;
        }
        Iterator keys = this.tuset.iterator();
        block0: while (keys.hasNext()) {
            String fullKey = keys.next().toString();
            Matcher m = pat.matcher(fullKey);
            while (m.find()) {
                Object matrix;
                int len;
                Object[] arr;
                int kindex = this.pointer;
                Object o = this.fuzzies.get(fullKey);
                if (o != null) {
                    arr = (Object[])o;
                    Integer oi = (Integer)arr[0];
                    int oind = oi;
                    int tlen = token.length();
                    len = oind + tlen + this.wordSeparator.length();
                    matrix = (int[][])arr[1];
                    if (matrix[kindex] != null) {
                        int le = matrix[kindex].length;
                        if (tlen == le) continue;
                        if (tlen > le) {
                            matrix[kindex] = new int[tlen];
                            arr[1] = matrix;
                        }
                    } else {
                        matrix[kindex] = new int[tlen];
                        arr[1] = matrix;
                    }
                    arr[0] = len;
                    this.fuzzies.put(fullKey, arr);
                } else {
                    len = token.length();
                    arr = new Object[2];
                    arr[0] = len;
                    matrix = new int[this.lengthSourceSegmentClean][];
                    matrix[kindex] = new int[len];
                    arr[1] = matrix;
                    this.fuzzies.put(fullKey, arr);
                }
                int pro = this.lengthSourceSegmentClean > fullKey.length() ? len * 100 / this.lengthSourceSegmentClean : len * 100 / fullKey.length();
                if (pro >= AppPreferences.bestMatch) {
                    String fullEntry;
                    if (pro >= 100) {
                        pro = 99;
                    }
                    if ((fullEntry = this.tumap.getMatch(fullKey)) != null) {
                        Object[] ob = new Object[6];
                        ob[0] = pro;
                        if (this.lengthSourceSegmentClean >= fullKey.length()) {
                            ob[1] = this.cleanSegment;
                        } else {
                            int h = fullKey.indexOf(this.cleanSegment);
                            if (h != -1) {
                                matrix = new int[fullKey.length()][];
                                matrix[h] = new int[this.cleanSegment.length()];
                                ob[1] = fullKey;
                            } else {
                                ob[1] = this.cleanSegment;
                            }
                        }
                        ob[2] = fullEntry;
                        ob[3] = matrix;
                        ob[4] = this.prefMatch ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        TranslationUnit tu = this.tumap.getCurrentTU();
                        ob[5] = tu;
                        this.bestFuzzies.put(fullEntry, ob);
                    }
                }
                if (pro <= this.fstats) continue block0;
                this.fstats = pro;
                continue block0;
            }
        }
        this.pointer += token.length() + this.wordSeparator.length();
    }

    private void lookUpFuzzies(int sindex, int nindex) {
        Pattern pat = this.patternsArray[sindex][nindex];
        String token = this.keysArray[sindex][nindex];
        int tokenLen = token.length();
        if (sindex == 0) {
            this.pointer = 0;
            this.previousPointer = 0;
        }
        int p = this.pointer;
        int pp = this.previousPointer;
        this.previousPointer = this.pointer;
        this.pointer += token.length() + this.wordSeparator.length();
        if (tokenLen > 0) {
            int count = 0;
            boolean isStopWord = StopWords.isStopWord(token);
            Iterator keys = this.tuset.iterator();
            block0: while (keys.hasNext()) {
                String fullKey = keys.next().toString();
                Matcher m = pat.matcher(fullKey);
                int k = 0;
                while (m.find()) {
                    int matchedLengthCurrentSegment;
                    int matchedLengthFuzzyMatch;
                    Object matrixCurrentSegment;
                    Object matrixFuzzyMatch;
                    Object[] arr;
                    ++k;
                    if (count < AppPreferences.subsegmentLimit && !isStopWord) {
                        ++count;
                        this.activeKeys.add(fullKey);
                    }
                    int indexCurrentSegment = p;
                    int indexFuzzyMatch = m.start();
                    boolean inOrder = true;
                    Object o = this.fuzzies.get(fullKey);
                    if (o != null) {
                        arr = (Object[])o;
                        Integer oi = (Integer)arr[0];
                        int oind = oi;
                        Integer oi2 = (Integer)arr[1];
                        int oind2 = oi2;
                        matrixFuzzyMatch = (int[][])arr[2];
                        matrixCurrentSegment = (int[][])arr[3];
                        int lastIndexFuzzyMatch = (Integer)arr[4];
                        int lastIndexCurrentSegment = (Integer)arr[5];
                        matchedLengthFuzzyMatch = indexFuzzyMatch > lastIndexFuzzyMatch ? oind + tokenLen + this.wordSeparator.length() : (matrixFuzzyMatch[indexFuzzyMatch] == null && k == 1 ? oind + tokenLen / 2 + this.wordSeparator.length() : oind);
                        matchedLengthCurrentSegment = indexCurrentSegment > lastIndexCurrentSegment ? oind2 + tokenLen + this.wordSeparator.length() : oind2;
                        if (indexFuzzyMatch < lastIndexFuzzyMatch) {
                            inOrder = false;
                        }
                        if (inOrder) {
                            if (matrixFuzzyMatch[indexFuzzyMatch] != null) {
                                int le = matrixFuzzyMatch[indexFuzzyMatch].length;
                                if (tokenLen == le) continue block0;
                                if (tokenLen > le) {
                                    matrixFuzzyMatch[indexFuzzyMatch] = new int[tokenLen];
                                    arr[2] = matrixFuzzyMatch;
                                    arr[0] = matchedLengthFuzzyMatch;
                                }
                            } else {
                                matrixFuzzyMatch[indexFuzzyMatch] = new int[tokenLen];
                                arr[2] = matrixFuzzyMatch;
                                arr[0] = matchedLengthFuzzyMatch;
                                arr[4] = indexFuzzyMatch;
                            }
                            if (matrixCurrentSegment[indexCurrentSegment] != null) {
                                int le2 = matrixCurrentSegment[indexCurrentSegment].length;
                                if (tokenLen > le2) {
                                    matrixCurrentSegment[indexCurrentSegment] = new int[tokenLen];
                                    arr[3] = matrixCurrentSegment;
                                    arr[1] = matchedLengthCurrentSegment;
                                }
                            } else {
                                matrixCurrentSegment[indexCurrentSegment] = new int[tokenLen];
                                arr[3] = matrixCurrentSegment;
                                arr[1] = matchedLengthCurrentSegment;
                                arr[5] = indexCurrentSegment;
                            }
                        } else {
                            arr[0] = matchedLengthFuzzyMatch;
                            arr[1] = matchedLengthCurrentSegment;
                        }
                    } else {
                        matchedLengthFuzzyMatch = tokenLen;
                        matchedLengthCurrentSegment = tokenLen;
                        arr = new Object[6];
                        arr[0] = matchedLengthFuzzyMatch;
                        arr[1] = matchedLengthCurrentSegment;
                        matrixFuzzyMatch = new int[fullKey.length()][];
                        matrixCurrentSegment = new int[this.cleanSegment.length()][];
                        int[] pos1 = new int[matchedLengthFuzzyMatch];
                        int[] pos2 = new int[matchedLengthCurrentSegment];
                        matrixFuzzyMatch[indexFuzzyMatch] = pos1;
                        matrixCurrentSegment[indexCurrentSegment] = pos2;
                        arr[2] = matrixFuzzyMatch;
                        arr[3] = matrixCurrentSegment;
                        arr[4] = indexFuzzyMatch;
                        arr[5] = indexCurrentSegment;
                        this.fuzzies.put(fullKey, arr);
                    }
                    int pro = this.lengthSourceSegmentClean > fullKey.length() ? matchedLengthFuzzyMatch * 100 / this.lengthSourceSegmentClean : matchedLengthFuzzyMatch * 100 / fullKey.length();
                    if (pro >= AppPreferences.bestMatch) {
                        String fullEntry;
                        boolean ex = false;
                        if (pro >= 100) {
                            pro = 99;
                            ex = true;
                        }
                        if ((fullEntry = this.tumap.getMatch(fullKey)) != null) {
                            int h;
                            if (ex && this.results.getContextPercent() > 99) {
                                this.bestFuzzies.remove(fullEntry);
                                continue block0;
                            }
                            Object[] ob = new Object[14];
                            ob[0] = pro;
                            ob[1] = fullKey;
                            ob[6] = this.cleanSegment;
                            if (this.lengthSourceSegmentClean < fullKey.length()) {
                                h = fullKey.indexOf(this.cleanSegment);
                                if (h != -1) {
                                    matrixFuzzyMatch = new int[fullKey.length()][];
                                    matrixFuzzyMatch[h] = new int[this.cleanSegment.length()];
                                }
                            } else {
                                h = this.cleanSegment.indexOf(fullKey);
                                if (h != -1) {
                                    matrixCurrentSegment = new int[this.cleanSegment.length()][];
                                    matrixCurrentSegment[h] = new int[fullKey.length()];
                                }
                            }
                            ob[2] = fullEntry;
                            ob[3] = matrixFuzzyMatch;
                            ob[4] = false;
                            TranslationUnit tu = this.tumap.getCurrentTU();
                            ob[5] = tu;
                            ob[7] = matrixCurrentSegment;
                            ob[8] = this.memory.getName();
                            ob[13] = false;
                            this.bestFuzzies.put(fullEntry, ob);
                        }
                    }
                    if (pro > this.fstats) {
                        this.fstats = pro;
                    }
                    if (!inOrder) continue;
                    continue block0;
                }
            }
        }
    }

    private void lookUpFuzziesPrefixes(int sindex, int nindex) {
        Pattern pat = this.patternsArray[sindex][nindex];
        String token = this.keysArray[sindex][nindex];
        String fulltoken = this.fullkeysArray[sindex][nindex];
        if (sindex == 0) {
            this.pointer = 0;
            this.previousPointer = 0;
        }
        int count = 0;
        boolean isStopWord = StopWords.isStopWord(fulltoken);
        Iterator keys = this.tuset.iterator();
        block0: while (keys.hasNext()) {
            String fullKey = keys.next().toString();
            Matcher m = pat.matcher(fullKey);
            while (m.find()) {
                Object matrixCurrentSegment;
                int matchedLengthCurrentSegment;
                Object matrixFuzzyMatch;
                int matchedLengthFuzzyMatch;
                Object[] arr;
                if (count < AppPreferences.subsegmentLimit && !isStopWord) {
                    ++count;
                    this.activeKeys.add(fullKey);
                }
                int indexCurrentSegment = this.pointer;
                int indexFuzzyMatch = m.start();
                Object o = this.fuzzies.get(fullKey);
                if (o != null) {
                    arr = (Object[])o;
                    int lastIndex = (Integer)arr[4];
                    int lastIndex2 = (Integer)arr[5];
                    Integer oi = (Integer)arr[0];
                    int oind = oi;
                    int tlen = token.length();
                    matchedLengthFuzzyMatch = indexFuzzyMatch > lastIndex ? oind + tlen + this.wordSeparator.length() : (lastIndex2 == this.previousPointer ? oind + tlen / 2 + this.wordSeparator.length() : oind);
                    matrixFuzzyMatch = (int[][])arr[2];
                    if (matrixFuzzyMatch[indexFuzzyMatch] != null) {
                        int le = matrixFuzzyMatch[indexFuzzyMatch].length;
                        if (tlen == le) continue;
                        if (tlen > le) {
                            matrixFuzzyMatch[indexFuzzyMatch] = new int[tlen];
                            arr[2] = matrixFuzzyMatch;
                            arr[0] = matchedLengthFuzzyMatch;
                        }
                    } else {
                        matrixFuzzyMatch[indexFuzzyMatch] = new int[tlen];
                        arr[2] = matrixFuzzyMatch;
                        arr[0] = matchedLengthFuzzyMatch;
                        if (lastIndex2 != this.previousPointer || indexFuzzyMatch > lastIndex) {
                            arr[4] = indexFuzzyMatch;
                        }
                    }
                    Integer oi2 = (Integer)arr[1];
                    int oind2 = oi2;
                    int tlen2 = fulltoken.length();
                    matchedLengthCurrentSegment = indexCurrentSegment > lastIndex2 ? oind2 + tlen2 + this.wordSeparator.length() : oind2;
                    matrixCurrentSegment = (int[][])arr[3];
                    if (matrixCurrentSegment[indexCurrentSegment] != null) {
                        int le2 = matrixCurrentSegment[indexCurrentSegment].length;
                        if (tlen2 > le2) {
                            matrixCurrentSegment[indexCurrentSegment] = new int[tlen2];
                            arr[3] = matrixCurrentSegment;
                            arr[1] = matchedLengthCurrentSegment;
                        }
                    } else {
                        matrixCurrentSegment[indexCurrentSegment] = new int[tlen2];
                        arr[3] = matrixCurrentSegment;
                        arr[1] = matchedLengthCurrentSegment;
                        arr[5] = indexCurrentSegment;
                    }
                } else {
                    matchedLengthFuzzyMatch = token.length();
                    matchedLengthCurrentSegment = fulltoken.length();
                    arr = new Object[6];
                    arr[0] = matchedLengthFuzzyMatch;
                    arr[1] = matchedLengthCurrentSegment;
                    matrixCurrentSegment = new int[this.cleanSegment.length()][];
                    matrixFuzzyMatch = new int[fullKey.length()][];
                    matrixFuzzyMatch[indexFuzzyMatch] = new int[matchedLengthFuzzyMatch];
                    matrixCurrentSegment[indexCurrentSegment] = new int[matchedLengthCurrentSegment];
                    arr[2] = matrixFuzzyMatch;
                    arr[3] = matrixCurrentSegment;
                    arr[4] = indexFuzzyMatch;
                    arr[5] = indexCurrentSegment;
                    this.fuzzies.put(fullKey, arr);
                }
                int pro = this.lengthSourceSegmentClean > fullKey.length() ? matchedLengthFuzzyMatch * 100 / this.lengthSourceSegmentClean : matchedLengthFuzzyMatch * 100 / fullKey.length();
                if (pro >= AppPreferences.bestMatch) {
                    String fullEntry;
                    boolean ex = false;
                    if (pro >= 100) {
                        pro = 99;
                        ex = true;
                    }
                    if ((fullEntry = this.tumap.getMatch(fullKey)) != null) {
                        if (ex && this.results.getContextPercent() > 99) {
                            this.bestFuzzies.remove(fullEntry);
                            continue block0;
                        }
                        Object[] ob = new Object[14];
                        ob[0] = pro;
                        ob[1] = fullKey;
                        ob[2] = fullEntry;
                        ob[3] = matrixFuzzyMatch;
                        ob[4] = true;
                        TranslationUnit tu = this.tumap.getCurrentTU();
                        ob[5] = tu;
                        ob[6] = this.cleanSegment;
                        ob[7] = matrixCurrentSegment;
                        ob[8] = this.memory.getName();
                        ob[13] = false;
                        this.bestFuzzies.put(fullEntry, ob);
                    }
                }
                if (pro <= this.fstats) continue block0;
                this.fstats = pro;
                continue block0;
            }
        }
        this.previousPointer = this.pointer;
        this.pointer += fulltoken.length() + this.wordSeparator.length();
    }

    private void lookUpSet(int sindex, int nindex) {
        int fragmentLength;
        String fragment;
        Pattern pat = this.patternsArray[sindex][nindex];
        if (!this.prefMatch) {
            fragment = this.keysArray[sindex][nindex];
            fragmentLength = fragment.length();
        } else {
            fragment = this.fullkeysArray[sindex][nindex];
            fragmentLength = fragment.length();
        }
        int keycount = 0;
        this.occur = 0;
        this.withContext = false;
        this.bestMatch = "";
        this.bestMatchFull = "";
        this.hm = new HashMap();
        boolean isFuzzyFragment = this.results.isFragmentInBestFuzzyMatchSource(fragment);
        Iterator keys = this.activeKeys.iterator();
        while (keys.hasNext()) {
            int i;
            String fullKey = keys.next().toString();
            Matcher m = pat.matcher(fullKey);
            if (!m.find()) continue;
            boolean context = isFuzzyFragment;
            if (!context && sindex > 0) {
                String token = this.keysArray[sindex - 1][0];
                String pre = fullKey.substring(0, m.start()).trim();
                if (pre.endsWith(token)) {
                    context = true;
                } else if (pre.length() > 0 && token.length() > 0) {
                    char c1 = pre.charAt(pre.length() - 1);
                    char c2 = token.charAt(token.length() - 1);
                    if (Character.isDigit(c1) && Character.isDigit(c2)) {
                        context = true;
                    }
                }
            }
            int keyIndex = sindex + (int)this.step;
            if (!context && keyIndex < this.keysArray.length && (i = m.end()) < fullKey.length()) {
                String token = this.keysArray[keyIndex][0];
                String suf = fullKey.substring(i).trim();
                if (suf.startsWith(token)) {
                    context = true;
                } else if (suf.length() > 0 && token.length() > 0) {
                    char c1 = suf.charAt(0);
                    char c2 = token.charAt(0);
                    if (Character.isDigit(c1) && Character.isDigit(c2)) {
                        context = true;
                    }
                }
            }
            Set all = this.tumap.getMatches(fullKey);
            TranslationUnit tu = this.tumap.getCurrentTU();
            if (tu != null) {
                this.results.setSubsegmentUnit(tu);
            }
            for (String fullEntry : all) {
                this.getBestMatch(fullEntry, context, isFuzzyFragment, fragmentLength);
            }
            if (++keycount != AppPreferences.subsegmentLimit) continue;
            break;
        }
    }

    private boolean longTermMemory(int sindex, int nindex) {
        String token = this.keysArray[sindex][nindex];
        if (token.length() < AppPreferences.subsegmentMinimalLength) {
            return false;
        }
        if (this.functionSourceWords.contains(token)) {
            return false;
        }
        this.lookUpSet(sindex, nindex);
        if (this.occur >= AppPreferences.hitsThreshold) {
            int len;
            char c;
            String subsegment = this.bestMatchFull;
            if (this.occur > AppPreferences.hitToAutoThreshold && ((c = subsegment.charAt(len = subsegment.length() - 1)) == '.' || c == '!' || c == '?' || c == '\u3002')) {
                subsegment = subsegment.substring(0, len);
            }
            if (this.prefMatch) {
                this.results.setSubsegmentMatch(this.occur, this.withContext, this.fullkeysArray[sindex][nindex], subsegment);
            } else {
                this.results.setSubsegmentMatch(this.occur, this.withContext, token, subsegment);
            }
            if (this.occur > AppPreferences.hitToVirtualThreshold) {
                if (this.prefMatch) {
                    this.tumap.setVirtualMatch(this.fullkeysArray[sindex][nindex].trim(), subsegment.trim());
                } else {
                    this.tumap.setVirtualMatch(token.trim(), subsegment.trim());
                }
            }
            if (this.occur > AppPreferences.hitToAutoThreshold || this.withContext) {
                return true;
            }
        } else {
            this.results.clearSubsegmentUnits();
        }
        return false;
    }

    public void setFunctionWords(List source, List target) {
        this.functionSourceWords = source;
        this.functionTargetWords = target;
    }

    public String makePrefixes(String key) {
        int min = AppPreferences.memPrefixLength;
        int proc = AppPreferences.memPrefixAccuracy;
        StringBuilder sb = new StringBuilder();
        String[] arr = key.split(" ");
        for (int i = 0; i < arr.length; ++i) {
            String string = arr[i];
            int[] parr = this.tumap.getPrefixLength(string);
            if (parr != null) {
                int pipe = parr[0];
                int pipe2 = parr[1];
                string = pipe2 != -1 ? string.substring(pipe, pipe2) : string.substring(0, pipe);
            } else {
                int ai = string.indexOf(39);
                if (ai != -1) {
                    String s = string.substring(ai + 1);
                    int len = s.length();
                    if (len >= min) {
                        if (proc == 0) {
                            string = s.substring(0, min);
                        } else {
                            int newlen = len * proc / 100;
                            if (newlen < min) {
                                newlen = min;
                            }
                            string = s.substring(0, newlen);
                        }
                    }
                } else {
                    int len = string.length();
                    if (len >= min) {
                        if (proc == 0) {
                            string = string.substring(0, min);
                        } else {
                            int newlen = len * proc / 100;
                            if (newlen < min) {
                                newlen = min;
                            }
                            string = string.substring(0, newlen);
                        }
                    }
                }
            }
            sb.append(string);
            if (i >= arr.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String[] makeTargetPrefixes(String[] full) {
        String[] pref = new String[full.length];
        int min = 5;
        for (int i = 0; i < full.length; ++i) {
            String string = full[i];
            int len = string.length();
            if (len > min) {
                string = string.substring(0, min);
            }
            pref[i] = string.toLowerCase();
        }
        return pref;
    }
}

