/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SegmentPatternString {
    private String segmentPattern;
    private String source;
    private String target;
    private boolean regularExpression = false;
    private Pattern pattern;
    private String[] positions;
    private String defaultSource;
    private String defaultTarget;
    public static Map sourceFragmentsMap;
    private volatile int hashCode = 0;

    public SegmentPatternString(String source, String target, boolean makePattern, boolean regularExpression) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (makePattern) {
            this.target = target;
            this.regularExpression = regularExpression;
            this.setSourceSegmentPattern(source);
        } else {
            this.source = source;
        }
    }

    public void setSegmentPattern(String s) {
        this.segmentPattern = s;
    }

    public String getSegmentPattern() {
        return this.segmentPattern;
    }

    public boolean equals(Object o) {
        if (o instanceof SegmentPatternString) {
            SegmentPatternString sp = (SegmentPatternString)o;
            Pattern pat = sp.getSourceSegmentPattern();
            if (pat == null) {
                return this.source.equals(sp.toString());
            }
            if (this.pattern != null) {
                return this.source.equals(sp.toString());
            }
            return sp.matchesSourceSegmentPattern(this.source);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.source;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    private void setSourceSegmentPattern(String s) {
        this.positions = new String[20];
        Pattern p = Pattern.compile("\\{\\d+\\}");
        Matcher m = p.matcher(s);
        StringBuilder sb = new StringBuilder();
        sb.append("\\A");
        int end = 0;
        int index = 0;
        while (m.find()) {
            String group = m.group();
            this.positions[index] = group.substring(1, group.length() - 1);
            ++index;
            int start = m.start();
            if (start > 0) {
                if (!this.regularExpression) {
                    sb.append("\\Q");
                }
                sb.append(s.substring(end, start));
                if (!this.regularExpression) {
                    sb.append("\\E");
                }
            }
            sb.append("(.+)");
            end = m.end();
        }
        if (end < s.length()) {
            if (!this.regularExpression) {
                sb.append("\\Q");
            }
            sb.append(s.substring(end));
            if (!this.regularExpression) {
                sb.append("\\E");
            }
        }
        sb.append("\\z");
        this.pattern = Pattern.compile(sb.toString(), 66);
        this.source = this.pattern.pattern();
    }

    public boolean matchesSourceSegmentPattern(String s) {
        Matcher m = this.pattern.matcher(s);
        if (m.find()) {
            sourceFragmentsMap = new ConcurrentHashMap();
            String[] p = this.getPositions();
            int groupCount = m.groupCount();
            for (int i = 1; i <= groupCount; ++i) {
                String g = m.group(i);
                String pos = p[i - 1];
                sourceFragmentsMap.put(pos, g);
            }
            return true;
        }
        return false;
    }

    public Pattern getSourceSegmentPattern() {
        return this.pattern;
    }

    public String[] getPositions() {
        return this.positions;
    }

    public void setDefaultSource(String s) {
        this.defaultSource = s;
    }

    public String getDefaultSource() {
        return this.defaultSource;
    }

    public void setDefaultTarget(String s) {
        this.defaultTarget = s;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public Map getSourceFragmentsMap() {
        return sourceFragmentsMap;
    }
}

