/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.MainView;
import translator.MyUndoListener;
import translator.Options;
import translator.ProjectView;
import translator.Prompter;
import translator.ResourceView;
import translator.ScrollPaneWatermark;
import translator.WorkflowView;
import translator.XMLElement;
import translator.XMLHelper;
import translator.ai.CTLinguist;
import translator.text.ProtectedDocument;
import translator.text.SegmentEditorKit;
import translator.text.TargetStyleConstants;
import translator.translatables.TextDocument;
import translator.ui.Colors;
import translator.ui.GridPanel;
import translator.ui.HTMLFormat;
import translator.ui.HighlightCaret;
import translator.ui.SelectWordAction;
import translator.ui.kodo.KodoGlowingBorder;

public class SourceView
extends GridPanel {
    private MainView topui;
    private MyUndoListener undoHandler;
    private JScrollPane jscroll;
    private JToolBar bar;
    private JButton buttonTrans;
    private JTextPane sourceTextPane;
    private JPopupMenu pop;
    private Prompter prompter;
    private LinkedHashMap itemsMap;
    private StyledDocument document;
    private ProtectedDocument protectedDoc;
    JButton buttonSelectedWords;
    private JToggleButton buttonWhites;
    private int shiftDown;
    private TextDocument selectedWordsEditor;
    private JButton buttonSpeak;

    SourceView(MainView parent) {
        Color c;
        this.topui = parent;
        int t = 180;
        if (AppPreferences.theme.equals("System")) {
            t = 0;
        } else if (AppPreferences.alpha != -1) {
            this.setOpaque(false);
            this.setGrid(true);
            this.setTransparent(true);
            c = new Color(AppPreferences.tbackground2);
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), AppPreferences.alpha);
            this.setBackground(color);
            t = 255 - AppPreferences.alpha;
        } else {
            this.setOpaque(true);
            this.setGrid(AppPreferences.backGrid);
            if (AppPreferences.tbackground2 != 0) {
                c = new Color(AppPreferences.tbackground2);
                this.setBackground(c);
            }
        }
        KodoGlowingBorder border = new KodoGlowingBorder();
        Color c2 = new Color(AppPreferences.iconsColor);
        Color color = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), t);
        border.setColors(new Color(200, 200, 200, t), new Color(200, 200, 200, t), color);
        this.setBorder(border);
        this.setLayout(new BorderLayout());
        this.createToolBar();
        this.createTextArea();
        if (AppPreferences.selectionRecording) {
            this.startWordRecording();
        }
    }

    public void addSpeakButton() {
        CTLinguist gpt = this.topui.getResourceView().getCTLinguist();
        if (gpt != null && this.buttonSpeak == null) {
            this.buttonSpeak = new JButton();
            this.buttonSpeak.setForeground(new Color(AppPreferences.toolBarsForeground));
            this.buttonSpeak.setOpaque(false);
            this.buttonSpeak.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TEXT_TO_SPEECH, (int)(this.buttonSpeak.getFont().getSize() + 4), (Color)Colors.getIconsColor());
            this.buttonSpeak.setIcon((Icon)ficon);
            this.buttonSpeak.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SourceView.this.topui.getResourceView().speakSelectedText();
                }
            });
            this.bar.add(this.buttonSpeak);
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    public void setBorderTitleColor(Color color) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.lightGray), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE SEGMENT"), 3, 0, null, color));
    }

    private void createToolBar() {
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        this.bar.setOpaque(true);
        this.bar.setBackground(GridPanel.darker(this.topui.getMainPanelBackgroundColor(), 0.9));
        if (AppPreferences.alpha != -1) {
            JSlider slider = new JSlider(0, 255, AppPreferences.alpha);
            slider.setName("SliderUITransparency");
            slider.setOpaque(false);
            slider.setPaintLabels(false);
            slider.setPaintTicks(false);
            slider.setPreferredSize(new Dimension(50, (int)slider.getPreferredSize().getHeight()));
            slider.setMaximumSize(new Dimension(50, (int)slider.getPreferredSize().getHeight()));
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider slider = (JSlider)e.getSource();
                    AppPreferences.alpha = slider.getValue();
                    ArrayList panels = SourceView.this.topui.getPanels();
                    for (GridPanel panel : panels) {
                        Color c = panel.getBackground();
                        int r = c.getRed();
                        int g = c.getGreen();
                        int b = c.getBlue();
                        panel.setBackground(new Color(r, g, b, AppPreferences.alpha));
                    }
                }
            });
            this.bar.add(slider);
        }
        this.buttonSelectedWords = new JButton();
        this.buttonSelectedWords.setOpaque(false);
        this.buttonSelectedWords.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonSelectedWords.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.buttonSelectedWords.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_MOUSE, (int)(this.buttonSelectedWords.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonSelectedWords.setIcon((Icon)ficon);
        this.buttonSelectedWords.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECTION RECORDING") + " (" + Options.getShortcutComboString("k35") + ")");
        this.buttonSelectedWords.setName("RecordListSelected");
        this.buttonSelectedWords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTLinguist ai;
                int mod = e.getModifiers();
                if ((mod & 1) == 1) {
                    SourceView.this.translateSelectedWords();
                    return;
                }
                String word = SourceView.this.sourceTextPane.getSelectedText();
                if (word == null && (word = SourceView.this.topui.getTargetPane().getSelectedText()) == null && (ai = SourceView.this.topui.getResourceView().getCTLinguist()) != null) {
                    word = ai.getChatPane().getSelectedText();
                }
                if (word == null || AppPreferences.autoSelectionRecording) {
                    JButton button = (JButton)e.getSource();
                    SourceView.this.showSelectionPopUp(SourceView.this.bar, button.getX(), button.getY() + button.getHeight() + 5);
                } else {
                    SourceView.this.addSelectedWord(word, true);
                }
            }
        });
        this.buttonWhites = new JToggleButton();
        this.buttonWhites.setOpaque(false);
        this.buttonWhites.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonWhites.setSelected(AppPreferences.invisibles);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_TEXTDIRECTION_L_TO_R, (int)(this.buttonWhites.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonWhites.setIcon((Icon)ficon);
        this.buttonWhites.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW INVISIBLE CHARACTERS") + " (" + Options.getShortcutComboString("k116") + ")");
        this.buttonWhites.setName("ShowInvisibleChars");
        this.buttonWhites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyledDocument sdoc = SourceView.this.topui.getSourcePane().getStyledDocument();
                StyledDocument tdoc = SourceView.this.topui.getTargetPane().getStyledDocument();
                AppPreferences.invisibles = SourceView.this.buttonWhites.isSelected();
                if (AppPreferences.invisibles) {
                    sdoc.putProperty("invisibles", true);
                    tdoc.putProperty("invisibles", true);
                } else {
                    sdoc.putProperty("invisibles", null);
                    tdoc.putProperty("invisibles", null);
                }
                SourceView.this.topui.getSourcePane().repaint();
                SourceView.this.topui.getTargetPane().repaint();
            }
        });
        JButton buttonZoomM = new JButton();
        buttonZoomM.setOpaque(false);
        buttonZoomM.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ZOOM -") + " (" + Options.getShortcutComboString("k87") + ")");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_MAGNIFY_MINUS, (int)(buttonZoomM.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonZoomM.setIcon((Icon)ficon);
        buttonZoomM.setName("DecreaseFontSize");
        buttonZoomM.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonZoomM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceView.this.topui.getResourceView().zoomMinus();
            }
        });
        JButton buttonZoomP = new JButton();
        buttonZoomP.setOpaque(false);
        buttonZoomP.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ZOOM +") + " (" + Options.getShortcutComboString("k86") + ")");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_MAGNIFY_PLUS, (int)(buttonZoomP.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonZoomP.setIcon((Icon)ficon);
        buttonZoomP.setName("IncreaseFontSize");
        buttonZoomP.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonZoomP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceView.this.topui.getResourceView().zoomPlus();
            }
        });
        this.bar.add(buttonZoomP);
        this.bar.add(buttonZoomM);
        JButton buttonLower = new JButton();
        buttonLower.setName("MenuEditTargetSegmentChangeCase");
        buttonLower.setOpaque(false);
        buttonLower.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_SIZE, (int)(buttonLower.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonLower.setIcon((Icon)ficon);
        buttonLower.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHANGE CASE"));
        buttonLower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPane tc = SourceView.this.topui.getTargetView().getTargetPane();
                SourceView.this.topui.getResourceView().cycleCase(tc, 1);
            }
        });
        JButton buttonUndo = new JButton();
        buttonUndo.setName("UndoEdit");
        buttonUndo.setOpaque(false);
        buttonUndo.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonUndo.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNDO"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_UNDO, (int)(buttonUndo.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonUndo.setIcon((Icon)ficon);
        buttonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.editSource && SourceView.this.topui.getFocusedTextComponent().equals(SourceView.this.topui.getSourcePane())) {
                    SourceView.this.topui.getSourceView().getUndoHandler().undoAction();
                } else {
                    SourceView.this.topui.getTargetView().getUndoHandler().undoAction();
                }
            }
        });
        JButton buttonRedo = new JButton();
        buttonRedo.setName("RedoEdit");
        buttonRedo.setOpaque(false);
        buttonRedo.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonRedo.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REDO"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_REDO, (int)(buttonRedo.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonRedo.setIcon((Icon)ficon);
        buttonRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.editSource && SourceView.this.topui.getFocusedTextComponent().equals(SourceView.this.topui.getSourcePane())) {
                    SourceView.this.topui.getSourceView().getUndoHandler().redoAction();
                } else {
                    SourceView.this.topui.getTargetView().getUndoHandler().redoAction();
                }
            }
        });
        this.bar.add(buttonLower);
        this.bar.add(buttonUndo);
        this.bar.add(buttonRedo);
        JButton buttonCut = new JButton();
        buttonCut.setOpaque(false);
        buttonCut.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonCut.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CUT"));
        buttonCut.setName("Cut");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CONTENT_CUT, (int)(buttonCut.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonCut.setIcon((Icon)ficon);
        buttonCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextComponent tc = SourceView.this.topui.getFocusedTextComponent();
                tc.cut();
            }
        });
        JButton buttonCopy = new JButton();
        buttonCopy.setOpaque(false);
        buttonCopy.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonCopy.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("COPY"));
        buttonCopy.setName("Copy");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CONTENT_COPY, (int)(buttonCopy.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonCopy.setIcon((Icon)ficon);
        buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextComponent tc = SourceView.this.topui.getFocusedTextComponent();
                tc.copy();
            }
        });
        JButton buttonPaste = new JButton();
        buttonPaste.setOpaque(false);
        buttonPaste.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonPaste.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PASTE"));
        buttonPaste.setName("Paste");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CONTENT_PASTE, (int)(buttonPaste.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonPaste.setIcon((Icon)ficon);
        buttonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextComponent tc = SourceView.this.topui.getFocusedTextComponent();
                tc.paste();
            }
        });
        this.bar.add(buttonCut);
        this.bar.add(buttonCopy);
        this.bar.add(buttonPaste);
        this.bar.add(this.buttonWhites);
        this.buttonTrans = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE"));
        this.buttonTrans.setOpaque(false);
        this.buttonTrans.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.buttonTrans.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.buttonTrans.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TRANSLATE, (int)(this.buttonTrans.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonTrans.setIcon((Icon)ficon);
        this.buttonTrans.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE SELECTED FRAGMENT") + " (" + Options.getShortcutComboString("k25") + ")");
        this.buttonTrans.setName("TranslateSelectedFragment");
        this.buttonTrans.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceView.this.topui.getWorkflowView().translate();
            }
        });
        this.bar.add(this.buttonTrans);
        JButton buttonTransferMT = new JButton();
        buttonTransferMT.setOpaque(false);
        buttonTransferMT.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonTransferMT.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER MT FROM WEB PAGE") + " (" + Options.getShortcutComboString("k110") + ")");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_UP_BOLD, (int)(buttonTransferMT.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonTransferMT.setIcon((Icon)ficon);
        buttonTransferMT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceView.this.topui.getResourceView().transferMTFormWebPage();
            }
        });
        this.bar.add(buttonTransferMT);
        if (AppPreferences.editorsSplit.equals("Horizontal")) {
            if (AppPreferences.sourceToolbarPosition) {
                this.add((Component)this.bar, "North");
            } else {
                this.add((Component)this.bar, "South");
            }
        } else if (AppPreferences.targetToolbarPosition) {
            AppPreferences.sourceToolbarPosition = true;
            this.add((Component)this.bar, "North");
        } else {
            AppPreferences.sourceToolbarPosition = false;
            this.add((Component)this.bar, "South");
        }
        this.bar.setVisible(!AppPreferences.hideToolBars);
    }

    public JToolBar getToolBar() {
        return this.bar;
    }

    public void setTextForTranslateButton(String s) {
        this.buttonTrans.setText(s);
    }

    private void createTextArea() {
        File file;
        int fontColor;
        this.sourceTextPane = new JTextPane();
        this.sourceTextPane.setEditorKit(new SegmentEditorKit());
        this.sourceTextPane.setDragEnabled(AppPreferences.draganddrop);
        this.sourceTextPane.putClientProperty("type", "langview2");
        Graphics g = this.sourceTextPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        if (AppPreferences.tbackground2 != 0 || AppPreferences.tBackgroundIm2.length() > 0) {
            Color tbackground = new Color(AppPreferences.tbackground2);
            Color tforeground = new Color(AppPreferences.tforeground2);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.sourceTextPane.setSelectionColor(selection);
            this.sourceTextPane.setCaretColor(tforeground);
            this.sourceTextPane.setBackground(tbackground);
            this.sourceTextPane.setForeground(tforeground);
            this.sourceTextPane.setSelectedTextColor(tforeground);
            fontColor = AppPreferences.tforeground2;
        } else {
            AppPreferences.foreground = AppPreferences.pforeground = this.sourceTextPane.getForeground().getRGB();
            HTMLFormat.setStyles();
            fontColor = AppPreferences.pforeground;
            if (AppPreferences.linuxGTK) {
                this.sourceTextPane.setCaretColor(this.sourceTextPane.getForeground());
            }
        }
        Colors.termBorderBright = fontColor != -16777216;
        if (AppPreferences.laf != null && AppPreferences.laf.equals("Mac OS")) {
            this.sourceTextPane.setCaret(new HighlightCaret());
        }
        this.sourceTextPane.setFont(new Font(AppPreferences.sfontname, AppPreferences.sfontstyle, AppPreferences.sfontsize));
        this.document = this.sourceTextPane.getStyledDocument();
        this.document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceView.this.undoHandler.compoundEditEnd(false);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                StyledDocument sdoc;
                Object o;
                SourceView.this.topui.resetCharacterCount();
                if (AppPreferences.adjustCase) {
                    if (AppPreferences.noWordSeparatorSourceLanguage || AppPreferences.noWordSeparatorTargetLanguage) {
                        SourceView.this.topui.getTargetView().setCaseAdjusted(true);
                    } else {
                        SourceView.this.topui.getTargetView().setCaseAdjusted(false);
                    }
                }
                if ((o = (sdoc = (StyledDocument)e.getDocument()).getProperty("tags")) != null) {
                    sdoc.putProperty("tags", null);
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (this.this$1.SourceView.this.document.getLength() > 1) {
                                Font font = this.this$1.SourceView.this.sourceTextPane.getFont();
                                font = font.deriveFont(1, AppPreferences.tagsfontsize);
                                XMLHelper.markTags(sdoc, font);
                            }
                        }
                    });
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceView.this.topui.resetCharacterCount();
            }
        });
        if (AppPreferences.invisibles) {
            this.document.putProperty("invisibles", true);
        }
        Color placolor = new Color(AppPreferences.placeablesColor);
        Style style = this.document.addStyle("Placeable", null);
        StyleConstants.setBackground(style, placolor);
        if (Colors.termBorderBright) {
            StyleConstants.setForeground(style, Color.WHITE);
        }
        TargetStyleConstants.setTermBorder(style, true);
        Color termcolor = new Color(AppPreferences.matchColor2);
        Color termcolorLow = GridPanel.brighter(termcolor, 0.9);
        Color termcolorHigh = GridPanel.darker(termcolor, 0.9);
        Color termcolorfont = new Color(AppPreferences.matchColorFont2);
        Color phrasecolor = new Color(AppPreferences.matchColor);
        Color phrasecolorLow = GridPanel.brighter(phrasecolor, 0.9);
        Color phrasecolorHigh = GridPanel.darker(phrasecolor, 0.9);
        Color phrasecolorfont = new Color(AppPreferences.matchColorFont);
        Style gstyle = this.document.addStyle("Terms", null);
        Style gstyleLow = this.document.addStyle("TermsLow", null);
        Style gstyleHigh = this.document.addStyle("TermsHigh", null);
        if (AppPreferences.tbackground2 != AppPreferences.matchColor2) {
            StyleConstants.setBackground(gstyle, termcolor);
            StyleConstants.setBackground(gstyleLow, termcolorLow);
            StyleConstants.setBackground(gstyleHigh, termcolorHigh);
            TargetStyleConstants.setTermBorder(gstyle, true);
            TargetStyleConstants.setTermBorder(gstyleLow, true);
            TargetStyleConstants.setTermBorder(gstyleHigh, true);
        }
        if (fontColor != AppPreferences.matchColorFont2) {
            StyleConstants.setForeground(gstyle, termcolorfont);
            StyleConstants.setForeground(gstyleLow, termcolorfont);
            StyleConstants.setForeground(gstyleHigh, termcolorfont);
        }
        Style mstyle = this.document.addStyle("Phrases", null);
        Style mstyleLow = this.document.addStyle("PhrasesLow", null);
        Style mstyleHigh = this.document.addStyle("PhrasesHigh", null);
        if (AppPreferences.tbackground2 != AppPreferences.matchColor) {
            StyleConstants.setBackground(mstyle, phrasecolor);
            StyleConstants.setBackground(mstyleLow, phrasecolorLow);
            StyleConstants.setBackground(mstyleHigh, phrasecolorHigh);
            TargetStyleConstants.setTermBorder(mstyle, true);
            TargetStyleConstants.setTermBorder(mstyleLow, true);
            TargetStyleConstants.setTermBorder(mstyleHigh, true);
        } else {
            HTMLFormat.matchColorHTML = HTMLFormat.matchColorHTML2;
            HTMLFormat.matchColorHTMLNoMT = HTMLFormat.matchColorHTML2;
        }
        if (fontColor != AppPreferences.matchColorFont) {
            StyleConstants.setForeground(mstyle, phrasecolorfont);
            StyleConstants.setForeground(mstyleLow, phrasecolorfont);
            StyleConstants.setForeground(mstyleHigh, phrasecolorfont);
        }
        style = this.document.addStyle("Tags", null);
        this.document.addStyle("", null);
        style = this.document.addStyle("Normal", null);
        StyleConstants.setForeground(style, this.sourceTextPane.getForeground());
        style = this.document.addStyle("SpaceNB", null);
        StyleConstants.setBackground(style, Color.LIGHT_GRAY);
        style = this.document.addStyle("Pattern", null);
        TargetStyleConstants.setPatternUnderline(style, true);
        Style sstyle = this.sourceTextPane.addStyle("highlight", null);
        StyleConstants.setBackground(sstyle, termcolor);
        this.sourceTextPane.setMargin(new Insets(16, 16, 16, 16));
        this.sourceTextPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SourceView.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.sourceTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                String sel = SourceView.this.sourceTextPane.getSelectedText();
                if (sel != null && me.getButton() == 3) {
                    int mod = me.getModifiers();
                    if (mod == 6) {
                        WorkflowView wv = SourceView.this.topui.getWorkflowView();
                        wv.addPhraseToMemory();
                    } else if (mod == 5) {
                        WorkflowView wv = SourceView.this.topui.getWorkflowView();
                        wv.addEntryToGlossary();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ProjectView prview;
                XMLElement tu;
                if (evt.isPopupTrigger() && (tu = (prview = SourceView.this.topui.getProjectView()).getProject().getCurrentTransUnit()) != null) {
                    prview.getProject().showPopUp(evt.getComponent(), evt.getX(), evt.getY(), tu);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProjectView prview;
                XMLElement tu;
                String sel = SourceView.this.sourceTextPane.getSelectedText();
                if (sel != null) {
                    ResourceView rview = SourceView.this.topui.getResourceView();
                    rview.clearAISelection();
                    int mod = evt.getModifiersEx();
                    int cc = evt.getClickCount();
                    if ((mod & 0x200) != 512 && cc < 2 && AppPreferences.smartSelection && evt.getButton() == 1 && !AppPreferences.noWordSeparatorSourceLanguage) {
                        try {
                            int spos = Utilities.getWordStart(SourceView.this.sourceTextPane, SourceView.this.sourceTextPane.getSelectionStart());
                            int epos = Utilities.getWordEnd(SourceView.this.sourceTextPane, SourceView.this.sourceTextPane.getSelectionEnd() - 1);
                            SourceView.this.sourceTextPane.setSelectionStart(spos);
                            SourceView.this.sourceTextPane.setSelectionEnd(epos);
                            sel = SourceView.this.sourceTextPane.getSelectedText();
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (sel.length() <= 150) {
                        sel = XMLHelper.parseTags(sel);
                        rview.getLookUpBox().setSelectedItem(sel);
                        if (AppPreferences.chatGPTAction == 2) {
                            rview.translateAIService(sel);
                        }
                        if (AppPreferences.ttsSpeak == 2) {
                            rview.speak(sel);
                        }
                    }
                    SourceView.this.topui.getTargetPane().getCaret().setSelectionVisible(true);
                    if (AppPreferences.selectionRecording && AppPreferences.autoSelectionRecording) {
                        SourceView.this.addSelectedWord(sel, true);
                    }
                }
                if (evt.isPopupTrigger() && (tu = (prview = SourceView.this.topui.getProjectView()).getProject().getCurrentTransUnit()) != null) {
                    prview.getProject().showPopUp(evt.getComponent(), evt.getX(), evt.getY(), tu);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SourceView.this.topui.resetTextAreas();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.sourceTextPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                final int dot = e.getDot();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 18 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        try {
                            Rectangle r = this.this$1.SourceView.this.sourceTextPane.getVisibleRect();
                            Rectangle2D r0 = this.this$1.SourceView.this.sourceTextPane.modelToView2D(dot);
                            int w = (int)r.getWidth();
                            int h = (int)r.getHeight();
                            int x = (int)r.getX();
                            int y = (int)r.getY();
                            int y0 = (int)r0.getY();
                            if (y0 - y + 40 >= h) {
                                r = new Rectangle(x, y0, w, h);
                                this.this$1.SourceView.this.sourceTextPane.scrollRectToVisible(r);
                            } else if (y0 < 40) {
                                r = new Rectangle(0, 0, w, h);
                                this.this$1.SourceView.this.sourceTextPane.scrollRectToVisible(r);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        this.sourceTextPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ProjectView prview;
                XMLElement tu;
                int keycode = e.getKeyCode();
                if (keycode == 525 && (tu = (prview = SourceView.this.topui.getProjectView()).getProject().getCurrentTransUnit()) != null) {
                    try {
                        int pos = SourceView.this.sourceTextPane.getCaretPosition();
                        Rectangle2D r = SourceView.this.sourceTextPane.modelToView2D(pos);
                        int x = (int)r.getX();
                        int y = (int)r.getY();
                        Component comp = (Component)e.getSource();
                        prview.getProject().showPopUp(comp, x, y, tu);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(SourceView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                SourceView.this.shiftDown = 0;
                char c = e.getKeyChar();
                boolean space = Character.isSpaceChar(c);
                if (space) {
                    SourceView.this.undoHandler.compoundEditBreak(true);
                } else if (!AppPreferences.noWordSeparatorSourceLanguage) {
                    SourceView.this.undoHandler.compoundEditEnd(false);
                } else {
                    SourceView.this.undoHandler.compoundEditEnd(true);
                }
                SourceView.this.sourceTextPane.repaint();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int i = e.getKeyCode();
                if (i == 16) {
                    SourceView.this.shiftDown++;
                    if (SourceView.this.shiftDown == 2) {
                        SourceView.this.shiftDown = 0;
                        if (!e.isShiftDown()) {
                            String s = SourceView.this.sourceTextPane.getSelectedText();
                            if (s == null) {
                                s = SourceView.this.topui.getResourceView().getWordAtCaretPosition(SourceView.this.sourceTextPane, true);
                            }
                            SourceView.this.topui.getTargetView().showMatchesForIndex(s);
                        }
                    }
                } else {
                    SourceView.this.shiftDown = 0;
                }
            }
        });
        this.protectedDoc = new ProtectedDocument(this.sourceTextPane);
        this.undoHandler = new MyUndoListener();
        this.undoHandler.setLimit(100);
        this.document.addUndoableEditListener(this.undoHandler);
        this.sourceTextPane.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceView.this.undoHandler.undoAction();
            }
        });
        this.sourceTextPane.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceView.this.undoHandler.redoAction();
            }
        });
        if (AppPreferences.operatingSystem == 1) {
            this.sourceTextPane.getInputMap().put(KeyStroke.getKeyStroke(90, 256), "Undo");
            this.sourceTextPane.getInputMap().put(KeyStroke.getKeyStroke(89, 256), "Redo");
        } else {
            this.sourceTextPane.getInputMap().put(KeyStroke.getKeyStroke(90, 128), "Undo");
            this.sourceTextPane.getInputMap().put(KeyStroke.getKeyStroke(89, 128), "Redo");
        }
        this.sourceTextPane.getActionMap().put("select-word", new SelectWordAction());
        this.jscroll = new JScrollPane(this.sourceTextPane);
        this.jscroll.setOpaque(false);
        this.jscroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.jscroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            this.jscroll.getViewport().setOpaque(false);
            this.sourceTextPane.setBackground(new Color(0, 0, 0, 0));
            this.sourceTextPane.setOpaque(false);
        }
        if (AppPreferences.alpha == -1 && AppPreferences.tBackgroundIm2.length() > 0 && (file = new File(AppPreferences.tBackgroundIm2)).exists()) {
            JViewport vp = (JViewport)this.sourceTextPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.sourceTextPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.add((Component)this.jscroll, "Center");
    }

    MyUndoListener getUndoHandler() {
        return this.undoHandler;
    }

    public void addSelectedWord(String sel, boolean context) {
        if (this.pop == null) {
            this.startWordRecording();
        }
        String[] values = new String[2];
        if (context) {
            String t1 = this.sourceTextPane.getText();
            JTextPane tpane = this.topui.getTargetPane();
            String t2 = tpane.getSelectedText();
            if (t2 == null) {
                t2 = tpane.getText();
            }
            values[0] = t1;
            values[1] = t2;
        }
        if (this.itemsMap != null) {
            this.itemsMap.put(sel.trim(), values);
        }
        if (this.itemsMap != null && this.itemsMap.size() > 0) {
            int i = this.itemsMap.size();
            this.buttonSelectedWords.setText(Integer.toString(i));
        }
    }

    public LinkedHashMap getHistoryMap() {
        return this.itemsMap;
    }

    public void updatePrompter() {
        if (this.prompter != null) {
            this.prompter.makeCueWords();
        } else {
            this.prompter = new Prompter(this.topui);
            this.prompter.setKeyListener();
            this.prompter.makeCueWords();
        }
    }

    public void removePrompter() {
        if (this.prompter != null) {
            this.prompter.removeKeyListener();
            this.prompter = null;
        }
    }

    public Prompter getPrompter() {
        return this.prompter;
    }

    boolean isPrompterActive() {
        if (this.prompter == null) {
            return false;
        }
        return this.prompter.isPopUpVisible();
    }

    public void highlightWord(final String word) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SourceView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    StyledDocument doc = this.this$0.sourceTextPane.getStyledDocument();
                    String text = doc.getText(0, doc.getLength());
                    if (text.length() > word.length()) {
                        Pattern p = Pattern.compile(word, 2);
                        Matcher ma = p.matcher(text);
                        while (ma.find()) {
                            int s = ma.start();
                            int e = ma.end();
                            doc.setCharacterAttributes(s, e - s, this.this$0.sourceTextPane.getStyle("highlight"), false);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public JScrollPane getScrollPane() {
        return this.jscroll;
    }

    JTextPane getSourceArea() {
        return this.sourceTextPane;
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        this.pop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SourceView.this.pop.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                SourceView.this.pop.removeAll();
            }
        });
    }

    public void showSelectionPopUp(Component comp, int xx, int yy) {
        if (this.pop == null) {
            this.startWordRecording();
            return;
        }
        try {
            int y;
            int x;
            int pos = this.sourceTextPane.getCaretPosition();
            if (xx != -1 && yy != -1) {
                x = xx;
                y = yy;
            } else {
                Rectangle2D rec = this.sourceTextPane.modelToView2D(pos);
                x = (int)rec.getX();
                y = (int)rec.getY();
            }
            JMenu more = null;
            int no = 0;
            Font f = this.sourceTextPane.getFont();
            float fs = 14.0f;
            if (this.itemsMap != null) {
                JMenuItem itemTranslate = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE")){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        SourceView.this.translateSelectedWords();
                    }
                });
                this.pop.add(itemTranslate);
                JMenu actionMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION"));
                this.pop.add(actionMenu);
                JMenuItem itemClear = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLEAR")){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        SourceView.this.clearSelectionMap();
                    }
                });
                actionMenu.add(itemClear);
                JMenuItem itemFinish = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LIST")){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        SourceView.this.listSelections();
                    }
                });
                actionMenu.add(itemFinish);
                JMenuItem itemClose = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STOP")){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        SourceView.this.stopSelectionRecording();
                    }
                });
                actionMenu.add(itemClose);
                actionMenu.addSeparator();
                JCheckBoxMenuItem autoRecordMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC SELECTION RECORDING"));
                autoRecordMenu.setSelected(AppPreferences.autoSelectionRecording);
                autoRecordMenu.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        AppPreferences.autoSelectionRecording = e.getStateChange() == 1;
                    }
                });
                actionMenu.add(autoRecordMenu);
                JCheckBoxMenuItem contextRecordMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CT-L1 LINGUIST SELECTION CONTEXT"));
                contextRecordMenu.setSelected(AppPreferences.selectionRecordingContext);
                contextRecordMenu.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        AppPreferences.selectionRecordingContext = e.getStateChange() == 1;
                    }
                });
                actionMenu.add(contextRecordMenu);
                if (!this.itemsMap.isEmpty()) {
                    this.pop.addSeparator();
                }
                Set set = this.itemsMap.keySet();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    if (no == 30) {
                        if (more == null) {
                            more = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MORE..."));
                            more.setFont(f.deriveFont(fs));
                            this.pop.add((Component)more, 0);
                            this.pop.add((Component)new JPopupMenu.Separator(), 1);
                        } else {
                            JMenu more2 = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MORE..."));
                            more2.setFont(f.deriveFont(fs));
                            more.add((Component)more2, 0);
                            more.add((Component)new JPopupMenu.Separator(), 1);
                            more = more2;
                        }
                        no = 0;
                    }
                    ++no;
                    String key = it.next().toString();
                    String[] values = (String[])this.itemsMap.get(key);
                    String value1 = values[0];
                    String value2 = values[1];
                    if (value1 != null) {
                        JMenu menu = new JMenu();
                        JMenuItem item = new JMenuItem(new AbstractAction(value1){

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                String com = a.getActionCommand();
                                try {
                                    SourceView.this.itemsMap.remove(com);
                                    if (SourceView.this.itemsMap.size() > 0) {
                                        int i = SourceView.this.itemsMap.size();
                                        SourceView.this.buttonSelectedWords.setText(Integer.toString(i));
                                    } else {
                                        SourceView.this.buttonSelectedWords.setText("");
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)item.getFont().getSize(), (Color)item.getForeground());
                        item.setIcon((Icon)ficon);
                        JMenuItem item2 = new JMenuItem(new AbstractAction(value2){

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                String com = a.getActionCommand();
                                try {
                                    SourceView.this.itemsMap.remove(com);
                                    if (SourceView.this.itemsMap.size() > 0) {
                                        int i = SourceView.this.itemsMap.size();
                                        SourceView.this.buttonSelectedWords.setText(Integer.toString(i));
                                    } else {
                                        SourceView.this.buttonSelectedWords.setText("");
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)item2.getFont().getSize(), (Color)item2.getForeground());
                        item2.setIcon((Icon)ficon);
                        int max = 100;
                        item.setActionCommand(key);
                        item.setFont(f.deriveFont(fs));
                        item2.setActionCommand(key);
                        item2.setFont(f.deriveFont(fs));
                        value1 = value1.replaceAll("\n", " ");
                        StringBuffer sb = new StringBuffer(value1);
                        int ind = sb.indexOf(key);
                        while (ind != -1) {
                            sb.insert(ind, "<u>");
                            sb.insert(ind + key.length() + 3, "</u>");
                            ind = sb.indexOf(key, ind + key.length() + 3);
                        }
                        item.setText("<html><body width=500>" + sb.toString() + "</body></html>");
                        menu.add(item);
                        if (value2 != null && value2.length() > 0) {
                            value2 = value2.replaceAll("\n", " ");
                            item2.setText("<html><body width=500>" + value2 + "</body></html>");
                            menu.addSeparator();
                            menu.add(item2);
                        }
                        if (key.length() > max) {
                            key = key.substring(0, max) + "...";
                        }
                        key = key.replaceAll("\n", " ");
                        menu.setText(key);
                        menu.setFont(f.deriveFont(fs));
                        if (more == null) {
                            this.pop.add(menu);
                            continue;
                        }
                        more.add(menu);
                        continue;
                    }
                    JMenuItem item = new JMenuItem(new AbstractAction(key){

                        @Override
                        public void actionPerformed(ActionEvent a) {
                            String com = a.getActionCommand();
                            try {
                                SourceView.this.itemsMap.remove(com);
                                if (SourceView.this.itemsMap.size() > 0) {
                                    int i = SourceView.this.itemsMap.size();
                                    SourceView.this.buttonSelectedWords.setText(Integer.toString(i));
                                } else {
                                    SourceView.this.buttonSelectedWords.setText("");
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                    FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)item.getFont().getSize(), (Color)item.getForeground());
                    item.setIcon((Icon)ficon);
                    int max = 100;
                    item.setActionCommand(key);
                    item.setFont(f.deriveFont(fs));
                    if (key.length() > max) {
                        key = key.substring(0, max) + "...";
                    }
                    key = key.replaceAll("\n", " ");
                    item.setText(key);
                    item.setFont(f.deriveFont(fs));
                    if (more == null) {
                        this.pop.add(item);
                        continue;
                    }
                    more.add(item);
                }
            }
            if (this.pop.getComponentCount() > 0) {
                this.pop.show(comp, x, y);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void protectTags(int from, int to) {
        this.protectedDoc.protect(from, to);
    }

    public void resetTagProtection() {
        this.protectedDoc.reset();
    }

    public void plusFont() {
        if (this.sourceTextPane != null) {
            Font font = this.sourceTextPane.getFont();
            float size = font.getSize() + 1;
            font = font.deriveFont(size);
            this.sourceTextPane.setFont(font);
            AppPreferences.sfontsize = (int)size;
        }
    }

    public void minusFont() {
        if (this.sourceTextPane != null) {
            Font font = this.sourceTextPane.getFont();
            float size = font.getSize() - 1;
            font = font.deriveFont(size);
            this.sourceTextPane.setFont(font);
            AppPreferences.sfontsize = (int)size;
        }
    }

    public void startWordRecording() {
        this.itemsMap = new LinkedHashMap(100);
        this.setPopup();
        if (!this.buttonSelectedWords.isShowing()) {
            this.bar.add(this.buttonSelectedWords);
            this.bar.revalidate();
            this.bar.repaint();
        }
        AppPreferences.selectionRecording = true;
    }

    public void stopSelectionRecording() {
        AppPreferences.selectionRecording = false;
        this.itemsMap.clear();
        this.itemsMap = null;
        this.pop = null;
        this.buttonSelectedWords.setText("");
        this.bar.remove(this.buttonSelectedWords);
        this.bar.revalidate();
        this.bar.repaint();
    }

    public void listSelections() {
        if (this.itemsMap != null && this.itemsMap.size() > 0) {
            StringBuffer entries = new StringBuffer();
            Set eset = this.itemsMap.keySet();
            Iterator i = eset.iterator();
            while (i.hasNext()) {
                entries.append((String)i.next());
                entries.append("\n");
            }
            this.itemsMap.clear();
            this.buttonSelectedWords.setText("");
            Document doc = null;
            if (this.selectedWordsEditor != null) {
                doc = this.selectedWordsEditor.getDocument();
            }
            if (doc == null) {
                ResourceView rv = this.topui.getResourceView();
                this.selectedWordsEditor = rv.newTextDocument(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECTIONS"));
                doc = this.selectedWordsEditor.getDocument();
            }
            try {
                doc.insertString(doc.getLength(), entries.toString(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getRecordedSelectionContext() {
        if (this.itemsMap != null && this.itemsMap.size() > 0) {
            StringBuffer entries = new StringBuffer();
            Set eset = this.itemsMap.keySet();
            Iterator i = eset.iterator();
            while (i.hasNext()) {
                entries.append((String)i.next());
                entries.append("\n");
            }
            this.itemsMap.clear();
            this.buttonSelectedWords.setText("");
            return entries.toString();
        }
        return null;
    }

    private void clearSelectionMap() {
        if (this.itemsMap != null) {
            this.itemsMap.clear();
            this.buttonSelectedWords.setText("");
        }
    }

    public String getSelectedWords() {
        if (this.itemsMap != null && this.itemsMap.size() > 0) {
            StringBuffer entries = new StringBuffer();
            Set eset = this.itemsMap.keySet();
            Iterator i = eset.iterator();
            while (i.hasNext()) {
                if (entries.length() > 0) {
                    entries.append(", ");
                }
                entries.append((String)i.next());
            }
            return entries.toString();
        }
        return null;
    }

    private void translateSelectedWords() {
        if (this.itemsMap != null && this.itemsMap.size() > 0) {
            StringBuffer entries = new StringBuffer();
            Set eset = this.itemsMap.keySet();
            Iterator i = eset.iterator();
            while (i.hasNext()) {
                if (entries.length() > 0) {
                    entries.append(", ");
                }
                entries.append((String)i.next());
            }
            this.itemsMap.clear();
            this.buttonSelectedWords.setText("");
            String q = entries.toString();
            this.topui.getResourceView().translateAIService(q);
            this.topui.getResourceView().translateMTSelection(q);
        }
    }

    public void setTextComponentOrientation(Locale loc) {
        ComponentOrientation o = ComponentOrientation.getOrientation(loc);
        ComponentOrientation co = this.sourceTextPane.getComponentOrientation();
        if (o.isLeftToRight() != co.isLeftToRight()) {
            AppPreferences.RTLSource = !o.isLeftToRight();
            this.sourceTextPane.getParent().getParent().applyComponentOrientation(o);
            this.topui.getResourceView().getLookUpBox().applyComponentOrientation(o);
            this.revalidate();
            this.repaint();
        }
    }

    public void toggleInvisibleCharacters(boolean toggle) {
        if (toggle && !this.buttonWhites.isSelected()) {
            this.buttonWhites.doClick();
        } else if (!toggle && this.buttonWhites.isSelected()) {
            this.buttonWhites.doClick();
        }
    }
}

