/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import translator.AppPreferences;
import translator.BillingChooser;
import translator.DefaultXMLElement;
import translator.KeyPreferences;
import translator.MainView;
import translator.MemoryStatistics;
import translator.MySwingWorker;
import translator.Project;
import translator.Statistics;
import translator.TextResource;
import translator.WordCount;
import translator.Workflow;
import translator.WorkflowManager;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXView;
import translator.ttx.TTX;
import translator.ttx.TTXView;
import translator.ui.HTMLFormat;
import translator.ui.kodo.KodoProgressBarUI;
import translator.xliff.Billing;
import translator.xliff.BillingEditor;
import translator.xliff.XLIFF;
import translator.xliff.XliffFile;
import translator.xliff.XliffView;

public class StatisticsView {
    private MainView topui;
    private String statsHTML;
    private String fileName;
    private TextResource htmlViewer;
    JMenuItem pStatisticsMenuItem;
    JMenuItem docStatsMenuItem;
    private String register;
    private String invoice;
    private boolean pause;
    private String progress;
    JProgressBar progressBar;

    public StatisticsView(MainView topui) {
        this.topui = topui;
        this.register = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REGISTER");
        this.invoice = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE");
    }

    public void showStatsMenu(JMenu menu) {
        this.pStatisticsMenuItem = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT STATISTICS")){

            @Override
            public void actionPerformed(ActionEvent a) {
                String s = StatisticsView.this.statsProjectToHTML2(false);
                if (s != null) {
                    s = "<html>" + HTMLFormat.styles + "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body>" + s + "</body></html>";
                    if (StatisticsView.this.htmlViewer == null) {
                        StatisticsView.this.setHTMLViewer();
                    }
                    StatisticsView.this.htmlViewer.showStatistics(s);
                    StatisticsView.this.statsHTML = s;
                    StatisticsView.this.fileName = "Project_Statistics.html";
                    StatisticsView.this.copyStatistics();
                }
            }
        });
        this.pStatisticsMenuItem.setName("MenuProjectStatisticsProject");
        KeyStroke ks = KeyPreferences.getKeyStroke("k93");
        if (ks != null) {
            this.pStatisticsMenuItem.setAccelerator(ks);
        }
        menu.add(this.pStatisticsMenuItem);
        JCheckBoxMenuItem menuUpdate = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC UPDATE OF PROJECT STATISTICS"));
        menuUpdate.setSelected(AppPreferences.updateProjectStatistics);
        menuUpdate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean bl = AppPreferences.updateProjectStatistics = e.getStateChange() == 1;
                if (!AppPreferences.updateProjectStatistics) {
                    StatisticsView.this.topui.getProjectView().getToolBar().remove(StatisticsView.this.progressBar);
                    StatisticsView.this.topui.getProjectView().getToolBar().revalidate();
                    StatisticsView.this.topui.getProjectView().getToolBar().repaint();
                    StatisticsView.this.progressBar = null;
                }
            }
        });
        menu.add(menuUpdate);
        this.docStatsMenuItem = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CURRENT DOCUMENT STATISTICS")){

            @Override
            public void actionPerformed(ActionEvent a) {
                String s = StatisticsView.this.statsProjectToHTML2(true);
                if (s != null) {
                    s = "<html>" + HTMLFormat.styles + "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body>" + s + "</body></html>";
                    if (StatisticsView.this.htmlViewer == null) {
                        StatisticsView.this.setHTMLViewer();
                    }
                    StatisticsView.this.htmlViewer.showStatistics(s);
                    StatisticsView.this.statsHTML = s;
                    StatisticsView.this.fileName = "Document_Statistics.html";
                    StatisticsView.this.copyStatistics();
                }
            }
        });
        this.docStatsMenuItem.setName("MenuProjectStatisticsCurrentDocument");
        menu.add(this.docStatsMenuItem);
        menu.addSeparator();
        JMenu memoryStats = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY STATISTICS"));
        memoryStats.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JMenu menu = (JMenu)e.getItem();
                if (e.getStateChange() == 1) {
                    StatisticsView.this.showMemoryStatisticsMenu(menu);
                } else if (e.getStateChange() == 2) {
                    menu.removeAll();
                }
            }
        });
        memoryStats.setName("MenuProjectStatisticsMemory");
        menu.add(memoryStats);
        JMenuItem fullStats = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TOTAL STATISTICS")){

            @Override
            public void actionPerformed(ActionEvent a) {
                final Project p = StatisticsView.this.topui.getProjectView().getProject();
                if (p == null) {
                    return;
                }
                StatisticsView.this.statsHTML = "<html>" + HTMLFormat.styles + "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body>";
                String s = StatisticsView.this.statsProjectToHTML2(false);
                if (s != null) {
                    StatisticsView.this.statsHTML = StatisticsView.this.statsHTML + s;
                }
                List localMems = StatisticsView.this.topui.getMemoryView().getLocalMemories();
                final ArrayList<Memory> statsMems = new ArrayList<Memory>();
                for (Memory m : localMems) {
                    if (m.isActive()) continue;
                    MemoryStatistics stats = m.getMemoryStatistics();
                    stats.reset();
                    int endPos = p.getCurrentUnitsNumber();
                    m.initMemoryProgress(0, endPos, "");
                    m.setActive(true);
                    statsMems.add(m);
                }
                MySwingWorker worker = new MySwingWorker(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Object construct() {
                        for (Memory m : statsMems) {
                            p.analyse(m);
                        }
                        return null;
                    }

                    @Override
                    public void finished() {
                        for (Memory m : statsMems) {
                            m.removeMemoryProgress();
                            m.setActive(false);
                            MemoryStatistics stats = m.getMemoryStatistics();
                            String s = this.this$1.StatisticsView.this.statsMemoryToHTML(m.getName(), stats);
                            if (s == null) continue;
                            stats.reset();
                            this.this$1.StatisticsView.this.statsHTML = this.this$1.StatisticsView.this.statsHTML + s;
                        }
                        this.this$1.StatisticsView.this.statsHTML = this.this$1.StatisticsView.this.statsHTML + "</body></html>";
                        if (this.this$1.StatisticsView.this.htmlViewer == null) {
                            this.this$1.StatisticsView.this.setHTMLViewer();
                        }
                        this.this$1.StatisticsView.this.htmlViewer.showStatistics(this.this$1.StatisticsView.this.statsHTML);
                        this.this$1.StatisticsView.this.fileName = "Total_Statistics.html";
                        this.this$1.StatisticsView.this.copyStatistics();
                    }
                };
                worker.start();
            }
        });
        fullStats.setName("MenuProjectStatisticsTotal");
        menu.addSeparator();
        menu.add(fullStats);
        JMenuItem savefile = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE REPORT")){

            @Override
            public void actionPerformed(ActionEvent a) {
                StatisticsView.this.saveStatistics();
            }
        });
        savefile.setName("MenuProjectStatisticsSaveReport");
        menu.addSeparator();
        menu.add(savefile);
    }

    public String[] getProjectWordCount() {
        Project project = this.topui.getProjectView().getProject();
        if (project == null) {
            return null;
        }
        Statistics stats = null;
        XLIFF xlf = project.getXLIFF();
        if (xlf != null) {
            XliffView view = xlf.getView();
            stats = view.getStatistics(false);
        } else {
            TTX ttx = project.getTTX();
            if (ttx != null) {
                TTXView view = ttx.getView();
                stats = view.getStatistics();
            } else {
                TMX tmx = project.getTMX();
                if (tmx != null) {
                    TMXView view = tmx.getView();
                    stats = view.getStatistics();
                }
            }
        }
        if (stats != null) {
            String[] arr = new String[2];
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            float proc = stats.getTranslatedPercent();
            String procString = nf.format(proc) + "%";
            arr[0] = Integer.toString(stats.allSourceWords);
            arr[1] = procString;
            return arr;
        }
        return null;
    }

    private String statsProjectToHTML2(boolean singleDoc) {
        Project project = this.topui.getProjectView().getProject();
        if (project == null) {
            return null;
        }
        Statistics stats = null;
        XLIFF xlf = project.getXLIFF();
        if (xlf != null) {
            XliffView view = xlf.getView();
            stats = view.getStatistics(singleDoc);
        } else {
            TTX ttx = project.getTTX();
            if (ttx != null) {
                TTXView view = ttx.getView();
                stats = view.getStatistics();
            } else {
                TMX tmx = project.getTMX();
                if (tmx != null) {
                    TMXView view = tmx.getView();
                    stats = view.getStatistics();
                }
            }
        }
        if (stats != null) {
            WorkflowManager manager = this.topui.getWorkflowView().getWorkflowManager();
            StringBuilder html = new StringBuilder();
            html.append(HTMLFormat.startTableStats2);
            html.append("<tr><th style='color:white; background-color:#000000'>");
            if (!this.pause) {
                html.append("<a href=\"stop\" style=\"color:yellow; font-size:").append(AppPreferences.UIFontSizeHTML).append(";\"><b><u>STOP</b></u>");
            } else {
                html.append("<a href=\"start\" style=\"color:yellow; font-size:").append(AppPreferences.UIFontSizeHTML).append(";\"><b><u>START</b></u>");
            }
            html.append("</th><th align=right colspan=5 style='color:white; background-color:#000000'><i>");
            if (!singleDoc) {
                html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT STATISTICS").toUpperCase());
            } else {
                XliffFile file;
                String s = null;
                if (xlf != null && (file = xlf.getCurrentFile()) != null) {
                    s = file.getShortName();
                }
                if (s != null && s.length() > 0) {
                    String d = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CURRENT DOCUMENT STATISTICS") + ": ";
                    html.append(d.toUpperCase());
                    html.append(s);
                } else {
                    html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CURRENT DOCUMENT STATISTICS") + ":");
                }
            }
            html.append("</i></th></tr>");
            html.append("<tr><th style=\"color:white; background-color:#444444\">");
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\">");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTS"));
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\">");
            if (AppPreferences.noWordSeparatorSourceLanguage || AppPreferences.noWordSeparatorTargetLanguage) {
                html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORDS/IDEOGRAMS"));
            } else {
                html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORDS"));
            }
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\" colspan=2>");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHARACTERS"));
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\">");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PERCENT"));
            html.append("</th>");
            html.append("</tr>");
            String rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATED SEGMENTS");
            html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td>");
            html.append("<td align=right>");
            html.append(stats.translatedSegments);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.translatedWords);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.translatedCharsNoWhites);
            html.append("</td>");
            html.append("<td align=right>");
            html.append((int)stats.translatedChars);
            html.append("</td>");
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            float proc = stats.getTranslatedPercent();
            String procString = nf.format(proc) + "%";
            html.append("<td align=right>");
            html.append(procString);
            html.append("</td>");
            this.progress = procString;
            html.append("</tr>");
            rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNTRANSLATED SEGMENTS");
            html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td>");
            html.append("<td align=right>");
            html.append(stats.untranslatedSegments);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.untranslatedWords);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.untranslatedCharsNoWhites);
            html.append("</td>");
            html.append("<td align=right>");
            html.append((int)stats.untranslatedChars);
            html.append("</td>");
            proc = stats.getUntranslatedPercent();
            procString = nf.format(proc) + "%";
            html.append("<td align=right>");
            html.append(procString);
            html.append("</td>");
            html.append("</tr>");
            if (stats.checkedSegments > 0) {
                rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECKED SEGMENTS");
                html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td>");
                html.append("<td align=right>");
                html.append(stats.checkedSegments);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.checkedWords);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.checkedCharsNoWhites);
                html.append("</td>");
                html.append("<td align=right>");
                html.append((int)stats.checkedChars);
                html.append("</td>");
                proc = stats.getCheckedPercent();
                procString = nf.format(proc) + "%";
                html.append("<td align=right>");
                html.append(procString);
                html.append("</td>");
                html.append("</tr>");
                rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNCHECKED SEGMENTS");
                html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td>");
                html.append("<td align=right>");
                html.append(stats.uncheckedSegments);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.uncheckedWords);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.uncheckedCharsNoWhites);
                html.append("</td>");
                html.append("<td align=right>");
                html.append((int)stats.uncheckedChars);
                html.append("</td>");
                proc = stats.getUncheckedPercent();
                procString = nf.format(proc) + "%";
                html.append("<td align=right>");
                html.append(procString);
                html.append("</td>");
                html.append("</tr>");
            }
            if (stats.approvedSegments > 0) {
                rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("APPROVED SEGMENTS");
                html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td>");
                html.append("<td align=right>");
                html.append(stats.approvedSegments);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.approvedWords);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.approvedCharsNoWhites);
                html.append("</td>");
                html.append("<td align=right>");
                html.append((int)stats.approvedChars);
                html.append("</td>");
                proc = stats.getApprovedPercent();
                procString = nf.format(proc) + "%";
                html.append("<td align=right>");
                html.append(procString);
                html.append("</td>");
                html.append("</tr>");
            }
            if (stats.rejectedSegments > 0) {
                rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REJECTED SEGMENTS");
                html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td>");
                html.append("<td align=right>");
                html.append(stats.rejectedSegments);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.rejectedWords);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.rejectedCharsNoWhites);
                html.append("</td>");
                html.append("<td align=right>");
                html.append((int)stats.rejectedChars);
                html.append("</td>");
                proc = stats.getRejectedPercent();
                procString = nf.format(proc) + "%";
                html.append("<td align=right>");
                html.append(procString);
                html.append("</td>");
                html.append("</tr>");
            }
            rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ALL SEGMENTS");
            html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td>");
            html.append("<td align=right>");
            html.append(stats.allSegments);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.allSourceWords);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.allSourceCharsNoWhites);
            html.append("</td>");
            html.append("<td align=right>");
            html.append((int)stats.allSourceChars);
            html.append("</td>");
            html.append("<td align=right>");
            html.append("100%");
            html.append("</td>");
            rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPEATED SEGMENTS");
            html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td>");
            html.append("<td align=right>");
            html.append(stats.repeatedSegments);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.repeatedWords);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.repeatedCharsNoWhites);
            html.append("</td>");
            html.append("<td align=right>");
            html.append((int)stats.repeatedChars);
            html.append("</td>");
            proc = stats.getRepetionPercent();
            procString = nf.format(proc) + "%";
            html.append("<td align=right>");
            html.append(procString);
            html.append("</td>");
            html.append("</tr>");
            if (!AppPreferences.updateProjectStatistics) {
                rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SUBSEGMENT REPETITIONS (HOMOGENEITY)");
                html.append("<tr><td style=\"color:white; background-color:#555555\" align=right><b>" + rs + "</b></td><td color=black bgcolor=#F0F0F0></td>");
                html.append("<td align=right>");
                html.append(stats.repeatedInternalWords);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.repeatedInternalCharsNoWhites);
                html.append("</td>");
                html.append("<td align=right>");
                html.append(stats.repeatedInternalChars);
                html.append("</td>");
                proc = stats.getInternalRepetionPercent();
                procString = nf.format(proc) + "%";
                html.append("<td align=right>");
                html.append(procString);
                html.append("</td>");
                html.append("</tr>");
            }
            rs = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET SEGMENTS");
            html.append("<tr><td style=\"color:white; background-color:#660066\" align=right><b>" + rs + "</b></td><td></td>");
            html.append("<td align=right>");
            html.append(stats.allTargetWords);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.allTargetCharsNoWhites);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.allTargetChars);
            html.append("</td>");
            html.append("<td align=right></td>");
            html.append("</table>");
            html.append(HTMLFormat.startTableStats2);
            html.append("<tr><th style=\"color:white; background-color:#444444\">");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RATE"));
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\">");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE SEGMENTS"));
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\">");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET SEGMENTS"));
            html.append("</th>");
            html.append("<th style=\"background-color:#444444\">");
            html.append("<a href=\"register\" style=\"color:yellow; font-size:").append(AppPreferences.UIFontSizeHTML).append(";\"><b><u>").append(this.register);
            html.append("</u></th>");
            html.append("</tr>");
            html.append("<tr>");
            if (AppPreferences.billing.length() > 0) {
                StringBuilder sb = new StringBuilder();
                boolean singular = true;
                String[] sfields = AppPreferences.billing.split("\\s");
                for (int i = 0; i < sfields.length; ++i) {
                    String field = sfields[i];
                    if (i == 0 && !field.equals("1")) {
                        singular = false;
                    } else if (i == 1 && singular) {
                        field = field.substring(0, field.length() - 1);
                    } else if (i == 2) {
                        field = "= " + field;
                    }
                    sb.append(field);
                    if (i >= sfields.length - 1) continue;
                    sb.append("&nbsp;");
                }
                html.append("<td align=right>");
                html.append("<a href=\"rate\" style=\"font-size:").append(AppPreferences.UIFontSizeHTML).append(";\"><b>").append(sb.toString().trim());
            } else {
                html.append("<td align=right>");
                html.append("<a href=\"rate\" style=\"font-size:").append(AppPreferences.UIFontSizeHTML).append(";\"><b>Click to set your rate</b>");
            }
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.getSourceBillingMessage());
            html.append("</td>");
            html.append("<td align=right>");
            html.append(stats.getTargetBillingMessage());
            html.append("</td>");
            html.append("</tr>");
            html.append("</table>");
            Workflow process = manager.getWorkflow();
            if (process != null) {
                String[] pace;
                String count;
                WordCount wc;
                String s;
                String start = process.getStartTime();
                String pduration = process.getProjectDuration();
                String sduration = process.getSessionDuration();
                html.append(HTMLFormat.startTableStats2);
                if (start != null) {
                    s = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("START TIME");
                    html.append("<tr>");
                    html.append("<td style=\"color:white; background-color:#555555\" align=right>");
                    html.append("<b>" + s + "</b></td>");
                    html.append("<td align=left>");
                    html.append(start);
                    html.append("</td>");
                    html.append("</tr>");
                }
                if (pduration != null) {
                    s = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT DURATION");
                    html.append("<tr>");
                    html.append("<td style=\"color:white; background-color:#555555\" align=right>");
                    html.append("<b>" + s + "</b></td>");
                    html.append("<td align=left>");
                    html.append(pduration);
                    html.append("</td>");
                    html.append("</tr>");
                }
                if (sduration != null && !sduration.equals(pduration)) {
                    s = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SESSION DURATION");
                    html.append("<tr>");
                    html.append("<td style=\"color:white; background-color:#555555\" align=right>");
                    html.append("<b>" + s + "</b></td>");
                    html.append("<td align=left>");
                    html.append(sduration);
                    html.append("</td>");
                    html.append("</tr>");
                }
                if ((wc = process.getWordCount()) != null && (count = wc.getCountMessage()) != null && (pace = process.getPace()) != null) {
                    String s2 = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPEED IN THIS SESSION");
                    html.append("<tr>");
                    html.append("<td style=\"color:white; background-color:#555555\" align=right>");
                    html.append("<b>" + s2 + "</b></td>");
                    html.append("<td align=left>");
                    html.append(pace[2]);
                    if (count.length() > 0) {
                        html.append("&nbsp;&nbsp;");
                        html.append(count);
                    }
                    html.append("</td>");
                    html.append("</tr>");
                    if (pace[0] != null) {
                        s2 = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPEED PER MINUTE");
                        html.append("<tr>");
                        html.append("<td style=\"color:white; background-color:#555555\" align=right>");
                        html.append("<b>" + s2 + "</b></td>");
                        html.append("<td align=left>");
                        html.append(pace[0]);
                        html.append("</td>");
                        html.append("</tr>");
                    }
                    if (pace[1] != null) {
                        s2 = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPEED PER HOUR");
                        html.append("<tr>");
                        html.append("<td style=\"color:white; background-color:#555555\" align=right>");
                        html.append("<b>" + s2 + "</b></td>");
                        html.append("<td align=left>");
                        html.append(pace[1]);
                        html.append("</td>");
                        html.append("</tr>");
                    }
                }
                html.append("</table>");
            }
            return html.toString();
        }
        return null;
    }

    public String statsMemoryToHTML(String memName, MemoryStatistics stats) {
        int total = stats.total;
        if (total > 0) {
            int allWords = 0;
            StringBuilder html = new StringBuilder();
            html.append(HTMLFormat.startTableStats2);
            html.append("<tr><th align=right colspan=4 style='color:white; background-color:#000000'><i>");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY STATISTICS").toUpperCase());
            html.append(": ").append(memName);
            html.append("</i></th></tr>");
            html.append("<tr><th style=\"color:white; background-color:#444444\">");
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\">");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTS"));
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\">");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORDS"));
            html.append("</th>");
            html.append("<th style=\"color:white; background-color:#444444\">");
            html.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PERCENT"));
            html.append("</th>");
            html.append("</tr>");
            int no = stats.context;
            int words = stats.contextW;
            String w = Integer.toString(words);
            allWords += words;
            float proc = stats.contextL * 100.0f / stats.totalLength;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            String sproc = nf.format(proc) + "%";
            String s = Integer.toString(no);
            String t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONTEXT MATCHES");
            html.append("<tr><td width=50% align=right style=\"color:white; background-color:#660066\"><b>" + t + "</b></td>");
            html.append("<td align=right>");
            html.append(s);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(w);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(sproc);
            html.append("</td>");
            html.append("</tr>");
            no = stats.exact;
            words = stats.exactW;
            w = Integer.toString(words);
            allWords += words;
            proc = stats.exactL * 100.0f / stats.totalLength;
            nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            sproc = nf.format(proc) + "%";
            s = Integer.toString(no);
            t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXACT MATCHES");
            html.append("<tr><td width=50% align=right style=\"color:white; background-color:#000D66\"><b>" + t + "</b></td>");
            html.append("<td align=right>");
            html.append(s);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(w);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(sproc);
            html.append("</td>");
            html.append("</tr>");
            no = stats.fuzzy1;
            words = stats.fuzzy1W;
            w = Integer.toString(words);
            allWords += words;
            proc = stats.fuzzy1L * 100.0f / stats.totalLength;
            nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            sproc = nf.format(proc) + "%";
            s = Integer.toString(no);
            t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FUZZY MATCHES 95% - 100%");
            html.append("<tr><td width=50% align=right style=\"color:white; background-color:#555555\"><b>" + t + "</b></td>");
            html.append("<td align=right>");
            html.append(s);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(w);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(sproc);
            html.append("</td>");
            html.append("</tr>");
            no = stats.fuzzy2;
            words = stats.fuzzy2W;
            w = Integer.toString(words);
            allWords += words;
            proc = stats.fuzzy2L * 100.0f / stats.totalLength;
            nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            sproc = nf.format(proc) + "%";
            s = Integer.toString(no);
            t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FUZZY MATCHES 85% - 94%");
            html.append("<tr><td width=50% align=right style=\"color:white; background-color:#666666\"><b>" + t + "</b></td>");
            html.append("<td align=right>");
            html.append(s);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(w);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(sproc);
            html.append("</td>");
            html.append("</tr>");
            no = stats.fuzzy3;
            words = stats.fuzzy3W;
            w = Integer.toString(words);
            allWords += words;
            proc = stats.fuzzy3L * 100.0f / stats.totalLength;
            nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            sproc = nf.format(proc) + "%";
            s = Integer.toString(no);
            t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FUZZY MATCHES 75% - 84%");
            html.append("<tr><td width=50% align=right style=\"color:white; background-color:#777777\"><b>" + t + "</b></td>");
            html.append("<td align=right>");
            html.append(s);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(w);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(sproc);
            html.append("</td>");
            html.append("</tr>");
            no = stats.fuzzy4;
            words = stats.fuzzy4W;
            w = Integer.toString(words);
            allWords += words;
            proc = stats.fuzzy4L * 100.0f / stats.totalLength;
            nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            sproc = nf.format(proc) + "%";
            s = Integer.toString(no);
            t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FUZZY MATCHES 50% - 74%");
            html.append("<tr><td width=50% align=right style=\"color:white; background-color:#888888\"><b>" + t + "</b></td>");
            html.append("<td align=right>");
            html.append(s);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(w);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(sproc);
            html.append("</td>");
            html.append("</tr>");
            no = stats.noMatch;
            words = stats.noMatchW;
            w = Integer.toString(words);
            allWords += words;
            proc = stats.noMatchL * 100.0f / stats.totalLength;
            nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            sproc = nf.format(proc) + "%";
            s = Integer.toString(no);
            t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO MATCHES");
            html.append("<tr><td width=50% align=right style=\"color:white; background-color:#999999\"><b>" + t + "</b></td>");
            html.append("<td align=right>");
            html.append(s);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(w);
            html.append("</td>");
            html.append("<td align=right>");
            html.append(sproc);
            html.append("</td>");
            html.append("</tr>");
            t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ALL MATCHES");
            html.append("<tr><td width=50% align=right style=\"color:white; background-color:black\"><b>" + t + "</b></td>");
            html.append("<td align=right>");
            html.append("" + total);
            html.append("</td>");
            html.append("<td align=right>");
            html.append("" + allWords);
            html.append("</td>");
            html.append("<td align=right>");
            html.append("100%");
            html.append("</td>");
            html.append("</tr>");
            html.append("</table>");
            return html.toString();
        }
        return null;
    }

    private void copyStatistics() {
        Project p = this.topui.getProjectView().getProject();
        if (!AppPreferences.clipboard && p.mode != 3) {
            JTextPane pane = this.htmlViewer.getTextPane();
            pane.selectAll();
            pane.copy();
            pane.select(0, 0);
        }
    }

    private void setHTMLViewer() {
        this.htmlViewer = new TextResource();
        this.htmlViewer.setMainView(this.topui);
        this.htmlViewer.setStatisticsView();
        this.htmlViewer.newHTMLDocument(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STATISTICS"));
        JTextPane pane = this.htmlViewer.getTextPane();
        pane.addHyperlinkListener(new StatisticsHyperactive());
    }

    public void updateProjectStatistics() {
        if (this.htmlViewer == null) {
            this.setHTMLViewer();
        }
        SwingWorker worker = new SwingWorker(){
            String s = null;

            public String doInBackground() {
                this.s = StatisticsView.this.statsProjectToHTML2(false);
                return null;
            }

            @Override
            protected void done() {
                if (this.s != null) {
                    this.s = "<html>" + HTMLFormat.styles + "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body>" + this.s + "</body></html>";
                    StatisticsView.this.htmlViewer.showStatistics(this.s);
                    StatisticsView.this.statsHTML = this.s;
                    StatisticsView.this.fileName = "Project_Statistics.html";
                    if (StatisticsView.this.progressBar == null) {
                        StatisticsView.this.progressBar = new JProgressBar();
                        StatisticsView.this.progressBar.setBorder(BorderFactory.createEmptyBorder());
                        StatisticsView.this.progressBar.setBackground(StatisticsView.this.topui.getMainPanelBackgroundColor());
                        Color c = new Color(AppPreferences.iconsColor).darker();
                        StatisticsView.this.progressBar.setForeground(c);
                        StatisticsView.this.progressBar.setUI(new KodoProgressBarUI());
                        StatisticsView.this.progressBar.setToolTipText("Translated");
                        StatisticsView.this.progressBar.setStringPainted(true);
                        Dimension d = StatisticsView.this.progressBar.getPreferredSize();
                        StatisticsView.this.progressBar.setPreferredSize(new Dimension(100, d.height));
                        StatisticsView.this.topui.getProjectView().getToolBar().add((Component)StatisticsView.this.progressBar, 1);
                        StatisticsView.this.topui.getProjectView().getToolBar().revalidate();
                        StatisticsView.this.topui.getProjectView().getToolBar().repaint();
                    }
                    if (StatisticsView.this.progress.length() > 1) {
                        StatisticsView.this.progress = StatisticsView.this.progress.substring(0, StatisticsView.this.progress.length() - 1);
                        int f = (int)Float.parseFloat(StatisticsView.this.progress);
                        StatisticsView.this.progressBar.setValue(f);
                    }
                }
            }
        };
        worker.execute();
    }

    private void saveStatistics() {
        if (this.statsHTML == null) {
            this.statsHTML = this.statsProjectToHTML2(false);
            if (this.statsHTML == null) {
                return;
            }
            this.fileName = "ProjectStatistics.html";
        }
        if (this.fileName == null) {
            return;
        }
        Project project = this.topui.getProjectView().getProject();
        String path = project.getProjectPath();
        if (path == null) {
            path = System.getProperty("user.home");
        } else {
            File file = new File(path);
            path = file.getParent();
        }
        final File pf = new File(path);
        String statPath = path + AppPreferences.fs + this.fileName;
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ StatisticsView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        FileChooser fileChooser = new FileChooser();
                        if (pf.isDirectory() && pf.canRead()) {
                            fileChooser.setInitialDirectory(pf);
                        }
                        if (this.this$0.fileName != null) {
                            fileChooser.setInitialFileName(this.this$0.fileName);
                        }
                        if ((file = fileChooser.showSaveDialog(null)) != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 8 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this$0.saveFile(file);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 8 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(pf);
            jFileChooser.setSelectedFile(new File(statPath));
            if (0 == jFileChooser.showSaveDialog(this.topui)) {
                File file = jFileChooser.getSelectedFile();
                this.saveFile(file);
            }
        }
    }

    private void saveFile(File file) {
        try {
            Charset chars = Charset.forName("UTF-8");
            CharsetEncoder encoder = chars.newEncoder();
            FileOutputStream fos = new FileOutputStream(file);
            FileChannel fc = fos.getChannel();
            CharBuffer cb = CharBuffer.wrap(this.statsHTML.toCharArray());
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeHTMLViewer() {
        this.htmlViewer = null;
    }

    private void showMemoryStatisticsMenu(JMenu menu) {
        List localMems = this.topui.getMemoryView().getLocalMemories();
        for (Memory mem : localMems) {
            String name = mem.getName();
            JMenuItem file = new JMenuItem(new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent a) {
                    JMenuItem mitem = (JMenuItem)a.getSource();
                    final Memory m = (Memory)mitem.getClientProperty("memory");
                    final Project p = StatisticsView.this.topui.getProjectView().getProject();
                    if (p == null) {
                        return;
                    }
                    if (!m.isActive()) {
                        MemoryStatistics stats = m.getMemoryStatistics();
                        stats.reset();
                        int endPos = p.getCurrentUnitsNumber();
                        m.initMemoryProgress(0, endPos, "");
                        m.setActive(true);
                        MySwingWorker worker = new MySwingWorker(this){
                            final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public Object construct() {
                                p.analyse(m);
                                return null;
                            }

                            @Override
                            public void finished() {
                                m.removeMemoryProgress();
                                m.setActive(false);
                                MemoryStatistics stats = m.getMemoryStatistics();
                                String s = this.this$1.StatisticsView.this.statsMemoryToHTML(m.getName(), stats);
                                if (s != null) {
                                    s = "<html>" + HTMLFormat.styles + "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body>" + s + "</body></html>";
                                    if (this.this$1.StatisticsView.this.htmlViewer == null) {
                                        this.this$1.StatisticsView.this.setHTMLViewer();
                                    }
                                    this.this$1.StatisticsView.this.htmlViewer.showStatistics(s);
                                    stats.reset();
                                    this.this$1.StatisticsView.this.statsHTML = s;
                                    this.this$1.StatisticsView.this.fileName = m.getName() + "_Statistics.html";
                                    this.this$1.StatisticsView.this.copyStatistics();
                                }
                            }
                        };
                        worker.start();
                    }
                }
            });
            file.putClientProperty("memory", mem);
            menu.add(file);
        }
    }

    void register() {
        Billing b = new Billing();
        b.setName("bill:billing");
        DefaultXMLElement order = new DefaultXMLElement();
        order.setName("bill:order");
        try {
            int number = Integer.parseInt(AppPreferences.orderNumber);
            order.setAttribute("number", Integer.toString(++number));
        }
        catch (NumberFormatException number) {
            // empty catch block
        }
        Date d = new Date();
        String odate = DateFormat.getDateTimeInstance().format(d);
        order.setAttribute("date", odate);
        odate = DateFormat.getDateInstance().format(d);
        order.setAttribute("return-date", odate);
        order.setContent(0, "");
        b.setOrder(order);
        DefaultXMLElement bdoc = new DefaultXMLElement();
        bdoc.setName("bill:document");
        bdoc.setAttribute("language", AppPreferences.billingSource);
        bdoc.setAttribute("name", "");
        bdoc.setContent(0, "");
        b.setDocument(bdoc);
        DefaultXMLElement bjob = new DefaultXMLElement();
        bjob.setName("bill:job");
        bjob.setAttribute("language", AppPreferences.billingTarget);
        bjob.setAttribute("type", AppPreferences.billingService);
        b.setJob(bjob);
        DefaultXMLElement breg = new DefaultXMLElement();
        breg.setName("bill:register");
        breg.setAttribute("layout", AppPreferences.registerLayout);
        breg.setAttribute("file", AppPreferences.registerFile);
        breg.setAttribute("state", "new");
        b.setRegister(breg);
        boolean cancel = this.showBilling(b);
    }

    private boolean showBilling(Billing b) {
        BillingEditor dlg = new BillingEditor(this.topui, b, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BILLING EDITOR"));
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        return dlg.cancelled;
    }

    public void pauseStatistics(boolean p) {
        AppPreferences.pauseProjectStatistics = p;
        this.pause = p;
        WorkflowManager manager = this.topui.getWorkflowView().getWorkflowManager();
        Workflow wf = manager.getWorkflow();
        if (wf != null) {
            wf.pauseSessionTime(p);
        }
    }

    class StatisticsHyperactive
    implements HyperlinkListener {
        StatisticsHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String s = e.getDescription();
                if (s != null && s.equals("rate")) {
                    BillingChooser dlg = new BillingChooser(StatisticsView.this.topui, null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE YOUR RATE"), true);
                    Dimension dlgSize = dlg.getPreferredSize();
                    Dimension frmSize = StatisticsView.this.topui.getSize();
                    Point loc = StatisticsView.this.topui.getLocationOnScreen();
                    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                    dlg.setVisible(true);
                } else if (s != null && s.equals("register")) {
                    StatisticsView.this.register();
                } else if (s != null && s.equals("stop")) {
                    StatisticsView.this.pauseStatistics(true);
                    StatisticsView.this.updateProjectStatistics();
                } else if (s != null && s.equals("start")) {
                    StatisticsView.this.pauseStatistics(false);
                    StatisticsView.this.updateProjectStatistics();
                }
            }
        }
    }
}

