/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.DictionaryResource;
import translator.GlossaryResource;
import translator.KeyPreferences;
import translator.MT;
import translator.MainView;
import translator.MatchBoard;
import translator.Project;
import translator.Resource;
import translator.SynchronizedResource;
import translator.TextResource;
import translator.TrackingChanges;
import translator.WorkflowView;
import translator.ai.CTLinguist;
import translator.browser.WebResourceFX;
import translator.database.TermBase;
import translator.server.RemoteMemory;
import translator.tmx.Memory;
import translator.translatables.TextDocument;
import translator.ui.Colors;
import translator.ui.DnDTabbedPane;
import translator.ui.GridPanel;
import translator.ui.kodo.KodoTabbedPaneUI;
import translator.web.Proz;
import translator.web.TMTown;

public class TabView
extends GridPanel {
    private MainView topui;
    private DnDTabbedPane jTab;
    private JPopupMenu pop;
    private static Map joinedTabsMap;
    private static Map floatingFramesMap;
    private JToolBar alignBar;
    private JMenu alignMenu;

    TabView(MainView topui) {
        this.topui = topui;
        if (AppPreferences.alpha != -1) {
            this.setOpaque(false);
            this.setGrid(true);
            this.setTransparent(true);
            Color c = new Color(AppPreferences.background);
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), AppPreferences.alpha);
            this.setBackground(color);
        } else {
            this.setOpaque(true);
            this.setGrid(AppPreferences.backGrid);
            if (AppPreferences.background != 0) {
                this.setBackground(new Color(AppPreferences.background));
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initComponents();
        TabView.createJoinResourcesMap();
        TabView.createFloatingFramesMap();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.jTab = new DnDTabbedPane();
        if (AppPreferences.bottomTabs) {
            this.jTab.setTabPlacement(3);
        }
        if (AppPreferences.wrapTabs) {
            this.jTab.setTabLayoutPolicy(0);
        } else {
            this.jTab.setTabLayoutPolicy(1);
        }
        if (!AppPreferences.laf.equals("Nimbus")) {
            KodoTabbedPaneUI ui = new KodoTabbedPaneUI();
            if (AppPreferences.tforeground == -16777216) {
                ui.setTabBackground(GridPanel.darker(this.topui.getMainPanelBackgroundColor(), 0.92));
            } else {
                ui.setTabBackground(GridPanel.brighter(this.topui.getMainPanelBackgroundColor(), 0.75));
            }
            ui.setTabForeground(new Color(AppPreferences.toolBarsForeground));
            this.jTab.setUI(ui);
        }
        this.jTab.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.jTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    int i = TabView.this.jTab.getTabLayoutPolicy();
                    if (i == 1) {
                        TabView.this.jTab.setTabLayoutPolicy(0);
                    } else {
                        TabView.this.jTab.setTabLayoutPolicy(1);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    int x = evt.getX();
                    int y = evt.getY();
                    int k = TabView.this.jTab.indexAtLocation(x, y);
                    if (k != -1) {
                        TabView.this.createPopUpMenu(k);
                        TabView.this.pop.show(evt.getComponent(), x + 2, y);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    int x = evt.getX();
                    int y = evt.getY();
                    int k = TabView.this.jTab.indexAtLocation(x, y);
                    if (k != -1) {
                        TabView.this.createPopUpMenu(k);
                        TabView.this.pop.show(evt.getComponent(), x + 2, y);
                    }
                }
            }
        });
    }

    public JTabbedPane getTabbedPane() {
        return this.jTab;
    }

    public int getTabCount() {
        int i = this.jTab.getTabCount();
        return i;
    }

    public synchronized void addTab(Object res, String name, Component comp) {
        Object[] arr;
        Object o;
        FontIcon ficon;
        FontIcon ficon2;
        boolean align = false;
        Project pr = this.topui.getProjectView().getProject();
        if (pr != null) {
            align = pr.align;
        }
        if (this.indexOfTab(name) != -1) {
            name = name + "*";
        }
        if (comp != null && comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.putClientProperty("resource", res);
        } else {
            this.jTab.putClientProperty(name, res);
        }
        String title = name;
        if (title.length() > 40 && !align) {
            title = title.substring(0, 40) + "...";
        }
        boolean grid = false;
        if (res instanceof MatchBoard) {
            comp = (MatchBoard)res;
            ficon2 = FontIcon.of((Ikon)MaterialDesign.MDI_BINOCULARS, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
            this.jTab.addTab(title, (Icon)ficon2, comp, name);
        } else if (AppPreferences.windowsLayout == 6 && name.equals("Grid")) {
            ficon2 = FontIcon.of((Ikon)MaterialDesign.MDI_GRID, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
            this.jTab.insertTab(title, (Icon)ficon2, comp, name, 0);
            grid = true;
        } else {
            this.jTab.addTab(title, null, comp, name);
        }
        int tcount = this.jTab.getTabCount();
        if (tcount == 1) {
            this.add((Component)this.jTab, "Center");
        }
        if (!grid) {
            this.jTab.setSelectedIndex(tcount - 1);
        } else {
            this.jTab.setSelectedIndex(0);
        }
        if (res instanceof TrackingChanges) {
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FORMAT_STRIKETHROUGH, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
            this.jTab.setIconAt(tcount - 1, (Icon)ficon);
        } else if (res instanceof TermBase) {
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DATABASE, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
            this.jTab.setIconAt(tcount - 1, (Icon)ficon);
        } else if (res instanceof TextDocument) {
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FILE_DOCUMENT, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
            this.jTab.setIconAt(tcount - 1, (Icon)ficon);
        } else if (res instanceof Memory || res instanceof RemoteMemory) {
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
            this.jTab.setIconAt(tcount - 1, (Icon)ficon);
        } else if (res instanceof Resource) {
            FontIcon ficon3;
            if (res instanceof WebResourceFX) {
                WebResourceFX fxres = (WebResourceFX)res;
                if (fxres.isMTWebResurces() || fxres.isQAWebResurces()) {
                    ficon3 = FontIcon.of((Ikon)MaterialDesign.MDI_TRANSLATE, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                    this.jTab.setIconAt(tcount - 1, (Icon)ficon3);
                } else {
                    ficon3 = FontIcon.of((Ikon)MaterialDesign.MDI_WEB, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                    this.jTab.setIconAt(tcount - 1, (Icon)ficon3);
                }
            } else if (res instanceof TextResource) {
                TextResource tres = (TextResource)res;
                if (tres.isShowingStatistics()) {
                    ficon3 = FontIcon.of((Ikon)MaterialDesign.MDI_CHART_BAR, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                    this.jTab.setIconAt(tcount - 1, (Icon)ficon3);
                } else if (tres.isDocumentNote()) {
                    ficon3 = FontIcon.of((Ikon)MaterialDesign.MDI_COMMENT, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                    this.jTab.setIconAt(tcount - 1, (Icon)ficon3);
                } else if (name.equals("DST")) {
                    ficon3 = FontIcon.of((Ikon)MaterialDesign.MDI_BINOCULARS, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                    this.jTab.setIconAt(tcount - 1, (Icon)ficon3);
                } else {
                    ficon3 = FontIcon.of((Ikon)MaterialDesign.MDI_WEB, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                    this.jTab.setIconAt(tcount - 1, (Icon)ficon3);
                }
            } else if (res instanceof GlossaryResource) {
                ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PENCIL, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                this.jTab.setIconAt(tcount - 1, (Icon)ficon);
            } else if (res instanceof Proz || res instanceof TMTown) {
                ficon = FontIcon.of((Ikon)MaterialDesign.MDI_WEB, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                this.jTab.setIconAt(tcount - 1, (Icon)ficon);
            } else if (res instanceof MT) {
                ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TRANSLATE, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                this.jTab.setIconAt(tcount - 1, (Icon)ficon);
            } else if (res instanceof CTLinguist) {
                ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SIGMA, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                this.jTab.setIconAt(tcount - 1, (Icon)ficon);
            } else {
                ficon = FontIcon.of((Ikon)MaterialDesign.MDI_WEB, (int)AppPreferences.toolBarButtonsFontSize, (Color)Colors.getIconsColor());
                this.jTab.setIconAt(tcount - 1, (Icon)ficon);
            }
        }
        if (joinedTabsMap != null && (o = joinedTabsMap.get(name)) != null) {
            String arr1;
            arr = (String[])o;
            boolean allTabsPresent = true;
            for (int i = 0; i < arr.length && (arr1 = arr[i]) != null; ++i) {
                int j;
                int or = arr1.lastIndexOf(58);
                if (or != -1) {
                    arr1 = arr1.substring(0, or);
                }
                if ((j = this.indexOfTab(arr1)) != -1) continue;
                allTabsPresent = false;
                break;
            }
            if (allTabsPresent) {
                int i;
                int or2;
                String s = arr[0];
                String s2 = arr[1];
                String o1 = "-1";
                String o2 = "-1";
                int or1 = s.lastIndexOf(58);
                if (or1 != -1) {
                    o1 = s.substring(or1 + 1);
                    s = s.substring(0, or1);
                }
                if ((or2 = s2.lastIndexOf(58)) != -1) {
                    o2 = s2.substring(or2 + 1);
                    s2 = s2.substring(0, or2);
                }
                if ((i = this.indexOfTab(s)) != -1) {
                    int j = this.indexOfTab(s2);
                    if (j != -1) {
                        int orient;
                        joinedTabsMap.remove(s);
                        joinedTabsMap.remove(s2);
                        try {
                            orient = Integer.valueOf(o1);
                        }
                        catch (NumberFormatException e) {
                            orient = -1;
                        }
                        this.topui.synchronizeViews(i, j, orient);
                        for (int k = 2; k < arr.length; ++k) {
                            int orient3;
                            String s3 = arr[k];
                            if (s3 == null) continue;
                            String o3 = "-1";
                            int or3 = s3.lastIndexOf(58);
                            if (or3 != -1) {
                                o3 = s3.substring(or3 + 1);
                                s3 = s3.substring(0, or3);
                            }
                            if ((j = this.indexOfTab(s3)) == -1) continue;
                            joinedTabsMap.remove(s3);
                            int tabIndex = this.jTab.getSelectedIndex();
                            if (tabIndex == -1) continue;
                            try {
                                orient3 = Integer.valueOf(o3);
                            }
                            catch (NumberFormatException e) {
                                orient3 = -1;
                            }
                            this.topui.synchronizeViews(tabIndex, j, orient3);
                        }
                    }
                    return;
                }
            }
        }
        if (floatingFramesMap != null && (o = floatingFramesMap.get(name)) != null) {
            arr = (int[])o;
            int i = this.jTab.getSelectedIndex();
            if (i != -1) {
                this.topui.floatTab(i, (int[])arr);
            }
        }
    }

    public synchronized void removeTab(String name) {
        int index = this.indexOfTab(name);
        if (index == -1) {
            return;
        }
        this.jTab.putClientProperty(name, null);
        this.jTab.removeTabAt(index);
        index = this.jTab.getTabCount();
        if (index == 0) {
            this.remove(this.jTab);
            this.repaint();
        }
    }

    public synchronized void removeTab(String id, String name) {
        int index = this.indexOfTab(id);
        if (index == -1) {
            return;
        }
        this.jTab.putClientProperty(name, null);
        this.jTab.removeTabAt(index);
        index = this.jTab.getTabCount();
        if (index == 0) {
            this.remove(this.jTab);
            this.repaint();
        }
    }

    public void removeCurrentTab() {
        int index = this.jTab.getSelectedIndex();
        if (index == -1) {
            return;
        }
        String name = this.getCurrentName();
        if (name != null && (name.equals("Matchboard") || name.equals("Grid"))) {
            return;
        }
        if (this.jTab.getSelectedComponent() == null) {
            String title = this.jTab.getToolTipTextAt(index);
            this.jTab.putClientProperty(title, null);
        }
        this.jTab.removeTabAt(index);
        index = this.jTab.getTabCount();
        if (index == 0) {
            this.remove(this.jTab);
            this.repaint();
        }
    }

    public static void createFloatingFramesMap() {
        if (AppPreferences.autoFloat.length() > 0) {
            floatingFramesMap = new HashMap(2);
            String[] arr = AppPreferences.autoFloat.indexOf(124) != -1 ? AppPreferences.autoFloat.split("\\|") : new String[]{AppPreferences.autoFloat};
            if (arr != null && arr.length > 0) {
                for (int i = 0; i < arr.length; ++i) {
                    String s = arr[i];
                    int k = s.indexOf(58);
                    if (k == -1) continue;
                    String name = s.substring(0, k);
                    String s2 = s.substring(k + 1);
                    if (s2.indexOf(44) == -1) continue;
                    int[] dim = new int[4];
                    int t = 0;
                    String[] arr2 = s2.split(",");
                    for (int j = 0; j < arr2.length; ++j) {
                        String p = arr2[j];
                        dim[t] = Integer.parseInt(p);
                        ++t;
                    }
                    floatingFramesMap.put(name, dim);
                }
            }
        } else if (floatingFramesMap != null) {
            floatingFramesMap.clear();
        }
    }

    public static void createJoinResourcesMap() {
        if (AppPreferences.joinedTabsNames.length() > 0) {
            joinedTabsMap = new HashMap(4);
            String[] arr = AppPreferences.joinedTabsNames.indexOf(124) != -1 ? AppPreferences.joinedTabsNames.split("\\|") : new String[]{AppPreferences.joinedTabsNames};
            if (arr != null && arr.length > 0) {
                for (int i = 0; i < arr.length; ++i) {
                    String s = arr[i];
                    String o = ":-1";
                    int j = s.lastIndexOf(58);
                    if (j != -1) {
                        o = s.substring(j);
                        s = s.substring(0, j);
                    }
                    int k = s.indexOf(" - ");
                    String[] arr2 = new String[10];
                    int t = 0;
                    while (k != -1 && t < 10) {
                        String s1 = s.substring(0, k);
                        arr2[t] = s1 + o;
                        joinedTabsMap.put(s1, arr2);
                        if ((k = (s = s.substring(k + 3)).indexOf(" - ")) != -1 || s.length() <= 0 || ++t >= 10) continue;
                        arr2[t] = s + o;
                        joinedTabsMap.put(s, arr2);
                    }
                }
            }
        } else if (joinedTabsMap != null) {
            joinedTabsMap.clear();
        }
    }

    public void unsynchronizeTabs() {
        Resource resource = this.getCurrentResource();
        if (resource != null && resource instanceof SynchronizedResource) {
            this.removeCurrentTab();
            SynchronizedResource synchRes = (SynchronizedResource)resource;
            this.unsynchronize(synchRes);
            this.validate();
        }
    }

    private void unsynchronize(SynchronizedResource synchRes) {
        int i;
        String fullName;
        SynchronizedResource synch;
        Component leftComp = synchRes.getLeftComponent();
        Component rightComp = synchRes.getRightComponent();
        Object leftRes = synchRes.getLeftResource();
        Object rightRes = synchRes.getRightResource();
        if (leftRes != null && leftRes instanceof SynchronizedResource) {
            synch = (SynchronizedResource)leftRes;
            this.unsynchronize(synch);
        } else {
            String leftName = null;
            fullName = synchRes.getName();
            i = fullName.indexOf(" - ");
            leftName = fullName.substring(0, i);
            this.addTab(leftRes, leftName, leftComp);
        }
        if (rightRes != null && rightRes instanceof SynchronizedResource) {
            synch = (SynchronizedResource)rightRes;
            this.unsynchronize(synch);
        } else {
            String rightName = null;
            fullName = synchRes.getName();
            i = fullName.lastIndexOf(" - ");
            rightName = fullName.substring(i + 3, fullName.length());
            this.addTab(rightRes, rightName, rightComp);
        }
    }

    private void changeSynchronizedTabsOrientation() {
        Resource resource = this.getCurrentResource();
        if (resource != null && resource instanceof SynchronizedResource) {
            SynchronizedResource sres = (SynchronizedResource)resource;
            sres.changeOrientation(null);
        }
    }

    public String getSynchronizedTabsNames() {
        StringBuilder sb = new StringBuilder();
        int count = this.jTab.getTabCount();
        for (int i = 0; i < count; ++i) {
            Resource res = this.getResourceAtIndex(i);
            if (res == null || !(res instanceof SynchronizedResource)) continue;
            SynchronizedResource sres = (SynchronizedResource)res;
            String s = sres.getName();
            int o = sres.getOrientation();
            if (s == null || s.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(s);
            sb.append(':');
            sb.append(Integer.toString(o));
        }
        String s = this.topui.getDockName1();
        if (s != null && s.indexOf(" - ") != -1) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(s);
        }
        if ((s = this.topui.getDockName6()) != null && s.indexOf(" - ") != -1) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(s);
        }
        if ((s = this.topui.getDockName2()) != null && s.indexOf(" - ") != -1) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(s);
        }
        if ((s = this.topui.getDockName3()) != null && s.indexOf(" - ") != -1) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(s);
        }
        if ((s = this.topui.getDockName4()) != null && s.indexOf(" - ") != -1) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(s);
        }
        if ((s = this.topui.getDockName5()) != null && s.indexOf(" - ") != -1) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void autoDockAll() {
        String tabName;
        int i;
        int pos;
        String name;
        int j;
        String string;
        if (AppPreferences.autodockName1.length() > 0) {
            string = AppPreferences.autodockName1;
            j = string.lastIndexOf(58);
            if (j != -1) {
                name = string.substring(0, j);
                String spos = string.substring(j + 1);
                pos = Integer.valueOf(spos);
            } else {
                name = AppPreferences.autodockName1;
                pos = -1;
            }
            i = this.indexOfTab(name);
            if (i != -1 && (tabName = this.jTab.getToolTipTextAt(i)).equals(name)) {
                this.topui.dockToSegmentsView(i, pos, true);
            }
        }
        if (AppPreferences.autodockName2.length() > 0) {
            string = AppPreferences.autodockName2;
            j = string.lastIndexOf(58);
            if (j != -1) {
                name = string.substring(0, j);
                String spos = string.substring(j + 1);
                pos = Integer.valueOf(spos);
            } else {
                name = AppPreferences.autodockName2;
                pos = -1;
            }
            i = this.indexOfTab(name);
            if (i != -1 && (tabName = this.jTab.getToolTipTextAt(i)).equals(name)) {
                this.topui.dockToGridView(i, pos, true);
            }
        }
        if (AppPreferences.autodockName3.length() > 0) {
            string = AppPreferences.autodockName3;
            j = string.lastIndexOf(58);
            if (j != -1) {
                name = string.substring(0, j);
                String spos = string.substring(j + 1);
                pos = Integer.valueOf(spos);
            } else {
                name = AppPreferences.autodockName3;
                pos = -1;
            }
            i = this.indexOfTab(name);
            if (i != -1 && (tabName = this.jTab.getToolTipTextAt(i)).equals(name)) {
                this.topui.dockToTabsView(i, pos, true);
            }
        }
        if (AppPreferences.dockedTabsNames.length() > 0) {
            String[] arr = AppPreferences.dockedTabsNames.split("\\|");
            for (int i2 = 0; i2 < arr.length; ++i2) {
                String tabName2;
                string = arr[i2];
                if (string.length() <= 0 || (j = string.lastIndexOf(58)) == -1) continue;
                String name2 = string.substring(0, j);
                String spos = string.substring(j + 1);
                int pos2 = Integer.valueOf(spos);
                int k = this.indexOfTab(name2);
                if (k == -1 || !(tabName2 = this.jTab.getToolTipTextAt(k)).equals(name2)) continue;
                this.topui.dockToMainView(k, pos2, true);
            }
        }
    }

    public boolean tabExists(String name) {
        return this.indexOfTab(name) != -1;
    }

    private int indexOfTab(String name) {
        int ind = -1;
        int c = this.jTab.getTabCount();
        if (c > 0 && name != null) {
            int i;
            for (i = 0; i < c; ++i) {
                String id;
                Component comp = this.jTab.getComponentAt(i);
                if (comp == null || (id = comp.getName()) == null || !id.equals(name)) continue;
                ind = i;
                break;
            }
            if (ind == -1) {
                for (i = 0; i < c; ++i) {
                    String string = this.jTab.getToolTipTextAt(i);
                    if (string == null || !string.equals(name)) continue;
                    ind = i;
                    break;
                }
            }
        }
        return ind;
    }

    public boolean selectTab(String name) {
        int i = this.indexOfTab(name);
        if (i != -1) {
            this.jTab.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public void setCurrentName(String name) {
        int index = this.jTab.getSelectedIndex();
        if (index != -1) {
            String title = this.jTab.getToolTipTextAt(index);
            Component comp = this.jTab.getSelectedComponent();
            if (comp == null || !(comp instanceof JComponent)) {
                Object o = this.jTab.getClientProperty(title);
                this.jTab.putClientProperty(name, null);
                this.jTab.putClientProperty(name, o);
            }
            if ((title = name).length() > 40) {
                title = title.substring(0, 40) + "...";
            }
            this.jTab.setTitleAt(index, title);
            this.jTab.setToolTipTextAt(index, name);
            this.jTab.repaint();
        }
    }

    public String getCurrentName() {
        String name = null;
        int ind = this.jTab.getSelectedIndex();
        if (ind != -1) {
            name = this.jTab.getToolTipTextAt(ind);
            return name;
        }
        return "";
    }

    public Component getCurrentWindow() {
        JComponent comp = (JComponent)this.jTab.getSelectedComponent();
        return comp;
    }

    public Resource getCurrentResource() {
        Resource res = null;
        int index = this.jTab.getSelectedIndex();
        if (index != -1) {
            Component comp = this.jTab.getSelectedComponent();
            if (comp != null && comp instanceof JComponent) {
                JComponent jcomp = (JComponent)comp;
                Object o = jcomp.getClientProperty("resource");
                if (o != null && o instanceof Resource) {
                    res = (Resource)o;
                }
            } else {
                String title = this.jTab.getToolTipTextAt(index);
                Object o = this.jTab.getClientProperty(title);
                if (o != null && o instanceof Resource) {
                    res = (Resource)o;
                }
            }
        }
        return res;
    }

    public Resource getResourceAtIndex(int index) {
        Resource res = null;
        Component comp = this.jTab.getComponentAt(index);
        if (comp != null && comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            Object o = jcomp.getClientProperty("resource");
            if (o != null && o instanceof Resource) {
                res = (Resource)o;
            }
        } else {
            String title = this.jTab.getToolTipTextAt(index);
            Object o = this.jTab.getClientProperty(title);
            if (o != null && o instanceof Resource) {
                res = (Resource)o;
            }
        }
        return res;
    }

    public void selectGlossaryTab(DictionaryResource glossary) {
        Resource r = this.getCurrentResource();
        if (r == null || !(r instanceof DictionaryResource)) {
            int count = this.jTab.getTabCount();
            for (int i = 0; i < count; ++i) {
                if (!this.isGlossaryAtIndex(glossary, i)) continue;
                this.jTab.setSelectedIndex(i);
                break;
            }
        }
    }

    public void selectMemoryTab(Memory memory) {
        Memory m = this.getCurrentMemory();
        if (m == null) {
            int count = this.jTab.getTabCount();
            for (int i = 0; i < count; ++i) {
                if (!this.isMemoryAtIndex(memory, i)) continue;
                this.jTab.setSelectedIndex(i);
                break;
            }
        }
    }

    public void selectResourceTab(Resource resource) {
        Resource r = this.getCurrentResource();
        if (r == null || !r.equals(resource)) {
            int count = this.jTab.getTabCount();
            for (int i = 0; i < count; ++i) {
                r = this.getResourceAtIndex(i);
                if (r == null || !r.equals(resource)) continue;
                this.jTab.setSelectedIndex(i);
                break;
            }
        }
    }

    public void selectResourceTab(int type) {
        Resource r;
        if (!(type != 6 && type != 7 || (r = this.getCurrentResource()) != null && r instanceof TermBase)) {
            int count = this.jTab.getTabCount();
            for (int i = 0; i < count; ++i) {
                r = this.getResourceAtIndex(i);
                if (r == null || !(r instanceof TermBase)) continue;
                this.jTab.setSelectedIndex(i);
                break;
            }
        }
    }

    private boolean hasSynchTabGlossary(SynchronizedResource sr, DictionaryResource g) {
        SynchronizedResource srr;
        DictionaryResource gr = null;
        Object lo = sr.getLeftResource();
        Object ro = sr.getRightResource();
        if (lo != null && lo instanceof DictionaryResource && (gr = (DictionaryResource)lo).equals(g)) {
            return true;
        }
        if (ro != null && ro instanceof DictionaryResource && (gr = (DictionaryResource)ro).equals(g)) {
            return true;
        }
        if (lo instanceof SynchronizedResource && this.hasSynchTabGlossary(srr = (SynchronizedResource)lo, g)) {
            return true;
        }
        return ro instanceof SynchronizedResource && this.hasSynchTabGlossary(srr = (SynchronizedResource)ro, g);
    }

    private boolean hasSynchTabMemory(SynchronizedResource sr, Memory m) {
        SynchronizedResource srr;
        Memory mem = null;
        Object lo = sr.getLeftResource();
        Object ro = sr.getRightResource();
        if (lo != null && lo instanceof Memory && (mem = (Memory)lo).equals(m)) {
            return true;
        }
        if (ro != null && ro instanceof Memory && (mem = (Memory)ro).equals(m)) {
            return true;
        }
        if (lo instanceof SynchronizedResource && this.hasSynchTabMemory(srr = (SynchronizedResource)lo, m)) {
            return true;
        }
        return ro instanceof SynchronizedResource && this.hasSynchTabMemory(srr = (SynchronizedResource)ro, m);
    }

    private Memory getSynchMemory(SynchronizedResource sr) {
        SynchronizedResource srr;
        Memory mem = null;
        Object lo = sr.getLeftResource();
        Object ro = sr.getRightResource();
        if (lo != null && lo instanceof Memory) {
            mem = (Memory)lo;
            return mem;
        }
        if (ro != null && ro instanceof Memory) {
            mem = (Memory)ro;
            return mem;
        }
        if (lo instanceof SynchronizedResource && (mem = this.getSynchMemory(srr = (SynchronizedResource)lo)) != null) {
            return mem;
        }
        if (ro instanceof SynchronizedResource && (mem = this.getSynchMemory(srr = (SynchronizedResource)ro)) != null) {
            return mem;
        }
        return mem;
    }

    public Memory getCurrentMemory() {
        Memory tm = null;
        int index = this.jTab.getSelectedIndex();
        if (index != -1) {
            Component comp = this.jTab.getSelectedComponent();
            if (comp != null && comp instanceof JComponent) {
                JComponent jcomp = (JComponent)comp;
                Object o = jcomp.getClientProperty("resource");
                if (o != null) {
                    if (o instanceof Memory) {
                        tm = (Memory)o;
                    } else if (o instanceof SynchronizedResource) {
                        SynchronizedResource sr = (SynchronizedResource)o;
                        tm = this.getSynchMemory(sr);
                    }
                }
            } else {
                String title = this.jTab.getToolTipTextAt(index);
                Object o = this.jTab.getClientProperty(title);
                if (o != null && o instanceof Memory) {
                    tm = (Memory)o;
                }
            }
        }
        return tm;
    }

    public boolean isMemoryAtIndex(Memory m, int index) {
        String title;
        SynchronizedResource sr;
        JComponent jcomp;
        Object o;
        Memory tm = null;
        Component comp = this.jTab.getComponentAt(index);
        return comp != null && comp instanceof JComponent ? (o = (jcomp = (JComponent)comp).getClientProperty("resource")) != null && (o instanceof Memory ? (tm = (Memory)o).equals(m) : o instanceof SynchronizedResource && this.hasSynchTabMemory(sr = (SynchronizedResource)o, m)) : (o = this.jTab.getClientProperty(title = this.jTab.getToolTipTextAt(index))) != null && o instanceof Memory && (tm = (Memory)o).equals(m);
    }

    public boolean isGlossaryAtIndex(DictionaryResource g, int index) {
        String title;
        SynchronizedResource sr;
        JComponent jcomp;
        Object o;
        DictionaryResource gr = null;
        Component comp = this.jTab.getComponentAt(index);
        return comp != null && comp instanceof JComponent ? (o = (jcomp = (JComponent)comp).getClientProperty("resource")) != null && (o instanceof DictionaryResource ? (gr = (DictionaryResource)o).equals(g) : o instanceof SynchronizedResource && this.hasSynchTabGlossary(sr = (SynchronizedResource)o, g)) : (o = this.jTab.getClientProperty(title = this.jTab.getToolTipTextAt(index))) != null && o instanceof DictionaryResource && (gr = (DictionaryResource)o).equals(g);
    }

    public void createPopUpMenu(final int k) {
        SynchronizedResource sres;
        int o;
        int j;
        int kk = k + 1;
        this.pop = new JPopupMenu();
        String title = this.jTab.getToolTipTextAt(k);
        JMenuItem item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCK TAB TO WINDOW VERTICALLY - RIGHT"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.topui.dockToMainView(k, 2, false);
            }
        });
        if (this.topui.getDockName4() != null) {
            item.setEnabled(false);
        }
        this.pop.add(item);
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCK TAB TO WINDOW VERTICALLY - LEFT"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.topui.dockToMainView(k, 4, false);
            }
        });
        if (this.topui.getDockName2() != null) {
            item.setEnabled(false);
        }
        this.pop.add(item);
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCK TAB TO WINDOW HORIZONTALLY"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.topui.dockToMainView(k, 1, false);
            }
        });
        if (this.topui.getDockName5() != null) {
            item.setEnabled(false);
        }
        this.pop.add(item);
        this.pop.addSeparator();
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCK TAB TO SEGMENT EDITORS"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.topui.dockToSegmentsView(k, -1, false);
            }
        });
        if (this.topui.splitDockOne != null) {
            item.setEnabled(false);
        }
        this.pop.add(item);
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCK TAB TO TABBED PANEL"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.topui.dockToTabsView(k, -1, false);
            }
        });
        if (this.topui.splitDockThree != null) {
            item.setEnabled(false);
        }
        this.pop.add(item);
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCK TAB TO SEGMENTS GRID"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.topui.dockToGridView(k, -1, false);
            }
        });
        if (this.topui.splitDockTwo != null) {
            item.setEnabled(false);
        }
        this.pop.add(item);
        JCheckBoxMenuItem dividerDocksItem = new JCheckBoxMenuItem();
        dividerDocksItem.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VERTICAL DOCKING DIVIDER"));
        dividerDocksItem.setSelected(AppPreferences.dockingVerticalDivider);
        dividerDocksItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.dockingVerticalDivider = !AppPreferences.dockingVerticalDivider;
            }
        });
        this.pop.add(dividerDocksItem);
        this.pop.addSeparator();
        JMenu moveMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCK TAB TO..."));
        int i = this.jTab.getTabCount();
        for (j = 0; j < i; ++j) {
            if (j == k || j == kk || (title = this.jTab.getToolTipTextAt(j)).equals("Project")) continue;
            item = new JMenuItem(title);
            if (k > j) {
                item.putClientProperty("index", j);
            } else {
                item.putClientProperty("index", j - 1);
            }
            item.addActionListener(new ActionListener(){
                final /* synthetic */ TabView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem mitem = (JMenuItem)e.getSource();
                    int index = (Integer)mitem.getClientProperty("index");
                    Component comp = this.this$0.jTab.getComponentAt(k);
                    Icon icon = this.this$0.jTab.getIconAt(k);
                    String title = this.this$0.jTab.getTitleAt(k);
                    String name = this.this$0.jTab.getToolTipTextAt(k);
                    this.this$0.jTab.removeTabAt(k);
                    this.this$0.jTab.insertTab(title, icon, comp, name, index);
                    this.this$0.jTab.setSelectedIndex(index);
                }
            });
            moveMenu.add(item);
        }
        JMenu synchMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN TABS..."));
        this.pop.add(synchMenu);
        for (j = 0; j < i; ++j) {
            if (j == k || (title = this.jTab.getToolTipTextAt(j)).equals("Project")) continue;
            item = new JMenuItem(title);
            if (k > j) {
                item.putClientProperty("index", j);
            } else {
                item.putClientProperty("index", j - 1);
            }
            item.addActionListener(new ActionListener(){
                final /* synthetic */ TabView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem mitem = (JMenuItem)e.getSource();
                    int index = (Integer)mitem.getClientProperty("index");
                    Component comp = this.this$0.jTab.getComponentAt(k);
                    Icon icon = this.this$0.jTab.getIconAt(k);
                    String title = this.this$0.jTab.getTitleAt(k);
                    String name = this.this$0.jTab.getToolTipTextAt(k);
                    this.this$0.jTab.removeTabAt(k);
                    this.this$0.jTab.insertTab(title, icon, comp, name, index);
                    this.this$0.jTab.setSelectedIndex(index);
                    this.this$0.topui.synchronizeViews();
                }
            });
            synchMenu.add(item);
        }
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DISJOIN TABS"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabView.this.unsynchronizeTabs();
            }
        });
        this.pop.add(item);
        JCheckBoxMenuItem dividerTabsItem = new JCheckBoxMenuItem();
        dividerTabsItem.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VERTICAL TABS DIVIDER"));
        Resource resource = this.getCurrentResource();
        boolean vertical = resource != null && resource instanceof SynchronizedResource ? (o = (sres = (SynchronizedResource)resource).getOrientation()) == 1 : AppPreferences.tabsVerticalDivider;
        dividerTabsItem.setSelected(vertical);
        dividerTabsItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int i = e.getStateChange();
                AppPreferences.tabsVerticalDivider = i == 1;
                TabView.this.changeSynchronizedTabsOrientation();
            }
        });
        this.pop.add(dividerTabsItem);
        this.pop.addSeparator();
        this.pop.add(moveMenu);
        this.pop.addSeparator();
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FLOAT"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.topui.floatTab(k, null);
            }
        });
        this.pop.add(item);
        this.pop.addSeparator();
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE ALL TABS"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabView.this.closeAllTabs();
            }
        });
        this.pop.add(item);
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE OTHER TABS"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.closeOtherTabs(k);
            }
        });
        this.pop.add(item);
        item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE TAB"));
        item.addActionListener(new ActionListener(){
            final /* synthetic */ TabView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jTab.setSelectedIndex(k);
                this.this$0.topui.getResourceView().close();
            }
        });
        this.pop.add(item);
    }

    void closeOtherTabs(int k) {
        int i = this.jTab.getTabCount() - 1;
        while (i > -1) {
            if (i != k) {
                this.jTab.setSelectedIndex(i);
                String name = this.jTab.getToolTipTextAt(i);
                if (name != null && (name.equals("Matchboard") || name.equals("Grid"))) {
                    --i;
                    continue;
                }
                Resource r = this.getCurrentResource();
                if (!(r instanceof MT)) {
                    this.topui.getResourceView().close();
                }
            }
            --i;
        }
    }

    void closeAllTabs() {
        int i = this.jTab.getTabCount() - 1;
        while (i > -1) {
            this.jTab.setSelectedIndex(i);
            String name = this.jTab.getToolTipTextAt(i);
            if (name != null && (name.equals("Matchboard") || name.equals("Grid"))) {
                --i;
                continue;
            }
            Resource r = this.getCurrentResource();
            if (r instanceof SynchronizedResource) {
                this.unsynchronizeTabs();
                i = this.jTab.getTabCount() - 1;
                continue;
            }
            if (!(r instanceof TMTown) && !(r instanceof Proz)) {
                this.topui.getResourceView().close();
            }
            --i;
        }
        i = this.jTab.getTabCount() - 1;
        if (i != -1) {
            this.jTab.setSelectedIndex(i);
        }
    }

    public void setAlignmentBar(boolean autoAlign) {
        if (this.alignBar != null) {
            return;
        }
        this.alignBar = new JToolBar();
        this.alignBar.setFloatable(false);
        if (AppPreferences.alpha != -1) {
            this.alignBar.setOpaque(false);
        } else {
            this.alignBar.setOpaque(true);
        }
        if (AppPreferences.tbackground2 != 0) {
            if (!AppPreferences.backGrid) {
                this.alignBar.setBackground(this.topui.getMainPanelBackgroundColor());
            } else {
                this.alignBar.setBackground(GridPanel.darker(this.topui.getMainPanelBackgroundColor(), 0.92));
            }
        }
        JButton buttonNext = new JButton("1");
        buttonNext.setFont(buttonNext.getFont().deriveFont(1, AppPreferences.toolBarButtonsFontSize));
        buttonNext.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonNext.setOpaque(false);
        buttonNext.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT_BOLD_CIRCLE_OUTLINE, (int)(buttonNext.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonNext.setIcon((Icon)ficon);
        buttonNext.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEXT SOURCE SEGMENT"));
        buttonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.next(1);
            }
        });
        JButton buttonAppend = new JButton("1");
        buttonAppend.setFont(buttonNext.getFont().deriveFont(1, AppPreferences.toolBarButtonsFontSize));
        buttonAppend.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonAppend.setOpaque(false);
        buttonAppend.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CALL_MERGE, (int)(buttonAppend.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonAppend.setIcon((Icon)ficon);
        buttonAppend.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN SOURCE SEGMENTS"));
        buttonAppend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.append(1);
            }
        });
        JButton buttonAdd = new JButton("1");
        buttonAdd.setFont(buttonNext.getFont().deriveFont(1, AppPreferences.toolBarButtonsFontSize));
        buttonAdd.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonAdd.setOpaque(false);
        buttonAdd.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE_TO_GO, (int)(buttonAdd.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonAdd.setIcon((Icon)ficon);
        buttonAdd.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD TO MEMORY AND NEXT SOURCE SEGMENT"));
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.add(1, false);
            }
        });
        JButton buttonDelete = new JButton();
        buttonDelete.setName("MenuTransActionDeleteSegment");
        buttonDelete.setOpaque(false);
        buttonDelete.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DELETE_FOREVER, (int)(buttonDelete.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonDelete.setIcon((Icon)ficon);
        buttonDelete.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE SEGMENT"));
        buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.delete();
            }
        });
        JButton buttonNext2 = new JButton("2");
        buttonNext2.setFont(buttonNext.getFont().deriveFont(1, AppPreferences.toolBarButtonsFontSize));
        buttonNext2.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonNext2.setOpaque(false);
        buttonNext2.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT_BOLD_CIRCLE_OUTLINE, (int)(buttonNext2.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonNext2.setIcon((Icon)ficon);
        buttonNext2.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEXT TARGET SEGMENT"));
        buttonNext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.next(2);
            }
        });
        JButton buttonAppend2 = new JButton("2");
        buttonAppend2.setFont(buttonNext.getFont().deriveFont(1, AppPreferences.toolBarButtonsFontSize));
        buttonAppend2.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonAppend2.setOpaque(false);
        buttonAppend2.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CALL_MERGE, (int)(buttonAppend2.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonAppend2.setIcon((Icon)ficon);
        buttonAppend2.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN TARGET SEGMENTS"));
        buttonAppend2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.append(2);
            }
        });
        JButton buttonAdd2 = new JButton("2");
        buttonAdd2.setFont(buttonNext.getFont().deriveFont(1, AppPreferences.toolBarButtonsFontSize));
        buttonAdd2.setForeground(new Color(AppPreferences.toolBarsForeground));
        buttonAdd2.setOpaque(false);
        buttonAdd2.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE_TO_GO, (int)(buttonAdd2.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonAdd2.setIcon((Icon)ficon);
        buttonAdd2.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD TO MEMORY AND NEXT TARGET SEGMENT"));
        buttonAdd2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.add(2, false);
            }
        });
        if (autoAlign) {
            this.alignBar.add(buttonAppend);
            this.alignBar.add(buttonDelete);
            this.alignBar.add(buttonAppend2);
        } else {
            this.alignBar.add(buttonNext);
            this.alignBar.add(buttonAppend);
            this.alignBar.add(buttonAdd);
            this.alignBar.add(buttonDelete);
            this.alignBar.add(buttonNext2);
            this.alignBar.add(buttonAppend2);
            this.alignBar.add(buttonAdd2);
        }
        if (!AppPreferences.targetToolbarPosition) {
            this.topui.getTargetView().add((Component)this.alignBar, "North");
        } else {
            this.topui.getTargetView().add((Component)this.alignBar, "South");
        }
        this.topui.getTargetView().validate();
        this.topui.getTargetView().repaint();
    }

    public void setAlignmentMenu(boolean autoAlign) {
        if (this.alignMenu != null) {
            return;
        }
        this.alignMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ALIGNMENT"));
        JMenuItem buttonNext = new JMenuItem();
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT_BOLD_CIRCLE_OUTLINE, (int)buttonNext.getFont().getSize(), (Color)buttonNext.getForeground());
        buttonNext.setIcon((Icon)ficon);
        buttonNext.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEXT SOURCE SEGMENT"));
        buttonNext.setAccelerator(KeyStroke.getKeyStroke(112, AppPreferences.modifier));
        buttonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.next(1);
            }
        });
        JMenuItem buttonAppend = new JMenuItem();
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CALL_MERGE, (int)buttonAppend.getFont().getSize(), (Color)buttonAppend.getForeground());
        buttonAppend.setIcon((Icon)ficon);
        buttonAppend.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN SOURCE SEGMENTS"));
        buttonAppend.setAccelerator(KeyStroke.getKeyStroke(113, AppPreferences.modifier));
        buttonAppend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.append(1);
            }
        });
        JMenuItem buttonAdd = new JMenuItem();
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE_TO_GO, (int)buttonAdd.getFont().getSize(), (Color)buttonAdd.getForeground());
        buttonAdd.setIcon((Icon)ficon);
        buttonAdd.setAccelerator(KeyStroke.getKeyStroke(114, AppPreferences.modifier));
        buttonAdd.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD TO MEMORY AND NEXT SOURCE SEGMENT"));
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.add(1, false);
            }
        });
        JMenuItem buttonNext2 = new JMenuItem();
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT_BOLD_CIRCLE_OUTLINE, (int)buttonNext2.getFont().getSize(), (Color)buttonNext2.getForeground());
        buttonNext2.setIcon((Icon)ficon);
        buttonNext2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEXT TARGET SEGMENT"));
        buttonNext2.setAccelerator(KeyStroke.getKeyStroke(121, AppPreferences.modifier));
        buttonNext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.next(2);
            }
        });
        JMenuItem buttonAppend2 = new JMenuItem();
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CALL_MERGE, (int)buttonAppend2.getFont().getSize(), (Color)buttonAppend2.getForeground());
        buttonAppend2.setIcon((Icon)ficon);
        buttonAppend2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN TARGET SEGMENTS"));
        buttonAppend2.setAccelerator(KeyStroke.getKeyStroke(122, AppPreferences.modifier));
        buttonAppend2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.append(2);
            }
        });
        JMenuItem buttonAdd2 = new JMenuItem();
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE_TO_GO, (int)buttonAdd2.getFont().getSize(), (Color)buttonAdd2.getForeground());
        buttonAdd2.setIcon((Icon)ficon);
        buttonAdd2.setAccelerator(KeyStroke.getKeyStroke(123, AppPreferences.modifier));
        buttonAdd2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD TO MEMORY AND NEXT TARGET SEGMENT"));
        buttonAdd2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.add(2, false);
            }
        });
        JMenuItem buttonClose = new JMenuItem();
        buttonClose.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE ALIGNMENT INTERFACE"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)buttonClose.getFont().getSize(), (Color)buttonClose.getForeground());
        buttonClose.setIcon((Icon)ficon);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabView.this.closeAlignmentUI();
            }
        });
        JMenuItem buttonDelete = new JMenuItem();
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DELETE_FOREVER, (int)buttonDelete.getFont().getSize(), (Color)buttonDelete.getForeground());
        buttonDelete.setIcon((Icon)ficon);
        KeyStroke ks = KeyPreferences.getKeyStroke("k107");
        if (ks != null) {
            buttonDelete.setAccelerator(ks);
        }
        buttonDelete.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE SEGMENT"));
        buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TabView.this.topui.getWorkflowView();
                flow.delete();
            }
        });
        if (autoAlign) {
            this.alignMenu.add(buttonAppend);
            this.alignMenu.add(buttonDelete);
            this.alignMenu.add(buttonAppend2);
            this.alignMenu.addSeparator();
            this.alignMenu.add(buttonClose);
        } else {
            this.alignMenu.add(buttonNext);
            this.alignMenu.add(buttonAppend);
            this.alignMenu.add(buttonAdd);
            this.alignMenu.add(buttonDelete);
            this.alignMenu.add(buttonNext2);
            this.alignMenu.add(buttonAppend2);
            this.alignMenu.add(buttonAdd2);
            this.alignMenu.addSeparator();
            this.alignMenu.add(buttonClose);
        }
        this.topui.getMainMenubar().add((Component)this.alignMenu, 8);
        this.topui.getMainMenubar().validate();
    }

    public JToolBar getAlignmentBar() {
        return this.alignBar;
    }

    public void closeAlignmentUI() {
        if (this.alignBar != null) {
            this.topui.getTargetView().remove(this.alignBar);
            this.topui.getTargetView().validate();
            this.alignBar = null;
        }
        if (this.alignMenu != null) {
            this.topui.getMainMenubar().remove(this.alignMenu);
            this.topui.getMainMenubar().validate();
            this.alignMenu = null;
        }
    }
}

