/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.FileFilters;
import translator.FormatChooser;
import translator.MainView;
import translator.MySwingWorker;
import translator.MyUndoListener;
import translator.Project;
import translator.ScrollPaneWatermark;
import translator.StatisticsView;
import translator.TabView;
import translator.text.ParagraphEditorKit;
import translator.text.ParagraphStyledDocument;
import translator.xliff.XLIFF;
import translator.xliff.XliffFile;

public class TextResource
extends DefaultResource {
    public MainView topui;
    private JTextPane textPane;
    private boolean edit = false;
    private ParagraphStyledDocument doc = null;
    private String encoding = "UTF-8";
    private boolean paragraphView = true;
    boolean fileNote = false;
    boolean nontranslatables = false;
    boolean statistics = false;
    public String name;
    private MySwingWorker worker;
    protected MyUndoListener undoHandler;

    public void setStatisticsView() {
        this.edit = false;
        this.paragraphView = false;
        this.statistics = true;
    }

    public void showStatistics(String s) {
        HTMLDocument hdoc = (HTMLDocument)this.textPane.getDocument();
        try {
            hdoc.setInnerHTML(hdoc.getDefaultRootElement(), s);
            this.textPane.setCaretPosition(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void editDocumentNote(String note) {
        this.paragraphView = false;
        this.fileNote = true;
        if (this.textPane == null) {
            this.newDocument(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT NOTE"));
        }
        if (note != null) {
            Document doc = this.getDocument();
            try {
                if (doc.getLength() > 0) {
                    doc.remove(0, doc.getLength());
                }
                doc.insertString(0, note, null);
                Boolean state = false;
                doc.putProperty("state", state);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean isDocumentNote() {
        return this.fileNote;
    }

    public void editNonTranslatables() {
        this.nontranslatables = true;
    }

    public boolean isEditNonTranslatables() {
        return this.nontranslatables;
    }

    public boolean isShowingStatistics() {
        return this.statistics;
    }

    public void setParagraphView(boolean view) {
        this.paragraphView = view;
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
    }

    private void createHTMLEditorTab(String name) {
        this.name = name;
        JScrollPane scroll = this.createEditorTextComponent(null);
        TabView tview = this.topui.getTabView();
        tview.addTab(this, name, scroll);
    }

    private void createEditorTab(String name) {
        this.name = name;
        this.edit = true;
        ParagraphStyledDocument doc = new ParagraphStyledDocument();
        doc.putProperty("name", name);
        this.setDocumentProperties(doc);
        JScrollPane scroll = this.createEditorTextComponent(doc);
        TabView tview = this.topui.getTabView();
        tview.addTab(this, name, scroll);
    }

    private JScrollPane createEditorTextComponent(StyledDocument doc) {
        File file;
        this.textPane = new JTextPane();
        if (this.paragraphView) {
            this.textPane.setEditorKit(new ParagraphEditorKit());
        }
        if (this.statistics) {
            this.textPane.setContentType("text/html");
        }
        if (doc != null) {
            this.textPane.setDocument(doc);
        }
        if (!this.edit) {
            this.textPane.setEditable(false);
        }
        Graphics g = this.textPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.textPane.setCaretColor(foreground);
            this.textPane.setBackground(background);
            this.textPane.setForeground(foreground);
            this.textPane.setSelectedTextColor(foreground);
            this.textPane.setSelectionColor(selection);
        }
        this.textPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        if (!this.paragraphView) {
            this.textPane.setMargin(new Insets(16, 32, 16, 32));
        }
        this.textPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextResource.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                try {
                    int dot = e.getDot();
                    JTextComponent textP = (JTextComponent)e.getSource();
                    Rectangle2D r0 = textP.modelToView2D(dot);
                    if (r0 == null) {
                        return;
                    }
                    Rectangle r = textP.getVisibleRect();
                    int w = (int)r.getWidth();
                    int h = (int)r.getHeight();
                    int x = (int)r.getX();
                    int y = (int)r.getY();
                    int y0 = (int)r0.getY();
                    if (!textP.isFocusOwner()) {
                        r = new Rectangle(x, y0 - h / 2, w, h);
                        textP.scrollRectToVisible(r);
                    } else if (y0 - y + 40 >= h) {
                        r = new Rectangle(x, y0 - h / 5, w, h);
                        textP.scrollRectToVisible(r);
                    } else if (y0 < 40) {
                        r = new Rectangle(0, 0, w, h);
                        textP.scrollRectToVisible(r);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.textPane.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextResource.this.undoHandler.undoAction();
            }
        });
        this.textPane.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextResource.this.undoHandler.redoAction();
            }
        });
        this.textPane.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.textPane.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.textPane.setOpaque(false);
            this.textPane.setBackground(new Color(0, 0, 0, 0));
        }
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.textPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.textPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return jScrollPane;
    }

    public void setDocumentProperties(Document doc) {
        Boolean state = new Boolean(false);
        doc.putProperty("state", state);
        this.undoHandler = new MyUndoListener();
        this.undoHandler.setLimit(100);
        doc.addUndoableEditListener(this.undoHandler);
        doc.putProperty("undohandler", this.undoHandler);
        Boolean save = new Boolean(true);
        doc.putProperty("save", save);
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextResource.this.doc_insertUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextResource.this.doc_removeUpdate(e);
            }
        });
    }

    private void doc_changedUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            state = true;
            doc.putProperty("state", state);
        }
    }

    private void doc_insertUpdate(DocumentEvent e) {
        StyledDocument doc = (StyledDocument)e.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            state = true;
            doc.putProperty("state", state);
        }
    }

    private void doc_removeUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            state = true;
            doc.putProperty("state", state);
        }
    }

    public void openEditorTab(StyledDocument doc) {
        String fname;
        this.name = fname = (String)doc.getProperty("name");
        JScrollPane scroll = this.createEditorTextComponent(doc);
        TabView tview = this.topui.getTabView();
        tview.addTab(this, fname, scroll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadTextFile(File file, String encoding) {
        FileInputStream fis = null;
        try {
            Charset charset = Charset.isSupported(encoding) ? Charset.forName(encoding) : Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            ByteBuffer bb = ByteBuffer.allocateDirect(sz);
            fc.read(bb);
            ByteBuffer buffer = bb;
            ((Buffer)buffer).flip();
            CharBuffer cb = decoder.decode(bb);
            fc.close();
            String string = cb.toString();
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
            JLabel statusBar = this.topui.getMainStatusBar();
            statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public void openFile(File file, String encoding) {
        final StringBuffer texts = new StringBuffer();
        String outString = this.loadTextFile(file, encoding);
        texts.append(outString);
        this.edit = true;
        this.encoding = encoding;
        GapContent gap = new GapContent(texts.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ TextResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.doc.insertString(0, texts.toString(), null);
                    texts.setLength(0);
                    this.this$0.doc.setContents();
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.this$0.setDocumentProperties(this.this$0.doc);
                this.this$0.getTextPane().requestFocusInWindow();
            }
        });
    }

    protected boolean saveFile() {
        Document doc = null;
        doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return false;
        }
        String path = (String)doc.getProperty("path");
        if (path == null) {
            return this.saveAsFile();
        }
        if (path.length() == 0) {
            return false;
        }
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        File file = new File(path);
        return this.saveFile(file, doc);
    }

    protected boolean saveAsFile() {
        Document doc = this.getDocument();
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        JFileChooser jFileChooser = new JFileChooser();
        FileFilters filters = new FileFilters();
        String filterName = AppPreferences.format;
        filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE DOCUMENT"));
        jFileChooser.setCurrentDirectory(new File(AppPreferences.fileDirectory));
        String fs = (String)doc.getProperty("path");
        String tlang = (String)doc.getProperty("target-lang");
        if (fs == null) {
            fs = "";
        }
        if (tlang != null) {
            int ind = fs.lastIndexOf(".");
            if (ind != -1) {
                String ext = fs.substring(ind);
                fs = fs.substring(0, ind) + "_" + tlang + ext;
            } else {
                fs = fs + tlang;
            }
        }
        jFileChooser.setSelectedFile(new File(fs));
        jFileChooser.repaint();
        if (0 == jFileChooser.showSaveDialog(this.topui)) {
            int i;
            File newFile = jFileChooser.getSelectedFile();
            AppPreferences.fileDirectory = newFile.getParent();
            String oldpath = (String)doc.getProperty("path");
            String path = newFile.getPath();
            doc.putProperty("path", path);
            doc.putProperty("file", newFile);
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            if (oldpath != null) {
                docs.remove(oldpath);
            }
            docs.add(path);
            String oname = (String)doc.getProperty("name");
            String name = newFile.getName();
            TabView tview = this.topui.getTabView();
            JTabbedPane tabpane = tview.getTabbedPane();
            if (oname != null && (i = tabpane.indexOfTab(oname)) != -1) {
                tabpane.setTitleAt(i, name);
            }
            doc.putProperty("name", name);
            return this.saveFile(newFile, doc);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadAsText(File file, String encoding) {
        FileInputStream fis = null;
        InputStreamReader reader = null;
        String s = null;
        try {
            int bufferSize = 4096;
            fis = new FileInputStream(file);
            reader = new InputStreamReader((InputStream)fis, encoding);
            char[] buffer = new char[bufferSize];
            int offset = 0;
            while (true) {
                int numRead;
                int remain;
                if ((remain = buffer.length - offset) <= 0) {
                    char[] newBuffer = new char[buffer.length * 2];
                    System.arraycopy(buffer, 0, newBuffer, 0, offset);
                    buffer = newBuffer;
                    remain = buffer.length - offset;
                }
                if ((numRead = reader.read(buffer, offset, remain)) == -1) break;
                offset += numRead;
            }
            s = new String(buffer, 0, offset);
        }
        catch (IOException ex) {
            Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return s;
    }

    public static void storeAsText(File tempFile, String text, String enc) {
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, enc));
            awriter.write(text);
            awriter.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFile(File tempFile, String text, String enc) {
        FileOutputStream fos = null;
        try {
            Charset charset = Charset.isSupported(enc) ? Charset.forName(enc) : Charset.forName("UTF-8");
            CharsetEncoder encoder = charset.newEncoder();
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            fos = new FileOutputStream(tempFile);
            FileChannel fc = fos.getChannel();
            CharBuffer cb = CharBuffer.wrap(text.toCharArray());
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            fos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveText(File file, String text, String enc) {
        try {
            File tempFile = File.createTempFile("Exp", file.getName(), file.getParentFile());
            this.storeFile(tempFile, text, enc);
            if (file.exists()) {
                file.delete();
            }
            if (tempFile.renameTo(file)) return;
        }
        catch (IOException ex) {
            Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean saveFile(File file, Document doc) {
        try {
            Object texts = null;
            String text = doc.getText(0, doc.getLength());
            File tempFile = File.createTempFile("Backup", file.getName(), file.getParentFile());
            this.storeFile(tempFile, text, this.encoding);
            if (file.exists()) {
                file.delete();
            }
            if (tempFile.renameTo(file)) {
                Boolean state = false;
                doc.putProperty("state", state);
            } else {
                JLabel statusBar = this.topui.getMainStatusBar();
                statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANNOT RENAME FILE"));
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JLabel statusBar = this.topui.getMainStatusBar();
            statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING FILE"));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JLabel statusBar = this.topui.getMainStatusBar();
            statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING FILE"));
        }
        return false;
    }

    private boolean okToAbandon() {
        if (this.textPane != null && !this.textPane.isEditable()) {
            return true;
        }
        Document doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return true;
        }
        String title = this.name;
        if (title == null || title.length() == 0) {
            title = "CafeTran document";
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE CHANGES IN THE DOCUMENT?"), title, 0);
        switch (value) {
            case 0: {
                if (this.isDocumentNote()) {
                    this.saveDocumentNote();
                    return true;
                }
                return this.saveFile();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public Document getDocument() {
        Document doc = this.textPane.getDocument();
        return doc;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void newDocument(String name) {
        this.createEditorTab(name);
    }

    public void newHTMLDocument(String name) {
        this.createHTMLEditorTab(name);
    }

    @Override
    public void newResource() {
        this.createEditorTab(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW"));
    }

    @Override
    public void openResource() {
    }

    public void saveDocumentNote() {
        XliffFile xliffFile;
        XLIFF xliff;
        Project p;
        String s;
        Document doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return;
        }
        try {
            s = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
            s = null;
        }
        if (s != null && s.length() > 0 && (p = this.topui.getProjectView().getProject()) != null && (xliff = p.getXLIFF()) != null && xliff.isCafeTranXLIFF && (xliffFile = xliff.getFile(0)) != null) {
            xliffFile.setHeaderNote(s);
            state = false;
            doc.putProperty("state", state);
            if (p.isClosed()) {
                p.setClosed(false);
                p.saveProject(false);
                p.setClosed(true);
            }
        }
    }

    @Override
    public void saveAsResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextResource.this.saveAsFile();
            }
        });
    }

    @Override
    public void saveResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TextResource.this.isDocumentNote()) {
                    TextResource.this.saveDocumentNote();
                } else {
                    TextResource.this.saveFile();
                }
            }
        });
    }

    @Override
    public void closeResource() {
        if (!this.okToAbandon()) {
            return;
        }
        Object o = this.getDocument().getProperty("path");
        if (o != null) {
            String path = o.toString();
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            docs.remove(path);
        }
        if (this.textPane != null) {
            this.textPane.setVisible(false);
        }
        if (this.statistics) {
            StatisticsView sv = this.topui.getStatisticsView();
            sv.closeHTMLViewer();
        }
        TabView tview = this.topui.getTabView();
        tview.removeTab(this.name);
    }

    @Override
    public void printResource() {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.PRINT)) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT PRINT ACTION IS NOT SUPPORTED ON YOUR SYSTEM."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM INFORMATION"), 1);
            this.topui.printTextComponent();
        } else {
            Document doc = this.getDocument();
            File file = (File)doc.getProperty("file");
            if (file != null && file.toString().indexOf(46) != -1) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.print(file);
                }
                catch (IOException ex) {
                    this.topui.printTextComponent();
                }
            } else {
                this.topui.printTextComponent();
            }
        }
    }

    @Override
    public void nextResource() {
        Document doc = this.getDocument();
        this.undoHandler = (MyUndoListener)doc.getProperty("undohandler");
        if (this.undoHandler != null) {
            this.undoHandler.redoAction();
        }
    }

    @Override
    public void previousResource() {
        Document doc = this.getDocument();
        this.undoHandler = (MyUndoListener)doc.getProperty("undohandler");
        if (this.undoHandler != null) {
            this.undoHandler.undoAction();
        }
    }

    @Override
    public void plusResource() {
        Font font = this.textPane.getFont();
        float size = font.getSize() + 1;
        font = font.deriveFont(size);
        this.textPane.setFont(font);
        MutableAttributeSet attr = this.textPane.getInputAttributes();
        StyleConstants.setFontFamily(attr, font.getFamily());
        StyleConstants.setFontSize(attr, font.getSize());
        StyledDocument doc = this.textPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), attr, false);
    }

    @Override
    public void minusResource() {
        Font font = this.textPane.getFont();
        float size = font.getSize() - 1;
        font = font.deriveFont(size);
        this.textPane.setFont(font);
        MutableAttributeSet attr = this.textPane.getInputAttributes();
        StyleConstants.setFontFamily(attr, font.getFamily());
        StyleConstants.setFontSize(attr, font.getSize());
        StyledDocument doc = this.textPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), attr, false);
    }

    @Override
    public void search(String m, String r) {
        if (!this.statistics) {
            m = this.topui.getResourceView().prepareSearchString(m);
            this.lookUpText(m, r, -1);
        }
    }

    @Override
    public void stopSearch() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    private void lookUpText(final String m, final String r, final int pos) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ TextResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                JTextPane jt = this.this$0.textPane;
                if (jt != null) {
                    Document doc = jt.getDocument();
                    String text = null;
                    try {
                        text = doc.getText(0, doc.getLength());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Pattern p = AppPreferences.searchCase ? Pattern.compile(m) : Pattern.compile(m, 2);
                        Matcher ma = p.matcher(text);
                        int i = pos != -1 ? pos : jt.getCaretPosition();
                        if (ma.find(i)) {
                            if (r != null) {
                                int o = JOptionPane.showConfirmDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE ALL?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AND REPLACE"), 0);
                                if (o == 0) {
                                    StringBuffer sb = new StringBuffer();
                                    do {
                                        ma.appendReplacement(sb, r);
                                    } while (ma.find());
                                    if (sb.length() > 0) {
                                        ma.appendTail(sb);
                                        ((JTextComponent)jt).setText(sb.toString());
                                        jt.setCaretPosition(i);
                                        jt.requestFocus();
                                    }
                                } else {
                                    jt.setRequestFocusEnabled(false);
                                    jt.setSelectionStart(ma.start());
                                    jt.setSelectionEnd(ma.end());
                                    ((JTextComponent)jt).replaceSelection(r);
                                    jt.setSelectionStart(ma.start());
                                    jt.setSelectionEnd(ma.start() + r.length());
                                    jt.setRequestFocusEnabled(true);
                                    jt.requestFocus();
                                }
                            } else {
                                jt.setRequestFocusEnabled(false);
                                jt.setSelectionStart(ma.start());
                                jt.setSelectionEnd(ma.end());
                                jt.setRequestFocusEnabled(true);
                                jt.requestFocus();
                            }
                        } else {
                            int o = JOptionPane.showConfirmDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOT FOUND. CONTINUE FROM THE START?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AND REPLACE"), 0);
                            if (o == 0) {
                                this.this$0.lookUpText(m, r, 0);
                                jt.repaint();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (m.startsWith(">") && m.startsWith(">fca=") && (AppPreferences.fca = m.substring(m.indexOf("=") + 1)).indexOf("newline") != -1) {
                        AppPreferences.fca = AppPreferences.fca.replaceAll("newline", "\n");
                    }
                }
            }
        });
    }

    @Override
    public String getLocation() {
        String href = null;
        if (this.textPane != null) {
            Document doc = this.textPane.getDocument();
            href = (String)doc.getProperty("path");
        }
        return href;
    }
}

