/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import translator.AppPreferences;
import translator.MainView;
import translator.ProgressBarUpdater;
import translator.Project;
import translator.SegmentParser;
import translator.Translatable;
import translator.TranslateEvent;
import translator.TranslationUnitMap;
import translator.Workflow;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.ttx.ProcessTTXUnit;
import translator.ttx.TTX;
import translator.ttx.TTXUnit;
import translator.xliff.ProcessXLIFFUnit;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class TranslationHandler {
    private MainView topui;
    private ProgressMonitor pm;
    private JProgressBar bar;

    public TranslationHandler(MainView topui) {
        this.topui = topui;
        this.pm = new ProgressMonitor(topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTO-SEGMENTATION"), "", 0, 10);
        this.pm.setMillisToPopup(0);
    }

    public void pretranslateFromCurrentSegment(final Project p) {
        MemoryView mv = this.topui.getMemoryView();
        List mems = mv.getLocalMemories();
        if (mems.size() > 0) {
            mv.startPretranslationDialog(mems);
            this.pretranslateOnlyMemoryXliff(p, true);
            for (Object object : mems) {
                final Memory m = (Memory)object;
                if (m.isPretranslateOnly() || m.getWorkflowMode() != 1 || m.isActive()) continue;
                int endPos = p.getCurrentUnitsNumber();
                String procName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING") + "...";
                m.initMemoryProgress(0, endPos, procName);
                SegmentParser cparser = m.getTMX().getParser();
                cparser.clearCache();
                mv.clearTMPane(m);
                m.setPretranslated(true);
                m.setActive(true);
                m.setWorkflowMode(1);
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ TranslationHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        p.pretranslateFromCurrentSegment(m);
                        return null;
                    }

                    @Override
                    protected void done() {
                        m.removeMemoryProgress();
                        m.update();
                        m.setActive(false);
                    }
                };
                worker.execute();
            }
        }
    }

    public void pretranslateUnsegmentedDocument(Project project) {
        Translatable translatable;
        int mode = project.mode;
        if ((mode == 0 || mode == 1) && (translatable = project.getTranslatable()) != null) {
            final Workflow process = new Workflow(this.topui);
            process.setTranslatable(translatable);
            process.setTranslatableText();
            XLIFF xliff = project.getXLIFF();
            if (process.unclean) {
                xliff.setSegmentSeparator(AppPreferences.segFormat);
            } else {
                xliff.setSegmentSeparator(AppPreferences.segmentSeparator);
            }
            process.prepareSegmentation();
            MemoryView mv = this.topui.getMemoryView();
            List mems = mv.getLocalMemories();
            if (mems.size() > 0) {
                mv.startPretranslationDialog(mems);
                for (Object object : mems) {
                    List segs;
                    final Memory m = (Memory)object;
                    if (m.isPretranslateOnly() || m.getWorkflowMode() != 1 || m.isActive() || (segs = process.getSegmentsList()) == null) continue;
                    SegmentParser cparser = m.getTMX().getParser();
                    cparser.clearCache();
                    mv.clearTMPane(m);
                    m.setPretranslated(true);
                    m.setActive(true);
                    m.setWorkflowMode(1);
                    SwingWorker worker = new SwingWorker(this){
                        final /* synthetic */ TranslationHandler this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public String doInBackground() {
                            process.pretranslate(m, segs);
                            return null;
                        }

                        @Override
                        protected void done() {
                            m.removeMemoryProgress();
                            m.update();
                            m.setActive(false);
                        }
                    };
                    worker.execute();
                }
            }
        }
    }

    public void pretranslateAllSegmentsXLIFF(Project project, final boolean all) {
        final List tunits = project.getXLIFF().getView().getViewUnits();
        if (tunits == null || tunits.isEmpty()) {
            return;
        }
        MemoryView mv = this.topui.getMemoryView();
        List mems = mv.getLocalMemories();
        ArrayList<Memory> activeMems = new ArrayList<Memory>(4);
        if (mems.size() > 0) {
            Memory m;
            mv.startPretranslationDialog(mems);
            this.pretranslateOnlyMemoryXliff(project, all);
            for (Object e : mems) {
                m = (Memory)e;
                if (m.isPretranslateOnly() || m.getWorkflowMode() != 1 || m.isActive()) continue;
                SegmentParser cparser = m.getTMX().getParser();
                cparser.clearCache();
                mv.clearTMPane(m);
                m.setPretranslated(true);
                m.setActive(true);
                m.setWorkflowMode(1);
                activeMems.add(m);
                String procName = m.getName() + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING") + "...";
                m.initMemoryProgress(0, tunits.size(), procName);
            }
            for (Object e : activeMems) {
                m = (Memory)e;
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ TranslationHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        this.this$0.pretranslateAllXliff(m, tunits, all);
                        return null;
                    }

                    @Override
                    protected void done() {
                        m.removeMemoryProgress();
                        m.update();
                        m.setActive(false);
                    }
                };
                worker.execute();
            }
        }
    }

    public void pretranslateOnlyMemoryXliff(Project project, final boolean all) {
        XLIFF xliff = project.getXLIFF();
        if (xliff == null) {
            return;
        }
        final List tunits = xliff.getView().getViewUnits();
        if (tunits == null || tunits.isEmpty()) {
            return;
        }
        MemoryView mv = this.topui.getMemoryView();
        List mems = mv.getLocalMemories();
        if (mems.size() > 0) {
            for (Object object : mems) {
                final Memory m = (Memory)object;
                if (!m.isPretranslateOnly() || m.getWorkflowMode() != 1 || m.isActive()) continue;
                TMX tmx = m.getTMX();
                if (tmx != null) {
                    SegmentParser cparser = tmx.getParser();
                    cparser.clearCache();
                }
                mv.clearTMPane(m);
                m.setPretranslated(true);
                m.setActive(true);
                m.setWorkflowMode(1);
                String procName = m.getName() + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING") + "...";
                m.initMemoryProgress(0, tunits.size(), procName);
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ TranslationHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        m.loadMemoryForPretranslation();
                        this.this$0.pretranslateAllXliff(m, tunits, all);
                        return null;
                    }

                    @Override
                    protected void done() {
                        TranslationUnitMap tumap = m.getTMX().getTUMap();
                        tumap.clearMap();
                        m.removeMemoryProgress();
                        m.update();
                        m.setActive(false);
                        System.gc();
                    }
                };
                worker.execute();
            }
        }
    }

    public void pretranslateAllSegmentsTTX(Project project, final boolean all) {
        Memory m;
        final List tunits = project.getTTX().getView().getViewUnits();
        if (tunits == null || tunits.isEmpty()) {
            return;
        }
        MemoryView mv = this.topui.getMemoryView();
        List mems = mv.getLocalMemories();
        ArrayList<Memory> activeMems = new ArrayList<Memory>(4);
        if (mems.size() > 0) {
            mv.startPretranslationDialog(mems);
            for (Object e : mems) {
                m = (Memory)e;
                if (m.isPretranslateOnly() || m.getWorkflowMode() != 1 || m.isActive()) continue;
                SegmentParser cparser = m.getTMX().getParser();
                cparser.clearCache();
                mv.clearTMPane(m);
                m.setPretranslated(true);
                m.setActive(true);
                m.setWorkflowMode(1);
                activeMems.add(m);
                String procName = m.getName() + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING") + "...";
                m.initMemoryProgress(0, tunits.size(), procName);
            }
        }
        for (Object e : activeMems) {
            m = (Memory)e;
            SwingWorker worker = new SwingWorker(this){
                final /* synthetic */ TranslationHandler this$0;
                {
                    this.this$0 = this$0;
                }

                public String doInBackground() {
                    this.this$0.pretranslateAllTTX(m, tunits, all);
                    return null;
                }

                @Override
                protected void done() {
                    m.removeMemoryProgress();
                    m.update();
                    m.setActive(false);
                }
            };
            worker.execute();
        }
    }

    public void autotranslateWithReplacementMemory(final Project project, final Memory memory) {
        XLIFF xliff = project.getXLIFF();
        if (this.bar != null) {
            return;
        }
        final boolean storeMatch = xliff.isCafeTranXLIFF;
        final MemoryView mv = this.topui.getMemoryView();
        final ProcessXLIFFUnit process = new ProcessXLIFFUnit(xliff);
        final List mems = mv.getLocalMemories();
        mems.add(0, memory);
        final ArrayList<Memory> activeMems = new ArrayList<Memory>(4);
        if (mems.size() > 0) {
            for (Object object : mems) {
                Memory m = (Memory)object;
                if (m.isActive()) continue;
                m.setActive(true);
                activeMems.add(m);
            }
        }
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TranslationHandler this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                String mes = "Automatic insertion";
                List tunits = project.getXLIFF().getView().getViewUnits();
                this.this$0.initMemoryProgress(0, tunits.size());
                int from = 0;
                for (Object o : tunits) {
                    if (o != null && o instanceof XLIFFUnit) {
                        String target;
                        int state;
                        XLIFFUnit tu = (XLIFFUnit)o;
                        if (tu.locked || !tu.translate || (state = tu.getState()) == 1 || (target = tu.getTargetText().trim()).length() > 0) continue;
                        String source = tu.getSourceText();
                        if (source.length() > 0) {
                            process.processTU(tu);
                            String sourceProcessed = process.getSourceString();
                            String r = mv.translateForExactMatches(source, sourceProcessed, tu);
                            if (r != null) {
                                int accuracy;
                                process.updateTU(tu, sourceProcessed, r);
                                TranslateEvent event = mv.getTranslateEvent();
                                if (event != null && (accuracy = event.getAssembledAccuracy()) > 100) {
                                    int context = event.getContextAccuracy();
                                    if (context == 102) {
                                        tu.setMatch(102, 1, storeMatch);
                                    } else if (context == 101) {
                                        tu.setMatch(101, 1, storeMatch);
                                    } else {
                                        tu.setMatch(100, 1, storeMatch);
                                    }
                                }
                            }
                        }
                    }
                    if (++from % 10 != 0) continue;
                    this.this$0.updateMemoryProgress(from, mes);
                }
                return null;
            }

            @Override
            protected void done() {
                for (Object object : activeMems) {
                    Memory m = (Memory)object;
                    m.setActive(false);
                }
                mems.remove(0);
                memory.clearMemory();
                this.this$0.removeMemoryProgress();
                this.this$0.topui.getProjectView().getProject().edit("#0");
            }
        };
        worker.execute();
    }

    public void autotranslateAllSegmentsXLIFF(final Project project) {
        XLIFF xliff = project.getXLIFF();
        if (this.bar != null) {
            return;
        }
        final boolean storeMatch = xliff.isCafeTranXLIFF;
        final MemoryView mv = this.topui.getMemoryView();
        final ProcessXLIFFUnit process = new ProcessXLIFFUnit(xliff);
        List mems = mv.getLocalMemories();
        final ArrayList<Memory> activeMems = new ArrayList<Memory>(4);
        if (mems.size() > 0) {
            for (Object object : mems) {
                Memory m = (Memory)object;
                if (m.isActive()) continue;
                m.setActive(true);
                activeMems.add(m);
            }
        }
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TranslationHandler this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                String mes = "Automatic insertion";
                List tunits = project.getXLIFF().getView().getViewUnits();
                this.this$0.initMemoryProgress(0, tunits.size());
                int from = 0;
                for (Object o : tunits) {
                    if (o != null && o instanceof XLIFFUnit) {
                        String target;
                        int state;
                        XLIFFUnit tu = (XLIFFUnit)o;
                        if (tu.locked || !tu.translate || (state = tu.getState()) == 1 || (target = tu.getTargetText().trim()).length() > 0) continue;
                        String source = tu.getSourceText();
                        if (source.length() > 0) {
                            process.processTU(tu);
                            String sourceProcessed = process.getSourceString();
                            String r = mv.translateForExactMatches(source, sourceProcessed, tu);
                            if (r != null) {
                                int accuracy;
                                process.updateTU(tu, sourceProcessed, r);
                                TranslateEvent event = mv.getTranslateEvent();
                                if (event != null && (accuracy = event.getAssembledAccuracy()) > 100) {
                                    int context = event.getContextAccuracy();
                                    if (context == 102) {
                                        tu.setMatch(102, 1, storeMatch);
                                    } else if (context == 101) {
                                        tu.setMatch(101, 1, storeMatch);
                                    } else {
                                        tu.setMatch(100, 1, storeMatch);
                                    }
                                }
                            }
                        }
                    }
                    if (++from % 10 != 0) continue;
                    this.this$0.updateMemoryProgress(from, mes);
                }
                return null;
            }

            @Override
            protected void done() {
                for (Object object : activeMems) {
                    Memory m = (Memory)object;
                    m.setActive(false);
                }
                this.this$0.removeMemoryProgress();
                this.this$0.topui.getProjectView().getProject().edit("#0");
            }
        };
        worker.execute();
    }

    public void autotranslateAllSegmentsTTX(final Project project) {
        if (this.bar != null) {
            return;
        }
        boolean storeMatch = false;
        TTX ttx = project.getTTX();
        final MemoryView mv = this.topui.getMemoryView();
        final ProcessTTXUnit process = new ProcessTTXUnit(ttx);
        List mems = mv.getLocalMemories();
        final ArrayList<Memory> activeMems = new ArrayList<Memory>(4);
        if (mems.size() > 0) {
            for (Object object : mems) {
                Memory m = (Memory)object;
                if (m.isActive()) continue;
                m.setActive(true);
                activeMems.add(m);
            }
        }
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TranslationHandler this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                String mes = "Automatic insertion";
                List tunits = project.getTTX().getView().getViewUnits();
                this.this$0.initMemoryProgress(0, tunits.size());
                int from = 0;
                for (Object o : tunits) {
                    if (o != null && o instanceof TTXUnit) {
                        int state;
                        TTXUnit tu = (TTXUnit)o;
                        String target = tu.getTargetText().trim();
                        if (target.length() > 0 || (state = tu.getState()) == 1) continue;
                        String source = tu.getSourceText();
                        if (source.length() > 0) {
                            process.processTU(tu);
                            String sourceProcessed = process.getSourceString();
                            String r = mv.translateForExactMatches(source, sourceProcessed, tu);
                            if (r != null) {
                                int accuracy;
                                process.updateTU(tu, sourceProcessed, r);
                                TranslateEvent event = mv.getTranslateEvent();
                                if (event != null && (accuracy = event.getAssembledAccuracy()) > 100) {
                                    int context = event.getContextAccuracy();
                                    if (context == 102) {
                                        tu.setMatch(102, 1, false);
                                    } else if (context == 101) {
                                        tu.setMatch(101, 1, false);
                                    } else {
                                        tu.setMatch(100, 1, false);
                                    }
                                }
                            }
                        }
                    }
                    if (++from % 10 != 0) continue;
                    this.this$0.updateMemoryProgress(from, mes);
                }
                return null;
            }

            @Override
            protected void done() {
                for (Object object : activeMems) {
                    Memory m = (Memory)object;
                    m.setActive(false);
                }
                this.this$0.removeMemoryProgress();
                this.this$0.topui.getProjectView().getProject().edit("#0");
            }
        };
        worker.execute();
    }

    private void pretranslateAllXliff(Memory ctm, List tunits, boolean all) {
        SegmentParser cparser = ctm.getTMX().getParser();
        int from = 0;
        try {
            XLIFFUnit[] units = new XLIFFUnit[tunits.size()];
            int n = 0;
            ListIterator it = tunits.listIterator();
            while (it.hasNext()) {
                XLIFFUnit u;
                units[n] = u = (XLIFFUnit)it.next();
                ++n;
            }
            for (XLIFFUnit tu : units) {
                if (!ctm.isClosed()) {
                    int state;
                    if (tu.locked || !tu.translate || (state = tu.getState()) == 1) continue;
                    String source = tu.getSourceText();
                    String target = tu.getTargetText();
                    if (source.length() > 0) {
                        String cs;
                        if (all) {
                            cs = cparser.cleanSegment(source);
                            if (cs.trim().length() > 0) {
                                cparser.translate(source, cs, tu, true);
                            }
                        } else if (target.trim().length() == 0 && (cs = cparser.cleanSegment(source)).trim().length() > 0) {
                            cparser.translate(source, cs, tu, true);
                        }
                        ctm.update();
                    }
                    if (++from % 10 != 0) continue;
                    ctm.updateMemoryProgress(from, ctm.getName(), true);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.topui, ex.getMessage(), "Pretranslation Error in " + ctm.getName(), 0);
        }
    }

    private void pretranslateAllTTX(Memory ctm, List tunits, boolean all) {
        SegmentParser cparser = ctm.getTMX().getParser();
        int from = 0;
        try {
            TTXUnit[] units = new TTXUnit[tunits.size()];
            int n = 0;
            ListIterator it = tunits.listIterator();
            while (it.hasNext()) {
                TTXUnit u;
                units[n] = u = (TTXUnit)it.next();
                ++n;
            }
            for (TTXUnit tu : units) {
                if (!ctm.isClosed()) {
                    int state = tu.getState();
                    if (state == 1) continue;
                    String source = tu.getSourceText();
                    String target = tu.getTargetText();
                    if (source.length() > 0) {
                        String cs;
                        if (all) {
                            cs = cparser.cleanSegment(source);
                            if (cs.trim().length() > 0) {
                                cparser.translate(source, cs, tu, true);
                            }
                        } else if (target.trim().length() == 0 && (cs = cparser.cleanSegment(source)).trim().length() > 0) {
                            cparser.translate(source, cs, tu, true);
                        }
                        ctm.update();
                    }
                    if (++from % 10 != 0) continue;
                    ctm.updateMemoryProgress(from, ctm.getName(), true);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.topui, ex.getMessage(), "Pretranslation Error in " + ctm.getName(), 0);
        }
    }

    public void initMemoryProgress(int currentPos, int endPos) {
        if (this.bar == null) {
            this.bar = this.topui.getPretranslateProgressBar();
        }
        this.bar.setMinimum(currentPos);
        this.bar.setMaximum(endPos);
        this.bar.setStringPainted(true);
        this.bar.setString("");
    }

    public void updateMemoryProgress(int ifrom, String s) {
        StringBuilder sb = new StringBuilder(s);
        sb.append(" - ");
        sb.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING")).append("...");
        String n = Integer.toString(ifrom);
        sb.append(n);
        this.bar.setString(sb.toString());
        ProgressBarUpdater updater = new ProgressBarUpdater(this.bar, ifrom);
        SwingUtilities.invokeLater(updater);
    }

    public void removeMemoryProgress() {
        if (this.bar != null) {
            this.topui.removePretranslateProgressBar(this.bar);
            this.bar = null;
        }
    }
}

