/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.DefaultResource;
import translator.MainView;
import translator.Resource;
import translator.TransparentBackgroundListener;
import translator.WebResource;
import translator.browser.WebResourceFX;

public class TransparentBackground
extends JLabel
implements ComponentListener,
MouseListener {
    private BufferedImage _background;
    MainView frame;
    JPopupMenu pop;

    public TransparentBackground(MainView frame) {
        this.frame = frame;
        TransparentBackgroundListener tbl = frame.getTransparentBackgroundListener();
        tbl.addBackgroundComp(this);
        this._background = tbl.getBackground();
        tbl.repaintAll();
        this.addMouseListener(this);
        this.setToolTipText("Click to update screen capture");
    }

    protected void setTransparentBackgroud(BufferedImage image) {
        this._background = image;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)this._background, 0, 0, null);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
        }
        if (!(this.pop != null && this.pop.isShowing() || evt.getButton() != 1)) {
            TransparentBackgroundListener tbl = this.frame.getTransparentBackgroundListener();
            tbl.updateBackground();
            this._background = tbl.getBackground();
            tbl.repaintAll();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop = new JPopupMenu();
        boolean hasItems = false;
        FontIcon ficon = null;
        List list = this.frame.getResourceView().getWebResources();
        if (list != null) {
            for (Object object : list) {
                AbstractButton item = null;
                if (object instanceof Resource) {
                    DefaultResource wrr;
                    Resource wr = (Resource)object;
                    if (wr instanceof WebResourceFX ? ((WebResourceFX)(wrr = (WebResourceFX)wr)).hasTransparentTab() : wr instanceof WebResource && ((WebResource)(wrr = (WebResource)wr)).hasTabbedView()) continue;
                    String name = wr.getLocation();
                    item = new JMenuItem(name);
                    if (ficon == null) {
                        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)item.getFont().getSize(), (Color)item.getForeground());
                    }
                    item.setIcon((Icon)ficon);
                    item.putClientProperty("resource", wr);
                    hasItems = true;
                }
                if (item == null) continue;
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JMenuItem item = (JMenuItem)e.getSource();
                        Resource wr = (Resource)item.getClientProperty("resource");
                        if (wr != null) {
                            wr.closeResource();
                        }
                    }
                });
                this.pop.add((JMenuItem)item);
            }
            if (hasItems) {
                this.pop.show(comp, x, y);
            }
        }
    }
}

