/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import translator.MainView;
import translator.TransparentBackground;

public class TransparentBackgroundListener
implements ComponentListener,
WindowFocusListener {
    private MainView frame;
    private BufferedImage _background;
    private static long _lastUpdate = 0L;
    private boolean _refreshRequested = true;
    private Robot _robot;
    private Rectangle _screenRect;
    private ArrayList comps;
    public boolean refresh = true;

    public TransparentBackgroundListener(MainView frame) {
        this.frame = frame;
        try {
            this._robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
            return;
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this._screenRect = new Rectangle(dim.width, dim.height);
        this.comps = new ArrayList();
    }

    public void addBackgroundComp(TransparentBackground comp) {
        this.comps.add(comp);
    }

    public void removeBackgroundComp(TransparentBackground comp) {
        this.comps.remove(comp);
        if (this.comps.size() == 0) {
            this.frame.removeTransparentBackgroundListener();
        }
    }

    public void updateBackground() {
        this.frame.setVisible(false);
        JFrame resFrame = this.frame.getExtendedFrame();
        if (resFrame != null) {
            resFrame.setVisible(false);
        }
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._background = this._robot.createScreenCapture(this._screenRect);
        this.frame.setVisible(true);
        if (resFrame != null) {
            resFrame.setVisible(true);
        }
    }

    BufferedImage getBackground() {
        return this._background;
    }

    protected void refresh() {
        long now = System.currentTimeMillis();
        if (this._refreshRequested && now - _lastUpdate > 2000L) {
            if (this.frame.isVisible()) {
                this.updateBackground();
                this._refreshRequested = false;
                for (TransparentBackground jcomp : this.comps) {
                    jcomp.setTransparentBackgroud(this._background);
                }
                this.repaintAll();
            }
            this._refreshRequested = true;
            _lastUpdate = System.currentTimeMillis();
        }
    }

    protected void repaintAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (TransparentBackground jcomp : TransparentBackgroundListener.this.comps) {
                    jcomp.repaint();
                }
            }
        });
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.refresh = true;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window[] activeframes = TransparentBackgroundListener.this.frame.getOwnedWindows();
                for (int i = 0; i < activeframes.length; ++i) {
                    if (!activeframes[i].isShowing()) continue;
                    TransparentBackgroundListener.this.refresh = false;
                    break;
                }
            }
        });
    }
}

