/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import translator.AppPreferences;
import translator.MainClass;
import translator.Project;
import translator.Workflow;
import translator.XMLElement;
import translator.XMLSourceSegmentHandler;
import translator.XMLTargetSegmentHandler;
import translator.ui.HTMLFormat;

public class XMLHelper {
    private static DefaultHandler targetHandler;
    private static DefaultHandler sourceHandler;
    private static SAXParser saxParser;
    private static Pattern pipes;
    private static Pattern tags;
    private static Pattern customTags;
    private static Pattern tagsAndCustomTags;
    private static Pattern tagGroup;
    private static Pattern tagGroupAndCustomTags;
    private static Pattern spaceWithTagGroups;
    private static Pattern spanTags;
    private static Pattern generalTags;
    private static Pattern hiddenTags;
    private static Pattern trimStartPattern;
    private static Pattern trimEndPattern;

    public static void showCustomTags() {
        tagsAndCustomTags = Pattern.compile(AppPreferences.tags);
        tagGroupAndCustomTags = Pattern.compile(AppPreferences.tagGroups);
    }

    public static Pattern getTagGroupPattern() {
        return tagGroup;
    }

    public static Pattern getTagGroupAndCustomTagsPattern() {
        return tagGroupAndCustomTags;
    }

    public static Pattern getTagsPattern() {
        return tags;
    }

    public static Pattern getTagsAndCustomTagsPattern() {
        return tagsAndCustomTags;
    }

    public static String resolveXMLEntities2(String e) {
        boolean markTag = false;
        char[] ch = e.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            boolean isHTMLTag = false;
            int j = -1;
            if (c == '<') {
                char a;
                j = i + 1;
                if (j < ch.length && (a = ch[j]) == '/') {
                    ++j;
                }
                boolean start = false;
                while (j < ch.length) {
                    String ss;
                    int k;
                    char cc = ch[j];
                    if (!start && cc == 's') {
                        k = j + 2;
                        if (k < ch.length) {
                            ss = new String(ch, j, 3);
                            if (!ss.equals("sup") && !ss.equals("sub")) break;
                            j = k;
                            start = true;
                        }
                    } else if (!start && cc == 'm') {
                        k = j + 3;
                        if (k < ch.length) {
                            ss = new String(ch, j, 4);
                            if (!ss.equals("mark")) break;
                            j = k;
                            start = true;
                            markTag = true;
                        }
                    } else if (cc == 'b' || cc == 'i' || cc == 'u') {
                        start = true;
                    } else {
                        if (!start) break;
                        if (cc == '>') {
                            isHTMLTag = true;
                            break;
                        }
                        if (cc != ' ') break;
                    }
                    ++j;
                }
            }
            if (!isHTMLTag) {
                if (c == ' ') {
                    if (i > 0 && ch[i - 1] == ' ') {
                        sb.append("&nbsp;");
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (c == '\t') {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue;
                }
                if (c == '\n') {
                    sb.append("<br>");
                    continue;
                }
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    sb.append("&gt;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '\"') {
                    sb.append("&quot;");
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(ch, i, j - i + 1);
            i = j;
        }
        String s = sb.toString();
        if (markTag) {
            s = s.replace("<mark>", HTMLFormat.startMarkSpan);
            s = s.replace("</mark>", HTMLFormat.endMarkSpan);
        }
        return s;
    }

    public static String resolveXMLEntities2PunctDiff(String e, String current) {
        int i;
        char[] ch = e.toCharArray();
        char[] ch2 = current.toCharArray();
        int offset = 0;
        boolean firstDiffOnly = false;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < ch.length; ++i) {
            char c = ch[i];
            boolean tag = false;
            if (i + offset < ch2.length) {
                char c2 = ch2[i + offset];
                if (!firstDiffOnly && c != c2) {
                    tag = true;
                    sb.append(HTMLFormat.punctuationDifferenceColorHTML);
                    sb.append("<b>");
                    int ind1 = AppPreferences.punctuationString.indexOf(c);
                    int ind2 = AppPreferences.punctuationString.indexOf(c2);
                    if (ind1 != -1 && ind2 == -1) {
                        --offset;
                    } else if (ind1 == -1 && ind2 != -1) {
                        ++offset;
                        sb.append(c2);
                        sb.append("</b></span>");
                        tag = false;
                    } else if (ind1 == -1 && ind2 == -1) {
                        firstDiffOnly = true;
                    }
                }
            } else {
                tag = true;
                sb.append(HTMLFormat.punctuationDifferenceColorHTML);
                sb.append("<b>");
            }
            boolean isHTMLTag = false;
            int j = -1;
            if (c == '<') {
                char a;
                j = i + 1;
                if (j < ch.length && (a = ch[j]) == '/') {
                    ++j;
                }
                boolean start = false;
                while (j < ch.length) {
                    char cc = ch[j];
                    if (!start && cc == 's') {
                        int k = j + 2;
                        if (k < ch.length) {
                            String ss = new String(ch, j, 3);
                            if (!ss.equals("sup") && !ss.equals("sub")) break;
                            j = k;
                            start = true;
                        }
                    } else if (cc == 'b' || cc == 'i' || cc == 'u') {
                        start = true;
                    } else {
                        if (!start) break;
                        if (cc == '>') {
                            isHTMLTag = true;
                            break;
                        }
                        if (cc != ' ') break;
                    }
                    ++j;
                }
            }
            if (!isHTMLTag) {
                if (c == ' ') {
                    if (i > 0 && ch[i - 1] == ' ') {
                        sb.append("&nbsp;");
                    } else {
                        sb.append(c);
                    }
                } else if (c == '\t') {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                } else if (c == '\n') {
                    sb.append("<br>");
                } else if (c == '<') {
                    sb.append("&lt;");
                } else if (c == '>') {
                    sb.append("&gt;");
                } else if (c == '&') {
                    sb.append("&amp;");
                } else if (c == '\"') {
                    sb.append("&quot;");
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(ch, i, j - i + 1);
                i = j;
            }
            if (!tag) continue;
            sb.append("</b></span>");
        }
        if (i + offset < current.length()) {
            sb.append(HTMLFormat.punctuationDifferenceColorHTML);
            sb.append("<b>");
            String s = current.substring(i + offset);
            sb.append(s);
            sb.append("</b></span>");
        }
        return sb.toString();
    }

    public static String resolveXMLEntities(String e) {
        if (e.indexOf(38) != -1) {
            e = e.replaceAll("&", "&amp;");
        }
        if (e.indexOf(34) != -1) {
            e = e.replaceAll("\"", "&quot;");
        }
        if (e.indexOf(60) != -1) {
            e = e.replaceAll("<", "&lt;");
        }
        if (e.indexOf(62) != -1) {
            e = e.replaceAll(">", "&gt;");
        }
        return e;
    }

    public static String resolveHTMLSwingEntities(String e) {
        if (e.indexOf(60) != -1) {
            e = e.replaceAll("<", "&lt;");
        }
        if (e.indexOf(62) != -1) {
            e = e.replaceAll(">", "&gt;");
        }
        return e;
    }

    public static String resolveXMLEntitiesBetweenSpanTags(String e) {
        String s;
        Matcher matcher = spanTags.matcher(e);
        int start = 0;
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            start = matcher.start();
            if (start > end) {
                s = e.substring(end, start);
                s = XMLHelper.resolveXMLEntities(s);
                sb.append(s);
            }
            String group = matcher.group();
            sb.append(group);
            end = matcher.end();
        }
        if (end < e.length()) {
            s = e.substring(end);
            s = XMLHelper.resolveXMLEntities(s);
            sb.append(s);
        }
        return sb.toString();
    }

    public static String resolveEntitiesXML(String e) {
        StringBuilder sb = new StringBuilder();
        int ind = 0;
        int i = -1;
        String tail = null;
        String head = null;
        String code = null;
        while ((i = e.indexOf(38, ind)) != -1) {
            char c;
            int k;
            tail = e.substring(ind, i);
            head = e.substring(i);
            ind = i + 1;
            if (head.startsWith("&#x")) {
                k = head.indexOf(59);
                if (k == -1) continue;
                code = head.substring(3, k);
                try {
                    c = (char)Integer.parseInt(code, 16);
                    sb.append(tail);
                    sb.append(c);
                    ind += k;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
                continue;
            }
            if (head.startsWith("&#")) {
                k = head.indexOf(59);
                if (k == -1) continue;
                code = head.substring(2, k);
                try {
                    c = (char)Integer.parseInt(code);
                    sb.append(tail);
                    sb.append(c);
                    ind += k;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
                continue;
            }
            if (head.startsWith("&amp;")) {
                k = head.indexOf(59);
                sb.append(tail);
                sb.append('&');
                ind += k;
                continue;
            }
            if (head.startsWith("&quot;")) {
                k = head.indexOf(59);
                sb.append(tail);
                sb.append("\"");
                ind += k;
                continue;
            }
            if (head.startsWith("&lt;")) {
                k = head.indexOf(59);
                sb.append(tail);
                sb.append('<');
                ind += k;
                continue;
            }
            if (head.startsWith("&gt;")) {
                k = head.indexOf(59);
                sb.append(tail);
                sb.append('>');
                ind += k;
                continue;
            }
            if (!head.startsWith("&apos;")) continue;
            k = head.indexOf(59);
            sb.append(tail);
            sb.append("'");
            ind += k;
        }
        if (ind != -1 && sb.length() > 0) {
            sb.append(e.substring(ind));
            return sb.toString();
        }
        return e;
    }

    public static String resolveMIFEntities(String e) {
        String r;
        if (e.indexOf("\\") != -1) {
            String s = Matcher.quoteReplacement("\\");
            String r2 = Matcher.quoteReplacement("\\\\");
            e = e.replaceAll(s, r2);
        }
        if (e.indexOf("\t") != -1) {
            r = Matcher.quoteReplacement("\\t");
            e = e.replaceAll("\t", r);
        }
        if (e.indexOf(">") != -1) {
            r = Matcher.quoteReplacement("\\>");
            e = e.replaceAll(">", r);
        }
        if (e.indexOf("'") != -1) {
            r = Matcher.quoteReplacement("\\q");
            e = e.replaceAll("'", r);
        }
        if (e.indexOf("`") != -1) {
            r = Matcher.quoteReplacement("\\Q");
            e = e.replaceAll("`", r);
        }
        return e;
    }

    static SAXParser getParser() {
        if (saxParser == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                saxParser = factory.newSAXParser();
            }
            catch (SAXException ex) {
                Logger.getLogger(XMLHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(XMLHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return saxParser;
    }

    private static DefaultHandler getSegmentHandler(boolean target) {
        if (target) {
            if (targetHandler == null) {
                targetHandler = new XMLTargetSegmentHandler();
            }
            return targetHandler;
        }
        if (sourceHandler == null) {
            sourceHandler = new XMLSourceSegmentHandler();
        }
        return sourceHandler;
    }

    public static int[] calculateTagsPosition(String segment) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Matcher matcher = tagGroup.matcher(segment);
        int resultSize = 0;
        int offset = 0;
        while (matcher.find()) {
            int start = matcher.start() - offset;
            offset += matcher.end() - matcher.start();
            list.add(start);
            ++resultSize;
        }
        int[] result = new int[resultSize];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    public static String replaceTagsWithSpace(String stags) {
        Matcher matcher = tags.matcher(stags);
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String group = matcher.group();
            String br = "";
            int i = group.indexOf("equiv-text=\"");
            if (i != -1) {
                int j = group.indexOf("\"", i += 12);
                if (j != -1) {
                    br = group.substring(i, j);
                }
            } else {
                br = " ";
            }
            int start = matcher.start();
            if (start >= end) {
                String content = stags.substring(end, start);
                sb.append(content);
                sb.append(br);
            }
            end = matcher.end();
        }
        if (end < stags.length()) {
            sb.append(stags.substring(end));
        }
        return sb.toString();
    }

    public static String parseTags(String stags) {
        Matcher matcher = tagsAndCustomTags.matcher(stags);
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            int start;
            int j;
            String group = matcher.group();
            String br = "";
            int i = group.indexOf("equiv-text=\"");
            if (i != -1 && (j = group.indexOf("\"", i += 12)) != -1) {
                br = group.substring(i, j);
            }
            if ((start = matcher.start()) >= end) {
                String content = stags.substring(end, start);
                sb.append(content);
                sb.append(br);
            }
            end = matcher.end();
        }
        if (end < stags.length()) {
            sb.append(stags.substring(end));
        }
        return sb.toString();
    }

    public static String parseCustomTags(String stags) {
        Matcher matcher = customTags.matcher(stags);
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            int start = matcher.start();
            if (start >= end) {
                String content = stags.substring(end, start);
                sb.append(content);
            }
            end = matcher.end();
        }
        if (end < stags.length()) {
            sb.append(stags.substring(end));
        }
        return sb.toString();
    }

    public static String parseTagsContent(String stags) {
        Matcher matcher = generalTags.matcher(stags);
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            int start = matcher.start();
            if (start >= end) {
                String content = stags.substring(end, start);
                sb.append(content);
            }
            end = matcher.end();
        }
        if (end < stags.length()) {
            sb.append(stags.substring(end));
        }
        return sb.toString();
    }

    public static String parseHiddenTags(String s, boolean source) {
        if (s == null || s.length() == 0) {
            return s;
        }
        Project project = MainClass.getMainView().getProjectView().getProject();
        Matcher matcher = hiddenTags.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group();
            String n = project.getTagsXML(group, source);
            if (n == null || n.length() <= 0) continue;
            if (n.indexOf(92) != -1) {
                n = n.replace("\\", "\\\\");
            }
            if (n.indexOf(36) != -1) {
                n = n.replace("$", "\\$");
            }
            matcher.appendReplacement(sb, n);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static int countCharacters(String stags) {
        Matcher matcher = tags.matcher(stags);
        int start = -1;
        int end = 0;
        int length = 0;
        while (matcher.find()) {
            int j;
            String group = matcher.group();
            int i = group.indexOf("equiv-text=\"");
            if (i != -1 && (j = group.indexOf("\"", i += 12)) != -1) {
                length += group.substring(i, j).length();
            }
            if ((start = matcher.start()) >= end) {
                length += stags.substring(end, start).length();
            }
            end = matcher.end();
        }
        if (end < stags.length()) {
            length += stags.substring(end).length();
        }
        return length;
    }

    public static String removeFirstCharsToLeft(String search) {
        Matcher matcher = tagGroup.matcher(search);
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String group = matcher.group();
            int start = matcher.start();
            if (start >= end) {
                String content = search.substring(end, start);
                if (content.length() > 0) {
                    sb.append(content);
                }
                sb.append(group);
            }
            end = matcher.end();
        }
        if (end < search.length()) {
            String content = search.substring(end);
            sb.append(content);
        }
        return sb.toString();
    }

    public static String removeLastOnlyChars(String search) {
        Pattern p = Pattern.compile(AppPreferences.tagGroups + "(?!.*" + AppPreferences.tagGroups + ")");
        Matcher matcher = p.matcher(search);
        int end = 0;
        StringBuilder sb = new StringBuilder();
        if (matcher.find()) {
            String tail = null;
            boolean foundTail = false;
            int e = matcher.end();
            if (e < search.length()) {
                String con = search.substring(e);
                tail = XMLHelper.replaceCharsBetweenTags(con, "", true);
                if (tail != null) {
                    foundTail = true;
                } else {
                    tail = con;
                }
            }
            String group = matcher.group();
            int start = matcher.start();
            if (start >= end) {
                String content = search.substring(end, start);
                if (content.length() > 0) {
                    if (foundTail) {
                        sb.append(content);
                    } else {
                        String s = XMLHelper.replaceCharsBetweenTags(content, "", true);
                        if (s != null) {
                            sb.append(s);
                        } else {
                            sb.append(content);
                        }
                    }
                }
                sb.append(group);
            }
            if (tail != null) {
                sb.append(tail);
            }
        } else if (end < search.length()) {
            String content = search.substring(end);
            String s = XMLHelper.replaceCharsBetweenTags(content, "", true);
            if (s != null) {
                return s;
            }
            return search;
        }
        return sb.toString();
    }

    public static String removeChars(String search) {
        Matcher matcher = tagGroup.matcher(search);
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String group = matcher.group();
            int start = matcher.start();
            if (start >= end) {
                String content = search.substring(end, start);
                if (content.length() > 0) {
                    String s = XMLHelper.replaceCharsBetweenTags(content, "", false);
                    sb.append(s);
                }
                sb.append(group);
            }
            end = matcher.end();
        }
        if (end < search.length()) {
            String content = search.substring(end);
            String s = XMLHelper.replaceCharsBetweenTags(content, "", false);
            sb.append(s);
        }
        return sb.toString();
    }

    private static String replaceCharsBetweenTags(String s, String r, boolean lastOnly) {
        Pattern p = !lastOnly ? Pattern.compile(AppPreferences.removables) : Pattern.compile(AppPreferences.removables + "(?!.*" + AppPreferences.removables + ")");
        boolean found = false;
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, r);
            found = true;
        }
        if (lastOnly && !found) {
            return null;
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String removeTags(String search) {
        String content;
        Matcher matcher = tagGroup.matcher(search);
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            int start = matcher.start();
            if (start >= end && (content = search.substring(end, start)).length() > 0) {
                sb.append(content);
            }
            end = matcher.end();
        }
        if (end < search.length()) {
            content = search.substring(end);
            sb.append(content);
        }
        return sb.toString();
    }

    public static String shrinkTags(String stags, Map map) {
        Matcher matcher = tagGroup.matcher(stags);
        int end = 0;
        int count = 1;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String group = matcher.group();
            String tag = "<x" + Integer.toString(count) + ">";
            map.put(tag, group);
            ++count;
            int start = matcher.start();
            if (start >= end) {
                String content = stags.substring(end, start);
                if (content.length() > 0) {
                    sb.append(content);
                }
                sb.append(tag);
            }
            end = matcher.end();
        }
        if (end < stags.length()) {
            String content = stags.substring(end);
            sb.append(content);
        }
        return sb.toString();
    }

    public static String trimSpace(String s) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = spaceWithTagGroups.matcher(s);
        int end = 0;
        while (matcher.find()) {
            int start = matcher.start();
            String group = matcher.group();
            int n = group.indexOf(60);
            int m = group.lastIndexOf(62);
            if (n != -1 && m != -1) {
                int i = group.indexOf("equiv-text=\"");
                if (i != -1) {
                    String sp;
                    int j = group.indexOf("\"", i += 12);
                    if (j != -1 && (sp = group.substring(i, j)).equals(" ")) {
                        if (group.startsWith(" ")) {
                            group = group.substring(1);
                        }
                        if (group.endsWith(" ")) {
                            group = group.substring(0, group.length() - 1);
                        }
                    }
                } else {
                    int h = 0;
                    int g = group.length();
                    if (n > 1) {
                        h = n - 1;
                    }
                    if (m + 2 < group.length()) {
                        g = m + 2;
                    }
                    if (h > 0 || g < group.length()) {
                        group = group.substring(h, g);
                    }
                }
            } else if (group.length() > 1 && start > 0) {
                group = " ";
            }
            if (start >= end) {
                String content = s.substring(end, start);
                sb.append(content);
                sb.append(group);
            }
            end = matcher.end();
        }
        if (end < s.length()) {
            sb.append(s.substring(end));
        }
        return sb.toString();
    }

    public static String transferTags(String stags, String ttags) {
        Matcher matcher = tags.matcher(stags);
        int count = 0;
        StringBuilder target = new StringBuilder(ttags);
        while (matcher.find()) {
            String tgroup = matcher.group();
            int end = matcher.end();
            if (++count == 1 && end < stags.length()) {
                target.insert(0, tgroup);
                continue;
            }
            target.append(tgroup);
        }
        return target.toString();
    }

    public static String expandTags(String stags, Map map) {
        Matcher matcher = tagGroup.matcher(stags);
        int end = 0;
        int count = 1;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String tag = "<x" + Integer.toString(count) + ">";
            tag = (String)map.get(tag);
            ++count;
            int start = matcher.start();
            if (start >= end) {
                String content = stags.substring(end, start);
                sb.append(content);
                if (tag != null) {
                    sb.append(tag);
                }
            }
            end = matcher.end();
        }
        if (end < stags.length()) {
            String content = stags.substring(end);
            sb.append(content);
        }
        return sb.toString();
    }

    public static boolean hasStringContent(String stags) {
        String content;
        Matcher matcher = tags.matcher(stags);
        int start = -1;
        int end = 0;
        boolean str = false;
        while (matcher.find()) {
            start = matcher.start();
            if (start >= end && (content = stags.substring(end, start)).trim().length() > 0) {
                str = true;
                break;
            }
            end = matcher.end();
        }
        if (!str && end < stags.length() && (content = stags.substring(end)).trim().length() > 0) {
            str = true;
        }
        return str;
    }

    public static String reinsertTags(int[] tags, String source, String target) {
        List tg = XMLHelper.getTagGroups(source);
        StringBuilder sb = new StringBuilder(target);
        int offset = 0;
        for (int k = 0; k < tags.length; ++k) {
            int j;
            int l = tags[k] + offset;
            if (k >= tg.size() || l >= sb.length()) continue;
            String group = (String)tg.get(k);
            sb.insert(l, group);
            offset += group.length();
            int i = group.indexOf("equiv-text=\"");
            if (i == -1 || (j = group.indexOf("\"", i += 12)) == -1) continue;
            String br = group.substring(i, j);
            String sub = sb.substring(l + group.length());
            if (sub == null || !sub.startsWith(br)) continue;
            int sind = l + group.length();
            int eind = sind + br.length();
            sb.delete(sind, eind);
        }
        return sb.toString();
    }

    public static String replacePipesWithTags(String s, String t) {
        int i = 0;
        int j = 0;
        Matcher matcher = tagGroup.matcher(s);
        ArrayList<String> tagList = new ArrayList<String>();
        while (matcher.find()) {
            String g = matcher.group();
            tagList.add(g);
            ++i;
        }
        matcher = pipes.matcher(t);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (j < tagList.size()) {
                String g = (String)tagList.get(j);
                matcher.appendReplacement(sb, g);
            }
            ++j;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String replaceTagsWithPipes(String s) {
        Matcher matcher = tagGroup.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "|");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String tansferMissingTags(String s, String t) {
        int i = 0;
        int j = 0;
        Matcher matcher = tags.matcher(t);
        while (matcher.find()) {
            ++i;
        }
        matcher = tags.matcher(s);
        while (matcher.find()) {
            if (++j <= i) continue;
            String g = matcher.group();
            t = t + g;
        }
        return t;
    }

    public static int countTags(String s) {
        int i = 0;
        String tt = null;
        Matcher matcher = tags.matcher(s);
        while (matcher.find()) {
            String group = matcher.group();
            if (tt != null && tt.equals(group)) {
                tt = null;
                continue;
            }
            int k = group.indexOf(" track=");
            if (k != -1) {
                tt = "</" + group.substring(1, k) + ">";
                continue;
            }
            if (tt != null) continue;
            ++i;
        }
        return i;
    }

    public static int countTagGroups(String s) {
        int i = 0;
        Matcher matcher = tagGroup.matcher(s);
        while (matcher.find()) {
            ++i;
        }
        return i;
    }

    public static String countTagPosition(String source, String target, int caretPos) {
        int tsub = -1;
        int ssub = -1;
        int curTPos = -1;
        int curSPos = -1;
        Matcher matcher = tags.matcher(target);
        int start = -1;
        int end = 0;
        String group = null;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            ++tsub;
            start = matcher.start();
            if (start >= end) {
                String content = target.substring(end, start);
                sb.append(content);
                if (sb.length() >= caretPos) {
                    curTPos = start - end;
                    break;
                }
            }
            end = matcher.end();
            group = matcher.group();
            sb.append(group);
        }
        if (curTPos == -1) {
            if (start != -1) {
                ++tsub;
                curTPos = target.length() - end;
            } else {
                curTPos = target.length();
            }
        }
        matcher = tags.matcher(source);
        start = -1;
        end = 0;
        String tag = null;
        while (matcher.find()) {
            ++ssub;
            start = matcher.start();
            if (tag != null && group != null && tag.equals(group)) {
                curSPos = start - end;
                break;
            }
            if (ssub >= tsub) break;
            end = matcher.end();
            tag = matcher.group();
        }
        if (curSPos == -1) {
            curSPos = tag != null && group != null && tag.equals(group) ? source.length() - end : (start != -1 ? start : source.length());
        }
        String spos = String.valueOf(curSPos) + " | " + String.valueOf(curTPos);
        return spos;
    }

    public static boolean parseSegment(XMLElement elem, HashMap sm, HashMap tm, String s, boolean target) {
        s = "<xtag0>" + s + "</xtag0>";
        Matcher matcher = tags.matcher(s);
        int start = -1;
        int end = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String tag = matcher.group();
            start = matcher.start();
            if (start >= end) {
                String content = s.substring(end, start);
                content = XMLHelper.resolveXMLEntities(content);
                sb.append(content);
            }
            sb.append(tag);
            end = matcher.end();
        }
        String xmlString = sb.toString();
        try {
            DefaultHandler xhand;
            SAXParser parser = XMLHelper.getParser();
            DefaultHandler handler = XMLHelper.getSegmentHandler(target);
            if (handler instanceof XMLTargetSegmentHandler) {
                xhand = (XMLTargetSegmentHandler)handler;
                ((XMLTargetSegmentHandler)xhand).setParent(elem);
                ((XMLTargetSegmentHandler)xhand).setMaps(sm, tm);
            } else if (handler instanceof XMLSourceSegmentHandler) {
                xhand = (XMLSourceSegmentHandler)handler;
                ((XMLSourceSegmentHandler)xhand).setParent(elem);
                ((XMLSourceSegmentHandler)xhand).setMaps(sm, tm);
            }
            StringReader reader = new StringReader(xmlString);
            InputSource is = new InputSource();
            is.setCharacterStream(reader);
            parser.parse(is, handler);
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER SOURCE TAGS TO TARGET. TYPE A TAG NUMBER AND PRESS ESC KEY."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TAGS QA"), 1);
            return false;
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
            return false;
        }
        return true;
    }

    public static boolean replaceInXML(XMLElement elem, Pattern pattern, String r) {
        List list = elem.getChildren();
        int ri = 0;
        boolean replaced = false;
        for (Object object : list) {
            if (object instanceof String) {
                String src = object.toString();
                Matcher ma = pattern.matcher(src);
                StringBuffer sb = new StringBuffer();
                boolean found = false;
                while (ma.find()) {
                    if (AppPreferences.preserveCaseWithReplacement) {
                        String key = ma.group();
                        String f = XMLHelper.adaptCase(key, r);
                        if (!f.equals(r)) {
                            ma.appendReplacement(sb, f);
                        } else {
                            ma.appendReplacement(sb, r);
                        }
                    } else {
                        ma.appendReplacement(sb, r);
                    }
                    found = true;
                    replaced = true;
                }
                if (found) {
                    ma.appendTail(sb);
                    elem.setContent(ri, sb.toString());
                }
            } else {
                XMLElement xelem = (XMLElement)object;
                String name = xelem.getName();
                if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("ut")) {
                    ++ri;
                    continue;
                }
                replaced = XMLHelper.replaceInXML(xelem, pattern, r);
            }
            ++ri;
        }
        return replaced;
    }

    private static int getTagNo(String tagID) {
        Workflow flow = MainClass.getMainView().getWorkflowView().getWorkflowManager().getWorkflow();
        if (flow == null) {
            return -1;
        }
        List tags = flow.getTags();
        for (Object[] next : tags) {
            String s = (String)next[1];
            if (!tagID.equals(s)) continue;
            return (Integer)next[0];
        }
        return -1;
    }

    public static void markTags(StyledDocument doc, Font font) {
        try {
            Style style = doc.getStyle("Tags");
            String s = doc.getText(0, doc.getLength());
            Matcher ma = AppPreferences.mergeNeighboringTags ? tagGroupAndCustomTags.matcher(s) : tagsAndCustomTags.matcher(s);
            int st = -1;
            int en = 0;
            int tagNo = 0;
            while (ma.find()) {
                String sid;
                st = ma.start();
                en = ma.end();
                String group = ma.group();
                boolean endTag = false;
                if (group.endsWith("mark>")) {
                    sid = "m";
                    if (group.startsWith("</")) {
                        endTag = true;
                    }
                } else if (group.endsWith("sub>")) {
                    sid = "s";
                    if (group.startsWith("</")) {
                        endTag = true;
                    }
                } else if (group.endsWith("sup>")) {
                    sid = "r";
                    if (group.startsWith("</")) {
                        endTag = true;
                    }
                } else if (group.endsWith("b>")) {
                    sid = "b";
                    if (group.startsWith("</")) {
                        endTag = true;
                    }
                } else if (group.endsWith("i>")) {
                    sid = "i";
                    if (group.startsWith("</")) {
                        endTag = true;
                    }
                } else if (group.endsWith("u>")) {
                    sid = "u";
                    if (group.startsWith("</")) {
                        endTag = true;
                    }
                } else {
                    String d;
                    int n = XMLHelper.getTagNo(group);
                    tagNo = n != -1 ? n : ++tagNo;
                    sid = Integer.toString(tagNo);
                    if (!AppPreferences.hideTagDetails && (d = MainClass.getMainView().getProjectView().getProject().getTagsXML(group, true)) != null && d.length() > 0) {
                        sid = sid + " " + d;
                    }
                }
                if (sid != null) {
                    JLabel label = new JLabel(sid);
                    label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                    label.setHorizontalTextPosition(0);
                    label.setOpaque(false);
                    Font f = endTag ? font.deriveFont(3) : font;
                    label.setFont(f);
                    if (group.indexOf("xntr") != -1) {
                        label.setForeground(new Color(AppPreferences.placeablesColor));
                    } else {
                        label.setForeground(new Color(AppPreferences.tagColor));
                    }
                    StyleConstants.setComponent(style, label);
                }
                doc.setCharacterAttributes(st, en - st, style, true);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public static List getTagGroups(String segment) {
        ArrayList<String> tg = new ArrayList<String>();
        Matcher ma = tagGroup.matcher(segment);
        while (ma.find()) {
            int s = ma.start();
            int e = ma.end();
            String group = ma.group();
            if (s <= 0 || e >= segment.length()) continue;
            tg.add(group);
        }
        return tg;
    }

    public static int getSplitPostion(String s) {
        return s.replaceAll(AppPreferences.tags, "").length();
    }

    public static int setSplitPostion(String s, int i) {
        int diff;
        int position = 0;
        int pos = 0;
        Matcher matcher = tags.matcher(s);
        int start = -1;
        int end = 0;
        while (matcher.find()) {
            start = matcher.start();
            if ((pos += start - end) >= i) {
                diff = pos - i;
                position = start - diff;
                break;
            }
            end = matcher.end();
        }
        if (start == -1) {
            position = i;
        } else if (pos < i) {
            if ((pos += s.length() - end) >= i) {
                diff = pos - i;
                position = s.length() - diff;
            } else {
                position = s.length();
            }
        }
        return position;
    }

    public static String trimNewTermStart(String s) {
        if (AppPreferences.trimNewtermStart.length() > 0) {
            int e;
            Matcher m;
            if (trimStartPattern == null) {
                trimStartPattern = Pattern.compile(AppPreferences.trimNewtermStart);
            }
            if ((m = trimStartPattern.matcher(s)).find() && (e = m.end()) > 0) {
                s = s.substring(e, s.length());
            }
        }
        return s;
    }

    public static String trimNewTermEnd(String s) {
        if (AppPreferences.trimNewtermEnd.length() > 0) {
            int st;
            Matcher m;
            if (trimEndPattern == null) {
                trimEndPattern = Pattern.compile(AppPreferences.trimNewtermEnd);
            }
            if ((m = trimEndPattern.matcher(s)).find() && (st = m.start()) < s.length()) {
                s = s.substring(0, st);
            }
        }
        return s;
    }

    public static String normalizeApostrophe(String s) {
        char ap1 = '\u2019';
        char ap2 = '\u02bc';
        char[] c = s.toCharArray();
        for (int j = 0; j < c.length; ++j) {
            char ca = c[j];
            if (ca != ap1 && ca != ap2) continue;
            c[j] = 39;
        }
        return String.valueOf(c);
    }

    public static String normalizeSpace(String s) {
        if (AppPreferences.whitespaceChars == null) {
            return s;
        }
        char[] c = s.toCharArray();
        block0: for (int j = 0; j < c.length; ++j) {
            char da;
            char ca = c[j];
            for (int k = 0; k < AppPreferences.whitespaceChars.length && (da = AppPreferences.whitespaceChars[k]) != '\u0000'; ++k) {
                char cd;
                if (ca != da || j > 0 && da == '\u00a0' && Character.isDigit(cd = c[j - 1]) || ca == '/' && (j > 0 && (cd = c[j - 1]) == '<' || j + 1 < c.length && (cd = c[j + 1]) == '>')) continue;
                c[j] = 32;
                continue block0;
            }
        }
        return String.valueOf(c);
    }

    public static boolean isReferencePath(String path) {
        boolean ref = false;
        if (path.startsWith("http") || path.startsWith("/") || path.indexOf(":\\") != -1) {
            ref = true;
        }
        return ref;
    }

    public static boolean equalsCaseInsensitive(char[] a, char[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.toLowerCase(a[i]) == Character.toLowerCase(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static String adaptCase(String s, String t) {
        char k;
        char c;
        if (t.length() == 0) {
            return t;
        }
        if (s.length() > 1 && t.length() > 1) {
            char cc = s.charAt(1);
            char kk = t.charAt(1);
            if (Character.isUpperCase(cc) && !Character.isUpperCase(kk)) {
                char cc2;
                if (s.length() > 3 && !Character.isUpperCase(cc2 = s.charAt(s.length() - 2))) {
                    return t;
                }
                t = t.toUpperCase();
                return t;
            }
            if (Character.isLowerCase(cc) && !Character.isLowerCase(kk)) {
                char cc2;
                if (s.length() > 3 && !Character.isLowerCase(cc2 = s.charAt(s.length() - 2))) {
                    return t;
                }
                t = t.toLowerCase();
                cc = s.charAt(0);
                if (Character.isUpperCase(cc)) {
                    kk = t.charAt(0);
                    kk = Character.toUpperCase(kk);
                    StringBuilder sb = new StringBuilder();
                    sb.append(kk);
                    sb.append(t.substring(1));
                    t = sb.toString();
                }
                return t;
            }
        }
        if (Character.isUpperCase(c = s.charAt(0))) {
            k = t.charAt(0);
            if (!Character.isUpperCase(k)) {
                k = Character.toUpperCase(k);
                StringBuilder sb = new StringBuilder();
                sb.append(k);
                if (t.length() > 1) {
                    sb.append(t.substring(1));
                }
                t = sb.toString();
            }
        } else {
            k = t.charAt(0);
            if (!Character.isLowerCase(k)) {
                k = Character.toLowerCase(k);
                StringBuilder sb = new StringBuilder();
                sb.append(k);
                if (t.length() > 1) {
                    sb.append(t.substring(1));
                }
                t = sb.toString();
            }
        }
        return t;
    }

    public static String hexToUnicode(String e) {
        int i;
        StringBuilder sb = new StringBuilder();
        int ind = 0;
        while ((i = e.indexOf("\\u", ind)) != -1) {
            String tail = e.substring(ind, i);
            String head = e.substring(i);
            int k = 6;
            String code = head.substring(2, 6);
            char c = (char)Integer.parseInt(code, 16);
            sb.append(tail);
            sb.append(c);
            ind = i + k;
        }
        if (ind != -1 && sb.length() > 0) {
            sb.append(e.substring(ind));
            return sb.toString();
        }
        return e;
    }

    public static String quote(String s) {
        int l = s.length();
        if (l == 0) {
            return s;
        }
        boolean noWordBoundary = false;
        StringBuilder sb = new StringBuilder(l + 12);
        sb.append("\\b\\Q");
        char[] arr = s.toCharArray();
        int codepoint = Character.codePointAt(arr, l - 1);
        if (!Character.isLetter(codepoint)) {
            noWordBoundary = true;
        }
        for (int i = 0; i < arr.length; ++i) {
            char c = arr[i];
            sb.append(c);
        }
        if (!noWordBoundary) {
            sb.append("\\E\\b");
        } else {
            sb.append("\\E");
        }
        return sb.toString();
    }

    public static int[][] lcs(String s1, String s2) {
        int m = s1.length();
        int n = s2.length();
        int[][] dp = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            for (int j = 0; j <= n; ++j) {
                dp[i][j] = i == 0 || j == 0 ? 0 : (s1.charAt(i - 1) == s2.charAt(j - 1) ? dp[i - 1][j - 1] + 1 : Math.max(dp[i - 1][j], dp[i][j - 1]));
            }
        }
        return dp;
    }

    public static String getDifferenceHTML(String s1, String s2) {
        int m = s1.length();
        int n = s2.length();
        int[][] dp = XMLHelper.lcs(s1, s2);
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuilder result = new StringBuilder();
        int i = m;
        int j = n;
        while (i > 0 || j > 0) {
            if (i > 0 && j > 0 && s1.charAt(i - 1) == s2.charAt(j - 1)) {
                list.add(0);
                result.append(s1.charAt(i - 1));
                --i;
                --j;
                continue;
            }
            if (j > 0 && (i == 0 || dp[i][j - 1] >= dp[i - 1][j])) {
                list.add(1);
                result.append(s2.charAt(j - 1));
                --j;
                continue;
            }
            if (i <= 0 || j != 0 && dp[i - 1][j] < dp[i][j - 1]) continue;
            list.add(-1);
            result.append(s1.charAt(i - 1));
            --i;
        }
        StringBuilder reversed = result.reverse();
        StringBuilder htmlResult = new StringBuilder();
        int o = 0;
        int y = 0;
        for (int k = list.size() - 1; k >= 0; --k) {
            int x = (Integer)list.get(k);
            char c = reversed.charAt(o);
            if (x == 0) {
                if (y != 0) {
                    htmlResult.append("</span>");
                }
                htmlResult.append(c);
            } else if (x == 1) {
                if (y != 1 && y != 0) {
                    htmlResult.append("</span>");
                }
                if (y != 1) {
                    htmlResult.append(HTMLFormat.trackingAddColorHTMLTag);
                }
                htmlResult.append(c);
            } else if (x == -1) {
                if (y != -1 && y != 0) {
                    htmlResult.append("</span>");
                }
                if (y != -1) {
                    htmlResult.append(HTMLFormat.trackingDeleteColorHTMLTag);
                }
                htmlResult.append(c);
            }
            y = x;
            ++o;
        }
        if (y != 0) {
            htmlResult.append("</span>");
        }
        return htmlResult.toString();
    }

    static {
        pipes = Pattern.compile("\\|");
        tags = Pattern.compile(AppPreferences.tags);
        customTags = Pattern.compile(AppPreferences.customTags);
        tagsAndCustomTags = Pattern.compile(AppPreferences.tags + "|" + AppPreferences.customTags);
        tagGroup = Pattern.compile(AppPreferences.tagGroups);
        tagGroupAndCustomTags = Pattern.compile(AppPreferences.tagGroups + "|" + AppPreferences.customTags);
        spaceWithTagGroups = Pattern.compile("[ ]*" + AppPreferences.tagGroups + "[ ]*|[ ]{2,}");
        spanTags = Pattern.compile("(<[/]*span[^<>]*>)+?");
        generalTags = Pattern.compile("(<[^>]*>)+?");
        hiddenTags = Pattern.compile("(<xntr[^>]*>)");
    }
}

