/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.CharArrayWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.xliff.CDATA;

public class XMLSourceSegmentHandler
extends DefaultHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    private XMLElement parent;
    private XMLElement root;
    private HashMap sm;
    private HashMap tm;

    public void setParent(XMLElement tu) {
        this.parent = tu;
    }

    public void setMaps(HashMap sm, HashMap tm) {
        this.sm = sm;
        this.tm = tm;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        DefaultXMLElement xml = new DefaultXMLElement();
        if (qName.equals("xtag0")) {
            this.root = xml;
        } else {
            XMLElement txml = null;
            txml = (XMLElement)this.sm.get(qName);
            if (txml == null) {
                txml = (XMLElement)this.tm.get(qName);
            }
            if (txml != null) {
                String n = txml.getName();
                if (AppPreferences.projectType == 3 && n.equals("!CDATA")) {
                    xml = new CDATA();
                }
                xml.setName(n);
                if (n.equals("ntr")) {
                    xml.setContent(0, txml.getContent(0));
                } else {
                    LinkedHashMap m = txml.getAttributes();
                    if (m != null) {
                        Set set = m.keySet();
                        Iterator<Object> it = set.iterator();
                        while (it.hasNext()) {
                            String key = it.next().toString();
                            String value = m.get(key).toString();
                            xml.setAttribute(key, value);
                        }
                    }
                    if (n.equals("ut") || n.equals("bpt") || n.equals("ept") || n.equals("it") || n.equals("ph")) {
                        List list = txml.getChildren();
                        for (Object object : list) {
                            xml.addChild(object);
                        }
                    }
                }
            } else {
                throw new SAXException("The tag " + qName + " is not found");
            }
        }
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            pxml.addChild(this.contents.toString());
        }
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            childXml.addChild(this.contents.toString());
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            String n = childXml.getName();
            if (n != null && n.equals("ntr")) {
                List ch = xml.getChildren();
                if (ch.size() > 0) {
                    Object ob = xml.getContent(ch.size() - 1);
                    if (ob instanceof String) {
                        String s = ob.toString() + childXml.getContent(0);
                        xml.setContent(ch.size() - 1, s);
                    } else {
                        xml.addChild(childXml.getContent(0));
                    }
                } else {
                    xml.addChild(childXml.getContent(0));
                }
            } else {
                xml.addChild(childXml);
            }
        }
        if (qName.equals("xtag0")) {
            List list = this.parent.getChildren();
            if (list != null && list.size() > 0) {
                list.clear();
            }
            List rlist = this.root.getChildren();
            for (Object o : rlist) {
                this.parent.addChild(o);
            }
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }
}

