/*
 * Decompiled with CFR 0.152.
 */
package translator.browser;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import translator.MainClass;
import translator.Placeables;
import translator.browser.Callback;
import translator.browser.Entry;
import translator.browser.Helpers;
import translator.browser.History;
import translator.browser.JScriptEditorsBinder;
import translator.browser.JScriptSearchExecutor;
import translator.browser.PersistentCookieStore;
import translator.web.Proz;
import translator.web.TMTown;

public class Browser
extends Callback.FX<String> {
    private final WebView view;
    private WebEngine engine;
    private History history;
    private Entry entry;
    private List<ChangeListener<String>> titleChangeListeners = new ArrayList<ChangeListener<String>>();
    private List<ChangeListener<String>> locationChangeListeners = new ArrayList<ChangeListener<String>>();
    private List<ChangeListener<Number>> progressChangeListeners = new ArrayList<ChangeListener<Number>>();
    private List<ChangeListener<Boolean>> runningChangeListeners = new ArrayList<ChangeListener<Boolean>>();
    private List<ChangeListener<Document>> documentChangeListeners = new ArrayList<ChangeListener<Document>>();
    private ChangeListener<Throwable> errorListener = null;
    private static PersistentCookieStore cookieStore;
    boolean persistentCookieStore = true;
    private URI currentURI;
    private boolean dragStarted = false;
    private boolean blockJavaScript = false;
    private String paragraphBorder = "border-style:solid; border-width:thin; border-color:#FF6600;";

    public Browser() {
        this.view = Helpers.doTask(new Callable<WebView>(){

            @Override
            public WebView call() throws Exception {
                final WebView webView = new WebView();
                webView.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handle(MouseEvent mouse) {
                        String selection = (String)webView.getEngine().executeScript("window.getSelection().toString()");
                        if (selection == null || selection.length() == 0) {
                            this.this$1.Browser.this.dragStarted = true;
                        }
                    }
                });
                webView.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handle(MouseEvent mouse) {
                        boolean ctrl = mouse.isShortcutDown();
                        if (!ctrl) {
                            if (!mouse.isStillSincePress() && this.this$1.Browser.this.dragStarted && mouse.getButton() == MouseButton.PRIMARY) {
                                this.this$1.Browser.this.dragStarted = false;
                                final String selection = (String)webView.getEngine().executeScript("window.getSelection().toString()");
                                if (selection != null && selection.length() > 0) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 2 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            String selection2 = Placeables.unmaskTarget(selection);
                                            MainClass.getMainView().getTargetView().grabSelection(selection2);
                                        }
                                    });
                                }
                            }
                        } else {
                            this.this$1.Browser.this.dragStarted = false;
                        }
                    }
                });
                Browser.this.engine = webView.getEngine();
                Browser.this.history = new History(Browser.this.engine);
                return webView;
            }
        });
        this.initHistory();
    }

    public Browser(String url) {
        this();
        this.load(url);
    }

    public Browser(boolean htmlDialog) {
        this.view = Helpers.doTask(new Callable<WebView>(){

            @Override
            public WebView call() throws Exception {
                WebView webView = new WebView();
                Browser.this.engine = webView.getEngine();
                return webView;
            }
        });
    }

    public WebView getWebView() {
        return this.view;
    }

    public void loadHTML(String str) {
        if (str != null) {
            if ((str = str.trim()).isEmpty()) {
                return;
            }
            this.callHTML(str);
        }
    }

    public void load(String str) {
        if (str != null) {
            if ((str = str.trim()).isEmpty()) {
                return;
            }
            URL url = Browser.toURL(str);
            if (url == null) {
                url = Browser.toURL("http://" + str);
            }
            if (url != null) {
                this.call(url.toExternalForm());
            }
        }
    }

    private static URL toURL(String str) {
        try {
            return new URL(str);
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }

    public void executeFocusScript() {
        if (this.currentURI != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JScriptSearchExecutor.executeFocusJScript(Browser.this.engine);
                }
            });
        }
    }

    public void executeSearchStript(final String word) {
        if (this.currentURI != null) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ Browser this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    JScriptSearchExecutor.executeSearchJScript(this.this$0.currentURI, word, this.this$0.engine);
                }
            });
        }
    }

    public void executeBindScript() {
        if (this.currentURI != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JScriptEditorsBinder.executeBindJScript(Browser.this.currentURI, Browser.this.engine);
                }
            });
        }
    }

    public static void stopBindScript() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JScriptEditorsBinder.stopBinding();
            }
        });
    }

    public void executeTransferScript() {
        if (this.currentURI != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JScriptEditorsBinder.executeTransferJScript(Browser.this.currentURI, Browser.this.engine);
                }
            });
        }
    }

    public void blockJavaScript(boolean block) {
        this.blockJavaScript = block;
    }

    public void findAndFrame(final String s, final boolean back) {
        Platform.runLater((Runnable)new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String script = !back ? "window.find('" + s + "',false,false,false,false,true,false);" : "window.find('" + s + "',false,true,false,false,true,false);";
                this.this$0.engine.executeScript(script);
            }
        });
    }

    public void findInPage(final String s, final boolean back) {
        Platform.runLater((Runnable)new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String script = !back ? "window.find('" + s + "',false,false,false,false,true,false);" : "window.find('" + s + "',false,true,false,false,true,false);";
                this.this$0.engine.executeScript(script);
            }
        });
    }

    public void stopPage() {
        Helpers.doAction(new Runnable(){

            @Override
            public void run() {
                Browser.this.engine.getLoadWorker().cancel();
            }
        });
    }

    public void reloadPage() {
        Helpers.doAction(new Runnable(){

            @Override
            public void run() {
                Browser.this.engine.reload();
            }
        });
    }

    private void initHistory() {
        Helpers.doAction(new Runnable(){

            @Override
            public void run() {
                Browser.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                        if (newValue != null) {
                            URI uri = URI.create(newValue);
                            Browser.this.currentURI = uri;
                            String host = uri.getHost();
                            if (host != null && Browser.this.blockJavaScript && Browser.this.engine.isJavaScriptEnabled()) {
                                Browser.this.engine.setJavaScriptEnabled(false);
                            }
                            Browser.this.entry = new Entry(newValue);
                        }
                    }
                });
                Browser.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                        if (Browser.this.entry != null) {
                            Browser.this.entry.setTitle(newValue);
                        } else {
                            Browser.this.history.update(newValue);
                        }
                    }
                });
                Browser.this.engine.documentProperty().addListener((ChangeListener)new ChangeListener<Document>(){

                    public void changed(ObservableValue<? extends Document> ov, Document oldValue, Document newValue) {
                        if (null != newValue && Browser.this.entry != null) {
                            if (TMTown.TMTownLinking) {
                                final String location = Browser.this.entry.getLocation();
                                if (location.startsWith(TMTown.redirectURL)) {
                                    System.out.println("link");
                                    TMTown.TMTownLinking = false;
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 3 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            boolean b = MainClass.getMainView().closeFloatingFrame("TM-Town - Authorization");
                                            if (!b) {
                                                MainClass.getMainView().getTabView().removeTab("TM-Town - Authorization");
                                            }
                                            TMTown tmtown = MainClass.getMainView().getResourceView().getTMTownService();
                                            MainClass.getMainView().getTabView().selectResourceTab(tmtown);
                                            tmtown.exchangeAuthorizationForToken(location);
                                        }
                                    });
                                } else if (location.startsWith(TMTown.accountURL)) {
                                    System.out.println("authorize");
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            boolean b = MainClass.getMainView().closeFloatingFrame("TM-Town - Authorization");
                                            if (b) {
                                                MainClass.getMainView().getResourceLoader().prepareWebResource(TMTown.authorizationRequest, "TM-Town - Authorization", false, true, -1);
                                            } else {
                                                MainClass.getMainView().getTabView().removeTab("TM-Town - Authorization");
                                                MainClass.getMainView().getResourceLoader().prepareWebResource(TMTown.authorizationRequest, "TM-Town - Authorization", false, false, -1);
                                            }
                                        }
                                    });
                                }
                            } else if (Proz.ProzLinking && Browser.this.entry.getLocation().startsWith(Proz.redirectURL)) {
                                System.out.println("link");
                                Proz.ProzLinking = false;
                                final String location = Browser.this.entry.getLocation();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 3 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        boolean b = MainClass.getMainView().closeFloatingFrame("ProZ.com - Authorization");
                                        if (!b) {
                                            MainClass.getMainView().getTabView().removeTab("ProZ.com - Authorization");
                                        }
                                        Proz proz = MainClass.getMainView().getResourceView().getProzService();
                                        MainClass.getMainView().getTabView().selectResourceTab(proz);
                                        proz.exchangeAuthorizationForToken(location);
                                    }
                                });
                            }
                            Browser.this.history.update(Browser.this.entry);
                            Browser.this.entry = null;
                        }
                    }
                });
            }
        });
    }

    public void removeAllHandlers() {
        Helpers.doAction(new Runnable(){

            @Override
            public void run() {
                for (ChangeListener c : Browser.this.locationChangeListeners) {
                    Browser.this.engine.locationProperty().removeListener(c);
                }
                for (ChangeListener c : Browser.this.titleChangeListeners) {
                    Browser.this.engine.titleProperty().removeListener(c);
                }
                for (ChangeListener c : Browser.this.progressChangeListeners) {
                    Browser.this.engine.getLoadWorker().workDoneProperty().removeListener(c);
                }
                for (ChangeListener c : Browser.this.runningChangeListeners) {
                    Browser.this.engine.getLoadWorker().runningProperty().removeListener(c);
                }
                for (ChangeListener c : Browser.this.documentChangeListeners) {
                    Browser.this.engine.documentProperty().removeListener(c);
                }
                Browser.this.locationChangeListeners.clear();
                Browser.this.titleChangeListeners.clear();
                Browser.this.progressChangeListeners.clear();
                Browser.this.runningChangeListeners.clear();
                Browser.this.runningChangeListeners.clear();
                Browser.this.documentChangeListeners.clear();
                Browser.this.engine.setOnStatusChanged(null);
                Browser.this.engine.setCreatePopupHandler(null);
            }
        });
    }

    public void addDocumentChangeListener(final Callback<Document> doc) {
        Helpers.doAction(new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.documentChangeListeners.add(Browser.addListener(doc, (ObservableValue)this.this$0.engine.documentProperty()));
            }
        });
    }

    public void addLocationChangeListener(final Callback<String> location) {
        Helpers.doAction(new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.locationChangeListeners.add(Browser.addListener(location, (ObservableValue)this.this$0.engine.locationProperty()));
            }
        });
    }

    public void addTitleChangeListener(final Callback<String> title) {
        Helpers.doAction(new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.titleChangeListeners.add(Browser.addListener(title, (ObservableValue)this.this$0.engine.titleProperty()));
            }
        });
    }

    public void addRunningChangeListener(final Callback<Boolean> callback) {
        Helpers.doAction(new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.runningChangeListeners.add(Browser.addListener(callback, (ObservableValue)this.this$0.engine.getLoadWorker().runningProperty()));
            }
        });
    }

    public void addProgressChangeListener(final Callback<Number> callback) {
        Helpers.doAction(new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.progressChangeListeners.add(Browser.addListener(callback, (ObservableValue)this.this$0.engine.getLoadWorker().workDoneProperty()));
            }
        });
    }

    public void setStatusHandler(final Callback<String> callback) {
        Helpers.doAction(new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(WebEvent<String> event) {
                        callback.call((String)event.getData());
                    }
                });
            }
        });
    }

    public void setCreatePopupHandler(final javafx.util.Callback<PopupFeatures, WebEngine> handler) {
        Helpers.doAction(new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.engine.setCreatePopupHandler(handler);
            }
        });
    }

    public void setErrorHandler(final Callback<Throwable> error) {
        Helpers.doAction(new Runnable(){
            final /* synthetic */ Browser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (error == null && this.this$0.errorListener != null) {
                    this.this$0.engine.getLoadWorker().exceptionProperty().removeListener(this.this$0.errorListener);
                } else {
                    this.this$0.engine.getLoadWorker().exceptionProperty().addListener(this.this$0.errorListener = (ChangeListener)new ChangeListener<Throwable>(){

                        public void changed(ObservableValue<? extends Throwable> o, Throwable old, Throwable value) {
                            if (this$0.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                                this$0.engine.getLoadWorker().getException().printStackTrace();
                                if (error != null) {
                                    error.call(this$0.engine.getLoadWorker().getException());
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private static <T> ChangeListener<T> addListener(final Callback<T> callback, ObservableValue<T> value) {
        if (callback != null) {
            ChangeListener handler = new ChangeListener<T>(){

                public void changed(ObservableValue<? extends T> value, T oldValue, T newValue) {
                    callback.call(newValue);
                }
            };
            value.addListener(handler);
            return handler;
        }
        return null;
    }

    @Override
    protected void callImpl(String value) {
        this.engine.load(value);
    }

    @Override
    protected void callImplHTML(String value) {
        this.engine.loadContent(value);
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public String getTitle() {
        return this.engine.getTitle();
    }

    public String getLocation() {
        return this.engine.getLocation();
    }

    public History getHistory() {
        return this.history;
    }

    public Entry getEntry() {
        return new Entry(this.engine.getLocation(), this.engine.getTitle());
    }

    private void markElement(String s, Element el) {
        if (el.getNodeName().equals("P")) {
            String content = el.getTextContent();
            boolean found = false;
            if (content != null && content.indexOf(s) != -1) {
                found = true;
            }
            this.iterate(el, found);
        } else {
            NodeList childNodes = el.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (!(item instanceof Element)) continue;
                this.markElement(s, (Element)item);
            }
        }
    }

    private void iterate(Element el, boolean found) {
        NamedNodeMap attributesList = el.getAttributes();
        String style = null;
        for (int j = 0; j < attributesList.getLength(); ++j) {
            String name = attributesList.item(j).getNodeName();
            if (!name.equals("style")) continue;
            style = attributesList.item(j).getNodeValue();
            break;
        }
        if (style != null) {
            int i = style.indexOf(this.paragraphBorder);
            if (!found) {
                if (i != -1) {
                    style = style.replace(this.paragraphBorder, "");
                    el.setAttribute("style", style);
                }
            } else if (i == -1) {
                style = style + this.paragraphBorder;
                el.setAttribute("style", style);
            }
        } else if (found) {
            el.setAttribute("style", this.paragraphBorder);
        }
    }

    private void highlight(WebEngine engine, String text) {
        engine.executeScript("$('body').removeHighlight().highlight('" + text + "')");
    }

    private void removeHighlight(WebEngine engine) {
        engine.executeScript("$('body').removeHighlight()");
    }

    public static void clearPersistentCookieStore() {
        if (cookieStore == null) {
            cookieStore = new PersistentCookieStore();
            cookieStore.removeAll();
            cookieStore = null;
        } else {
            cookieStore.removeAll();
        }
    }
}

