/*
 * Decompiled with CFR 0.152.
 */
package translator.browser;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.web.WebEngine;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLTextAreaElement;
import translator.AppPreferences;
import translator.MainClass;
import translator.Placeables;
import translator.XMLHelper;

public class JScriptEditorsBinder {
    private static Timeline repeatTask;
    private static Pattern patternHTMLTags;

    public static void executeTransferJScript(URI uri, WebEngine engine) {
        String host = uri.getHost();
        if (host != null) {
            if (host.startsWith("www.deepl.com")) {
                JScriptEditorsBinder.transferDeepL(engine);
            } else if (host.equals("translate.google.com")) {
                JScriptEditorsBinder.transferGT(engine);
            } else if (host.equals("www.bing.com")) {
                JScriptEditorsBinder.transferBingTranslator(engine);
            } else if (host.equals("fanyi.youdao.com")) {
                JScriptEditorsBinder.transferYoudaoTranslator(engine);
            } else if (host.equals("languagetool.org")) {
                JScriptEditorsBinder.transferLanguageTool(engine);
            } else if (host.equals("translate.systran.net")) {
                JScriptEditorsBinder.transferSystran(engine);
            } else if (host.equals("www.modernmt.com")) {
                JScriptEditorsBinder.transferModernMT(engine);
            }
        }
    }

    public static void executeBindJScript(URI uri, WebEngine engine) {
        String host = uri.getHost();
        if (host != null) {
            if (host.startsWith("www.deepl.com")) {
                JScriptEditorsBinder.bindDeepL(engine);
            } else if (host.equals("translate.google.com")) {
                JScriptEditorsBinder.bindGoogleTranslate(engine);
            } else if (host.equals("www.bing.com")) {
                JScriptEditorsBinder.bindBingTranslator(engine);
            }
        }
    }

    private static void transferDeepL(WebEngine engine) {
        int i = 1;
        final String result = (String)engine.executeScript("document.getElementsByClassName('--l --r sentence_highlight')[" + i + "].innerHTML");
        if (result != null && result.length() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String r = result.replaceAll("<br>", "\n");
                    Matcher m = patternHTMLTags.matcher(r);
                    r = m.replaceAll("").trim();
                    String segment = Placeables.unmaskTarget(r);
                    segment = XMLHelper.resolveEntitiesXML(segment);
                    MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                }
            });
        }
    }

    private static void transferModernMT(WebEngine engine) {
        HTMLTextAreaElement elem = (HTMLTextAreaElement)engine.getDocument().getElementsByTagName("textarea").item(1);
        final String result = elem.getTextContent();
        if (result != null && result.length() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String r = result.replaceAll("<br>", "\n");
                    Matcher m = patternHTMLTags.matcher(r);
                    r = m.replaceAll("").trim();
                    String segment = Placeables.unmaskTarget(r);
                    MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                }
            });
        }
    }

    private static void transferSystran(WebEngine engine) {
        int i = 0;
        final String result = (String)engine.executeScript("document.getElementsByClassName('htmlResultBox')[" + i + "].innerHTML");
        if (result != null && result.length() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String r = result.replaceAll("<br>", "\n");
                    Matcher m = patternHTMLTags.matcher(r);
                    r = m.replaceAll("").trim();
                    String segment = Placeables.unmaskTarget(r);
                    MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                }
            });
        }
    }

    private static void transferGT(WebEngine engine) {
        int i = 0;
        final String result = (String)engine.executeScript("document.getElementsByClassName('ryNqvb')[" + i + "].innerHTML");
        if (result != null && result.length() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String r = result.replaceAll("<br>", "\n");
                    Matcher m = patternHTMLTags.matcher(r);
                    r = m.replaceAll("").trim();
                    String segment = Placeables.unmaskTarget(r);
                    MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                }
            });
        }
    }

    private static void transferBingTranslator(WebEngine engine) {
        final String result = (String)engine.executeScript("document.getElementById('tta_output_ta').value");
        if (result != null && result.length() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String r = result.replaceAll("<br>", "\n");
                    Matcher m = patternHTMLTags.matcher(r);
                    r = m.replaceAll("").trim();
                    String segment = Placeables.unmaskTarget(r);
                    MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                }
            });
        }
    }

    private static void transferYoudaoTranslator(WebEngine engine) {
        String s = null;
        Document doc = engine.getDocument();
        Element elem = doc.getElementById("outputText");
        if (elem != null) {
            s = (String)engine.executeScript("document.getElementById('outputText').innerHTML");
        } else {
            elem = doc.getElementById("transTarget");
            if (elem != null) {
                s = (String)engine.executeScript("document.getElementById('transTarget').innerHTML");
            }
        }
        if (s != null && s.length() > 0) {
            final String result = s;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String r = result.replaceAll("<br>", "\n");
                    Matcher m = patternHTMLTags.matcher(r);
                    r = m.replaceAll("").trim();
                    String segment = Placeables.unmaskTarget(r);
                    MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                }
            });
        }
    }

    private static void transferLanguageTool(WebEngine engine) {
        String s;
        Node node;
        Element elem;
        Document doc2;
        Document doc = engine.getDocument();
        if (doc != null && (doc2 = (Document)engine.executeScript("document.getElementById('checktext_ifr').contentWindow.document")) != null && (elem = doc2.getElementById("tinymce")) != null && (node = elem.getFirstChild()) != null && (s = node.getTextContent()) != null) {
            MainClass.getMainView().getTargetView().setWebMachineTranslation(s);
        }
    }

    private static void bindDeepL(final WebEngine engine) {
        JScriptEditorsBinder.stopBinding();
        repeatTask = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)2000.0), (EventHandler)new EventHandler<ActionEvent>(){
            private String oldString = "";

            public void handle(ActionEvent event) {
                if (!AppPreferences.bindExternalEditor) {
                    repeatTask.stop();
                    repeatTask = null;
                    return;
                }
                int i = 0;
                String newString = (String)engine.executeScript("document.getElementsByClassName('lmt__textarea lmt__target_textarea lmt__textarea_base_style')[" + i + "].value");
                if (newString != null && !this.oldString.equals(newString)) {
                    this.oldString = newString;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String segment = Placeables.unmaskTarget(oldString);
                            MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                        }
                    });
                }
            }
        }, new KeyValue[0])});
        repeatTask.setCycleCount(-1);
        repeatTask.play();
    }

    private static void bindGoogleTranslate(final WebEngine engine) {
        JScriptEditorsBinder.stopBinding();
        repeatTask = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)2000.0), (EventHandler)new EventHandler<ActionEvent>(){
            private String oldString = "";

            public void handle(ActionEvent event) {
                if (!AppPreferences.bindExternalEditor) {
                    repeatTask.stop();
                    repeatTask = null;
                    return;
                }
                int i = 0;
                String newString = (String)engine.executeScript("document.getElementsByClassName('tlid-translation translation')[" + i + "].innerHTML");
                if (newString != null && !this.oldString.equals(newString)) {
                    this.oldString = newString;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String r = oldString.replaceAll("<br>", "\n");
                            Matcher m = patternHTMLTags.matcher(r);
                            r = m.replaceAll("").trim();
                            String segment = Placeables.unmaskTarget(r);
                            MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                        }
                    });
                }
            }
        }, new KeyValue[0])});
        repeatTask.setCycleCount(-1);
        repeatTask.play();
    }

    private static void bindBingTranslator(final WebEngine engine) {
        JScriptEditorsBinder.stopBinding();
        repeatTask = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)2000.0), (EventHandler)new EventHandler<ActionEvent>(){
            private String oldString = "";

            public void handle(ActionEvent event) {
                if (!AppPreferences.bindExternalEditor) {
                    repeatTask.stop();
                    repeatTask = null;
                    return;
                }
                String newString = (String)engine.executeScript("document.getElementById('t_tv').value");
                if (newString != null && !this.oldString.equals(newString)) {
                    this.oldString = newString;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String r = oldString.replaceAll("<br>", "\n");
                            Matcher m = patternHTMLTags.matcher(r);
                            r = m.replaceAll("").trim();
                            String segment = Placeables.unmaskTarget(r);
                            MainClass.getMainView().getTargetView().setWebMachineTranslation(segment);
                        }
                    });
                }
            }
        }, new KeyValue[0])});
        repeatTask.setCycleCount(-1);
        repeatTask.play();
    }

    public static void stopBinding() {
        if (repeatTask != null) {
            repeatTask.stop();
            repeatTask = null;
        }
    }

    static {
        patternHTMLTags = Pattern.compile("<[^>]*>", 2);
    }
}

