/*
 * Decompiled with CFR 0.152.
 */
package translator.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import translator.AppPreferences;
import translator.browser.Browser;
import translator.browser.Callback;
import translator.browser.History;

public class WebPane
extends JPanel {
    private final Browser browser;
    private final JFXPanel jfxPanel = new JFXPanel();
    private History history;

    public WebPane() {
        this(new Browser());
    }

    public WebPane(String url) {
        this(new Browser(url));
    }

    public WebPane(final Browser browser) {
        super(new BorderLayout());
        this.browser = browser;
        this.history = browser.getHistory();
        this.initBrowserHandlers();
        Platform.runLater((Runnable)new Runnable(){
            final /* synthetic */ WebPane this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                BorderPane pane = new BorderPane();
                Scene scene = new Scene((Parent)pane);
                pane.setCenter((Node)this.this$0.getBrowser().getWebView());
                this.this$0.jfxPanel.setScene(scene);
                if (AppPreferences.fontScaleWebsites != 1.0) {
                    browser.getWebView().setFontScale(AppPreferences.fontScaleWebsites);
                }
            }
        });
        this.add("Center", (Component)this.jfxPanel);
    }

    public void load(String url) {
        this.getBrowser().load(url);
    }

    public void findAndFrame(String s, boolean back) {
        this.getBrowser().findAndFrame(s, back);
    }

    public void findInPage(String s, boolean back) {
        this.getBrowser().findInPage(s, back);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public JFXPanel getJFXPanel() {
        return this.jfxPanel;
    }

    public void disposeComponent() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebPane.this.getBrowser().removeAllHandlers();
                WebPane.this.jfxPanel.setScene(null);
            }
        });
    }

    void goBack() {
        this.history.set(-1);
    }

    void goForward() {
        this.history.set(1);
    }

    void zoomUp() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                double d = WebPane.this.browser.getWebView().getFontScale();
                WebPane.this.browser.getWebView().setFontScale(d + 0.1);
            }
        });
    }

    public void takeFocus() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebPane.this.browser.getWebView().requestFocus();
            }
        });
    }

    void zoomDown() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                double d = WebPane.this.browser.getWebView().getFontScale();
                WebPane.this.browser.getWebView().setFontScale(d - 0.1);
            }
        });
    }

    private void initBrowserHandlers() {
        this.getBrowser().setErrorHandler((Callback<Throwable>)new Callback.EDT<Throwable>(){

            @Override
            protected void callImpl(Throwable value) {
                JOptionPane.showMessageDialog(WebPane.this, value != null ? WebPane.this.getBrowser().getLocation() + "\n" + value.getMessage() : WebPane.this.getBrowser().getLocation() + "\nUnexpected error.", "Loading error...", 0);
            }

            @Override
            protected void callImplHTML(Throwable value) {
                JOptionPane.showMessageDialog(WebPane.this, value != null ? WebPane.this.getBrowser().getLocation() + "\n" + value.getMessage() : WebPane.this.getBrowser().getLocation() + "\nUnexpected error.", "Loading error...", 0);
            }
        });
        this.getBrowser().setStatusHandler((Callback<String>)new Callback.EDT<String>(){

            @Override
            protected void callImpl(String value) {
            }

            @Override
            protected void callImplHTML(String value) {
            }
        });
        this.getBrowser().addTitleChangeListener((Callback<String>)new Callback.EDT<String>(){

            @Override
            protected void callImpl(String value) {
                if (value != null) {
                    // empty if block
                }
            }

            @Override
            protected void callImplHTML(String value) {
                if (value != null) {
                    // empty if block
                }
            }
        });
    }
}

