/*
 * Decompiled with CFR 0.152.
 */
package translator.database;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.MainView;
import translator.ResourceView;
import translator.database.DBConnection;
import translator.database.Term;
import translator.database.TermBase;
import translator.database.TextAreaEditor;
import translator.ui.GridPanel;
import translator.ui.UITools;

public class DataBaseUI
extends GridPanel {
    private DBConnection connection;
    private TermBase base;
    private MainView topui;
    private JTextField urlField;
    private JPanel jPanel1;
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private BindingGroup bindingGroup;

    public DataBaseUI(MainView ui, TermBase base) {
        this.topui = ui;
        this.base = base;
        this.connection = base.getConnection();
        String nq = this.connection.getNextRowsQuery();
        if (nq == null) {
            this.connection.selectAllRows();
        } else {
            this.connection.selectRows(nq);
        }
        if (this.connection.srcCol == -1 || this.connection.trgCol == -1) {
            base.showTableInfo(ui);
        } else {
            this.connection.nextTerms();
        }
        if (AppPreferences.alpha != -1 && !AppPreferences.laf.equals("Substance")) {
            this.setOpaque(false);
            this.setGrid(false);
            this.setTransparent(false);
        } else if (AppPreferences.tBackgroundIm.length() > 0) {
            File file = new File(AppPreferences.tBackgroundIm);
            if (file.exists()) {
                try {
                    URL url = file.toURI().toURL();
                    this.setImage(url);
                }
                catch (IOException ex) {
                    Logger.getLogger(DataBaseUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.setOpaque(true);
        } else {
            this.setOpaque(true);
            this.setGrid(AppPreferences.backGrid);
            if (AppPreferences.background != 0 && AppPreferences.alpha == -1) {
                this.setBackground(new Color(AppPreferences.background));
            }
        }
        this.initComponents();
        this.topui.getResourceView().showTotalRecallSearchButtons();
    }

    public DataBaseUI() {
        this.connection = this.base.getConnection();
        this.initComponents();
        this.topui.getResourceView().showTotalRecallSearchButtons();
    }

    private void initComponents() {
        String ccol;
        String rcol;
        String ncol;
        String fcol;
        String idcol;
        String tcol;
        this.bindingGroup = new BindingGroup();
        Color background = null;
        Color foreground = null;
        Color selection = null;
        if (AppPreferences.background != 0 || AppPreferences.tBackgroundIm.length() > 0) {
            background = new Color(AppPreferences.background);
            foreground = new Color(AppPreferences.foreground);
            selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
        }
        this.masterScrollPane = new JScrollPane();
        this.masterScrollPane.setOpaque(false);
        this.masterScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.masterScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            this.masterScrollPane.getViewport().setOpaque(false);
        }
        this.masterTable = new JTable();
        if (AppPreferences.operatingSystem == 1) {
            this.masterTable.setGridColor(Color.LIGHT_GRAY);
        }
        this.jPanel1 = new JPanel();
        this.jPanel1.setBorder(new EmptyBorder(4, 0, 0, 0));
        if (AppPreferences.windowsLayout == 1 || AppPreferences.windowsLayout == 2) {
            this.jPanel1.setLayout(new GridLayout(0, 1, 2, 2));
        } else {
            this.jPanel1.setLayout(new GridLayout(1, 0, 2, 2));
        }
        this.jPanel1.setOpaque(false);
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (List)this.connection.getTermsList(), (JTable)this.masterTable);
        int i = 0;
        int[] types = this.connection.getColumnTypes();
        int max = 1;
        int maxInt = 1;
        int maxTime = 1;
        int maxDate = 1;
        int maxTimestamp = 1;
        int epanes = 0;
        List cols = this.connection.getColumnNames();
        String scol = this.connection.getSourceLang();
        if (scol.indexOf("-") != -1) {
            scol = scol.replaceAll("-", "_");
        }
        if ((tcol = this.connection.getTargetLang()).indexOf("-") != -1) {
            tcol = tcol.replaceAll("-", "_");
        }
        if ((idcol = this.connection.getClientIDName()).indexOf("-") != -1) {
            idcol = idcol.replaceAll("-", "_");
        }
        if ((fcol = this.connection.getFieldName()).indexOf("-") != -1) {
            fcol = fcol.replaceAll("-", "_");
        }
        if ((ncol = this.connection.getNotesName()).indexOf("-") != -1) {
            ncol = ncol.replaceAll("-", "_");
        }
        if ((rcol = this.connection.getReferenceName()).indexOf("-") != -1) {
            rcol = rcol.replaceAll("-", "_");
        }
        if ((ccol = this.connection.getContextName()).indexOf("-") != -1) {
            ccol = ccol.replaceAll("-", "_");
        }
        for (String column : cols) {
            JTableBinding.ColumnBinding columnBinding;
            String s;
            int type = types[i];
            ++i;
            if (type == 12 || type == -9) {
                TitledBorder border;
                s = null;
                if (column.equalsIgnoreCase(tcol)) {
                    s = "target";
                } else if (column.equalsIgnoreCase(scol)) {
                    s = "source";
                } else if (column.equalsIgnoreCase(idcol)) {
                    s = "id";
                } else if (column.equalsIgnoreCase(fcol)) {
                    s = "field";
                } else if (column.equalsIgnoreCase(ccol)) {
                    s = "context";
                } else if (column.equalsIgnoreCase(ncol)) {
                    s = "note";
                } else if (column.equalsIgnoreCase(rcol)) {
                    s = "reference";
                } else if (max == 1) {
                    ++max;
                    s = "one";
                } else if (max == 2) {
                    ++max;
                    s = "two";
                } else if (max == 3) {
                    ++max;
                    s = "three";
                } else if (max == 4) {
                    ++max;
                    s = "four";
                } else if (max == 5) {
                    ++max;
                    s = "five";
                } else if (max == 6) {
                    ++max;
                    s = "six";
                }
                if (s == null) continue;
                columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
                columnBinding.setColumnName(column);
                columnBinding.setColumnClass(String.class);
                if (s.equals("reference")) {
                    ++epanes;
                    this.urlField = new JTextField();
                    this.urlField.setFont(this.urlField.getFont().deriveFont(1));
                    this.urlField.setPreferredSize(new Dimension(320, 28));
                    JButton file = new JButton();
                    file.setPreferredSize(new Dimension(28, 28));
                    file.setMaximumSize(new Dimension(28, 28));
                    file.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET REFERENCE"));
                    FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FOLDER_PLUS, (int)file.getFont().getSize(), (Color)file.getForeground());
                    file.setIcon((Icon)ficon);
                    file.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            File f;
                            final String loc = !AppPreferences.dbURLRef.startsWith("http") ? ((f = new File(AppPreferences.dbURLRef)).exists() ? f.getPath() : System.getProperty("user.home")) : System.getProperty("user.home");
                            if (AppPreferences.isJavaFXReady()) {
                                Platform.runLater((Runnable)new Runnable(){
                                    final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            File file;
                                            FileChooser fileChooser = new FileChooser();
                                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                                            File f = new File(loc);
                                            if (f.isDirectory() && f.canRead()) {
                                                fileChooser.setInitialDirectory(f);
                                            }
                                            if ((file = fileChooser.showOpenDialog(null)) != null) {
                                                SwingUtilities.invokeLater(new Runnable(){
                                                    final /* synthetic */ 1 this$2;
                                                    {
                                                        this.this$2 = this$2;
                                                    }

                                                    @Override
                                                    public void run() {
                                                        String path = file.getPath();
                                                        this.this$2.this$1.DataBaseUI.this.urlField.setText(path);
                                                        AppPreferences.dbURLRef = file.getParent();
                                                    }
                                                });
                                            }
                                        }
                                        catch (Exception ex) {
                                            final String s = ex.getMessage();
                                            SwingUtilities.invokeLater(new Runnable(){
                                                final /* synthetic */ 1 this$2;
                                                {
                                                    this.this$2 = this$2;
                                                }

                                                @Override
                                                public void run() {
                                                    JOptionPane.showMessageDialog(this.this$2.this$1.DataBaseUI.this, s);
                                                }
                                            });
                                        }
                                    }
                                });
                            } else {
                                JFileChooser jch = new JFileChooser(loc);
                                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                                jch.setFileSelectionMode(2);
                                if (0 == jch.showOpenDialog(DataBaseUI.this.topui)) {
                                    File file = jch.getSelectedFile();
                                    String path = file.getPath();
                                    DataBaseUI.this.urlField.setText(path);
                                    AppPreferences.dbURLRef = path;
                                }
                            }
                        }
                    });
                    JButton open = new JButton();
                    open.setPreferredSize(new Dimension(28, 28));
                    open.setMaximumSize(new Dimension(28, 28));
                    open.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VIEW REFERENCE"));
                    ficon = FontIcon.of((Ikon)MaterialDesign.MDI_EYE, (int)open.getFont().getSize(), (Color)open.getForeground());
                    open.setIcon((Icon)ficon);
                    open.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String path = DataBaseUI.this.urlField.getText();
                            if (path.startsWith("file")) {
                                try {
                                    File file = new File(new URI(path));
                                    if (file.exists()) {
                                        AppPreferences.dbURLRef = path;
                                        DataBaseUI.this.topui.getResourceView().viewFile(file);
                                    }
                                }
                                catch (URISyntaxException ex) {
                                    Logger.getLogger(DataBaseUI.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            } else if (path.startsWith("http")) {
                                try {
                                    AppPreferences.dbURLRef = path;
                                    URI uri = new URI(path);
                                    DataBaseUI.this.topui.getResourceView();
                                    ResourceView.browse(uri);
                                }
                                catch (URISyntaxException ex) {
                                    Logger.getLogger(DataBaseUI.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            } else {
                                File file = new File(path);
                                if (file.exists()) {
                                    AppPreferences.dbURLRef = path;
                                    DataBaseUI.this.topui.getResourceView().viewFile(file);
                                }
                            }
                        }
                    });
                    JPanel rpanel = new JPanel();
                    Color titleColor = new Color(255, 120, 0);
                    TitledBorder border2 = BorderFactory.createTitledBorder(null, column, 0, 0, null, titleColor);
                    rpanel.setBorder(border2);
                    rpanel.setOpaque(false);
                    rpanel.add(file);
                    rpanel.add(this.urlField);
                    rpanel.add(open);
                    AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.masterTable, (Property)ELProperty.create((String)("${selectedElement." + s + "}")), (Object)this.urlField, (Property)BeanProperty.create((String)"text"));
                    this.bindingGroup.addBinding((Binding)binding);
                    this.jPanel1.add(rpanel);
                    continue;
                }
                if (!s.equals("source") && !s.equals("target")) continue;
                ++epanes;
                JScrollPane jScrollPane1 = new JScrollPane();
                jScrollPane1.setOpaque(false);
                Color titleColor = new Color(255, 120, 0);
                String val = LanguageCodes.getName(column.replace("_", "-"));
                if (val != null) {
                    border = BorderFactory.createTitledBorder(null, val, 0, 0, null, titleColor);
                    jScrollPane1.setBorder(border);
                } else {
                    border = BorderFactory.createTitledBorder(null, column, 0, 0, null, titleColor);
                    jScrollPane1.setBorder(border);
                }
                jScrollPane1.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
                JTextPane jTextArea1 = new JTextPane();
                if (background != null) {
                    jTextArea1.setCaretColor(foreground);
                    jTextArea1.setBackground(background);
                    jTextArea1.setForeground(foreground);
                    jTextArea1.setSelectedTextColor(foreground);
                    jTextArea1.setSelectionColor(selection);
                }
                jTextArea1.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, 16));
                StyledDocument document = jTextArea1.getStyledDocument();
                document.addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        int len = e.getLength();
                        if (len > 1) {
                            StyledDocument doc = (StyledDocument)e.getDocument();
                            DataBaseUI.this.highlightWord(doc);
                        }
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                    }
                });
                if (s.equals("target") || s.equals("source")) {
                    jTextArea1.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            JTextPane a;
                            String sel;
                            boolean ctrl = UITools.isShortcutDown(e);
                            if (!ctrl && (sel = (a = (JTextPane)e.getSource()).getSelectedText()) != null) {
                                DataBaseUI.this.topui.getTargetView().grabSelection(sel);
                            }
                        }
                    });
                }
                AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.masterTable, (Property)ELProperty.create((String)("${selectedElement." + s + "}")), (Object)jTextArea1, (Property)BeanProperty.create((String)"text"));
                this.bindingGroup.addBinding((Binding)binding);
                if (AppPreferences.backGrid) {
                    jScrollPane1.getViewport().setOpaque(false);
                    jTextArea1.setBackground(new Color(0, 0, 0, 0));
                    jTextArea1.setOpaque(false);
                }
                jScrollPane1.setViewportView(jTextArea1);
                this.jPanel1.add(jScrollPane1);
                continue;
            }
            if (type == 4 || type == 2) {
                s = null;
                if (maxInt == 1) {
                    ++maxInt;
                    s = "integer";
                }
                if (s == null) continue;
                columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
                if (column.equals("docid")) {
                    columnBinding.setColumnName("Id");
                } else {
                    columnBinding.setColumnName(column);
                }
                columnBinding.setColumnClass(Integer.class);
                continue;
            }
            if (type == 91) {
                s = null;
                if (maxDate == 1) {
                    ++maxDate;
                    s = "date";
                }
                if (s == null) continue;
                columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
                columnBinding.setColumnName(column);
                columnBinding.setColumnClass(Date.class);
                continue;
            }
            if (type == 92) {
                s = null;
                if (maxTime == 1) {
                    ++maxTime;
                    s = "time";
                }
                if (s == null) continue;
                columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
                columnBinding.setColumnName(column);
                columnBinding.setColumnClass(Time.class);
                continue;
            }
            if (type != 93) continue;
            s = null;
            if (maxTimestamp == 1) {
                ++maxTimestamp;
                s = "timestamp";
            }
            if (s == null) continue;
            columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
            columnBinding.setColumnName(column);
            columnBinding.setColumnClass(Timestamp.class);
        }
        this.bindingGroup.addBinding((Binding)jTableBinding);
        jTableBinding.bind();
        Font font2 = this.masterTable.getFont().deriveFont((float)AppPreferences.pfontsize);
        this.masterTable.setFont(font2);
        int rowSize = AppPreferences.pfontsize + 8;
        this.masterTable.setRowHeight(rowSize);
        TextAreaEditor textEditor = new TextAreaEditor();
        int count = this.masterTable.getColumnModel().getColumnCount();
        Iterator it = cols.iterator();
        for (i = 0; it.hasNext() && i < count; ++i) {
            String column = (String)it.next();
            int type = types[i];
            if (type == 4 || type == 2) {
                this.masterTable.getColumnModel().getColumn(i).setMaxWidth(100);
                continue;
            }
            if (type == 91) {
                this.masterTable.getColumnModel().getColumn(i).setMaxWidth(150);
                continue;
            }
            if (type == 92) {
                this.masterTable.getColumnModel().getColumn(i).setMaxWidth(100);
                continue;
            }
            if (type == 93) {
                this.masterTable.getColumnModel().getColumn(i).setMaxWidth(150);
                continue;
            }
            this.masterTable.getColumnModel().getColumn(i).setCellEditor(textEditor);
        }
        this.masterScrollPane.setViewportView(this.masterTable);
        JSplitPane jsplit = new JSplitPane();
        jsplit.setOpaque(false);
        jsplit.setOrientation(0);
        jsplit.setBorder(BorderFactory.createEmptyBorder());
        jsplit.setDividerSize(AppPreferences.dividerSize + 4);
        jsplit.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JSplitPane spane = (JSplitPane)e.getComponent();
                spane.setDividerLocation(0.7);
            }
        });
        jsplit.setDividerLocation(0.7);
        jsplit.setRightComponent(this.jPanel1);
        jsplit.setLeftComponent(this.masterScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)jsplit, "Center");
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        if (AppPreferences.alpha != -1) {
            bar.setOpaque(false);
        } else {
            bar.setOpaque(true);
        }
        if (AppPreferences.tbackground2 != 0) {
            if (!AppPreferences.backGrid) {
                bar.setBackground(this.topui.getMainPanelBackgroundColor());
            } else {
                bar.setBackground(GridPanel.darker(this.topui.getMainPanelBackgroundColor(), 0.92));
            }
        }
        JButton buttonPrevious = new JButton();
        buttonPrevious.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonPrevious.setOpaque(false);
        buttonPrevious.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BACK"));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_LEFT, (int)(buttonPrevious.getFont().getSize() + 4), (Color)buttonPrevious.getForeground());
        buttonPrevious.setIcon((Icon)ficon);
        buttonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseUI.this.base.previousResource();
            }
        });
        JButton buttonNextP = new JButton();
        buttonNextP.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonNextP.setOpaque(false);
        buttonNextP.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FORWARD"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT, (int)(buttonNextP.getFont().getSize() + 4), (Color)buttonNextP.getForeground());
        buttonNextP.setIcon((Icon)ficon);
        buttonNextP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseUI.this.base.nextResource();
            }
        });
        JButton buttonDelete = new JButton();
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TABLE_ROW_REMOVE, (int)(buttonDelete.getFont().getSize() + 4), (Color)buttonDelete.getForeground());
        buttonDelete.setIcon((Icon)ficon);
        buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseUI.this.base.deleteEntry();
            }
        });
        buttonDelete.setOpaque(false);
        buttonDelete.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE ENTRY"));
        buttonDelete.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        JButton buttonAdd = new JButton();
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseUI.this.base.newEntry();
            }
        });
        buttonAdd.setOpaque(false);
        buttonAdd.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD ENTRY"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TABLE_ROW_PLUS_AFTER, (int)(buttonAdd.getFont().getSize() + 4), (Color)buttonAdd.getForeground());
        buttonAdd.setIcon((Icon)ficon);
        buttonAdd.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        JButton saveTable = new JButton();
        saveTable.setOpaque(false);
        saveTable.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE AND REFRESH MEMORY TABLE"));
        saveTable.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_REFRESH, (int)(saveTable.getFont().getSize() + 4), (Color)saveTable.getForeground());
        saveTable.setIcon((Icon)ficon);
        saveTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseUI.this.base.saveResource();
            }
        });
        JButton buttonInfo = new JButton();
        buttonInfo.setOpaque(false);
        buttonInfo.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_INFORMATION, (int)(buttonInfo.getFont().getSize() + 4), (Color)buttonInfo.getForeground());
        buttonInfo.setIcon((Icon)ficon);
        buttonInfo.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW MEMORY TABLE INFO..."));
        buttonInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseUI.this.base.showTableInfo(DataBaseUI.this.topui);
            }
        });
        JButton buttonClose = new JButton();
        buttonClose.setOpaque(false);
        buttonClose.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonClose.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE MEMORY TABLE"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)(buttonClose.getFont().getSize() + 4), (Color)buttonClose.getForeground());
        buttonClose.setIcon((Icon)ficon);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseUI.this.base.closeResource();
                Container cont = DataBaseUI.this.getTopLevelAncestor();
                if (cont instanceof JFrame) {
                    JFrame frame = (JFrame)cont;
                    frame.dispose();
                }
            }
        });
        if (this.connection.getSQLType() == 2) {
            bar.add(buttonPrevious);
        }
        bar.add(buttonNextP);
        bar.add(buttonDelete);
        bar.add(buttonAdd);
        bar.add(buttonInfo);
        bar.add(saveTable);
        bar.add(buttonClose);
        this.add((Component)bar, "South");
        this.bindingGroup.bind();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.connection.updateDB();
        this.repaint();
    }

    public void deleteAction() {
        List terms = this.connection.getTermsList();
        int[] selected = this.masterTable.getSelectedRows();
        ArrayList<Term> toRemove = new ArrayList<Term>(selected.length);
        for (int idx = 0; idx < selected.length; ++idx) {
            Term t = (Term)terms.get(this.masterTable.convertRowIndexToModel(selected[idx]));
            toRemove.add(t);
        }
        terms.removeAll(toRemove);
        this.connection.removeTerms(toRemove);
        this.repaint();
    }

    public Term newAction() {
        List terms = this.connection.getTermsList();
        Term t = this.connection.newTerm();
        terms.add(t);
        int row = terms.size() - 1;
        this.masterTable.setRowSelectionInterval(row, row);
        this.masterTable.scrollRectToVisible(this.masterTable.getCellRect(row, 0, true));
        return t;
    }

    void refreshUI() {
        this.removeAll();
        this.initComponents();
        this.validate();
        this.repaint();
    }

    void selectCell(int row, int column) {
        int i = this.masterTable.getRowCount();
        if (i > 0) {
            this.masterTable.changeSelection(row, column, false, false);
            this.masterTable.requestFocusInWindow();
        } else {
            Component[] comps = this.jPanel1.getComponents();
            for (int j = 0; j < comps.length; ++j) {
                Component component = comps[j];
                if (!(component instanceof JScrollPane)) continue;
                JScrollPane scroll = (JScrollPane)component;
                JTextPane tpane = (JTextPane)scroll.getViewport().getComponent(0);
                tpane.setText("");
            }
        }
    }

    JTable getTable() {
        return this.masterTable;
    }

    public void highlightWord(final StyledDocument doc) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ DataBaseUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    String text;
                    String word = this.this$0.topui.getResourceView().getLookUpText();
                    if (word != null && (text = doc.getText(0, doc.getLength())).length() > word.length()) {
                        Pattern p = Pattern.compile(word, 18);
                        Matcher ma = p.matcher(text);
                        while (ma.find()) {
                            int s = ma.start();
                            int e = ma.end();
                            doc.setCharacterAttributes(s, e - s, this.this$0.topui.getSourcePane().getStyle("highlight"), false);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

