/*
 * Decompiled with CFR 0.152.
 */
package translator.database;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextPane;
import translator.GlossaryNewEntryEditor;
import translator.MainView;
import translator.MySwingWorker;
import translator.Resource;
import translator.TargetView;
import translator.database.DBConnection;
import translator.database.DataBaseUI;
import translator.database.DatabaseView;
import translator.database.TableInfoDialog;
import translator.database.Term;

public class TermBase
extends Resource {
    private DBConnection connection;
    private String name;
    private MainView parent;
    private DataBaseUI ui;
    private boolean loaded;
    private boolean isBlocked;

    public TermBase(String name) {
        this.name = name;
    }

    public void setBlocked(boolean b) {
        this.isBlocked = b;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setLoaded(boolean l) {
        this.loaded = l;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setUI(DataBaseUI ui) {
        this.ui = ui;
    }

    public DataBaseUI getUI() {
        return this.ui;
    }

    private void openTable() {
        this.connection.setTable(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setConnection(DBConnection con) {
        this.connection = con;
    }

    public DBConnection getConnection() {
        return this.connection;
    }

    private String makeQuery(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            String word = s.substring(1, s.lastIndexOf(34));
            word = Pattern.quote(word);
            s = "\\b" + word + "\\b";
        } else if (s.indexOf("+") != -1) {
            String[] mm = Pattern.compile("+", 16).split(s);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mm.length; ++i) {
                String string = mm[i];
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = Pattern.quote(string);
                    string = "\\b" + string + "\\b";
                }
                sb.append("(?=.*");
                sb.append(string);
                sb.append(")");
            }
            s = sb.toString();
        }
        return s;
    }

    public void addEntry(String s, String t, String u, String f, String n, String r, String c) {
        Term term = this.ui.newAction();
        term.setSource(s);
        term.setTarget(t);
        if (u != null && u.length() > 0) {
            term.setId(u);
        }
        if (f != null && f.length() > 0) {
            term.setField(f);
        }
        if (c != null && c.length() > 0) {
            term.setContext(c);
        }
        if (n != null && n.length() > 0) {
            term.setNote(n);
        }
        if (r != null && r.length() > 0) {
            term.setReference(r);
        }
    }

    @Override
    public void setMainView(MainView mv) {
        this.parent = mv;
    }

    public MainView getTopUI() {
        return this.parent;
    }

    public void searchSource(String search, String replace) {
        this.connection.searchSourceDataBase(search, replace);
        this.ui.selectCell(0, 0);
        this.ui.repaint();
    }

    public void searchTarget(String search, String replace) {
        this.connection.searchTargetDataBase(search, replace);
        this.ui.selectCell(0, 0);
        this.ui.repaint();
    }

    @Override
    public void search(String search, String replace) {
        JProgressBar bar;
        final String s = search;
        final String r = replace;
        if (s.startsWith("sql>")) {
            bar = this.parent.getPretranslateProgressBar();
            bar.setIndeterminate(true);
            bar.setStringPainted(true);
            bar.setString(s);
        } else {
            bar = null;
        }
        MySwingWorker worker = new MySwingWorker(this){
            final /* synthetic */ TermBase this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                if (s.startsWith("sql>")) {
                    String command = s.substring(4);
                    if (command.length() > 0) {
                        this.this$0.connection.executeSQLCommand(command.trim());
                    }
                } else {
                    this.this$0.connection.searchSourceDataBase(s, r);
                }
                return null;
            }

            @Override
            public void finished() {
                this.this$0.ui.selectCell(0, 0);
                this.this$0.ui.repaint();
                if (bar != null) {
                    this.this$0.parent.removePretranslateProgressBar(bar);
                }
            }
        };
        worker.setPriority(5);
        worker.start();
    }

    @Override
    public void stopSearch() {
    }

    public void addEntryDirectToBase() {
        JTextPane sp = this.parent.getSourcePane();
        JTextPane tp = this.parent.getTargetPane();
        String key = sp.getSelectedText();
        String entry = tp.getSelectedText();
        if (key == null) {
            key = sp.getText();
        }
        if (entry == null) {
            entry = tp.getText();
        }
        if (key != null && key.length() > 0 && entry != null && entry.length() > 0) {
            this.addEntry(key, entry, null, null, null, null, null);
            int cp = sp.getSelectionEnd();
            if (cp != -1) {
                sp.setCaretPosition(cp);
            }
            if ((cp = tp.getSelectionEnd()) != -1) {
                tp.setCaretPosition(cp);
            }
        }
    }

    @Override
    public void newResource() {
        JTextPane jpt;
        String entry;
        TargetView pview = this.parent.getTargetView();
        JTextPane jps = this.parent.getSourcePane();
        String key = jps.getSelectedText();
        if (key == null) {
            key = "";
        }
        if ((entry = (jpt = pview.getTargetPane()).getSelectedText()) == null) {
            entry = "";
        }
        GlossaryNewEntryEditor dlg = new GlossaryNewEntryEditor(this.parent);
        dlg.setKey(key);
        dlg.setEntry(entry);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    @Override
    public void openResource() {
        this.openTable();
    }

    @Override
    public void saveResource() {
        this.connection.updateDB();
        this.ui.selectCell(0, 0);
        this.ui.repaint();
    }

    @Override
    public void saveAsResource() {
        this.connection.updateDB();
        this.ui.selectCell(0, 0);
        this.ui.repaint();
    }

    @Override
    public void closeResource() {
        try {
            this.connection.closeSession();
        }
        catch (SQLException ex) {
            Logger.getLogger(TermBase.class.getName()).log(Level.SEVERE, null, ex);
        }
        HashMap map = this.parent.getDatabaseView().getTables();
        DatabaseView dv = this.parent.getDatabaseView();
        if (this.loaded) {
            this.parent.getTabView().removeTab(this.name);
            map.remove(this.name);
            JMenu menu = dv.getBasesMenu();
            Component[] comps = menu.getMenuComponents();
            for (int i = 0; i < comps.length; ++i) {
                JCheckBoxMenuItem item;
                String iname;
                Component component = comps[i];
                if (!(component instanceof JCheckBoxMenuItem) || !(iname = (item = (JCheckBoxMenuItem)component).getText()).equalsIgnoreCase(this.name)) continue;
                item.setSelected(false);
            }
        }
        if (map.isEmpty()) {
            dv.defaultTB = null;
            this.connection.closeConnection();
        }
        this.ui = null;
    }

    @Override
    public void printResource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void nextResource() {
        String nq;
        String q = this.connection.getQuery();
        if (q == null && (nq = this.connection.getNextRowsQuery()) != null) {
            this.connection.selectRows(nq);
        }
        this.connection.nextTerms();
        this.ui.selectCell(0, 0);
        this.ui.repaint();
    }

    @Override
    public void previousResource() {
        String nq;
        String q = this.connection.getQuery();
        if (q == null && (nq = this.connection.getPreviousRowsQuery()) != null) {
            this.connection.selectRows(nq);
        }
        this.connection.previousTerms();
        this.ui.selectCell(0, 0);
        this.ui.repaint();
    }

    @Override
    public void plusResource() {
        JTable table = this.ui.getTable();
        Font font = table.getFont();
        float size = font.getSize();
        font = font.deriveFont(size + 1.0f);
        table.setFont(font);
    }

    @Override
    public void minusResource() {
        JTable table = this.ui.getTable();
        Font font = table.getFont();
        float size = font.getSize();
        font = font.deriveFont(size - 1.0f);
        table.setFont(font);
    }

    @Override
    public void help() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getInfoPath() {
        return null;
    }

    @Override
    public String getLocation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteEntry() {
        this.ui.deleteAction();
    }

    public void newEntry() {
        JTextPane sp = this.parent.getSourcePane();
        JTextPane tp = this.parent.getTargetPane();
        String key = sp.getSelectedText();
        String entry = tp.getSelectedText();
        if (key == null) {
            key = "";
        }
        if (entry == null) {
            entry = "";
        }
        if (key.length() > 0 || entry.length() > 0) {
            this.addEntry(key, entry, null, null, null, null, null);
            int cp = sp.getSelectionEnd();
            if (cp != -1) {
                sp.setCaretPosition(cp);
            }
            if ((cp = tp.getSelectionEnd()) != -1) {
                tp.setCaretPosition(cp);
            }
        } else {
            this.ui.newAction();
        }
    }

    public void showTableInfo(MainView mv) {
        TableInfoDialog dlg = new TableInfoDialog(mv, this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = mv.getSize();
        Point loc = mv.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }
}

