/*
 * Decompiled with CFR 0.152.
 */
package translator.hunspell;

import dk.dren.hunspell.Hunspell;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.KeyPreferences;
import translator.MainView;
import translator.Placeables;
import translator.Project;
import translator.Prompter;
import translator.ResourceView;
import translator.Spellcheckable;
import translator.TextResource;
import translator.XMLHelper;
import translator.hunspell.SpellChooser;
import translator.text.ParagraphStyledDocument;

public class HunSpellChecker
extends TextResource
implements Spellcheckable {
    private DefaultStyledDocument targetSegmentDocument;
    private JTextPane targetSegmentPane;
    private ParagraphStyledDocument mistakesDocument;
    private JTextPane mistakesPane;
    boolean spell = false;
    int fromcopy = -1;
    private String mWord = null;
    private int mWordIndex = 0;
    private List alternatives = null;
    private Hunspell.Dictionary dictionaryTarget;
    private Hunspell.Dictionary dictionary2Target;
    private Hunspell.Dictionary dictionarySource;
    private Hunspell.Dictionary dictionary2Source;
    private HashSet languages;
    private String dictDirectory;
    private String currentLanguageTarget;
    private String currentLanguageSource;
    private String dictionary2Name = "user";
    private String dictionary2TargetPath;
    private String dictionary2SourcePath;
    public JMenuItem spellShowItem;
    public JMenuItem spellReplaceItem;
    public Set misspelledWords = new HashSet();
    public Set placeableWords = new HashSet();
    public Set ignoredWords = new HashSet();
    private BreakIterator breakIterator = BreakIterator.getWordInstance();
    private HunspellKeyListener hkeyListener;
    private HunspellDocumentListener hdocListener;
    private HunspellMouseAdapter hmouseAdapter;

    public HunSpellChecker() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    File[] files;
                    HunSpellChecker.this.dictDirectory = AppPreferences.packagePath + "resources" + AppPreferences.fs + "spellchecker" + AppPreferences.fs;
                    File f = new File(HunSpellChecker.this.dictDirectory);
                    boolean e = true;
                    if (!f.exists()) {
                        e = f.mkdir();
                    }
                    if (e && (files = f.listFiles()).length > 0) {
                        HunSpellChecker.this.languages = new HashSet();
                        for (int i = 0; i < files.length; ++i) {
                            String name = files[i].getName();
                            if (!name.endsWith(".dic")) continue;
                            name = name.substring(0, name.lastIndexOf(".dic"));
                            HunSpellChecker.this.languages.add(name);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        r.run();
    }

    @Override
    public void setMainView(MainView parent) {
        this.topui = parent;
        this.setParagraphView(false);
        JMenuBar menuBar = this.topui.getMainMenubar();
        JMenu editMenu = menuBar.getMenu(1);
        JMenuItem spell = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPELLCHECKER"));
        spell.setName("MenuEditSpellChecker");
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SPELLCHECK, (int)spell.getFont().getSize(), (Color)spell.getForeground());
        spell.setIcon((Icon)ficon);
        spell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpellChooser dlg = new SpellChooser(HunSpellChecker.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPELLCHECKER"), HunSpellChecker.this);
                Dimension dlgSize = dlg.getPreferredSize();
                Dimension frmSize = HunSpellChecker.this.topui.getSize();
                Point loc = HunSpellChecker.this.topui.getLocationOnScreen();
                dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                dlg.setVisible(true);
            }
        });
        JMenuItem spellEdit = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT USER'S SPELLING DICTIONARY"));
        spellEdit.setName("MenuEditEditUserSpellingDictionary");
        spellEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HunSpellChecker.this.editUserDictionary();
            }
        });
        this.spellShowItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW ALTERNATIVE SPELLING"));
        this.spellShowItem.setName("MenuEditShowAlternativeSpelling");
        KeyStroke ks = KeyPreferences.getKeyStroke("k67");
        if (ks != null) {
            this.spellShowItem.setAccelerator(ks);
        }
        this.spellShowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HunSpellChecker.this.topui.getTargetView().showToolsPopup(HunSpellChecker.this.targetSegmentPane, -1, -1, true);
            }
        });
        this.spellReplaceItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE WITH ALTERNATIVE SPELLING"));
        this.spellReplaceItem.setName("MenuEditReplaceWithAlternative");
        ks = KeyPreferences.getKeyStroke("k62");
        if (ks != null) {
            this.spellReplaceItem.setAccelerator(ks);
        }
        this.spellReplaceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HunSpellChecker.this.dictionaryTarget != null) {
                            HunSpellChecker.this.correctWord();
                        }
                    }
                });
            }
        });
        int count = editMenu.getMenuComponentCount();
        editMenu.insert(spell, count - 1);
        editMenu.insert(spellEdit, count);
        editMenu.insert(this.spellShowItem, count + 1);
        editMenu.insert(this.spellReplaceItem, count + 2);
        editMenu.insertSeparator(count + 3);
        this.targetSegmentPane = this.topui.getTargetPane();
        this.targetSegmentDocument = (DefaultStyledDocument)this.targetSegmentPane.getDocument();
    }

    public void setTextPane(JTextPane pane, boolean addListeners) {
        if (this.currentLanguageTarget != null) {
            this.targetSegmentPane = pane;
            this.targetSegmentDocument = (DefaultStyledDocument)this.targetSegmentPane.getDocument();
            if (addListeners) {
                HunspellKeyListener hlistener = new HunspellKeyListener();
                this.targetSegmentPane.addKeyListener(hlistener);
                HunspellMouseAdapter hadapter = new HunspellMouseAdapter();
                this.targetSegmentPane.addMouseMotionListener(hadapter);
                HunspellDocumentListener dlistener = new HunspellDocumentListener();
                this.targetSegmentDocument.addDocumentListener(dlistener);
            }
        }
    }

    public boolean hasTargetDictionary() {
        return this.dictionaryTarget != null;
    }

    public boolean hasSourceDictionary() {
        return this.dictionarySource != null;
    }

    public void editUserDictionary() {
        File file;
        if (this.dictionary2TargetPath != null && (file = new File(this.dictionary2TargetPath)).exists()) {
            this.openFile(file, "UTF-8");
        }
    }

    private void addIgnoredWord(String word) {
        String projectDirectory;
        this.ignoredWords.add(word);
        Project project = this.topui.getProjectView().getProject();
        if (project != null && (projectDirectory = project.getProjectDirectory()) != null) {
            String sdir = projectDirectory + AppPreferences.fs + "resources" + AppPreferences.fs + "spellchecker";
            File dir = new File(sdir);
            dir.mkdirs();
            File file = new File(sdir + AppPreferences.fs + "user.dic");
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.saveIgnoredWord(word, file);
        }
    }

    private void saveIgnoredWord(String word, File file) {
        word = word + AppPreferences.ls;
        try {
            Charset charset = Charset.forName("UTF-8");
            CharsetEncoder encoder = charset.newEncoder();
            FileOutputStream foss = new FileOutputStream(file, true);
            FileChannel fc = foss.getChannel();
            CharBuffer cb = CharBuffer.wrap(word);
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            foss.close();
            fc.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIgnoredWords(File file) {
        this.ignoredWords.clear();
        FileInputStream fis = null;
        try {
            String eline;
            fis = new FileInputStream(file);
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            while ((eline = r.readLine()) != null) {
                int hash = eline.indexOf(35);
                if (hash != -1) {
                    if (eline.charAt(0) == '#') continue;
                    eline = eline.substring(0, hash);
                }
                if (eline.length() <= 0) continue;
                this.ignoredWords.add(eline);
            }
        }
        catch (IOException e) {
            Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, e);
            System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + file.getPath());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void addPlaceableWord(String word) {
        String[] s = word.split("[ \u00a0]");
        for (int i = 0; i < s.length; ++i) {
            String string = s[i];
            if (string.length() <= 0) continue;
            this.placeableWords.add(string);
        }
    }

    public void clearPlaceableWords() {
        this.placeableWords.clear();
    }

    public void addWord(String word) {
        String r;
        File file;
        if (this.dictionary2TargetPath != null && (file = new File(this.dictionary2TargetPath)).exists() && (r = this.loadTextFile(file, "UTF-8")) != null) {
            int n = 1;
            int nl = r.indexOf(10);
            if (nl != -1) {
                String num = r.substring(0, nl).trim();
                r = r.substring(nl + 1).trim();
                try {
                    n = Integer.parseInt(num);
                    ++n;
                }
                catch (NumberFormatException ex) {
                    n = 1;
                }
            }
            StringBuilder sb = new StringBuilder(r.length() + 32);
            sb.append(n);
            sb.append('\n');
            sb.append(r);
            sb.append('\n');
            sb.append(word);
            this.saveText(file, sb.toString(), "UTF-8");
            this.reload();
        }
    }

    private void correctWord() {
        String s = this.targetSegmentPane.getSelectedText();
        if (s == null) {
            s = this.topui.getResourceView().getWordAtCaretPosition(this.targetSegmentPane, false);
        }
        if (s != null && s.length() > 0 && this.misspelledWords.contains(s)) {
            this.mWord = s;
        }
        if (this.mWord != null) {
            if (this.alternatives == null) {
                this.alternatives = this.wordAlternatives(this.mWord);
            }
            if (this.alternatives != null && this.alternatives.size() > 0) {
                if (this.mWordIndex >= this.alternatives.size()) {
                    this.mWordIndex = 0;
                }
                try {
                    int len = this.targetSegmentDocument.getLength();
                    int cpos = this.targetSegmentPane.getCaretPosition();
                    cpos = cpos + this.mWord.length() < len ? (cpos += this.mWord.length()) : len;
                    String text = this.targetSegmentDocument.getText(0, cpos);
                    int i = text.lastIndexOf(this.mWord);
                    if (i != -1) {
                        String rep = (String)this.alternatives.get(this.mWordIndex);
                        if (rep != null) {
                            this.targetSegmentDocument.replace(i, this.mWord.length(), rep, null);
                            ++this.mWordIndex;
                            this.mWord = rep;
                        } else {
                            this.mWordIndex = 0;
                        }
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean addPopUpMenu(final JPopupMenu popUp, final String word, final int ws) {
        if (this.dictionaryTarget == null) {
            return false;
        }
        if (this.wordValid(word) || this.placeableWords.contains(word) || this.ignoreSpellCheck(word)) {
            return false;
        }
        int accel = 1;
        Font f = this.targetSegmentPane.getFont();
        float fs = 14.0f;
        List alt = this.wordAlternatives(word);
        if (alt != null && alt.size() > 0) {
            for (int i = 0; i < alt.size(); ++i) {
                char sh;
                Object object = alt.get(i);
                JMenuItem item = new JMenuItem(new AbstractAction(this, object.toString()){
                    final /* synthetic */ HunSpellChecker this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        String com = a.getActionCommand();
                        try {
                            this.this$0.targetSegmentDocument.replace(ws, word.length(), com, null);
                            popUp.setVisible(false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                float fsize = item.getFont().getSize2D();
                if (fs < fsize) {
                    fs = fsize;
                }
                item.setFont(f.deriveFont(fs));
                if (accel < 10) {
                    sh = Character.forDigit(accel, 10);
                    item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                } else if (accel == 10) {
                    sh = Character.forDigit(0, 10);
                    item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                }
                ++accel;
                popUp.add(item);
            }
        }
        String menuText = word.length() > 20 ? word.substring(0, 20) + "..." : word;
        JMenuItem item = new JMenuItem(new AbstractAction(this, menuText){
            final /* synthetic */ HunSpellChecker this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                String s = word;
                if (s != null && (s = s.trim()).length() > 0) {
                    this.this$0.addWord(s);
                    this.this$0.checkSpellCurrentTarget(s);
                }
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke('s'));
        item.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD TO SPELLCHECKER"));
        float fsize = item.getFont().getSize2D();
        if (fs < fsize) {
            fs = fsize;
        }
        item.setFont(f.deriveFont(fs));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SPELLCHECK, (int)item.getFont().getSize(), (Color)item.getForeground());
        item.setIcon((Icon)ficon);
        if (accel > 1) {
            popUp.addSeparator();
        }
        popUp.add(item);
        JMenuItem ignoreItem = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IGNORE")){
            final /* synthetic */ HunSpellChecker this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                String s = word;
                if (s != null && (s = s.trim()).length() > 0) {
                    this.this$0.addIgnoredWord(s);
                    this.this$0.checkSpellCurrentTarget(s);
                }
            }
        });
        ignoreItem.setAccelerator(KeyStroke.getKeyStroke('i'));
        ignoreItem.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IGNORE THIS SPELLING MISTAKE FOR THE CURRENT PROJECT"));
        fsize = ignoreItem.getFont().getSize2D();
        if (fs < fsize) {
            fs = fsize;
        }
        ignoreItem.setFont(f.deriveFont(fs));
        popUp.add(ignoreItem);
        return true;
    }

    @Override
    public boolean globalCheckSpell(String text) {
        int we;
        String string;
        Matcher m;
        String[] s;
        String place;
        boolean mistake = false;
        int ws = 0;
        int tlength = text.length();
        HashSet<String> placeablesSet = new HashSet<String>();
        Set set = Placeables.getPlaceablesSet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            place = it.next().toString();
            if (place.charAt(0) != '|') {
                int start = text.indexOf(place);
                if (start == -1) continue;
                s = place.split("[ \u00a0]");
                for (int i = 0; i < s.length; ++i) {
                    String string2 = s[i];
                    if (string2.length() <= 0) continue;
                    placeablesSet.add(string2);
                }
                continue;
            }
            place = place.substring(1);
            Pattern ppattern = Pattern.compile(place);
            m = ppattern.matcher(text);
            while (m.find()) {
                place = m.group();
                String[] s2 = place.split("[ \u00a0]");
                for (int i = 0; i < s2.length; ++i) {
                    string = s2[i];
                    if (string.length() <= 0) continue;
                    placeablesSet.add(string);
                }
            }
        }
        set = Placeables.getPlaceablesSetHidden();
        it = set.iterator();
        while (it.hasNext()) {
            place = it.next().toString();
            if (place.charAt(0) != '|') {
                int start = text.indexOf(place);
                if (start == -1) continue;
                s = place.split("[ \u00a0]");
                for (int i = 0; i < s.length; ++i) {
                    String string3 = s[i];
                    if (string3.length() <= 0) continue;
                    placeablesSet.add(string3);
                }
                continue;
            }
            place = place.substring(1);
            Pattern ppattern = Pattern.compile(place);
            m = ppattern.matcher(text);
            while (m.find()) {
                place = m.group();
                String[] s3 = place.split("[ \u00a0]");
                for (int i = 0; i < s3.length; ++i) {
                    string = s3[i];
                    if (string.length() <= 0) continue;
                    placeablesSet.add(string);
                }
            }
        }
        this.breakIterator.setText(text);
        while (ws < tlength && (we = this.breakIterator.following(ws)) != -1) {
            String word;
            int length;
            char next;
            boolean replace = false;
            if (we + 2 < tlength && text.charAt(we) == '\u2019' && Character.isLetter(next = text.charAt(we + 1))) {
                if ((we = this.breakIterator.following(we + 1)) == -1) break;
                replace = true;
            }
            if ((length = (word = text.substring(ws, we)).trim().length()) > 1) {
                if (replace) {
                    word = word.replace('\u2019', '\'');
                }
                if (!(this.wordValid(word) || placeablesSet.contains(word) || this.ignoreSpellCheck(word))) {
                    mistake = true;
                    break;
                }
            }
            ws = we;
        }
        return mistake;
    }

    public List getMispelledWords(String text) {
        int we;
        String string;
        Matcher m;
        String[] s;
        String place;
        ArrayList<String> list = new ArrayList<String>(4);
        int ws = 0;
        int tlength = text.length();
        HashSet<String> placeablesSet = new HashSet<String>();
        Set set = Placeables.getPlaceablesSet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            place = it.next().toString();
            if (place.charAt(0) != '|') {
                int start = text.indexOf(place);
                if (start == -1) continue;
                s = place.split("[ \u00a0]");
                for (int i = 0; i < s.length; ++i) {
                    String string2 = s[i];
                    if (string2.length() <= 0) continue;
                    placeablesSet.add(string2);
                }
                continue;
            }
            place = place.substring(1);
            Pattern ppattern = Pattern.compile(place);
            m = ppattern.matcher(text);
            while (m.find()) {
                place = m.group();
                String[] s2 = place.split("[ \u00a0]");
                for (int i = 0; i < s2.length; ++i) {
                    string = s2[i];
                    if (string.length() <= 0) continue;
                    placeablesSet.add(string);
                }
            }
        }
        set = Placeables.getPlaceablesSetHidden();
        it = set.iterator();
        while (it.hasNext()) {
            place = it.next().toString();
            if (place.charAt(0) != '|') {
                int start = text.indexOf(place);
                if (start == -1) continue;
                s = place.split("[ \u00a0]");
                for (int i = 0; i < s.length; ++i) {
                    String string3 = s[i];
                    if (string3.length() <= 0) continue;
                    placeablesSet.add(string3);
                }
                continue;
            }
            place = place.substring(1);
            Pattern ppattern = Pattern.compile(place);
            m = ppattern.matcher(text);
            while (m.find()) {
                place = m.group();
                String[] s3 = place.split("[ \u00a0]");
                for (int i = 0; i < s3.length; ++i) {
                    string = s3[i];
                    if (string.length() <= 0) continue;
                    placeablesSet.add(string);
                }
            }
        }
        this.breakIterator.setText(text);
        while (ws < tlength && (we = this.breakIterator.following(ws)) != -1) {
            String word;
            int length;
            char next;
            boolean replace = false;
            if (we + 2 < tlength && text.charAt(we) == '\u2019' && Character.isLetter(next = text.charAt(we + 1))) {
                if ((we = this.breakIterator.following(we + 1)) == -1) break;
                replace = true;
            }
            if ((length = (word = text.substring(ws, we)).trim().length()) > 1) {
                if (replace) {
                    word = word.replace('\u2019', '\'');
                }
                if (!(this.wordValid(word) || placeablesSet.contains(word) || this.ignoreSpellCheck(word))) {
                    list.add(word);
                }
            }
            ws = we;
        }
        return list;
    }

    public List getStems(String word) {
        List stems2;
        List stems = this.dictionarySource.stem(word);
        if (this.dictionary2Source != null && (stems2 = this.dictionary2Source.stem(word)) != null && !stems2.isEmpty()) {
            stems.addAll(stems2);
        }
        return stems;
    }

    private void checkSpellCurrentTarget(String s) {
        int tlength = this.targetSegmentDocument.getLength();
        if (tlength > 0) {
            String text = null;
            try {
                text = this.targetSegmentDocument.getText(0, tlength);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (text != null) {
                int k = 0;
                int i = text.indexOf(s, k);
                while (i != -1) {
                    k = i + s.length();
                    this.checkSpell(i, k);
                    i = text.indexOf(s, k);
                }
            }
        }
    }

    private void checkSpell(int from, int to) {
        try {
            int we;
            int ws;
            int tlength = this.targetSegmentDocument.getLength();
            if (from > tlength) {
                return;
            }
            String text = this.targetSegmentDocument.getText(0, tlength);
            Style error = this.targetSegmentDocument.getStyle("Spellcheck");
            Style normal = this.targetSegmentDocument.getStyle("Normal");
            this.breakIterator.setText(text);
            if (from > 0) {
                char c;
                ws = this.breakIterator.preceding(from);
                if (ws > 1 && (c = text.charAt(ws - 1)) == '\u2019') {
                    ws = this.breakIterator.preceding(ws - 1);
                }
            } else {
                ws = 0;
            }
            while (ws <= to && ws < tlength && (we = this.breakIterator.following(ws)) != -1) {
                String word;
                int length;
                char next;
                boolean replace = false;
                if (we + 2 < tlength && text.charAt(we) == '\u2019' && Character.isLetter(next = text.charAt(we + 1))) {
                    if ((we = this.breakIterator.following(we + 1)) == -1) break;
                    replace = true;
                }
                if ((length = (word = this.targetSegmentDocument.getText(ws, we - ws)).trim().length()) > 1) {
                    if (replace) {
                        word = word.replace('\u2019', '\'');
                    }
                    if (this.wordValid(word) || this.placeableWords.contains(word) || this.ignoreSpellCheck(word)) {
                        this.targetSegmentDocument.setCharacterAttributes(ws, length, normal, true);
                    } else {
                        this.targetSegmentDocument.setCharacterAttributes(ws, length, error, true);
                        this.mWord = word;
                        this.misspelledWords.add(word);
                    }
                } else {
                    int i;
                    char c = word.charAt(0);
                    if (c == '>') {
                        ws = we;
                        continue;
                    }
                    if (c == '<' && (i = text.indexOf(62, ws)) != -1) break;
                    this.targetSegmentDocument.setCharacterAttributes(ws, word.length(), normal, true);
                }
                ws = we;
            }
            this.targetSegmentPane.setCharacterAttributes(normal, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List wordAlternatives(String word) {
        List suggestions2;
        List suggestions = this.dictionaryTarget.suggest(word);
        if (this.dictionary2Target != null && (suggestions2 = this.dictionary2Target.suggest(word)) != null && !suggestions2.isEmpty()) {
            if (suggestions != null && !suggestions.isEmpty()) {
                suggestions.addAll(suggestions2);
            } else {
                return suggestions2;
            }
        }
        return suggestions;
    }

    private boolean wordValid(String word) {
        if (this.dictionaryTarget != null && this.dictionaryTarget.misspelled(word)) {
            if (this.dictionary2Target != null) {
                return !this.dictionary2Target.misspelled(word);
            }
            return false;
        }
        return true;
    }

    private boolean ignoreSpellCheck(String word) {
        if (this.ignoredWords.contains(word)) {
            return true;
        }
        char[] arr = word.toCharArray();
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            char c = arr[i];
            if (Character.isDigit(c)) {
                return true;
            }
            if (!AppPreferences.qaSpellCheckIgnoreAcronyms || len > AppPreferences.qaSpellCheckAcronymsLength || i != 1 || !Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public void clearMisspelledWords() {
        if (!this.misspelledWords.isEmpty()) {
            Prompter ac = this.topui.getSourceView().getPrompter();
            Iterator iterator = this.misspelledWords.iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                if (ac != null) {
                    ac.removeMispelledWord(next);
                }
                iterator.remove();
            }
        }
    }

    public Set getLanguages() {
        return this.languages;
    }

    public String getCurrentLanguage() {
        return this.currentLanguageTarget;
    }

    public void setBreakIterator(Locale locale) {
        this.breakIterator = BreakIterator.getWordInstance(locale);
    }

    public void setTargetLanguageDictionary(String lang) {
        if (!(this.dictDirectory == null || this.currentLanguageTarget != null && this.currentLanguageTarget.equals(lang))) {
            try {
                if (this.languages != null && this.languages.contains(lang)) {
                    if (this.hkeyListener == null) {
                        this.hkeyListener = new HunspellKeyListener();
                        this.targetSegmentPane.addKeyListener(this.hkeyListener);
                    }
                    if (this.hmouseAdapter == null) {
                        this.hmouseAdapter = new HunspellMouseAdapter();
                        this.targetSegmentPane.addMouseMotionListener(this.hmouseAdapter);
                    }
                    if (this.hdocListener == null) {
                        this.hdocListener = new HunspellDocumentListener();
                        this.targetSegmentDocument.addDocumentListener(this.hdocListener);
                    }
                    Hunspell hunspell = Hunspell.getInstance();
                    this.dictionaryTarget = hunspell.getDictionary(this.dictDirectory + lang);
                    this.currentLanguageTarget = lang;
                    String userDict = this.dictionary2Name + "-" + lang;
                    if (this.languages.contains(userDict)) {
                        String path = this.dictDirectory + userDict;
                        this.dictionary2Target = hunspell.getDictionary(path);
                        this.dictionary2TargetPath = path + ".dic";
                    } else if (this.languages.contains(this.dictionary2Name)) {
                        String path = this.dictDirectory + this.dictionary2Name;
                        this.dictionary2Target = hunspell.getDictionary(path);
                        this.dictionary2TargetPath = path + ".dic";
                    } else {
                        this.dictionary2Target = null;
                    }
                } else {
                    this.currentLanguageTarget = null;
                    this.dictionaryTarget = null;
                    this.dictionary2Target = null;
                    if (this.hkeyListener != null) {
                        this.targetSegmentPane.removeKeyListener(this.hkeyListener);
                        this.hkeyListener = null;
                    }
                    if (this.hmouseAdapter != null) {
                        this.targetSegmentPane.removeMouseMotionListener(this.hmouseAdapter);
                        this.hmouseAdapter = null;
                    }
                    if (this.hdocListener != null) {
                        this.targetSegmentDocument.removeDocumentListener(this.hdocListener);
                        this.hdocListener = null;
                    }
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setSourceLanguageDictionary(String lang) {
        if (!(this.dictDirectory == null || this.currentLanguageSource != null && this.currentLanguageSource.equals(lang))) {
            try {
                if (this.languages != null && this.languages.contains(lang)) {
                    Hunspell hunspell = Hunspell.getInstance();
                    this.dictionarySource = hunspell.getDictionary(this.dictDirectory + lang);
                    this.currentLanguageSource = lang;
                    String userDict = this.dictionary2Name + "-" + lang;
                    if (this.languages.contains(userDict)) {
                        String path = this.dictDirectory + userDict;
                        this.dictionary2Source = hunspell.getDictionary(path);
                        this.dictionary2SourcePath = path + ".dic";
                    } else if (this.languages.contains(this.dictionary2Name)) {
                        String path = this.dictDirectory + this.dictionary2Name;
                        this.dictionary2Source = hunspell.getDictionary(path);
                        this.dictionary2SourcePath = path + ".dic";
                    } else {
                        this.dictionary2Source = null;
                    }
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void reload() {
        String userDict = this.dictionary2Name + "-" + this.currentLanguageTarget;
        Hunspell hunspell = Hunspell.getInstance();
        try {
            String path = null;
            if (this.languages.contains(userDict)) {
                path = this.dictDirectory + userDict;
            } else if (this.languages.contains(this.dictionary2Name)) {
                path = this.dictDirectory + this.dictionary2Name;
            }
            if (path != null) {
                hunspell.destroyDictionary(path);
                this.dictionary2Target = hunspell.getDictionary(path);
                this.dictionary2TargetPath = path + ".dic";
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void showMistakes(Set scanSet) {
        this.setMistakesPane();
        try {
            String toolTip = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK TO ADD TO THE SPELL CHECK DICTIONARY. HOLD CTRL KEY TO SEARCH IN THE PROJECT.");
            boolean isMacLF = false;
            if (AppPreferences.laf.equals("Mac OS")) {
                isMacLF = true;
            }
            for (String abb : scanSet) {
                JButton buttonAdd = new JButton(abb);
                if (!isMacLF) {
                    buttonAdd.setOpaque(false);
                } else {
                    buttonAdd.setOpaque(true);
                    buttonAdd.setBorder(BorderFactory.createRaisedSoftBevelBorder());
                }
                buttonAdd.setHorizontalAlignment(2);
                buttonAdd.setActionCommand(abb);
                buttonAdd.setToolTipText(toolTip);
                buttonAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int mod = e.getModifiers();
                        JButton button = (JButton)e.getSource();
                        String key = e.getActionCommand();
                        if ((key = key.trim()).length() > 0) {
                            if ((mod & 2) == 2) {
                                ResourceView rv = HunSpellChecker.this.topui.getResourceView();
                                key = XMLHelper.parseTags(key);
                                rv.getLookUpBox().setSelectedItem(key);
                                boolean ww = AppPreferences.searchWholewords;
                                if (!ww) {
                                    AppPreferences.searchWholewords = true;
                                }
                                int m = rv.getFindMode();
                                rv.setFindMode(5);
                                rv.lookUpResource(key, null, null);
                                rv.setFindMode(m);
                                AppPreferences.searchWholewords = ww;
                            } else {
                                button.setEnabled(false);
                                HunSpellChecker.this.addWord(key);
                                HunSpellChecker.this.checkSpellCurrentTarget(key);
                            }
                        }
                    }
                });
                this.mistakesPane.insertComponent(buttonAdd);
                this.mistakesDocument.insertString(this.mistakesDocument.getLength(), " ", null);
                this.mistakesPane.setCaretPosition(this.mistakesDocument.getLength());
            }
            this.mistakesPane.validate();
            if (this.mistakesDocument.getLength() > 0) {
                this.mistakesPane.setCaretPosition(0);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    private void setMistakesPane() {
        if (this.mistakesPane == null || !this.mistakesPane.isVisible()) {
            ResourceView rv = this.topui.getResourceView();
            TextResource res = rv.newTextResource(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNKNOWN SPELLING"));
            this.mistakesPane = res.getTextPane();
            this.mistakesPane.setEditable(false);
            this.mistakesDocument = (ParagraphStyledDocument)this.mistakesPane.getDocument();
            this.mistakesDocument.putProperty("path", "");
        } else {
            try {
                this.mistakesDocument.remove(0, this.mistakesDocument.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(HunSpellChecker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void saveResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HunSpellChecker.this.saveFile();
                HunSpellChecker.this.reload();
            }
        });
    }

    private class HunspellKeyListener
    implements KeyListener {
        private HunspellKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (HunSpellChecker.this.dictionaryTarget == null) {
                return;
            }
            char c = e.getKeyChar();
            int type = Character.getType(c);
            if (Character.isWhitespace(c) || type == 24) {
                HunSpellChecker.this.spell = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HunSpellChecker.this.checkSpell(HunSpellChecker.this.fromcopy, HunSpellChecker.this.fromcopy + 1);
                    }
                });
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (HunSpellChecker.this.dictionaryTarget == null) {
                return;
            }
            if (HunSpellChecker.this.spell && e.isActionKey()) {
                String s;
                Object o = HunSpellChecker.this.targetSegmentPane.getInputMap(0).get(KeyStroke.getKeyStroke(e.getKeyCode(), 0));
                if (o != null && ((s = o.toString()).equals("UP") || s.equals("DOWN"))) {
                    return;
                }
                HunSpellChecker.this.spell = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HunSpellChecker.this.checkSpell(HunSpellChecker.this.fromcopy, HunSpellChecker.this.fromcopy + 1);
                    }
                });
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!e.isControlDown() && HunSpellChecker.this.mWordIndex > 0) {
                HunSpellChecker.this.mWordIndex = 0;
                HunSpellChecker.this.alternatives = null;
            }
        }
    }

    private class HunspellMouseAdapter
    extends MouseMotionAdapter {
        private HunspellMouseAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            if (HunSpellChecker.this.dictionaryTarget == null) {
                return;
            }
            if (HunSpellChecker.this.spell) {
                HunSpellChecker.this.spell = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HunSpellChecker.this.checkSpell(HunSpellChecker.this.fromcopy, HunSpellChecker.this.fromcopy + 1);
                    }
                });
            }
        }
    }

    private class HunspellDocumentListener
    implements DocumentListener {
        private HunspellDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (HunSpellChecker.this.dictionaryTarget == null) {
                return;
            }
            final int len = e.getLength();
            final int off = e.getOffset();
            if (len > 1) {
                try {
                    Document doc = e.getDocument();
                    String text = doc.getText(0, doc.getLength());
                    String s = text.substring(off, off + len);
                    if (s.charAt(off) == '<' && s.charAt(off + len) == '>') {
                        HunSpellChecker.this.spell = false;
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ HunspellDocumentListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (this.this$1.HunSpellChecker.this.targetSegmentPane.getClientProperty("content") == null) {
                            this.this$1.HunSpellChecker.this.checkSpell(off, off + len);
                        }
                    }
                });
            } else {
                HunSpellChecker.this.spell = true;
            }
            HunSpellChecker.this.fromcopy = off;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            final int off = e.getOffset();
            final int len = e.getLength();
            HunSpellChecker.this.fromcopy = off;
            HunSpellChecker.this.spell = true;
            if (len > 1 && HunSpellChecker.this.targetSegmentDocument.getLength() > 0) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ HunspellDocumentListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (this.this$1.HunSpellChecker.this.targetSegmentPane.getClientProperty("content") == null) {
                            this.this$1.HunSpellChecker.this.checkSpell(off, off + len);
                        }
                    }
                });
            }
        }
    }
}

