/*
 * Decompiled with CFR 0.152.
 */
package translator.hunspell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.MainView;
import translator.ResourceView;

final class SpellingDictionaryInstaller
extends JDialog
implements ActionListener {
    private JComboBox enbox;
    private JButton jb1;
    private JButton jb2;
    private MainView parent;
    private String langCode;

    SpellingDictionaryInstaller(MainView parent, String title) {
        super(parent, title, true);
        this.parent = parent;
        this.enableEvents(64L);
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        String[] langs = LanguageCodes.getNames();
        this.enbox = new JComboBox<String>(langs);
        int count = this.enbox.getItemCount();
        if (count == 0) {
            this.enbox.addItem("No spell-check dictionaries");
        }
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout());
        this.setResizable(false);
        panel3.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE LANGUAGE")));
        panel3.add(this.jb1);
        panel3.add(this.enbox);
        panel3.add(this.jb2);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridLayout(5, 1));
        panel4.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        JLabel label = new JLabel("A collection of spelling dictionaries is available at the following links:");
        JLabel label2 = new JLabel("After downloading select your language from the list above and press OK to install.");
        String html1 = "<html><body><a href=\"https://ftp5.gwdg.de/pub/openoffice/contrib/dictionaries/\">As zipped files at https://ftp5.gwdg.de/pub/openoffice/contrib/dictionaries/</a></body></html>";
        JButton button = new JButton(html1);
        button.setActionCommand("https://ftp5.gwdg.de/pub/openoffice/contrib/dictionaries/");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String action = e.getActionCommand();
                try {
                    URI uri = new URI(action);
                    SpellingDictionaryInstaller.this.parent.getResourceView();
                    ResourceView.browse(uri);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(SpellingDictionaryInstaller.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        String html2 = "<html><body><a href=\"https://extensions.libreoffice.org/\">As LibreOffice dictionaries (*.oxt)</a></body></html>";
        JButton button2 = new JButton(html2);
        button2.setActionCommand("https://extensions.libreoffice.org/");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String action = e.getActionCommand();
                try {
                    URI uri = new URI(action);
                    SpellingDictionaryInstaller.this.parent.getResourceView();
                    ResourceView.browse(uri);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(SpellingDictionaryInstaller.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        String html3 = "<html><body><a href=\"https://www.freeoffice.com/en/download/dictionaries\">As FreeOffice dictionaries (*.sox)</a></body></html>";
        JButton button3 = new JButton(html3);
        button3.setActionCommand("https://www.freeoffice.com/en/download/dictionaries");
        button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String action = e.getActionCommand();
                try {
                    URI uri = new URI(action);
                    SpellingDictionaryInstaller.this.parent.getResourceView();
                    ResourceView.browse(uri);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(SpellingDictionaryInstaller.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        panel4.add(label);
        panel4.add(button);
        panel4.add(button2);
        panel4.add(button3);
        panel4.add(label2);
        JPanel con = new JPanel();
        con.setBorder(new EmptyBorder(new Insets(10, 5, 5, 5)));
        this.setContentPane(con);
        con.setLayout(new BorderLayout());
        con.add((Component)panel3, "Center");
        con.add((Component)panel4, "South");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String code;
        String s;
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1 && (s = (String)this.enbox.getSelectedItem()) != null && (code = LanguageCodes.getCode(s)).indexOf(45) != -1) {
            this.langCode = code.replace('-', '_');
            this.installDictionary();
        }
    }

    private void installDictionary() {
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALL DICTIONARY"));
                    final File file = fileChooser.showOpenDialog(null);
                    if (file != null) {
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                String name = file.getName().toLowerCase();
                                if (name.endsWith(".zip") || name.endsWith(".oxt") || name.endsWith(".xpi") || name.endsWith(".sox")) {
                                    this.this$1.SpellingDictionaryInstaller.this.installZippedDictionary(file);
                                } else if (name.endsWith(".dic") || name.endsWith(".aff")) {
                                    String fpath = file.getPath();
                                    int dot = fpath.lastIndexOf(46);
                                    if (name.endsWith(".dic")) {
                                        fpath = fpath.substring(0, dot) + ".aff";
                                    } else if (name.endsWith(".aff")) {
                                        fpath = fpath.substring(0, dot) + ".dic";
                                    }
                                    File file2 = new File(fpath);
                                    if (file2.exists()) {
                                        this.this$1.SpellingDictionaryInstaller.this.installFromFile(file, file2);
                                    }
                                }
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALL DICTIONARY"));
            if (0 == jFileChooser.showOpenDialog(this.parent)) {
                File file = jFileChooser.getSelectedFile();
                String name = file.getName().toLowerCase();
                if (name.endsWith(".zip") || name.endsWith(".oxt") || name.endsWith(".xpi")) {
                    this.installZippedDictionary(file);
                } else if (name.endsWith(".dic") || name.endsWith(".aff")) {
                    String fpath = file.getPath();
                    int dot = fpath.lastIndexOf(46);
                    if (name.endsWith(".dic")) {
                        fpath = fpath.substring(0, dot) + ".aff";
                    } else if (name.endsWith(".aff")) {
                        fpath = fpath.substring(0, dot) + ".dic";
                    }
                    File file2 = new File(fpath);
                    if (file2.exists()) {
                        this.installFromFile(file, file2);
                    }
                }
            }
        }
    }

    private void installZippedDictionary(File file) {
        String dirPath = AppPreferences.packagePath + "resources" + AppPreferences.fs + "spellchecker" + AppPreferences.fs;
        boolean extract = true;
        boolean found = false;
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                int fs = entryName.indexOf(AppPreferences.fs);
                if (fs == -1 && AppPreferences.fs.equals("/")) {
                    entryName = entryName.replace('\\', '/');
                }
                if ((fs = entryName.indexOf(47)) != -1) {
                    entryName = entryName.substring(fs + 1);
                }
                int hyph = entryName.indexOf("hyph");
                if ((!entryName.endsWith(".dic") || hyph != -1) && !entryName.endsWith(".aff")) continue;
                found = true;
                if (entryName.endsWith(".dic")) {
                    entryName = this.langCode + ".dic";
                } else if (entryName.endsWith(".aff")) {
                    entryName = this.langCode + ".aff";
                }
                if (!extract) continue;
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(dirPath + entryName);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            zipFile.close();
            if (found) {
                File dst = new File(dirPath + "user-" + this.langCode + ".dic");
                File src = new File(dirPath + "user.dic");
                File dst2 = new File(dirPath + "user-" + this.langCode + ".aff");
                File src2 = new File(dirPath + "user.aff");
                if (src.exists() && !dst.exists()) {
                    this.copyFile(src, dst);
                    if (src2.exists() && !dst2.exists()) {
                        this.copyFile(src2, dst2);
                    }
                }
                this.cancel();
                JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALLATION COMPLETED. PLEASE RESTART CAFETRAN."));
            }
        }
        catch (IOException ioe) {
            String m = ioe.getMessage();
            if (m != null) {
                JOptionPane.showMessageDialog(this.parent, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
            }
            ioe.printStackTrace();
        }
    }

    private void installFromFile(File file1, File file2) {
        String dirPath = AppPreferences.packagePath + "resources" + AppPreferences.fs + "spellchecker" + AppPreferences.fs;
        boolean found = false;
        File[] files = new File[]{file1, file2};
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String entryName = file.getName();
            found = true;
            try {
                if (entryName.endsWith(".dic")) {
                    entryName = this.langCode + ".dic";
                } else if (entryName.endsWith(".aff")) {
                    entryName = this.langCode + ".aff";
                }
                String dst = dirPath + entryName;
                FileChannel srcChannel = new FileInputStream(file.getPath()).getChannel();
                FileChannel dstChannel = new FileOutputStream(dst).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                continue;
            }
            catch (IOException e) {
                String m = e.getMessage();
                if (m != null) {
                    JOptionPane.showMessageDialog(this.parent, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
                }
                found = false;
            }
        }
        if (found) {
            File dst = new File(dirPath + "user-" + this.langCode + ".dic");
            File src = new File(dirPath + "user.dic");
            File dst2 = new File(dirPath + "user-" + this.langCode + ".aff");
            File src2 = new File(dirPath + "user.aff");
            if (src.exists() && !dst.exists()) {
                this.copyFile(src, dst);
                if (src2.exists() && !dst2.exists()) {
                    this.copyFile(src2, dst2);
                }
            }
            this.cancel();
            JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALLATION COMPLETED. PLEASE RESTART CAFETRAN."));
        }
    }

    private void downloadAndInstall(String ftpUrl, String name) {
        String wloc;
        File f;
        long startTime = System.currentTimeMillis();
        String savePath = AppPreferences.operatingSystem == 0 ? ((f = new File(wloc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists() ? wloc : System.getProperty("user.home")) : System.getProperty("user.home");
        savePath = savePath + AppPreferences.fs + name;
        System.out.println("Connecting to FTP server");
        try {
            URL url = new URL(ftpUrl);
            URLConnection conn = url.openConnection();
            InputStream inputStream = conn.getInputStream();
            long filesize = conn.getContentLength();
            System.out.println("Size of the file to download in kb is:-" + filesize / 1024L);
            FileOutputStream outputStream = new FileOutputStream(new File(savePath));
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            long endTime = System.currentTimeMillis();
            System.out.println("File downloaded");
            System.out.println("Download time in sec. is:-" + (endTime - startTime) / 1000L);
            outputStream.close();
            inputStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void installFromDirectory(File file) {
        String dirPath = AppPreferences.packagePath + "resources" + AppPreferences.fs + "spellchecker" + AppPreferences.fs;
        boolean found = false;
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String entryName;
            File file1 = files[i];
            if (file1.isDirectory() || !(entryName = file1.getName()).endsWith(".dic") && !entryName.endsWith(".aff")) continue;
            found = true;
            try {
                if (entryName.endsWith(".dic")) {
                    entryName = this.langCode + ".dic";
                } else if (entryName.endsWith(".aff")) {
                    entryName = this.langCode + ".aff";
                }
                String dst = dirPath + entryName;
                FileChannel srcChannel = new FileInputStream(file1.getPath()).getChannel();
                FileChannel dstChannel = new FileOutputStream(dst).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                continue;
            }
            catch (IOException e) {
                String m = e.getMessage();
                if (m != null) {
                    JOptionPane.showMessageDialog(this.parent, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
                }
                found = false;
            }
        }
        if (found) {
            JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALLATION COMPLETED. PLEASE RESTART CAFETRAN."));
        }
    }

    private void copyFile(File src, File dst) {
        block2: {
            try {
                FileChannel srcChannel = new FileInputStream(src.getPath()).getChannel();
                FileChannel dstChannel = new FileOutputStream(dst).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
            }
            catch (IOException e) {
                String m = e.getMessage();
                if (m == null) break block2;
                JOptionPane.showMessageDialog(this.parent, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
            }
        }
    }
}

