/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.MT;
import translator.MainView;
import translator.Options;
import translator.ui.UITools;

final class DeepLOptions
extends JDialog
implements ActionListener {
    private JComboBox mtSLangs;
    private JComboBox mtTLangs;
    private JCheckBox autoMT = null;
    private JTextField keyField = null;
    private JComboBox domainBox = null;
    private JComboBox toneBox = null;
    private JButton jb1;
    private JButton jb2;
    private MT mt;
    private MainView topui;

    DeepLOptions(Options parent, MT mt, String title) {
        super(parent, title, true);
        this.mt = mt;
        this.topui = parent.getMainView();
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.enableEvents(64L);
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.mtSLangs = new JComboBox<String>(this.mt.getLanguages());
        this.mtTLangs = new JComboBox<String>(this.mt.getLanguages());
        if (AppPreferences.mtSource6 != null && AppPreferences.mtSource6.length() > 0) {
            this.mtSLangs.setSelectedItem(AppPreferences.mtSource6);
        }
        if (AppPreferences.mtTarget6 != null && AppPreferences.mtTarget6.length() > 0) {
            this.mtTLangs.setSelectedItem(AppPreferences.mtTarget6);
        }
        this.autoMT = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC"));
        this.autoMT.setSelected(AppPreferences.autoMT6);
        JLabel domainlabeL = new JLabel("API domain:");
        String[] s = new String[]{"api.deepl.com"};
        this.domainBox = new JComboBox<String>(s);
        if (AppPreferences.deeplAPIDomain != null && AppPreferences.deeplAPIDomain.length() > 0) {
            this.domainBox.setSelectedItem(AppPreferences.deeplAPIDomain);
        }
        JLabel keylabeL = new JLabel("API key:");
        this.keyField = new JTextField();
        this.keyField.setPreferredSize(new Dimension(600, this.keyField.getPreferredSize().height));
        this.keyField.setText(AppPreferences.deeplAPIKey);
        this.keyField.setMargin(new Insets(0, 2, 0, 0));
        this.keyField.setCaretPosition(0);
        JLabel tonelabeL = new JLabel("Formality:");
        String[] t = new String[]{"Default", "Prefer formal language", "Prefer informal language"};
        this.toneBox = new JComboBox<String>(t);
        if (AppPreferences.deeplAPIFormality < t.length) {
            this.toneBox.setSelectedIndex(AppPreferences.deeplAPIFormality);
        }
        JPanel panel1 = new JPanel();
        panel1.setBorder(new EmptyBorder(5, 5, 0, 5));
        panel1.setOpaque(false);
        panel1.setLayout(new FlowLayout());
        panel1.add(this.mtSLangs);
        panel1.add(this.mtTLangs);
        panel1.add(this.autoMT);
        JPanel panel2 = new JPanel();
        panel2.setBorder(new EmptyBorder(5, 20, 0, 5));
        panel2.setLayout(new SpringLayout());
        panel2.setOpaque(false);
        panel2.add(domainlabeL);
        panel2.add(this.domainBox);
        panel2.add(keylabeL);
        panel2.add(this.keyField);
        panel2.add(tonelabeL);
        panel2.add(this.toneBox);
        UITools.makeCompactGrid(panel2, 3, 2, 0, 0, 10, 5);
        JPanel panel3 = new JPanel(new FlowLayout(2));
        panel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        panel3.add(this.jb1);
        panel3.add(this.jb2);
        this.add((Component)panel1, "North");
        this.add((Component)panel2, "Center");
        this.add((Component)panel3, "South");
        panel3.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepLOptions.this.jb1.doClick();
            }
        });
        panel3.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepLOptions.this.jb2.doClick();
            }
        });
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            MT mtrans;
            Object ob = this.mtSLangs.getSelectedItem();
            if (ob != null) {
                AppPreferences.mtSource6 = ob.toString();
            }
            if ((ob = this.mtTLangs.getSelectedItem()) != null) {
                AppPreferences.mtTarget6 = ob.toString();
            }
            if ((mtrans = this.topui.getResourceView().getMT6()) != null) {
                mtrans.setLanguagePair(AppPreferences.mtSource6, AppPreferences.mtTarget6);
            }
            AppPreferences.deeplAPIKey = this.keyField.getText().trim();
            AppPreferences.deeplAPIDomain = this.domainBox.getSelectedItem().toString();
            AppPreferences.deeplAPIFormality = this.toneBox.getSelectedIndex();
            AppPreferences.autoMT6 = this.autoMT.isSelected();
            this.cancel();
        }
    }
}

