/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.Placeables;

public class MTRefinement {
    private static ConcurrentHashMap sourceMaskMap = new ConcurrentHashMap();
    private static ConcurrentHashMap targetMaskMap = new ConcurrentHashMap();
    private static int maskIndex = 1;
    private static AssembleParser parser;
    private static Pattern pattern;

    public static void setParser(AssembleParser ap) {
        parser = ap;
    }

    static synchronized String adjustNontranslatable(String mtarget) {
        String[] str = pattern.split(mtarget);
        int sindex = 0;
        int eindex = 0;
        int slength = mtarget.length();
        String result = mtarget;
        boolean adjusted = false;
        block0: for (int i = 0; i < str.length; ++i) {
            String key = str[i];
            if (key.length() == 0) continue;
            sindex = mtarget.indexOf(key, sindex);
            String part = mtarget.substring(sindex, slength);
            sindex += key.length();
            for (int j = str.length - 1; j >= i; --j) {
                key = str[j];
                eindex = part.lastIndexOf(key) + key.length();
                String npart = Placeables.getConvertedPlaceable(part = part.substring(0, eindex));
                if (npart != null) {
                    result = result.replace(part, npart);
                    adjusted = true;
                    i = j;
                    sindex += part.length();
                    continue block0;
                }
                part = part.substring(0, part.length() - key.length());
            }
        }
        if (adjusted) {
            return result;
        }
        return null;
    }

    public static String maskSource(String source) {
        if (AppPreferences.correctAA && !sourceMaskMap.isEmpty()) {
            for (Map.Entry entry : sourceMaskMap.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                source = source.replace(value, key);
            }
        }
        return source;
    }

    public static synchronized String refineMT(String target) {
        if (AppPreferences.correctAA) {
            String s = MTRefinement.adjustNontranslatable(target);
            if (s != null) {
                target = s;
            }
            if (AppPreferences.fragmentAdjustmentMT && parser != null) {
                target = parser.correctMT(target);
            } else if (!targetMaskMap.isEmpty()) {
                for (Map.Entry entry : targetMaskMap.entrySet()) {
                    String key = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    target = target.replace(key, value);
                }
            }
        }
        return target;
    }

    public static synchronized void maskFragment(String s, String t) {
        s = s.trim();
        t = t.trim();
        if (s.length() < 4) {
            return;
        }
        String m = "{" + String.valueOf(maskIndex) + "}";
        sourceMaskMap.put(m, s);
        targetMaskMap.put(m, t);
        ++maskIndex;
    }

    public static synchronized void resetMasking() {
        if (AppPreferences.correctAA) {
            maskIndex = 1;
            sourceMaskMap.clear();
            targetMaskMap.clear();
        }
    }

    static {
        pattern = Pattern.compile("[ .,!?]+");
    }
}

