/*
 * Decompiled with CFR 0.152.
 */
package translator.qa;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.GlossaryResource;
import translator.KeyPreferences;
import translator.MainView;
import translator.NumbersHelper;
import translator.Placeables;
import translator.Project;
import translator.ProjectView;
import translator.ResourceView;
import translator.Spellcheckable;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.WorkflowView;
import translator.XMLElement;
import translator.XMLHelper;
import translator.hunspell.HunSpellChecker;
import translator.qa.ExactTermParser;
import translator.qa.Fixable;
import translator.qa.Issue;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;
import translator.tmx.TMXView;
import translator.ttx.TTX;
import translator.ttx.TTXUnit;
import translator.ui.GridPanel;
import translator.xliff.FileBody;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class QAView {
    private MainView topui;
    private JMenu QAMenu;
    public JMenuItem repeatQAMenuItem;
    private ProjectView prview;
    private List tunitsFilter;
    private LinkedHashSet tunitsSetFilter;
    private boolean spacesCheck;
    private static HashMap issuesTMX;
    private List lastFilters;
    private boolean checkStart;

    public QAView(MainView topui) {
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.tunitsFilter = new ArrayList();
        this.setQAMenu();
    }

    public JMenu getMenu() {
        return this.QAMenu;
    }

    private void setQAMenu() {
        this.QAMenu = new JMenu("QA");
        JMenuItem transConformityMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION CONFORMITY CHECK"));
        transConformityMenu.setName("MenuQATranslationConformityCheck");
        transConformityMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                if (QAView.this.translationConformityCheck()) {
                    QAView.this.showQAResults();
                    QAView.this.projectToSave();
                }
            }
        });
        JMenuItem transCheckMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION CONSISTENCY CHECK"));
        transCheckMenu.setName("MenuQATranslationConsistencyCheck");
        transCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                if (QAView.this.translationConsistencyCheck()) {
                    QAView.this.showQAResults();
                    QAView.this.projectToSave();
                }
            }
        });
        JMenuItem termsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENTS CONSISTENCY CHECK") + " (" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY") + ")");
        termsMenu.setName("MenuQATermsConsistencyCheckMemory");
        termsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                if (QAView.this.termMemoryCheck()) {
                    QAView.this.showQAResults();
                    QAView.this.projectToSave();
                }
            }
        });
        JMenuItem termsMenu2 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TERMS CONSISTENCY CHECK") + " (" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY") + ")");
        termsMenu2.setName("MenuQATermsConsistencyCheckGlossary");
        termsMenu2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                if (QAView.this.termGlossaryCheck()) {
                    QAView.this.showQAResults();
                    QAView.this.projectToSave();
                }
            }
        });
        JMenuItem nontranslatablesCheckMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NON-TRANSLATABLE FRAGMENTS CHECK"));
        nontranslatablesCheckMenu.setName("MenuQANontranslatableFragmentsCheck");
        nontranslatablesCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                if (QAView.this.nonTranslatablesCheck()) {
                    QAView.this.showQAResults();
                    QAView.this.projectToSave();
                } else {
                    JOptionPane.showMessageDialog(QAView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION NOT SUPPORTED FOR THIS FILE TYPE"));
                    QAView.this.topui.resetSegmentsFilter();
                }
            }
        });
        JMenuItem tagsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TAGS CHECK"));
        tagsMenu.setName("MenuQATagsCheck");
        tagsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.tagsCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem spaceLMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LEADING SPACES CHECK"));
        spaceLMenu.setName("MenuQALeadingSpacesCheck");
        spaceLMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.spacesCheck = true;
                QAView.this.initQA();
                QAView.this.spaceLeadingCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
                QAView.this.spacesCheck = false;
            }
        });
        JMenuItem spaceTMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRAILING SPACES CHECK"));
        spaceTMenu.setName("MenuQATrailingSpacesCheck");
        spaceTMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.spacesCheck = true;
                QAView.this.initQA();
                QAView.this.spaceTrailingCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
                QAView.this.spacesCheck = false;
            }
        });
        JMenuItem spaceDoubleMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE SPACES CHECK"));
        spaceDoubleMenu.setName("MenuQADoubleSpacesCheck");
        spaceDoubleMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.spacesCheck = true;
                QAView.this.initQA();
                QAView.this.spaceDoubleCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
                QAView.this.spacesCheck = false;
            }
        });
        JMenuItem spaceAtTagsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AT TAGS SPACES CHECK"));
        spaceAtTagsMenu.setName("MenuQAAtTagSpacesCheck");
        spaceAtTagsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.spacesCheck = true;
                QAView.this.initQA();
                QAView.this.spaceAtTagsCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
                QAView.this.spacesCheck = false;
            }
        });
        JMenuItem digitsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NUMBERS CHECK"));
        digitsMenu.setName("MenuQANumbersCheck");
        digitsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.digitsCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem emptySegsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EMPTY SEGMENTS CHECK"));
        emptySegsMenu.setName("MenuQAEmptySegsCheck");
        emptySegsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.emptySegmentsCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem sameSegsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET SAME AS SOURCE CHECK"));
        sameSegsMenu.setName("MenuQATargetSameAsSourceCheck");
        sameSegsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.sameSegmentsCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem sameSourceDifferentTargetMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAME SOURCE WITH DIFFERENT TARGET CHECK"));
        sameSourceDifferentTargetMenu.setName("MenuQASameSourceDifferentTargetCheck");
        sameSourceDifferentTargetMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.sameSourceDifferentTargetCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem sameTargetDifferentSourceMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAME TARGET WITH DIFFERENT SOURCE CHECK"));
        sameTargetDifferentSourceMenu.setName("MenuQASameTargetDifferentSourceCheck");
        sameTargetDifferentSourceMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.sameTargetDifferentSourceCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem endPunctMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("END PUNCTUATION CHECK"));
        endPunctMenu.setName("MenuQAEndPunctuationCheck");
        endPunctMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.endPunctuationCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem caseCheckMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INITIAL CAPITALIZATION CHECK"));
        caseCheckMenu.setName("MenuQAInitialCapitalizationCheck");
        caseCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.capitalizationCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem doubleWordsCheckMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE WORDS CHECK"));
        doubleWordsCheckMenu.setName("MenuQADoubleWordsCheck");
        doubleWordsCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.doubleWordsCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem lengthDifferenceCheckMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LENGTH DIFFERENCE CHECK") + " (%)");
        lengthDifferenceCheckMenu.setName("MenuQALengthDifferenceCheck");
        lengthDifferenceCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.lengthDifferenceCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem lengthDifferenceCheckCharsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LENGTH DIFFERENCE CHECK") + " (chars)");
        lengthDifferenceCheckCharsMenu.setName("MenuQALengthDifferenceCharsCheck");
        lengthDifferenceCheckCharsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.lengthDifferenceCheckChars();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem maximumLengthCheckMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MAXIMUM SEGMENT LENGTH CHECK"));
        maximumLengthCheckMenu.setName("MenuQAMaximumLengthCheck");
        maximumLengthCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.maxLengthCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem spellCheckMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK SPELLING IN TARGET SEGMENTS"));
        spellCheckMenu.setName("MenuQACheckSpellingInTargetSegs");
        spellCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.spellCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem bracketsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BRACKETS CHECK"));
        bracketsMenu.setName("MenuQABracketsCheck");
        bracketsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.bracketsCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem quotesMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("QUOTATION MARKS CHECK"));
        quotesMenu.setName("MenuQABracketsCheck");
        quotesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.initQA();
                QAView.this.quotesCheck();
                QAView.this.showQAResults();
                QAView.this.projectToSave();
            }
        });
        JMenuItem allMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK ALL"));
        allMenu.setName("MenuQACheckAll");
        allMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.showCheckAllDialog();
            }
        });
        JMenu listMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORD LISTS"));
        listMenu.setName("MenuQAWordLists");
        JMenuItem whitelistSourceMenuItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK SOURCE SEGMENTS FOR WORDS") + "...");
        whitelistSourceMenuItem.setName("MenuQAWordListsCheckSource");
        whitelistSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                File f = new File(AppPreferences.QAwordlistDir);
                                if (f.exists() && f.isDirectory()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            AppPreferences.QAwordlistDir = file.getParent();
                                            String s = this.this$2.QAView.this.readStream(file, AppPreferences.en);
                                            if (s != null && s.length() > 0) {
                                                this.this$2.QAView.this.initQA();
                                                this.this$2.QAView.this.blacklistCheck(s, true, true);
                                                this.this$2.QAView.this.showQAResults();
                                                this.this$2.QAView.this.projectToSave();
                                            }
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(this.this$2.QAView.this.topui, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(new File(""));
                    jFileChooser.setCurrentDirectory(new File(AppPreferences.QAwordlistDir));
                    jFileChooser.repaint();
                    if (0 == jFileChooser.showOpenDialog(QAView.this.topui)) {
                        File file = jFileChooser.getSelectedFile();
                        AppPreferences.QAwordlistDir = file.getParent();
                        String s = QAView.this.readStream(file, AppPreferences.en);
                        if (s != null && s.length() > 0) {
                            QAView.this.initQA();
                            QAView.this.blacklistCheck(s, true, true);
                            QAView.this.showQAResults();
                            QAView.this.projectToSave();
                        }
                    }
                }
            }
        });
        JMenuItem whitelistTargetMenuItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK TARGET SEGMENTS FOR WORDS") + "...");
        whitelistTargetMenuItem.setName("MenuQAWordListsCheckTarget");
        whitelistTargetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                File f = new File(AppPreferences.QAwordlistDir);
                                if (f.exists() && f.isDirectory()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            AppPreferences.QAwordlistDir = file.getParent();
                                            String s = this.this$2.QAView.this.readStream(file, AppPreferences.en);
                                            if (s != null && s.length() > 0) {
                                                this.this$2.QAView.this.initQA();
                                                this.this$2.QAView.this.blacklistCheck(s, false, true);
                                                this.this$2.QAView.this.showQAResults();
                                                this.this$2.QAView.this.projectToSave();
                                            }
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(this.this$2.QAView.this.topui, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(new File(""));
                    jFileChooser.setCurrentDirectory(new File(AppPreferences.QAwordlistDir));
                    jFileChooser.repaint();
                    if (0 == jFileChooser.showOpenDialog(QAView.this.topui)) {
                        File file = jFileChooser.getSelectedFile();
                        AppPreferences.QAwordlistDir = file.getParent();
                        String s = QAView.this.readStream(file, AppPreferences.en);
                        if (s != null && s.length() > 0) {
                            QAView.this.initQA();
                            QAView.this.blacklistCheck(s, false, true);
                            QAView.this.showQAResults();
                            QAView.this.projectToSave();
                        }
                    }
                }
            }
        });
        JMenuItem blacklistSourceMenuItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK SOURCE SEGMENTS FOR MISSING WORDS") + "...");
        blacklistSourceMenuItem.setName("MenuQAWordListsCheckSourceMissing");
        blacklistSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                File f = new File(AppPreferences.QAwordlistDir);
                                if (f.exists() && f.isDirectory()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            AppPreferences.QAwordlistDir = file.getParent();
                                            String s = this.this$2.QAView.this.readStream(file, AppPreferences.en);
                                            if (s != null && s.length() > 0) {
                                                this.this$2.QAView.this.initQA();
                                                this.this$2.QAView.this.blacklistCheck(s, true, false);
                                                this.this$2.QAView.this.showQAResults();
                                                this.this$2.QAView.this.projectToSave();
                                            }
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(this.this$2.QAView.this.topui, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(new File(""));
                    jFileChooser.setCurrentDirectory(new File(AppPreferences.QAwordlistDir));
                    jFileChooser.repaint();
                    if (0 == jFileChooser.showOpenDialog(QAView.this.topui)) {
                        File file = jFileChooser.getSelectedFile();
                        AppPreferences.QAwordlistDir = file.getParent();
                        String s = QAView.this.readStream(file, AppPreferences.en);
                        if (s != null && s.length() > 0) {
                            QAView.this.initQA();
                            QAView.this.blacklistCheck(s, true, false);
                            QAView.this.showQAResults();
                            QAView.this.projectToSave();
                        }
                    }
                }
            }
        });
        JMenuItem blacklistTargetMenuItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK TARGET SEGMENTS FOR MISSING WORDS") + "...");
        blacklistTargetMenuItem.setName("MenuQAWordListsCheckTargetMissing");
        blacklistTargetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                File f = new File(AppPreferences.QAwordlistDir);
                                if (f.exists() && f.isDirectory()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            AppPreferences.QAwordlistDir = file.getParent();
                                            String s = this.this$2.QAView.this.readStream(file, AppPreferences.en);
                                            if (s != null && s.length() > 0) {
                                                this.this$2.QAView.this.initQA();
                                                this.this$2.QAView.this.blacklistCheck(s, false, false);
                                                this.this$2.QAView.this.showQAResults();
                                                this.this$2.QAView.this.projectToSave();
                                            }
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(this.this$2.QAView.this.topui, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(new File(""));
                    jFileChooser.setCurrentDirectory(new File(AppPreferences.QAwordlistDir));
                    jFileChooser.repaint();
                    if (0 == jFileChooser.showOpenDialog(QAView.this.topui)) {
                        File file = jFileChooser.getSelectedFile();
                        AppPreferences.QAwordlistDir = file.getParent();
                        String s = QAView.this.readStream(file, AppPreferences.en);
                        if (s != null && s.length() > 0) {
                            QAView.this.initQA();
                            QAView.this.blacklistCheck(s, false, false);
                            QAView.this.showQAResults();
                            QAView.this.projectToSave();
                        }
                    }
                }
            }
        });
        JMenuItem findAndReplaceSourceMenuItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AND REPLACE IN SOURCE SEGMENTS") + "...");
        findAndReplaceSourceMenuItem.setName("MenuQAWordListsFindAndReplaceSource");
        findAndReplaceSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                File f = new File(AppPreferences.QAwordlistDir);
                                if (f.exists() && f.isDirectory()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            AppPreferences.QAwordlistDir = file.getParent();
                                            HashMap map = this.this$2.QAView.this.readStreamToMap(file, AppPreferences.en);
                                            this.this$2.QAView.this.initQA();
                                            this.this$2.QAView.this.findAndReplaceListCheck(map, true);
                                            this.this$2.QAView.this.showQAResults();
                                            this.this$2.QAView.this.projectToSave();
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(this.this$2.QAView.this.topui, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(new File(""));
                    jFileChooser.setCurrentDirectory(new File(AppPreferences.QAwordlistDir));
                    jFileChooser.repaint();
                    if (0 == jFileChooser.showOpenDialog(QAView.this.topui)) {
                        File file = jFileChooser.getSelectedFile();
                        AppPreferences.QAwordlistDir = file.getParent();
                        HashMap map = QAView.this.readStreamToMap(file, AppPreferences.en);
                        QAView.this.initQA();
                        QAView.this.findAndReplaceListCheck(map, true);
                        QAView.this.showQAResults();
                        QAView.this.projectToSave();
                    }
                }
            }
        });
        JMenuItem findAndReplaceTargetMenuItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AND REPLACE IN TARGET SEGMENTS") + "...");
        findAndReplaceTargetMenuItem.setName("MenuQAWordListsFindAndReplaceTarget");
        findAndReplaceTargetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                File f = new File(AppPreferences.QAwordlistDir);
                                if (f.exists() && f.isDirectory()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            AppPreferences.QAwordlistDir = file.getParent();
                                            HashMap map = this.this$2.QAView.this.readStreamToMap(file, AppPreferences.en);
                                            this.this$2.QAView.this.initQA();
                                            this.this$2.QAView.this.findAndReplaceListCheck(map, false);
                                            this.this$2.QAView.this.showQAResults();
                                            this.this$2.QAView.this.projectToSave();
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(this.this$2.QAView.this.topui, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(new File(""));
                    jFileChooser.setCurrentDirectory(new File(AppPreferences.QAwordlistDir));
                    jFileChooser.repaint();
                    if (0 == jFileChooser.showOpenDialog(QAView.this.topui)) {
                        File file = jFileChooser.getSelectedFile();
                        AppPreferences.QAwordlistDir = file.getParent();
                        HashMap map = QAView.this.readStreamToMap(file, AppPreferences.en);
                        QAView.this.initQA();
                        QAView.this.findAndReplaceListCheck(map, false);
                        QAView.this.showQAResults();
                        QAView.this.projectToSave();
                    }
                }
            }
        });
        listMenu.add(whitelistSourceMenuItem);
        listMenu.add(whitelistTargetMenuItem);
        listMenu.addSeparator();
        listMenu.add(blacklistSourceMenuItem);
        listMenu.add(blacklistTargetMenuItem);
        listMenu.addSeparator();
        listMenu.add(findAndReplaceSourceMenuItem);
        listMenu.add(findAndReplaceTargetMenuItem);
        this.repeatQAMenuItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPEAT LAST QA CHECK"));
        this.repeatQAMenuItem.setName("MenuQARepeatLast");
        KeyStroke ks = KeyPreferences.getKeyStroke("k92");
        if (ks != null) {
            this.repeatQAMenuItem.setAccelerator(ks);
        }
        this.repeatQAMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QAView.this.repeatLastQA();
            }
        });
        JMenu consistencyMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONSISTENCY CHECKS"));
        consistencyMenu.add(transCheckMenu);
        consistencyMenu.add(termsMenu);
        consistencyMenu.add(termsMenu2);
        consistencyMenu.add(transConformityMenu);
        this.QAMenu.add(listMenu);
        this.QAMenu.addSeparator();
        this.QAMenu.add(this.repeatQAMenuItem);
        this.QAMenu.addSeparator();
        this.QAMenu.add(consistencyMenu);
        this.QAMenu.addSeparator();
        this.QAMenu.add(spellCheckMenu);
        this.QAMenu.addSeparator();
        this.QAMenu.add(tagsMenu);
        this.QAMenu.add(bracketsMenu);
        this.QAMenu.add(quotesMenu);
        this.QAMenu.addSeparator();
        this.QAMenu.add(spaceLMenu);
        this.QAMenu.add(spaceTMenu);
        this.QAMenu.add(spaceDoubleMenu);
        this.QAMenu.add(spaceAtTagsMenu);
        this.QAMenu.addSeparator();
        this.QAMenu.add(nontranslatablesCheckMenu);
        this.QAMenu.add(digitsMenu);
        this.QAMenu.add(emptySegsMenu);
        this.QAMenu.add(sameSegsMenu);
        this.QAMenu.add(sameSourceDifferentTargetMenu);
        this.QAMenu.add(sameTargetDifferentSourceMenu);
        this.QAMenu.addSeparator();
        this.QAMenu.add(endPunctMenu);
        this.QAMenu.add(caseCheckMenu);
        this.QAMenu.add(doubleWordsCheckMenu);
        this.QAMenu.add(lengthDifferenceCheckMenu);
        this.QAMenu.add(lengthDifferenceCheckCharsMenu);
        this.QAMenu.add(maximumLengthCheckMenu);
        this.QAMenu.addSeparator();
        this.QAMenu.add(allMenu);
    }

    public void showCheckAllDialog() {
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK ALL"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 2, 4, 8));
        dialog.add(panel);
        final JCheckBox QAMenu1 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION CONSISTENCY CHECK"));
        QAMenu1.setSelected(AppPreferences.QACheck1);
        final JCheckBox QAMenu3 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENTS CONSISTENCY CHECK") + " (" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION MEMORIES") + ")");
        QAMenu3.setSelected(AppPreferences.QACheck3);
        final JCheckBox QAMenu4 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TERMS CONSISTENCY CHECK") + " (" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES") + ")");
        QAMenu4.setSelected(AppPreferences.QACheck4);
        final JCheckBox QAMenu2 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION CONFORMITY CHECK"));
        QAMenu2.setSelected(AppPreferences.QACheck2);
        final JCheckBox QAMenu5 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NON-TRANSLATABLE FRAGMENTS CHECK"));
        QAMenu5.setSelected(AppPreferences.QACheck5);
        final JCheckBox QAMenu6 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK SPELLING IN TARGET SEGMENTS"));
        QAMenu6.setSelected(AppPreferences.QACheck6);
        final JCheckBox QAMenu7 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TAGS CHECK"));
        QAMenu7.setSelected(AppPreferences.QACheck7);
        final JCheckBox QAMenu8 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BRACKETS CHECK"));
        QAMenu8.setSelected(AppPreferences.QACheck8);
        final JCheckBox QAMenu9 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LEADING SPACES CHECK"));
        QAMenu9.setSelected(AppPreferences.QACheck9);
        final JCheckBox QAMenu10 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRAILING SPACES CHECK"));
        QAMenu10.setSelected(AppPreferences.QACheck10);
        final JCheckBox QAMenu11 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE SPACES CHECK"));
        QAMenu11.setSelected(AppPreferences.QACheck11);
        final JCheckBox QAMenu12 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AT TAGS SPACES CHECK"));
        QAMenu12.setSelected(AppPreferences.QACheck12);
        final JCheckBox QAMenu13 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NUMBERS CHECK"));
        QAMenu13.setSelected(AppPreferences.QACheck13);
        final JCheckBox QAMenu14 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EMPTY SEGMENTS CHECK"));
        QAMenu14.setSelected(AppPreferences.QACheck14);
        final JCheckBox QAMenu15 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET SAME AS SOURCE CHECK"));
        QAMenu15.setSelected(AppPreferences.QACheck15);
        final JCheckBox QAMenu16 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAME SOURCE WITH DIFFERENT TARGET CHECK"));
        QAMenu16.setSelected(AppPreferences.QACheck16);
        final JCheckBox QAMenu17 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAME TARGET WITH DIFFERENT SOURCE CHECK"));
        QAMenu17.setSelected(AppPreferences.QACheck17);
        final JCheckBox QAMenu18 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("END PUNCTUATION CHECK"));
        QAMenu18.setSelected(AppPreferences.QACheck18);
        final JCheckBox QAMenu19 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INITIAL CAPITALIZATION CHECK"));
        QAMenu19.setSelected(AppPreferences.QACheck19);
        final JCheckBox QAMenu20 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE WORDS CHECK"));
        QAMenu20.setSelected(AppPreferences.QACheck20);
        final JCheckBox QAMenu21 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LENGTH DIFFERENCE CHECK") + " (%)");
        QAMenu21.setSelected(AppPreferences.QACheck21);
        final JCheckBox QAMenu22 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LENGTH DIFFERENCE CHECK") + " (chars)");
        QAMenu22.setSelected(AppPreferences.QACheck22);
        final JCheckBox QAMenu23 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MAXIMUM SEGMENT LENGTH CHECK"));
        QAMenu23.setSelected(AppPreferences.QACheck23);
        final JCheckBox QAMenu24 = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("QUOTATION MARKS CHECK"));
        QAMenu24.setSelected(AppPreferences.QACheck24);
        panel.add(QAMenu1);
        panel.add(QAMenu3);
        panel.add(QAMenu4);
        panel.add(QAMenu2);
        panel.add(QAMenu5);
        panel.add(QAMenu6);
        panel.add(QAMenu7);
        panel.add(QAMenu9);
        panel.add(QAMenu10);
        panel.add(QAMenu8);
        panel.add(QAMenu11);
        panel.add(QAMenu24);
        panel.add(QAMenu12);
        panel.add(QAMenu13);
        panel.add(QAMenu14);
        panel.add(QAMenu15);
        panel.add(QAMenu16);
        panel.add(QAMenu17);
        panel.add(QAMenu18);
        panel.add(QAMenu19);
        panel.add(QAMenu20);
        panel.add(QAMenu21);
        panel.add(QAMenu22);
        panel.add(QAMenu23);
        JButton jButton1 = new JButton();
        jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        jButton1.addActionListener(new ActionListener(){
            final /* synthetic */ QAView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
                this.this$0.initQA();
                this.this$0.tunitsSetFilter = new LinkedHashSet();
                AppPreferences.QACheck1 = QAMenu1.isSelected();
                AppPreferences.QACheck2 = QAMenu2.isSelected();
                AppPreferences.QACheck3 = QAMenu3.isSelected();
                AppPreferences.QACheck4 = QAMenu4.isSelected();
                AppPreferences.QACheck5 = QAMenu5.isSelected();
                AppPreferences.QACheck6 = QAMenu6.isSelected();
                AppPreferences.QACheck7 = QAMenu7.isSelected();
                AppPreferences.QACheck8 = QAMenu8.isSelected();
                AppPreferences.QACheck9 = QAMenu9.isSelected();
                AppPreferences.QACheck10 = QAMenu10.isSelected();
                AppPreferences.QACheck11 = QAMenu11.isSelected();
                AppPreferences.QACheck12 = QAMenu12.isSelected();
                AppPreferences.QACheck13 = QAMenu13.isSelected();
                AppPreferences.QACheck14 = QAMenu14.isSelected();
                AppPreferences.QACheck15 = QAMenu15.isSelected();
                AppPreferences.QACheck16 = QAMenu16.isSelected();
                AppPreferences.QACheck17 = QAMenu17.isSelected();
                AppPreferences.QACheck18 = QAMenu18.isSelected();
                AppPreferences.QACheck19 = QAMenu19.isSelected();
                AppPreferences.QACheck20 = QAMenu20.isSelected();
                AppPreferences.QACheck21 = QAMenu21.isSelected();
                AppPreferences.QACheck22 = QAMenu22.isSelected();
                AppPreferences.QACheck23 = QAMenu23.isSelected();
                AppPreferences.QACheck24 = QAMenu24.isSelected();
                if (AppPreferences.QACheck1) {
                    this.this$0.translationConsistencyCheck();
                }
                if (AppPreferences.QACheck2) {
                    this.this$0.translationConformityCheck();
                }
                if (AppPreferences.QACheck3) {
                    this.this$0.termMemoryCheck();
                }
                if (AppPreferences.QACheck4) {
                    this.this$0.termGlossaryCheck();
                }
                if (AppPreferences.QACheck5) {
                    this.this$0.nonTranslatablesCheck();
                }
                if (AppPreferences.QACheck6) {
                    this.this$0.spellCheck();
                }
                if (AppPreferences.QACheck7) {
                    this.this$0.tagsCheck();
                }
                if (AppPreferences.QACheck8) {
                    this.this$0.bracketsCheck();
                }
                if (AppPreferences.QACheck9) {
                    this.this$0.spaceLeadingCheck();
                }
                if (AppPreferences.QACheck10) {
                    this.this$0.spaceTrailingCheck();
                }
                if (AppPreferences.QACheck11) {
                    this.this$0.spaceDoubleCheck();
                }
                if (AppPreferences.QACheck12) {
                    this.this$0.spaceAtTagsCheck();
                }
                if (AppPreferences.QACheck13) {
                    this.this$0.digitsCheck();
                }
                if (AppPreferences.QACheck14) {
                    this.this$0.emptySegmentsCheck();
                }
                if (AppPreferences.QACheck15) {
                    this.this$0.sameSegmentsCheck();
                }
                if (AppPreferences.QACheck16) {
                    this.this$0.sameSourceDifferentTargetCheck();
                }
                if (AppPreferences.QACheck17) {
                    this.this$0.sameTargetDifferentSourceCheck();
                }
                if (AppPreferences.QACheck18) {
                    this.this$0.endPunctuationCheck();
                }
                if (AppPreferences.QACheck19) {
                    this.this$0.capitalizationCheck();
                }
                if (AppPreferences.QACheck20) {
                    this.this$0.doubleWordsCheck();
                }
                if (AppPreferences.QACheck21) {
                    this.this$0.lengthDifferenceCheck();
                }
                if (AppPreferences.QACheck22) {
                    this.this$0.lengthDifferenceCheckChars();
                }
                if (AppPreferences.QACheck23) {
                    this.this$0.maxLengthCheck();
                }
                if (AppPreferences.QACheck24) {
                    this.this$0.quotesCheck();
                }
                this.this$0.tunitsFilter = new ArrayList(this.this$0.tunitsSetFilter);
                this.this$0.tunitsSetFilter = null;
                this.this$0.showQAResults();
                this.this$0.projectToSave();
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        jButton2.addActionListener(new ActionListener(){
            final /* synthetic */ QAView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panel.add(jButton1);
        panel.add(jButton2);
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    private void initQA() {
        this.tunitsFilter.clear();
        if (this.lastFilters != null) {
            this.lastFilters.clear();
        } else {
            this.lastFilters = new ArrayList();
        }
        List tunits = null;
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            XliffFile file;
            tunits = xliff.getView().getGluedUnits();
            if (tunits == null && (file = xliff.getCurrentFile()) != null) {
                FileBody body = file.getBody();
                tunits = body.getTransUnits();
            }
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                tunits = ttx.getView().getGluedUnits();
                if (tunits == null) {
                    tunits = ttx.getCurrentFile().getTransUnits();
                }
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    issuesTMX = new HashMap();
                }
            }
        }
        if (tunits == null) {
            return;
        }
        for (Object o : tunits) {
            if (o == null || !(o instanceof Fixable)) continue;
            Fixable tu = (Fixable)o;
            tu.setIssues();
        }
    }

    private void tagsCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.tagsCheckXliff(xliff);
            if (!xliff.isCafeTranXLIFF) {
                this.tagsContentCheckXliff(xliff);
            }
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.tagsCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.tagsCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(1);
    }

    private void bracketsCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.bracketsCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.bracketsCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.bracketsCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(2);
    }

    private void quotesCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.quotesCheckXliff(xliff);
        } else {
            JOptionPane.showMessageDialog(this.topui, "Not supported QA action for this file format");
        }
        this.lastFilters.add(24);
    }

    private void spaceLeadingCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.spaceLeadingCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.spaceLeadingCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.spaceLeadingCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(3);
    }

    private void spaceTrailingCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.spaceTrailingCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.spaceTrailingCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.spaceTrailingCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(4);
    }

    private void spaceDoubleCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.spaceDoubleCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.spaceDoubleCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.spaceDoubleCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(5);
    }

    private void spaceAtTagsCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.spaceAtTagsCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.spaceAtTagsCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.spaceAtTagsCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(6);
    }

    private void spellCheck() {
        HunSpellChecker sp = this.topui.getSpellChecker();
        if (sp != null && sp.hasTargetDictionary()) {
            XLIFF xliff = this.prview.getProject().getXLIFF();
            if (xliff != null) {
                this.spellCheckXliff(xliff, sp);
            } else {
                TTX ttx = this.prview.getProject().getTTX();
                if (ttx != null) {
                    this.spellCheckTTX(ttx, sp);
                } else {
                    TMX tmx = this.prview.getProject().getTMX();
                    if (tmx != null) {
                        this.spellCheckTMX(tmx, sp);
                    }
                }
            }
        } else {
            Spellcheckable sp2 = this.topui.getResourceView().getSpellcheckable();
            if (sp2 != null) {
                XLIFF xliff = this.prview.getProject().getXLIFF();
                if (xliff != null) {
                    this.spellCheckXliff(xliff, sp2);
                } else {
                    TTX ttx = this.prview.getProject().getTTX();
                    if (ttx != null) {
                        this.spellCheckTTX(ttx, sp2);
                    }
                }
            }
        }
        this.lastFilters.add(7);
    }

    private void digitsCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.digitsCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.digitsCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.digitsCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(8);
    }

    private void emptySegmentsCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.emptySegmentsCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.emptySegmentsCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.emptySegmentsCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(9);
    }

    private void sameSegmentsCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.sameSegmentsCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.sameSegmentsCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.sameSegmentsCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(10);
    }

    private void sameSourceDifferentTargetCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.sameSourceDifferentTargetXLIFF(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                JOptionPane.showMessageDialog(this.topui, "Not supported QA action for this file format");
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.sameSourceDifferentTargetTMX(tmx);
                }
            }
        }
        this.lastFilters.add(18);
    }

    private void sameTargetDifferentSourceCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.sameTargetDifferentSourceXLIFF(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                JOptionPane.showMessageDialog(this.topui, "Not supported QA action for this file format");
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.sameTargetDifferentSourceTMX(tmx);
                }
            }
        }
        this.lastFilters.add(19);
    }

    private void endPunctuationCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.endPunctCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.endPunctCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.endPunctCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(11);
    }

    private void capitalizationCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.capitalizationCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.capitalizationCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.capitalizationCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(12);
    }

    private void doubleWordsCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.doubleWordsCheckXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.doubleWordsCheckTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.doubleWordsCheckTMX(tmx);
                }
            }
        }
        this.lastFilters.add(13);
    }

    private void lengthDifferenceCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.lengthDifferenceCheckXliff(xliff);
        } else {
            TMX tmx = this.prview.getProject().getTMX();
            if (tmx != null) {
                this.lengthDifferenceCheckTMX(tmx);
            }
        }
        this.lastFilters.add(21);
    }

    private void lengthDifferenceCheckChars() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.lengthDifferenceCheckXliffChars(xliff);
        } else {
            TMX tmx = this.prview.getProject().getTMX();
            if (tmx != null) {
                this.lengthDifferenceCheckTMXChars(tmx);
            }
        }
        this.lastFilters.add(22);
    }

    private void maxLengthCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.maxLengthCheckXliff(xliff);
        } else {
            TMX tmx = this.prview.getProject().getTMX();
            if (tmx != null) {
                this.maxLengthCheckTMX(tmx);
            }
        }
        this.lastFilters.add(23);
    }

    private void blacklistCheck(String query, boolean language, boolean hit) {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.blacklistCheckXliff(xliff, query, language, hit);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.blacklistCheckTTX(ttx, query, language, hit);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.blacklistCheckTMX(tmx, query, language, hit);
                }
            }
        }
    }

    private void findAndReplaceListCheck(HashMap map, boolean language) {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.findAndReplaceCheckXliff(xliff, map, language);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.findAndReplaceCheckTTX(ttx, map, language);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.findAndReplaceCheckTMX(tmx, map, language);
                }
            }
        }
    }

    private boolean translationConsistencyCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.translationConsistencyCheckXliff(xliff);
        } else {
            TMX tmx = this.prview.getProject().getTMX();
            if (tmx != null) {
                this.translationConsistencyCheckTMX(tmx);
            }
        }
        this.lastFilters.add(14);
        return true;
    }

    private boolean translationConformityCheck() {
        this.checkStart = false;
        TMX tmx = this.prview.getProject().getTMX();
        if (tmx != null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION NOT SUPPORTED FOR THIS FILE TYPE"));
            this.topui.resetSegmentsFilter();
            return false;
        }
        MemoryView mview = this.topui.getMemoryView();
        List mems = mview.getLocalMemories();
        if (mems.size() > 0) {
            this.conformityCheckDialog(mems);
            if (!this.checkStart) {
                return false;
            }
            XLIFF xliff = this.prview.getProject().getXLIFF();
            if (xliff != null) {
                this.conformityCheckXliff(xliff);
            } else {
                TTX ttx = this.prview.getProject().getTTX();
                if (ttx != null) {
                    this.conformityCheckTTX(ttx);
                }
            }
        }
        this.lastFilters.add(15);
        return true;
    }

    private void conformityCheckXliff(XLIFF xliff) {
        MemoryView mview = this.topui.getMemoryView();
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            boolean b;
            String source;
            String targett;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (targett = tu.getTargetText()) == null || targett.length() == 0 || (source = tu.getSourceText()).length() <= 0 || !(b = mview.translateForTargetsDifferenceCheck(source, tu))) continue;
            Issue issue = new Issue(12);
            tu.addIssue(issue);
            issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DIFFERENT TRANSLATION"));
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void conformityCheckTTX(TTX ttx) {
        MemoryView mview = this.topui.getMemoryView();
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            boolean b;
            String source;
            String targett;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments || (targett = tu.getTargetText()) == null || targett.length() == 0 || (source = tu.getSourceText()).length() <= 0 || !(b = mview.translateForTargetsDifferenceCheck(source, tu))) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private boolean termMemoryCheck() {
        this.checkStart = false;
        TMX tmx = this.prview.getProject().getTMX();
        if (tmx != null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION NOT SUPPORTED FOR THIS FILE TYPE"));
            this.topui.resetSegmentsFilter();
            return false;
        }
        MemoryView mview = this.topui.getMemoryView();
        List mems = mview.getLocalMemories();
        if (mems.size() > 0) {
            this.memoryTermCheckDialog(mems);
            if (!this.checkStart) {
                return false;
            }
            for (Object object : mems) {
                Memory m = (Memory)object;
                if (!m.getTermsCheck()) continue;
                m.setActive(true);
                XLIFF xliff = this.prview.getProject().getXLIFF();
                if (xliff != null) {
                    this.termCheckXliff(xliff, m);
                } else {
                    TTX ttx = this.prview.getProject().getTTX();
                    if (ttx != null) {
                        this.termCheckTTX(ttx, m);
                    }
                }
                m.setActive(false);
            }
        }
        this.lastFilters.add(16);
        return true;
    }

    private void termCheckXliff(XLIFF xliff, Memory m) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        ExactTermParser parser = new ExactTermParser();
        int matchType = m.getMatchType();
        parser.setMatchingType(matchType);
        parser.setTUMap(m.getTMX().getTUMap());
        parser.setMemoryName(m.getName());
        for (Object o : tunits) {
            Fixable f;
            String targett;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (targett = tu.getTargetText()) == null || targett.length() == 0 || (f = parser.translate(tu)) == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(f);
                continue;
            }
            this.tunitsFilter.add(f);
        }
    }

    private void termCheckTTX(TTX ttx, Memory m) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        ExactTermParser parser = new ExactTermParser();
        int matchType = m.getMatchType();
        parser.setMatchingType(matchType);
        parser.setTUMap(m.getTMX().getTUMap());
        parser.setMemoryName(m.getName());
        for (Object o : tunits) {
            Fixable f;
            String targett;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments || (targett = tu.getTargetText()) == null || targett.length() == 0 || (f = parser.translate(tu)) == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(f);
                continue;
            }
            this.tunitsFilter.add(f);
        }
    }

    private boolean termGlossaryCheck() {
        this.checkStart = false;
        TMX tmx = this.prview.getProject().getTMX();
        if (tmx != null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION NOT SUPPORTED FOR THIS FILE TYPE"));
            this.topui.resetSegmentsFilter();
            return false;
        }
        ResourceView rview = this.topui.getResourceView();
        List glossList = rview.getGlossaries();
        if (glossList != null && glossList.size() > 0) {
            this.glossaryTermCheckDialog(glossList);
            if (!this.checkStart) {
                return false;
            }
            for (Object object : glossList) {
                GlossaryResource g = (GlossaryResource)object;
                boolean b = g.isQATermsCheck();
                if (!b) continue;
                XLIFF xliff = this.prview.getProject().getXLIFF();
                if (xliff != null) {
                    this.termCheckXliff(xliff, g);
                    continue;
                }
                TTX ttx = this.prview.getProject().getTTX();
                if (ttx == null) continue;
                this.termCheckTTX(ttx, g);
            }
        }
        this.lastFilters.add(17);
        return true;
    }

    private void termCheckXliff(XLIFF xliff, GlossaryResource g) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            Fixable f;
            String targett;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (targett = tu.getTargetText()) == null || targett.length() == 0 || (f = g.getGlossaryEntriesQA(tu)) == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(f);
                continue;
            }
            this.tunitsFilter.add(f);
        }
    }

    private void termCheckTTX(TTX ttx, GlossaryResource g) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            Fixable f;
            String targett;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments || (targett = tu.getTargetText()) == null || targett.length() == 0 || (f = g.getGlossaryEntriesQA(tu)) == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(f);
                continue;
            }
            this.tunitsFilter.add(f);
        }
    }

    private boolean nonTranslatablesCheck() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.nonTranslatablesXliff(xliff);
            this.lastFilters.add(20);
            return true;
        }
        return false;
    }

    private void nonTranslatablesXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Set set = Placeables.getPlaceablesSet();
        set.remove("|" + Placeables.whiteSpaces);
        for (Object o : tunits) {
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            Iterator it2 = set.iterator();
            while (it2.hasNext()) {
                Matcher m2;
                Matcher m1;
                Pattern ppattern;
                boolean foundInSource = false;
                boolean foundInTarget = false;
                String place = it2.next().toString();
                if (place.charAt(0) != '|') {
                    Matcher m22;
                    String ckey = null;
                    ppattern = Pattern.compile(place, 16);
                    m1 = ppattern.matcher(source);
                    if (m1.find()) {
                        foundInSource = true;
                        String found = m1.group();
                        String cp = Placeables.getPlaceablesForConversion(place);
                        if (cp != null) {
                            Placeables.addPlaceableToConversionMap(found, m1);
                            ckey = Placeables.getConvertedPlaceable(found);
                            Placeables.clearCurrentPlaceables();
                        }
                        if (ckey == null) {
                            String t;
                            if (AppPreferences.replaceAtTransfer) {
                                String rep = WorkflowView.replaceCharacters(found);
                                if (!rep.equals(found)) {
                                    ckey = rep;
                                }
                            } else if (AppPreferences.formatnumbers && (t = NumbersHelper.formatLocaleNumber(found)) != null) {
                                ckey = t;
                            }
                        }
                    }
                    if ((m22 = ppattern.matcher(target)).find()) {
                        foundInTarget = true;
                    } else if (ckey != null && target.indexOf(ckey) != -1) {
                        foundInTarget = true;
                    }
                    if (!foundInSource || foundInTarget) continue;
                    Issue issue = new Issue(16);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MISSING NON-TRANSLATABLE FRAGMENT"));
                    issue.setQuery(m1, true);
                    tu.addIssue(issue);
                    if (this.tunitsSetFilter != null) {
                        this.tunitsSetFilter.add(tu);
                        continue;
                    }
                    this.tunitsFilter.add(tu);
                    continue;
                }
                String place2 = place.substring(1);
                ppattern = Pattern.compile(place2);
                m1 = ppattern.matcher(source);
                String ckey = null;
                if (m1.find()) {
                    String found = m1.group();
                    foundInSource = true;
                    String cp = Placeables.getPlaceablesForConversion(place);
                    if (cp != null) {
                        Placeables.addPlaceableToConversionMap(found, m1);
                        ckey = Placeables.getConvertedPlaceable(found);
                        Placeables.clearCurrentPlaceables();
                    }
                    if (ckey == null) {
                        String t;
                        if (AppPreferences.replaceAtTransfer) {
                            String rep = WorkflowView.replaceCharacters(found);
                            if (!rep.equals(found)) {
                                ckey = rep;
                            }
                        } else if (AppPreferences.formatnumbers && (t = NumbersHelper.formatLocaleNumber(found)) != null) {
                            ckey = t;
                        }
                    }
                }
                if ((m2 = ppattern.matcher(target)).find()) {
                    foundInTarget = true;
                } else if (ckey != null && target.indexOf(ckey) != -1) {
                    foundInTarget = true;
                }
                if (!foundInSource || foundInTarget) continue;
                Issue issue = new Issue(16);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MISSING NON-TRANSLATABLE FRAGMENT"));
                issue.setQuery(m1, true);
                tu.addIssue(issue);
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
        set.add("|" + Placeables.whiteSpaces);
    }

    private void tagsContentCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Pattern patt3 = Pattern.compile("(<[^>]*>)");
        for (Object o : tunits) {
            String target;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0) continue;
            Issue issue = null;
            XMLElement sourceE = tu.getSource();
            XMLElement targetE = tu.getTarget();
            if (sourceE != null && targetE != null) {
                String[] sarr = this.getXliffTagString(sourceE.getChildren(), true, 0, xliff.getVersion());
                String[] tarr = this.getXliffTagString(targetE.getChildren(), true, 0, xliff.getVersion());
                String sourceTags = sarr[0];
                String targetTags = tarr[0];
                Matcher smaTags = patt3.matcher(sourceTags);
                Matcher tmaTags = patt3.matcher(targetTags);
                boolean fault = false;
                int startText1 = 0;
                int startText2 = 0;
                while (smaTags.find()) {
                    int endText1 = smaTags.start();
                    String content1 = sourceTags.substring(startText1, endText1).trim();
                    startText1 = smaTags.end();
                    if (!tmaTags.find()) continue;
                    int endText2 = tmaTags.start();
                    String content2 = targetTags.substring(startText2, endText2).trim();
                    startText2 = tmaTags.end();
                    if (content1.length() == 0 && content2.length() > 0) {
                        fault = true;
                        break;
                    }
                    if (content2.length() != 0 || content1.length() <= 0) continue;
                    fault = true;
                    break;
                }
                String content1 = sourceTags.substring(startText1).trim();
                String content2 = targetTags.substring(startText2).trim();
                if (content1.length() == 0 && content2.length() > 0) {
                    fault = true;
                } else if (content2.length() == 0 && content1.length() > 0) {
                    fault = true;
                }
                if (fault) {
                    if (issue == null) {
                        issue = new Issue(3);
                        tu.addIssue(issue);
                    }
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT CONTENTS BETWEEN TAGS"));
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                if (this.tunitsSetFilter.contains(tu)) continue;
                this.tunitsSetFilter.add(tu);
                continue;
            }
            if (this.tunitsFilter.contains(tu)) continue;
            this.tunitsFilter.add(tu);
        }
    }

    private void tagsCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        block0: for (Object o : tunits) {
            String targett;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (targett = tu.getTargetText()) == null || targett.length() == 0) continue;
            XMLElement source = tu.getSource();
            XMLElement target = tu.getTarget();
            if (source == null || target == null) continue;
            ArrayList stags = new ArrayList();
            ArrayList ttags = new ArrayList();
            List slist = source.getChildren();
            List tlist = target.getChildren();
            this.collectTags(slist, stags);
            this.collectTags(tlist, ttags);
            if (stags.size() == ttags.size()) {
                Iterator itt = ttags.iterator();
                Iterator iss = stags.iterator();
                while (iss.hasNext()) {
                    String tname;
                    String sname = iss.next().toString();
                    if (sname.equals(tname = itt.next().toString())) continue;
                    Issue issue = new Issue(2);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TAGS"));
                    tu.addIssue(issue);
                    if (this.tunitsSetFilter != null) {
                        this.tunitsSetFilter.add(tu);
                        continue block0;
                    }
                    this.tunitsFilter.add(tu);
                    continue block0;
                }
                continue;
            }
            Issue issue = new Issue(2);
            issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TAGS"));
            tu.addIssue(issue);
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void tagsCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        block0: for (Object o : tunits) {
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            XMLElement source = tu.getSource();
            XMLElement target = tu.getTarget();
            String targett = tu.getTargetText();
            if (targett == null || targett.length() == 0 || source == null || target == null) continue;
            ArrayList stags = new ArrayList();
            ArrayList ttags = new ArrayList();
            List slist = source.getChildren();
            List tlist = target.getChildren();
            this.collectTags(slist, stags);
            this.collectTags(tlist, ttags);
            if (stags.size() == ttags.size()) {
                Iterator itt = ttags.iterator();
                Iterator iss = stags.iterator();
                while (iss.hasNext()) {
                    String tname;
                    String sname = iss.next().toString();
                    if (sname.equals(tname = itt.next().toString())) continue;
                    Issue issue = new Issue(2);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TAGS"));
                    tu.addIssue(issue);
                    if (this.tunitsSetFilter != null) {
                        this.tunitsSetFilter.add(tu);
                        continue block0;
                    }
                    this.tunitsFilter.add(tu);
                    continue block0;
                }
                continue;
            }
            Issue issue = new Issue(2);
            issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TAGS"));
            tu.addIssue(issue);
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void tagsCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        block0: for (Object o : tunits) {
            ArrayList<Issue> issues;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvs = tu.getTUV(slang);
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            if (tuvt == null || tuvs == null) continue;
            XMLElement source = tuvs.getSegment();
            XMLElement target = tuvt.getSegment();
            String targett = tuvt.getSegmentText();
            if (targett == null || targett.length() == 0 || source == null || target == null) continue;
            ArrayList stags = new ArrayList();
            ArrayList ttags = new ArrayList();
            List slist = source.getChildren();
            List tlist = target.getChildren();
            this.collectTags(slist, stags);
            this.collectTags(tlist, ttags);
            if (stags.size() == ttags.size()) {
                Iterator itt = ttags.iterator();
                Iterator iss = stags.iterator();
                while (iss.hasNext()) {
                    ArrayList<Issue> issues2;
                    String tname;
                    String sname = iss.next().toString();
                    if (sname.equals(tname = itt.next().toString())) continue;
                    Issue issue = new Issue(2);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TAGS"));
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues2 = (ArrayList<Issue>)object;
                        issues2.add(issue);
                    } else {
                        issues2 = new ArrayList<Issue>(2);
                        issues2.add(issue);
                        issuesTMX.put(tu, issues2);
                    }
                    if (this.tunitsSetFilter != null) {
                        this.tunitsSetFilter.add(tu);
                        continue block0;
                    }
                    this.tunitsFilter.add(tu);
                    continue block0;
                }
                continue;
            }
            Issue issue = new Issue(2);
            issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TAGS"));
            Object object = issuesTMX.get(tu);
            if (object != null) {
                issues = (ArrayList<Issue>)object;
                issues.add(issue);
            } else {
                issues = new ArrayList<Issue>(2);
                issues.add(issue);
                issuesTMX.put(tu, issues);
            }
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceLeadingCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Pattern patt1 = Pattern.compile("(\\A\\s+)");
        for (Object o : tunits) {
            int ind;
            String group;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            String sleadSpace = "";
            String tleadSpace = "";
            Matcher sma = patt1.matcher(source);
            Matcher tma = patt1.matcher(target);
            while (sma.find()) {
                group = sma.group();
                ind = sma.start();
                sleadSpace = group;
            }
            while (tma.find()) {
                group = tma.group();
                ind = tma.start();
                tleadSpace = group;
            }
            Issue issue = null;
            if (!sleadSpace.equals(tleadSpace)) {
                issue = new Issue(3);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT LEADING SPACE"));
                tu.addIssue(issue);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceLeadingCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        Pattern patt1 = Pattern.compile("(\\A\\s+)");
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            int ind;
            String group;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String target = tuvt.getSegmentText();
            String source = tuvs.getSegmentText();
            if (target == null || target.length() == 0) continue;
            String sleadSpace = "";
            String tleadSpace = "";
            Matcher sma = patt1.matcher(source);
            Matcher tma = patt1.matcher(target);
            while (sma.find()) {
                group = sma.group();
                ind = sma.start();
                sleadSpace = group;
            }
            while (tma.find()) {
                group = tma.group();
                ind = tma.start();
                tleadSpace = group;
            }
            Issue issue = null;
            if (!sleadSpace.equals(tleadSpace)) {
                ArrayList<Issue> issues;
                issue = new Issue(3);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT LEADING SPACE"));
                Object object = issuesTMX.get(tu);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceLeadingCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        Pattern patt1 = Pattern.compile("(\\A\\s+)");
        for (Object o : tunits) {
            int ind;
            String group;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String sleadSpace = "";
            String tleadSpace = "";
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            Matcher sma = patt1.matcher(source);
            Matcher tma = patt1.matcher(target);
            while (sma.find()) {
                group = sma.group();
                ind = sma.start();
                sleadSpace = group;
            }
            while (tma.find()) {
                group = tma.group();
                ind = tma.start();
                tleadSpace = group;
            }
            Issue issue = null;
            if (!sleadSpace.equals(tleadSpace)) {
                issue = new Issue(3);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT LEADING SPACE"));
                tu.addIssue(issue);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceTrailingCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Pattern patt1 = Pattern.compile("(\\s+\\z)");
        for (Object o : tunits) {
            int ind;
            String group;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            String strailSpace = "";
            String ttrailSpace = "";
            Matcher sma = patt1.matcher(source);
            Matcher tma = patt1.matcher(target);
            while (sma.find()) {
                group = sma.group();
                ind = sma.start();
                strailSpace = group;
            }
            while (tma.find()) {
                group = tma.group();
                ind = tma.start();
                ttrailSpace = group;
            }
            Issue issue = null;
            if (!strailSpace.equals(ttrailSpace)) {
                if (issue == null) {
                    issue = new Issue(3);
                    tu.addIssue(issue);
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TRAILING SPACE"));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceTrailingCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        Pattern patt1 = Pattern.compile("(\\s+\\z)");
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            int ind;
            String group;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String target = tuvt.getSegmentText();
            String source = tuvs.getSegmentText();
            if (target == null || target.length() == 0) continue;
            String strailSpace = "";
            String ttrailSpace = "";
            Matcher sma = patt1.matcher(source);
            Matcher tma = patt1.matcher(target);
            while (sma.find()) {
                group = sma.group();
                ind = sma.start();
                strailSpace = group;
            }
            while (tma.find()) {
                group = tma.group();
                ind = tma.start();
                ttrailSpace = group;
            }
            Issue issue = null;
            if (!strailSpace.equals(ttrailSpace)) {
                if (issue == null) {
                    ArrayList<Issue> issues;
                    issue = new Issue(3);
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TRAILING SPACE"));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceTrailingCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        Pattern patt1 = Pattern.compile("(\\s+\\z)");
        for (Object o : tunits) {
            int ind;
            String group;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String strailSpace = "";
            String ttrailSpace = "";
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            Matcher sma = patt1.matcher(source);
            Matcher tma = patt1.matcher(target);
            while (sma.find()) {
                group = sma.group();
                ind = sma.start();
                strailSpace = group;
            }
            while (tma.find()) {
                group = tma.group();
                ind = tma.start();
                ttrailSpace = group;
            }
            Issue issue = null;
            if (!strailSpace.equals(ttrailSpace)) {
                if (issue == null) {
                    issue = new Issue(3);
                    tu.addIssue(issue);
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TRAILING SPACE"));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void quotesCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Pattern patt1 = Pattern.compile("[\"\u2018\u2019\u201a?\u201c\u201d\u201e?\u00ab\u00bb\u2039\u203a]");
        for (Object o : tunits) {
            String target;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0) continue;
            Matcher tma1 = patt1.matcher(target);
            int i = 0;
            while (tma1.find()) {
                ++i;
            }
            Issue issue = null;
            if (i > 0 && i % 2 != 0) {
                boolean okay = true;
                String source = tu.getSourceText();
                tma1 = patt1.matcher(source);
                int k = 0;
                while (tma1.find()) {
                    ++k;
                }
                if (k != i) {
                    okay = false;
                }
                if (!okay) {
                    issue = new Issue(11);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MISSING QUOTATION MARK"));
                    tu.addIssue(issue);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void bracketsCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Pattern patt1 = Pattern.compile("[\\]\\)\\}]");
        Pattern patt2 = Pattern.compile("[\\[\\(\\{]");
        for (Object o : tunits) {
            String target;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0) continue;
            Matcher tma1 = patt1.matcher(target);
            Matcher tma2 = patt2.matcher(target);
            int i = 0;
            while (tma1.find()) {
                ++i;
            }
            int j = 0;
            while (tma2.find()) {
                ++j;
            }
            Issue issue = null;
            if (j != i) {
                boolean okay = false;
                String source = tu.getSourceText();
                tma1 = patt1.matcher(source);
                int k = 0;
                while (tma1.find()) {
                    ++k;
                }
                if (k == i) {
                    tma2 = patt2.matcher(source);
                    int m = 0;
                    while (tma2.find()) {
                        ++m;
                    }
                    if (m == j) {
                        okay = true;
                    }
                }
                if (!okay) {
                    issue = new Issue(11);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MISSING BRACKET"));
                    tu.addIssue(issue);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void bracketsCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        Pattern patt1 = Pattern.compile("[\\]\\)\\}]");
        Pattern patt2 = Pattern.compile("[\\[\\(\\{]");
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            String target;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null || (target = tuvt.getSegmentText()) == null || target.length() == 0) continue;
            Matcher tma1 = patt1.matcher(target);
            Matcher tma2 = patt2.matcher(target);
            int i = 0;
            while (tma1.find()) {
                ++i;
            }
            int j = 0;
            while (tma2.find()) {
                ++j;
            }
            Issue issue = null;
            if (j != i) {
                boolean okay = false;
                String source = tuvs.getSegmentText();
                tma1 = patt1.matcher(source);
                int k = 0;
                while (tma1.find()) {
                    ++k;
                }
                if (k == i) {
                    tma2 = patt2.matcher(source);
                    int m = 0;
                    while (tma2.find()) {
                        ++m;
                    }
                    if (m == j) {
                        okay = true;
                    }
                }
                if (!okay) {
                    ArrayList<Issue> issues;
                    issue = new Issue(11);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MISSING BRACKET"));
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceDoubleCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Pattern patt2 = Pattern.compile("[ \u3000\u00a0\t]{2,}");
        for (Object o : tunits) {
            String target;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0) continue;
            Issue issue = null;
            Matcher tma = patt2.matcher(target);
            if (tma.find()) {
                if (issue == null) {
                    issue = new Issue(3);
                    tu.addIssue(issue);
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE SPACE"));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceDoubleCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        Pattern patt2 = Pattern.compile("[ \u3000\u00a0\t]{2,}");
        TranslationUnitMap map = tmx.getTUMap();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            String target;
            TMXUnit tu;
            TMXUnitVariant tuvt;
            if (o == null || !(o instanceof TMXUnit) || (tuvt = (tu = (TMXUnit)o).getTUV(tlang)) == null || (target = tuvt.getSegmentText()) == null || target.length() == 0) continue;
            Issue issue = null;
            Matcher tma = patt2.matcher(target);
            if (tma.find()) {
                if (issue == null) {
                    ArrayList<Issue> issues;
                    issue = new Issue(3);
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE SPACE"));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceAtTagsCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Pattern patt3 = Pattern.compile("\\s*(<[^>]*>)+\\s*");
        for (Object o : tunits) {
            String target;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0) continue;
            Issue issue = null;
            XMLElement sourceE = tu.getSource();
            XMLElement targetE = tu.getTarget();
            if (sourceE != null && targetE != null) {
                String[] sarr = this.getXliffTagString(sourceE.getChildren(), true, 0, xliff.getVersion());
                String[] tarr = this.getXliffTagString(targetE.getChildren(), true, 0, xliff.getVersion());
                String sourceTags = sarr[0];
                String targetTags = tarr[0];
                Matcher smaTags = patt3.matcher(sourceTags);
                Matcher tmaTags = patt3.matcher(targetTags);
                boolean fault = false;
                while (smaTags.find()) {
                    String group = smaTags.group();
                    if (!tmaTags.find()) continue;
                    String group2 = tmaTags.group();
                    char first1 = group.charAt(0);
                    char first2 = group2.charAt(0);
                    if (Character.isWhitespace(first1) && !Character.isWhitespace(first2)) {
                        fault = true;
                        break;
                    }
                    if (Character.isWhitespace(first2) && !Character.isWhitespace(first1)) {
                        fault = true;
                        break;
                    }
                    char last1 = group.charAt(group.length() - 1);
                    char last2 = group2.charAt(group2.length() - 1);
                    if (Character.isWhitespace(last1) && !Character.isWhitespace(last2)) {
                        fault = true;
                        break;
                    }
                    if (!Character.isWhitespace(last2) || Character.isWhitespace(last1)) continue;
                    fault = true;
                    break;
                }
                if (fault) {
                    if (issue == null) {
                        issue = new Issue(3);
                        tu.addIssue(issue);
                    }
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT SPACE AT TAG"));
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceAtTagsCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        Pattern patt3 = Pattern.compile("\\s*(<[^>]*>)+\\s*");
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvs = tu.getTUV(slang);
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            if (tuvt == null || tuvs == null) continue;
            XMLElement sourceE = tuvs.getSegment();
            XMLElement targetE = tuvt.getSegment();
            String targett = tuvt.getSegmentText();
            if (targett == null || targett.length() == 0) continue;
            Issue issue = null;
            if (sourceE != null && targetE != null) {
                String[] sarr = this.getXliffTagString(sourceE.getChildren(), true, 0, 1);
                String[] tarr = this.getXliffTagString(targetE.getChildren(), true, 0, 1);
                String sourceTags = sarr[0];
                String targetTags = tarr[0];
                Matcher smaTags = patt3.matcher(sourceTags);
                Matcher tmaTags = patt3.matcher(targetTags);
                boolean fault = false;
                while (smaTags.find()) {
                    String group = smaTags.group();
                    if (!tmaTags.find()) continue;
                    String group2 = tmaTags.group();
                    char first1 = group.charAt(0);
                    char first2 = group2.charAt(0);
                    if (Character.isWhitespace(first1) && !Character.isWhitespace(first2)) {
                        fault = true;
                        break;
                    }
                    if (Character.isWhitespace(first2) && !Character.isWhitespace(first1)) {
                        fault = true;
                        break;
                    }
                    char last1 = group.charAt(group.length() - 1);
                    char last2 = group2.charAt(group2.length() - 1);
                    if (Character.isWhitespace(last1) && !Character.isWhitespace(last2)) {
                        fault = true;
                        break;
                    }
                    if (!Character.isWhitespace(last2) || Character.isWhitespace(last1)) continue;
                    fault = true;
                    break;
                }
                if (fault) {
                    ArrayList<Issue> issues;
                    Object object;
                    if (issue == null) {
                        issue = new Issue(3);
                    }
                    if ((object = issuesTMX.get(tu)) != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT SPACE AT TAG"));
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void bracketsCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        Pattern patt1 = Pattern.compile("[\\]\\)\\}]");
        Pattern patt2 = Pattern.compile("[\\[\\(\\{]");
        for (Object o : tunits) {
            String target;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0) continue;
            Matcher tma1 = patt1.matcher(target);
            Matcher tma2 = patt2.matcher(target);
            int i = 0;
            while (tma1.find()) {
                ++i;
            }
            int j = 0;
            while (tma2.find()) {
                ++j;
            }
            Issue issue = null;
            if (j != i) {
                issue = new Issue(11);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MISSING BRACKETS"));
                tu.addIssue(issue);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceDoubleCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        Pattern patt2 = Pattern.compile("[ \u3000\u00a0\t]{2,}");
        for (Object o : tunits) {
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            Issue issue = null;
            Matcher tma = patt2.matcher(target);
            if (tma.find()) {
                if (issue == null) {
                    issue = new Issue(3);
                    tu.addIssue(issue);
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE SPACE"));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spaceAtTagsCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        Pattern patt3 = Pattern.compile("\\s*(<[^>]*>)+\\s*");
        for (Object o : tunits) {
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            Issue issue = null;
            XMLElement sourceE = tu.getSource();
            XMLElement targetE = tu.getTarget();
            if (sourceE != null && targetE != null) {
                String[] sarr = this.getTTXTagString(sourceE.getChildren(), true, 0);
                String[] tarr = this.getTTXTagString(targetE.getChildren(), true, 0);
                String sourceTags = sarr[0];
                String targetTags = tarr[0];
                Matcher smaTags = patt3.matcher(sourceTags);
                Matcher tmaTags = patt3.matcher(targetTags);
                boolean fault = false;
                while (smaTags.find()) {
                    String group = smaTags.group();
                    if (!tmaTags.find()) continue;
                    String group2 = tmaTags.group();
                    char first1 = group.charAt(0);
                    char first2 = group2.charAt(0);
                    if (Character.isWhitespace(first1) && !Character.isWhitespace(first2)) {
                        fault = true;
                        break;
                    }
                    if (Character.isWhitespace(first2) && !Character.isWhitespace(first1)) {
                        fault = true;
                        break;
                    }
                    char last1 = group.charAt(group.length() - 1);
                    char last2 = group2.charAt(group2.length() - 1);
                    if (Character.isWhitespace(last1) && !Character.isWhitespace(last2)) {
                        fault = true;
                        break;
                    }
                    if (!Character.isWhitespace(last2) || Character.isWhitespace(last1)) continue;
                    fault = true;
                    break;
                }
                if (fault) {
                    if (issue == null) {
                        issue = new Issue(3);
                        tu.addIssue(issue);
                    }
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT SPACE AT TAG"));
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spellCheckXliff(XLIFF xliff, Spellcheckable sp) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            String target;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0) continue;
            List spacePositions = tu.getSpaceInsertPositions();
            if (!AppPreferences.noWordSeparatorTargetLanguage && spacePositions != null && !spacePositions.isEmpty()) {
                int off = 0;
                char space = ' ';
                StringBuilder builder = new StringBuilder(target);
                for (int i = 0; i < spacePositions.size(); ++i) {
                    int spos = (Integer)spacePositions.get(i);
                    builder.insert(spos + off, space);
                    ++off;
                }
                target = builder.toString();
            }
            Issue issue = null;
            if (sp.globalCheckSpell(target)) {
                issue = new Issue(9);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPELLING MISTAKE"));
                tu.addIssue(issue);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spellCheckTMX(TMX tmx, Spellcheckable sp) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            String target;
            TMXUnit tu;
            TMXUnitVariant tuvt;
            if (o == null || !(o instanceof TMXUnit) || (tuvt = (tu = (TMXUnit)o).getTUV(tlang)) == null || (target = tuvt.getSegmentText()) == null || target.length() == 0) continue;
            Issue issue = null;
            if (sp.globalCheckSpell(target)) {
                ArrayList<Issue> issues;
                issue = new Issue(9);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPELLING MISTAKE"));
                Object object = issuesTMX.get(tu);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void spellCheckTTX(TTX ttx, Spellcheckable sp) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            Issue issue = null;
            if (sp.globalCheckSpell(target)) {
                issue = new Issue(9);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPELLING MISTAKE"));
                tu.addIssue(issue);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void digitsCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            String group;
            XLIFFUnit tu;
            int state;
            if (o == null || !(o instanceof XLIFFUnit) || (state = (tu = (XLIFFUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments || tu.locked || !tu.translate) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            if (AppPreferences.noWordSeparatorSourceLanguage) {
                source = QAView.fullwidth2halfwidth(source);
            }
            if (AppPreferences.noWordSeparatorTargetLanguage) {
                target = QAView.fullwidth2halfwidth(target);
            }
            ArrayList<String> sdigits = new ArrayList<String>(4);
            ArrayList<String> tdigits = new ArrayList<String>(4);
            Pattern patt = Pattern.compile("\\d+");
            Matcher sma = patt.matcher(source);
            Matcher tma = patt.matcher(target);
            while (sma.find()) {
                group = sma.group();
                sdigits.add(group);
            }
            while (tma.find()) {
                group = tma.group();
                tdigits.add(group);
            }
            Issue issue = null;
            if (sdigits.size() != tdigits.size()) {
                issue = new Issue(4);
                tu.addIssue(issue);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT NUMBER"));
            }
            Iterator it1 = sdigits.iterator();
            while (it1.hasNext()) {
                String s = it1.next().toString();
                if (tdigits.contains(s)) {
                    tdigits.remove(s);
                    continue;
                }
                if (issue == null) {
                    issue = new Issue(4);
                    tu.addIssue(issue);
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT NUMBER") + ": " + s);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void digitsCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            String group;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            if (AppPreferences.noWordSeparatorSourceLanguage) {
                source = QAView.fullwidth2halfwidth(source);
            }
            if (AppPreferences.noWordSeparatorTargetLanguage) {
                target = QAView.fullwidth2halfwidth(target);
            }
            ArrayList<String> sdigits = new ArrayList<String>(4);
            ArrayList<String> tdigits = new ArrayList<String>(4);
            Pattern patt = Pattern.compile("\\d+");
            Matcher sma = patt.matcher(source);
            Matcher tma = patt.matcher(target);
            while (sma.find()) {
                group = sma.group();
                sdigits.add(group);
            }
            while (tma.find()) {
                group = tma.group();
                tdigits.add(group);
            }
            Issue issue = null;
            if (sdigits.size() != tdigits.size()) {
                issue = new Issue(4);
                tu.addIssue(issue);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT NUMBER"));
            }
            Iterator it1 = sdigits.iterator();
            while (it1.hasNext()) {
                String s = it1.next().toString();
                if (tdigits.contains(s)) {
                    tdigits.remove(s);
                    continue;
                }
                if (issue == null) {
                    issue = new Issue(4);
                    tu.addIssue(issue);
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT NUMBER") + ": " + s);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void digitsCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            String group;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String target = tuvt.getSegmentText();
            String source = tuvs.getSegmentText();
            if (target == null || target.length() == 0) continue;
            if (AppPreferences.noWordSeparatorSourceLanguage) {
                source = QAView.fullwidth2halfwidth(source);
            }
            if (AppPreferences.noWordSeparatorTargetLanguage) {
                target = QAView.fullwidth2halfwidth(target);
            }
            ArrayList<String> sdigits = new ArrayList<String>(4);
            ArrayList<String> tdigits = new ArrayList<String>(4);
            Pattern patt = Pattern.compile("\\d+");
            Matcher sma = patt.matcher(source);
            Matcher tma = patt.matcher(target);
            while (sma.find()) {
                group = sma.group();
                sdigits.add(group);
            }
            while (tma.find()) {
                group = tma.group();
                tdigits.add(group);
            }
            Issue issue = null;
            if (sdigits.size() != tdigits.size()) {
                ArrayList<Issue> issues;
                issue = new Issue(4);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT NUMBER"));
                Object object = issuesTMX.get(tu);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
            }
            Iterator it1 = sdigits.iterator();
            while (it1.hasNext()) {
                String s = it1.next().toString();
                if (tdigits.contains(s)) {
                    tdigits.remove(s);
                    continue;
                }
                if (issue == null) {
                    ArrayList<Issue> issues;
                    issue = new Issue(4);
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT NUMBER") + ": " + s);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void checkTMX(TMX tmx) {
        Collection tunits = tmx.getTranslationUnits();
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            Object issue;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String target = tuvt.getSegmentText();
            String source = tuvs.getSegmentText();
            if (target == null || target.length() == 0 || (issue = null) == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void sameSourceDifferentTargetXLIFF(XLIFF xliff) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String s = tu.getSourceText().trim();
            String t = tu.getTargetText().trim();
            if (s.length() <= 0 || t.length() <= 0) continue;
            s = s.replaceAll(AppPreferences.punctuation, "");
            s = XMLHelper.normalizeSpace(s);
            Object ob = map.get(s = s.replaceAll("\\s+", " "));
            if (ob != null) {
                Stack<XLIFFUnit> deck = null;
                if (ob instanceof XLIFFUnit) {
                    XLIFFUnit tuu = (XLIFFUnit)ob;
                    if (!tu.equals(tuu)) {
                        deck = new Stack<XLIFFUnit>();
                        deck.addElement(tuu);
                        map.put(s, deck);
                    }
                } else {
                    deck = (Stack<XLIFFUnit>)ob;
                }
                if (deck == null) continue;
                deck.remove(tu);
                deck.add(0, tu);
                continue;
            }
            map.put(s, tu);
        }
        Collection values = map.values();
        for (Object object : values) {
            XLIFFUnit tu;
            if (!(object instanceof Stack)) continue;
            HashSet<String> set = new HashSet<String>();
            Stack deck = (Stack)object;
            boolean different = false;
            for (Object o : deck) {
                tu = (XLIFFUnit)o;
                String t = tu.getTargetText().trim();
                t = t.replaceAll(AppPreferences.punctuation, "");
                t = XMLHelper.normalizeSpace(t);
                t = t.replaceAll("\\s+", " ");
                boolean b = set.add(t);
                if (set.size() <= 1) continue;
                different = true;
                break;
            }
            if (!different) continue;
            for (Object o : deck) {
                tu = (XLIFFUnit)o;
                Issue issue = new Issue(14);
                tu.addIssue(issue);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAME SOURCE WITH DIFFERENT TARGET"));
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
    }

    private void sameSourceDifferentTargetTMX(TMX tmx) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap tumap = tmx.getTUMap();
        String slang = tumap.getSourceLang();
        String tlang = tumap.getTargetLang();
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String t = tuvt.getSegmentText();
            String s = tuvs.getSegmentText();
            if (s.length() <= 0 || t.length() <= 0) continue;
            s = s.replaceAll(AppPreferences.punctuation, "");
            s = XMLHelper.normalizeSpace(s);
            Object ob = map.get(s = s.replaceAll("\\s+", " "));
            if (ob != null) {
                Stack<TMXUnit> deck = null;
                if (ob instanceof TMXUnit) {
                    TMXUnit tuu = (TMXUnit)ob;
                    if (!tu.equals(tuu)) {
                        deck = new Stack<TMXUnit>();
                        deck.addElement(tuu);
                        map.put(s, deck);
                    }
                } else {
                    deck = (Stack<TMXUnit>)ob;
                }
                if (deck == null) continue;
                deck.remove(tu);
                deck.add(0, tu);
                continue;
            }
            map.put(s, tu);
        }
        Collection values = map.values();
        for (Object object : values) {
            TMXUnit tu;
            if (!(object instanceof Stack)) continue;
            HashSet<String> set = new HashSet<String>();
            Stack deck = (Stack)object;
            boolean different = false;
            for (Object o : deck) {
                tu = (TMXUnit)o;
                TMXUnitVariant tuvt = tu.getTUV(tlang);
                if (tuvt == null) continue;
                String t = tuvt.getSegmentText();
                t = t.replaceAll(AppPreferences.punctuation, "");
                t = XMLHelper.normalizeSpace(t);
                t = t.replaceAll("\\s+", " ");
                boolean b = set.add(t);
                if (set.size() <= 1) continue;
                different = true;
                break;
            }
            if (!different) continue;
            for (Object o : deck) {
                ArrayList<Issue> issues;
                tu = (TMXUnit)o;
                Issue issue = new Issue(14);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAME SOURCE WITH DIFFERENT TARGET"));
                Object iobject = issuesTMX.get(tu);
                if (iobject != null) {
                    issues = (ArrayList<Issue>)iobject;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
    }

    private void sameTargetDifferentSourceXLIFF(XLIFF xliff) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            String target;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText().trim()).length() <= 0) continue;
            target = target.replaceAll(AppPreferences.punctuation, "");
            target = XMLHelper.normalizeSpace(target);
            Object ob = map.get(target = target.replaceAll("\\s+", " "));
            if (ob != null) {
                Stack<XLIFFUnit> deck = null;
                if (ob instanceof XLIFFUnit) {
                    XLIFFUnit tuu = (XLIFFUnit)ob;
                    if (!tu.equals(tuu)) {
                        deck = new Stack<XLIFFUnit>();
                        deck.addElement(tuu);
                        map.put(target, deck);
                    }
                } else {
                    deck = (Stack<XLIFFUnit>)ob;
                }
                if (deck == null) continue;
                deck.remove(tu);
                deck.add(0, tu);
                continue;
            }
            map.put(target, tu);
        }
        Collection values = map.values();
        for (Object object : values) {
            XLIFFUnit tu;
            if (!(object instanceof Stack)) continue;
            HashSet<String> set = new HashSet<String>();
            Stack deck = (Stack)object;
            boolean different = false;
            for (Object o2 : deck) {
                tu = (XLIFFUnit)o2;
                String source = tu.getSourceText().trim();
                if (source.length() <= 0) continue;
                source = source.replaceAll(AppPreferences.punctuation, "");
                source = XMLHelper.normalizeSpace(source);
                source = source.replaceAll("\\s+", " ");
                boolean b = set.add(source);
                if (set.size() <= 1) continue;
                different = true;
                break;
            }
            if (!different) continue;
            for (Object o2 : deck) {
                tu = (XLIFFUnit)o2;
                Issue issue = new Issue(15);
                tu.addIssue(issue);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAME TARGET WITH DIFFERENT SOURCE"));
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
    }

    private void sameTargetDifferentSourceTMX(TMX tmx) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap tumap = tmx.getTUMap();
        String slang = tumap.getSourceLang();
        String tlang = tumap.getTargetLang();
        for (Object o : tunits) {
            String t;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null || (t = tuvt.getSegmentText()).length() <= 0) continue;
            t = t.replaceAll(AppPreferences.punctuation, "");
            t = XMLHelper.normalizeSpace(t);
            Object ob = map.get(t = t.replaceAll("\\s+", " "));
            if (ob != null) {
                Stack<TMXUnit> deck = null;
                if (ob instanceof TMXUnit) {
                    TMXUnit tuu = (TMXUnit)ob;
                    if (!tu.equals(tuu)) {
                        deck = new Stack<TMXUnit>();
                        deck.addElement(tuu);
                        map.put(t, deck);
                    }
                } else {
                    deck = (Stack<TMXUnit>)ob;
                }
                if (deck == null) continue;
                deck.remove(tu);
                deck.add(0, tu);
                continue;
            }
            map.put(t, tu);
        }
        Collection values = map.values();
        for (Object object : values) {
            TMXUnit tu;
            if (!(object instanceof Stack)) continue;
            HashSet<String> set = new HashSet<String>();
            Stack deck = (Stack)object;
            boolean different = false;
            for (Object o : deck) {
                tu = (TMXUnit)o;
                TMXUnitVariant tuvs = tu.getTUV(slang);
                if (tuvs == null) continue;
                String s = tuvs.getSegmentText();
                s = s.replaceAll(AppPreferences.punctuation, "");
                s = XMLHelper.normalizeSpace(s);
                s = s.replaceAll("\\s+", " ");
                boolean b = set.add(s);
                if (set.size() <= 1) continue;
                different = true;
                break;
            }
            if (!different) continue;
            for (Object o : deck) {
                ArrayList<Issue> issues;
                tu = (TMXUnit)o;
                Issue issue = new Issue(15);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAME TARGET WITH DIFFERENT SOURCE"));
                Object iobject = issuesTMX.get(tu);
                if (iobject != null) {
                    issues = (ArrayList<Issue>)iobject;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
    }

    private void sameSegmentsCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null) {
                String s = tu.getSourceText();
                String t = tu.getTargetText();
                if (t.equals(s)) {
                    issue = new Issue(6);
                    tu.addIssue(issue);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET SAME AS SOURCE"));
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void sameSegmentsCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null) {
                String s = tu.getSourceText();
                String t = tu.getTargetText();
                if (t.equals(s)) {
                    issue = new Issue(6);
                    tu.addIssue(issue);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET SAME AS SOURCE"));
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void sameSegmentsCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String t = tuvt.getSegmentText();
            String s = tuvs.getSegmentText();
            Issue issue = null;
            if (t != null && s != null && t.equals(s)) {
                ArrayList<Issue> issues;
                issue = new Issue(6);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET SAME AS SOURCE"));
                Object object = issuesTMX.get(tu);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void maxLengthCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            String t;
            int tl;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null && (tl = (t = tu.getTargetText()).length()) > AppPreferences.qaMaxLength) {
                issue = new Issue(19);
                tu.addIssue(issue);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENT LENGTH") + "=" + Integer.toString(tl));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void maxLengthCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            int tl;
            TMXUnit tu;
            TMXUnitVariant tuvt;
            if (o == null || !(o instanceof TMXUnit) || (tuvt = (tu = (TMXUnit)o).getTUV(tlang)) == null) continue;
            String t = tuvt.getSegmentText();
            Issue issue = null;
            if (t != null && (tl = t.length()) > AppPreferences.qaMaxLength) {
                ArrayList<Issue> issues;
                issue = new Issue(19);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENT LENGTH") + "=" + Integer.toString(tl));
                Object object = issuesTMX.get(tu);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void lengthDifferenceCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null) {
                String s = tu.getSourceText();
                String t = tu.getTargetText();
                double sl = s.length();
                double tl = t.length();
                double diff = 0.0;
                if (sl > tl) {
                    diff = (sl - tl) / sl * 100.0;
                } else if (tl > sl) {
                    diff = (tl - sl) / tl * 100.0;
                }
                int difference = (int)diff;
                if (diff > (double)AppPreferences.qaLengthDifference) {
                    issue = new Issue(17);
                    tu.addIssue(issue);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LENGTH DIFFERENCE") + "=" + Integer.toString(difference) + "%");
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void lengthDifferenceCheckXliffChars(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null) {
                String s = tu.getSourceText();
                String t = tu.getTargetText();
                double sl = s.length();
                double tl = t.length();
                double diff = 0.0;
                if (sl > tl) {
                    diff = sl - tl;
                } else if (tl > sl) {
                    diff = tl - sl;
                }
                int difference = (int)diff;
                if (diff > (double)AppPreferences.qaLengthDifferenceChars) {
                    issue = new Issue(18);
                    tu.addIssue(issue);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LENGTH DIFFERENCE") + "=" + Integer.toString(difference) + " chars");
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void lengthDifferenceCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String t = tuvt.getSegmentText();
            String s = tuvs.getSegmentText();
            Issue issue = null;
            if (t != null && s != null) {
                double sl = s.length();
                double tl = t.length();
                double diff = 0.0;
                if (sl > tl) {
                    diff = (sl - tl) / sl * 100.0;
                } else if (tl > sl) {
                    diff = (tl - sl) / tl * 100.0;
                }
                int difference = (int)diff;
                if (diff > (double)AppPreferences.qaLengthDifference) {
                    ArrayList<Issue> issues;
                    issue = new Issue(17);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LENGTH DIFFERENCE") + "=" + Integer.toString(difference) + "%");
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void lengthDifferenceCheckTMXChars(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String t = tuvt.getSegmentText();
            String s = tuvs.getSegmentText();
            Issue issue = null;
            if (t != null && s != null) {
                double sl = s.length();
                double tl = t.length();
                double diff = 0.0;
                if (sl > tl) {
                    diff = sl - tl;
                } else if (tl > sl) {
                    diff = tl - sl;
                }
                int difference = (int)diff;
                if (diff > (double)AppPreferences.qaLengthDifferenceChars) {
                    ArrayList<Issue> issues;
                    issue = new Issue(18);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LENGTH DIFFERENCE") + "=" + Integer.toString(difference) + " chars");
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void doubleWordsCheckXliff(XLIFF xliff) {
        Pattern p = Pattern.compile("\\b(\\w+)\\s+\\1\\b");
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            String t;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null && (t = tu.getTargetText().trim()).length() > 0) {
                t = t.replaceAll(AppPreferences.punctuation, "");
                String[] words = t.split(" ");
                String word = null;
                boolean doubleWord = false;
                for (int i = 0; i < words.length; ++i) {
                    String string = words[i].trim();
                    if (i > 0 && string.length() > 0 && string.equals(word)) {
                        doubleWord = true;
                        break;
                    }
                    word = string;
                }
                if (doubleWord) {
                    Matcher ma = p.matcher(t);
                    issue = new Issue(8);
                    issue.setQuery(ma, false);
                    tu.addIssue(issue);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE WORDS"));
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void doubleWordsCheckTTX(TTX ttx) {
        Pattern p = Pattern.compile("\\b(\\w+)\\s+\\1\\b");
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            String t;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null && (t = tu.getTargetText().trim()).length() > 0) {
                t = t.replaceAll(AppPreferences.punctuation, "");
                String[] words = t.split(" ");
                String word = null;
                boolean doubleWord = false;
                for (int i = 0; i < words.length; ++i) {
                    String string = words[i].trim();
                    if (i > 0 && string.length() > 0 && string.equals(word)) {
                        doubleWord = true;
                        break;
                    }
                    word = string;
                }
                if (doubleWord) {
                    Matcher ma = p.matcher(t);
                    issue = new Issue(8);
                    issue.setQuery(ma, false);
                    tu.addIssue(issue);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE WORDS"));
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void doubleWordsCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        Pattern p = Pattern.compile("\\b(\\w+)\\s+\\1\\b");
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            String target;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null || (target = tuvt.getSegmentText()) == null || target.length() == 0) continue;
            target = target.replaceAll(AppPreferences.punctuation, "");
            Issue issue = null;
            String[] words = target.split(" ");
            String word = null;
            boolean doubleWord = false;
            for (int i = 0; i < words.length; ++i) {
                String string = words[i].trim();
                if (i > 0 && string.length() > 0 && string.equals(word)) {
                    doubleWord = true;
                    break;
                }
                word = string;
            }
            if (doubleWord) {
                ArrayList<Issue> issues;
                Matcher ma = p.matcher(target);
                issue = new Issue(8);
                issue.setQuery(ma, false);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOUBLE WORDS"));
                Object object = issuesTMX.get(tu);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void capitalizationCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null) {
                String s = tu.getSourceText().trim();
                String t = tu.getTargetText().trim();
                if (s.length() > 0 && t.length() > 0) {
                    boolean falsePositive = false;
                    char sc = s.charAt(0);
                    char tc = t.charAt(0);
                    if (Character.isDigit(sc) && !Character.isDigit(tc)) {
                        falsePositive = true;
                    } else if (!Character.isDigit(sc) && Character.isDigit(tc)) {
                        falsePositive = true;
                    } else if (sc == '\u00a0' || tc == '\u00a0') {
                        falsePositive = true;
                    }
                    boolean sourceCase = Character.isUpperCase(sc);
                    boolean targetCase = Character.isUpperCase(tc);
                    if (sourceCase != targetCase && !falsePositive) {
                        issue = new Issue(7);
                        tu.addIssue(issue);
                        issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LETTER CASE DOES NOT MATCH"));
                    }
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void capitalizationCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            XMLElement target = tu.getTarget();
            if (target != null) {
                String s = tu.getSourceText().trim();
                String t = tu.getTargetText().trim();
                if (s.length() > 0 && t.length() > 0) {
                    boolean falsePositive = false;
                    char sc = s.charAt(0);
                    char tc = t.charAt(0);
                    if (Character.isDigit(sc) && !Character.isDigit(tc)) {
                        falsePositive = true;
                    } else if (!Character.isDigit(sc) && Character.isDigit(tc)) {
                        falsePositive = true;
                    }
                    boolean sourceCase = Character.isUpperCase(sc);
                    boolean targetCase = Character.isUpperCase(tc);
                    if (sourceCase != targetCase && !falsePositive) {
                        issue = new Issue(7);
                        tu.addIssue(issue);
                        issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LETTER CASE DOES NOT MATCH"));
                    }
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void capitalizationCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String target = tuvt.getSegmentText();
            String source = tuvs.getSegmentText();
            if (target == null) continue;
            Issue issue = null;
            if (source.trim().length() > 0 && target.trim().length() > 0) {
                boolean falsePositive = false;
                char sc = source.charAt(0);
                char tc = target.charAt(0);
                if (Character.isDigit(sc) && !Character.isDigit(tc)) {
                    falsePositive = true;
                } else if (!Character.isDigit(sc) && Character.isDigit(tc)) {
                    falsePositive = true;
                }
                boolean sourceCase = Character.isUpperCase(sc);
                boolean targetCase = Character.isUpperCase(tc);
                if (sourceCase != targetCase && !falsePositive) {
                    ArrayList<Issue> issues;
                    issue = new Issue(7);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LETTER CASE DOES NOT MATCH"));
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void emptySegmentsCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            String target = tu.getTargetText();
            if (target == null || target.trim().length() == 0) {
                issue = new Issue(5);
                tu.addIssue(issue);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EMPTY SEGMENT"));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void emptySegmentsCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            Issue issue = null;
            String target = tu.getTargetText();
            if (target == null || target.trim().length() == 0) {
                issue = new Issue(5);
                tu.addIssue(issue);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EMPTY SEGMENT"));
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void emptySegmentsCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            TMXUnit tu;
            TMXUnitVariant tuvt;
            if (o == null || !(o instanceof TMXUnit) || (tuvt = (tu = (TMXUnit)o).getTUV(tlang)) == null) continue;
            String target = tuvt.getSegmentText();
            Issue issue = null;
            if (target == null || target.trim().length() == 0) {
                ArrayList<Issue> issues;
                issue = new Issue(5);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EMPTY SEGMENT"));
                Object object = issuesTMX.get(tu);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void translationConsistencyCheckTMX(TMX tmx) {
        Collection tunits = tmx.getTranslationUnits();
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            if (o == null || !(o instanceof TranslationUnit)) continue;
            TranslationUnit tu = (TranslationUnit)o;
            HashMap<String, TranslationUnit> uniqueTUs = null;
            if (tu.hasLink()) {
                uniqueTUs = new HashMap<String, TranslationUnit>();
                String target = tu.getSegment(tlang);
                if (target != null) {
                    uniqueTUs.put(target, tu);
                }
            }
            while (tu.hasLink()) {
                TranslationUnit tu1 = tu.getLink();
                String target = tu1.getSegment(tlang);
                if (target != null) {
                    uniqueTUs.put(target, tu1);
                }
                tu = tu1;
            }
            if (uniqueTUs == null || uniqueTUs.size() <= 1) continue;
            Collection col = uniqueTUs.values();
            for (TranslationUnit next : col) {
                ArrayList<Issue> issues;
                Issue issue = new Issue(1);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TRANSLATION"));
                Object object = issuesTMX.get(next);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(next, issues);
                }
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(next);
                    continue;
                }
                this.tunitsFilter.add(next);
            }
        }
    }

    private void translationConsistencyCheckXliff(XLIFF xliff) {
        HashMap map = Project.getProjectMemory();
        Collection values = map.values();
        HashMap qaMap = new HashMap();
        for (Object object : values) {
            if (object instanceof Stack) {
                Stack deck = (Stack)object;
                for (Object o : deck) {
                    XLIFFUnit tu = (XLIFFUnit)o;
                    String source = tu.getSourceText().toLowerCase();
                    List list = (List)qaMap.get(source);
                    if (list != null) {
                        list.add(tu);
                        continue;
                    }
                    ArrayList<XLIFFUnit> newList = new ArrayList<XLIFFUnit>();
                    newList.add(tu);
                    qaMap.put(source, newList);
                }
                continue;
            }
            XLIFFUnit tu = (XLIFFUnit)object;
            String source = tu.getSourceText().toLowerCase();
            List list = (List)qaMap.get(source);
            if (list != null) {
                list.add(tu);
                continue;
            }
            ArrayList<XLIFFUnit> newList = new ArrayList<XLIFFUnit>();
            newList.add(tu);
            qaMap.put(source, newList);
        }
        Collection values2 = qaMap.values();
        for (List next : values2) {
            if (next.size() <= 1) continue;
            HashSet<String> set = new HashSet<String>(2);
            for (int i = 0; i < next.size(); ++i) {
                XLIFFUnit get = (XLIFFUnit)next.get(i);
                String target = get.getTargetText().toLowerCase();
                set.add(target);
            }
            if (set.size() <= 1) continue;
            for (Object o : next) {
                XLIFFUnit tu = (XLIFFUnit)o;
                int state = tu.getState();
                if (state == 1 && !AppPreferences.qaCheckedSegments) continue;
                Issue issue = new Issue(1);
                tu.addIssue(issue);
                issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TRANSLATION"));
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
    }

    private void endPunctCheckXliff(XLIFF xliff) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        for (Object o : tunits) {
            String group;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String sPunct = "";
            String tPunct = "";
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            Pattern patt = Pattern.compile("([;:.)!?\u3002]\\z)");
            Matcher sma = patt.matcher(source);
            Matcher tma = patt.matcher(target);
            if (sma.find()) {
                sPunct = group = sma.group();
            }
            if (tma.find()) {
                tPunct = group = tma.group();
            }
            Issue issue = null;
            if (!sPunct.equals(tPunct)) {
                boolean isCorrect = false;
                if (sPunct.startsWith("\u3002") && (tPunct.startsWith(".") || tPunct.startsWith("?"))) {
                    isCorrect = true;
                } else if (tPunct.startsWith("\u3002") && (sPunct.startsWith(".") || sPunct.startsWith("?"))) {
                    isCorrect = true;
                }
                if (!isCorrect) {
                    boolean language;
                    issue = new Issue(3);
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("END PUNCTUATION"));
                    if (sPunct.length() > tPunct.length()) {
                        language = true;
                        issue.setQuery(sma, language);
                    } else {
                        language = false;
                        issue.setQuery(tma, language);
                    }
                    tu.addIssue(issue);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void endPunctCheckTTX(TTX ttx) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        for (Object o : tunits) {
            String group;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
            String source = tu.getSourceText();
            String target = tu.getTargetText();
            if (target == null || target.length() == 0) continue;
            String sPunct = "";
            String tPunct = "";
            Pattern patt = Pattern.compile("([;:.)!?\u3002]\\z)");
            Matcher sma = patt.matcher(source);
            Matcher tma = patt.matcher(target);
            if (sma.find()) {
                sPunct = group = sma.group();
            }
            if (tma.find()) {
                tPunct = group = tma.group();
            }
            Issue issue = null;
            if (!sPunct.equals(tPunct)) {
                boolean isCorrect = false;
                if (sPunct.startsWith("\u3002") && (tPunct.startsWith(".") || tPunct.startsWith("?"))) {
                    isCorrect = true;
                } else if (tPunct.startsWith("\u3002") && (sPunct.startsWith(".") || sPunct.startsWith("?"))) {
                    isCorrect = true;
                }
                if (!isCorrect) {
                    boolean language;
                    issue = new Issue(3);
                    if (sPunct.length() > tPunct.length()) {
                        language = true;
                        issue.setQuery(sma, language);
                    } else {
                        language = false;
                        issue.setQuery(tma, language);
                    }
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("END PUNCTUATION"));
                    tu.addIssue(issue);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void endPunctCheckTMX(TMX tmx) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        for (Object o : tunits) {
            String group;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            if (tuvt == null || tuvs == null) continue;
            String target = tuvt.getSegmentText();
            String source = tuvs.getSegmentText();
            if (target == null || target.length() == 0) continue;
            String sPunct = "";
            String tPunct = "";
            Pattern patt = Pattern.compile("([;:.)!?\u3002]\\z)");
            Matcher sma = patt.matcher(source);
            Matcher tma = patt.matcher(target);
            if (sma.find()) {
                sPunct = group = sma.group();
            }
            if (tma.find()) {
                tPunct = group = tma.group();
            }
            Issue issue = null;
            if (!sPunct.equals(tPunct)) {
                boolean isCorrect = false;
                if (sPunct.startsWith("\u3002") && (tPunct.startsWith(".") || tPunct.startsWith("?"))) {
                    isCorrect = true;
                } else if (tPunct.startsWith("\u3002") && (sPunct.startsWith(".") || sPunct.startsWith("?"))) {
                    isCorrect = true;
                }
                if (!isCorrect) {
                    ArrayList<Issue> issues;
                    boolean language;
                    issue = new Issue(3);
                    if (sPunct.length() > tPunct.length()) {
                        language = true;
                        issue.setQuery(sma, language);
                    } else {
                        language = false;
                        issue.setQuery(tma, language);
                    }
                    issue.addMessage(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("END PUNCTUATION"));
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void blacklistCheckTTX(TTX ttx, String query, boolean language, boolean hit) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        Pattern patt = !AppPreferences.qaCaseMatch ? Pattern.compile(query, 2) : Pattern.compile(query);
        String message = hit ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORD PRESENT") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORD MISSING");
        for (Object o : tunits) {
            String content;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments || (content = language ? tu.getSourceText() : tu.getTargetText()) == null) continue;
            Matcher ma = patt.matcher(content);
            Issue issue = null;
            if (ma.find() == hit) {
                issue = new Issue(10);
                issue.addMessage(message);
                issue.setQuery(ma, language);
                tu.addIssue(issue);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void blacklistCheckXliff(XLIFF xliff, String query, boolean language, boolean hit) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Pattern patt = !AppPreferences.qaCaseMatch ? Pattern.compile(query, 2) : Pattern.compile(query);
        String message = hit ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORD PRESENT") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORD MISSING");
        for (Object o : tunits) {
            String content;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (content = language ? tu.getSourceText() : tu.getTargetText()) == null) continue;
            Matcher ma = patt.matcher(content);
            Issue issue = null;
            if (ma.find() == hit) {
                issue = new Issue(10);
                issue.addMessage(message);
                issue.setQuery(ma, language);
                tu.addIssue(issue);
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void blacklistCheckTMX(TMX tmx, String query, boolean language, boolean hit) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap map = tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        Pattern patt = !AppPreferences.qaCaseMatch ? Pattern.compile(query, 2) : Pattern.compile(query);
        String message = hit ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORD PRESENT") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORD MISSING");
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            TMXUnitVariant tuvt = tu.getTUV(tlang);
            TMXUnitVariant tuvs = tu.getTUV(slang);
            String content = null;
            if (language) {
                if (tuvs != null) {
                    content = tuvs.getSegmentText();
                }
            } else if (tuvt != null) {
                content = tuvt.getSegmentText();
            }
            if (content == null) continue;
            Matcher ma = patt.matcher(content);
            Issue issue = null;
            if (ma.find() == hit) {
                ArrayList<Issue> issues;
                issue = new Issue(10);
                issue.addMessage(message);
                issue.setQuery(ma, language);
                Object object = issuesTMX.get(tu);
                if (object != null) {
                    issues = (ArrayList<Issue>)object;
                    issues.add(issue);
                } else {
                    issues = new ArrayList<Issue>(2);
                    issues.add(issue);
                    issuesTMX.put(tu, issues);
                }
            }
            if (issue == null) continue;
            if (this.tunitsSetFilter != null) {
                this.tunitsSetFilter.add(tu);
                continue;
            }
            this.tunitsFilter.add(tu);
        }
    }

    private void findAndReplaceCheckXliff(XLIFF xliff, HashMap map, boolean language) {
        List tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tunits = xliff.getView().getFilteredUnits();
        }
        if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
            FileBody body = xliff.getCurrentFile().getBody();
            tunits = body.getTransUnits();
        }
        Set set = map.entrySet();
        for (Map.Entry element : set) {
            String find = (String)element.getKey();
            String replace = (String)element.getValue();
            StringBuilder findBuilder = new StringBuilder();
            if (AppPreferences.qaWholewords) {
                findBuilder.append("\\b");
            }
            if (!AppPreferences.qaRegEx) {
                findBuilder.append("\\Q");
            }
            findBuilder.append(find);
            if (!AppPreferences.qaRegEx) {
                findBuilder.append("\\E");
            }
            if (AppPreferences.qaWholewords) {
                findBuilder.append("\\b");
            }
            Pattern patt = !AppPreferences.qaCaseMatch ? Pattern.compile(findBuilder.toString(), 2) : Pattern.compile(findBuilder.toString());
            for (Object o : tunits) {
                int state;
                if (o == null || !(o instanceof XLIFFUnit)) continue;
                XLIFFUnit tu = (XLIFFUnit)o;
                if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
                boolean replaced = false;
                if (language) {
                    XMLElement tus = tu.getSource();
                    if (tus != null) {
                        replaced = XMLHelper.replaceInXML(tus, patt, replace);
                        if (xliff.isExternalToolXLIFF && replaced) {
                            tu.updateParentTargetSegment();
                        }
                    }
                } else {
                    XMLElement tut = tu.getTarget();
                    if (tut != null) {
                        replaced = XMLHelper.replaceInXML(tut, patt, replace);
                        if (xliff.isExternalToolXLIFF && replaced) {
                            tu.updateParentTargetSegment();
                        }
                    }
                }
                Issue issue = null;
                if (replaced) {
                    xliff.saved = false;
                    String message = find + "=" + replace;
                    issue = new Issue(13);
                    issue.addMessage(message);
                    tu.addIssue(issue);
                }
                if (issue == null) continue;
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
    }

    private void findAndReplaceCheckTTX(TTX ttx, HashMap map, boolean language) {
        List tunits = ttx.getView().getGluedUnits();
        if (tunits == null) {
            tunits = ttx.getCurrentFile().getTransUnits();
        }
        Set set = map.entrySet();
        for (Map.Entry element : set) {
            String find = (String)element.getKey();
            String replace = (String)element.getValue();
            StringBuilder findBuilder = new StringBuilder();
            if (AppPreferences.qaWholewords) {
                findBuilder.append("\\b");
            }
            if (!AppPreferences.qaRegEx) {
                findBuilder.append("\\Q");
            }
            findBuilder.append(find);
            if (!AppPreferences.qaRegEx) {
                findBuilder.append("\\E");
            }
            if (AppPreferences.qaWholewords) {
                findBuilder.append("\\b");
            }
            Pattern patt = !AppPreferences.qaCaseMatch ? Pattern.compile(findBuilder.toString(), 2) : Pattern.compile(findBuilder.toString());
            for (Object o : tunits) {
                TTXUnit tu;
                int state;
                if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments) continue;
                boolean replaced = false;
                if (language) {
                    XMLElement tus = tu.getSource();
                    if (tus != null) {
                        replaced = XMLHelper.replaceInXML(tus, patt, replace);
                    }
                } else {
                    XMLElement tut = tu.getTarget();
                    if (tut != null) {
                        replaced = XMLHelper.replaceInXML(tut, patt, replace);
                    }
                }
                Issue issue = null;
                if (replaced) {
                    ttx.saved = false;
                    String message = find + "=" + replace;
                    issue = new Issue(13);
                    issue.addMessage(message);
                    tu.addIssue(issue);
                }
                if (issue == null) continue;
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
    }

    private void findAndReplaceCheckTMX(TMX tmx, HashMap map, boolean language) {
        Collection tunits = null;
        if (AppPreferences.qaFilteredSegments) {
            tmx.getView();
            tunits = TMXView.getFilteredUnits();
        }
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits == null) {
            return;
        }
        TranslationUnitMap tumap = tmx.getTUMap();
        String slang = tumap.getSourceLang();
        String tlang = tumap.getTargetLang();
        Set set = map.entrySet();
        for (Map.Entry element : set) {
            String find = (String)element.getKey();
            String replace = (String)element.getValue();
            StringBuilder findBuilder = new StringBuilder();
            if (AppPreferences.qaWholewords) {
                findBuilder.append("\\b");
            }
            if (!AppPreferences.qaRegEx) {
                findBuilder.append("\\Q");
            }
            findBuilder.append(find);
            if (!AppPreferences.qaRegEx) {
                findBuilder.append("\\E");
            }
            if (AppPreferences.qaWholewords) {
                findBuilder.append("\\b");
            }
            Pattern patt = !AppPreferences.qaCaseMatch ? Pattern.compile(findBuilder.toString(), 2) : Pattern.compile(findBuilder.toString());
            for (Object o : tunits) {
                XMLElement xmle;
                if (o == null || !(o instanceof TMXUnit)) continue;
                TMXUnit tu = (TMXUnit)o;
                boolean replaced = false;
                if (language) {
                    TMXUnitVariant tuvs = tu.getTUV(slang);
                    xmle = null;
                    if (tuvs != null) {
                        xmle = tuvs.getSegment();
                    }
                    if (xmle != null) {
                        replaced = XMLHelper.replaceInXML(xmle, patt, replace);
                    }
                } else {
                    TMXUnitVariant tuvt = tu.getTUV(tlang);
                    xmle = null;
                    if (tuvt != null) {
                        xmle = tuvt.getSegment();
                    }
                    if (xmle != null) {
                        replaced = XMLHelper.replaceInXML(xmle, patt, replace);
                    }
                }
                Issue issue = null;
                if (replaced) {
                    ArrayList<Issue> issues;
                    tmx.saved = false;
                    String message = find + "=" + replace;
                    issue = new Issue(13);
                    issue.addMessage(message);
                    Object object = issuesTMX.get(tu);
                    if (object != null) {
                        issues = (ArrayList<Issue>)object;
                        issues.add(issue);
                    } else {
                        issues = new ArrayList<Issue>(2);
                        issues.add(issue);
                        issuesTMX.put(tu, issues);
                    }
                }
                if (issue == null) continue;
                if (this.tunitsSetFilter != null) {
                    this.tunitsSetFilter.add(tu);
                    continue;
                }
                this.tunitsFilter.add(tu);
            }
        }
    }

    public void repeatLastQA() {
        if (this.lastFilters == null || this.lastFilters.isEmpty()) {
            return;
        }
        Object[] objects = this.lastFilters.toArray();
        this.initQA();
        this.tunitsSetFilter = new LinkedHashSet();
        for (int k = 0; k < objects.length; ++k) {
            int i = (Integer)objects[k];
            if (i == 1) {
                this.tagsCheck();
                continue;
            }
            if (i == 2) {
                this.bracketsCheck();
                continue;
            }
            if (i == 3) {
                this.spaceLeadingCheck();
                continue;
            }
            if (i == 4) {
                this.spaceTrailingCheck();
                continue;
            }
            if (i == 5) {
                this.spaceDoubleCheck();
                continue;
            }
            if (i == 6) {
                this.spaceAtTagsCheck();
                continue;
            }
            if (i == 7) {
                this.spellCheck();
                continue;
            }
            if (i == 8) {
                this.digitsCheck();
                continue;
            }
            if (i == 9) {
                this.emptySegmentsCheck();
                continue;
            }
            if (i == 10) {
                this.sameSegmentsCheck();
                continue;
            }
            if (i == 11) {
                this.endPunctuationCheck();
                continue;
            }
            if (i == 12) {
                this.capitalizationCheck();
                continue;
            }
            if (i == 13) {
                this.doubleWordsCheck();
                continue;
            }
            if (i == 14) {
                this.translationConsistencyCheck();
                continue;
            }
            if (i == 15) {
                this.translationConformityCheck();
                continue;
            }
            if (i == 16) {
                this.termMemoryCheck();
                continue;
            }
            if (i == 17) {
                this.termGlossaryCheck();
                continue;
            }
            if (i == 18) {
                this.sameSourceDifferentTargetCheck();
                continue;
            }
            if (i == 19) {
                this.sameTargetDifferentSourceCheck();
                continue;
            }
            if (i == 20) {
                this.nonTranslatablesCheck();
                continue;
            }
            if (i == 21) {
                this.lengthDifferenceCheck();
                continue;
            }
            if (i == 22) {
                this.lengthDifferenceCheckChars();
                continue;
            }
            if (i == 23) {
                this.maxLengthCheck();
                continue;
            }
            if (i != 24) continue;
            this.quotesCheck();
        }
        this.tunitsFilter = new ArrayList(this.tunitsSetFilter);
        this.tunitsSetFilter = null;
        this.showQAResults();
        this.projectToSave();
    }

    public List getFilteredUnits() {
        return this.tunitsFilter;
    }

    private void showQAResults() {
        if (!this.tunitsFilter.isEmpty()) {
            AppPreferences.QAFilter = true;
            if (this.spacesCheck) {
                this.topui.getSourceView().toggleInvisibleCharacters(true);
            }
            this.topui.setSegmentsFilter();
            if (!AppPreferences.qaFilteredSegments) {
                this.prview.getProject().setQAFilteredWorkflow(this.tunitsFilter);
            } else {
                ArrayList copy = new ArrayList();
                copy.addAll(this.tunitsFilter);
                this.prview.getProject().setQAFilteredWorkflow(copy);
            }
            this.prview.getProject().edit("#0");
        } else {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("QA COMPLETED SUCCESSFULLY"));
            this.topui.resetSegmentsFilter();
            this.topui.requestFocus();
        }
    }

    private void projectToSave() {
        List projects = this.prview.getProject().getProjects();
        if (projects != null) {
            for (Object object : projects) {
                if (object instanceof XLIFF) {
                    XLIFF xlf = (XLIFF)object;
                    xlf.saved = false;
                    continue;
                }
                if (object instanceof TMX) {
                    TMX tmx = (TMX)object;
                    tmx.saved = false;
                    continue;
                }
                if (!(object instanceof TTX)) continue;
                TTX ttx = (TTX)object;
                ttx.saved = false;
            }
        }
    }

    private String[] getTTXTagString(List list, boolean edit, int tagCounter) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("ut")) {
                    ed = false;
                }
                int tagNo = ++tagCounter;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                fs = fs + stag;
                String[] arr = this.getTTXTagString(li, ed, tagCounter);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private String[] getXliffTagString(List list, boolean edit, int tagCounter, int xliffVersion) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                String[] arr;
                String type;
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (xliffVersion == 2) {
                    if (name.equals("cp") || name.equals("ph") || name.equals("sc") || name.equals("ec") || name.equals("sm") || name.equals("em")) {
                        ed = false;
                        em = true;
                    }
                } else {
                    if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                        ed = false;
                    }
                    if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                        em = true;
                    }
                }
                int tagNo = ++tagCounter;
                String tname = "x" + tagNo;
                boolean skiptag = false;
                if (name.equals("x")) {
                    String equiv = xml.getAttribute("equiv-text");
                    if (equiv != null && equiv.length() > 0) {
                        tname = tname + " equiv-text=\"" + equiv + "\"";
                    }
                } else if (name.equals("mrk") && (type = xml.getAttribute("mtype")) != null && type.equals("x-sdl-comment")) {
                    skiptag = true;
                }
                String stag = null;
                String etag = null;
                if (!skiptag) {
                    if (!em) {
                        stag = "<" + tname + ">";
                        etag = "</" + tname + ">";
                    } else {
                        stag = "<" + tname + "/>";
                    }
                    fs = fs + stag;
                }
                if ((arr = this.getXliffTagString(li, ed, tagCounter, xliffVersion)) != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private void collectTags(List slist, List stags) {
        for (Object object : slist) {
            if (!(object instanceof XMLElement)) continue;
            XMLElement tag = (XMLElement)object;
            String tagname = tag.getName();
            String id = tag.getAttribute("id");
            if (id != null) {
                if (id.startsWith("locked")) {
                    id = "locked";
                }
                stags.add(tagname + id);
            } else {
                String type;
                boolean comment = false;
                if (tagname.equals("mrk") && (type = tag.getAttribute("mtype")) != null && type.equals("x-sdl-comment")) {
                    comment = true;
                }
                if (!comment) {
                    stags.add(tagname);
                }
            }
            List sslist = tag.getChildren();
            this.collectTags(sslist, stags);
        }
    }

    private void collectTagsContent(List slist, Map stags, int count) {
        for (Object object : slist) {
            if (!(object instanceof XMLElement)) continue;
            XMLElement tag = (XMLElement)object;
            String tagname = tag.getName();
            String id = Integer.toString(count);
            stags.put(tagname + id, tag.getContent(0));
            List sslist = tag.getChildren();
            this.collectTagsContent(sslist, stags, ++count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(File file, String encoding) {
        FileInputStream fis = null;
        StringBuilder content = new StringBuilder();
        try {
            String eline;
            fis = new FileInputStream(file);
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
            while ((eline = r.readLine()) != null) {
                int hash = eline.indexOf(35);
                if (hash != -1) {
                    if (eline.charAt(0) == '#') continue;
                    eline = eline.substring(0, hash);
                }
                if (AppPreferences.qaWholewords) {
                    content.append("\\b");
                }
                if (!AppPreferences.qaRegEx) {
                    content.append("\\Q");
                }
                content.append(eline);
                if (!AppPreferences.qaRegEx) {
                    content.append("\\E");
                }
                if (AppPreferences.qaWholewords) {
                    content.append("\\b");
                }
                content.append("|");
            }
            int len = content.length();
            if (len > 0) {
                content.setLength(len - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + file.getPath());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(QAView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap readStreamToMap(File file, String encoding) {
        HashMap<String, String> map = new HashMap<String, String>();
        FileInputStream fis = null;
        try {
            String eline;
            fis = new FileInputStream(file);
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
            while ((eline = r.readLine()) != null) {
                int i;
                int hash = eline.indexOf(35);
                if (hash != -1) {
                    if (eline.charAt(0) == '#') continue;
                    eline = eline.substring(0, hash);
                }
                if ((i = eline.indexOf("=")) == -1) continue;
                String find = eline.substring(0, i);
                String replace = eline.substring(i + 1);
                if (find.length() <= 0) continue;
                map.put(find, replace);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + file.getPath());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(QAView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return map;
    }

    public static Map getTMXIssuesMap() {
        return issuesTMX;
    }

    private void conformityCheckDialog(List memories) {
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION MEMORIES"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (memories.size() > 20) {
            scroll.setPreferredSize(new Dimension(500, 500));
        }
        dialog.add(scroll);
        JButton menuFileItem = new JButton(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("START")){
            final /* synthetic */ QAView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                this.this$0.checkStart = true;
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        menuFileItem.setHorizontalAlignment(0);
        panel.add(menuFileItem);
        panel.getActionMap().put("ENTER", new AbstractAction(this, "ENTER"){
            final /* synthetic */ QAView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.checkStart = true;
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        for (Memory m : memories) {
            JCheckBox menuMemoryItem = new JCheckBox(m.getName());
            menuMemoryItem.setSelected(m.isCompareTargets());
            menuMemoryItem.putClientProperty("memory", m);
            menuMemoryItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i = e.getStateChange();
                    JCheckBox box = (JCheckBox)e.getItem();
                    Memory m = (Memory)box.getClientProperty("memory");
                    if (i == 1) {
                        m.setCompareTargets(true);
                    } else {
                        m.setCompareTargets(false);
                    }
                }
            });
            menuMemoryItem.setFocusPainted(false);
            menuMemoryItem.setOpaque(false);
            menuMemoryItem.setFont(menuMemoryItem.getFont().deriveFont(1));
            panel.add(menuMemoryItem);
        }
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    private void glossaryTermCheckDialog(List glossaries) {
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (glossaries.size() > 20) {
            scroll.setPreferredSize(new Dimension(500, 500));
        }
        dialog.add(scroll);
        JButton menuFileItem = new JButton(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("START")){
            final /* synthetic */ QAView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                this.this$0.checkStart = true;
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        menuFileItem.setHorizontalAlignment(0);
        panel.add(menuFileItem);
        panel.getActionMap().put("ENTER", new AbstractAction(this, "ENTER"){
            final /* synthetic */ QAView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.checkStart = true;
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        for (GlossaryResource g : glossaries) {
            JCheckBox menuItem = new JCheckBox(g.getName());
            menuItem.setSelected(g.isQATermsCheck());
            menuItem.putClientProperty("glossary", g);
            menuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i = e.getStateChange();
                    JCheckBox box = (JCheckBox)e.getItem();
                    GlossaryResource g = (GlossaryResource)box.getClientProperty("glossary");
                    if (i == 1) {
                        g.setQATermsCheck(true);
                    } else {
                        g.setQATermsCheck(false);
                    }
                }
            });
            menuItem.setFocusPainted(false);
            menuItem.setOpaque(false);
            menuItem.setFont(menuItem.getFont().deriveFont(1));
            panel.add(menuItem);
        }
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    private void memoryTermCheckDialog(List memories) {
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION MEMORIES"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (memories.size() > 20) {
            scroll.setPreferredSize(new Dimension(500, 500));
        }
        dialog.add(scroll);
        JButton menuFileItem = new JButton(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("START")){
            final /* synthetic */ QAView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                this.this$0.checkStart = true;
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        menuFileItem.setHorizontalAlignment(0);
        panel.add(menuFileItem);
        panel.getActionMap().put("ENTER", new AbstractAction(this, "ENTER"){
            final /* synthetic */ QAView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.checkStart = true;
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        for (Memory m : memories) {
            JCheckBox menuItem = new JCheckBox(m.getName());
            menuItem.setSelected(m.getTermsCheck());
            menuItem.putClientProperty("memory", m);
            menuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i = e.getStateChange();
                    JCheckBox box = (JCheckBox)e.getItem();
                    Memory m = (Memory)box.getClientProperty("memory");
                    if (i == 1) {
                        m.setTermsCheck(true);
                    } else {
                        m.setTermsCheck(false);
                    }
                }
            });
            menuItem.setFocusPainted(false);
            menuItem.setOpaque(false);
            menuItem.setFont(menuItem.getFont().deriveFont(1));
            panel.add(menuItem);
        }
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    private static String fullwidth2halfwidth(String fullwidthstr) {
        if (fullwidthstr == null || fullwidthstr.length() == 0) {
            return fullwidthstr;
        }
        char[] chararray = fullwidthstr.toCharArray();
        for (int i = 0; i < chararray.length; ++i) {
            char charintvalue = chararray[i];
            if (charintvalue >= '\uff01' && charintvalue <= '\uff5e') {
                chararray[i] = (char)(charintvalue - 65248);
                continue;
            }
            if (charintvalue != '\u3000') continue;
            chararray[i] = 32;
        }
        return new String(chararray);
    }
}

