/*
 * Decompiled with CFR 0.152.
 */
package translator.server;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.MainView;
import translator.MySwingWorker;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.ScrollPaneWatermark;
import translator.TabView;
import translator.TargetView;
import translator.TranslationUnit;
import translator.XMLElement;
import translator.XMLElementEditor;
import translator.XMLHelper;
import translator.tmx.MemoryView;
import translator.tmx.TMXResult;
import translator.tmx.TMXUnit;
import translator.ui.HTMLFormat;
import translator.ui.UITools;

public class RemoteMemory
extends DefaultResource {
    public MainView topui;
    public TabView tview;
    public MemoryView mview;
    private JTextPane pane;
    public ResourceView rview;
    private JPopupMenu pop;
    private String info;
    private String name;
    private String path;
    private String infoPath;
    private Socket socket = null;
    private PrintWriter out = null;
    private BufferedReader in = null;
    private ObjectInputStream ois = null;
    private TMXResult result;
    private boolean running = false;
    public boolean auto = true;
    public boolean readonly = false;
    private int port;
    private String host;
    private int count = 0;
    private MySwingWorker worker;
    private Thread th;
    private boolean act = true;

    public RemoteMemory(ResourceInfo ri) {
        this.infoPath = ri.getInfoPath();
        this.path = ri.getResourcePath();
        this.name = ri.getName();
        if (this.name == null) {
            int i = this.infoPath.lastIndexOf(AppPreferences.fs);
            if (i == -1) {
                i = this.infoPath.lastIndexOf(47);
            }
            this.name = i != -1 ? this.infoPath.substring(i + 1, this.infoPath.length() - 4) : "Remote Memory";
        }
        this.connect("Xwing", 4242);
    }

    public RemoteMemory(String host, int port) {
        this.host = host;
        this.port = port;
        this.name = host;
    }

    private void connect(final String host, final int port) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ RemoteMemory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.socket = new Socket(host, port);
                    this.this$0.out = new PrintWriter(this.this$0.socket.getOutputStream(), true);
                    this.this$0.ois = new ObjectInputStream(this.this$0.socket.getInputStream());
                    this.this$0.createMemoryTab();
                    this.this$0.setPopup();
                }
                catch (UnknownHostException e) {
                    JOptionPane.showMessageDialog(this.this$0.topui, "Host not found: " + host);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.this$0.topui, "Couldn't connect to: " + host);
                }
            }
        });
    }

    private void disconnect() {
        try {
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O to disconnect from: " + this.host);
        }
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.mview = topui.getMemoryView();
        this.tview = topui.getTabView();
        this.rview = topui.getResourceView();
        this.connect(this.host, this.port);
    }

    private void createMemoryTab() {
        File file;
        this.pane = new JTextPane();
        this.pane.putClientProperty("type", "remote");
        this.pane.addHyperlinkListener(new MemoryHyperactive());
        this.pane.setContentType("text/html");
        Graphics g = this.pane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            Color foreground = new Color(AppPreferences.foreground);
            background = new Color(AppPreferences.background);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.pane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
            this.pane.setCaretColor(foreground);
            this.pane.setBackground(background);
            this.pane.setForeground(foreground);
            this.pane.setSelectionColor(selection);
            this.pane.setSelectedTextColor(foreground);
        }
        this.pane.setMargin(new Insets(12, 12, 12, 12));
        this.pane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                RemoteMemory.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.pane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    RemoteMemory.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JTextPane memoryPane;
                String sel;
                boolean ctrl = UITools.isShortcutDown(e);
                if (!ctrl && (sel = (memoryPane = (JTextPane)e.getSource()).getSelectedText()) != null) {
                    TargetView pview = RemoteMemory.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
                if (e.isPopupTrigger()) {
                    RemoteMemory.this.showPopUp(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.pane.setEditable(false);
        Style sstyle = this.pane.addStyle("highlight", null);
        Color segment = new Color(AppPreferences.segment);
        StyleConstants.setForeground(sstyle, segment);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.pane.setBackground(new Color(0, 0, 0, 0));
            this.pane.setOpaque(false);
        }
        jScrollPane.getViewport().add((Component)this.pane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.pane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.pane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(RemoteMemory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tview.addTab(this, this.name, jScrollPane);
    }

    private synchronized void updateBase(String[] s) {
        if (this.out != null) {
            if (AppPreferences.isTrialVersion && this.count > 10) {
                return;
            }
            String source = s[0];
            String target = s[1];
            if (source.length() > 0 && target.length() > 0) {
                this.out.println(source + "<=+>" + target + "\nEOI");
            }
        }
    }

    public void update(final String[] s) {
        MySwingWorker worker = new MySwingWorker(this){
            final /* synthetic */ RemoteMemory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.this$0.updateBase(s);
                return null;
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
    }

    public void cancelSearch() {
        this.running = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    private synchronized StringBuffer searchBase(String key) {
        StringBuffer sb = new StringBuffer();
        if (this.out != null) {
            ++this.count;
            this.running = true;
            if (!AppPreferences.isTrialVersion) {
                this.out.println(key + "\nEOI");
            } else {
                if (this.count > 10) {
                    String m = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRIAL VERSION LIMIT");
                    sb.append("<html>");
                    sb.append(HTMLFormat.styles);
                    sb.append("<body>");
                    sb.append("<table align=center WIDTH=33% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=8 CELLPADDING=2><tr>");
                    sb.append("<th style=\"color:white; background-color:#B71C1C\">");
                    sb.append(m);
                    sb.append("</th>");
                    sb.append("</tr>");
                    sb.append("</table>");
                    sb.append("</body></html>");
                    this.running = false;
                    return sb;
                }
                this.out.println("#TrialVersion\n" + key + "\nEOI");
            }
            try {
                if (this.ois != null) {
                    Object o = this.ois.readObject();
                    if (o != null && o instanceof TMXResult) {
                        this.result = (TMXResult)o;
                        String matches = this.result.getHTMLResults();
                        if (matches != null) {
                            sb.append(matches);
                        }
                        if (this.mview.getTranslateEvent() != null) {
                            this.mview.getTranslateEvent().addTranslationResult(key, this.result, false);
                        }
                    } else if (o != null && o instanceof String) {
                        String m = (String)o;
                        String s = "Server Message";
                        JOptionPane.showMessageDialog(this.topui, m, s, 1);
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                String mess = ex.getMessage();
                sb.append("<html>");
                sb.append(HTMLFormat.styles);
                sb.append("<body>");
                sb.append("<table align=center WIDTH=33% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=8 CELLPADDING=2><tr>");
                sb.append("<th style=\"color:white; background-color:#B71C1C\">");
                sb.append(mess);
                sb.append("</th>");
                sb.append("</tr>");
                sb.append("</table>");
                sb.append("</body></html>");
                this.running = false;
                return sb;
            }
            catch (IOException ex) {
                String mess = ex.getMessage();
                sb.append("<html>");
                sb.append(HTMLFormat.styles);
                sb.append("<body>");
                sb.append("<table align=center WIDTH=33% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=8 CELLPADDING=2><tr>");
                sb.append("<th style=\"color:white; background-color:#B71C1C\">");
                sb.append(mess);
                sb.append("</th>");
                sb.append("</tr>");
                sb.append("</table>");
                sb.append("</body></html>");
                this.running = false;
                return sb;
            }
        }
        return sb;
    }

    @Override
    public void search(final String key, String replace) {
        if (this.running) {
            return;
        }
        this.worker = new MySwingWorker(this){
            StringBuffer sb = new StringBuffer();
            final /* synthetic */ RemoteMemory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.sb = this.this$0.searchBase(key);
                return null;
            }

            @Override
            public void finished() {
                try {
                    HTMLDocument htmldoc = (HTMLDocument)this.this$0.pane.getDocument();
                    htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), this.sb.toString());
                    this.this$0.pane.setCaretPosition(0);
                    this.this$0.running = false;
                    if (this.this$0.mview.getTranslateEvent() != null) {
                        this.this$0.mview.getTranslateEvent().countDownLatch();
                    }
                    this.this$0.topui.getTargetPane().requestFocus();
                }
                catch (IOException ex) {
                    Logger.getLogger(RemoteMemory.class.getName()).log(Level.SEVERE, null, ex);
                    if (this.this$0.mview.getTranslateEvent() != null) {
                        this.this$0.mview.getTranslateEvent().countDownLatch();
                    }
                    this.this$0.running = false;
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(RemoteMemory.class.getName()).log(Level.SEVERE, null, ex);
                    if (this.this$0.mview.getTranslateEvent() != null) {
                        this.this$0.mview.getTranslateEvent().countDownLatch();
                    }
                    this.this$0.running = false;
                }
            }
        };
        this.worker.start();
    }

    @Override
    public void stopSearch() {
        this.running = false;
    }

    private boolean okToAbandon() {
        int value = JOptionPane.showConfirmDialog(this.topui, "Disconnect from the " + this.name + "?", "CafeTran Espresso", 0);
        switch (value) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void closeResource() {
        if (this.okToAbandon()) {
            this.disconnect();
            this.topui.getMemoryView().removeRemoteMemory(this);
            this.tview.removeTab(this.name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void editElement(String s) {
        if (s.startsWith("#")) {
            TMXUnit tux;
            int r;
            TranslationUnit tu;
            int ind = s.indexOf(61);
            String s3 = ind != -1 ? s.substring(ind + 1, s.length()) : s.substring(1, s.length());
            int i = Integer.parseInt(s3);
            if (this.result != null && ind != -1 && (tu = this.result.getTranslationUnit(i)) != null && tu instanceof TMXUnit && (r = this.showXMLElement(tux = (TMXUnit)tu)) != 0) return;
        }
        if (s.startsWith("$")) {
            String t;
            int i;
            Object[] ob;
            if (this.result == null || (ob = this.result.getBestFuzzy(i = Integer.parseInt(t = s.substring(1, s.length())))) == null) return;
            int proc = (Integer)ob[0];
            String f = (String)ob[2];
            this.setResult(f, proc, 2);
            return;
        } else {
            if (this.result == null) return;
            int i = Integer.parseInt(s);
            String t = this.result.getTarget(i);
            this.insertResult(t);
        }
    }

    public int showXMLElement(XMLElement elem) {
        XMLElementEditor dlg = new XMLElementEditor(this.topui, elem);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        return dlg.getStatus();
    }

    public void setResult(String result, int proc, int type) {
        this.topui.getTargetPane().setText(result);
    }

    public void insertResult(String result) {
        try {
            JTextPane targetTextArea = this.topui.getTargetPane();
            int pos = targetTextArea.getCaretPosition();
            Document dok = targetTextArea.getDocument();
            dok.insertString(pos, result, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(RemoteMemory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction("Translate"){

            @Override
            public void actionPerformed(ActionEvent a) {
                JTextPane pane = RemoteMemory.this.topui.getSourcePane();
                String query = pane.getSelectedText();
                if (query == null) {
                    query = pane.getText();
                }
                if (query.length() > 0) {
                    query = XMLHelper.parseTags(query);
                    RemoteMemory.this.search(query, null);
                }
            }
        });
        this.pop.add(item);
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    @Override
    public String getInfoPath() {
        return this.infoPath;
    }

    public String getResourcePath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    void viewContent(final TranslationUnit tu, final String sourceWord, final String targetWord) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ RemoteMemory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    String target;
                    StyledDocument doc;
                    JTextPane sourceTextArea = this.this$0.topui.getSourcePane();
                    JTextPane targetTextArea = this.this$0.topui.getTargetPane();
                    if (sourceTextArea.getClientProperty("content") == null) {
                        sourceTextArea.putClientProperty("content", sourceTextArea.getText());
                    }
                    if (targetTextArea.getClientProperty("content") == null) {
                        targetTextArea.putClientProperty("content", targetTextArea.getText());
                    }
                    String word = sourceWord != null ? sourceWord : this.this$0.topui.getResourceView().getLookUpText();
                    String source = tu.getSegment(((RemoteMemory)this.this$0).result.sLang);
                    if (source.length() > 0) {
                        doc = sourceTextArea.getStyledDocument();
                        doc.remove(0, doc.getLength());
                        doc.insertString(0, source, null);
                        sourceTextArea.setCaretPosition(0);
                        if (word != null && word.length() > 0) {
                            this.this$0.topui.getSourceView().highlightWord(word);
                        }
                    } else {
                        doc = sourceTextArea.getStyledDocument();
                        doc.remove(0, doc.getLength());
                    }
                    if (targetWord != null) {
                        word = targetWord;
                    }
                    if ((target = tu.getSegment(((RemoteMemory)this.this$0).result.tLang)).length() > 0) {
                        StyledDocument doc2 = targetTextArea.getStyledDocument();
                        doc2.remove(0, doc2.getLength());
                        doc2.insertString(0, target, null);
                        targetTextArea.setCaretPosition(0);
                        if (word != null && word.length() > 0) {
                            this.this$0.topui.getTargetView().highlightWord(word);
                        }
                    } else {
                        StyledDocument doc3 = targetTextArea.getStyledDocument();
                        doc3.remove(0, doc3.getLength());
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(RemoteMemory.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    class MemoryHyperactive
    implements HyperlinkListener {
        MemoryHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                if (RemoteMemory.this.th != null) {
                    RemoteMemory.this.act = false;
                    RemoteMemory.this.th = null;
                }
            } else if (e.getEventType() != HyperlinkEvent.EventType.ENTERED && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                RemoteMemory.this.act = false;
                HTMLDocument doc = (HTMLDocument)RemoteMemory.this.pane.getDocument();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        String s2 = e.getDescription();
                        if (s2 != null) {
                            RemoteMemory.this.editElement(s2);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

