/*
 * Decompiled with CFR 0.152.
 */
package translator.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.LinkedHashMap;
import translator.MainView;
import translator.server.RendezVousServerThread;

public class RendezVousServer {
    private MainView topui;
    private ServerSocket serverSocket = null;
    private boolean listening;
    static LinkedHashMap clients;

    public RendezVousServer(MainView topui) {
        this.topui = topui;
        clients = new LinkedHashMap();
    }

    public void listen(int port) {
        this.listening = true;
        try {
            this.serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            System.out.println("Rendezvous server could not listen on port: " + port);
            return;
        }
        System.out.println("Rendezvous server started...");
        while (this.listening) {
            try {
                RendezVousServerThread rvs = new RendezVousServerThread(this.serverSocket.accept());
                rvs.setMainView(this.topui);
                rvs.start();
            }
            catch (IOException ex) {
                String mess = ex.getMessage();
                System.out.println("Rendezvous server: " + mess);
            }
        }
    }

    public LinkedHashMap getClients() {
        return clients;
    }

    public static synchronized void add(String id, RendezVousServerThread rvs) {
        if (clients != null) {
            clients.put(id, rvs);
        }
    }

    public static synchronized void remove(String id) {
        if (clients != null) {
            clients.remove(id);
        }
    }

    public synchronized void stop() {
        this.listening = false;
        try {
            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        for (Object object : clients.values()) {
            if (object == null || !(object instanceof RendezVousServerThread)) continue;
            RendezVousServerThread rvs = (RendezVousServerThread)object;
            rvs.close();
        }
        clients.clear();
        System.out.println("Rendezvous server stopped.");
    }
}

