/*
 * Decompiled with CFR 0.152.
 */
package translator.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import translator.AppPreferences;
import translator.MainView;
import translator.Project;
import translator.SegmentParser;
import translator.TranslationUnitMap;
import translator.XMLHelper;
import translator.server.RendezVousServer;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.tmx.TMXResult;

public class RendezVousServerThread
extends Thread {
    private Socket socket = null;
    private MainView topui;
    private MemoryView mv;
    private SegmentParser parser;
    private String memoryID;
    private String sourceLang;
    private String targetLang;
    private ObjectOutputStream oos;
    private BufferedReader in;
    private String host;
    private boolean running;

    public RendezVousServerThread(Socket socket) {
        super("RendezVousServerThread");
        this.socket = socket;
    }

    void setMainView(MainView topui) {
        this.topui = topui;
        this.mv = topui.getMemoryView();
    }

    private SegmentParser initParser(Memory mem) {
        Project project;
        TMX tmx = mem.getTMX();
        TranslationUnitMap tumap = tmx.getTUMap();
        int matchtype = mem.getMatchType();
        boolean prefixmatch = mem.getPrefixMatch();
        boolean caseMatch = mem.getCaseMatch();
        this.parser = new SegmentParser(mem);
        this.parser.setCompareTargets(mem.isCompareTargets());
        this.parser.setPriority(mem.getPriority());
        this.parser.setMatchingType(matchtype, prefixmatch, caseMatch);
        this.parser.setTUMap(tumap);
        this.parser.setMemoryStatistics(mem.getMemoryStatistics());
        List fws = tumap.getFunctionWordsSource();
        List fwt = tumap.getFunctionWordsTarget();
        if (fws != null && fwt != null) {
            this.parser.setFunctionWords(fws, fwt);
        }
        if ((project = this.topui.getProjectView().getProject()) != null) {
            Locale locale = project.getSrcLocale();
            if (locale == null) {
                locale = tmx.getSrcLocale();
            }
            this.parser.setSourceLocale(locale);
        }
        return this.parser;
    }

    @Override
    public void run() {
        try {
            String inputLine;
            this.oos = new ObjectOutputStream(this.socket.getOutputStream());
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.host = this.socket.getInetAddress().getHostName();
            if (AppPreferences.request) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int i = JOptionPane.showConfirmDialog(RendezVousServerThread.this.topui, "Accept remote connection from " + RendezVousServerThread.this.host + "?", "Rendezvous request", 0);
                        if (i == 1) {
                            RendezVousServerThread.this.close();
                        } else {
                            RendezVousServer.add(RendezVousServerThread.this.host, RendezVousServerThread.this);
                        }
                    }
                });
            } else {
                RendezVousServer.add(this.host, this);
            }
            System.out.println(this.host + ": Hello!");
            StringBuffer sb = new StringBuffer();
            boolean trialVersionCilent = false;
            while ((inputLine = this.in.readLine()) != null) {
                if (inputLine.equals("#TrialVersion")) {
                    trialVersionCilent = true;
                    continue;
                }
                if (inputLine.equals("EOI")) {
                    String query = sb.toString();
                    sb.setLength(0);
                    Memory mem = this.mv.getMemory();
                    if (mem == null) continue;
                    int i = query.indexOf("<=+>");
                    if (i != -1) {
                        if (AppPreferences.readonlyServer) continue;
                        String key = query.substring(0, i);
                        String value = query.substring(i + 4);
                        this.update(key, value, mem);
                        continue;
                    }
                    if (this.running) continue;
                    this.running = true;
                    if (query.length() > 0) {
                        this.search(query, mem, trialVersionCilent);
                    }
                    this.running = false;
                    continue;
                }
                sb.append(inputLine);
            }
            this.close();
        }
        catch (IOException e) {
            this.running = false;
            String mess = e.getMessage();
            System.out.println(this.host + ": " + mess);
        }
    }

    private synchronized void update(String key, String value, Memory mem) {
        key = XMLHelper.parseTags(key);
        value = XMLHelper.parseTags(value);
        boolean ro = mem.isReadOnly();
        if (!ro) {
            mem.updateMemory(key, value, null, null);
        }
    }

    private synchronized void search(String query, Memory mem, boolean trialVersionClient) {
        if (trialVersionClient && Memory.totalTUsLoaded > 1000) {
            String m = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRIAL VERSION LIMIT OF 1000 TRANSLATION UNITS IN THE MEMORY.");
            try {
                if (m != null) {
                    this.oos.writeObject(m);
                }
            }
            catch (IOException ex) {
                this.running = false;
                ex.printStackTrace();
            }
        } else {
            String mid = mem.getName();
            String slang = mem.getSourceLangCode();
            String tlang = mem.getTargetLangCode();
            String cleanSegment = mem.getTMX().getParser().cleanSegment(query);
            TMXResult result = mem.getTMX().getParser().getFromCache(cleanSegment);
            if (result == null) {
                if (!(this.parser != null && mid.equals(this.memoryID) && slang.equals(this.sourceLang) && tlang.equals(this.targetLang))) {
                    this.parser = this.initParser(mem);
                    this.memoryID = mid;
                    this.sourceLang = slang;
                    this.targetLang = tlang;
                }
                if (cleanSegment.trim().length() > 0) {
                    result = this.parser.translate(query, cleanSegment, null, false);
                }
            }
            try {
                if (result != null) {
                    this.oos.writeObject(result);
                }
            }
            catch (IOException ex) {
                this.running = false;
                ex.printStackTrace();
            }
        }
    }

    public void close() {
        try {
            if (this.oos != null) {
                this.oos.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
            RendezVousServer.remove(this.host);
            System.out.println(this.host + ": Bye!");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

