/*
 * Decompiled with CFR 0.152.
 */
package translator.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.text.ParagraphView;
import javax.swing.text.ViewFactory;

public class PagedParagraphView
extends ParagraphView {
    public static short NUMBERS_WIDTH = (short)10;
    int DRAW_PAGE_INSET = 0;

    public PagedParagraphView(Element e) {
        super(e);
        short top = 0;
        short left = 0;
        short bottom = 0;
        short right = 0;
        this.setInsets(top, left, bottom, right);
    }

    @Override
    protected void setInsets(short top, short left, short bottom, short right) {
        super.setInsets((short)(top + NUMBERS_WIDTH), (short)(left + NUMBERS_WIDTH), (short)(bottom + NUMBERS_WIDTH), (short)(right + NUMBERS_WIDTH));
    }

    @Override
    public void paint(Graphics g, Shape a) {
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Rectangle baseClip = g.getClip().getBounds();
        Rectangle page = new Rectangle();
        page.x = alloc.x;
        page.y = alloc.y;
        page.height = alloc.height;
        page.width = alloc.width;
        this.paintPageFrame(g, page, baseClip);
        super.paint(g, a);
    }

    public void paintPageFrame(Graphics g, Shape page, Rectangle container) {
        Rectangle alloc;
        Rectangle rectangle = alloc = page instanceof Rectangle ? (Rectangle)page : page.getBounds();
        if (container.intersection((Rectangle)alloc).height <= 0) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(alloc.x, alloc.y, alloc.width, this.DRAW_PAGE_INSET);
        g.fillRect(alloc.x, alloc.y, this.DRAW_PAGE_INSET, alloc.height);
        g.fillRect(alloc.x, alloc.y + alloc.height - this.DRAW_PAGE_INSET, alloc.width, this.DRAW_PAGE_INSET);
        g.fillRect(alloc.x + alloc.width - this.DRAW_PAGE_INSET, alloc.y, this.DRAW_PAGE_INSET, alloc.height);
        g.setColor(oldColor);
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
    }
}

