/*
 * Decompiled with CFR 0.152.
 */
package translator.text;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import translator.AppPreferences;
import translator.text.CTSegmentCache;
import translator.text.TargetStyleConstants;
import translator.ui.Colors;

public class TargetLabelView
extends LabelView {
    static final float[] dash1 = new float[]{6.0f, 2.0f};
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 6.0f, dash1, 0.0f);
    private Color termBackground = Color.LIGHT_GRAY;
    TabExpander expander;
    private boolean colorUnderline;
    private boolean patternUnderline;
    private boolean termBorder;

    public TargetLabelView(Element elem) {
        super(elem);
    }

    @Override
    public float getTabbedSpan(float x, TabExpander e) {
        this.checkPainter();
        TabExpander old = this.expander;
        this.expander = e;
        if (this.expander != old) {
            this.preferenceChanged(null, true, false);
        }
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        float width = this.getGlyphPainter().getSpan(this, p0, p1, this.expander, x);
        return width;
    }

    @Override
    public View breakView(int axis, int p0, float pos, float len) {
        if (axis == 0) {
            this.checkPainter();
            int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
            int breakSpot = this.getBreakSpot(p0, p1);
            if (breakSpot != -1) {
                p1 = breakSpot;
            }
            if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
                return this;
            }
            GlyphView v = (GlyphView)this.createFragment(p0, p1);
            return v;
        }
        return this;
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        if (axis == 0) {
            this.checkPainter();
            int p0 = this.getStartOffset();
            int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
            if (p1 == p0) {
                return 0;
            }
            if (this.getBreakSpot(p0, p1) != -1) {
                return 2000;
            }
            return 1000;
        }
        return super.getBreakWeight(axis, pos, len);
    }

    private int getBreakSpot(int p0, int p1) {
        Document doc = this.getDocument();
        if (doc != null && Boolean.TRUE.equals(doc.getProperty("multiByte"))) {
            return this.getBreakSpotUseBreakIterator(p0, p1);
        }
        return this.getBreakSpotUseWhitespace(p0, p1);
    }

    private int getBreakSpotUseWhitespace(int p0, int p1) {
        Segment s = this.getText(p0, p1);
        char ch = s.last();
        while (ch != '\uffff') {
            if (Character.isWhitespace(ch)) {
                CTSegmentCache.releaseSharedSegment(s);
                return s.getIndex() - s.getBeginIndex() + 1 + p0;
            }
            ch = s.previous();
        }
        CTSegmentCache.releaseSharedSegment(s);
        return -1;
    }

    private int getBreakSpotUseBreakIterator(int p0, int p1) {
        int breakPoint;
        int parent1;
        int parent0;
        Element parent = this.getElement().getParentElement();
        Container c = this.getContainer();
        if (parent == null) {
            parent0 = p0;
            parent1 = p1;
        } else {
            parent0 = parent.getStartOffset();
            parent1 = parent.getEndOffset();
        }
        BreakIterator breaker = c != null ? BreakIterator.getLineInstance(c.getLocale()) : BreakIterator.getLineInstance();
        Segment s = this.getText(parent0, parent1);
        s.first();
        breaker.setText(s);
        if (p1 == parent1) {
            breakPoint = breaker.last();
        } else if (p1 + 1 == parent1) {
            breakPoint = breaker.following(s.offset + s.count - 2);
            if (breakPoint >= s.count + s.offset) {
                breakPoint = breaker.preceding(s.offset + s.count - 1);
            }
        } else {
            breakPoint = breaker.preceding(p1 - parent0 + s.offset + 1);
        }
        int retValue = -1;
        if (breakPoint != -1 && (breakPoint = breakPoint - s.offset + parent0) > p0) {
            if (p0 == parent0 && breakPoint == p0) {
                retValue = -1;
            } else if (breakPoint <= p1) {
                retValue = breakPoint;
            }
        }
        CTSegmentCache.releaseSharedSegment(s);
        return retValue;
    }

    @Override
    public Segment getText(int p0, int p1) {
        Segment text = CTSegmentCache.getSharedSegment();
        try {
            Document doc = this.getDocument();
            doc.getText(p0, p1 - p0, text);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        return text;
    }

    @Override
    public float getMinimumSpan(int axis) {
        switch (axis) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return super.getMinimumSpan(axis);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public void paint(Graphics g, Shape a) {
        Color oldColor;
        Shape oldClip;
        Rectangle clip;
        Shape oldClip2;
        char c;
        int x;
        int i;
        int x0;
        String labelStr;
        StyledDocument sdoc;
        Rectangle r;
        boolean showInvisible;
        super.paint(g, a);
        boolean bl = showInvisible = this.getDocument().getProperty("invisibles") != null;
        if (showInvisible) {
            r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            sdoc = (StyledDocument)this.getDocument();
            try {
                labelStr = sdoc.getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
                x0 = this.modelToView((int)this.getStartOffset(), (Shape)new Rectangle((int)r.width, (int)r.height), (Position.Bias)Position.Bias.Forward).getBounds().x;
                for (i = 0; i < labelStr.length(); ++i) {
                    String s;
                    x = this.modelToView((int)(i + this.getStartOffset()), (Shape)new Rectangle((int)r.width, (int)r.height), (Position.Bias)Position.Bias.Forward).getBounds().x - x0;
                    c = labelStr.charAt(i);
                    if (c == '\n' && !AppPreferences.invisiblesExcludeNewLine) {
                        if (this.getEndOffset() == sdoc.getLength() + 1) continue;
                        s = "\u00b6";
                        g.setFont(this.getFont());
                        int w = g.getFontMetrics().stringWidth(s);
                        Rectangle clip2 = new Rectangle(r.x + x, r.y, 2 * w, r.height);
                        oldClip2 = g.getClip();
                        g.setClip(clip2);
                        g.drawString(s, r.x + x, r.y + g.getFontMetrics().getMaxAscent());
                        g.setClip(oldClip2);
                        continue;
                    }
                    if (c == '\r') {
                        if (this.getEndOffset() == sdoc.getLength() + 1) continue;
                        s = "\u21b2";
                        g.setFont(this.getFont());
                        int w = g.getFontMetrics().stringWidth(s);
                        Rectangle clip3 = new Rectangle(r.x + x, r.y, 2 * w, r.height);
                        oldClip2 = g.getClip();
                        g.setClip(clip3);
                        g.drawString(s, r.x + x, r.y + g.getFontMetrics().getMaxAscent());
                        g.setClip(oldClip2);
                        continue;
                    }
                    if (c == '\t') {
                        s = "t";
                        Font font = this.getFont();
                        g.setFont(font.deriveFont(1, AppPreferences.tagsfontsize));
                        int w = g.getFontMetrics().stringWidth(s);
                        clip = new Rectangle(r.x + x, r.y, 2 * w, r.height);
                        oldClip = g.getClip();
                        oldColor = g.getColor();
                        g.setColor(new Color(AppPreferences.tagColor));
                        g.setClip(clip);
                        g.drawString(s, r.x + x, r.y + g.getFontMetrics().getMaxAscent());
                        g.setClip(oldClip);
                        g.setColor(oldColor);
                        continue;
                    }
                    if (c == ' ' && !AppPreferences.invisiblesExcludeSpace) {
                        s = "\u00b7";
                        g.setFont(this.getFont());
                        int w = g.getFontMetrics().stringWidth(s);
                        Rectangle clip4 = new Rectangle(r.x + x, r.y, 2 * w, r.height);
                        oldClip2 = g.getClip();
                        g.setClip(clip4);
                        g.drawString(s, r.x + x, r.y + g.getFontMetrics().getMaxAscent());
                        g.setClip(oldClip2);
                        continue;
                    }
                    if (c == '\u00a0') {
                        s = "\u02fd";
                        g.setFont(this.getFont());
                        int w = g.getFontMetrics().stringWidth(s);
                        Rectangle clip5 = new Rectangle(r.x + x, r.y, 2 * w, r.height);
                        oldClip2 = g.getClip();
                        g.setClip(clip5);
                        g.drawString(s, r.x + x, r.y + g.getFontMetrics().getMaxAscent());
                        g.setClip(oldClip2);
                        continue;
                    }
                    if (c != '\u3000') continue;
                    s = "\u02fe";
                    g.setFont(this.getFont());
                    int w = g.getFontMetrics().stringWidth(s);
                    Rectangle clip6 = new Rectangle(r.x + x, r.y, 2 * w, r.height);
                    oldClip2 = g.getClip();
                    g.setClip(clip6);
                    g.drawString(s, r.x + x, r.y + g.getFontMetrics().getMaxAscent());
                    g.setClip(oldClip2);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            sdoc = (StyledDocument)this.getDocument();
            try {
                labelStr = sdoc.getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
                x0 = this.modelToView((int)this.getStartOffset(), (Shape)new Rectangle((int)r.width, (int)r.height), (Position.Bias)Position.Bias.Forward).getBounds().x;
                for (i = 0; i < labelStr.length(); ++i) {
                    x = this.modelToView((int)(i + this.getStartOffset()), (Shape)new Rectangle((int)r.width, (int)r.height), (Position.Bias)Position.Bias.Forward).getBounds().x - x0;
                    c = labelStr.charAt(i);
                    if (c == '\u00a0') {
                        int x2 = this.modelToView((int)(i + 1 + this.getStartOffset()), (Shape)new Rectangle((int)r.width, (int)r.height), (Position.Bias)Position.Bias.Forward).getBounds().x - x0;
                        int w = 2;
                        Rectangle clip7 = new Rectangle(r.x + x, r.y, 2 * w, r.height);
                        oldClip2 = g.getClip();
                        g.setClip(clip7);
                        x += (x2 - x - w) / 2;
                        g.drawLine(r.x + x, r.y + r.height / 2, r.x + x + w, r.y + r.height / 2);
                        g.drawLine(r.x + x, r.y + r.height / 2 + 1, r.x + x + w, r.y + r.height / 2 + 1);
                        g.setClip(oldClip2);
                        continue;
                    }
                    if (c != '\t') continue;
                    String s = "t";
                    Font font = this.getFont();
                    g.setFont(font.deriveFont(1, AppPreferences.tagsfontsize));
                    int w = g.getFontMetrics().stringWidth(s);
                    clip = new Rectangle(r.x + x, r.y, 2 * w, r.height);
                    oldClip = g.getClip();
                    oldColor = g.getColor();
                    g.setColor(new Color(AppPreferences.tagColor));
                    g.setClip(clip);
                    g.drawString(s, r.x + x, r.y + g.getFontMetrics().getMaxAscent());
                    g.setClip(oldClip);
                    g.setColor(oldColor);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        boolean colorunderline = this.isColorUnderline();
        if (colorunderline) {
            g2d.setColor(Color.red);
            GlyphView.GlyphPainter painter = this.getGlyphPainter();
            int p0 = this.getStartOffset();
            int p1 = this.getEndOffset();
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            View parent = this.getParent();
            if (parent != null && parent.getEndOffset() == p1) {
                Segment s = this.getText(p0, p1);
                while (Character.isWhitespace(s.last())) {
                    --p1;
                    --s.count;
                }
                CTSegmentCache.releaseSharedSegment(s);
            }
            int x02 = alloc.x;
            int p = this.getStartOffset();
            if (p != p0) {
                x02 += (int)painter.getSpan(this, p, p0, this.getTabExpander(), x02);
            }
            int x1 = x02 + (int)painter.getSpan(this, p0, p1, this.getTabExpander(), x02);
            int y = alloc.y + alloc.height - (int)painter.getDescent(this);
            int yTmp = y + 2;
            g2d.setStroke(dashed);
            g2d.drawLine(x02, yTmp, x1, yTmp);
        } else {
            boolean termborder = this.isTermBorder();
            if (termborder) {
                GlyphView.GlyphPainter painter = this.getGlyphPainter();
                int p0 = this.getStartOffset();
                int p1 = this.getEndOffset();
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                View parent = this.getParent();
                if (parent != null && parent.getEndOffset() == p1) {
                    Segment s = this.getText(p0, p1);
                    CTSegmentCache.releaseSharedSegment(s);
                }
                int x03 = alloc.x;
                int p = this.getStartOffset();
                if (p != p0) {
                    x03 += (int)painter.getSpan(this, p, p0, this.getTabExpander(), x03);
                }
                if (this.isPatternUnderline()) {
                    g2d.setColor(Color.BLUE);
                    g2d.drawLine(x03 + 1, alloc.y - 1, x03 + alloc.width - 1, alloc.y - 1);
                    g2d.drawLine(x03 + 1, alloc.y + alloc.height + 1, x03 + alloc.width - 1, alloc.y + alloc.height + 1);
                } else if (!Colors.termBorderBright) {
                    g2d.setColor(this.termBackground.brighter());
                    g2d.drawLine(x03 + 1, alloc.y - 1, x03 + alloc.width - 2, alloc.y - 1);
                    g2d.setColor(this.termBackground.darker());
                    g2d.drawLine(x03 + alloc.width - 1, alloc.y, x03 + alloc.width - 1, alloc.y + alloc.height - 1);
                    g2d.drawLine(x03 + 1, alloc.y + alloc.height, x03 + alloc.width - 2, alloc.y + alloc.height);
                } else {
                    g2d.setColor(this.termBackground.brighter());
                    g2d.drawLine(x03 + 1, alloc.y - 1, x03 + alloc.width - 2, alloc.y - 1);
                    g2d.drawLine(x03 + alloc.width - 1, alloc.y, x03 + alloc.width - 1, alloc.y + alloc.height - 2);
                }
            }
        }
    }

    protected void setColorUnderline(boolean u) {
        this.colorUnderline = u;
    }

    public boolean isColorUnderline() {
        this.sync();
        return this.colorUnderline;
    }

    protected void setPatternUnderline(boolean u) {
        this.patternUnderline = u;
    }

    public boolean isPatternUnderline() {
        this.sync();
        return this.patternUnderline;
    }

    protected void setTermBorder(boolean b) {
        this.termBorder = b;
    }

    public boolean isTermBorder() {
        this.sync();
        return this.termBorder;
    }

    final void sync() {
        Font font = this.getFont();
        if (font == null) {
            this.setPropertiesFromAttributes();
        }
    }

    @Override
    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attr = this.getAttributes();
        if (attr != null) {
            Color background;
            this.setColorUnderline(TargetStyleConstants.isColorUnderline(attr));
            this.setPatternUnderline(TargetStyleConstants.isPatternUnderline(attr));
            boolean b = TargetStyleConstants.isTermBorder(attr);
            this.setTermBorder(b);
            if (b && (background = TargetStyleConstants.getTermBackground(attr)) != null) {
                this.termBackground = background;
            }
        }
    }
}

