/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.CharArrayWriter;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;

public class BitextHandler
extends DefaultHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    protected Memory memory;
    protected TMX tmx;
    private TMXReadOnlyUnitMap romap;
    protected String slang;
    protected String tlang;
    boolean readOnly;
    private Locator2 locator;

    public BitextHandler(Memory memory) {
        this.memory = memory;
        this.slang = memory.getSourceLangCode();
        int i = this.slang.indexOf(45);
        if (i != -1) {
            this.slang = this.slang.substring(0, i);
        }
        this.tlang = memory.getTargetLangCode();
        i = this.tlang.indexOf(45);
        if (i != -1) {
            this.tlang = this.tlang.substring(0, i);
        }
        this.readOnly = memory.isReadOnly();
        this.tmx = memory.getTMX();
        if (this.readOnly) {
            this.romap = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (locator instanceof Locator2) {
            this.locator = (Locator2)locator;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.locator != null) {
            String enc = this.locator.getEncoding();
            if (enc != null && enc.startsWith("UTF-8")) {
                enc = "UTF-8";
            }
            this.memory.encoding = enc;
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        DefaultXMLElement xml = new DefaultXMLElement(attr.getLength(), 1);
        for (int i = 0; i < attr.getLength(); ++i) {
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
        }
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            pxml.addChild(this.contents.toString());
        }
        xml.setName(qName);
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String name;
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            childXml.addChild(this.contents.toString());
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
        }
        if ((name = childXml.getName()).equals("seg")) {
            XMLElement xlang;
            XMLElement sourceElement = null;
            XMLElement targetElement = null;
            int i = 0;
            List list = childXml.getChildren("src");
            if (i < list.size()) {
                sourceElement = xlang = (XMLElement)list.get(i);
            }
            if ((i = 0) < (list = childXml.getChildren("tgt")).size()) {
                targetElement = xlang = (XMLElement)list.get(i);
            }
            if (sourceElement != null && targetElement != null) {
                String source = this.getTerm(sourceElement);
                String target = this.getTerm(targetElement);
                if (source.length() > 0 && target.length() > 0) {
                    if (this.readOnly) {
                        TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
                        tu.setSegment(this.slang, source);
                        tu.setSegment(this.tlang, target);
                        this.romap.load(tu);
                    } else {
                        int dup = this.memory.getDuplicatesMode();
                        this.tmx.update(source, target, null, null, null, dup);
                        this.memory.setNewTU();
                    }
                }
            }
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    private String getTerm(XMLElement element) {
        StringBuilder sb = new StringBuilder();
        List list = element.getChildren();
        for (Object next : list) {
            XMLElement elem;
            String s;
            if (next instanceof String) {
                sb.append(next.toString());
                continue;
            }
            if (!(next instanceof XMLElement) || (s = this.getTerm(elem = (XMLElement)next)).length() <= 0) continue;
            sb.append(s);
        }
        return sb.toString().trim();
    }
}

