/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.TranslationUnit;
import translator.tmx.TMX;
import translator.tmx.TMXResult;
import translator.tmx.TMXUnit;
import translator.ui.GridPopupMenu;
import translator.ui.HTMLFormat;

public class MemoryTip {
    String startTable = "<TABLE WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLPADDING=4 CELLSPACING=4>";
    String endTable = "</TABLE>";
    String sRow = "<TR>";
    String eRow = "</TR>";
    String sBLeftCol = "<TD WIDTH=50% BORDER=0 VALIGN=CENTER ALIGN=LEFT style='border-width: 1px; border-style: solid; border-color: gray'>";
    String sBLeftMarkedCol = "<TD WIDTH=50% VALIGN=CENTER ALIGN=LEFT style='border-width: 2px; border-style: solid; border-color: red'>";
    String eCol = "</TD>";
    private GridPopupMenu pop;

    private void setPopup() {
        this.pop = new GridPopupMenu();
        this.pop.setBorder(BorderFactory.createEmptyBorder());
        this.pop.setGrid(AppPreferences.backGrid);
        if (AppPreferences.background != 0) {
            this.pop.setBackground(new Color(AppPreferences.background));
        }
        this.pop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MemoryTip.this.pop.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                MemoryTip.this.pop.removeAll();
            }
        });
    }

    private void showTUToolTip(TranslationUnit tu, String[] sources, String[] targets, Component comp, int x, int y) {
        Object[] props;
        String type;
        int ssize = Toolkit.getDefaultToolkit().getScreenSize().width;
        int max = ssize / 2;
        Font f = new Font(AppPreferences.mfontname, AppPreferences.mfontstyle, AppPreferences.mfontsize);
        StringBuilder html = new StringBuilder();
        html.append("<HTML>");
        html.append("<BODY width=" + max + ">");
        html.append(this.startTable);
        String para = "<p style='background: " + HTMLFormat.htmlBackgroundColor + "; color: " + HTMLFormat.htmlForegroundColor + "'>";
        if (sources[0] != null && targets[0] != null) {
            html.append(this.sRow);
            html.append(this.sBLeftCol);
            html.append(para);
            html.append(sources[0]);
            html.append("</p>");
            html.append(this.eCol);
            html.append(this.sBLeftCol);
            html.append(para);
            html.append(targets[0]);
            html.append("</p>");
            html.append(this.eCol);
            html.append(this.eRow);
        }
        html.append(this.sRow);
        html.append(this.sBLeftMarkedCol);
        html.append(para);
        html.append(sources[1]);
        html.append("</p>");
        html.append(this.eCol);
        html.append(this.sBLeftMarkedCol);
        html.append(para);
        html.append(targets[1]);
        html.append("</p>");
        html.append(this.eCol);
        html.append(this.eRow);
        if (sources[2] != null && targets[2] != null) {
            html.append(this.sRow);
            html.append(this.sBLeftCol);
            html.append(para);
            html.append(sources[2]);
            html.append("</p>");
            html.append(this.eCol);
            html.append(this.sBLeftCol);
            html.append(para);
            html.append(targets[2]);
            html.append("</p>");
            html.append(this.eCol);
            html.append(this.eRow);
        }
        if (tu instanceof TMXUnit) {
            List notes;
            TMXUnit tux = (TMXUnit)tu;
            LinkedHashMap amap = tux.getAttributes();
            if (amap != null) {
                for (Map.Entry entry : amap.entrySet()) {
                    type = (String)entry.getKey();
                    String text = null;
                    if (type.equals("creationid")) {
                        type = "Creation ID";
                        text = (String)entry.getValue();
                    } else if (type.equals("creationdate")) {
                        type = "Creation Date";
                        text = (String)entry.getValue();
                        StringBuilder builder = new StringBuilder();
                        char[] arr = text.toCharArray();
                        int k = 0;
                        for (int i = 0; i < arr.length; ++i) {
                            char b = arr[i];
                            if (b == 'T') {
                                builder.append(", ");
                            } else if (k == 4 || k == 6) {
                                builder.append('-');
                                builder.append(b);
                            } else if (k == 11 || k == 13) {
                                builder.append(':');
                                builder.append(b);
                            } else if (b != 'Z') {
                                builder.append(b);
                            }
                            ++k;
                        }
                        text = builder.toString();
                    }
                    if (text == null || text.length() <= 0) continue;
                    html.append(this.sRow);
                    html.append(this.sBLeftCol);
                    html.append(para);
                    html.append("<b>");
                    html.append(type);
                    html.append(":</b> ");
                    html.append(text);
                    html.append("</p>");
                    html.append(this.eCol);
                    html.append(this.eRow);
                }
            }
            if ((notes = tux.getChildren("note")) != null && notes.size() > 0) {
                for (DefaultXMLElement c : notes) {
                    String con;
                    Object no = c.getContent(0);
                    if (no == null || (con = no.toString()).length() <= 0) continue;
                    con = con.replace("\n", "<br>");
                    html.append(this.sRow);
                    html.append(this.sBLeftCol);
                    html.append(para);
                    html.append("<i>");
                    html.append(con);
                    html.append("</i>");
                    html.append("</p>");
                    html.append(this.eCol);
                    html.append(this.eRow);
                }
            }
        }
        if ((props = tu.getProperties()) != null) {
            for (int i = 0; i < props.length; ++i) {
                String[] arr;
                Object object = props[i];
                if (object == null || (type = (arr = (String[])object)[0]).equals("target_tags")) continue;
                String cont = arr[1];
                html.append(this.sRow);
                html.append(this.sBLeftCol);
                html.append(para);
                html.append("<b>");
                html.append(type);
                html.append(":</b> ");
                html.append(cont);
                html.append("</p>");
                html.append(this.eCol);
                html.append(this.eRow);
            }
        }
        html.append(this.endTable);
        html.append("</BODY></HTML>");
        JLabel item = new JLabel();
        item.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                MemoryTip.this.hideInfo();
            }
        });
        item.setOpaque(true);
        item.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (HTMLFormat.htmlBackgroundColor.equals("white")) {
            item.setBackground(Color.white);
        } else {
            item.setBackground(new Color(AppPreferences.tbackground2));
        }
        item.setText(html.toString());
        item.setFont(f);
        if (this.pop == null) {
            this.setPopup();
        } else {
            this.pop.removeAll();
            this.pop.setVisible(false);
        }
        this.pop.add(item);
        this.pop.show(comp, x, y);
    }

    public void hideInfo() {
        if (this.pop != null) {
            this.pop.setVisible(false);
        }
    }

    public void showInfo(TMX tmx, String s, Component comp, int x, int y) {
        if (s.startsWith("#")) {
            Collection col = tmx.getTranslationUnits();
            TMXResult result = tmx.getTMXResult();
            int ind = s.indexOf(61);
            String s3 = ind != -1 ? s.substring(ind + 1, s.length()) : s.substring(1, s.length());
            if (s3.endsWith("#")) {
                s3 = s3.substring(0, s3.length() - 1);
            }
            int i = Integer.parseInt(s3);
            String sword = null;
            String tword = null;
            if (result != null && ind != -1) {
                String s2 = s.substring(1, ind);
                int j = Integer.parseInt(s2);
                sword = result.getSource(j);
                tword = result.getTarget(j);
                TranslationUnit tu = result.getTranslationUnit(i);
                if (tu != null) {
                    String slang = tmx.getTUMap().getSourceLang();
                    String source = tmx.getView().getSegmentXMLText(tu, slang);
                    if (sword != null && source != null && source.length() > sword.length()) {
                        StringBuffer sb = new StringBuffer();
                        Pattern p = Pattern.compile(sword, 18);
                        Matcher ma = p.matcher(source);
                        while (ma.find()) {
                            String g = ma.group();
                            ma.appendReplacement(sb, "<font color=#" + Integer.toHexString(AppPreferences.linkColor).substring(2) + "><b>" + g + "</b></font>");
                        }
                        ma.appendTail(sb);
                        source = sb.toString();
                    }
                    String tlang = tmx.getTUMap().getTargetLang();
                    String target = tmx.getView().getSegmentXMLText(tu, tlang);
                    if (tword != null && target != null && target.length() > tword.length()) {
                        StringBuffer sb = new StringBuffer();
                        Pattern p = Pattern.compile(tword, 18);
                        Matcher ma = p.matcher(target);
                        while (ma.find()) {
                            String g = ma.group();
                            ma.appendReplacement(sb, "<font color=#" + Integer.toHexString(AppPreferences.linkColor).substring(2) + "><b>" + g + "</b></font>");
                        }
                        ma.appendTail(sb);
                        target = sb.toString();
                    }
                    String[] sarr = new String[3];
                    String[] tarr = new String[3];
                    TranslationUnit tup = tu.getPreviousTranslationUnit();
                    if (tup != null) {
                        sarr[0] = tmx.getView().getSegmentXMLText(tup, slang);
                        tarr[0] = tmx.getView().getSegmentXMLText(tup, tlang);
                    }
                    sarr[1] = source;
                    tarr[1] = target;
                    TranslationUnit tun = tu.getNextTranslationUnit();
                    if (tun != null) {
                        sarr[2] = tmx.getView().getSegmentXMLText(tun, slang);
                        tarr[2] = tmx.getView().getSegmentXMLText(tun, tlang);
                    }
                    this.showTUToolTip(tu, sarr, tarr, comp, x, y);
                }
            } else if (i < col.size()) {
                ArrayList list;
                if (col instanceof List) {
                    list = (ArrayList)col;
                } else {
                    list = new ArrayList(col.size());
                    list.addAll(col);
                }
                TranslationUnit tu = (TranslationUnit)list.get(i);
                if (tu != null) {
                    String slang = tmx.getTUMap().getSourceLang();
                    String source = tmx.getView().getSegmentXMLText(tu, slang);
                    String tlang = tmx.getTUMap().getTargetLang();
                    String target = tmx.getView().getSegmentXMLText(tu, tlang);
                    String[] sarr = new String[3];
                    String[] tarr = new String[3];
                    TranslationUnit tup = tu.getPreviousTranslationUnit();
                    if (tup != null) {
                        sarr[0] = tmx.getView().getSegmentXMLText(tup, slang);
                        tarr[0] = tmx.getView().getSegmentXMLText(tup, tlang);
                    }
                    sarr[1] = source;
                    tarr[1] = target;
                    TranslationUnit tun = tu.getNextTranslationUnit();
                    if (tun != null) {
                        sarr[2] = tmx.getView().getSegmentXMLText(tun, slang);
                        tarr[2] = tmx.getView().getSegmentXMLText(tun, tlang);
                    }
                    this.showTUToolTip(tu, sarr, tarr, comp, x, y);
                }
            }
        }
    }
}

