/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.Converter;
import translator.DictionaryResource;
import translator.FileFilters;
import translator.FragmentMatch;
import translator.KeyPreferences;
import translator.MainClass;
import translator.MainView;
import translator.NumbersHelper;
import translator.Project;
import translator.ProjectView;
import translator.Resource;
import translator.ScrollPaneWatermark;
import translator.TabView;
import translator.TargetView;
import translator.TranslateEvent;
import translator.TranslationResult;
import translator.Workflow;
import translator.WorkflowManager;
import translator.XMLElement;
import translator.XMLHelper;
import translator.database.DatabaseView;
import translator.database.TermBase;
import translator.html.CTHTMLEditorKit;
import translator.server.RemoteMemory;
import translator.server.RendezVousServer;
import translator.server.RendezVousServerThread;
import translator.server.TMXRemoteDialog;
import translator.tmx.Memory;
import translator.tmx.MemoryTip;
import translator.tmx.TMX;
import translator.tmx.TMXBody;
import translator.tmx.TMXNewEntryEditor;
import translator.tmx.TMXView;
import translator.ui.GridPanel;
import translator.ui.UITools;
import translator.web.TMTown;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class MemoryView {
    private MainView parent;
    private JTextPane sourceTextArea;
    private JTextPane targetTextArea;
    private Memory defaultMemory;
    private Memory TotalRecallMemory;
    private TabView tview;
    private int newmemories = 0;
    private List remoteMemories;
    private List localMemories;
    private JMenu requestsMenu;
    private JMenu memoryMenu;
    public JMenuItem openMemoryItem;
    public JMenuItem saveMemoriesItem;
    private TMXNewEntryEditor memoryNewEntryEditor;
    private TranslateEvent event;
    public boolean mergeMemories;
    int mouseX;
    int mouseY;
    private MemoryTip memoryTip = new MemoryTip();
    boolean noMemoryForSegmentsInfo;
    boolean replaceWithTopPriority = true;

    public MemoryView(MainView parent) {
        this.parent = parent;
        this.tview = parent.getTabView();
        this.targetTextArea = parent.getTargetPane();
        this.sourceTextArea = parent.getSourcePane();
        this.setMemoryMenu();
        this.localMemories = new ArrayList();
        AssembleParser.setLocalMemories(this.localMemories);
    }

    public void close() {
        this.setTotalRecallMemory(null);
        this.noMemoryForSegmentsInfo = false;
    }

    public MemoryTip getMemoryTip() {
        return this.memoryTip;
    }

    public JMenu getMenu() {
        return this.memoryMenu;
    }

    private void setMemoryMenu() {
        this.memoryMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY"));
        JMenu segmentsMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION MEMORIES"));
        segmentsMenu.setName("MenuMemoryTranslationMemories");
        JMenuItem newSegmentsMemoryItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW MEMORY") + "...");
        newSegmentsMemoryItem.setName("MenuMemoryNewTranslationMemory");
        newSegmentsMemoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.newSegmentsMemory(true);
            }
        });
        this.memoryMenu.add(newSegmentsMemoryItem);
        this.memoryMenu.addSeparator();
        List list = this.parent.getResourceLoader().getLastSegmentMemories();
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            File file;
            String p = list.get(i).toString();
            if (p == null || p.length() <= 0 || !(file = new File(p)).exists()) continue;
            String n = file.getName();
            String nn = n.toLowerCase();
            if (!file.isDirectory() && !nn.endsWith(".tmx") && !nn.endsWith(".txt")) continue;
            JMenuItem item = new JMenuItem(n);
            item.setToolTipText(file.getPath());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem item = (JMenuItem)e.getSource();
                    File file = new File(item.getToolTipText());
                    String name = file.getName().toLowerCase();
                    String path = file.getPath();
                    if (name.endsWith(".tmx") || name.endsWith(".txt") || file.isDirectory()) {
                        Memory ntr = MemoryView.this.createSegmentsMemory(false);
                        ntr.setPath(path);
                        MemoryView.this.parent.getResourceLoader().loadMemory(ntr);
                    }
                }
            });
            if (count > 0 && count % 6 == 0) {
                segmentsMenu.addSeparator();
            }
            segmentsMenu.add(item);
            if (++count == 16) break;
        }
        this.openMemoryItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MEMORY..."));
        this.openMemoryItem.setName("MenuMemoryOpenMemory");
        KeyStroke ks = KeyPreferences.getKeyStroke("k32");
        if (ks != null) {
            this.openMemoryItem.setAccelerator(ks);
        }
        this.openMemoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(0, false);
            }
        });
        this.memoryMenu.add(this.openMemoryItem);
        JMenuItem openMemoryFolderItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MEMORIES FOLDER") + "...");
        openMemoryFolderItem.setName("MenuMemoryMergeMemories");
        openMemoryFolderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(0, true);
            }
        });
        this.memoryMenu.add(openMemoryFolderItem);
        JMenuItem loadMemoryItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN MEMORY") + "...");
        loadMemoryItem.setName("MenuMemoryJoinMemory");
        loadMemoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(1, MemoryView.this.mergeMemories);
            }
        });
        this.memoryMenu.add(loadMemoryItem);
        this.memoryMenu.add(segmentsMenu);
        JMenuItem close = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE MEMORY"));
        close.setName("MenuMemoryCloseMemory");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Memory tm = MemoryView.this.tview.getCurrentMemory();
                if (tm == null) {
                    JOptionPane.showMessageDialog(MemoryView.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TRANSLATION MEMORY"));
                } else {
                    tm.closeMemory();
                }
            }
        });
        this.memoryMenu.add(close);
        this.memoryMenu.addSeparator();
        JCheckBoxMenuItem mergeTMs = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT FILES IN FOLDER"));
        mergeTMs.setName("MenuMemoryMergeMemories");
        mergeTMs.setSelected(this.mergeMemories);
        mergeTMs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int i = e.getStateChange();
                MemoryView.this.mergeMemories = i == 1;
            }
        });
        this.memoryMenu.add(mergeTMs);
        JMenu importMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT"));
        importMenu.setName("MenuMemoryImport");
        this.memoryMenu.add(importMenu);
        JMenu exportMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT"));
        exportMenu.setName("MenuMemoryExport");
        this.memoryMenu.add(exportMenu);
        JMenuItem importExcel = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT MS EXCEL MEMORY..."));
        importExcel.setName("MenuMemoryImportMSExcelMemory");
        importExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(0, MemoryView.this.mergeMemories);
            }
        });
        JMenuItem importTBX = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT TBX TERMINOLOGY..."));
        importTBX.setName("MenuMemoryImportTBXTerminology");
        importTBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryTBXOpen(false);
            }
        });
        JMenuItem importMacGlossaries = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT MAC OS X GLOSSARIES..."));
        importMacGlossaries.setName("MenuMemoryImportMacOSXGlossaries");
        importMacGlossaries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(0, MemoryView.this.mergeMemories);
            }
        });
        JMenuItem importBitextTM = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT BITEXT MEMORY..."));
        importBitextTM.setName("MenuMemoryImportBitextMemory");
        importBitextTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(0, MemoryView.this.mergeMemories);
            }
        });
        JMenuItem importSDLTM = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT SDLTM MEMORY..."));
        importSDLTM.setName("MenuMemoryImportSDLTMMemory");
        importSDLTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(3, MemoryView.this.mergeMemories);
            }
        });
        JMenuItem importSDLTB = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT SDLTB TERMBASE..."));
        importSDLTB.setName("MenuMemoryImportSDLTBTermbase");
        importSDLTB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(3, MemoryView.this.mergeMemories);
            }
        });
        JMenuItem importMultitermGlossary = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT MULTITERM XML TERMBASE..."));
        importMultitermGlossary.setName("MenuMemoryImportMultitermXML");
        importMultitermGlossary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(6, MemoryView.this.mergeMemories);
            }
        });
        JMenuItem importWFTM = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT TAB DELIMITED MEMORY..."));
        importWFTM.setName("MenuMemoryImportTabDelimitedMemory");
        importWFTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryOpen(4, MemoryView.this.mergeMemories);
            }
        });
        JMenuItem importP = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT FROM PROJECT"));
        importP.setName("MenuMemoryImportSegsFromProject");
        importP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProjectView prview = MemoryView.this.parent.getProjectView();
                        Project project = prview.getProject();
                        List mems = MemoryView.this.getLocalMemories();
                        if (mems.size() > 0) {
                            MemoryView.this.startTaskForSingleTMDialog(mems, true);
                            Memory memory = null;
                            for (Memory m : mems) {
                                if (!m.isTaskReady()) continue;
                                m.setTaskReady(false);
                                memory = m;
                                break;
                            }
                            if (memory != null) {
                                Converter conv = new Converter(project, memory);
                                conv.setMainView(MemoryView.this.parent);
                                conv.toMemory();
                                memory.checkTrialVersionLimit();
                            }
                        } else {
                            JOptionPane.showMessageDialog(MemoryView.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TRANSLATION MEMORY"));
                        }
                    }
                });
            }
        });
        JMenuItem importR = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT GLOSSARY"));
        importR.setName("MenuMemoryImportEntriesFromGlossary");
        importR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabView tabview = MemoryView.this.parent.getTabView();
                Resource r = tabview.getCurrentResource();
                if (r instanceof DictionaryResource) {
                    DictionaryResource dictionary = (DictionaryResource)r;
                    List mems = MemoryView.this.getLocalMemories();
                    if (mems.size() > 0) {
                        MemoryView.this.startTaskForSingleTMDialog(mems, true);
                        Memory memory = null;
                        for (Memory m : mems) {
                            if (!m.isTaskReady()) continue;
                            m.setTaskReady(false);
                            memory = m;
                            break;
                        }
                        if (memory != null) {
                            Converter conv = new Converter(dictionary, memory);
                            conv.setMainView(MemoryView.this.parent);
                            conv.dictionaryToMemory();
                        }
                    } else {
                        JOptionPane.showMessageDialog(MemoryView.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TRANSLATION MEMORY"));
                    }
                } else {
                    JOptionPane.showMessageDialog(MemoryView.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A GLOSSARY TAB!"));
                }
            }
        });
        JMenuItem importPre = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT PRELIMINARY MATCHING MEMORY") + "...");
        importPre.setName("MenuMemoryImportPreTranslation");
        importPre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.importPretranslationNew();
            }
        });
        importMenu.add(importPre);
        importMenu.addSeparator();
        importMenu.add(importP);
        importMenu.add(importR);
        importMenu.add(importExcel);
        importMenu.add(importTBX);
        importMenu.add(importWFTM);
        importMenu.addSeparator();
        importMenu.add(importSDLTM);
        importMenu.add(importSDLTB);
        importMenu.add(importMultitermGlossary);
        importMenu.add(importMacGlossaries);
        importMenu.add(importBitextTM);
        JMenuItem exportPre = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT PRELIMINARY MATCHING MEMORY") + "...");
        exportPre.setName("MenuMemoryExportPreTranslation");
        exportPre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.exportPretranslationNew();
            }
        });
        JMenuItem exportR = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT TO CSV GLOSSARY"));
        exportR.setName("MenuMemoryExportSegmentsToGlossary");
        exportR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabView tabview = MemoryView.this.parent.getTabView();
                Resource r = tabview.getCurrentResource();
                if (r instanceof DictionaryResource) {
                    DictionaryResource dictionary = (DictionaryResource)r;
                    List mems = MemoryView.this.getLocalMemories();
                    if (mems.size() > 0) {
                        MemoryView.this.startTaskForSingleTMDialog(mems, false);
                        Memory memory = null;
                        for (Memory m : mems) {
                            if (!m.isTaskReady()) continue;
                            m.setTaskReady(false);
                            memory = m;
                            break;
                        }
                        if (memory != null) {
                            Converter conv = new Converter(dictionary, memory);
                            conv.setMainView(MemoryView.this.parent);
                            conv.memoryToDictionary();
                        }
                    } else {
                        JOptionPane.showMessageDialog(MemoryView.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TRANSLATION MEMORY"));
                    }
                } else {
                    JOptionPane.showMessageDialog(MemoryView.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A GLOSSARY TAB!"));
                }
            }
        });
        exportMenu.add(exportPre);
        exportMenu.add(exportR);
        this.memoryMenu.addSeparator();
        JMenuItem connmem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONNECT TO MEMORY SERVER..."));
        connmem.setName("MenuMemoryConnectToMemoryServer");
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SERVER_NETWORK, (int)connmem.getFont().getSize(), (Color)connmem.getForeground());
        connmem.setIcon((Icon)ficon);
        connmem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.connectRemoteMemory();
            }
        });
        this.memoryMenu.add(connmem);
        this.requestsMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY SERVER GUESTS"));
        this.requestsMenu.setName("MenuMemoryMemoryServerGuests");
        this.requestsMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                final JMenu menu = (JMenu)e.getItem();
                if (e.getStateChange() == 1) {
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 22 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.MemoryView.this.showRequestsMenu(menu);
                        }
                    });
                } else if (e.getStateChange() == 2) {
                    menu.removeAll();
                }
            }
        });
        this.memoryMenu.add(this.requestsMenu);
        this.memoryMenu.addSeparator();
        this.saveMemoriesItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE ALL MEMORIES"));
        this.saveMemoriesItem.setName("MenuMemorySaveAllMemories");
        ks = KeyPreferences.getKeyStroke("k33");
        if (ks != null) {
            this.saveMemoriesItem.setAccelerator(ks);
        }
        this.saveMemoriesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.saveMemories();
            }
        });
        this.memoryMenu.add(this.saveMemoriesItem);
        JMenuItem currsave = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE MEMORY"));
        currsave.setName("MenuMemorySaveMemory");
        currsave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List mems = MemoryView.this.getLocalMemories();
                if (mems.size() > 0) {
                    MemoryView.this.startTaskForSingleTMDialog(mems, true);
                    Memory memory = null;
                    for (Memory me : mems) {
                        if (!me.isTaskReady()) continue;
                        me.setTaskReady(false);
                        memory = me;
                        break;
                    }
                    if (memory != null) {
                        memory.saveMemory(false);
                    }
                } else {
                    JOptionPane.showMessageDialog(MemoryView.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TRANSLATION MEMORY"));
                }
            }
        });
        this.memoryMenu.add(currsave);
        JMenuItem saveAs = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE MEMORY AS..."));
        saveAs.setName("MenuMemorySaveMemoryAs");
        saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List mems = MemoryView.this.getLocalMemories();
                if (mems.size() > 0) {
                    MemoryView.this.startTaskForSingleTMDialog(mems, false);
                    Memory memory = null;
                    for (Memory me : mems) {
                        if (!me.isTaskReady()) continue;
                        me.setTaskReady(false);
                        memory = me;
                        break;
                    }
                    if (memory != null) {
                        memory.saveMemory(true);
                    }
                } else {
                    JOptionPane.showMessageDialog(MemoryView.this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TRANSLATION MEMORY"));
                }
            }
        });
        this.memoryMenu.add(saveAs);
        this.memoryMenu.addSeparator();
        JMenuItem storeTM = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STORE MEMORY IN TOTAL RECALL..."));
        storeTM.setName("MenuMemoryStoreMemoryInTotalRecall");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DATABASE, (int)storeTM.getFont().getSize(), (Color)storeTM.getForeground());
        storeTM.setIcon((Icon)ficon);
        storeTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.memoryToDatabase();
            }
        });
        JMenuItem recallTM = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RECALL MEMORY..."));
        recallTM.setName("MenuTRRecallToMemory");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)recallTM.getFont().getSize(), (Color)recallTM.getForeground());
        recallTM.setIcon((Icon)ficon);
        recallTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.TotalRecallToMemory();
            }
        });
        this.memoryMenu.add(recallTM);
        this.memoryMenu.add(storeTM);
    }

    private void showRequestsMenu(JMenu menu) {
        LinkedHashMap map;
        RendezVousServer rvs = MainClass.getServer();
        if (rvs != null && (map = rvs.getClients()) != null && map.size() > 0) {
            for (final String host : map.keySet()) {
                JMenuItem item = new JMenuItem(new AbstractAction(this, host){
                    final /* synthetic */ MemoryView this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        LinkedHashMap map;
                        Object o;
                        RendezVousServer rvs;
                        int i = JOptionPane.showConfirmDialog(this.this$0.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAY GOODBYE TO") + " " + host, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RENDEZVOUS SERVER"), 0);
                        if (i == 0 && (rvs = MainClass.getServer()) != null && (o = (map = rvs.getClients()).get(host)) != null) {
                            RendezVousServerThread thread = (RendezVousServerThread)o;
                            thread.close();
                        }
                    }
                });
                menu.add(item);
            }
        }
    }

    public List getRemoteMemories() {
        return this.remoteMemories;
    }

    public void connectRemoteMemory() {
        TMXRemoteDialog dlg = new TMXRemoteDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RENDEZVOUS SERVER CONNECTION"));
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        if (!dlg.cancelled && dlg.rm != null) {
            if (this.remoteMemories == null) {
                this.remoteMemories = new ArrayList();
            }
            if (!this.remoteMemories.contains(dlg.rm)) {
                this.remoteMemories.add(dlg.rm);
            }
        }
    }

    public void removeRemoteMemory(RemoteMemory rm) {
        if (this.remoteMemories != null) {
            this.remoteMemories.remove(rm);
        }
    }

    public List getLocalMemories() {
        return this.localMemories;
    }

    public void addLocalMemory(Memory m) {
        if (!this.localMemories.contains(m)) {
            this.localMemories.add(m);
        }
        this.defaultMemory = m;
    }

    public void removeLocalMemory(Memory rm) {
        this.localMemories.remove(rm);
        if (this.localMemories.isEmpty()) {
            this.defaultMemory = null;
        }
    }

    public void removeAllMemories() {
        this.localMemories.clear();
        if (this.remoteMemories != null) {
            this.remoteMemories.clear();
        }
    }

    public boolean memoryExists(String name1) {
        if (name1 != null && name1.length() > 0) {
            Memory m2;
            String name2;
            for (Object next : this.localMemories) {
                if (!(next instanceof Memory) || (name2 = (m2 = (Memory)next).getName()) == null || !name2.equals(name1)) continue;
                return true;
            }
            if (this.remoteMemories != null) {
                for (Object next : this.remoteMemories) {
                    if (!(next instanceof Memory) || (name2 = (m2 = (Memory)next).getName()) == null || !name2.equals(name1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void memoryToDatabase() {
        List mems = this.getLocalMemories();
        if (mems.size() > 0) {
            this.startTaskForSingleTMDialog(mems, false);
            Memory memory = null;
            for (Memory me : mems) {
                if (!me.isTaskReady()) continue;
                me.setTaskReady(false);
                memory = me;
                break;
            }
            if (memory != null) {
                memory.storeToDatabase();
            }
        } else {
            JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TRANSLATION MEMORY"));
        }
    }

    public void TotalRecallToMemory() {
        String n = AppPreferences.memoryTable != null ? AppPreferences.memoryTable : "";
        final Memory dataBaseTM = this.createTotalRecallMemory(n);
        dataBaseTM.showStartDialog("Total Recall");
        if (dataBaseTM.canLoad()) {
            AppPreferences.forSegmentsMemoryDB = dataBaseTM.getSegmentsMode();
            AppPreferences.forTermsMemoryDB = dataBaseTM.getTermsMode();
            AppPreferences.termsCheckMemoryDB = dataBaseTM.getTermsCheck();
            AppPreferences.readonlyMemoryDB = dataBaseTM.isReadOnly();
            AppPreferences.duplicatesMemoryDB = dataBaseTM.getDuplicatesMode();
            AppPreferences.priorityMemoryDB = dataBaseTM.getPriority();
            AppPreferences.matchCaseMemoryDB = dataBaseTM.getCaseMatch();
            AppPreferences.exactGreedyMatchMemoryDB = dataBaseTM.isGreedyMatching();
            AppPreferences.prefixMatchMemoryDB = dataBaseTM.getPrefixMatch();
            AppPreferences.workflowModeMemory = dataBaseTM.getWorkflowMode();
            final TermBase base = dataBaseTM.getTable();
            if (base != null) {
                String name;
                AppPreferences.memoryTable = name = base.getName();
                name = name + "_TM";
                if (this.parent.getTabView().tabExists(name)) {
                    JOptionPane.showMessageDialog(this.parent, "The TM already exists. Please close it to recall again.");
                    return;
                }
                dataBaseTM.setName(name);
                this.createTranslationTab(name, dataBaseTM);
                dataBaseTM.newTM(AppPreferences.initialCapacity);
                final JProgressBar bar = this.parent.getPretranslateProgressBar();
                bar.setIndeterminate(true);
                bar.setStringPainted(true);
                bar.setString("Recalling segments...");
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ MemoryView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        dataBaseTM.loadDatabaseTM(base);
                        return null;
                    }

                    @Override
                    protected void done() {
                        this.this$0.parent.removePretranslateProgressBar(bar);
                        this.this$0.addLocalMemory(dataBaseTM);
                    }
                };
                worker.execute();
            } else {
                JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A MEMORY TABLE!"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO DATABASE!"), 1);
            }
        }
    }

    public void newSegmentsMemory(boolean open) {
        if (open) {
            Memory tmxTM = this.createSegmentsMemory(true);
            this.newMemory(tmxTM);
        } else {
            Memory tmxTM = this.setMemoryDefaultOptions();
            if (tmxTM != null && tmxTM.canLoad()) {
                tmxTM.saveNewMemory();
            }
        }
    }

    public Memory createSegmentsMemory(boolean isNew) {
        Memory tmxTM = new Memory("");
        tmxTM.setMainView(this.parent);
        tmxTM.setEncoding(AppPreferences.en);
        if (AppPreferences.userid.length() > 0) {
            tmxTM.setUserID(AppPreferences.userid);
        }
        tmxTM.setMatchType(AppPreferences.matchType);
        tmxTM.setPrefixMatch(AppPreferences.prefixMatchMemory);
        if (AppPreferences.prefixMatchMemory) {
            tmxTM.setPrefixAccuracy(AppPreferences.memPrefixAccuracy);
        }
        if (isNew) {
            tmxTM.setNewlyAdded(true);
            tmxTM.setWorkflowMode(AppPreferences.workflowModeMemory);
            tmxTM.setSegmentsMode(AppPreferences.forSegmentsMemory);
            tmxTM.setTermsMode(AppPreferences.forTermsMemory);
            tmxTM.setTermsCheck(AppPreferences.termsCheckMemory);
            tmxTM.setReadOnly(AppPreferences.readonlyMemory);
            tmxTM.setPretranslateOnly(AppPreferences.pretranslateOnlyMemory);
            tmxTM.setDuplicatesMode(AppPreferences.duplicatesMemory);
            tmxTM.setWithTagPositions(AppPreferences.tagsPositionMemory);
            tmxTM.setPriority(AppPreferences.priorityMemory);
            tmxTM.setCaseMatch(AppPreferences.matchCaseMemory);
            tmxTM.setGreedyMatching(AppPreferences.exactGreedyMatchMemory);
        }
        return tmxTM;
    }

    public Memory createTotalRecallMemory(String name) {
        Memory dataBaseTM = new Memory("");
        dataBaseTM.setName(name);
        dataBaseTM.fromDatabase = true;
        dataBaseTM.setMainView(this.parent);
        dataBaseTM.setEncoding(AppPreferences.en);
        if (AppPreferences.userid.length() > 0) {
            dataBaseTM.setUserID(AppPreferences.userid);
        }
        dataBaseTM.setMatchType(AppPreferences.matchType);
        dataBaseTM.setPrefixMatch(AppPreferences.prefixMatchMemoryDB);
        if (AppPreferences.prefixMatchMemoryDB) {
            dataBaseTM.setPrefixAccuracy(AppPreferences.memPrefixAccuracy);
        }
        dataBaseTM.setWorkflowMode(AppPreferences.workflowModeMemory);
        dataBaseTM.setSegmentsMode(AppPreferences.forSegmentsMemoryDB);
        dataBaseTM.setTermsMode(AppPreferences.forTermsMemoryDB);
        dataBaseTM.setTermsCheck(AppPreferences.termsCheckMemoryDB);
        dataBaseTM.setReadOnly(AppPreferences.readonlyMemoryDB);
        dataBaseTM.setDuplicatesMode(AppPreferences.duplicatesMemoryDB);
        if (AppPreferences.priorityMemoryDB == 3) {
            dataBaseTM.stopAutoassembling(true);
        } else {
            dataBaseTM.setPriority(AppPreferences.priorityMemoryDB);
        }
        dataBaseTM.setCaseMatch(AppPreferences.matchCaseMemoryDB);
        dataBaseTM.setGreedyMatching(AppPreferences.exactGreedyMatchMemoryDB);
        return dataBaseTM;
    }

    public void setTotalRecallMemory(Memory m) {
        this.TotalRecallMemory = m;
    }

    public Memory getTotalRecallMemory() {
        return this.TotalRecallMemory;
    }

    public void newMemory() {
        Memory ntr = new Memory("");
        ntr.setMainView(this.parent);
        ntr.showStartDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW MEMORY"));
        if (ntr.canLoad()) {
            String name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY");
            if (this.newmemories > 0) {
                name = name + this.newmemories;
            }
            ++this.newmemories;
            ntr.setName(name);
            this.createTranslationTab(name, ntr);
            ntr.newTM(1000);
            TMX tmx = ntr.getTMX();
            if (tmx != null) {
                tmx.getTUMap().cancelProgress();
            }
            this.next();
            this.addLocalMemory(ntr);
            if (!ntr.isReadOnly()) {
                ntr.saveMemory(true);
            }
        }
    }

    public void newMemory(Memory ntr) {
        ntr.setMainView(this.parent);
        ntr.showStartDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW MEMORY"));
        if (ntr.canLoad()) {
            String name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY");
            if (this.newmemories > 0) {
                name = name + this.newmemories;
            }
            ++this.newmemories;
            ntr.setName(name);
            this.createTranslationTab(name, ntr);
            ntr.newTM(1000);
            TMX tmx = ntr.getTMX();
            if (tmx != null) {
                tmx.getTUMap().cancelProgress();
            }
            this.next();
            this.addLocalMemory(ntr);
            if (!ntr.isReadOnly()) {
                ntr.saveMemory(true);
            }
        }
    }

    public Memory newProjectMemory() {
        Memory projectTM = new Memory("");
        projectTM.setMainView(this.parent);
        projectTM.setEncoding(AppPreferences.en);
        if (AppPreferences.userid.length() > 0) {
            projectTM.setUserID(AppPreferences.userid);
        }
        projectTM.setMatchType(AppPreferences.matchType);
        projectTM.setPrefixMatch(AppPreferences.prefixMatchMemoryPR);
        if (AppPreferences.prefixMatchMemoryPR) {
            projectTM.setPrefixAccuracy(AppPreferences.memPrefixAccuracy);
        }
        projectTM.setWorkflowMode(0);
        projectTM.setSegmentsMode(AppPreferences.forSegmentsMemoryPR);
        projectTM.setTermsMode(AppPreferences.forTermsMemoryPR);
        projectTM.setTermsCheck(AppPreferences.termsCheckMemoryPR);
        projectTM.setWithTagPositions(true);
        projectTM.setDuplicatesMode(AppPreferences.duplicatesMemoryPR);
        projectTM.setPriority(AppPreferences.priorityMemoryPR);
        projectTM.setCaseMatch(AppPreferences.matchCaseMemoryPR);
        projectTM.setGreedyMatching(AppPreferences.exactGreedyMatchMemoryPR);
        projectTM.setName("ProjectTM");
        return projectTM;
    }

    public void setProjectMemory(Memory ntr) {
        ntr.setSourceLangCode(AppPreferences.fileSLang);
        ntr.setTargetLangCode(AppPreferences.fileTLang);
        this.createTranslationTab(ntr.getName(), ntr);
        ntr.newTM(1000);
        TMX tmx = ntr.getTMX();
        if (tmx != null) {
            tmx.getTUMap().cancelProgress();
        }
        this.next();
        this.addLocalMemory(ntr);
    }

    public void memoryOpen(final int mode, boolean folder) {
        String wloc;
        File f;
        final boolean merge = folder;
        final String dir = mode == 5 && AppPreferences.pretranslationDir.length() > 0 ? AppPreferences.pretranslationDir : (AppPreferences.memoryDirectory != null && AppPreferences.memoryDirectory.length() > 0 ? AppPreferences.memoryDirectory : (AppPreferences.operatingSystem == 0 ? ((f = new File(wloc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists() ? wloc : System.getProperty("user.home")) : System.getProperty("user.home")));
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ MemoryView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        if (!merge) {
                            File f;
                            FileChooser fileChooser = new FileChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MEMORY"));
                            if (dir != null && dir.length() > 0 && (f = new File(dir)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showOpenDialog(null);
                        } else {
                            File f;
                            DirectoryChooser fileChooser = new DirectoryChooser();
                            if (dir != null && dir.length() > 0 && (f = new File(dir)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showDialog(null);
                        }
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 30 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this$0.openMemoryType(file, this.this$1.mode);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 30 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.parent, s);
                            }
                        });
                    }
                }
            });
        } else {
            File f2 = new File(dir);
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            String[] mem = new String[]{"Memories"};
            FileFilters filters = new FileFilters();
            filters.setFileFilters(mem, "Memories", jFileChooser);
            jFileChooser.setSelectedFile(new File(""));
            jFileChooser.setCurrentDirectory(f2);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MEMORY"));
            jFileChooser.repaint();
            if (0 == jFileChooser.showOpenDialog(this.parent)) {
                File file = jFileChooser.getSelectedFile();
                this.openMemoryType(file, mode);
            }
        }
    }

    private void openMemoryType(File file, int mode) {
        String name = file.getName();
        if (file.isDirectory() || name.endsWith(".tmx") || name.endsWith(".TMX") || name.endsWith(".txt") || name.endsWith(".TXT") || name.endsWith(".sdltm") || name.endsWith(".SDLTM") || name.endsWith(".sdltb") || name.endsWith(".SDLTB") || name.endsWith(".lg") || name.endsWith(".LG") || name.endsWith(".sdlppx") || name.endsWith(".SDLPPX") || name.endsWith(".xlsx") || name.endsWith(".XLSX") || name.endsWith(".xml") || name.endsWith(".XML")) {
            if (mode == 5) {
                AppPreferences.pretranslationDir = file.getParent();
            } else {
                AppPreferences.memoryDirectory = file.getParent();
            }
            String path = file.getPath();
            if (mode == 0) {
                this.parent.getResourceLoader().startMemory(path, false);
            } else if (mode == 1) {
                this.importMemoryToTMX(path);
            } else if (mode == 2) {
                this.loadMemoryToTable(path);
            } else if (mode == 3 || mode == 4 || mode == 6) {
                this.parent.getResourceLoader().startExternalMemory(path, mode);
            } else if (mode == 5) {
                Memory ntr = this.createSegmentsMemory(true);
                ntr.setReadOnly(true);
                ntr.setPath(path);
                this.parent.getResourceLoader().startPretranslationMemory(ntr);
            }
        }
    }

    public void importPretranslationNew() {
        this.memoryOpen(5, this.mergeMemories);
    }

    public void exportPretranslationNew() {
        final String dir = AppPreferences.pretranslationDir != null && AppPreferences.pretranslationDir.length() > 0 ? AppPreferences.pretranslationDir : "";
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ MemoryView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File f;
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE PRELIMINARY MATCHING MEMORY"));
                        if (dir != null && dir.length() > 0 && (f = new File(dir)).isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        fileChooser.setInitialFileName("Pretranslation.tmx");
                        final File file = fileChooser.showSaveDialog(null);
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 31 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    AppPreferences.pretranslationDir = file.getPath();
                                    HashSet units = new HashSet(1000);
                                    List mems = this.this$1.this$0.getLocalMemories();
                                    for (Memory m : mems) {
                                        String mn = m.getName();
                                        if (mn == null || mn.length() <= 0) continue;
                                        m.collectPretranslatedTUs(units);
                                    }
                                    if (!units.isEmpty()) {
                                        Memory m = new Memory(file.getPath());
                                        m.setMainView(this.this$1.this$0.parent);
                                        m.setUserID(AppPreferences.userid);
                                        m.setSourceLangCode(AppPreferences.fileSLang);
                                        m.newTMX();
                                        TMX tmx = m.getTMX();
                                        TMXBody body = tmx.getBody();
                                        body.setTUPretranslationSet(units);
                                        m.saveMemory(false);
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 31 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.parent, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            String[] mem = new String[]{"Memories"};
            FileFilters filters = new FileFilters();
            filters.setFileFilters(mem, "Memories", jFileChooser);
            File f = new File(dir);
            if (f.exists()) {
                jFileChooser.setCurrentDirectory(f);
            } else {
                jFileChooser.setCurrentDirectory(null);
            }
            jFileChooser.setSelectedFile(new File("Pretranslation.tmx"));
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE PRELIMINARY MATCHING MEMORY"));
            if (0 == jFileChooser.showSaveDialog(this.parent)) {
                File file = jFileChooser.getSelectedFile();
                AppPreferences.pretranslationDir = file.getPath();
                HashSet units = new HashSet(1000);
                List mems = this.getLocalMemories();
                for (Memory m : mems) {
                    String mn = m.getName();
                    if (mn == null || mn.length() <= 0) continue;
                    m.collectPretranslatedTUs(units);
                }
                if (!units.isEmpty()) {
                    Memory m = new Memory(file.getPath());
                    m.setMainView(this.parent);
                    m.setUserID(AppPreferences.userid);
                    m.setSourceLangCode(AppPreferences.fileSLang);
                    m.newTMX();
                    TMX tmx = m.getTMX();
                    TMXBody body = tmx.getBody();
                    body.setTUPretranslationSet(units);
                    m.saveMemory(false);
                }
            }
        }
    }

    public void memoryTBXOpen(final boolean toTable) {
        String wloc;
        File f;
        final String dir = AppPreferences.memoryDirectory != null && AppPreferences.memoryDirectory.length() > 0 ? AppPreferences.memoryDirectory : (AppPreferences.operatingSystem == 0 ? ((f = new File(wloc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists() ? wloc : System.getProperty("user.home")) : System.getProperty("user.home"));
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ MemoryView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        if (!this.this$0.mergeMemories) {
                            File f;
                            FileChooser fileChooser = new FileChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MEMORY"));
                            if (dir != null && dir.length() > 0 && (f = new File(dir)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showOpenDialog(null);
                        } else {
                            File f;
                            DirectoryChooser fileChooser = new DirectoryChooser();
                            if (dir != null && dir.length() > 0 && (f = new File(dir)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showDialog(null);
                        }
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 32 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    AppPreferences.memoryDirectory = file.getParent();
                                    String path = file.getPath();
                                    if (!this.this$1.toTable) {
                                        this.this$1.this$0.parent.getResourceLoader().importMemory(path, 0);
                                    } else {
                                        this.this$1.this$0.loadMemoryToTable(path);
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 32 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.parent, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            f = new File(dir);
            jFileChooser.setSelectedFile(new File(""));
            jFileChooser.setCurrentDirectory(f);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN MEMORY"));
            jFileChooser.repaint();
            if (0 == jFileChooser.showOpenDialog(this.parent)) {
                File file = jFileChooser.getSelectedFile();
                AppPreferences.memoryDirectory = file.getParent();
                String path = file.getPath();
                if (!toTable) {
                    this.parent.getResourceLoader().importMemory(path, 0);
                } else {
                    this.loadMemoryToTable(path);
                }
            }
        }
    }

    public void loadMemoryToTable(String mpath) {
        TermBase base;
        DatabaseView dbview = this.parent.getDatabaseView();
        List list = dbview.getTableNames();
        if (list.isEmpty()) {
            dbview.makeTable();
            list = dbview.getTableNames();
            if (list.isEmpty()) {
                return;
            }
        }
        Memory ntr = new Memory(mpath);
        ntr.setMainView(this.parent);
        ntr.toDatabase = true;
        int i = mpath.lastIndexOf(AppPreferences.fs);
        String title = null;
        if (i != -1) {
            title = mpath.substring(i + 1);
        }
        ntr.showImportDialog(title);
        if (ntr.canLoad() && (base = ntr.getTable()) != null) {
            ntr.loadToTable();
        }
    }

    public void importMemoryToTMX(String mpath) {
        Memory m = this.parent.getProjectView().getProject().getTMXMemory();
        if (m != null) {
            m.importTM(mpath);
        } else {
            List mems = this.getLocalMemories();
            if (mems.size() > 0) {
                this.startTaskForSingleTMDialog(mems, true);
                Memory memory = null;
                for (Memory me : mems) {
                    if (!me.isTaskReady()) continue;
                    me.setTaskReady(false);
                    memory = me;
                    break;
                }
                if (memory != null) {
                    memory.importTM(mpath);
                }
            } else {
                JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TRANSLATION MEMORY"));
            }
        }
    }

    public void createTranslationTab(String name, Memory m) {
        File file;
        JTextPane memoryTextPane = new JTextPane();
        memoryTextPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        memoryTextPane.putClientProperty("type", "memory");
        MemoryHyperactive mh = new MemoryHyperactive();
        mh.setMemory(m);
        memoryTextPane.addHyperlinkListener(mh);
        memoryTextPane.setContentType("text/html");
        Graphics g = memoryTextPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            Color foreground = new Color(AppPreferences.foreground);
            background = new Color(AppPreferences.background);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.parent.toAlphaColor(selection, 127);
            }
            memoryTextPane.setCaretColor(foreground);
            memoryTextPane.setBackground(background);
            memoryTextPane.setForeground(foreground);
            memoryTextPane.setSelectionColor(selection);
            memoryTextPane.setSelectedTextColor(foreground);
        }
        memoryTextPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        memoryTextPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MemoryView.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        memoryTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                boolean ctrl = UITools.isShortcutDown(evt);
                if (!ctrl) {
                    String sel;
                    String sel2;
                    int cc;
                    JTextPane memoryPane = (JTextPane)evt.getSource();
                    if (evt.getButton() == 1 && (cc = evt.getClickCount()) < 2 && (sel2 = memoryPane.getSelectedText()) != null && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                        try {
                            int spos = Utilities.getWordStart(memoryPane, memoryPane.getSelectionStart());
                            int epos = Utilities.getWordEnd(memoryPane, memoryPane.getSelectionEnd() - 1);
                            memoryPane.setSelectionStart(spos);
                            memoryPane.setSelectionEnd(epos);
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((sel = memoryPane.getSelectedText()) != null && !sel.endsWith("\u200b")) {
                        TargetView pview = MemoryView.this.parent.getTargetView();
                        pview.grabSelection(sel);
                    }
                }
            }
        });
        memoryTextPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MemoryView.this.mouseX = evt.getX();
                MemoryView.this.mouseY = evt.getY();
            }
        });
        memoryTextPane.setEditable(false);
        Style sstyle = memoryTextPane.addStyle("highlight", null);
        Color segment = new Color(AppPreferences.segment);
        StyleConstants.setForeground(sstyle, segment);
        m.setMemoryPane(memoryTextPane);
        JScrollPane jScrollPane = new JScrollPane();
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            memoryTextPane.setBackground(new Color(0, 0, 0, 0));
            memoryTextPane.setOpaque(false);
        }
        jScrollPane.getViewport().add((Component)memoryTextPane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)memoryTextPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(memoryTextPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.parent.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(MemoryView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)jScrollPane, "Center");
        String uid = m.getUID();
        if (uid != null) {
            panel.setName(uid);
        }
        this.tview.addTab(m, name, panel);
    }

    public void highlightTU(int i) {
        Memory ctm = this.getMemory();
        if (ctm != null) {
            try {
                String text;
                int tusection;
                HTMLDocument doc = ctm.getMemoryDoc();
                JTextPane pane = ctm.getMemoryPane();
                Style style = pane.getStyle("highlight");
                if (style == null) {
                    style = pane.addStyle("highlight", null);
                    Color segment = new Color(AppPreferences.segment);
                    StyleConstants.setForeground(style, segment);
                }
                if ((tusection = (text = doc.getText(0, doc.getLength())).lastIndexOf("TU")) != -1) {
                    String ii = Integer.toString(i);
                    int index = text.indexOf(ii, tusection);
                    if (index != -1) {
                        doc.setCharacterAttributes(index, ii.length(), style, false);
                    } else {
                        this.next();
                        text = doc.getText(0, doc.getLength());
                        index = text.indexOf(ii);
                        if (index != -1) {
                            doc.setCharacterAttributes(index, ii.length(), style, false);
                        }
                    }
                }
            }
            catch (Exception ble) {
                ble.printStackTrace();
            }
        }
    }

    public void next() {
        Memory ctm = this.getMemory();
        if (ctm != null) {
            ctm.nextTUS();
        }
    }

    public void previous() {
        Memory ctm = this.getMemory();
        if (ctm != null) {
            ctm.previousTUS();
        }
    }

    public void stopSearch() {
        if (this.event != null) {
            this.event.cancelAllThreads();
            this.event.clearAutoMatch();
        }
    }

    public synchronized void searchMemories(String s, String r, int mode) {
        if (s.length() == 0) {
            return;
        }
        for (Object object : this.localMemories) {
            Memory m = (Memory)object;
            boolean ro = m.isReadOnly();
            if (ro && r != null) continue;
            m.searchMemory(s, r, mode);
        }
        this.parent.getFocusedTextComponent().requestFocus();
    }

    public void showTMMessage(Memory ctm, String mes) {
        HTMLDocument cmemoryDoc = ctm.getMemoryDoc();
        try {
            cmemoryDoc.setInnerHTML(cmemoryDoc.getDefaultRootElement(), mes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearTMPane(Memory ctm) {
        HTMLDocument cmemoryDoc = ctm.getMemoryDoc();
        int len = cmemoryDoc.getLength();
        if (len > 0) {
            try {
                cmemoryDoc.remove(0, len);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TranslateEvent getTranslateEvent() {
        return this.event;
    }

    public void translateSegment(String queryTM, String queryGlossary, String queryAA, String queryTagged, boolean auto) {
        this.stopSearch();
        this.event = new TranslateEvent(this.parent);
        this.event.setTranslateText(queryTM, queryGlossary, queryAA, queryTagged);
        this.event.translateSegment(auto);
    }

    public String translateForExactMatches(String query, String processedQuery, XMLElement unit) {
        this.event = new TranslateEvent(this.parent);
        this.event.setTranslateText(query, null, null, null);
        String s = this.event.translateForExactMatches(processedQuery, unit);
        return s;
    }

    public boolean translateForTargetsDifferenceCheck(String query, XMLElement unit) {
        TranslateEvent event = new TranslateEvent(this.parent);
        event.setTranslateText(query, null, null, null);
        boolean b = event.translateForTargetsDifferenceCheck(unit);
        return b;
    }

    public int addToRemoteMemory(String[] s) {
        int count = 0;
        if (this.remoteMemories != null) {
            for (Object object : this.remoteMemories) {
                RemoteMemory rm = (RemoteMemory)object;
                if (rm.readonly) continue;
                rm.update(s);
                ++count;
            }
        }
        return count;
    }

    private int addToLocalMemory(String key, String value) {
        int count = 0;
        String nkey = XMLHelper.parseTags(key);
        String nvalue = XMLHelper.parseTags(value);
        if (nkey.length() > 0 && nvalue.length() > 0) {
            for (Object object : this.localMemories) {
                Memory m = (Memory)object;
                boolean ro = m.isReadOnly();
                boolean segs = m.getSegmentsMode();
                if (ro || !segs) continue;
                boolean tp = m.hasTagPostions();
                if (tp) {
                    int[] tags = XMLHelper.calculateTagsPosition(value);
                    if (tags.length > 0) {
                        m.updateMemoryWithTags(nkey, nvalue, tags);
                        ++count;
                        continue;
                    }
                    m.updateMemory(nkey, nvalue, null, null);
                    ++count;
                    continue;
                }
                m.updateMemory(nkey, nvalue, null, null);
                ++count;
            }
        }
        return count;
    }

    public int addToWebService(String s, String t) {
        TMTown tmtown;
        int count = 0;
        if (s.length() > 0 && t.length() > 0 && (tmtown = this.parent.getResourceView().getTMTownService()) != null) {
            tmtown.addSegmentToWebService(s, t);
            ++count;
        }
        return count;
    }

    public void addToMemory() {
        Document sdoc = this.sourceTextArea.getDocument();
        Document tdoc = this.targetTextArea.getDocument();
        int count = 0;
        try {
            String key = sdoc.getText(0, sdoc.getLength());
            String value = tdoc.getText(0, tdoc.getLength());
            if (AppPreferences.matchHiddenPlaceables) {
                key = XMLHelper.parseHiddenTags(key, true);
                value = XMLHelper.parseHiddenTags(value, false);
            }
            count += this.addToLocalMemory(key, value);
            String[] s = new String[]{key, value};
            count += this.addToRemoteMemory(s);
            if (AppPreferences.tmTownAddSegments) {
                count += this.addToWebService(key, value);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(MemoryView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addPhraseDirectToMemory() {
        JTextPane sp = this.parent.getSourcePane();
        JTextPane tp = this.parent.getTargetPane();
        String key = sp.getSelectedText();
        String entry = tp.getSelectedText();
        if (key == null) {
            key = sp.getText();
        }
        if (entry == null) {
            entry = tp.getText();
        }
        if (key != null && key.length() > 0 && entry != null && entry.length() > 0) {
            int cp;
            if (AppPreferences.trimNewterm) {
                key = XMLHelper.trimNewTermStart(key);
                key = XMLHelper.trimNewTermEnd(key);
                entry = XMLHelper.trimNewTermStart(entry);
                entry = XMLHelper.trimNewTermEnd(entry);
            }
            this.addFragmentToMemory(key, entry, null, null);
            if (this.event != null) {
                this.event.addNewFragmentsToMatchBoard();
            }
            if ((cp = sp.getSelectionEnd()) != -1) {
                sp.setCaretPosition(cp);
            }
            if ((cp = tp.getSelectionEnd()) != -1) {
                tp.setCaretPosition(cp);
            }
        }
    }

    public void addPhraseDirectToMemory(Memory memory) {
        JTextPane sp = this.parent.getSourcePane();
        JTextPane tp = this.parent.getTargetPane();
        String key = sp.getSelectedText();
        String entry = tp.getSelectedText();
        if (key != null && key.length() > 0 && entry != null && entry.length() > 0) {
            int cp;
            if (AppPreferences.trimNewterm) {
                key = XMLHelper.trimNewTermStart(key);
                key = XMLHelper.trimNewTermEnd(key);
                entry = XMLHelper.trimNewTermStart(entry);
                entry = XMLHelper.trimNewTermEnd(entry);
            }
            this.addFragmentToMemory(memory, key, entry, null, null);
            if (this.event != null) {
                this.event.addNewFragmentsToMatchBoard();
            }
            if ((cp = sp.getSelectionEnd()) != -1) {
                sp.setCaretPosition(cp);
            }
            if ((cp = tp.getSelectionEnd()) != -1) {
                tp.setCaretPosition(cp);
            }
        }
    }

    public void addFragmentToMemory(String key, String value, String note, Map map) {
        Memory m;
        String nkey = XMLHelper.parseTags(key);
        String nvalue = XMLHelper.parseTags(value);
        FragmentMatch fmatch = new FragmentMatch(nkey, nkey, nvalue, "New", false, 1, 1, 0, 0, 0);
        if (this.event != null) {
            this.event.addFragmentMatch(fmatch);
        }
        if (AssembleParser.isSegmentPattern(nkey)) {
            if (nkey.length() > 0 && nkey.charAt(0) != '?' && nkey.charAt(0) != '|') {
                nkey = "?" + nkey;
            }
            if (nvalue.length() > 0 && nvalue.charAt(0) != '?' && nvalue.charAt(0) != '|') {
                nvalue = "?" + nvalue;
            }
        }
        for (Object object : this.localMemories) {
            Memory m2 = (Memory)object;
            boolean terms = m2.getTermsMode();
            boolean ro = m2.isReadOnly();
            boolean bl = m2.isBlocked();
            if (ro || bl || !terms) continue;
            m2.updateMemory(nkey, nvalue, note, map);
            m2.getTMX().getView().refreshView();
        }
        Project p = this.parent.getProjectView().getProject();
        if (p != null && (m = p.getTMXMemory()) != null) {
            boolean ro = m.isReadOnly();
            boolean bl = m.isBlocked();
            if (!bl && !ro) {
                m.updateMemory(nkey, nvalue, note, map);
                m.getTMX().getView().refreshView();
            }
        }
        String[] s = new String[]{key, value};
        this.addToRemoteMemory(s);
    }

    public void addFragmentToMemory(Memory m, String key, String value, String note, Map map) {
        String nkey = XMLHelper.parseTags(key);
        String nvalue = XMLHelper.parseTags(value);
        FragmentMatch fmatch = new FragmentMatch(nkey, nkey, nvalue, "New", false, 1, 1, 0, 0, 0);
        if (this.event != null) {
            this.event.addFragmentMatch(fmatch);
        }
        if (AssembleParser.isSegmentPattern(nkey)) {
            if (nkey.length() > 0 && nkey.charAt(0) != '?' && nkey.charAt(0) != '|') {
                nkey = "?" + nkey;
            }
            if (nvalue.length() > 0 && nvalue.charAt(0) != '?' && nvalue.charAt(0) != '|') {
                nvalue = "?" + nvalue;
            }
        }
        boolean terms = m.getTermsMode();
        boolean ro = m.isReadOnly();
        boolean bl = m.isBlocked();
        if (!ro && !bl && terms) {
            m.updateMemory(nkey, nvalue, note, map);
            m.getTMX().getView().refreshView();
        }
    }

    public boolean hasFragmentsTM() {
        List li = this.getLocalMemories();
        if (li != null) {
            for (Object object : li) {
                Memory m = (Memory)object;
                boolean ro = m.isReadOnly();
                boolean terms = m.getTermsMode();
                if (ro || !terms) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRemoteTM() {
        List li = this.getRemoteMemories();
        if (li != null && li.size() > 0) {
            for (Object object : li) {
                RemoteMemory rm = (RemoteMemory)object;
                if (rm.readonly) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasProjectTM() {
        String name;
        boolean ro;
        Memory m;
        Project p = this.parent.getProjectView().getProject();
        return p != null && (m = p.getTMXMemory()) != null && !(ro = m.isReadOnly()) && (name = p.getName()) != null;
    }

    public void newMemoryEntry() {
        Dimension dlgSize;
        if (!(this.hasFragmentsTM() || this.hasProjectTM() || this.hasRemoteTM())) {
            JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENTS MEMORY IS NOT OPEN."));
            return;
        }
        String key = this.sourceTextArea.getSelectedText();
        if (key == null) {
            key = "";
        } else {
            this.sourceTextArea.setCaretPosition(this.sourceTextArea.getSelectionEnd());
        }
        String entry = this.targetTextArea.getSelectedText();
        if (entry == null) {
            entry = "";
        } else {
            this.targetTextArea.setCaretPosition(this.targetTextArea.getSelectionEnd());
        }
        if (this.memoryNewEntryEditor != null && this.memoryNewEntryEditor.isVisible()) {
            this.memoryNewEntryEditor.setKey(key);
            this.memoryNewEntryEditor.setEntry(entry);
            return;
        }
        this.memoryNewEntryEditor = new TMXNewEntryEditor(this.parent);
        this.memoryNewEntryEditor.setKey(key);
        this.memoryNewEntryEditor.setEntry(entry);
        if (AppPreferences.newEntryDialogWidth > 50 && AppPreferences.newEntryDialogHeight > 50) {
            dlgSize = new Dimension(AppPreferences.newEntryDialogWidth, AppPreferences.newEntryDialogHeight);
            this.memoryNewEntryEditor.setSize(dlgSize);
        } else {
            dlgSize = this.memoryNewEntryEditor.getPreferredSize();
        }
        if (AppPreferences.newEntryDialogPosX > -1 && AppPreferences.newEntryDialogPosY > -1) {
            this.memoryNewEntryEditor.setLocation(AppPreferences.newEntryDialogPosX, AppPreferences.newEntryDialogPosY);
        } else {
            Dimension frmSize = this.parent.getSize();
            Point loc = this.parent.getLocationOnScreen();
            this.memoryNewEntryEditor.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.memoryNewEntryEditor.setVisible(true);
    }

    public void newMemoryEntry(String key, String entry) {
        Dimension dlgSize;
        if (!(this.hasFragmentsTM() || this.hasProjectTM() || this.hasRemoteTM())) {
            JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENTS MEMORY IS NOT OPEN."));
            return;
        }
        if (this.memoryNewEntryEditor != null && this.memoryNewEntryEditor.isVisible()) {
            if (key != null) {
                this.memoryNewEntryEditor.setKey(key);
            }
            if (entry != null) {
                this.memoryNewEntryEditor.setEntry(entry);
            }
            return;
        }
        this.memoryNewEntryEditor = new TMXNewEntryEditor(this.parent);
        if (key != null) {
            this.memoryNewEntryEditor.setKey(key);
        }
        if (entry != null) {
            this.memoryNewEntryEditor.setEntry(entry);
        }
        if (AppPreferences.newEntryDialogWidth > 50 && AppPreferences.newEntryDialogHeight > 50) {
            dlgSize = new Dimension(AppPreferences.newEntryDialogWidth, AppPreferences.newEntryDialogHeight);
            this.memoryNewEntryEditor.setSize(dlgSize);
        } else {
            dlgSize = this.memoryNewEntryEditor.getPreferredSize();
        }
        if (AppPreferences.newEntryDialogPosX > -1 && AppPreferences.newEntryDialogPosY > -1) {
            this.memoryNewEntryEditor.setLocation(AppPreferences.newEntryDialogPosX, AppPreferences.newEntryDialogPosY);
        } else {
            Dimension frmSize = this.parent.getSize();
            Point loc = this.parent.getLocationOnScreen();
            this.memoryNewEntryEditor.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.memoryNewEntryEditor.setVisible(true);
    }

    public TMXNewEntryEditor getMemoryNewEntryEditor() {
        return this.memoryNewEntryEditor;
    }

    public Memory getMemory(String name) {
        Memory m = null;
        for (Memory next : this.localMemories) {
            String n = next.getName();
            if (n == null || !n.equals(name)) continue;
            m = next;
            break;
        }
        return m;
    }

    public Memory getMemory() {
        Memory tm = this.tview.getCurrentMemory();
        if (tm != null) {
            return tm;
        }
        return this.defaultMemory;
    }

    public void insertMatch(String s) {
        try {
            int pos = this.targetTextArea.getCaretPosition();
            Document doc = this.targetTextArea.getDocument();
            String sel = this.targetTextArea.getSelectedText();
            if (sel != null) {
                pos = this.targetTextArea.getSelectionStart();
                doc.remove(pos, sel.length());
            }
            doc.insertString(pos, s, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TMXView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setBestMatch(String target, int percent, int type) {
        try {
            Document sdoc = this.sourceTextArea.getDocument();
            String source = sdoc.getText(0, sdoc.getLength());
            if (AppPreferences.autonumbers && percent < 100) {
                target = NumbersHelper.autoTransfer(source, target);
            }
            TranslateEvent transEvent = this.getTranslateEvent();
            if (AppPreferences.autotags && transEvent != null) {
                target = this.parent.getMatchBoard().transferSegmentTags(source, target, transEvent);
            }
            target = this.parent.getMatchBoard().matchHiddenNontranslatables(target);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(MemoryView.class.getName()).log(Level.SEVERE, null, ex);
        }
        Workflow w = this.parent.getWorkflowView().getWorkflowManager().getWorkflow();
        if (w != null) {
            XLIFFUnit tu;
            w.setTarget(target);
            XLIFF xliff = this.parent.getProjectView().getProject().getXLIFF();
            if (xliff != null && (tu = xliff.getWorkflow().getCheckTransUnit()) != null) {
                this.parent.getTargetView().setEdited(false);
                tu.removeMatch(false);
                boolean storeMatch = false;
                if (xliff.isCafeTranXLIFF) {
                    storeMatch = true;
                }
                tu.setMatch(percent, type, storeMatch);
            }
        }
    }

    public void insertBestAutoMatch(TranslateEvent transEvent) {
        String bestTranslation = transEvent.getBestTranslation();
        if (bestTranslation == null) {
            return;
        }
        try {
            Document tdoc = this.targetTextArea.getDocument();
            String ot = tdoc.getText(0, tdoc.getLength());
            Document sdoc = this.sourceTextArea.getDocument();
            String source = sdoc.getText(0, sdoc.getLength());
            if (ot == null || ot.length() == 0) {
                int bestAccuracy = transEvent.getBestAccuracy();
                int contextAccuracy = transEvent.getContextAccuracy();
                boolean isBestFuzzyMatch = transEvent.isBestFuzzyMatch();
                boolean hasTagsTransferred = transEvent.hasTagsTransferred();
                if (AppPreferences.autonumbers && bestAccuracy < 100) {
                    bestTranslation = NumbersHelper.autoTransfer(source, bestTranslation);
                }
                if (AppPreferences.autotags && !hasTagsTransferred) {
                    bestTranslation = this.parent.getMatchBoard().transferSegmentTags(source, bestTranslation, transEvent);
                }
                bestTranslation = this.parent.getMatchBoard().matchHiddenNontranslatables(bestTranslation);
                Workflow w = this.parent.getWorkflowView().getWorkflowManager().getWorkflow();
                if (w != null) {
                    XLIFFUnit tu;
                    w.setTarget(bestTranslation);
                    this.parent.getTargetView().setEdited(false);
                    XLIFF xliff = this.parent.getProjectView().getProject().getXLIFF();
                    if (xliff != null && (tu = xliff.getWorkflow().getCheckTransUnit()) != null) {
                        tu.removeMatch(false);
                        boolean storeMatch = false;
                        if (xliff.isCafeTranXLIFF) {
                            storeMatch = true;
                        }
                        if (bestAccuracy > 100) {
                            if (contextAccuracy == 102) {
                                tu.setMatch(102, 1, storeMatch);
                            } else if (contextAccuracy == 101) {
                                tu.setMatch(101, 1, storeMatch);
                            } else {
                                tu.setMatch(100, 1, storeMatch);
                            }
                        } else if (isBestFuzzyMatch) {
                            tu.setMatch(bestAccuracy, 2, storeMatch);
                        } else {
                            tu.setMatch(bestAccuracy, 3, storeMatch);
                        }
                    }
                }
                int alen = bestTranslation.length();
                Project project = this.parent.getProjectView().getProject();
                boolean isQA = project.isQAFilterWorkflow();
                if (AppPreferences.skipPerfectMatches && bestAccuracy == 101 && !isQA) {
                    WorkflowManager.suspendAutosave = true;
                    this.parent.getWorkflowView().autoNext();
                } else if (AppPreferences.skipAutoMatches && !isQA) {
                    WorkflowManager.suspendAutosave = true;
                    WorkflowManager.suspendQATagsCheck = true;
                    this.parent.getWorkflowView().autoNext();
                } else {
                    this.targetTextArea.setSelectionStart(0);
                    this.targetTextArea.setSelectionEnd(alen);
                }
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(MemoryView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean exactTargetsDifferent(String match) {
        boolean differ = false;
        JTextPane tpane = this.parent.getTargetPane();
        Document doc = tpane.getDocument();
        int len = doc.getLength();
        if (len > 0) {
            String target = null;
            try {
                target = doc.getText(0, len);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(MemoryView.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (target == null) {
                return differ;
            }
            if (!target.equals(match)) {
                differ = true;
            }
        }
        return differ;
    }

    Point adjustPopupLocationToFitScreen(JLabel label, int xposition, int yposition) {
        Point p = new Point(xposition, yposition);
        if (GraphicsEnvironment.isHeadless()) {
            return p;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(p)) continue;
            gc = dgc;
            break;
        }
        if (gc == null) {
            gc = this.parent.getGraphicsConfiguration();
        }
        Rectangle screenBounds = gc != null ? gc.getBounds() : new Rectangle(toolkit.getScreenSize());
        Dimension size = label.getPreferredSize();
        long pw = (long)p.x + (long)size.width;
        long ph = (long)p.y + (long)size.height;
        if (pw > (long)(screenBounds.x + screenBounds.width)) {
            p.x = screenBounds.x + screenBounds.width - size.width;
        }
        if (ph > (long)(screenBounds.y + screenBounds.height)) {
            p.y = screenBounds.y + screenBounds.height - size.height - 33;
        }
        if (p.x < screenBounds.x) {
            p.x = screenBounds.x;
        }
        if (p.y < screenBounds.y) {
            p.y = screenBounds.y;
        }
        return p;
    }

    public boolean fieldsMatch(String key, String value) {
        String v;
        Object o;
        boolean match = false;
        LinkedHashMap map = this.parent.getProjectView().getProject().getSegmentAttributes();
        if (map != null && (o = map.get(key)) != null && (v = o.toString()).length() > 0 && v.equalsIgnoreCase(value)) {
            match = true;
        }
        return match;
    }

    public void saveMemories() {
        for (Object object : this.localMemories) {
            Memory m = (Memory)object;
            m.saveMemory(false);
        }
    }

    public void showTargetWordAlternatives(final JPopupMenu popUp, final String word, final int ws) {
        if (this.event == null) {
            return;
        }
        Map allAutoMatchesMap = this.event.getAutoMatchesMap();
        if (allAutoMatchesMap != null && !allAutoMatchesMap.isEmpty()) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (Map.Entry entry : allAutoMatchesMap.entrySet()) {
                String s;
                String key = (String)entry.getKey();
                Set set = (Set)entry.getValue();
                boolean hasWord = false;
                for (FragmentMatch fmatch : set) {
                    s = fmatch.getTarget();
                    if (!s.equalsIgnoreCase(word)) continue;
                    hasWord = true;
                    break;
                }
                if (!hasWord) continue;
                for (FragmentMatch fmatch : set) {
                    s = fmatch.getTarget();
                    if (s.equalsIgnoreCase(word)) continue;
                    map.put(s, key);
                }
            }
            if (!map.isEmpty()) {
                int accel = 1;
                Font f = this.parent.getTargetPane().getFont();
                float fs = 14.0f;
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getValue();
                    String alternative = (String)entry.getKey();
                    if (alternative == null || alternative.length() == 0) continue;
                    JMenuItem item = new JMenuItem(alternative);
                    item.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (e.getButton() == 3) {
                                MemoryView.this.replaceWithTopPriority = false;
                            }
                        }
                    });
                    item.setActionCommand(alternative);
                    item.addActionListener(new ActionListener(){
                        final /* synthetic */ MemoryView this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JMenuItem item = (JMenuItem)e.getSource();
                            String key = (String)item.getClientProperty("key");
                            String alternative = e.getActionCommand();
                            if (this.this$0.replaceWithTopPriority) {
                                AssembleParser.addToSuperGlossary(key, alternative);
                            } else {
                                this.this$0.replaceWithTopPriority = true;
                            }
                            char wc = alternative.charAt(0);
                            char wc2 = word.charAt(0);
                            if (Character.isLowerCase(wc2) && Character.isUpperCase(wc)) {
                                alternative = alternative.toLowerCase();
                            } else if (Character.isUpperCase(wc2) && Character.isLowerCase(wc)) {
                                char[] arr = alternative.toCharArray();
                                arr[0] = wc = Character.toUpperCase(wc);
                                alternative = String.valueOf(arr);
                            }
                            try {
                                DefaultStyledDocument doc = (DefaultStyledDocument)this.this$0.parent.getTargetPane().getStyledDocument();
                                doc.replace(ws, word.length(), alternative, null);
                                popUp.setVisible(false);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                    item.putClientProperty("key", key);
                    if (accel < 10) {
                        char sh = Character.forDigit(accel, 10);
                        item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                    } else if (accel == 10) {
                        char sh = Character.forDigit(0, 10);
                        item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                    }
                    ++accel;
                    float fsize = item.getFont().getSize2D();
                    if (fs < fsize) {
                        fs = fsize;
                    }
                    item.setFont(f.deriveFont(fs));
                    popUp.add(item);
                }
            }
        }
    }

    public void showAutoMatchesPopUp() {
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        int w = frmSize.width / 2;
        int x = w - w / 2 + loc.x;
        int y = frmSize.height / 2 + loc.y;
        this.parent.getTargetView().showMatchesPopUp(this.parent, x, y, null);
    }

    public void showAutoTranslationPopUp() {
        TranslationResult translationResult;
        if (this.event != null && (translationResult = this.event.getTranslationResult()) != null) {
            Dimension frmSize = this.parent.getSize();
            Point loc = this.parent.getLocation();
            int w = frmSize.width / 2;
            int x = w - w / 2 + loc.x;
            int y = frmSize.height / 2 + loc.y;
            this.parent.getTargetView().showAutoTranslationPopUp(this.parent, x, y, this.event);
        }
    }

    public void insertFuzzyMatchOne() {
        Object[] totalBest;
        Object object;
        if (this.event != null && (object = (totalBest = this.event.getTranslationResult().getFuzzyResult())[0]) != null) {
            Object[] arr = (Object[])object;
            int p = (Integer)arr[0];
            String fuzzyEntry = (String)arr[2];
            this.setBestMatch(fuzzyEntry, p, 2);
        }
    }

    public void insertFuzzyMatchTwo() {
        Object object;
        Object[] totalBest;
        if (this.event != null && (totalBest = this.event.getTranslationResult().getFuzzyResult()).length > 1 && (object = totalBest[1]) != null) {
            Object[] arr = (Object[])object;
            int p = (Integer)arr[0];
            String fuzzyEntry = (String)arr[2];
            this.setBestMatch(fuzzyEntry, p, 2);
        }
    }

    public void insertFuzzyMatchThree() {
        Object object;
        Object[] totalBest;
        if (this.event != null && (totalBest = this.event.getTranslationResult().getFuzzyResult()).length > 2 && (object = totalBest[2]) != null) {
            Object[] arr = (Object[])object;
            int p = (Integer)arr[0];
            String fuzzyEntry = (String)arr[2];
            this.setBestMatch(fuzzyEntry, p, 2);
        }
    }

    public void insertAutotranslation() {
        String[] mt;
        TranslationResult translationResult;
        if (this.event != null && (translationResult = this.event.getTranslationResult()) != null && translationResult != null && (mt = translationResult.getAAResult()) != null) {
            int percent = translationResult.getAAAccuracy();
            int contextaccuracy = translationResult.getContextAccuracy();
            String s = mt[1];
            if (s != null) {
                if (contextaccuracy > 99) {
                    this.setBestMatch(s, contextaccuracy, 1);
                } else {
                    this.setBestMatch(s, percent, 3);
                }
            }
        }
    }

    public Memory setTotalRecallMemoryDefaultOptions(Memory dataBaseTM) {
        dataBaseTM.showStartDialog("Total Recall Options");
        String sourceLanguage = dataBaseTM.getSourceLangCode();
        String targetLanguage = dataBaseTM.getTargetLangCode();
        if (sourceLanguage != null && targetLanguage != null) {
            AppPreferences.forSegmentsMemoryDB = dataBaseTM.getSegmentsMode();
            AppPreferences.forTermsMemoryDB = dataBaseTM.getTermsMode();
            AppPreferences.termsCheckMemoryDB = dataBaseTM.getTermsCheck();
            AppPreferences.readonlyMemoryDB = dataBaseTM.isReadOnly();
            AppPreferences.duplicatesMemoryDB = dataBaseTM.getDuplicatesMode();
            AppPreferences.priorityMemoryDB = dataBaseTM.isAutoAssemblingStopped() ? 3 : dataBaseTM.getPriority();
            AppPreferences.matchCaseMemoryDB = dataBaseTM.getCaseMatch();
            AppPreferences.exactGreedyMatchMemoryDB = dataBaseTM.isGreedyMatching();
            AppPreferences.workflowModeMemory = dataBaseTM.getWorkflowMode();
            AppPreferences.prefixMatchMemoryDB = dataBaseTM.getPrefixMatch();
            return dataBaseTM;
        }
        return null;
    }

    public Memory setMemoryDefaultOptions() {
        Memory tmxTM = null;
        tmxTM = this.createSegmentsMemory(true);
        tmxTM.showStartDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TMX MEMORY"));
        String sourceLanguage = tmxTM.getSourceLangCode();
        String targetLanguage = tmxTM.getTargetLangCode();
        if (sourceLanguage != null && targetLanguage != null) {
            AppPreferences.workflowModeMemory = tmxTM.getWorkflowMode();
            AppPreferences.forSegmentsMemory = tmxTM.getSegmentsMode();
            AppPreferences.forTermsMemory = tmxTM.getTermsMode();
            AppPreferences.termsCheckMemory = tmxTM.getTermsCheck();
            AppPreferences.readonlyMemory = tmxTM.isReadOnly();
            AppPreferences.pretranslateOnlyMemory = tmxTM.isPretranslateOnly();
            AppPreferences.duplicatesMemory = tmxTM.getDuplicatesMode();
            AppPreferences.priorityMemory = tmxTM.getPriority();
            AppPreferences.tagsPositionMemory = tmxTM.hasTagPostions();
            AppPreferences.matchCaseMemory = tmxTM.getCaseMatch();
            AppPreferences.exactGreedyMatchMemory = tmxTM.isGreedyMatching();
            AppPreferences.prefixMatchMemory = tmxTM.getPrefixMatch();
            AppPreferences.fileSLang = sourceLanguage;
            AppPreferences.fileTLang = targetLanguage;
            return tmxTM;
        }
        return null;
    }

    public void startPretranslationDialog(List memories) {
        final JDialog dialog = new JDialog((Frame)this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION MEMORIES"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (memories.size() > 20) {
            scroll.setPreferredSize(new Dimension(500, 500));
        }
        dialog.add(scroll);
        JButton menuFileItem = new JButton(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("START PRELIMINARY MEMORY MATCHING")){
            final /* synthetic */ MemoryView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        menuFileItem.setHorizontalAlignment(0);
        panel.add(menuFileItem);
        for (Memory m : memories) {
            int w = m.getWorkflowMode();
            if (w == 2) continue;
            JCheckBox menuMemoryItem = new JCheckBox(m.getName());
            if (w == 1) {
                menuMemoryItem.setSelected(true);
            }
            menuMemoryItem.putClientProperty("memory", m);
            menuMemoryItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox box = (JCheckBox)e.getSource();
                    boolean state = box.isSelected();
                    Memory m = (Memory)box.getClientProperty("memory");
                    if (state) {
                        m.setWorkflowMode(1);
                    } else {
                        m.setWorkflowMode(0);
                    }
                }
            });
            menuMemoryItem.setFocusPainted(false);
            menuMemoryItem.setOpaque(false);
            menuMemoryItem.setFont(menuMemoryItem.getFont().deriveFont(1));
            panel.add(menuMemoryItem);
        }
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void startTaskDialog(List memories) {
        final JDialog dialog = new JDialog((Frame)this.parent, "TMs");
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (memories.size() > 20) {
            scroll.setPreferredSize(new Dimension(500, 500));
        }
        dialog.add(scroll);
        JButton menuFileItem = new JButton(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("START TASK")){
            final /* synthetic */ MemoryView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        menuFileItem.setPreferredSize(new Dimension(150, menuFileItem.getPreferredSize().height));
        menuFileItem.setHorizontalAlignment(0);
        panel.add(menuFileItem);
        for (Memory m : memories) {
            boolean w = m.isTaskReady();
            JCheckBox menuMemoryItem = new JCheckBox(m.getName());
            menuMemoryItem.setSelected(w);
            menuMemoryItem.putClientProperty("memory", m);
            menuMemoryItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox box = (JCheckBox)e.getSource();
                    boolean state = box.isSelected();
                    Memory m = (Memory)box.getClientProperty("memory");
                    m.setTaskReady(state);
                }
            });
            menuMemoryItem.setFocusPainted(false);
            menuMemoryItem.setOpaque(false);
            menuMemoryItem.setFont(menuMemoryItem.getFont().deriveFont(1));
            panel.add(menuMemoryItem);
        }
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void startTaskForSingleTMDialog(List memories, boolean importTM) {
        final JDialog dialog = new JDialog((Frame)this.parent, "TMs");
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        if (memories.size() > 20) {
            scroll.setPreferredSize(new Dimension(500, 500));
        }
        dialog.add(scroll);
        boolean taskReady = false;
        for (Memory m : memories) {
            if (importTM && m.isReadOnly()) continue;
            taskReady = true;
            m.setTaskReady(false);
            String n = m.getName();
            JButton menuMemoryItem = new JButton(n);
            menuMemoryItem.putClientProperty("memory", m);
            menuMemoryItem.addActionListener(new ActionListener(){
                final /* synthetic */ MemoryView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton)e.getSource();
                    Memory m = (Memory)button.getClientProperty("memory");
                    m.setTaskReady(true);
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            panel.add(menuMemoryItem);
        }
        if (taskReady) {
            Dimension dlgSize = dialog.getPreferredSize();
            Dimension frmSize = this.parent.getSize();
            Point loc = this.parent.getLocation();
            dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dialog.pack();
            dialog.setVisible(true);
        } else {
            dialog.dispose();
        }
    }

    public void resetAssembleParser() {
        AssembleParser.clearMaps();
    }

    class MemoryHyperactive
    implements HyperlinkListener {
        private Memory memory;
        private Thread th;
        private boolean act = true;

        MemoryHyperactive() {
        }

        public void setMemory(Memory m) {
            this.memory = m;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                if (this.th != null) {
                    this.act = false;
                    if (this.th.isAlive()) {
                        this.th.interrupt();
                    }
                    this.th = null;
                }
                MemoryView.this.memoryTip.hideInfo();
            } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                if (this.th == null) {
                    this.act = true;
                    final String s = e.getDescription();
                    final Component comp = (Component)e.getSource();
                    this.th = new Thread(this){
                        final /* synthetic */ MemoryHyperactive this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            try {
                                Thread.currentThread();
                                Thread.sleep(750L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (this$1.act) {
                                        this$1.MemoryView.this.memoryTip.showInfo(this$1.memory.getTMX(), s, comp, this$1.MemoryView.this.mouseX + 20, this$1.MemoryView.this.mouseY + 20);
                                    }
                                }
                            });
                        }
                    };
                    this.th.setPriority(1);
                    this.th.start();
                }
            } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.act = false;
                JEditorPane pane = (JEditorPane)e.getSource();
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        MemoryView.this.memoryTip.hideInfo();
                        String s2 = e.getDescription();
                        if (s2.equals("next")) {
                            MemoryView.this.next();
                        } else {
                            this.memory.edit(s2);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

