/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;

public class MultitermXMLHandler {
    private TMXReadOnlyUnitMap romap;
    private String slang;
    private String tlang;
    Memory memory;
    boolean readOnly;
    TMX tmx;
    String txtString;
    String enc;

    public MultitermXMLHandler(Memory memory) {
        this.memory = memory;
        this.slang = memory.getSourceLangCode();
        int i = this.slang.indexOf(45);
        if (i != -1) {
            this.slang = this.slang.substring(0, i);
        }
        this.tlang = memory.getTargetLangCode();
        i = this.tlang.indexOf(45);
        if (i != -1) {
            this.tlang = this.tlang.substring(0, i);
        }
        this.readOnly = memory.isReadOnly();
        this.enc = memory.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadZippedTextFile(ZipFile zfile, String name, String encoding) {
        InputStream is = null;
        try {
            ZipEntry entry = zfile.getEntry(name);
            int size = (int)entry.getSize();
            is = zfile.getInputStream(entry);
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] buf = new byte[size];
            bis.read(buf, 0, size);
            bis.close();
            this.txtString = new String(buf, 0, buf.length, encoding);
        }
        catch (IOException ex) {
            Logger.getLogger(MultitermXMLHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MultitermXMLHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTextFile(File file, String encoding) {
        FileInputStream fis = null;
        try {
            Charset charset = Charset.isSupported(encoding) ? Charset.forName(encoding) : Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            ByteBuffer bb = ByteBuffer.allocateDirect(sz);
            fc.read(bb);
            ByteBuffer buffer = bb;
            ((Buffer)buffer).flip();
            CharBuffer cb = decoder.decode(bb);
            fc.close();
            this.txtString = cb.toString();
        }
        catch (IOException ex) {
            Logger.getLogger(MultitermXMLHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MultitermXMLHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void parse() {
        this.tmx = this.memory.getTMX();
        if (this.readOnly) {
            this.romap = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
        }
        String languageGroup = "<languageGrp>.+?</languageGrp>";
        String termformat = "<term>.+?</term>";
        String descripformat = "<descrip .+?</descrip>";
        String languageformat = "<language .+?((</language>)|(/>))";
        String conceptGroup = "<conceptGrp>.+?</conceptGrp>";
        Pattern conceptGroupP = Pattern.compile(conceptGroup, 34);
        Pattern languageGroupP = Pattern.compile(languageGroup, 34);
        Pattern languageP = Pattern.compile(languageformat, 34);
        Pattern termP = Pattern.compile(termformat, 2);
        Pattern descripP = Pattern.compile(descripformat, 2);
        Matcher conceptGroupMatcher = conceptGroupP.matcher(this.txtString);
        while (conceptGroupMatcher.find()) {
            String conceptGrp = conceptGroupMatcher.group();
            Matcher langGrp = languageGroupP.matcher(conceptGrp);
            String source = null;
            String target = null;
            String note = null;
            while (langGrp.find()) {
                int j;
                String sgr;
                int k;
                int j2;
                String sgr2;
                int k2;
                String sslang = null;
                String ttlang = null;
                String gr = langGrp.group();
                Matcher m = languageP.matcher(gr);
                if (m.find()) {
                    String lgroup = m.group();
                    int si = lgroup.indexOf("lang=\"");
                    if (si == -1) continue;
                    int ei = lgroup.indexOf("\"", si + 6);
                    String la = lgroup.substring(si + 6, ei);
                    int i = la.indexOf(45);
                    if (i != -1) {
                        la = la.substring(0, i);
                    }
                    if (la.equalsIgnoreCase(this.slang)) {
                        sslang = la;
                    } else if (la.equalsIgnoreCase(this.tlang)) {
                        ttlang = la;
                    }
                }
                Matcher mm = termP.matcher(gr);
                StringBuilder content = new StringBuilder();
                if (mm.find() && (k2 = (sgr2 = mm.group()).indexOf("</term>", j2 = sgr2.indexOf("<term>"))) != -1) {
                    sgr2 = sgr2.substring(j2 + 6, k2);
                    sgr2 = XMLHelper.resolveEntitiesXML(sgr2);
                    content.append(sgr2);
                }
                Matcher mmm = descripP.matcher(gr);
                StringBuilder descrip = new StringBuilder();
                if (mmm.find() && (k = (sgr = mmm.group()).indexOf("</descrip>", j = sgr.indexOf(">"))) != -1) {
                    sgr = sgr.substring(j + 1, k);
                    sgr = XMLHelper.resolveEntitiesXML(sgr);
                    descrip.append(sgr);
                }
                if (sslang != null && sslang.equalsIgnoreCase(this.slang)) {
                    source = content.toString();
                    if (descrip.length() <= 0) continue;
                    if (note != null) {
                        note = note + "\n" + descrip.toString();
                        continue;
                    }
                    note = descrip.toString();
                    continue;
                }
                if (ttlang == null || !ttlang.equalsIgnoreCase(this.tlang)) continue;
                target = content.toString();
                if (descrip.length() <= 0) continue;
                if (note != null) {
                    note = note + "\n" + descrip.toString();
                    continue;
                }
                note = descrip.toString();
            }
            if (source == null || target == null) continue;
            if (this.readOnly) {
                TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
                tu.setSegment(this.slang, source);
                tu.setSegment(this.tlang, target);
                this.romap.load(tu);
                continue;
            }
            int dup = this.memory.getDuplicatesMode();
            this.tmx.update(source, target, note, null, null, dup);
            this.memory.setNewTU();
        }
    }
}

