/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.NumbersHelper;
import translator.Prompter;
import translator.SegmentParser;
import translator.StopWords;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLElement;
import translator.XMLHelper;
import translator.hunspell.HunSpellChecker;
import translator.tmx.Memory;
import translator.tmx.TMXBody;
import translator.tmx.TMXHeader;
import translator.tmx.TMXMenu;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;
import translator.tmx.TMXResult;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;
import translator.tmx.TMXView;
import translator.tmx.TMXWorkflow;

public class TMX
extends DefaultXMLElement {
    private XMLElement header;
    private TMXBody body;
    private TMXView view;
    private static TMXWorkflow xworkflow;
    private SegmentParser parser;
    private TranslationUnitMap map;
    private Locale locale;
    private Locale srclocale;
    int capacity = -1;
    private int id = -1;
    private String lastTUID;
    private String path;
    public boolean saved = true;
    private String tabbedTextHeader;
    int i = -1;
    TMXResult result;

    public void setLastID(String tuid) {
        this.lastTUID = tuid;
    }

    public String getLastID() {
        return this.lastTUID;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    private void setSpellChecker(String lang) {
        HunSpellChecker spell = this.view.topui.getSpellChecker();
        if (spell != null) {
            spell.setTargetLanguageDictionary(lang);
            spell.setBreakIterator(this.locale);
        }
    }

    public void setLocale(String lang) {
        if (lang != null && lang.length() > 0) {
            boolean edit;
            String ccode;
            String lcode;
            int v;
            if (lang.equals("en")) {
                lang = "en-US";
            }
            if ((v = lang.indexOf(45)) == -1) {
                v = lang.indexOf(95);
            }
            if (v != -1) {
                lcode = lang.substring(0, v).toLowerCase();
                ccode = lang.substring(v + 1).toUpperCase();
            } else {
                lcode = lang.toLowerCase();
                ccode = lang.toUpperCase();
            }
            this.locale = new Locale(lcode, ccode);
            Memory m = this.view.getMemory();
            if (m != null && (edit = m.getEditMode())) {
                if (lcode.equals("ja") || lcode.equals("zh") || lcode.equals("th")) {
                    AppPreferences.noWordSeparatorTargetLanguage = true;
                    Prompter.imputMethodsOverlapping = lcode.equals("ja");
                } else {
                    AppPreferences.noWordSeparatorTargetLanguage = false;
                    Prompter.imputMethodsOverlapping = false;
                }
                this.setSpellChecker(lcode + "_" + ccode);
                NumbersHelper.setTargetLocale(this.locale);
                if (this.view != null) {
                    this.view.topui.getTargetView().setTextComponentOrientation(this.locale);
                    this.view.topui.getResourceView().getTextShortcuts().setDefaultShortcuts(this.locale);
                }
            }
        }
    }

    public void setSrcLocale(String lang) {
        if (lang != null && lang.length() > 0) {
            boolean edit;
            if (lang.equals("en")) {
                lang = "en-US";
            }
            int v = lang.indexOf(95);
            int vv = lang.indexOf(45);
            this.srclocale = v != -1 ? new Locale(lang.substring(0, v).toLowerCase(), lang.substring(v + 1).toUpperCase()) : (vv != -1 ? new Locale(lang.substring(0, vv).toLowerCase(), lang.substring(vv + 1).toUpperCase()) : new Locale(lang.toLowerCase(), lang.toUpperCase()));
            Memory m = this.view.getMemory();
            if (m != null && (edit = m.getEditMode())) {
                StopWords.setStopWords(lang);
                this.view.topui.getSourceView().setTextComponentOrientation(this.srclocale);
                NumbersHelper.setSourceLocale(this.srclocale);
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getSrcLocale() {
        return this.srclocale;
    }

    public synchronized void switchDirection() {
        Collection tunits = this.getTranslationUnits();
        this.map.switchLang(tunits);
    }

    public void setParser(SegmentParser par) {
        this.parser = par;
    }

    public SegmentParser getParser() {
        return this.parser;
    }

    public void setFunctionWords() {
        this.map.setFunctionWords();
        this.parser.setFunctionWords(this.map.getFunctionWordsSource(), this.map.getFunctionWordsTarget());
    }

    public void createNewTU(String id) {
        this.map.createTU(id);
    }

    public void createTUNote() {
        TranslationUnit tu;
        TMXUnit tunit = null;
        TMXWorkflow flow = this.getWorkflow();
        if (flow != null) {
            tunit = flow.getCheckTransUnit();
        }
        if (tunit == null && (tu = this.map.getCurrentTU()) instanceof TMXUnit) {
            tunit = (TMXUnit)tu;
        }
        if (tunit != null) {
            this.getView().getMenu().createNote(tunit);
        }
    }

    public void update(String key, String value, String note, Map attrs, int[] tags, int rem) {
        TranslationUnit tux;
        if (rem == 1 || rem == 2) {
            TranslationUnit tu;
            String skey = this.parser.cleanSegment(key);
            this.parser.removeFromCache(skey);
            if (skey.indexOf(124) != -1) {
                skey = skey.replaceAll("\\|", "");
            }
            if (this.map.isPrefixMatching()) {
                skey = this.parser.makePrefixes(skey);
            }
            if ((tu = this.map.getTU(skey)) != null) {
                if (rem == 1) {
                    String msource;
                    String slang = this.map.getSourceLang();
                    String source = tu.getSegment(slang);
                    boolean same = false;
                    String mkey = key.replaceAll("\\|", "");
                    if (mkey.equals(msource = source.replaceAll("\\|", ""))) {
                        this.map.removeTU(tu);
                        same = true;
                    }
                    if (tu instanceof TMXUnit) {
                        TMXUnit tux2 = (TMXUnit)tu;
                        List tunits = this.getBody().getTransUnits();
                        if (this.map.isPrefixMatching()) {
                            if (same) {
                                tunits.remove(tux2);
                            }
                        } else {
                            tunits.remove(tux2);
                        }
                    }
                } else if (rem == 2) {
                    return;
                }
            }
        }
        this.map.setUnitContents(key, value);
        TranslationUnit tu = this.map.getNewTU();
        if (tu instanceof TMXUnit) {
            tux = (TMXUnit)tu;
            if (note != null) {
                DefaultXMLElement elem = new DefaultXMLElement(1, 1);
                elem.setContent(0, note);
                elem.setName("note");
                ((DefaultXMLElement)((Object)tux)).getChildren().add(0, elem);
            }
            if (attrs != null && attrs.size() > 0) {
                int index = 0;
                Iterator it = attrs.keySet().iterator();
                while (it.hasNext()) {
                    String k = it.next().toString();
                    String v = (String)attrs.get(k);
                    DefaultXMLElement elem = new DefaultXMLElement(1, 1);
                    elem.setContent(0, v);
                    elem.setName("prop");
                    elem.setAttribute("type", k);
                    ((DefaultXMLElement)((Object)tux)).getChildren().add(index, elem);
                    ++index;
                }
            }
            if (tags != null && tags.length > 0) {
                ((TMXUnit)tux).setTags(tags);
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < tags.length; ++j) {
                    int k = tags[j];
                    sb.append(k);
                    if (j + 1 >= tags.length) continue;
                    sb.append(',');
                }
                DefaultXMLElement elem = new DefaultXMLElement(1, 1);
                elem.setContent(0, sb.toString());
                elem.setName("prop");
                elem.setAttribute("type", "target_tags");
                ((DefaultXMLElement)((Object)tux)).getChildren().add(0, elem);
            }
            this.getBody().addChild(tux);
        } else if (attrs != null && tu instanceof TMXReadOnlyUnit) {
            tux = (TMXReadOnlyUnit)tu;
            if (attrs.size() > 0) {
                Iterator it = attrs.keySet().iterator();
                while (it.hasNext()) {
                    String k = it.next().toString();
                    String v = (String)attrs.get(k);
                    ((TMXReadOnlyUnit)tux).addProperty(k, v);
                }
            }
        }
    }

    public String getFromMemory(String source) {
        return this.map.getMatch(source);
    }

    public Collection getTranslationUnits() {
        Collection c = this.getBody().getTransUnits();
        if (c.isEmpty()) {
            c = this.map.getMapTranslationUnits();
        }
        return c;
    }

    public TranslationUnitMap getTUMap() {
        return this.map;
    }

    public void setTUMap(TranslationUnitMap m) {
        this.map = m;
    }

    public void setView(TMXView view) {
        this.view = view;
    }

    public TMXView getView() {
        return this.view;
    }

    public void setWorkflow(TMXWorkflow flow) {
        xworkflow = flow;
    }

    public TMXWorkflow getWorkflow() {
        return xworkflow;
    }

    @Override
    public void addChild(Object o) {
        XMLElement xml;
        String name;
        if (o instanceof XMLElement && (name = (xml = (XMLElement)o).getName()).equals("header")) {
            this.setHeader(xml);
        }
    }

    public void setTabbedTextHeader(String s) {
        this.tabbedTextHeader = s;
    }

    public String getTabbedTextHeader() {
        return this.tabbedTextHeader;
    }

    public void setHeader(XMLElement h) {
        this.header = h;
        List notes = this.header.getChildren("note");
        for (DefaultXMLElement note : notes) {
            String cap;
            int pos;
            Object o = note.getContent(0);
            if (o == null || !(o instanceof String) || (pos = (cap = (String)o).indexOf("size=")) == -1) continue;
            cap = cap.substring(5);
            int c = Integer.parseInt(cap);
            double d = (double)c / 0.75;
            this.capacity = (int)(d + 1000.0);
            this.header.removeChild(note);
            break;
        }
    }

    public XMLElement getHeader() {
        return this.header;
    }

    public void setBody(TMXBody b) {
        this.body = b;
    }

    public TMXBody getBody() {
        return this.body;
    }

    public void searchFile(String s, String r, int mode) {
        this.view.search(s, r, mode);
    }

    public void viewRange(int from, int to) {
        this.view.viewRange(from, to);
    }

    public void sort() {
        this.view.sort();
    }

    public void sortByLength(boolean longToShort) {
        this.view.sortByLength(longToShort);
    }

    private void prop(String source, String replacement, XMLElement tuss, XMLElement tutt) {
        if (tuss != null && tutt != null) {
            List tusList = tuss.getChildren();
            List tutList = tutt.getChildren();
            ListIterator sit = tusList.listIterator();
            ListIterator<String> tit = tutList.listIterator();
            while (sit.hasNext() && tit.hasNext()) {
                Object object1 = sit.next();
                Object object2 = tit.next();
                if (object1 == null || object2 == null) continue;
                if (object1 instanceof String && object2 instanceof String) {
                    String tsource = object1.toString();
                    String ttarget = object2.toString();
                    if (tsource.length() <= 0 || !tsource.equalsIgnoreCase(source) || ttarget.equalsIgnoreCase(replacement)) continue;
                    tit.set(replacement);
                    ++this.i;
                    continue;
                }
                if (!(object1 instanceof XMLElement) || !(object2 instanceof XMLElement)) continue;
                XMLElement subsource = (XMLElement)object1;
                XMLElement subtarget = (XMLElement)object2;
                this.prop(source, replacement, subsource, subtarget);
            }
        }
    }

    public int propagate(String source, String replacement) {
        this.i = 0;
        if (replacement != null && source != null) {
            source = XMLHelper.parseTags(source);
            replacement = XMLHelper.parseTags(replacement);
            this.getView();
            List tunits = TMXView.getFilteredUnits();
            if (tunits == null && (tunits = this.getView().getGluedUnits()) == null) {
                tunits = this.getBody().getTransUnits();
            }
            String slang = this.map.getSourceLang();
            String tlang = this.map.getTargetLang();
            for (TMXUnit tuu : tunits) {
                TMXUnitVariant tuvs = tuu.getTUV(slang);
                TMXUnitVariant tuvt = tuu.getTUV(tlang);
                if (tuvs == null || tuvt == null) continue;
                XMLElement sseg = tuvs.getSegment();
                XMLElement tseg = tuvt.getSegment();
                this.prop(source, replacement, sseg, tseg);
            }
        }
        return this.i;
    }

    public void setTMXResult(TMXResult result) {
        this.result = result;
    }

    public TMXResult getTMXResult() {
        return this.result;
    }

    public void editElement(String s) {
        if (s.startsWith("#")) {
            Object o;
            int ind;
            String s3;
            List tunits = TMXView.getFilteredUnits();
            if (tunits == null && (tunits = this.getView().getGluedUnits()) == null && (tunits = this.getBody().getTransUnits()) != null && tunits.isEmpty()) {
                tunits = (List)this.getTUMap().getMapTranslationUnits();
            }
            if ((s3 = (ind = s.indexOf(61)) != -1 ? s.substring(ind + 1, s.length()) : s.substring(1, s.length())).endsWith("#")) {
                s3 = s3.substring(0, s3.length() - 1);
            }
            int i = Integer.parseInt(s3);
            if (this.result != null && ind != -1) {
                TranslationUnit tu = this.result.getTranslationUnit(i);
                if (tu != null) {
                    if (tu instanceof TMXUnit) {
                        TMXUnit tux = (TMXUnit)tu;
                        if (this.view != null) {
                            TMXMenu menu = this.view.getMenu();
                            int r = menu.showXMLElement(tux);
                            if (r == 0) {
                                tunits.remove(tux);
                                this.getTUMap().removeTU(tux);
                            }
                            if (r != -1) {
                                this.saved = false;
                            }
                        }
                    } else {
                        if (tu.hasParent()) {
                            TMXReadOnlyUnit turo = (TMXReadOnlyUnit)tu;
                            tu = turo.getParentTranslationUnit();
                        }
                        TMXUnit tux = this.convertReadOnlyTUtoTMXTU(tu);
                        if (this.view != null) {
                            TMXMenu menu = this.view.getMenu();
                            int r = menu.showXMLElement(tux);
                            if (r == 0) {
                                TMXReadOnlyUnitMap map = (TMXReadOnlyUnitMap)this.getTUMap();
                                map.removeTranslationUnitSynonyms(tu);
                                tunits.remove(tu);
                                this.getTUMap().removeTU(tu);
                            } else if (r == 1) {
                                TMXReadOnlyUnitMap map = (TMXReadOnlyUnitMap)this.getTUMap();
                                map.removeTranslationUnitSynonyms(tu);
                                tunits.remove(tu);
                                this.getTUMap().removeTU(tu);
                                String slang = this.getTUMap().getSourceLang();
                                String tlang = this.getTUMap().getTargetLang();
                                String source = tux.getSegment(slang);
                                String target = tux.getSegment(tlang);
                                int k = slang.indexOf(45);
                                if (k != -1) {
                                    slang = slang.substring(0, k);
                                }
                                if ((k = tlang.indexOf(45)) != -1) {
                                    tlang = tlang.substring(0, k);
                                }
                                TMXReadOnlyUnit turo = (TMXReadOnlyUnit)tu;
                                turo.setSegment(slang, source);
                                turo.setSegment(tlang, target);
                                Object[] p = turo.getProperties();
                                Object[] p2 = tux.getProperties();
                                if (p != null && p2 != null) {
                                    for (int j = 0; j < p2.length; ++j) {
                                        p[j] = p2[j];
                                    }
                                }
                                map.load(turo);
                                map.updateTranslationUnitSynonyms(tu);
                            }
                        }
                    }
                }
            } else if (i < tunits.size() && (o = tunits.get(i)) != null) {
                if (o instanceof TMXUnit) {
                    TMXUnit tux = (TMXUnit)o;
                    if (this.view != null) {
                        TMXMenu menu = this.view.getMenu();
                        int r = menu.showXMLElement(tux);
                        if (r == 0) {
                            tunits.remove(tux);
                            this.getTUMap().removeTU(tux);
                        }
                        if (r != -1) {
                            this.saved = false;
                            this.view.browseToUnit(i);
                        }
                    }
                } else if (o instanceof TranslationUnit) {
                    TranslationUnit tu = (TranslationUnit)o;
                    if (tu.hasParent()) {
                        TMXReadOnlyUnit turo = (TMXReadOnlyUnit)tu;
                        tu = turo.getParentTranslationUnit();
                    }
                    TMXUnit tux = this.convertReadOnlyTUtoTMXTU(tu);
                    if (this.view != null) {
                        TMXMenu menu = this.view.getMenu();
                        int r = menu.showXMLElement(tux);
                        if (r == 0) {
                            TMXReadOnlyUnitMap map = (TMXReadOnlyUnitMap)this.getTUMap();
                            map.removeTranslationUnitSynonyms(tu);
                            tunits.remove(tu);
                            this.getTUMap().removeTU(tu);
                        } else if (r == 1) {
                            TMXReadOnlyUnitMap map = (TMXReadOnlyUnitMap)this.getTUMap();
                            map.removeTranslationUnitSynonyms(tu);
                            tunits.remove(tu);
                            this.getTUMap().removeTU(tu);
                            String slang = this.getTUMap().getSourceLang();
                            String tlang = this.getTUMap().getTargetLang();
                            String source = tux.getSegment(slang);
                            String target = tux.getSegment(tlang);
                            int k = slang.indexOf(45);
                            if (k != -1) {
                                slang = slang.substring(0, k);
                            }
                            if ((k = tlang.indexOf(45)) != -1) {
                                tlang = tlang.substring(0, k);
                            }
                            TMXReadOnlyUnit turo = (TMXReadOnlyUnit)tu;
                            turo.setSegment(slang, source);
                            turo.setSegment(tlang, target);
                            Object[] p = turo.getProperties();
                            Object[] p2 = tux.getProperties();
                            if (p != null && p2 != null) {
                                for (int j = 0; j < p2.length; ++j) {
                                    p[j] = p2[j];
                                }
                            }
                            map.load(turo);
                            map.updateTranslationUnitSynonyms(tu);
                        }
                        if (r != -1) {
                            this.view.browseToUnit(i);
                        }
                    }
                }
            }
        } else if (s.startsWith("$")) {
            if (this.result != null) {
                String t = s.substring(1, s.length());
                int i = Integer.parseInt(t);
                Object[] ob = this.result.getBestFuzzy(i);
                if (this.view != null && ob != null) {
                    int proc = (Integer)ob[0];
                    String f = (String)ob[2];
                    this.view.topui.getMemoryView().setBestMatch(f, proc, 2);
                }
            }
        } else if (s.startsWith("%")) {
            if (this.result != null) {
                String t = s.substring(1, s.length());
                int i = Integer.parseInt(t);
                String e = this.result.getTarget(i);
                if (this.view != null && e != null) {
                    int cp = this.result.getContextPercent();
                    if (cp > 99) {
                        this.view.topui.getMemoryView().setBestMatch(e, cp, 1);
                    } else {
                        this.view.topui.getMemoryView().setBestMatch(e, 100, 3);
                    }
                }
            }
        } else if (this.result != null) {
            int i = Integer.parseInt(s);
            String t = this.result.getTarget(i);
            if (this.view != null) {
                this.view.topui.getMemoryView().insertMatch(t);
            }
        }
    }

    public void edit(String s) {
        if (s.equals("END")) {
            int size;
            List tus = this.view.getViewUnits();
            if (tus != null && (size = tus.size()) > 0) {
                xworkflow.setCheckStart(size - 1);
                xworkflow.checkNextTU();
            }
        } else if (s.equals("TU")) {
            TranslationUnit tu = this.getTUMap().getNewTU();
            if (tu != null && tu instanceof TMXUnit) {
                TMXUnit tux = (TMXUnit)tu;
                TMXView view = this.getView();
                if (view != null) {
                    TMXMenu menu = view.getMenu();
                    menu.showXMLElement(tux);
                }
            }
        } else if (s.startsWith("#")) {
            if (s.endsWith("#")) {
                this.editElement(s.substring(0, s.length() - 1));
                return;
            }
            String tuid = s.substring(1);
            int i = Integer.parseInt(tuid);
            if (i == -1) {
                xworkflow.checkNextTU();
            } else if (i == -2) {
                xworkflow.checkPreviousTU();
            } else if (i == -3) {
                xworkflow.joinTU();
            } else if (i == -4) {
                int current = this.view.getCurrentTUIndex();
                this.view.browseToUnit(current);
            } else {
                if (i >= 0) {
                    xworkflow.setCheckStart(i);
                }
                xworkflow.checkNextTU();
            }
        }
    }

    public StringBuffer toAutoCompletion() {
        StringBuffer sb = new StringBuffer();
        List tus = this.body.getTransUnits();
        this.takeTUContent(tus, sb);
        return sb;
    }

    private void takeTUContent(Collection tus, StringBuffer sb) {
        for (TMXUnit tunit : tus) {
            String content;
            String tlang;
            TMXUnitVariant tut = tunit.getTUV(tlang = this.map.getTargetLang());
            if (tut == null || (content = tut.getSegmentText()).length() <= 0) continue;
            sb.append(content);
            sb.append(" ");
        }
    }

    private TMXUnit convertReadOnlyTUtoTMXTU(TranslationUnit tu) {
        TMXUnit newTU = new TMXUnit(this.getID());
        newTU.setName("tu");
        TMXUnitVariant sourceTUV = new TMXUnitVariant();
        sourceTUV.setName("tuv");
        sourceTUV.setAttribute("xml:lang", this.map.getSourceLang());
        DefaultXMLElement seg = new DefaultXMLElement(0, 1);
        seg.setName("seg");
        seg.setContent(0, tu.getSegment(this.map.getSourceLang()));
        sourceTUV.setSegment(seg);
        newTU.addTUV(sourceTUV);
        TMXUnitVariant targetTUV = new TMXUnitVariant();
        targetTUV.setName("tuv");
        targetTUV.setAttribute("xml:lang", this.map.getTargetLang());
        seg = new DefaultXMLElement(0, 1);
        seg.setName("seg");
        seg.setContent(0, tu.getSegment(this.map.getTargetLang()));
        targetTUV.setSegment(seg);
        newTU.addTUV(targetTUV);
        Object[] p = tu.getProperties();
        if (p != null) {
            for (int j = 0; j < p.length; ++j) {
                String[] p1 = (String[])p[j];
                if (p1 == null) continue;
                String k = p1[0];
                String v = p1[1];
                DefaultXMLElement xe = new DefaultXMLElement();
                xe.setName("prop");
                xe.setAttribute("type", k);
                xe.setContent(0, v);
                newTU.addChild(xe);
            }
        }
        return newTU;
    }

    public String exportBilingualToWord(String name, boolean withNotes) {
        String nl = "";
        String sl = this.getTUMap().getSourceLang();
        String tl = this.getTUMap().getTargetLang();
        if (sl != null && sl.indexOf(45) != -1) {
            sl = "<w:rPr><w:lang w:val=\"" + sl + "\"/></w:rPr>";
        }
        if (tl != null && tl.indexOf(45) != -1) {
            nl = "<w:lang w:val=\"" + tl + "\"/>";
            tl = "<w:rPr><w:lang w:val=\"" + tl + "\"/></w:rPr>";
        }
        String startTable = "<w:tblGrid><w:gridCol w:w=\"600\"/><w:gridCol w:w=\"4606\"/><w:gridCol w:w=\"4606\"/></w:tblGrid>";
        String startTable2 = "<w:tblGrid><w:gridCol w:w=\"600\"/><w:gridCol w:w=\"3500\"/><w:gridCol w:w=\"3500\"/><w:gridCol w:w=\"2212\"/><w:gridCol w:w=\"300\"/></w:tblGrid>";
        String startRow = "<w:tr>";
        String endRow = "</w:tr>";
        String idHeaderColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"600\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"595959\"/>\n          </w:tcPr>\n          <w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr>\n            <w:r><w:rPr><w:b/><w:color w:val=\"FFFFFF\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String langHeaderColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"7000\"/><w:gridSpan w:val=\"2\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"595959\"/>\n          </w:tcPr>\n          <w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr>\n            <w:r><w:rPr><w:b/><w:color w:val=\"FFFFFF\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String noteHeaderColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"2212\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"595959\"/>\n          </w:tcPr>\n          <w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr>\n            <w:r><w:rPr><w:b/><w:color w:val=\"FFFFFF\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String statusHeaderColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"300\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"595959\"/>\n          </w:tcPr>\n          <w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr>\n            <w:r><w:rPr><w:b/><w:color w:val=\"FFFFFF\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String statusColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"300\"/><w:shd w:val=\"clear\" w:color=\"auto\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>\n              <w:t xml:space=\"preserve\">";
        String statusColumn2 = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"300\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>\n              <w:t xml:space=\"preserve\">";
        String idColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"600\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r><w:rPr><w:sz w:val=\"18\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String startColumnSource = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"4606\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + sl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnSourceChecked = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"4606\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + sl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnSourceNotes = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"3500\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + sl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnSourceNotesChecked = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"3500\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + sl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnTarget = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"4606\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + tl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnTargetChecked = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"4606\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + tl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnTargetNotes = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"3500\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + tl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnTargetNotesChecked = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"3500\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + tl + "\n              <w:t xml:space=\"preserve\">";
        String noteColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"2212\"/><w:shd w:val=\"clear\" w:color=\"auto\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r><w:rPr><w:i/>" + nl + "</w:rPr>\n              <w:t xml:space=\"preserve\">";
        String noteColumnR = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"2212\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r><w:rPr><w:i/>" + nl + "</w:rPr>\n              <w:t xml:space=\"preserve\">";
        String endColumn = "</w:t>\n            </w:r>\n          </w:p>\n        </w:tc>";
        String wBreak = "</w:t></w:r><w:br/><w:r><w:t xml:space=\"preserve\">";
        int tuno = 0;
        String targetString = null;
        this.getView();
        List units = TMXView.getFilteredUnits();
        if (units == null) {
            units = this.getView().getGluedUnits();
            if (units == null) {
                Collection col = this.getTranslationUnits();
                if (col instanceof List) {
                    units = (List)col;
                } else {
                    units = new ArrayList(col.size());
                    units.addAll(col);
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT FROM FILTER TO BILINGUAL DOCUMENT. RETURN IMPORT ONLY INTO EXACTLY THE SAME FILTER."));
        }
        int size = units.size();
        ProgressMonitor pm = new ProgressMonitor(this.view.topui, "Exporting translation...", null, 0, size);
        StringBuilder sbuffer = new StringBuilder();
        if (!withNotes) {
            sbuffer.append(startTable);
        } else {
            sbuffer.append(startTable2);
        }
        sbuffer.append(startRow);
        sbuffer.append(idHeaderColumn);
        sbuffer.append("ID");
        sbuffer.append(endColumn);
        sbuffer.append(langHeaderColumn);
        int k = name.indexOf(46);
        if (k != -1) {
            name = name.substring(0, k);
        }
        name = XMLHelper.resolveXMLEntities(name);
        sbuffer.append(name);
        sbuffer.append(endColumn);
        if (withNotes) {
            sbuffer.append(noteHeaderColumn);
            sbuffer.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTES"));
            sbuffer.append(endColumn);
            sbuffer.append(statusHeaderColumn);
            sbuffer.append("R");
            sbuffer.append(endColumn);
        }
        sbuffer.append(endRow);
        boolean odd = false;
        String slang = this.getTUMap().getSourceLang();
        String tlang = this.getTUMap().getTargetLang();
        for (Object o : units) {
            if (!(o instanceof TranslationUnit)) continue;
            TranslationUnit tu = (TranslationUnit)o;
            boolean state = tu.getState();
            String s = this.view.getSegmentXMLText(tu, slang);
            String t = this.view.getSegmentXMLText(tu, tlang);
            sbuffer.append(startRow);
            int indexCol = tuno + 1;
            sbuffer.append(idColumn);
            sbuffer.append(Integer.toString(indexCol));
            sbuffer.append(endColumn);
            if (!withNotes) {
                if (state) {
                    sbuffer.append(startColumnSourceChecked);
                } else {
                    sbuffer.append(startColumnSource);
                }
                sbuffer.append(s);
                sbuffer.append(endColumn);
                if (state) {
                    sbuffer.append(startColumnTargetChecked);
                } else {
                    sbuffer.append(startColumnTarget);
                }
                sbuffer.append(t);
                sbuffer.append(endColumn);
            } else {
                TMXUnit tux;
                List notes;
                if (state) {
                    sbuffer.append(startColumnSourceNotesChecked);
                } else {
                    sbuffer.append(startColumnSourceNotes);
                }
                sbuffer.append(s);
                sbuffer.append(endColumn);
                if (state) {
                    sbuffer.append(startColumnTargetNotesChecked);
                } else {
                    sbuffer.append(startColumnTargetNotes);
                }
                sbuffer.append(t);
                sbuffer.append(endColumn);
                StringBuilder sbNotes = new StringBuilder();
                if (tu instanceof TMXUnit && (notes = (tux = (TMXUnit)tu).getChildren("note")) != null && notes.size() > 0) {
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object no = c.getContent(0);
                        if (no == null || (con = no.toString()).length() <= 0) continue;
                        sbNotes.append(con);
                    }
                }
                if (state) {
                    sbuffer.append(noteColumnR);
                } else {
                    sbuffer.append(noteColumn);
                }
                String sn = sbNotes.toString();
                if (sn.length() > 0) {
                    sn = XMLHelper.resolveXMLEntities(sn);
                    sn = sn.replace("\n", wBreak);
                    sbuffer.append(sn);
                }
                sbuffer.append(endColumn);
                if (state) {
                    sbuffer.append(statusColumn2);
                    sbuffer.append("R");
                } else {
                    sbuffer.append(statusColumn);
                }
                sbuffer.append(endColumn);
            }
            sbuffer.append(endRow);
            odd = !odd;
            pm.setProgress(++tuno);
        }
        targetString = sbuffer.toString();
        return targetString;
    }

    public boolean importBilingualFromWord(String skeleton) {
        ArrayList<String> sources = new ArrayList<String>();
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<String> notes = new ArrayList<String>();
        ArrayList<String> statues = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<w:tr[> ].+?</w:tr>", 32);
        Pattern pattern2 = Pattern.compile("<w:tc[> ].+?</w:tc>", 32);
        Pattern pattern3 = Pattern.compile("<w:t[> ].+?</w:t>");
        Matcher matcher1 = pattern.matcher(skeleton);
        boolean header = false;
        while (matcher1.find()) {
            if (!header) {
                header = true;
                continue;
            }
            String group1 = matcher1.group();
            Matcher matcher2 = pattern2.matcher(group1);
            int i = 0;
            while (matcher2.find()) {
                if (i == 1 || i == 2 || i == 3 || i == 4) {
                    String group2 = matcher2.group();
                    Matcher matcher3 = pattern3.matcher(group2);
                    StringBuilder sb = new StringBuilder();
                    int end = 0;
                    while (matcher3.find()) {
                        int k;
                        int start = matcher3.start();
                        String newline = null;
                        if (end > 0) {
                            newline = group2.substring(end, start);
                        }
                        String group3 = matcher3.group();
                        end = matcher3.end();
                        int j = group3.indexOf(62);
                        String s = group3.substring(j + 1, k = group3.indexOf(60, j));
                        if (s.length() <= 0) continue;
                        if (i == 2 && newline != null && (newline.indexOf("<w:br/>") != -1 || newline.indexOf("</w:p><w:p") != -1)) {
                            sb.append("\n");
                        }
                        s = XMLHelper.resolveEntitiesXML(s);
                        sb.append(s);
                    }
                    if (i == 1) {
                        sources.add(sb.toString());
                    } else if (i == 2) {
                        targets.add(sb.toString());
                    } else if (i == 3) {
                        notes.add(sb.toString());
                    } else if (i == 4) {
                        statues.add(sb.toString());
                    }
                }
                ++i;
            }
        }
        this.getView();
        List units = TMXView.getFilteredUnits();
        if (units == null) {
            units = this.getView().getGluedUnits();
            if (units == null) {
                Collection col = this.getTranslationUnits();
                if (col instanceof List) {
                    units = (List)col;
                } else {
                    units = new ArrayList(col.size());
                    units.addAll(col);
                }
            }
        } else {
            int i = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT TO FILTER?"), "", 2);
            if (i != 0) {
                return false;
            }
        }
        String slang = this.getTUMap().getSourceLang();
        String tlang = this.getTUMap().getTargetLang();
        int size = units.size();
        if (size == targets.size() && size == sources.size()) {
            int ind = 0;
            Iterator it = targets.iterator();
            while (it.hasNext()) {
                String target;
                XMLElement tarXML;
                TMXUnitVariant tuv;
                String source;
                String t = it.next().toString();
                String s = (String)sources.get(ind);
                TMXUnit tu = (TMXUnit)units.get(ind);
                if (s.length() > 0 && !s.equals(source = tu.getSegment(slang))) {
                    tuv = tu.getTUV(slang);
                    tarXML = tuv.getSegment();
                    tarXML.getChildren().clear();
                    tarXML.setContent(0, s);
                }
                if (t.length() > 0 && !t.equals(target = tu.getSegment(tlang))) {
                    tuv = tu.getTUV(tlang);
                    tarXML = tuv.getSegment();
                    tarXML.getChildren().clear();
                    tarXML.setContent(0, t);
                }
                if (notes.size() > 0) {
                    String note;
                    List onotes = tu.getChildren("note");
                    if (onotes != null && onotes.size() > 0) {
                        for (DefaultXMLElement c : onotes) {
                            Object o = c.getContent(0);
                            if (o != null) {
                                String con = o.toString();
                                if (con.length() <= 0 || con.equals("propagated")) continue;
                                tu.removeChild(c);
                                continue;
                            }
                            tu.removeChild(c);
                        }
                    }
                    if ((note = (String)notes.get(ind)) != null && note.length() > 0) {
                        DefaultXMLElement xn = new DefaultXMLElement();
                        xn.setName("note");
                        xn.addChild(note);
                        tu.addChild(xn);
                    }
                }
                if (statues.size() > 0) {
                    String status = (String)statues.get(ind);
                    tu.state = status != null && status.equalsIgnoreCase("R");
                }
                ++ind;
            }
        }
        return true;
    }

    public void writeXMLFormat(BufferedWriter awriter) throws IOException {
        StringBuilder sb = new StringBuilder();
        String name = this.getName();
        sb.append("<");
        sb.append(name);
        LinkedHashMap attrMap = this.getAttributes();
        if (attrMap != null) {
            Set set = attrMap.keySet();
            Iterator i = set.iterator();
            while (i.hasNext()) {
                sb.append(" ");
                String s = (String)i.next();
                sb.append(s);
                sb.append('=');
                sb.append('\"');
                sb.append((String)attrMap.get(s));
                sb.append('\"');
            }
        }
        sb.append(">");
        sb.append(AppPreferences.ls);
        if (this.header != null) {
            sb.append(this.header.getXMLFormat());
        }
        awriter.write(sb.toString());
        sb.setLength(0);
        if (this.body != null) {
            this.body.writeXMLFormat(awriter);
        }
        sb.append(AppPreferences.ls);
        sb.append("</");
        sb.append(name);
        sb.append(">");
        awriter.write(sb.toString());
        this.saved = true;
    }

    public void writeXMLFormat() throws IOException {
        File projectFile = new File(this.path);
        File tempFile = File.createTempFile("old", null, projectFile.getParentFile());
        FileOutputStream out = new FileOutputStream(tempFile);
        String encoding = "UTF-8";
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));
        if (encoding != null && encoding.startsWith("UTF-16")) {
            awriter.write("<?xml version=\"1.0\" encoding=\"utf-16\"?>" + AppPreferences.ls);
        } else {
            awriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>" + AppPreferences.ls);
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        XMLElement header = this.getHeader();
        if (header == null) {
            header = new TMXHeader();
            header.setName("header");
            this.setHeader(header);
        }
        header.setAttribute("changedate", date);
        this.writeXMLFormat(awriter);
        awriter.close();
        out.close();
        if (projectFile.exists()) {
            projectFile.delete();
        }
        if (!tempFile.renameTo(projectFile)) {
            throw new IOException();
        }
        this.saved = true;
    }
}

