/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import translator.AppPreferences;
import translator.MainView;
import translator.XMLElement;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.ui.GridPanel;

public class TMXEditor
extends JDialog
implements ActionListener {
    private JMenuBar menuBar;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private XMLElement header;
    private LinkedHashMap attr;
    public boolean cancelled = false;
    private TMX tmx;

    public TMXEditor(MainView jowner, Memory memory, String title) {
        super(jowner, title, true);
        this.setResizable(false);
        this.tmx = memory.getTMX();
        this.header = this.tmx.getHeader();
        boolean editmode = memory.getEditMode();
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("TMX");
        fileMenu.setMnemonic(77);
        this.tmx.getView().getMenu().showTMXMenu(this.tmx, fileMenu);
        this.menuBar.add(fileMenu);
        this.jPanel1 = new GridPanel();
        this.jPanel1.setLayout(new GridLayout(0, 2, 5, 5));
        this.jPanel1.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        JPanel con = (JPanel)this.getContentPane();
        con.add((Component)this.jPanel1, "Center");
        this.attr = this.header.getAttributes();
        if (this.attr != null) {
            Set keys = this.attr.keySet();
            for (String name : keys) {
                String value = (String)this.attr.get(name);
                String display = name.substring(0, 1).toUpperCase() + name.substring(1) + ":";
                JLabel label = new JLabel(display);
                label.setName(name);
                label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
                JTextField field = new JTextField(value);
                field.setCaretPosition(0);
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setFont(field.getFont().deriveFont(1));
                field.setPreferredSize(new Dimension(200, field.getPreferredSize().height));
                this.jPanel1.add(label);
                this.jPanel1.add(field);
            }
        }
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(new FlowLayout(2));
        this.jPanel3.setBorder(new EmptyBorder(new Insets(0, 10, 5, 10)));
        con.add((Component)this.jPanel3, "South");
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton2 = new JButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SWITCH")){

            @Override
            public void actionPerformed(ActionEvent a) {
                Memory tm = TMXEditor.this.tmx.getView().getMemory();
                TMXEditor.this.closeDialog();
                if (tm != null) {
                    tm.changeLanguagePair();
                }
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jPanel3.add(this.jButton3);
        this.jPanel3.add(this.jButton2);
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXEditor.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXEditor.this.jButton2.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TMXEditor.this.cancelled = true;
                TMXEditor.this.closeDialog();
            }
        });
        this.pack();
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            Component[] comps = this.jPanel1.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                JComponent field;
                String type = null;
                String value = null;
                if (comps[i] instanceof JLabel) {
                    JLabel lab = (JLabel)comps[i];
                    type = lab.getName();
                    ++i;
                } else if (comps[i] instanceof JButton) {
                    JButton but = (JButton)comps[i];
                    type = but.getName();
                    ++i;
                }
                if (comps[i] instanceof JTextField) {
                    field = (JTextField)comps[i];
                    value = ((JTextComponent)field).getText();
                } else if (comps[i] instanceof JComboBox) {
                    field = (JComboBox)comps[i];
                    value = (String)((JComboBox)field).getSelectedItem();
                }
                if (type == null || value == null) continue;
                this.header.setAttribute(type, value);
            }
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            this.cancelled = true;
            this.closeDialog();
        }
    }
}

