/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.util.Collection;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXBody;
import translator.tmx.TMXHandler;
import translator.tmx.TMXHeader;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitMap;
import translator.tmx.TMXUnitVariant;

public class TMXFilterHandler
extends TMXHandler {
    private Map properties;
    private String regularExp;
    private String regularExpNote;
    private boolean langFilter;
    private boolean identicalFilter;
    private boolean emptySegmentFilter;
    private boolean internalTagsFilter;
    private boolean foreignCodesFilter;
    private String tagsRegExp;
    private boolean readonly;
    private TMX tmx;
    private TMXReadOnlyUnitMap map;
    private boolean load = true;
    private boolean caseMatch;

    TMXFilterHandler(Memory memory) {
        super(memory);
        this.caseMatch = memory.getCaseMatch();
    }

    void setPoperties(Map p) {
        this.properties = p;
        this.load = false;
    }

    void setRegularExpressionNote(String reg) {
        this.regularExpNote = reg;
        this.load = false;
    }

    void setRegularExpression(String reg) {
        this.regularExp = reg;
        this.load = false;
    }

    void setLangFilter(boolean filter) {
        this.langFilter = filter;
    }

    void setIdenticalFilter(boolean filter) {
        this.identicalFilter = filter;
    }

    void setEmptySegmentFilter(boolean filter) {
        this.emptySegmentFilter = filter;
    }

    void setInternalTagsFilter(boolean filter) {
        this.internalTagsFilter = filter;
        this.tagsRegExp = "<.+?[0-9]+[/]*>";
    }

    void setForeignCodesFilter(boolean filter) {
        this.foreignCodesFilter = filter;
    }

    void setReadOnly(boolean filter) {
        this.readonly = filter;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        DefaultXMLElement xml;
        if (qName.equals("tuv")) {
            xml = new TMXUnitVariant();
        } else if (qName.equals("tu")) {
            xml = new TMXUnit(this.tmx.getID());
        } else if (qName.equals("tmx")) {
            if (this.project != null) {
                this.tmx = new TMX();
                this.project.setTMX(this.tmx);
            } else {
                this.tmx = this.memory.getTMX();
                if (this.tmx == null) {
                    this.tmx = new TMX();
                }
            }
            xml = this.tmx;
        } else if (qName.equals("header")) {
            TMXHeader tmh = new TMXHeader();
            xml = tmh;
        } else if (qName.equals("body")) {
            TMXBody tmb = this.tmx.getBody();
            if (tmb == null) {
                int cap = AppPreferences.initialCapacity;
                if (this.tmx.capacity != -1) {
                    cap = this.tmx.capacity;
                }
                if (!this.readonly) {
                    tmb = new TMXBody(1, cap);
                    TMXUnitMap map = new TMXUnitMap(cap);
                    map.setProjectID(this.tmx.getID());
                    tmb.setTUMap(map);
                    this.tmx.setTUMap(map);
                } else {
                    tmb = new TMXBody(1, 1);
                    this.map = new TMXReadOnlyUnitMap(cap);
                    tmb.setTUMap(this.map);
                    this.tmx.setTUMap(this.map);
                }
                this.tmx.setBody(tmb);
                this.memory.setTMX(this.tmx);
            } else if (this.readonly) {
                this.map = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
            }
            xml = tmb;
        } else {
            xml = new DefaultXMLElement(attr.getLength(), 1);
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            String v;
            String t;
            String s;
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
            if (!(xml instanceof TMXUnit) || this.properties == null || (s = (String)this.properties.get(t = attr.getQName(i).toLowerCase())) == null || (v = attr.getValue(i)) == null || !s.equals(v.toLowerCase())) continue;
            this.load = true;
            break;
        }
        xml.setName(qName);
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            pxml.addChild(this.contents.toString());
        }
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            String s;
            String type;
            String n;
            String c = this.contents.toString();
            if (this.internalTagsFilter) {
                this.load = true;
                n = childXml.getName();
                if (n.equals("seg")) {
                    c = c.replaceAll(this.tagsRegExp, "");
                }
            }
            if (this.foreignCodesFilter) {
                this.load = true;
                n = childXml.getName();
                if (n.equals("seg")) {
                    c = this.cleanForeignCodes(c);
                }
            }
            childXml.addChild(c);
            if (this.regularExp != null && (n = childXml.getName()).equals("seg") && c.matches(this.regularExp)) {
                this.load = true;
            }
            if (this.regularExpNote != null && (n = childXml.getName()).equals("note") && c.matches(this.regularExpNote)) {
                this.load = true;
            }
            if (this.properties != null && !this.load && (n = childXml.getName()).equals("prop") && (type = childXml.getAttribute("type")) != null && (s = (String)this.properties.get(type.toLowerCase())) != null && s.equals(c.toLowerCase())) {
                this.load = true;
            }
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            if (this.langFilter && childXml instanceof TMXUnitVariant) {
                TMXUnitVariant tuv = (TMXUnitVariant)childXml;
                String lang = tuv.getLanguage();
                if (lang != null && (lang.equals(this.slang) || lang.equals(this.tlang))) {
                    xml.addChild(childXml);
                }
            } else {
                String name = childXml.getName();
                if (name.equals("tu")) {
                    String source = null;
                    String target = null;
                    TMXUnit tu = (TMXUnit)childXml;
                    TMXUnitVariant tuvs = tu.getTUV(this.slang);
                    TMXUnitVariant tuvt = tu.getTUV(this.tlang);
                    if (this.identicalFilter || this.emptySegmentFilter) {
                        if (tuvs != null) {
                            source = tuvs.getSegmentText();
                        }
                        if (tuvt != null) {
                            target = tuvt.getSegmentText();
                        }
                        if (source != null && target != null) {
                            Collection col = tu.getTMXUnitVariants();
                            if (this.identicalFilter) {
                                if (this.caseMatch) {
                                    if (source.equals(target)) {
                                        tu.removeChild(tuvs);
                                        tu.removeChild(tuvt);
                                        col.remove(tuvs);
                                        col.remove(tuvt);
                                    }
                                } else if (source.equalsIgnoreCase(target)) {
                                    tu.removeChild(tuvs);
                                    tu.removeChild(tuvt);
                                    col.remove(tuvs);
                                    col.remove(tuvt);
                                }
                            }
                            if (this.emptySegmentFilter && (source.trim().length() == 0 || target.trim().length() == 0)) {
                                tu.removeChild(tuvs);
                                tu.removeChild(tuvt);
                                col.remove(tuvs);
                                col.remove(tuvt);
                            }
                            this.load = col.size() != 0;
                        } else {
                            this.load = true;
                        }
                    }
                    if (this.load) {
                        if (this.memory.hasTagPostions() && childXml.getName().equals("prop") && xml instanceof TMXUnit) {
                            this.setTagPostions(xml, childXml);
                        }
                        if (!this.readonly) {
                            xml.addChild(childXml);
                        } else {
                            TMXReadOnlyUnit turo = new TMXReadOnlyUnit();
                            if (source != null) {
                                turo.setSegment(this.slang, source);
                            } else if (tuvs != null) {
                                source = tuvs.getSegmentText();
                                turo.setSegment(this.slang, source);
                            }
                            if (target != null) {
                                turo.setSegment(this.tlang, target);
                            } else if (tuvt != null) {
                                target = tuvt.getSegmentText();
                                turo.setSegment(this.tlang, target);
                            }
                            this.map.load(turo);
                        }
                        this.load = false;
                    }
                } else if (this.internalTagsFilter) {
                    String nn = xml.getName();
                    if (!nn.equals("seg")) {
                        xml.addChild(childXml);
                    }
                } else {
                    xml.addChild(childXml);
                }
            }
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    private String cleanForeignCodes(String s) {
        s = s.replaceAll("\\{.+?\\}", "");
        s = s.replace("\\\\", "\\");
        s = s.replace("\\rquote ", "\u2018");
        s = s.replace("\\lquote ", "\u2019");
        s = s.replace("\\endash ", "-");
        s = s.replace("\\emdash ", "-");
        s = s.replace(" (r)", "(r)");
        s = s.replace("\\-", "");
        s = s.replace("\\line ", " - ");
        s = s.replace("\\~", "\u00a0");
        s = s.replace("\\tab", "\t");
        s = s.replace(" (tm)", "(tm)");
        s = s.replace("\\bullet", "\u2022");
        return s;
    }
}

